/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01e.services.helpers;

import com.ejie.r01e.gestorejes.dbhelppers.dao.R01EDAOLabelsExportLoader;
import com.ejie.r01e.loaddownloadlabels.datos.R01EExcelSheet;
import com.ejie.r01e.loaddownloadlabels.datos.R01ELabelExcelUtils;
import com.ejie.r01e.loaddownloadlabels.util.R01EExcelReader;
import com.ejie.r01e.loaddownloadlabels.util.R01EExcelWriter;
import com.ejie.r01e.services.R01ELabelsManager;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MCatalogElementNotFoundException;
import com.ejie.r01m.exceptions.R01MCatalogException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.cataloguing.structures.R01MBag;
import com.ejie.r01m.objects.cataloguing.structures.R01MLabel;
import com.ejie.r01m.services.R01MClientFactory;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class R01EImportExportHelper
implements Serializable {
    private static final long serialVersionUID = -3692604043751665110L;
    private String strPath;
    private String strBag;
    private R01EExcelReader reader;
    private R01EExcelWriter writer;
    private R01MUserContext _userCtx = null;

    public String getPath() {
        return this.strPath;
    }

    public String getBag() {
        return this.strBag;
    }

    public R01EExcelReader getReader() {
        return this.reader;
    }

    public R01EExcelWriter getWriter() {
        return this.writer;
    }

    public void setPath(String pStrPath) {
        this.strPath = pStrPath;
    }

    public void setBag(String pStrBolsa) {
        this.strBag = pStrBolsa;
    }

    public void setReader(R01EExcelReader pLector) {
        this.reader = pLector;
    }

    public void setWriter(R01EExcelWriter pEscritor) {
        this.writer = pEscritor;
    }

    public R01EImportExportHelper(R01MUserContext userCtx) {
        this._userCtx = userCtx;
    }

    public R01EImportExportHelper(R01MUserContext userCtx, String pStrPath) {
        this(userCtx);
        this.strPath = pStrPath;
        this.initLog(pStrPath);
        this._userCtx = userCtx;
    }

    public static String getSystemDateHour() {
        StringBuffer fmtd = new StringBuffer("");
        try {
            Calendar raw = Calendar.getInstance();
            String dia = Integer.toString(raw.get(5));
            String mes = Integer.toString(raw.get(2) + 1);
            String anio = Integer.toString(raw.get(1));
            String hora = Integer.toString(raw.get(11));
            String minuto = Integer.toString(raw.get(12));
            String segundo = Integer.toString(raw.get(13));
            String milisegundo = Long.toString(raw.getTime().getTime() % 1000L);
            if (dia.length() == 1) {
                dia = 0 + dia;
            }
            if (mes.length() == 1) {
                mes = 0 + mes;
            }
            if (hora.length() == 1) {
                hora = 0 + hora;
            }
            if (minuto.length() == 1) {
                minuto = 0 + minuto;
            }
            if (segundo.length() == 1) {
                segundo = 0 + segundo;
            }
            if (milisegundo.length() == 1) {
                milisegundo = milisegundo + 0;
            }
            if (milisegundo.length() == 2) {
                milisegundo = milisegundo + 0;
            }
            fmtd.append("[");
            fmtd.append(dia);
            fmtd.append("-");
            fmtd.append(mes);
            fmtd.append("-");
            fmtd.append(anio);
            fmtd.append(" ");
            fmtd.append(hora);
            fmtd.append(":");
            fmtd.append(minuto);
            fmtd.append(":");
            fmtd.append(segundo);
            fmtd.append(":");
            fmtd.append(milisegundo);
            fmtd.append("] ");
        }
        catch (Throwable e) {
            System.err.println("Error al recuperar la fecha-hora del sistema");
            e.printStackTrace(System.err);
        }
        return fmtd.toString();
    }

    public void treatDates() {
        String strGUID_03anterior = "";
        String strGUID_03 = "";
        String[] fila = new String[6];
        Iterator i = this.getWriter().getBook().getSheet().getContent().iterator();
        while (i.hasNext()) {
            try {
                fila = (String[])i.next();
                strGUID_03 = R01ELabelExcelUtils.getGUID_03((String[])fila);
                if (strGUID_03.equals(strGUID_03anterior)) {
                    fila = R01ELabelExcelUtils.deleteLabelData((String[])fila);
                }
                strGUID_03anterior = strGUID_03;
            }
            catch (R01MCatalogException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void unloadDate(String pStrBolsa, OutputStream pResponse) throws Exception {
        this.setWriter(new R01EExcelWriter(pResponse));
        this.unloadDate(pStrBolsa);
    }

    public void unloadDate(String bagOid) throws Exception {
        R01EDAOLabelsExportLoader exportLoader = new R01EDAOLabelsExportLoader();
        if (this.getWriter() == null) {
            this.setWriter(new R01EExcelWriter(this.getPath(), exportLoader.exportDatas(bagOid)));
        } else {
            this.getWriter().getBook().getSheets().put("Etiquetas", exportLoader.exportDatas(bagOid));
        }
        this.treatDates();
        String strNombreHoja = "Etiquetas";
        if (bagOid != null) {
            bagOid = bagOid.length() > 20 ? "(" + bagOid.substring(0, 20) + ")" : "(" + bagOid.substring(0, bagOid.length()) + ")";
        }
        this.getWriter().writeSheet(strNombreHoja);
    }

    public Map loadDates(StringBuffer errores, String lang) throws Throwable {
        this.setReader(new R01EExcelReader(this.getPath()));
        this.readExcel();
        return this.outDates(errores, lang);
    }

    private String readExcel() {
        this.getReader().readAllSheets();
        return "OK";
    }

    private void initLog(String pStrPath) {
    }

    private Map outDates(StringBuffer errores, String lang) throws Exception {
        HashMap<String, String> modificatedLabels = new HashMap<String, String>();
        ArrayList<String[]> labelReg = null;
        ArrayList labels = new ArrayList();
        Enumeration e = this.getReader().getBook().getSheets().elements();
        while (e.hasMoreElements()) {
            Iterator i = ((R01EExcelSheet)e.nextElement()).getContent().iterator();
            String oidLabel = null;
            while (i.hasNext()) {
                String[] registro = (String[])i.next();
                try {
                    if (StringUtils.isEmptyString((String)R01ELabelExcelUtils.getGUID_03((String[])registro)) && StringUtils.isEmptyString((String)R01ELabelExcelUtils.getDESCRIPCION_03((String[])registro)) && StringUtils.isEmptyString((String)R01ELabelExcelUtils.getIDIOMA_06((String[])registro)) && StringUtils.isEmptyString((String)R01ELabelExcelUtils.getTIPO_06((String[])registro)) && StringUtils.isEmptyString((String)R01ELabelExcelUtils.getVALOR_06((String[])registro)) && StringUtils.isEmptyString((String)R01ELabelExcelUtils.getOID_EXTERNO_03((String[])registro))) continue;
                    if (StringUtils.isEmptyString((String)R01ELabelExcelUtils.getIDIOMA_06((String[])registro)) || StringUtils.isEmptyString((String)R01ELabelExcelUtils.getTIPO_06((String[])registro)) || StringUtils.isEmptyString((String)R01ELabelExcelUtils.getVALOR_06((String[])registro))) {
                        throw new R01MCatalogException();
                    }
                    if (!StringUtils.isEmptyString((String)R01ELabelExcelUtils.getGUID_03((String[])registro))) {
                        if (labelReg != null && labelReg.size() > 0) {
                            labels.add(labelReg);
                        }
                        labelReg = new ArrayList<String[]>();
                        labelReg.add(registro);
                        oidLabel = R01ELabelExcelUtils.getGUID_03((String[])registro);
                    } else {
                        labelReg.add(registro);
                    }
                    if (StringUtils.isEmptyString((String)R01ELabelExcelUtils.getIDIOMA_06((String[])registro)) || StringUtils.isEmptyString((String)R01ELabelExcelUtils.getTIPO_06((String[])registro)) || !R01ELabelExcelUtils.getIDIOMA_06((String[])registro).equalsIgnoreCase(lang) || R01ELabelExcelUtils.getTIPO_06((String[])registro).charAt(0) != 'S' || StringUtils.isEmptyString((String)R01ELabelExcelUtils.getVALOR_06((String[])registro)) || oidLabel.equalsIgnoreCase("NEW")) continue;
                    modificatedLabels.put(oidLabel, R01ELabelExcelUtils.getVALOR_06((String[])registro));
                }
                catch (R01MCatalogException ex) {
                    errores.append(R01ELabelExcelUtils.composeDebugInfo((String[])registro));
                }
            }
            if (labelReg == null) continue;
            labels.add(labelReg);
        }
        for (int i = 0; labels != null && i < labels.size(); ++i) {
            List label = (List)labels.get(i);
            String[] labelRegistro = (String[])label.get(0);
            if (R01ELabelExcelUtils.getGUID_03((String[])labelRegistro).toUpperCase().equalsIgnoreCase("NEW")) {
                try {
                    this.createLabel(label, errores);
                    continue;
                }
                catch (R01MCatalogElementNotFoundException elementNotFound) {
                    throw new Exception("La bolsa de catalogacion no se encuentra (" + this.getBag() + "), revise la hoja excel");
                }
                catch (R01MCatalogException catalogationException) {
                    throw new Exception("Error en la insercion de la etiqueta alguna etiqueta, revise la hoja excel");
                }
            }
            try {
                this.saveLabel(label, errores);
                continue;
            }
            catch (R01MCatalogElementNotFoundException elementNotFoundExc) {
                throw new Exception("Una de las etiquetas que se intentan modificar no existe (labelOid =" + R01ELabelExcelUtils.getGUID_03((String[])labelRegistro) + "), revise la hoja EXCEL");
            }
            catch (R01MCatalogException catalogExc) {
                throw new Exception("Error en la modificaci\u00f3n de la etiqueta: " + R01ELabelExcelUtils.getGUID_03((String[])labelRegistro));
            }
        }
        return modificatedLabels;
    }

    private void createLabel(List labelList, StringBuffer errores) throws R01MCatalogException, R01MCatalogElementNotFoundException, R01MSecurityException {
        R01MLabel label = R01ELabelExcelUtils.getLabel((R01MUserContext)this._userCtx, (List)labelList, (StringBuffer)errores);
        R01MBag bag = R01MClientFactory.getCatalogAPI((R01MUserContext)this._userCtx).loadBag(this.getBag());
        label.setBagId(bag.getBagId());
        R01ELabelsManager labelManager = new R01ELabelsManager();
        labelManager.doSaveLabel(this._userCtx, this.getBag(), label);
    }

    private void saveLabel(List labelList, StringBuffer errores) throws R01MCatalogException, R01MSecurityException, R01MCatalogElementNotFoundException {
        R01MLabel label = R01ELabelExcelUtils.getLabel((R01MUserContext)this._userCtx, (List)labelList, (StringBuffer)errores);
        R01MBag bag = null;
        try {
            bag = R01MClientFactory.getCatalogAPI((R01MUserContext)this._userCtx).loadBagWithLabel(label.getOid());
        }
        catch (R01MCatalogException ex) {
            errores.append(label.composeDebugInfo());
            return;
        }
        catch (R01MCatalogElementNotFoundException ex) {
            errores.append(label.composeDebugInfo());
            return;
        }
        if (!bag.getBagGUID().equals(this.getBag())) {
            errores.append(label.composeDebugInfo());
            return;
        }
        label.setBagId(bag.getBagId());
        R01ELabelsManager labelManager = new R01ELabelsManager();
        labelManager.doSaveLabel(this._userCtx, this.getBag(), label);
    }
}

