/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01e.services;

import com.ejie.r01e.catalog.ejb.bags.R01EBagEntityCMPUtil;
import com.ejie.r01e.catalog.ejb.elementnames.R01EElementNameEntityCMPLocal;
import com.ejie.r01e.catalog.ejb.elementnames.R01EElementNameEntityCMPUtil;
import com.ejie.r01e.catalog.ejb.labels.R01ELabelEntityCMPLocal;
import com.ejie.r01e.catalog.ejb.labels.R01ELabelEntityCMPUtil;
import com.ejie.r01e.catalog.ejb.relations.R01ERelationEntityCMPLocal;
import com.ejie.r01e.catalog.ejb.relations.R01ERelationEntityCMPUtil;
import com.ejie.r01e.catalog.ejb.structuresdefinitions.R01EStructureDefinitionEntityCMPLocal;
import com.ejie.r01e.catalog.ejb.structuresdefinitions.R01EStructureDefinitionEntityCMPUtil;
import com.ejie.r01e.catalog.ejb.structuresdefinitions.R01EStructureDefinitionEntityCMPValue;
import com.ejie.r01e.gestorejes.dbhelppers.dao.R01EDAOCoreModelObjsLoader;
import com.ejie.r01e.services.R01EBaseCatalogManager;
import com.ejie.r01e.services.R01ELabelsManager;
import com.ejie.r01e.structures.exceptions.R01ECatalogException;
import com.ejie.r01e.structures.exceptions.R01EElementNotFoundException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StateMap;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MCatalogElementNotFoundException;
import com.ejie.r01m.exceptions.R01MCatalogException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.cataloguing.R01MStructureCatalog;
import com.ejie.r01m.objects.cataloguing.structures.R01MLabel;
import com.ejie.r01m.objects.cataloguing.structures.R01MStructure;
import com.ejie.r01m.objects.cataloguing.structures.R01MStructureDefinition;
import com.ejie.r01m.objects.cataloguing.structures.R01MStructureItem;
import com.ejie.r01m.services.bzd.R01MCatalogStructuresBzd;
import com.ejie.r01p.utils.R01PProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class R01EStructuresManager
extends R01EBaseCatalogManager
implements R01MCatalogStructuresBzd {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01e.manager").intValue() != Level.OFF.intValue();
    private transient R01MUserContext _userCtx = null;

    public R01EStructuresManager() {
    }

    public R01EStructuresManager(R01MUserContext userCtx) {
        this._userCtx = userCtx;
    }

    public R01MStructure doLoadStructure(String structureOid) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        return this.doLoadStructure(structureOid, null, 0, -1);
    }

    public R01MStructure doLoadStructure(String structureOid, String languageCode, int relationParentId, int numRolesToReturn) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        R01MStructure structure;
        String opDesc = "Carga de la estructura con el identificador " + structureOid;
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader structureLoader = new R01EDAOCoreModelObjsLoader();
        try {
            structure = structureLoader.executeLoadStructure(structureOid, languageCode, relationParentId, numRolesToReturn);
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException(opDesc + ".Error:" + ex.getMessage());
        }
        catch (R01EElementNotFoundException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogElementNotFoundException(opDesc + ".Error:" + ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
        return structure;
    }

    public List doLoadStructuresWithLabel(String labelOid) throws R01MCatalogException {
        List structuresGuids;
        String opDesc = "Carga de los identificadores de las estructuras que contienen la etiqueta cuyo identificador es " + labelOid;
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader structureLoader = new R01EDAOCoreModelObjsLoader();
        try {
            structuresGuids = structureLoader.executeLoadStructuresWithLabel(labelOid);
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException(opDesc + ".Error:" + ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
        return structuresGuids;
    }

    public R01MStructureDefinition doLoadStructureDefinition(String structureOid) throws R01MCatalogException, R01MCatalogElementNotFoundException {
        R01MStructureDefinition structureDef;
        String opDesc = "Carga de la definicion de la estructura con el identificador " + structureOid;
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader structureDefLoader = new R01EDAOCoreModelObjsLoader();
        try {
            structureDef = structureDefLoader.executeLoadStructureDefinition(structureOid);
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException(opDesc + ".Error:" + ex.getMessage());
        }
        catch (R01EElementNotFoundException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogElementNotFoundException(opDesc + ".Error:" + ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
        return structureDef;
    }

    public List doLoadStructureDefinitions(Collection bagOids, char structureType, char structureStatus) throws R01MCatalogException {
        List structureDefs;
        String opDesc = "Carga de las definiciones de las estructuras con el tipo " + structureType + " y con el estado " + structureStatus;
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        if ((bagOids == null || bagOids.isEmpty()) && structureType == '\u0000' && structureStatus == '\u0000') {
            return null;
        }
        R01EDAOCoreModelObjsLoader structureDefLoader = new R01EDAOCoreModelObjsLoader();
        try {
            structureDefs = structureDefLoader.executeLoadStructureDefinitions(bagOids, structureType, structureStatus);
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException(opDesc + ".Error:" + ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
        return structureDefs;
    }

    public List doLoadStructuresInBag(String bagOid, char type, char status, String languageCode) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        return this.doLoadStructuresInBag(bagOid, type, status, languageCode, -1);
    }

    public List doLoadStructuresInBag(String bagOid, char type, char status, String languageCode, int maxRole) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        List structures;
        StringBuffer opDesc = new StringBuffer(100);
        opDesc.append("Carga de las estructuras de la bolsa ");
        opDesc.append(bagOid);
        opDesc.append(" con el tipo ");
        opDesc.append(type);
        opDesc.append(" y con el estado ");
        opDesc.append(status);
        opDesc.append(" para el idioma ");
        opDesc.append(languageCode);
        opDesc.append(" hasta el nivel ");
        opDesc.append(maxRole);
        opDesc.append('.');
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader structureLoader = new R01EDAOCoreModelObjsLoader();
        try {
            structures = structureLoader.executeLoadStructuresInBag(bagOid, type, status, languageCode, maxRole);
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException(opDesc + ".Error:" + ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
        return structures;
    }

    public int doSaveStructure(R01MUserContext userCtx, R01MStructure structure, String bagOid) throws R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogException {
        R01EStructureDefinitionEntityCMPLocal structureCMP;
        if (!super.validateContext(userCtx, bagOid)) {
            throw new R01MSecurityException("El usuario no tiene acceso a la bolsa " + bagOid);
        }
        String opDesc = "Creando/actualizando la estructura con el identificador " + structure.getSDefinition().getStructureGUID();
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        try {
            structureCMP = R01EStructureDefinitionEntityCMPUtil.getLocalHome().findByStructureGUID(structure.getSDefinition().getStructureGUID());
        }
        catch (FinderException fndExc) {
            int structureId = this._execCreateStructure(structure);
            if (DEBUG) {
                R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
            }
            return structureId;
        }
        catch (NamingException namExc) {
            R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de estructuras.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se encuentra el CMP de estructuras.Error:" + namExc.getMessage());
        }
        this._execUpdateStructure(structure.getSDefinition(), structureCMP);
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
        return structure.getSDefinition().getStructureId();
    }

    public void doRemoveStructure(R01MUserContext userCtx, String bagOid, String structureOid) throws R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogException {
        Collection relationsCollection;
        Collection namesCollection;
        if (!super.validateContext(userCtx, bagOid)) {
            throw new R01MSecurityException("El usuario no tiene acceso a la bolsa de la estructura " + structureOid);
        }
        String opDesc = "Borrando la estructura con el identificador " + structureOid + " de la bolsa " + structureOid;
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        try {
            namesCollection = R01EElementNameEntityCMPUtil.getLocalHome().findByElementGUID(structureOid);
        }
        catch (FinderException finderEx) {
            R01FLog.to((String)"r01e.manager").severe("No existe t\u00e9rmino para la estructura " + structureOid + ".Error:" + finderEx.getMessage());
            finderEx.printStackTrace(System.out);
            throw new R01MCatalogException("No existe t\u00e9rmino para la estructura " + structureOid + ".Error:" + finderEx.getMessage());
        }
        catch (NamingException namExc) {
            R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de t\u00e9rminos.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se encuentra el CMP de t\u00e9rminos.Error:" + namExc.getMessage());
        }
        if (namesCollection != null && !namesCollection.isEmpty()) {
            if (DEBUG) {
                R01FLog.to((String)"r01e.manager").info("Para cada nombre de la estructura " + structureOid + " se elimina el t\u00e9rmino.");
            }
            Iterator namesIterator = namesCollection.iterator();
            while (namesIterator.hasNext()) {
                try {
                    ((R01EElementNameEntityCMPLocal)namesIterator.next()).remove();
                }
                catch (EJBException ejbExc) {
                    R01FLog.to((String)"r01e.manager").severe("Error borrando el t\u00e9rmino para la estructura " + structureOid + ".Error:" + ejbExc.getMessage());
                    ejbExc.printStackTrace(System.out);
                    throw new R01MCatalogException("Error borrando el t\u00e9rmino para la estructura " + structureOid + ".Error:" + ejbExc.getMessage());
                }
                catch (RemoveException rmExc) {
                    R01FLog.to((String)"r01e.manager").severe("No se puede borrar el t\u00e9rmino para la estructura " + structureOid + ".Error:" + rmExc.getMessage());
                    rmExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No se puede borrar el t\u00e9rmino para la estructura " + structureOid + ".Error:" + rmExc.getMessage());
                }
            }
        } else if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("No existen t\u00e9rminos para la estructura " + structureOid);
        }
        try {
            relationsCollection = R01ERelationEntityCMPUtil.getLocalHome().findByStructureGUID(structureOid);
        }
        catch (FinderException finderEx) {
            R01FLog.to((String)"r01e.manager").severe("No existen relaciones para la estructura " + structureOid + ".Error:" + finderEx.getMessage());
            finderEx.printStackTrace(System.out);
            throw new R01MCatalogException("No existen relaciones para la estructura " + structureOid + ".Error:" + finderEx.getMessage());
        }
        catch (NamingException namExc) {
            R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de relaciones.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se encuentra el CMP de relaciones.Error:" + namExc.getMessage());
        }
        if (relationsCollection != null && !relationsCollection.isEmpty()) {
            if (DEBUG) {
                R01FLog.to((String)"r01e.manager").info("Borrando las relaciones de la estructura " + structureOid);
            }
            Iterator relationsIterator = relationsCollection.iterator();
            while (relationsIterator.hasNext()) {
                try {
                    ((R01ERelationEntityCMPLocal)relationsIterator.next()).remove();
                }
                catch (EJBException ejbExc) {
                    R01FLog.to((String)"r01e.manager").severe("Error borrando la relaci\u00f3n para la estructura " + structureOid + ".Error:" + ejbExc.getMessage());
                    ejbExc.printStackTrace(System.out);
                    throw new R01MCatalogException("Error borrando la relaci\u00f3n para la estructura " + structureOid + ".Error:" + ejbExc.getMessage());
                }
                catch (RemoveException rmExc) {
                    R01FLog.to((String)"r01e.manager").severe("No se puede borrar la relaci\u00f3n de la estructura " + structureOid + ".Error:" + rmExc.getMessage());
                    rmExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No se puede borrar la relaci\u00f3n de la estructura " + structureOid + ".Error:" + rmExc.getMessage());
                }
                if (!DEBUG) continue;
                R01FLog.to((String)"r01e.manager").info("Relacion de estructura eliminada: " + structureOid);
            }
        } else if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("No existen relaciones para la estructura " + structureOid);
        }
        try {
            R01EStructureDefinitionEntityCMPUtil.getLocalHome().findByStructureGUID(structureOid).remove();
        }
        catch (FinderException finderEx) {
            R01FLog.to((String)"r01e.manager").severe("No se encuentra la estructura " + structureOid + ".Error:" + finderEx.getMessage());
            finderEx.printStackTrace(System.out);
            throw new R01MCatalogException("No se encuentra la estructura " + structureOid + ".Error:" + finderEx.getMessage());
        }
        catch (NamingException namExc) {
            R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de estructuras.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se encuentra el CMP de estructuras.Error:" + namExc.getMessage());
        }
        catch (EJBException ejbExc) {
            R01FLog.to((String)"r01e.manager").severe("Error borrando la estructura " + structureOid + ".Error:" + ejbExc.getMessage());
            ejbExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error borrando la estructura " + structureOid + ".Error:" + ejbExc.getMessage());
        }
        catch (RemoveException rmExc) {
            R01FLog.to((String)"r01e.manager").severe("No se puede borrar la estructura " + structureOid + ".Error:" + rmExc.getMessage());
            rmExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se puede borrar la estructura " + structureOid + ".Error:" + rmExc.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
    }

    public void doMoveStructure(R01MUserContext userCtx, String structureGuid, String bagOid, String newBagOid) throws R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogException {
        int newBagId;
        if (!super.validateContext(userCtx, bagOid)) {
            throw new R01MSecurityException("El usuario no tiene acceso a la bolsa " + bagOid);
        }
        if (!super.validateContext(userCtx, newBagOid)) {
            throw new R01MSecurityException("El usuario no tiene acceso a la bolsa " + newBagOid);
        }
        String opDesc = "Mover la estructura " + structureGuid + " de la bolsa " + bagOid + " a la bolsa " + newBagOid;
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        try {
            newBagId = R01EBagEntityCMPUtil.getLocalHome().findByBagGUID(newBagOid).getBagId();
        }
        catch (FinderException findExc) {
            R01FLog.to((String)"r01e.manager").severe("La bolsa  " + newBagOid + " no existe.Error:" + findExc.getMessage());
            findExc.printStackTrace(System.out);
            throw new R01MCatalogElementNotFoundException("La bolsa  " + newBagOid + " no existe.Error:" + findExc.getMessage());
        }
        catch (NamingException namExc) {
            R01FLog.to((String)"r01e.manager").severe("Error al encontrar el CMP de bolsas.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error al encontrar el CMP de bolsas.Error:" + namExc.getMessage());
        }
        try {
            R01EStructureDefinitionEntityCMPUtil.getLocalHome().findByStructureGUID(structureGuid).setBagId(newBagId);
        }
        catch (FinderException findExc) {
            R01FLog.to((String)"r01e.manager").severe("No existe la estructura " + structureGuid + ".Error:" + findExc.getMessage());
            findExc.printStackTrace(System.out);
            throw new R01MCatalogElementNotFoundException("No existe la estructura " + structureGuid, (Exception)((Object)findExc));
        }
        catch (NamingException namExc) {
            R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de estructura.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error al encontrar el CMP estructura.Error:" + namExc.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
    }

    public List doLoadStructuresInGroup(String tagGroup) throws R01MCatalogException {
        List structures;
        String opDesc = "Carga de las estructuras pertenecientes al grupo " + tagGroup;
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader structureLoader = new R01EDAOCoreModelObjsLoader();
        try {
            structures = structureLoader.executeLoadStructuresInGroup(tagGroup);
        }
        catch (R01ECatalogException catExc) {
            catExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error en la carga de las estructuras de un grupo." + catExc.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
        return structures;
    }

    public List doValidateLabelsInOtherStructure(String structureGuid) throws R01MCatalogException {
        List labels;
        String opDesc = "Validando si la estructura " + structureGuid + " tiene todas sus etiquetas en otra estructura como eje de catalogaci\u00f3n.";
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        ArrayList<R01MLabel> labelsError = null;
        R01EDAOCoreModelObjsLoader loader = new R01EDAOCoreModelObjsLoader();
        try {
            labels = loader.executeLoadLabelsInStructure(structureGuid);
        }
        catch (R01ECatalogException catExc) {
            R01FLog.to((String)"r01e.manager").severe("Error al cargar las etiquetas de la estructura " + structureGuid + ".Error:" + catExc.getMessage());
            catExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error al cargar las etiquetas de la estructura " + structureGuid + ".Error:" + catExc.getMessage());
        }
        if (labels != null && !labels.isEmpty()) {
            for (R01MLabel label : labels) {
                boolean exist;
                try {
                    exist = loader.executeExistLabelInOtherStructure(structureGuid, label.getLabelId());
                }
                catch (R01ECatalogException catExc) {
                    R01FLog.to((String)"r01e.manager").severe("No se puede validar si la etiqueta " + label.getLabelId() + " pertenece a otra estructura distinta de " + structureGuid + ".Error:" + catExc.getMessage());
                    catExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No se puede validar si la etiqueta " + label.getLabelId() + " pertenece a otra estructura distinta de " + structureGuid + ".Error:" + catExc.getMessage());
                }
                if (exist) continue;
                if (labelsError == null) {
                    labelsError = new ArrayList<R01MLabel>();
                }
                labelsError.add(label);
            }
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
        return labelsError;
    }

    public List doGetLabelsInItsStructures(String[] labelOids) throws R01MCatalogException, R01MCatalogElementNotFoundException {
        String opDesc = "Devolver las rutas completas de las ramas en las que aparece una etiqueta de catalogacion.";
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        ArrayList<R01ELabelEntityCMPLocal> labels = new ArrayList<R01ELabelEntityCMPLocal>();
        if (labelOids != null && labelOids.length > 0) {
            for (int i = 0; i < labelOids.length; ++i) {
                R01ELabelEntityCMPLocal currLabelCMP;
                try {
                    currLabelCMP = R01ELabelEntityCMPUtil.getLocalHome().findByLabelGUID(labelOids[i]);
                }
                catch (FinderException fndExc) {
                    R01FLog.to((String)"r01e.manager").info("No existe la etiqueta " + labelOids[i] + ".Error:" + fndExc.getMessage());
                    fndExc.printStackTrace(System.out);
                    throw new R01MCatalogElementNotFoundException("No existe la etiqueta " + labelOids[i] + ".Error:" + fndExc.getMessage());
                }
                catch (NamingException namExc) {
                    R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de etiquetas.Error:" + namExc.getMessage());
                    namExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No se encuentra el CMP de etiquetas.Error:" + namExc.getMessage());
                }
                if (currLabelCMP == null) continue;
                labels.add(currLabelCMP);
            }
        }
        List mountLabels = this._mountLabelsBranches(labels, true);
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
        return mountLabels;
    }

    public List doLoadBranches(List branchCriteria) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        String opDesc = "Cargando una coleccion de ramas jerarquicas.";
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        ArrayList<List> vStructures = new ArrayList<List>();
        if (branchCriteria != null && !branchCriteria.isEmpty()) {
            for (int i = 0; i < branchCriteria.size(); ++i) {
                R01EStructureDefinitionEntityCMPLocal structureCMPLocal;
                int labelId;
                String structureGuid = (String)((List)branchCriteria.get(i)).get(0);
                String labelGuid = (String)((List)branchCriteria.get(i)).get(1);
                try {
                    labelId = R01ELabelEntityCMPUtil.getLocalHome().findByLabelGUID(labelGuid).getLabelId();
                }
                catch (FinderException fndExc) {
                    R01FLog.to((String)"r01e.manager").info("No existe la etiqueta " + labelGuid + ".Error:" + fndExc.getMessage());
                    fndExc.printStackTrace(System.out);
                    throw new R01MCatalogElementNotFoundException("No existe la etiqueta " + labelGuid + ".Error:" + fndExc.getMessage());
                }
                catch (NamingException namExc) {
                    R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de etiquetas.Error:" + namExc.getMessage());
                    namExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No se encuentra el CMP de etiquetas.Error:" + namExc.getMessage());
                }
                try {
                    structureCMPLocal = R01EStructureDefinitionEntityCMPUtil.getLocalHome().findByStructureGUID(structureGuid);
                }
                catch (FinderException fndExc) {
                    R01FLog.to((String)"r01e.manager").info("No existe la estructura " + structureGuid + ".Error:" + fndExc.getMessage());
                    fndExc.printStackTrace(System.out);
                    throw new R01MCatalogElementNotFoundException("No existe la estructura " + structureGuid + ".Error:" + fndExc.getMessage());
                }
                catch (NamingException namExc) {
                    R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de estructuras.Error:" + namExc.getMessage());
                    namExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No se encuentra el CMP de estructuras.Error:" + namExc.getMessage());
                }
                R01MStructureDefinition structDef = this._mountStructureDefinition(structureCMPLocal);
                List vBranch = this._mountBranch(labelId, structDef);
                vStructures.add(vBranch);
            }
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
        return vStructures;
    }

    public List<R01MStructureCatalog> doGetStructuresConfig(String propXPath) {
        Node data;
        ArrayList<R01MStructureCatalog> structuresConfig = new ArrayList<R01MStructureCatalog>();
        NodeIterator nodes = R01PProperties.getInstance().getPropertyNodeIterator(propXPath);
        if (nodes != null && (data = nodes.nextNode()) != null) {
            while (data != null) {
                for (int i = 0; i < data.getChildNodes().getLength(); ++i) {
                    String orgStructureAxisCode = "";
                    String orgStructureRole = "";
                    String orgStructureLabelOid = "";
                    Node structureNode = data.getChildNodes().item(i);
                    for (int j = 0; j < structureNode.getChildNodes().getLength(); ++j) {
                        Node structure = structureNode.getChildNodes().item(j);
                        if (structure.getNodeName().equals("structureOid")) {
                            orgStructureAxisCode = structure.getFirstChild().getNodeValue();
                        }
                        if (structure.getNodeName().equals("labelOid")) {
                            String string = orgStructureLabelOid = structure.getFirstChild() != null ? structure.getFirstChild().getNodeValue() : null;
                        }
                        if (!structure.getNodeName().equals("level")) continue;
                        orgStructureRole = structure.getFirstChild().getNodeValue();
                    }
                    if (orgStructureAxisCode.equals("") || orgStructureRole.equals("")) continue;
                    R01MStructureCatalog structureConfig = new R01MStructureCatalog();
                    structureConfig.setStructureOid(orgStructureAxisCode);
                    structureConfig.setOid(orgStructureLabelOid);
                    structureConfig.setRole(orgStructureRole);
                    structuresConfig.add(structureConfig);
                }
                data = nodes.nextNode();
            }
        }
        return structuresConfig;
    }

    private R01EStructureDefinitionEntityCMPValue _createVOFromModel(R01MStructureDefinition structureObj) {
        R01EStructureDefinitionEntityCMPValue structureVO = new R01EStructureDefinitionEntityCMPValue();
        structureVO.setStructureId(structureObj.getStructureId());
        structureVO.setStructureGUID(structureObj.getStructureGUID());
        structureVO.setBagId(structureObj.getBagId());
        structureVO.setStructureDescription(structureObj.getStructureDescription());
        structureVO.setStructureGroup(structureObj.getStructureGroup());
        structureVO.setStructureState(structureObj.getStructureState());
        structureVO.setStructureType(structureObj.getStructureType());
        return structureVO;
    }

    private int _execCreateStructure(R01MStructure structure) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        int structureId;
        R01MStructureDefinition structureDef = structure.getSDefinition();
        R01EStructureDefinitionEntityCMPValue structureVO = this._createVOFromModel(structureDef);
        try {
            structureId = R01EStructureDefinitionEntityCMPUtil.getLocalHome().create(structureVO).getStructureId();
        }
        catch (CreateException crtExc) {
            R01FLog.to((String)"r01e.manager").severe("No se puede crear la estructura " + structureDef.getStructureGUID() + ".Error:" + crtExc.getMessage());
            crtExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se puede crear la estructura " + structureDef.getStructureGUID() + ".Error:" + crtExc.getMessage());
        }
        catch (NamingException namExc) {
            R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de estructuras.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se encuentra el CMP de estructuras.Error:" + namExc.getMessage());
        }
        if (structureDef.getStructureNames() != null && !structureDef.getStructureNames().isEmpty()) {
            for (String languageKey : structureDef.getStructureNames().keySet()) {
                String value = (String)structureDef.getStructureNames().get(languageKey);
                try {
                    R01EElementNameEntityCMPUtil.getLocalHome().create(value, languageKey, structureDef.getStructureGUID(), null);
                }
                catch (CreateException crtExc) {
                    R01FLog.to((String)"r01e.manager").severe("No se puede crear el nombre " + value + " para la estructura " + structureDef.getStructureGUID() + ".Error:" + crtExc.getMessage());
                    crtExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No se puede crear el nombre " + value + " para la estructura " + structureDef.getStructureGUID() + ".Error:" + crtExc.getMessage());
                }
                catch (NamingException namExc) {
                    R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de nombres de catalogaci\u00f3n.Error:" + namExc.getMessage());
                    namExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No se encuentra el CMP de nombres de catalogaci\u00f3n.Error:" + namExc.getMessage());
                }
            }
        }
        return structureId;
    }

    private void _execUpdateStructure(R01MStructureDefinition structureDef, R01EStructureDefinitionEntityCMPLocal structureCMP) throws R01MCatalogException {
        structureCMP.setR01EStructureDefinitionEntityCMPValue(this._createVOFromModel(structureDef));
        if (structureDef.getStructureNames() != null && !structureDef.getStructureNames().isEmpty()) {
            for (String language : structureDef.getStructureNames().keySet()) {
                String nameValue = structureDef.getStructureNames().get(language).toString();
                try {
                    R01EElementNameEntityCMPLocal elementNameCMPLocal = R01EElementNameEntityCMPUtil.getLocalHome().findByElementGUID(structureCMP.getStructureGUID(), language);
                    elementNameCMPLocal.setValue(nameValue);
                    elementNameCMPLocal.setGuid(structureCMP.getStructureGUID());
                }
                catch (FinderException ex) {
                    try {
                        R01EElementNameEntityCMPUtil.getLocalHome().create(nameValue, language, structureCMP.getStructureGUID(), "");
                    }
                    catch (CreateException crtExc) {
                        R01FLog.to((String)"r01e.manager").severe("No se puede crear el t\u00e9rmino " + nameValue + " para la estructura " + structureCMP.getStructureGUID() + " en el idioma " + language + ".Error:" + crtExc.getMessage());
                        crtExc.printStackTrace(System.out);
                        throw new R01MCatalogException("o se puede crear el t\u00e9rmino " + nameValue + " para la estructura " + structureCMP.getStructureGUID() + " en el idioma " + language + ".Error:" + crtExc.getMessage());
                    }
                    catch (NamingException namExc) {
                        R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de t\u00e9rminos.Error:" + namExc.getMessage());
                        namExc.printStackTrace(System.out);
                        throw new R01MCatalogException("No se encuentra el CMP de t\u00e9rminos.Error:" + namExc.getMessage());
                    }
                }
                catch (NamingException namExc) {
                    R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de t\u00e9rminos.Error:" + namExc.getMessage());
                    namExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No se encuentra el CMP de t\u00e9rminos.Error:" + namExc.getMessage());
                }
            }
        }
        try {
            Collection elementNameCMPLocalCol = R01EElementNameEntityCMPUtil.getLocalHome().findByElementGUID(structureCMP.getStructureGUID());
            for (R01EElementNameEntityCMPLocal elementNameEntityLocal : elementNameCMPLocalCol) {
                if (structureDef.getStructureNames().containsKey(elementNameEntityLocal.getLanguageId())) continue;
                try {
                    elementNameEntityLocal.remove();
                }
                catch (EJBException ex) {
                }
                catch (RemoveException ex) {}
            }
        }
        catch (FinderException ignore) {
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    private List _mountLabelsBranches(Collection labelsCMPs, boolean includeDisabledStructures) throws R01MCatalogException {
        ArrayList<List> outStructures = new ArrayList<List>();
        R01ELabelEntityCMPLocal currLabelCMP2 = null;
        R01EDAOCoreModelObjsLoader structureLoader = new R01EDAOCoreModelObjsLoader();
        for (R01ELabelEntityCMPLocal currLabelCMP2 : labelsCMPs) {
            List structures;
            try {
                structures = structureLoader.executeLoadStructuresWithLabel(currLabelCMP2.getLabelId());
            }
            catch (R01ECatalogException ex) {
                ex.printStackTrace(System.out);
                throw new R01MCatalogException(ex.getMessage());
            }
            currLabelCMP2.getLabelId();
            if (structures == null || structures.isEmpty()) continue;
            for (R01MStructureDefinition structDef : structures) {
                if (structDef.getStructureState() != 'H' && !includeDisabledStructures) continue;
                try {
                    outStructures.add(this._mountBranch(currLabelCMP2.getLabelId(), structDef));
                }
                catch (R01MCatalogElementNotFoundException cenfExc) {
                    R01FLog.to((String)"r01e.manager").severe("Ha fallado la carga de una etiqueta.Error:" + cenfExc.getMessage());
                    cenfExc.printStackTrace(System.out);
                    throw new R01MCatalogException("Ha fallado la carga de una etiqueta.Error:" + cenfExc.getMessage());
                }
            }
        }
        return outStructures;
    }

    private List _mountBranch(int labelNumericId, R01MStructureDefinition structureDef) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        R01ELabelsManager labelManager = new R01ELabelsManager();
        StateMap notRootStructureItems = new StateMap();
        StateMap rootStructureItems = new StateMap();
        Collection relations = null;
        try {
            relations = R01ERelationEntityCMPUtil.getLocalHome().findByStructureGUID(structureDef.getStructureGUID());
        }
        catch (FinderException ignore) {
        }
        catch (NamingException namExc) {
            R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de t\u00e9rminos.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se encuentra el CMP de t\u00e9rminos.Error:" + namExc.getMessage());
        }
        R01MStructureItem outStructure = null;
        if (relations != null && !relations.isEmpty()) {
            R01MLabel currRootLabel;
            for (R01ERelationEntityCMPLocal relationCMP : relations) {
                R01MStructureItem childStructureItem;
                R01MStructureItem parentStructureItem;
                R01MLabel currChildLabel;
                if (relationCMP.getLabelId1() == labelNumericId) continue;
                if (relationCMP.getLabelId1() != 0) {
                    rootStructureItems.put("" + relationCMP.getLabelId2(), "" + relationCMP.getLabelId2());
                    if (notRootStructureItems.containsKey("" + relationCMP.getLabelId2())) continue;
                    currChildLabel = labelManager.doLoadLabel(relationCMP.getLabelId2());
                    R01MStructureItem rootStructure = new R01MStructureItem();
                    rootStructure.setRootLabelId(currChildLabel.getLabelId());
                    rootStructure.setRootLabelOid(currChildLabel.getOid());
                    rootStructure.setStructureGuid(structureDef.getStructureGUID());
                    rootStructure.setStructureId(structureDef.getStructureId());
                    notRootStructureItems.put("" + rootStructure.getRootLabelId(), rootStructure);
                    continue;
                }
                if (notRootStructureItems.containsKey("" + relationCMP.getLabelId1())) {
                    parentStructureItem = (R01MStructureItem)notRootStructureItems.get("" + relationCMP.getLabelId1());
                } else {
                    currRootLabel = labelManager.doLoadLabel(relationCMP.getLabelId1());
                    parentStructureItem = new R01MStructureItem();
                    if (currRootLabel != null) {
                        parentStructureItem.setRootLabelId(currRootLabel.getLabelId());
                        parentStructureItem.setRootLabelOid(currRootLabel.getOid());
                    }
                }
                parentStructureItem.setStructureGuid(structureDef.getStructureGUID());
                parentStructureItem.setStructureId(structureDef.getStructureId());
                if (notRootStructureItems.containsKey("" + relationCMP.getLabelId2())) {
                    childStructureItem = (R01MStructureItem)notRootStructureItems.get("" + relationCMP.getLabelId2());
                } else {
                    currChildLabel = labelManager.doLoadLabel(relationCMP.getLabelId2());
                    childStructureItem = new R01MStructureItem();
                    childStructureItem.setRootLabelId(currChildLabel.getLabelId());
                    childStructureItem.setRootLabelOid(currChildLabel.getOid());
                }
                childStructureItem.setStructureGuid(structureDef.getStructureGUID());
                childStructureItem.setStructureId(structureDef.getStructureId());
                parentStructureItem.addChild(childStructureItem);
                childStructureItem.setParent(parentStructureItem);
                notRootStructureItems.put("" + parentStructureItem.getRootLabelId(), parentStructureItem);
                notRootStructureItems.put("" + childStructureItem.getRootLabelId(), childStructureItem);
            }
            if (notRootStructureItems.get("" + labelNumericId) != null) {
                R01MStructureItem resultStructureTmp = (R01MStructureItem)notRootStructureItems.get("" + labelNumericId);
                currRootLabel = labelManager.doLoadLabel(resultStructureTmp.getRootLabelId());
                outStructure = new R01MStructureItem();
                outStructure.setRootLabelId(currRootLabel.getLabelId());
                outStructure.setRootLabelOid(currRootLabel.getOid());
                outStructure.setStructureGuid(resultStructureTmp.getStructureGuid());
                outStructure.setStructureId(resultStructureTmp.getStructureId());
                R01EDAOCoreModelObjsLoader structureLoader = new R01EDAOCoreModelObjsLoader();
                try {
                    List roles = structureLoader.executeLoadRoles(resultStructureTmp.getStructureGuid(), currRootLabel.getOid());
                    if (!roles.isEmpty()) {
                        outStructure.setRole(Integer.parseInt((String)roles.get(0)));
                    }
                }
                catch (R01ECatalogException cEx) {
                    R01FLog.to((String)"r01e.manager").severe("No se ha podido cargar el rol de la etiqueta. Error:" + cEx.getMessage());
                    cEx.printStackTrace(System.out);
                }
                if (resultStructureTmp.getParent() == null || resultStructureTmp.getParent().getRootLabelOid() == null) {
                    outStructure = resultStructureTmp;
                } else {
                    do {
                        currRootLabel = labelManager.doLoadLabel(resultStructureTmp.getParent().getRootLabelId());
                        R01MStructureItem structureAux = new R01MStructureItem();
                        structureAux.setRootLabelId(currRootLabel.getLabelId());
                        structureAux.setRootLabelOid(currRootLabel.getOid());
                        structureAux.setStructureGuid(resultStructureTmp.getStructureGuid());
                        structureAux.setStructureId(resultStructureTmp.getStructureId());
                        outStructure.setParent(structureAux);
                        structureAux.addChild(outStructure);
                        outStructure = structureAux;
                    } while ((resultStructureTmp = resultStructureTmp.getParent()).getParent() != null);
                }
            }
        }
        ArrayList<Object> outBranch = new ArrayList<Object>();
        outBranch.add(structureDef);
        outBranch.add(outStructure);
        return outBranch;
    }

    private R01MStructureDefinition _mountStructureDefinition(R01EStructureDefinitionEntityCMPLocal structureDefCMPLocal) throws R01MCatalogException {
        R01MStructureDefinition sDef = new R01MStructureDefinition();
        sDef.setBagId(structureDefCMPLocal.getBagId());
        sDef.setStructureGUID(structureDefCMPLocal.getStructureGUID());
        sDef.setStructureId(structureDefCMPLocal.getStructureId());
        sDef.setStructureDescription(structureDefCMPLocal.getStructureDescription());
        sDef.setStructureType(structureDefCMPLocal.getStructureType());
        sDef.setStructureState(structureDefCMPLocal.getStructureState());
        try {
            Collection structureNames = R01EElementNameEntityCMPUtil.getLocalHome().findByElementGUID(structureDefCMPLocal.getStructureGUID());
            for (R01EElementNameEntityCMPLocal sname : structureNames) {
                sDef.setName(sname.getValue(), sname.getLanguageId());
            }
        }
        catch (FinderException finderEx) {
            R01FLog.to((String)"r01e.manager").info("No existen t\u00e9rminos para la estructura " + structureDefCMPLocal.getStructureGUID());
        }
        catch (NamingException namExc) {
            R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de t\u00e9rminos.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se encuentra el CMP de t\u00e9rminos.Error:" + namExc.getMessage());
        }
        return sDef;
    }
}

