/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01e.services;

import com.ejie.r01e.catalog.ejb.operations.R01EOperationsCMPPK;
import com.ejie.r01e.catalog.ejb.operations.R01EOperationsCMPUtil;
import com.ejie.r01e.catalog.ejb.operations.R01EOperationsCMPValue;
import com.ejie.r01e.catalog.ejb.opresponse.R01EOperationsResponseCMPLocal;
import com.ejie.r01e.catalog.ejb.opresponse.R01EOperationsResponseCMPUtil;
import com.ejie.r01e.catalog.ejb.opresponse.R01EOperationsResponseCMPValue;
import com.ejie.r01e.catalog.ejb.packets.R01EPacketsCMPLocal;
import com.ejie.r01e.catalog.ejb.packets.R01EPacketsCMPPK;
import com.ejie.r01e.catalog.ejb.packets.R01EPacketsCMPUtil;
import com.ejie.r01e.catalog.ejb.packets.R01EPacketsCMPValue;
import com.ejie.r01e.catalog.ejb.request.R01ERequestCMPUtil;
import com.ejie.r01e.catalog.ejb.request.R01ERequestCMPValue;
import com.ejie.r01e.catalog.ejb.systems.R01ESystemsCMPLocal;
import com.ejie.r01e.catalog.ejb.systems.R01ESystemsCMPPK;
import com.ejie.r01e.catalog.ejb.systems.R01ESystemsCMPUtil;
import com.ejie.r01e.catalog.ejb.systems.R01ESystemsCMPValue;
import com.ejie.r01e.ejb.notifier.R01ECatalogNotifierSLUtil;
import com.ejie.r01e.gestorejes.dbhelppers.dao.R01EDAOCatalogModelLoader;
import com.ejie.r01e.gestorejes.dbhelppers.dao.R01EDAOOperationsObjsLoader;
import com.ejie.r01e.services.R01EBaseCatalogManager;
import com.ejie.r01e.structures.exceptions.R01ECatalogException;
import com.ejie.r01e.structures.exceptions.R01ECatalogModelPersistenceException;
import com.ejie.r01e.structures.exceptions.R01EElementNotFoundException;
import com.ejie.r01e.util.R01EProperties;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.sql.QueryExecutor;
import com.ejie.r01f.util.NumberUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01m.config.objects.cataloguing.R01MChangesLabelOperation;
import com.ejie.r01m.config.objects.cataloguing.R01MChangesLabelsOperationsGroup;
import com.ejie.r01m.config.objects.cataloguing.R01MChangesLabelsOperationsList;
import com.ejie.r01m.config.objects.cataloguing.R01MChangesLabelsPacket;
import com.ejie.r01m.config.objects.cataloguing.R01MPacketInfo;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MCatalogElementNotFoundException;
import com.ejie.r01m.exceptions.R01MCatalogException;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MJMSException;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.bzd.R01MCatalogOperationsBzd;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MDateUtils;
import com.ejie.r01m.utils.R01MDozerMappingUtils;
import com.ejie.r01m.utils.jms.R01MJMSUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import net.sf.dozer.util.mapping.MappingException;

public class R01EOperationsManager
extends R01EBaseCatalogManager
implements R01MCatalogOperationsBzd {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01e.operationsManager").intValue() != Level.OFF.intValue();
    private static int order = 0;
    private transient R01MUserContext _userCtx = null;
    private static QueryExecutor _qryExecContents = new QueryExecutor(R01MConstants.CONTENTMANAGER_APPCODE, "contentQueryConnection");
    private static QueryExecutor _qryExecPortal = new QueryExecutor(R01MConstants.PORTALMANAGER_APPCODE, "portalQueryConnection");
    private static QueryExecutor _qryExecLabels = new QueryExecutor(R01MConstants.STRUCTURES_APPCODE, "labelsConnection");
    private Map _structuresCache = new HashMap();
    private Map _labelsCache = new HashMap();

    public R01EOperationsManager() {
        R01EOperationsManager._init();
    }

    public R01EOperationsManager(R01MUserContext userCtx) {
        this._userCtx = userCtx;
        R01EOperationsManager._init();
    }

    private static void _init() {
        if (order == 0) {
            R01EDAOCatalogModelLoader modelLoader = new R01EDAOCatalogModelLoader();
            try {
                order = modelLoader.executeLoadMaxOrder();
            }
            catch (R01ECatalogModelPersistenceException ex) {
                order = 0;
            }
            ++order;
        }
    }

    public void doExecuteRecatalogationProcess(R01MUserContext userCtx, R01MChangesLabelsPacket packet) throws EJBException, R01MSecurityException, R01MCatalogException {
        this._userCtx = userCtx;
        if (packet.getType() == 2 || packet.getType() == 3) {
            try {
                this._doPreparePreprocessedPacket(packet);
            }
            catch (R01MCatalogException catEx) {
                throw new EJBException((Exception)((Object)catEx));
            }
        }
        if (packet.getType() == 1) {
            try {
                this._doPreparePacketLabelsChanges(packet);
            }
            catch (R01MCatalogException catEx) {
                throw new EJBException((Exception)((Object)catEx));
            }
        }
    }

    public void doLaunchPacket(R01MUserContext userCtx, String packetOid, int numOperations, List listeners, int typeProcessor, boolean forceProcessor) throws EJBException, R01MSecurityException, R01MCatalogException {
        try {
            this._userCtx = userCtx;
            if (typeProcessor == 0) {
                if (listeners != null && !listeners.isEmpty()) {
                    Iterator itListeners = listeners.iterator();
                    while (itListeners.hasNext()) {
                        this._doCommitPreprocessedPacket(packetOid, numOperations, (String)itListeners.next(), typeProcessor, forceProcessor);
                    }
                }
            } else {
                this._doCommitPreprocessedPacket(packetOid, numOperations, null, typeProcessor, forceProcessor);
            }
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
    }

    public void doAccountNewLabelOperation(R01MUserContext userCtx, R01MChangesLabelOperation operation) throws R01MCatalogException {
        R01EOperationsCMPValue operationVO;
        if (DEBUG) {
            R01FLog.to((String)"r01e.operationsManager").info("OPERATIONS MANAGER >> Registrando la operaci\u00f3n " + operation.getOperationOid());
        }
        this._userCtx = userCtx;
        operation.setOrder(this._getOrder());
        try {
            operationVO = (R01EOperationsCMPValue)R01MDozerMappingUtils.map((String)R01MConstants.STRUCTURES_APPCODE, (Object)operation, R01EOperationsCMPValue.class);
        }
        catch (MappingException mapEx) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER (" + operation.getOperationOid() + ") >  Error al mapear los miembros del objeto operaci\u00f3n al Value Object correspondiente.");
            mapEx.printStackTrace(System.out);
            throw new R01MCatalogException("Error al mapear los miembros del objeto operaci\u00f3n al Value Object correspondiente: " + mapEx.getMessage());
        }
        catch (Exception e) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER (" + operation.getOperationOid() + ") >  Ha fallado el Mapeo de la operaci\u00f3n : " + e.getMessage());
            e.printStackTrace(System.out);
            throw new R01MCatalogException("Error al mapear los miembros del objeto operaci\u00f3n al Value Object correspondiente: " + e.getMessage());
        }
        catch (Throwable thEx) {
            thEx.printStackTrace(System.out);
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER (" + operation.getOperationOid() + ") >  Ha fallado el Mapeo de la operaci\u00f3n : " + thEx.getMessage());
            throw new R01MCatalogException("Error al mapear los miembros del objeto operaci\u00f3n al Value Object correspondiente.Error:" + thEx.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.operationsManager").info("OPERATIONS MANAGER (" + operation.getOperationOid() + ") > Registrando en BD la operaci\u00f3n.");
        }
        try {
            R01EOperationsCMPUtil.getLocalHome().create(operationVO);
        }
        catch (CreateException crtEx) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER (" + operation.getOperationOid() + ") > Error al crear la operaci\u00f3n en BD.");
            crtEx.printStackTrace(System.out);
            throw new R01MCatalogException("Error al crear la operaci\u00f3n " + operation.getOperationOid() + ": " + crtEx.getMessage());
        }
        catch (NamingException namEx) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER(" + operation.getOperationOid() + ") > Error al encontrar el home del CMP de operaciones.");
            namEx.printStackTrace(System.out);
            throw new R01MCatalogException("Error al encontrar el home del CMP de operaciones: " + namEx.getMessage());
        }
        this._setOrder(order + 1);
    }

    public List doPreviewReport(R01MUserContext userCtx, String packetOid, int numOperations, String system) throws R01MSecurityException, R01MCatalogException {
        this._userCtx = userCtx;
        try {
            List operations;
            if (system != null && !system.equals("")) {
                if (StringUtils.isEmptyString((String)packetOid) || !NumberUtils.isInteger((String)("" + numOperations)) || numOperations <= 0) {
                    return null;
                }
                operations = this._doPreviewReport(packetOid, numOperations, system);
            } else {
                operations = this._doPreviewReport(packetOid);
            }
            return operations;
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
    }

    public List doLoadPacketsInfo(R01MUserContext userCtx) throws R01MCatalogException {
        this._userCtx = userCtx;
        R01EDAOCatalogModelLoader loader = new R01EDAOCatalogModelLoader();
        try {
            return loader.executeLoadPacketsInfo();
        }
        catch (R01ECatalogModelPersistenceException pmExc) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER > Error en la carga de la informaci\u00f3n de paquetes.");
            pmExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error en la carga de la informaci\u00f3n de paquetes: " + pmExc.getMessage());
        }
    }

    public R01MPacketInfo doLoadPacketInfo(R01MUserContext userCtx, String packetOid) throws R01MCatalogException, R01MCatalogElementNotFoundException {
        R01MPacketInfo packetInfo;
        String opDesc = "Carga del paquete de recatalogaciones " + packetOid;
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        this._userCtx = userCtx;
        try {
            packetInfo = new R01EDAOCatalogModelLoader().executeLoadPacketInfo(packetOid);
        }
        catch (R01ECatalogModelPersistenceException pmExc) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER > Error en la carga de la informaci\u00f3n de paquete.");
            pmExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error en la carga de la informaci\u00f3n de paquete: " + pmExc.getMessage());
        }
        catch (R01EElementNotFoundException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogElementNotFoundException("No existe el paquete de recatalogaciones expecificado.Error:" + ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
        return packetInfo;
    }

    public Map doLoadPacketAdminInfo(R01MUserContext userCtx) throws R01MCatalogException {
        Map packetAdminInfo;
        String opDesc = "Carga del paquete de administraci\u00f3n";
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        this._userCtx = userCtx;
        try {
            packetAdminInfo = new R01EDAOCatalogModelLoader().executeLoadPacketAdminInfo();
        }
        catch (R01ECatalogModelPersistenceException pmExc) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER > Error en la carga de la informaci\u00f3n de paquete.");
            pmExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error en la carga de la informaci\u00f3n del paquete de administraci\u00f3n: " + pmExc.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
        return packetAdminInfo;
    }

    public void doMovePacketToHistory(R01MUserContext userCtx, String packetOid) throws R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)"r01e.operationsManager").info("OPERATIONS MANAGER >> Deshabilitando el paquete " + packetOid);
        }
        this._userCtx = userCtx;
        try {
            R01EPacketsCMPUtil.getLocalHome().findByPrimaryKey(new R01EPacketsCMPPK(packetOid)).setStatus(0);
        }
        catch (FinderException fndExc) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER >> El paquete " + packetOid + " no existe.Error:" + fndExc.getMessage());
            fndExc.printStackTrace(System.out);
            throw new R01MCatalogException("El paquete " + packetOid + " no existe.Error:" + fndExc.getMessage());
        }
        catch (NamingException namEx) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER >> Error al encontrar el home del CMP de paquetes. Error:" + namEx.getMessage());
            namEx.printStackTrace(System.out);
            throw new R01MCatalogException("Error al encontrar el home del CMP de paquetes.Error:" + namEx.getMessage());
        }
        this._resetOperations(packetOid);
        if (DEBUG) {
            R01FLog.to((String)"r01e.operationsManager").info("OPERATIONS MANAGER >> El paquete " + packetOid + " ha sido DESHABILITADO !!!!");
        }
    }

    private synchronized int _getOrder() {
        return order;
    }

    private synchronized void _setOrder(int newOrder) {
        order = newOrder;
    }

    private List _doPreviewReport(String packetOid, int numOperations, String system) throws R01MCatalogException {
        List pendingRecatalogations;
        R01EDAOCatalogModelLoader loader = new R01EDAOCatalogModelLoader();
        ArrayList<R01MChangesLabelOperation> operations = new ArrayList<R01MChangesLabelOperation>();
        try {
            pendingRecatalogations = loader.executeGetPendingOperations(packetOid, system, numOperations);
        }
        catch (R01ECatalogModelPersistenceException ex) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER >> Error en la carga de las operaciones pendientes de ser ejecutadas.Error:" + ex.getMessage());
            ex.printStackTrace(System.out);
            throw new R01MCatalogException("Error en la carga de las operaciones pendientes de ser ejecutadas.Error:" + ex.getMessage());
        }
        if (pendingRecatalogations != null && !pendingRecatalogations.isEmpty()) {
            for (String currObjectOid : pendingRecatalogations) {
                R01EOperationsResponseCMPLocal operationsResponseCMP;
                try {
                    operationsResponseCMP = R01EOperationsResponseCMPUtil.getLocalHome().findByObjectOid(packetOid, currObjectOid);
                }
                catch (Exception ex) {
                    R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER >> Error en la carga del object de oid " + currObjectOid + ".Error:" + ex.getMessage());
                    ex.printStackTrace(System.out);
                    throw new R01MCatalogException("Error en la carga del object de oid " + currObjectOid + ".Error:" + ex.getMessage());
                }
                List xmlOperations = null;
                try {
                    xmlOperations = ((R01MChangesLabelsOperationsList)XOManager.getObject((String)R01MConstants.STRUCTURESMODEL_MAPFILE, (String)operationsResponseCMP.getXMLOperationsGroup())).getOperations();
                }
                catch (XOMarshallerException xoExc) {
                    R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER >> Error al mapear el XML de lista de operaciones a objeto. Error:" + xoExc.getMessage());
                    return null;
                }
                if (xmlOperations == null || xmlOperations.isEmpty()) continue;
                for (R01MChangesLabelOperation operation : xmlOperations) {
                    operations.add(this._doTraslateXMLOperation(operation, system));
                }
            }
        }
        return operations;
    }

    private List _doPreviewReport(String packetOid) throws R01MCatalogException {
        R01EPacketsCMPLocal packetCMP;
        ArrayList<R01MChangesLabelOperation> operations = new ArrayList<R01MChangesLabelOperation>();
        try {
            packetCMP = R01EPacketsCMPUtil.getLocalHome().findByPrimaryKey(new R01EPacketsCMPPK(packetOid));
        }
        catch (Exception ex) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER >> Error en la carga del object de oid " + packetOid + ".Error:" + ex.getMessage());
            ex.printStackTrace(System.out);
            throw new R01MCatalogException("Error en la carga del object de oid " + packetOid + ".Error:" + ex.getMessage());
        }
        List xmlOperations = null;
        StringBuffer objectXML = new StringBuffer(37);
        objectXML.append("<packetOperations>");
        objectXML.append(packetCMP.getXMLOperations());
        objectXML.append("</packetOperations>");
        try {
            xmlOperations = ((R01MChangesLabelsOperationsList)XOManager.getObject((String)R01MConstants.STRUCTURESMODEL_MAPFILE, (String)objectXML.toString())).getOperations();
        }
        catch (XOMarshallerException xoExc) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER >> Error al mapear el XML de lista de operaciones a objeto. Error:" + xoExc.getMessage());
            return null;
        }
        if (xmlOperations != null && !xmlOperations.isEmpty()) {
            for (R01MChangesLabelOperation operation : xmlOperations) {
                operations.add(this._doTraslateXMLOperation(operation, ""));
            }
        }
        return operations;
    }

    private void _doCommitPreprocessedPacket(String packetOid, int numOperations, String listener, int typeProcessor, boolean forceProcessor) throws R01MCatalogException {
        block29: {
            block26: {
                block27: {
                    block28: {
                        if (DEBUG) {
                            R01FLog.to((String)"r01e.operationsManager").info("OPERATIONS MANAGER >> Ejecuci\u00f3n efectiva del paquete " + packetOid + "\n\t n\u00famero de operaciones " + numOperations + "\n\t tipo de ejecuci\u00f3n " + typeProcessor + "\n\t forzar la ejecuci\u00f3n " + forceProcessor);
                        }
                        R01EDAOCatalogModelLoader loader = new R01EDAOCatalogModelLoader();
                        boolean isPacketEnabled = false;
                        boolean existsPacket = false;
                        if (!StringUtils.isEmptyString((String)packetOid)) {
                            try {
                                existsPacket = loader.existsPacket(packetOid);
                            }
                            catch (R01ECatalogModelPersistenceException catExc) {
                                R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER >> Error en la consulta de la existencia del paquete " + packetOid + ".Error:" + catExc.getMessage());
                                catExc.printStackTrace(System.out);
                                throw new R01MCatalogException("Error en la consulta de la existencia del paquete " + packetOid + ".Error:" + catExc.getMessage());
                            }
                        } else {
                            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER >> El identificador de paquete es NULO o vac\u00edo.");
                            throw new R01MCatalogException("El identificador de paquete es NULO o vac\u00edo.");
                        }
                        if (!existsPacket) break block26;
                        try {
                            isPacketEnabled = loader.isPacketEnabled(packetOid);
                        }
                        catch (R01ECatalogModelPersistenceException catExc) {
                            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER >> Error en la consulta de la existencia del paquete " + packetOid + ".Error:" + catExc.getMessage());
                            catExc.printStackTrace(System.out);
                            throw new R01MCatalogException("Error en la consulta de la existencia del paquete " + packetOid + ".Error:" + catExc.getMessage());
                        }
                        if (!isPacketEnabled) break block27;
                        R01MChangesLabelsPacket packet = this._readPacket(packetOid);
                        if (packet.getOperations() == null || packet.getOperations().isEmpty()) break block28;
                        switch (typeProcessor) {
                            case 1: {
                                this._createListenersAndOperations(packet, true);
                                break;
                            }
                            case 2: {
                                this._restartOperations(packetOid, packet.getType(), false);
                                break;
                            }
                            case 3: {
                                this._restartOperations(packetOid, packet.getType(), true);
                                break;
                            }
                            default: {
                                List pendingOpsTemp;
                                try {
                                    pendingOpsTemp = loader.executeGetPendingOperations(packetOid, listener, numOperations);
                                }
                                catch (R01ECatalogModelPersistenceException ex) {
                                    R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER >> Error en la carga de las operaciones pendientes de ser ejecutadas.Error:" + ex.getMessage());
                                    ex.printStackTrace(System.out);
                                    throw new R01MCatalogException("Error en la carga de las operaciones pendientes de ser ejecutadas.Error:" + ex.getMessage());
                                }
                                ArrayList operationsPendingOids = new ArrayList();
                                if (pendingOpsTemp != null && !pendingOpsTemp.isEmpty()) {
                                    operationsPendingOids.addAll(pendingOpsTemp);
                                }
                                if (operationsPendingOids != null && operationsPendingOids.size() > 0) {
                                    ArrayList<R01MChangesLabelsOperationsGroup> requestedOperationsGroups = new ArrayList<R01MChangesLabelsOperationsGroup>();
                                    R01EOperationsResponseCMPValue operationsResponseVO = null;
                                    for (String currObjectOid : operationsPendingOids) {
                                        R01EOperationsResponseCMPLocal operationsResponseCMP;
                                        try {
                                            operationsResponseCMP = R01EOperationsResponseCMPUtil.getLocalHome().findByObjectOid(packetOid, currObjectOid);
                                        }
                                        catch (Exception ex) {
                                            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER >> Error en la carga del object de oid " + currObjectOid + ".Error:" + ex.getMessage());
                                            ex.printStackTrace(System.out);
                                            throw new R01MCatalogException("Error en la carga del object de oid " + currObjectOid + ".Error:" + ex.getMessage());
                                        }
                                        R01MChangesLabelsOperationsGroup currOperationGroup = new R01MChangesLabelsOperationsGroup();
                                        currOperationGroup.setObjectOid(currObjectOid);
                                        if (operationsResponseCMP.getSystemOid().equals(R01MConstants.CONTENTMANAGER_APPCODE)) {
                                            currOperationGroup.setType(2);
                                        } else if (operationsResponseCMP.getSystemOid().equals(R01MConstants.PORTALMANAGER_APPCODE)) {
                                            currOperationGroup.setType(3);
                                        }
                                        currOperationGroup.setOperationsGroupXML(operationsResponseCMP.getXMLOperationsGroup());
                                        requestedOperationsGroups.add(currOperationGroup);
                                        operationsResponseVO = operationsResponseCMP.getR01EOperationsResponseCMPValue();
                                        operationsResponseVO.setState(1);
                                        operationsResponseCMP.setR01EOperationsResponseCMPValue(operationsResponseVO);
                                    }
                                    packet.setOperations(requestedOperationsGroups);
                                    this._sendPacketToJMS(packet);
                                    R01ERequestCMPValue requestVO = new R01ERequestCMPValue();
                                    requestVO.setEndDate(null);
                                    requestVO.setInitDate(R01MDateUtils.today());
                                    requestVO.setOperationsRequestCount(numOperations);
                                    requestVO.setPacketOid(packet.getPacketOid());
                                    try {
                                        R01ERequestCMPUtil.getLocalHome().create(requestVO);
                                        break;
                                    }
                                    catch (CreateException crtExc) {
                                        R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER >> No se puede registrar una solicitud de ejecuci\u00f3n del paquete " + packet.getPacketOid() + " .Error:" + crtExc.getMessage());
                                        crtExc.printStackTrace(System.out);
                                        throw new R01MCatalogException("No se puede registrar una solicitud de ejecuci\u00f3n del paquete " + packet.getPacketOid() + ".Error:" + crtExc.getMessage());
                                    }
                                    catch (NamingException namEx) {
                                        R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER >> Error al encontrar el home del CMP de peticiones. Error:" + namEx.getMessage());
                                        namEx.printStackTrace(System.out);
                                        throw new R01MCatalogException("Error al encontrar el home del CMP de peticiones. Error:" + namEx.getMessage());
                                    }
                                }
                                if (DEBUG) {
                                    R01FLog.to((String)"r01e.operationsManager").info("OPERATIONS MANAGER >> El paquete " + packetOid + " NO TIENE OPERACIONES PENDIENTES DE EJECUTAR !!!!!!");
                                    break;
                                } else {
                                    break;
                                }
                            }
                        }
                        break block29;
                    }
                    R01FLog.to((String)"r01e.operationsManager").warning("OPERATIONS MANAGER >> El paquete " + packetOid + " NO TIENE OPERACIONES PARA EJECUTAR !!!!!!");
                    break block29;
                }
                R01FLog.to((String)"r01e.operationsManager").warning("OPERATIONS MANAGER >> El paquete " + packetOid + " est\u00e1 deshabilitado!!!!!!");
                break block29;
            }
            R01FLog.to((String)"r01e.operationsManager").warning("OPERATIONS MANAGER >> El paquete " + packetOid + " NO EXISTE!!!!!!");
        }
    }

    private void _doPreparePreprocessedPacket(R01MChangesLabelsPacket packet) throws R01MCatalogException {
        String listenerApp = null;
        if (packet.getType() == 2) {
            listenerApp = R01MConstants.CONTENTMANAGER_APPCODE;
        } else if (packet.getType() == 3) {
            listenerApp = R01MConstants.PORTALMANAGER_APPCODE;
        }
        if (listenerApp != null) {
            try {
                this._registerNewPacket(packet);
            }
            catch (R01MCatalogException catExc) {
                R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER >> Error en el registro del paquete " + packet.getPacketOid() + ".Error:" + catExc.getMessage());
                catExc.printStackTrace(System.out);
                throw new R01MCatalogException("Error en el registro del paquete " + packet.getPacketOid() + ".Error:" + catExc.getMessage());
            }
        } else {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER >> El tipo del paquete " + packet.getType() + " no se corresponde con ning\u00fan listener especificado.");
        }
    }

    private void _doPreparePacketLabelsChanges(R01MChangesLabelsPacket packet) throws R01MCatalogException {
        String packetOid = packet.getPacketOid();
        if (packetOid == null) {
            throw new R01MCatalogException("El identificador de paquete es NULO.");
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.operationsManager").info("OPERATIONS MANAGER >> Obtener las operaciones a procesar para el paquete " + packetOid);
        }
        R01EDAOCatalogModelLoader loader = new R01EDAOCatalogModelLoader();
        boolean existsPacket = false;
        if (packetOid != null) {
            try {
                existsPacket = loader.existsPacket(packetOid);
            }
            catch (R01ECatalogModelPersistenceException catExc) {
                R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER >> Error en la consulta de la existencia del paquete " + packetOid + ".Error:" + catExc.getMessage());
                catExc.printStackTrace(System.out);
                throw new R01MCatalogException("Error en la consulta de la existencia del paquete " + packetOid + ".Error:" + catExc.getMessage());
            }
        }
        try {
            if (!existsPacket) {
                if (DEBUG) {
                    R01FLog.to((String)"r01e.operationsManager").info("OPERATIONS MANAGER >> El paquete " + packetOid + " NO EXISTE.");
                }
                this._processNewAdministrationPacket(packet);
            }
        }
        catch (R01MCatalogException catExc) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER >> Error al obtener el PAQUETE a procesar.Error:" + catExc.getMessage());
            catExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error al obtener el PAQUETE a procesar.Error:" + catExc.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.operationsManager").info("OPERATIONS MANAGER >> Se ha registrado el paquete " + packet.getPacketOid());
        }
    }

    private R01MChangesLabelsPacket _readPacket(String packetOid) throws R01MCatalogException {
        R01MChangesLabelsOperationsList operations;
        R01MChangesLabelsPacket packet;
        R01EPacketsCMPValue packetVO;
        try {
            packetVO = R01EPacketsCMPUtil.getLocalHome().findByPrimaryKey(new R01EPacketsCMPPK(packetOid)).getR01EPacketsCMPValue();
        }
        catch (FinderException fndExc) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER(" + packetOid + ") > El paquete no existe.");
            fndExc.printStackTrace(System.out);
            throw new R01MCatalogException("El paquete de oid " + packetOid + " no existe: " + fndExc.getMessage());
        }
        catch (NamingException namEx) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER(" + packetOid + ") > Error al encontrar el home del CMP de paquetes.");
            namEx.printStackTrace(System.out);
            throw new R01MCatalogException("Error al encontrar el home del CMP de paquetes: " + namEx.getMessage());
        }
        try {
            packet = (R01MChangesLabelsPacket)R01MDozerMappingUtils.map((String)R01MConstants.STRUCTURES_APPCODE, (Object)packetVO, R01MChangesLabelsPacket.class);
        }
        catch (MappingException mapEx) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER (" + packetOid + ") >  Error al mapear los miembros del Value Object al objeto correspondiente.");
            mapEx.printStackTrace(System.out);
            throw new R01MCatalogException("Error al mapear los miembros del objeto del Value Object al objeto correspondiente: " + mapEx.getMessage());
        }
        catch (Exception e) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER (" + packetOid + ") >  Ha fallado el Mapeo del paquete : " + e.getMessage());
            e.printStackTrace(System.out);
            throw new R01MCatalogException("Error al mapear los miembros del Value Object al objeto correspondiente: " + e.getMessage());
        }
        catch (Throwable thEx) {
            thEx.printStackTrace(System.out);
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER (" + packetOid + ") >  Ha fallado el Mapeo del paquete : " + thEx.getMessage());
            throw new R01MCatalogException("Error al mapear los miembros del Value Object al objeto correspondiente.Error:" + thEx.getMessage());
        }
        try {
            operations = (R01MChangesLabelsOperationsList)XOManager.getObject((String)R01MConstants.STRUCTURESMODEL_MAPFILE, (String)("<packetOperations>" + packetVO.getXMLOperations() + "</packetOperations>"));
        }
        catch (XOMarshallerException xoExc) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER(" + packetOid + ") > Error al mapear el objeto paquete a XML. Error:" + xoExc.getMessage());
            xoExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error al mapear el objeto paquete a XML: " + xoExc.getMessage());
        }
        packet.setOperations(operations.getOperations());
        return packet;
    }

    private void _processNewAdministrationPacket(R01MChangesLabelsPacket packet) throws R01MCatalogException {
        List packetOperations = null;
        R01EDAOOperationsObjsLoader loader = new R01EDAOOperationsObjsLoader();
        try {
            packetOperations = loader.executeLoadOperations();
        }
        catch (R01ECatalogException catExc) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER > Error al mapear las operaciones a procesar. Error:" + catExc.getMessage());
            catExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error al mapear las operaciones a procesar.Error:" + catExc.getMessage());
        }
        catch (R01ECatalogModelPersistenceException cmExc) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER > Error al cargar las operaciones a procesar. Error:" + cmExc.getMessage());
            cmExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error al cargar las operaciones a procesar.Error:" + cmExc.getMessage());
        }
        if (packetOperations != null && !packetOperations.isEmpty()) {
            packet.setOperations(packetOperations);
            R01EOperationsCMPPK operationPK = new R01EOperationsCMPPK();
            for (R01MChangesLabelOperation currOperation : packetOperations) {
                operationPK.setOid(currOperation.getOperationOid());
                try {
                    R01EOperationsCMPUtil.getLocalHome().findByPrimaryKey(operationPK).remove();
                }
                catch (EJBException ejbEx) {
                    R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER (" + currOperation.getOperationOid() + ") > DELETE > Error en CMP de la operaci\u00f3n.");
                    ejbEx.printStackTrace(System.out);
                    throw new R01MCatalogException("Error al borrar la operaci\u00f3n " + currOperation.getOperationOid() + ": " + ejbEx.getMessage());
                }
                catch (RemoveException remEx) {
                    R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER (" + currOperation.getOperationOid() + ") > DELETE > No se puede borrar la operaci\u00f3n.");
                    remEx.printStackTrace(System.out);
                    throw new R01MCatalogException("No se puede borrar la operaci\u00f3n " + currOperation.getOperationOid() + ": " + remEx.getMessage());
                }
                catch (FinderException findEx) {
                    R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER (" + currOperation.getOperationOid() + ")> DELETE > No existe la operaci\u00f3n.");
                    findEx.printStackTrace(System.out);
                    throw new R01MCatalogException("No existe la operaci\u00f3n " + currOperation.getOperationOid() + ": " + findEx.getMessage());
                }
                catch (NamingException namEx) {
                    R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER (" + currOperation.getOperationOid() + ")> DELETE > Error al localizar el home del CMP de la operaci\u00f3n.");
                    namEx.printStackTrace(System.out);
                    throw new R01MCatalogException("Error al localizar el home del CMP de la operaci\u00f3n: " + namEx.getMessage());
                }
            }
            this._registerNewPacket(packet);
            this._setOrder(1);
        } else {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER > NO EXISTEN OPERACIONES PARA SER PROCESADAS ...........");
        }
    }

    private void _registerNewPacket(R01MChangesLabelsPacket packet) throws R01MCatalogException {
        R01EPacketsCMPValue packetVO;
        R01FLog.to((String)"r01e.operationsManager").info("OPERATIONS MANAGER (" + packet.getPacketOid() + ") > Inicio Procesado del paquete ...........");
        if (packet.getOperations() == null || packet.getOperations().isEmpty()) {
            R01FLog.to((String)"r01e.operationsManager").info("OPERATIONS MANAGER (" + packet.getPacketOid() + ") > El paquete no tiene operaciones que procesar....");
            return;
        }
        if (packet.getType() == 1) {
            this._filterOperations(packet);
        }
        StringBuffer operationsXML = new StringBuffer("<operations>");
        Iterator itOperations = packet.getOperations().iterator();
        while (itOperations.hasNext()) {
            try {
                operationsXML.append(XOManager.getXML((String)R01MConstants.STRUCTURESMODEL_MAPFILE, itOperations.next()));
            }
            catch (XOMarshallerException xoExc) {
                R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER(" + packet.getPacketOid() + ") > Error al mapear el objeto paquete a XML. Error:" + xoExc.getMessage());
                xoExc.printStackTrace(System.out);
                throw new R01MCatalogException("Error al mapear el objeto paquete a XML: " + xoExc.getMessage());
            }
        }
        operationsXML.append("</operations>");
        if (StringUtils.isEmptyString((String)packet.getName())) {
            switch (packet.getType()) {
                case 1: {
                    packet.setName("Proceso de Recatalogaci\u00f3n de paquete de Administraci\u00f3n");
                    break;
                }
                case 2: {
                    packet.setName("Proceso de Recatalogaci\u00f3n Masiva de contenidos");
                    break;
                }
                case 3: {
                    packet.setName("Proceso de Recatalogaci\u00f3n Masiva de portales");
                    break;
                }
            }
        }
        packet.setUserId(this._userCtx != null ? this._userCtx.getUserName() : "unknown");
        packet.setCommitDate(R01MDateUtils.today());
        try {
            packetVO = (R01EPacketsCMPValue)R01MDozerMappingUtils.map((String)R01MConstants.STRUCTURES_APPCODE, (Object)packet, R01EPacketsCMPValue.class);
        }
        catch (MappingException mapEx) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER (" + packet.getPacketOid() + ") >  Error al mapear los miembros del objeto paquete al Value Object correspondiente.");
            mapEx.printStackTrace(System.out);
            throw new R01MCatalogException("Error al mapear los miembros del objeto paquete al Value Object correspondiente: " + mapEx.getMessage());
        }
        catch (Exception e) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER (" + packet.getPacketOid() + ") >  Ha fallado el Mapeo del paquete : " + e.getMessage());
            e.printStackTrace(System.out);
            throw new R01MCatalogException("Error al mapear los miembros del objeto paquete al Value Object correspondiente: " + e.getMessage());
        }
        catch (Throwable thEx) {
            thEx.printStackTrace(System.out);
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER (" + packet.getPacketOid() + ") >  Ha fallado el Mapeo del paquete : " + thEx.getMessage());
            throw new R01MCatalogException("Error al mapear los miembros del objeto paquete al Value Object correspondiente.Error:" + thEx.getMessage());
        }
        packetVO.setXMLOperations(operationsXML.toString());
        try {
            R01EPacketsCMPUtil.getLocalHome().create(packetVO);
        }
        catch (CreateException crtEx) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER (" + packetVO.getOid() + ") > Error al crear la operaci\u00f3n en BD.");
            crtEx.printStackTrace(System.out);
            throw new R01MCatalogException("Error al crear la operaci\u00f3n " + packetVO.getOid() + ": " + crtEx.getMessage());
        }
        catch (NamingException namEx) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER(" + packetVO.getOid() + ") > Error al encontrar el home del CMP de operaciones.");
            namEx.printStackTrace(System.out);
            throw new R01MCatalogException("Error al encontrar el home del CMP de operaciones: " + namEx.getMessage());
        }
        this._createListenersAndOperations(packet, false);
    }

    private void _createListenersAndOperations(R01MChangesLabelsPacket packet, boolean deleteOperations) throws R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)"r01e.operationsManager").info("OPERATIONS MANAGER (" + packet.getPacketOid() + ") > Registrando la recatalogaci\u00f3n del paquete...");
        }
        if (packet.getOperations() == null || packet.getOperations().isEmpty()) {
            return;
        }
        List listeners = this._getListeners(packet.getType());
        for (String currListener : listeners) {
            this._saveListener(currListener, packet.getPacketOid());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.operationsManager").info("OPERATIONS MANAGER (" + packet.getPacketOid() + ") > FIN registro de los listeners del paquete ...........");
        }
        if (deleteOperations) {
            this._resetOperations(packet.getPacketOid());
        }
        Map operationGroups = null;
        for (String currListener : listeners) {
            if (packet.getType() == 1) {
                if (currListener.equals(R01MConstants.CONTENTMANAGER_APPCODE)) {
                    try {
                        operationGroups = R01MClientFactory.getContentModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext((String)"RecatalogAdmin")).getOperationsGroupByContents(packet);
                    }
                    catch (R01MContentModelException cmExc) {
                        R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER (" + packet.getPacketOid() + ") > Error en la reagrupaci\u00f3n de contenidos.Error:" + cmExc.getMessage());
                        cmExc.printStackTrace(System.out);
                        throw new R01MCatalogException("Error en la reagrupaci\u00f3n de contenidos por el paquete " + packet.getPacketOid() + ".Error:" + cmExc.getMessage());
                    }
                    catch (R01MSecurityException secExc) {
                        R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER (" + packet.getPacketOid() + ") > Error de seguridad en la reagrupaci\u00f3n de contenidos.Error:" + secExc.getMessage());
                        secExc.printStackTrace(System.out);
                        throw new R01MCatalogException("Error de seguridad en la reagrupaci\u00f3n de contenidos por el paquete " + packet.getPacketOid() + ".Error:" + secExc.getMessage());
                    }
                }
                if (currListener.equals(R01MConstants.PORTALMANAGER_APPCODE)) {
                    try {
                        operationGroups = R01MClientFactory.getPortalModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext((String)"RecatalogAdmin"), (String)"all").getOperationsGroupByPages(packet);
                    }
                    catch (R01MPortalModelException pmExc) {
                        R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER (" + packet.getPacketOid() + ") > Error en la reagrupaci\u00f3n de p\u00e1ginas.Error:" + pmExc.getMessage());
                        pmExc.printStackTrace(System.out);
                        throw new R01MCatalogException("Error en la reagrupaci\u00f3n de p\u00e1ginas por el paquete " + packet.getPacketOid() + ".Error:" + pmExc.getMessage());
                    }
                    catch (R01MSecurityException secExc) {
                        R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER (" + packet.getPacketOid() + ") > Error de seguridad en la reagrupaci\u00f3n de p\u00e1ginas.Error:" + secExc.getMessage());
                        secExc.printStackTrace(System.out);
                        throw new R01MCatalogException("Error de seguridad en la reagrupaci\u00f3n de p\u00e1ginas por el paquete " + packet.getPacketOid() + ".Error:" + secExc.getMessage());
                    }
                }
            } else {
                operationGroups = this._createOperationsGroup(packet);
            }
            if (operationGroups == null || operationGroups.isEmpty()) continue;
            for (R01MChangesLabelsOperationsGroup opGroup : operationGroups.values()) {
                this._saveOperationGroup(currListener, packet.getPacketOid(), opGroup);
            }
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.operationsManager").info("OPERATIONS MANAGER (" + packet.getPacketOid() + ") > FIN registro de las operaciones del paquete ...........");
        }
    }

    private void _resetOperations(String packetOid) throws R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)"r01e.operationsManager").info("OPERATIONS MANAGER >> Borrando las operaciones asociadas al paquete " + packetOid);
        }
        R01EDAOCatalogModelLoader loader = new R01EDAOCatalogModelLoader();
        try {
            loader.executeDeleteRecatalogations(packetOid);
        }
        catch (R01ECatalogModelPersistenceException catExc) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER >> Error en la consulta de borrado de recatalogaciones del paquete " + packetOid + ".Error:" + catExc.getMessage());
            catExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error en la consulta de borrado de recatalogaciones del paquete " + packetOid + ".Error:" + catExc.getMessage());
        }
    }

    private void _restartOperations(String packetOid, int packetType, boolean allOperations) throws R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)"r01e.operationsManager").info("OPERATIONS MANAGER >> Reinicio de las operaciones asociadas al paquete " + packetOid);
        }
        ArrayList packetOpsCMPs = null;
        List listeners = this._getListeners(packetType);
        if (listeners != null && !listeners.isEmpty()) {
            packetOpsCMPs = new ArrayList();
            for (String currListener : listeners) {
                try {
                    Collection packetOpsCMPsAux;
                    if (allOperations) {
                        block25: {
                            block24: {
                                block23: {
                                    try {
                                        packetOpsCMPsAux = R01EOperationsResponseCMPUtil.getLocalHome().findByState(packetOid, currListener, 2);
                                        if (packetOpsCMPsAux != null && !packetOpsCMPsAux.isEmpty()) {
                                            packetOpsCMPs.addAll(packetOpsCMPsAux);
                                        }
                                    }
                                    catch (FinderException fndExc) {
                                        if (!DEBUG) break block23;
                                        R01FLog.to((String)"r01e.operationsManager").info("OPERATIONS MANAGER >>El paquete " + packetOid + " no tiene operaciones ERRONEAS.");
                                    }
                                }
                                try {
                                    packetOpsCMPsAux = R01EOperationsResponseCMPUtil.getLocalHome().findByState(packetOid, currListener, 4);
                                    if (packetOpsCMPsAux != null && !packetOpsCMPsAux.isEmpty()) {
                                        packetOpsCMPs.addAll(packetOpsCMPsAux);
                                    }
                                }
                                catch (FinderException fndExc) {
                                    if (!DEBUG) break block24;
                                    R01FLog.to((String)"r01e.operationsManager").info("OPERATIONS MANAGER >>El paquete " + packetOid + " no tiene operaciones OK con errores.");
                                }
                            }
                            try {
                                packetOpsCMPsAux = R01EOperationsResponseCMPUtil.getLocalHome().findByState(packetOid, currListener, 1);
                                if (packetOpsCMPsAux != null && !packetOpsCMPsAux.isEmpty()) {
                                    packetOpsCMPs.addAll(packetOpsCMPsAux);
                                }
                            }
                            catch (FinderException fndExc) {
                                if (!DEBUG) break block25;
                                R01FLog.to((String)"r01e.operationsManager").info("OPERATIONS MANAGER >>El paquete " + packetOid + " no tiene operaciones EN PROGRESO.");
                            }
                        }
                        try {
                            packetOpsCMPsAux = R01EOperationsResponseCMPUtil.getLocalHome().findByState(packetOid, currListener, 3);
                            if (packetOpsCMPsAux == null || packetOpsCMPsAux.isEmpty()) continue;
                            packetOpsCMPs.addAll(packetOpsCMPsAux);
                        }
                        catch (FinderException fndExc) {
                            if (!DEBUG) continue;
                            R01FLog.to((String)"r01e.operationsManager").info("OPERATIONS MANAGER >>El paquete " + packetOid + " no tiene operaciones OK.");
                        }
                        continue;
                    }
                    try {
                        packetOpsCMPsAux = R01EOperationsResponseCMPUtil.getLocalHome().findByState(packetOid, currListener, 2);
                        if (packetOpsCMPsAux == null || packetOpsCMPsAux.isEmpty()) continue;
                        packetOpsCMPs.addAll(packetOpsCMPsAux);
                    }
                    catch (FinderException fndExc) {
                        if (!DEBUG) continue;
                        R01FLog.to((String)"r01e.operationsManager").info("OPERATIONS MANAGER >>El paquete " + packetOid + " no tiene operaciones ERRONEAS.");
                    }
                }
                catch (NamingException namEx) {
                    R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER >> Error al encontrar el home del CMP de respuesta de procesado de operaciones. Error:" + namEx.getMessage());
                    namEx.printStackTrace(System.out);
                    throw new R01MCatalogException("Error al encontrar el home del CMP de respuesta de procesado de operaciones. Error:" + namEx.getMessage());
                }
            }
        }
        if (packetOpsCMPs != null && !packetOpsCMPs.isEmpty()) {
            R01EOperationsResponseCMPLocal packetOpsCMPLocal = null;
            R01EOperationsResponseCMPValue operationsResponseCMPValue = null;
            Iterator itPacketOpsCMPs = packetOpsCMPs.iterator();
            while (itPacketOpsCMPs.hasNext()) {
                try {
                    packetOpsCMPLocal = (R01EOperationsResponseCMPLocal)itPacketOpsCMPs.next();
                    operationsResponseCMPValue = packetOpsCMPLocal.getR01EOperationsResponseCMPValue();
                    operationsResponseCMPValue.setState(0);
                    operationsResponseCMPValue.setErrorMsg("");
                    packetOpsCMPLocal.setR01EOperationsResponseCMPValue(operationsResponseCMPValue);
                }
                catch (EJBException ex) {
                    R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER >> Error al encontrar el ejb de respuesta de procesado de operaciones. Error:" + ex.getMessage());
                    ex.printStackTrace(System.out);
                    throw new R01MCatalogException("Error en el ejb de respuesta de procesado de operaciones. Error:" + ex.getMessage());
                }
            }
        }
    }

    private List _getListeners(int packetType) {
        ArrayList<String> listeners = new ArrayList<String>();
        switch (packetType) {
            case 1: {
                for (String currListener : R01EProperties.RECATALOG_LISTENERS) {
                    listeners.add(currListener);
                }
                break;
            }
            case 2: {
                listeners.add(R01MConstants.CONTENTMANAGER_APPCODE);
                break;
            }
            case 3: {
                listeners.add(R01MConstants.PORTALMANAGER_APPCODE);
                break;
            }
            default: {
                R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER > El tipo de paquete " + packetType + " es incorrecto.");
            }
        }
        return listeners;
    }

    /*
     * WARNING - void declaration
     */
    private void _filterOperations(R01MChangesLabelsPacket packet) {
        if (DEBUG) {
            R01FLog.to((String)"r01e.operationsManager").info("OPERATIONS MANAGER >> Filtrando las operaciones:");
            R01FLog.to((String)"r01e.operationsManager").info(packet.composeDebugInfo("\t").toString());
        }
        HashMap operationsGroup = new HashMap();
        for (R01MChangesLabelOperation currOperation : packet.getOperations()) {
            if (currOperation.getOperationType() == 2 && currOperation.getTargetStructureOid().equals(currOperation.getSourceStructureOid()) && currOperation.getTargetRole() == currOperation.getSourceRole()) continue;
            if (operationsGroup.containsKey(currOperation.getLabelOid())) {
                ((List)operationsGroup.get(currOperation.getLabelOid())).add(currOperation);
                continue;
            }
            ArrayList<R01MChangesLabelOperation> operationsList = new ArrayList<R01MChangesLabelOperation>();
            operationsList.add(currOperation);
            operationsGroup.put(currOperation.getLabelOid(), operationsList);
        }
        ArrayList filteredOperations = new ArrayList();
        for (Map.Entry me : operationsGroup.entrySet()) {
            List operationsWithSameLabelOid = (List)me.getValue();
            if (operationsWithSameLabelOid.size() == 1) {
                if (((R01MChangesLabelOperation)operationsWithSameLabelOid.get(0)).getOperationType() == 5) continue;
                filteredOperations.add(operationsWithSameLabelOid.get(0));
                continue;
            }
            Collections.sort(operationsWithSameLabelOid);
            if (((R01MChangesLabelOperation)operationsWithSameLabelOid.get(operationsWithSameLabelOid.size() - 1)).getOperationType() == 3) {
                if (operationsWithSameLabelOid.size() >= 2) {
                    for (int i = operationsWithSameLabelOid.size() - 2; i >= 0; --i) {
                        R01MChangesLabelOperation currOperation = (R01MChangesLabelOperation)operationsWithSameLabelOid.get(i);
                        if (currOperation.getOperationType() != 2) continue;
                        currOperation.setOperationType(3);
                        currOperation.setTargetStructureOid(null);
                        currOperation.setTargetRole(0);
                        filteredOperations.add(currOperation);
                    }
                    filteredOperations.add(operationsWithSameLabelOid.get(operationsWithSameLabelOid.size() - 1));
                    continue;
                }
                filteredOperations.add(operationsWithSameLabelOid.get(0));
                continue;
            }
            ArrayList effectiveOperations = new ArrayList();
            for (int i = 0; i < operationsWithSameLabelOid.size(); ++i) {
                R01MChangesLabelOperation currOperation = (R01MChangesLabelOperation)operationsWithSameLabelOid.get(i);
                if (currOperation.getOperationType() == 1 && (effectiveOperations.size() > 0 || i < operationsWithSameLabelOid.size() - 1)) continue;
                if (currOperation.getOperationType() == 2) {
                    for (R01MChangesLabelOperation r01MChangesLabelOperation : effectiveOperations) {
                        if (r01MChangesLabelOperation.getOperationType() != 2) continue;
                        r01MChangesLabelOperation.setTargetStructureOid(currOperation.getTargetStructureOid());
                        r01MChangesLabelOperation.setTargetRole(currOperation.getTargetRole());
                    }
                }
                if (currOperation.getOperationType() == 5) {
                    void var10_16;
                    void var12_19;
                    R01MChangesLabelOperation r01MChangesLabelOperation = currOperation;
                    boolean isChanged = false;
                    Object var12_20 = null;
                    for (R01MChangesLabelOperation r01MChangesLabelOperation2 : effectiveOperations) {
                        if (r01MChangesLabelOperation2.getOperationType() != 3) continue;
                        R01MChangesLabelOperation r01MChangesLabelOperation3 = new R01MChangesLabelOperation();
                        r01MChangesLabelOperation3.setOrder(currOperation.getOrder());
                        r01MChangesLabelOperation3.setOperationOid(currOperation.getOperationOid());
                        r01MChangesLabelOperation3.setLabelOid(currOperation.getLabelOid());
                        r01MChangesLabelOperation3.setOperationType(2);
                        r01MChangesLabelOperation3.setSourceStructureOid(r01MChangesLabelOperation2.getSourceStructureOid());
                        r01MChangesLabelOperation3.setSourceRole(r01MChangesLabelOperation2.getSourceRole());
                        r01MChangesLabelOperation3.setTargetStructureOid(currOperation.getSourceStructureOid());
                        r01MChangesLabelOperation3.setTargetRole(currOperation.getSourceRole());
                        isChanged = true;
                        break;
                    }
                    if (!isChanged || var12_19 == null) continue;
                    effectiveOperations.remove(var12_19);
                    effectiveOperations.add(var10_16);
                    continue;
                }
                effectiveOperations.add(operationsWithSameLabelOid.get(i));
            }
            filteredOperations.addAll(effectiveOperations);
        }
        Collections.sort(filteredOperations);
        packet.setOperations(filteredOperations);
        if (DEBUG) {
            R01FLog.to((String)"r01e.operationsManager").info("OPERATIONS MANAGER >> Fin filtrado de las operaciones:");
            R01FLog.to((String)"r01e.operationsManager").info(packet.composeDebugInfo("\t").toString());
        }
    }

    private void _saveListener(String listener, String packetOid) throws R01MCatalogException {
        R01ESystemsCMPValue systemVO = new R01ESystemsCMPValue();
        systemVO.setSystemOid(listener);
        systemVO.setPacketOid(packetOid);
        try {
            R01ESystemsCMPLocal listenerCMP = R01ESystemsCMPUtil.getLocalHome().findByPrimaryKey(new R01ESystemsCMPPK(listener, packetOid));
            R01ESystemsCMPValue listenerObj = listenerCMP.getR01ESystemsCMPValue();
            listenerObj.setEndDate(null);
            listenerObj.setErrorMsg("");
            listenerObj.setState(0);
            listenerCMP.setR01ESystemsCMPValue(listenerObj);
        }
        catch (FinderException fndEx) {
            try {
                R01ESystemsCMPUtil.getLocalHome().create(systemVO);
            }
            catch (CreateException crtEx) {
                R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER (" + packetOid + ") > Error al registrar el sistema " + systemVO.getSystemOid() + ": " + crtEx.getMessage());
                crtEx.printStackTrace(System.out);
                throw new R01MCatalogException("Error al registrar el sistema " + systemVO.getSystemOid() + " con el paquete " + packetOid + ". Error:" + crtEx.getMessage());
            }
            catch (NamingException namEx) {
                R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER(" + packetOid + ") > Error al encontrar el home del CMP de listeners.");
                namEx.printStackTrace(System.out);
                throw new R01MCatalogException("Error al encontrar el home del CMP de listeners: " + namEx.getMessage());
            }
        }
        catch (NamingException namEx) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER(" + packetOid + ") > Error al encontrar el home del CMP de listeners.");
            namEx.printStackTrace(System.out);
            throw new R01MCatalogException("Error al encontrar el home del CMP de listeners: " + namEx.getMessage());
        }
    }

    private void _saveOperationGroup(String listener, String packetOid, R01MChangesLabelsOperationsGroup operationGroup) throws R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)"r01e.operationsManager").info("OPERATIONS MANAGER(" + packetOid + ") > Registrando la operaci\u00f3n (" + listener + "," + packetOid + "," + operationGroup.getObjectOid() + ")");
        }
        R01EOperationsResponseCMPValue operationVO = new R01EOperationsResponseCMPValue();
        operationVO.setSystemOid(listener);
        operationVO.setPacketOid(packetOid);
        operationVO.setObjectOid(operationGroup.getObjectOid());
        operationVO.setState(0);
        operationVO.setErrorMsg(null);
        operationVO.setXMLOperationsGroup(operationGroup.getOperationsGroupXML());
        try {
            R01EOperationsResponseCMPUtil.getLocalHome().create(operationVO);
        }
        catch (CreateException crtExc) {
            R01FLog.to((String)"r01e.operationsManager").severe("Error al crear la operaci\u00f3n (" + listener + "," + packetOid + "," + operationGroup.getObjectOid() + "). Error:" + crtExc.getMessage());
            crtExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error al crear la operaci\u00f3n (" + listener + "," + packetOid + "," + operationGroup.getObjectOid() + "). Error:" + crtExc.getMessage());
        }
        catch (NamingException namEx) {
            R01FLog.to((String)"r01e.operationsManager").severe("Error al encontrar el home del CMP de sistemas de procesado de operaciones. Error:" + namEx.getMessage());
            return;
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.operationsManager").info("OPERATIONS MANAGER(" + packetOid + ") > Registrando la operaci\u00f3n (" + listener + "," + packetOid + "," + operationGroup.getObjectOid() + ").");
        }
    }

    private Map _createOperationsGroup(R01MChangesLabelsPacket packet) throws R01MCatalogException {
        Map objectOperations;
        HashMap operationsGroups = new HashMap();
        if (packet.getOperations() != null && !packet.getOperations().isEmpty() && (objectOperations = R01MJMSUtils.createGroups((List)packet.getOperations())) != null && !objectOperations.isEmpty()) {
            for (Map.Entry me : objectOperations.entrySet()) {
                operationsGroups.put(me.getKey(), R01MJMSUtils.createGroupOperationsObject((int)packet.getType(), (List)((List)me.getValue())));
            }
        }
        return operationsGroups;
    }

    private void _sendPacketToJMS(R01MChangesLabelsPacket packet) throws R01MCatalogException {
        R01FLog.to((String)"r01e.operationsManager").info("OPERATIONS MANAGER >> El paquete " + packet.getPacketOid() + ", se va a PROCESAR >>>>>>>>>>>>>>>>>>>");
        try {
            R01ECatalogNotifierSLUtil.getLocalHome().create().sendPacket(packet);
        }
        catch (R01MJMSException jmsExc) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER > Error en el env\u00edo del paquete a la cola de mensajes.Error:" + jmsExc.getMessage());
            jmsExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error en el env\u00edo del paquete a la cola de mensajes.Error:" + jmsExc.getMessage());
        }
        catch (CreateException crtEx) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER > Error en el env\u00edo de notificaciones de recatalogaci\u00f3n. Error:" + crtEx.getMessage());
            crtEx.printStackTrace(System.out);
            throw new R01MCatalogException("Error en el env\u00edo de notificaciones de recatalogaci\u00f3n. Error:" + crtEx.getMessage());
        }
        catch (NamingException namExc) {
            R01FLog.to((String)"r01e.operationsManager").severe("OPERATIONS MANAGER > Error al encontrar el home de notificaciones de recatalogaci\u00f3n. Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error al encontrar el home de notificaciones de recatalogaci\u00f3n. Error:" + namExc.getMessage());
        }
        R01FLog.to((String)"r01e.operationsManager").info("OPERATIONS MANAGER >> El paquete " + packet.getPacketOid() + " ha sido enviado.");
    }

    private R01MChangesLabelOperation _doTraslateXMLOperation(R01MChangesLabelOperation operation, String system) throws R01MCatalogException {
        String sourceStructureName = "";
        String targetStructureName = "";
        String labelName = "";
        String objectName = "";
        if (!StringUtils.isEmptyString((String)operation.getSourceStructureOid())) {
            if (!this._structuresCache.containsKey(operation.getSourceStructureOid())) {
                sourceStructureName = this._loadStructureName(operation.getSourceStructureOid());
                if (sourceStructureName == null) {
                    sourceStructureName = " La estructura de identificador '" + operation.getSourceStructureOid() + "' no tiene nombre.";
                }
                this._structuresCache.put(operation.getSourceStructureOid(), sourceStructureName);
            } else {
                sourceStructureName = this._structuresCache.get(operation.getSourceStructureOid()).toString();
            }
        }
        if (!StringUtils.isEmptyString((String)operation.getTargetStructureOid())) {
            if (!this._structuresCache.containsKey(operation.getTargetStructureOid())) {
                targetStructureName = this._loadStructureName(operation.getTargetStructureOid());
                if (targetStructureName == null) {
                    targetStructureName = " La estructura de identificador '" + operation.getTargetStructureOid() + "' no tiene nombre.";
                }
                this._structuresCache.put(operation.getTargetStructureOid(), targetStructureName);
            } else {
                targetStructureName = this._structuresCache.get(operation.getTargetStructureOid()).toString();
            }
        }
        if (!StringUtils.isEmptyString((String)operation.getLabelOid())) {
            if (!this._labelsCache.containsKey(operation.getLabelOid())) {
                labelName = this._loadLabelName(operation.getLabelOid());
                if (labelName == null) {
                    labelName = " La etiqueta de identificador '" + operation.getLabelOid() + "' no tiene t\u00e9rmino.";
                }
                this._labelsCache.put(operation.getLabelOid(), labelName);
            } else {
                labelName = this._labelsCache.get(operation.getLabelOid()).toString();
            }
        }
        if (!StringUtils.isEmptyString((String)operation.getObjectOid())) {
            if (!StringUtils.isEmptyString((String)system)) {
                if (system.equalsIgnoreCase(R01MConstants.CONTENTMANAGER_APPCODE)) {
                    objectName = this._loadContentName(operation.getObjectOid());
                    if (objectName == null) {
                        objectName = "(Contenido de oid " + operation.getObjectOid() + " no encontrado)";
                    }
                } else if (system.equalsIgnoreCase(R01MConstants.PORTALMANAGER_APPCODE)) {
                    String[] pageData = this._loadPageData(operation.getObjectOid());
                    if (pageData != null) {
                        operation.setObjectParentOid(pageData[2]);
                        operation.setObjectInternalName(pageData[1]);
                        objectName = pageData[0];
                    } else {
                        objectName = "(P\u00e1gina de oid " + operation.getObjectOid() + " no encontrada)";
                    }
                }
            }
            operation.setObjectName(objectName);
        }
        StringBuffer description = new StringBuffer(39);
        switch (operation.getOperationType()) {
            case 2: {
                description.append("MOVER etiqueta ");
                description.append(labelName);
                description.append(" de la estructura ");
                description.append(sourceStructureName);
                description.append(" con rol ");
                description.append(operation.getSourceRole());
                description.append(" a la estructura ");
                description.append(targetStructureName);
                description.append(" rol ");
                description.append(operation.getTargetRole());
                if (operation.getObjectOid() != null) {
                    description.append(" en ");
                    description.append(objectName);
                }
                operation.setDescription(description.toString());
                break;
            }
            case 1: {
                description.append("CAMBIAR t\u00e9rmino a ");
                description.append(labelName);
                if (operation.getObjectOid() != null) {
                    description.append(" en ");
                    description.append(objectName);
                }
                operation.setDescription(description.toString());
                break;
            }
            case 4: {
                description.append("BORRAR etiqueta ");
                if (!"".equals(labelName)) {
                    description.append(labelName);
                } else {
                    description.append(operation.getLabelOid());
                }
                if (operation.getObjectOid() != null) {
                    description.append(" en ");
                    description.append(objectName);
                }
                operation.setDescription(description.toString());
                break;
            }
            case 3: {
                description.append("BORRAR etiqueta ");
                description.append(labelName);
                if (operation.getObjectOid() != null) {
                    description.append(" en ");
                    description.append(objectName);
                }
                operation.setDescription(description.toString());
                break;
            }
            case 5: {
                description.append("A\u00d1ADIR Etiqueta ");
                description.append(labelName);
                if (operation.getObjectOid() != null) {
                    description.append(" en ");
                    description.append(objectName);
                }
                operation.setDescription(description.toString());
                break;
            }
            case 6: {
                description.append("ELIMINAR Etiqueta ");
                description.append(labelName);
                if (operation.getObjectOid() != null) {
                    description.append(" en ");
                    description.append(objectName);
                }
                operation.setDescription(description.toString());
                break;
            }
            case -1: {
                description.append("******  Operacion desconocida *********");
                operation.setDescription(description.toString());
                break;
            }
        }
        return operation;
    }

    private String _loadContentName(String contentOid) {
        try {
            String sql = "SELECT NOMBRE_01 FROM R01D01T01 WHERE OID_01='" + contentOid + "'";
            List data = _qryExecContents.executeQuery(sql);
            String contentName = null;
            if (data != null) {
                Map rowMap = (Map)data.get(0);
                contentName = rowMap.get("NOMBRE_01").toString();
            }
            return contentName;
        }
        catch (SQLException sqlEx) {
            return null;
        }
    }

    private String[] _loadPageData(String pageOid) {
        try {
            String sql = "SELECT NOMBRE_01,INTERNAL_NAME_01,OID_17 FROM R01G01S01 WHERE OID_01='" + pageOid + "'";
            List data = _qryExecPortal.executeQuery(sql);
            String[] pageData = null;
            if (data != null) {
                Map rowMap = (Map)data.get(0);
                pageData = new String[]{rowMap.get("NOMBRE_01").toString(), rowMap.get("INTERNAL_NAME_01").toString(), rowMap.get("OID_17").toString()};
            }
            return pageData;
        }
        catch (SQLException sqlEx) {
            return null;
        }
    }

    private String _loadLabelName(String labelOid) {
        try {
            String sql = "SELECT VALOR_06 FROM R01E03S00,R01E06S00 WHERE GUID_03 = '" + labelOid + "' AND PK_03 = FK_03 AND IDIOMA_06='es'";
            List data = _qryExecLabels.executeQuery(sql);
            String labelTermES = null;
            if (data != null) {
                Map rowMap = (Map)data.get(0);
                labelTermES = rowMap.get("VALOR_06").toString();
            }
            return labelTermES;
        }
        catch (SQLException sqlEx) {
            return null;
        }
    }

    private String _loadStructureName(String structureOid) {
        try {
            String sql = "SELECT VALOR_08 FROM R01E08S00 WHERE ELEMENTO_GUID_08 = '" + structureOid + "' AND IDIOMA_08='es'";
            List data = _qryExecLabels.executeQuery(sql);
            String structureName = null;
            if (data != null) {
                Map rowMap = (Map)data.get(0);
                structureName = rowMap.get("VALOR_08").toString();
            }
            return structureName;
        }
        catch (SQLException sqlEx) {
            return null;
        }
    }
}

