/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01e.services;

import com.ejie.r01e.catalog.ejb.bags.R01EBagEntityCMPUtil;
import com.ejie.r01e.catalog.ejb.labels.R01ELabelEntityCMPLocal;
import com.ejie.r01e.catalog.ejb.labels.R01ELabelEntityCMPPK;
import com.ejie.r01e.catalog.ejb.labels.R01ELabelEntityCMPUtil;
import com.ejie.r01e.catalog.ejb.labels.R01ELabelEntityCMPValue;
import com.ejie.r01e.catalog.ejb.relations.R01ERelationEntityCMPLocal;
import com.ejie.r01e.catalog.ejb.relations.R01ERelationEntityCMPPK;
import com.ejie.r01e.catalog.ejb.relations.R01ERelationEntityCMPUtil;
import com.ejie.r01e.catalog.ejb.relations.R01ERelationEntityCMPValue;
import com.ejie.r01e.catalog.ejb.structuresdefinitions.R01EStructureDefinitionEntityCMPLocal;
import com.ejie.r01e.catalog.ejb.structuresdefinitions.R01EStructureDefinitionEntityCMPPK;
import com.ejie.r01e.catalog.ejb.structuresdefinitions.R01EStructureDefinitionEntityCMPUtil;
import com.ejie.r01e.catalog.ejb.terms.R01ETermEntityCMPLocal;
import com.ejie.r01e.catalog.ejb.terms.R01ETermEntityCMPUtil;
import com.ejie.r01e.catalog.ejb.terms.R01ETermEntityCMPValue;
import com.ejie.r01e.gestorejes.dbhelppers.dao.R01EDAOCoreModelObjsLoader;
import com.ejie.r01e.services.R01EBaseCatalogManager;
import com.ejie.r01e.services.R01EOperationsManager;
import com.ejie.r01e.structures.exceptions.R01ECatalogException;
import com.ejie.r01e.structures.exceptions.R01EElementNotFoundException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.config.objects.cataloguing.R01MChangesLabelOperation;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MCatalogElementNotFoundException;
import com.ejie.r01m.exceptions.R01MCatalogElementNotRemovableException;
import com.ejie.r01m.exceptions.R01MCatalogException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.cataloguing.structures.R01MLabel;
import com.ejie.r01m.objects.cataloguing.structures.R01MLabelSearchFilter;
import com.ejie.r01m.objects.cataloguing.structures.R01MRelation;
import com.ejie.r01m.objects.cataloguing.structures.R01MTerm;
import com.ejie.r01m.services.bzd.R01MCatalogLabelsBzd;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MDozerMappingUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import net.sf.dozer.util.mapping.MappingException;

public class R01ELabelsManager
extends R01EBaseCatalogManager
implements R01MCatalogLabelsBzd {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01e.manager").intValue() != Level.OFF.intValue();
    private transient R01MUserContext _userCtx = null;

    public R01ELabelsManager() {
    }

    public R01ELabelsManager(R01MUserContext userCtx) {
        this._userCtx = userCtx;
    }

    public R01MLabel doLoadLabel(String labelOid) throws R01MCatalogException {
        R01MLabel label;
        String opDesc = "Cargando la etiqueta con identificador " + labelOid;
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader labelLoader = new R01EDAOCoreModelObjsLoader();
        try {
            label = labelLoader.executeLoadLabel(labelOid);
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException(ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
        return label;
    }

    public R01MLabel doLoadLabel(int labelId) throws R01MCatalogException {
        R01MLabel label;
        String opDesc = "Cargando la etiqueta con identificador num\u00e9rico " + labelId;
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader labelLoader = new R01EDAOCoreModelObjsLoader();
        try {
            label = labelLoader.executeLoadLabel(labelId);
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException(ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
        return label;
    }

    public R01MLabel doLoadLabelByExtOID(String extOid) throws R01MCatalogException, R01MCatalogElementNotFoundException {
        R01MLabel label;
        String opDesc = "Cargando la etiqueta con identificador externo " + extOid;
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader labelLoader = new R01EDAOCoreModelObjsLoader();
        try {
            label = labelLoader.executeLoadLabelByExternalOid(extOid);
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException(ex.getMessage());
        }
        catch (R01EElementNotFoundException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogElementNotFoundException(ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
        return label;
    }

    public List doLoadOrderedLabels(String bagOid, String languageCode) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        List labels;
        String opDesc = "";
        if (DEBUG) {
            opDesc = bagOid != null ? "Carga ordenada alfabeticamente de las etiquetas de la bolsa " + bagOid + " seg\u00fan el idioma " + languageCode : "Carga ordenada alfabeticamente de las etiquetas de todas las bolsas segun el idioma " + languageCode;
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader labelLoader = new R01EDAOCoreModelObjsLoader();
        try {
            labels = labelLoader.executeLoadOrderedLabels(bagOid, languageCode);
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException(ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
        return labels;
    }

    public List doLoadSearchLabel(R01MLabelSearchFilter searchCriteriaObj) throws R01MCatalogException {
        List relations;
        String opDesc = "Buscando etiquetas con el texto " + searchCriteriaObj.getTermText() + " en idioma " + searchCriteriaObj.getLanguageId();
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init): " + opDesc);
        }
        R01EDAOCoreModelObjsLoader labelLoader = new R01EDAOCoreModelObjsLoader();
        try {
            relations = labelLoader.executeLoadSearchLabel(searchCriteriaObj);
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException(ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
        return relations;
    }

    public List doLoadLabelInStructureWithRole(String structureOid, String labelOid, int role) throws R01MCatalogException {
        List relations;
        String opDesc = "Buscando label: " + labelOid + " en la estructura " + structureOid + " con el rol " + role;
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init): " + opDesc);
        }
        R01EDAOCoreModelObjsLoader labelLoader = new R01EDAOCoreModelObjsLoader();
        try {
            relations = labelLoader.executeLoadLabelInStructureWithRole(structureOid, labelOid, role);
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException(ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
        return relations;
    }

    public List doLoadLabels(String bagOid) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        List labels;
        String opDesc = "Cargando las etiquetas de la bolsa " + bagOid;
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader labelLoader = new R01EDAOCoreModelObjsLoader();
        try {
            labels = labelLoader.executeLoadLabels(bagOid);
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException(ex.getMessage());
        }
        catch (R01EElementNotFoundException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogElementNotFoundException(ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
        return labels;
    }

    public int doSaveLabel(R01MUserContext userCtx, String bagOid, R01MLabel label) throws R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogException {
        R01ELabelEntityCMPLocal labelCMP;
        this._userCtx = userCtx;
        if (!super.validateContext(this._userCtx, bagOid)) {
            throw new R01MSecurityException("El usuario no tiene acceso a la bolsa " + bagOid);
        }
        String opDesc = "Creando/actualizando la etiqueta " + label.getOid() + " de la bolsa " + bagOid;
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        try {
            labelCMP = R01ELabelEntityCMPUtil.getLocalHome().findByLabelGUID(label.getOid());
        }
        catch (FinderException fndExc) {
            int labelId = this._execCreateLabel(label);
            if (DEBUG) {
                R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
            }
            return labelId;
        }
        catch (NamingException namExc) {
            R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de etiquetas.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se encuentra el CMP de etiquetas.Error:" + namExc.getMessage());
        }
        this._execUpdateLabel(label, labelCMP);
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
        return label.getLabelId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doRemoveLabel(R01MUserContext userCtx, String bagOid, String labelOid) throws R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogException, R01MCatalogElementNotRemovableException {
        this._userCtx = userCtx;
        if (!super.validateContext(this._userCtx, bagOid)) {
            throw new R01MSecurityException("El usuario no tiene acceso a la bolsa " + bagOid);
        }
        String opDesc = "Eliminando la etiqueta " + labelOid + " de la bolsa " + bagOid;
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        if (!this._checkLabelRemoval(labelOid)) {
            throw new R01MCatalogElementNotRemovableException("NO se permite borrar la etiqueta, revisar las relaciones.");
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").finer("se van a borrar relaciones de similitud con la etiqueta");
        }
        try {
            Collection relations = R01ERelationEntityCMPUtil.getLocalHome().findLabelRelations(labelOid, 'R');
            if (relations != null && !relations.isEmpty()) {
                for (R01ERelationEntityCMPLocal relationEntity : relations) {
                    try {
                        relationEntity.remove();
                    }
                    catch (RemoveException removExc) {
                        throw new R01MCatalogElementNotRemovableException("Error eliminando las relaciones de la etiqueta.Error:" + removExc.getMessage());
                    }
                }
            }
        }
        catch (FinderException fndExc) {
        }
        catch (NamingException namExc) {
            R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de relaciones.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se encuentra el CMP de relaciones.Error:" + namExc.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").finer("Borrando la etiqueta " + labelOid);
        }
        try {
            R01ELabelEntityCMPUtil.getLocalHome().findByLabelGUID(labelOid).remove();
        }
        catch (FinderException fndExc) {
            R01FLog.to((String)"r01e.manager").severe("La etiqueta " + labelOid + " no existe.Error:" + fndExc.getMessage());
            fndExc.printStackTrace(System.out);
            throw new R01MCatalogElementNotFoundException("La etiqueta " + labelOid + " no existe.Error:" + fndExc.getMessage());
        }
        catch (NamingException namExc) {
            R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de etiquetas.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se encuentra el CMP de etiquetas.Error:" + namExc.getMessage());
        }
        catch (EJBException ejbExc) {
            R01FLog.to((String)"r01e.manager").severe("Error borrando la etiqueta " + labelOid + ".Error:" + ejbExc.getMessage());
            ejbExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error borrando la etiqueta " + labelOid + ".Error:" + ejbExc.getMessage());
        }
        catch (RemoveException rmExc) {
            R01FLog.to((String)"r01e.manager").severe("No se puede borrar la etiqueta " + labelOid + ".Error:" + rmExc.getMessage());
            rmExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se puede borrar la etiqueta " + labelOid + ".Error:" + rmExc.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
    }

    public void doMoveLabelToBag(R01MUserContext userCtx, String labelOid, String bagOid, String newBagOid) throws R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogException {
        int newBagId;
        this._userCtx = userCtx;
        if (!super.validateContext(this._userCtx, bagOid)) {
            throw new R01MSecurityException("El usuario no tiene acceso a la bolsa " + bagOid);
        }
        if (!super.validateContext(this._userCtx, newBagOid)) {
            throw new R01MSecurityException("El usuario no tiene acceso a la bolsa " + newBagOid);
        }
        String opDesc = "Mover la etiqueta " + labelOid + " de la bolsa " + bagOid + " a la bolsa " + newBagOid;
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        try {
            newBagId = R01EBagEntityCMPUtil.getLocalHome().findByBagGUID(newBagOid).getBagId();
        }
        catch (FinderException findExc) {
            R01FLog.to((String)"r01e.manager").severe("La bolsa  " + newBagOid + " no existe.Error:" + findExc.getMessage());
            findExc.printStackTrace(System.out);
            throw new R01MCatalogElementNotFoundException("La bolsa  " + newBagOid + " no existe.Error:" + findExc.getMessage());
        }
        catch (NamingException namExc) {
            R01FLog.to((String)"r01e.manager").severe("Error al encontrar el CMP de bolsas.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error al encontrar el CMP de bolsas.Error:" + namExc.getMessage());
        }
        try {
            R01ELabelEntityCMPUtil.getLocalHome().findByLabelGUID(labelOid).setBagId(newBagId);
        }
        catch (FinderException findExc) {
            R01FLog.to((String)"r01e.manager").severe("No existe la etiqueta " + labelOid + ".Error:" + findExc.getMessage());
            findExc.printStackTrace(System.out);
            throw new R01MCatalogElementNotFoundException("No existe la etiqueta " + labelOid + ".Error:" + findExc.getMessage());
        }
        catch (NamingException namExc) {
            R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de etiquetas.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error al encontrar el CMP etiquetas.Error:" + namExc.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
    }

    public int doAddRelation(R01MUserContext userCtx, String bagOid, R01MRelation relation, int role) throws R01MSecurityException, R01MCatalogException {
        int relationId;
        R01ERelationEntityCMPValue relationVO;
        if (!super.validateContext(userCtx, bagOid)) {
            throw new R01MSecurityException("El usuario no tiene acceso a la bolsa " + bagOid);
        }
        String opDesc = "A\u00f1adiendo la relacion " + relation.getRelationGuid() + " para la estructura de id interno " + relation.getStructureId() + " en la bolsa " + bagOid;
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader structureLoader = new R01EDAOCoreModelObjsLoader();
        try {
            int maxOrder = structureLoader.getMaxOrderRelationList(relation.getStructureId(), relation.getRelationParentId());
            relation.setOrder(++maxOrder);
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException((Exception)((Object)ex));
        }
        try {
            relationVO = (R01ERelationEntityCMPValue)R01MDozerMappingUtils.map((String)R01MConstants.STRUCTURES_APPCODE, (Object)relation, R01ERelationEntityCMPValue.class);
            if (relationVO.getRelationType() == 'R') {
                relationVO.setStructureId(null);
            }
        }
        catch (MappingException mapEx) {
            R01FLog.to((String)"r01e.operationsManager").severe("Structures MANAGER (" + relation.getRelationId() + ") >  Error al mapear los miembros del objeto relacion al Value Object correspondiente.");
            mapEx.printStackTrace(System.out);
            throw new R01MCatalogException("Error al mapear los miembros del objeto relacion al Value Object correspondiente: " + mapEx.getMessage());
        }
        catch (Exception e) {
            R01FLog.to((String)"r01e.operationsManager").severe("Structures MANAGER (" + relation.getRelationId() + ") >  Ha fallado el Mapeo de la relacion : " + e.getMessage());
            e.printStackTrace(System.out);
            throw new R01MCatalogException("Error al mapear los miembros del objeto relacion al Value Object correspondiente: " + e.getMessage());
        }
        catch (Throwable thEx) {
            thEx.printStackTrace(System.out);
            R01FLog.to((String)"r01e.operationsManager").severe("Structures MANAGER (" + relation.getRelationId() + ") >  Ha fallado el Mapeo de la relacion : " + thEx.getMessage());
            throw new R01MCatalogException("Error al mapear los miembros del objeto relacion al Value Object correspondiente.");
        }
        try {
            relationId = R01ERelationEntityCMPUtil.getLocalHome().create(relationVO).getRelationId();
        }
        catch (CreateException crtExc) {
            R01FLog.to((String)"r01e.manager").severe("No se puede crear la relacion " + relation.getRelationId() + ".Error:" + crtExc.getMessage());
            crtExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se puede crear la relacion " + relation.getRelationId() + ".Error:" + crtExc.getMessage());
        }
        catch (NamingException namExc) {
            R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de relaciones.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se encuentra el CMP de relaciones.Error:" + namExc.getMessage());
        }
        if (relation.getRelationType() == 'H') {
            R01ELabelEntityCMPLocal label = null;
            R01EStructureDefinitionEntityCMPLocal structure = null;
            try {
                label = R01ELabelEntityCMPUtil.getLocalHome().findByPrimaryKey(new R01ELabelEntityCMPPK(relation.getLabelId2()));
            }
            catch (FinderException fndExc) {
                R01FLog.to((String)"r01e.manager").severe("No se encuentra la etiqueta " + relation.getLabelId2() + ".Error:" + fndExc.getMessage());
                fndExc.printStackTrace(System.out);
                throw new R01MCatalogException("No se encuentra la etiqueta " + relation.getLabelId2() + ".Error:" + fndExc.getMessage());
            }
            catch (NamingException namExc) {
                R01FLog.to((String)"r01e.manager").severe("Error al encontrar el CMP de la etiqueta " + relation.getLabelId2() + ".Error:" + namExc.getMessage());
                namExc.printStackTrace(System.out);
                throw new R01MCatalogException("Error al encontrar el CMP de la etiqueta " + relation.getLabelId2() + ".Error:" + namExc.getMessage());
            }
            try {
                structure = R01EStructureDefinitionEntityCMPUtil.getLocalHome().findByPrimaryKey(new R01EStructureDefinitionEntityCMPPK(relation.getStructureId()));
            }
            catch (FinderException fndExc) {
                R01FLog.to((String)"r01e.manager").severe("No se encuentra la estructura " + relation.getStructureId() + ".Error:" + fndExc.getMessage());
                fndExc.printStackTrace(System.out);
                throw new R01MCatalogException("No se encuentra la estructura " + relation.getStructureId() + ".Error:" + fndExc.getMessage());
            }
            catch (NamingException namExc) {
                R01FLog.to((String)"r01e.manager").severe("Error al encontrar el CMP de la estructura " + relation.getStructureId() + ".Error:" + namExc.getMessage());
                namExc.printStackTrace(System.out);
                throw new R01MCatalogException("Error al encontrar el CMP de la estructura " + relation.getStructureId() + ".Error:" + namExc.getMessage());
            }
            if (label != null) {
                R01EOperationsManager opManager = new R01EOperationsManager();
                R01MChangesLabelOperation operation = new R01MChangesLabelOperation();
                operation.setLabelOid(label.getLabelGUID());
                operation.setSourceRole(role);
                operation.setSourceStructureOid(structure.getStructureGUID());
                operation.setOperationType(5);
                opManager.doAccountNewLabelOperation(userCtx, operation);
            }
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
        return relationId;
    }

    public int doAddBidirectionalRelation(R01MUserContext userCtx, String bagOid, R01MRelation relation, int role) throws R01MSecurityException, R01MCatalogException {
        int relationId;
        R01ERelationEntityCMPValue relationVO;
        if (!super.validateContext(userCtx, bagOid)) {
            throw new R01MSecurityException("El usuario no tiene acceso a la bolsa " + bagOid);
        }
        String opDesc = "A\u00f1adiendo la relacion " + relation.getRelationGuid() + " para la estructura de id interno " + relation.getStructureId() + " en la bolsa " + bagOid;
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader relationLoader = new R01EDAOCoreModelObjsLoader();
        R01MRelation bidirectRelation = null;
        try {
            bidirectRelation = relationLoader.executeLoadSimilarRelation(relation.getLabelId2(), relation.getLabelId1());
        }
        catch (R01ECatalogException ex) {
        }
        catch (R01EElementNotFoundException ex) {
            // empty catch block
        }
        if (bidirectRelation != null) {
            bidirectRelation = null;
        } else {
            bidirectRelation = new R01MRelation();
            bidirectRelation.setLabelId1(relation.getLabelId2());
            bidirectRelation.setLabelId2(relation.getLabelId1());
            bidirectRelation.setOrder(1);
            bidirectRelation.setRelationType('R');
        }
        R01ERelationEntityCMPValue bidirectRelationVO = null;
        try {
            relationVO = (R01ERelationEntityCMPValue)R01MDozerMappingUtils.map((String)R01MConstants.STRUCTURES_APPCODE, (Object)relation, R01ERelationEntityCMPValue.class);
            relationVO.setStructureId(null);
            if (bidirectRelation != null) {
                bidirectRelationVO = (R01ERelationEntityCMPValue)R01MDozerMappingUtils.map((String)R01MConstants.STRUCTURES_APPCODE, (Object)bidirectRelation, R01ERelationEntityCMPValue.class);
                bidirectRelationVO.setStructureId(null);
            }
        }
        catch (MappingException mapEx) {
            R01FLog.to((String)"r01e.operationsManager").severe("Structures MANAGER (" + relation.getRelationId() + ") >  Error al mapear los miembros del objeto relacion al Value Object correspondiente.");
            throw new R01MCatalogException("Error al mapear los miembros del objeto relacion al Value Object correspondiente: " + mapEx.getMessage());
        }
        catch (Exception e) {
            R01FLog.to((String)"r01e.operationsManager").severe("Structures MANAGER (" + relation.getRelationId() + ") >  Ha fallado el Mapeo de la relacion : " + e.getMessage());
            throw new R01MCatalogException("Error al mapear los miembros del objeto relacion al Value Object correspondiente: " + e.getMessage());
        }
        catch (Throwable thEx) {
            R01FLog.to((String)"r01e.operationsManager").severe("Structures MANAGER (" + relation.getRelationId() + ") >  Ha fallado el Mapeo de la relacion : " + thEx.getMessage());
            throw new R01MCatalogException("Error al mapear los miembros del objeto relacion al Value Object correspondiente.");
        }
        try {
            relationId = R01ERelationEntityCMPUtil.getLocalHome().create(relationVO).getRelationId();
            if (bidirectRelationVO != null) {
                R01ERelationEntityCMPUtil.getLocalHome().create(bidirectRelationVO);
            }
        }
        catch (CreateException crtExc) {
            R01FLog.to((String)"r01e.manager").severe("No se puede crear la relacion " + relation.getRelationId() + ".Error:" + crtExc.getMessage());
            throw new R01MCatalogException("No se puede crear la relacion " + relation.getRelationId() + ".Error:" + crtExc.getMessage());
        }
        catch (NamingException namExc) {
            R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de relaciones.Error:" + namExc.getMessage());
            throw new R01MCatalogException("No se encuentra el CMP de relaciones.Error:" + namExc.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
        return relationId;
    }

    public void doRemoveRelation(R01MUserContext userCtx, String bagOid, int role, int relationId) throws R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogException {
        if (!super.validateContext(userCtx, bagOid)) {
            throw new R01MSecurityException("El usuario no tiene acceso a la bolsa " + bagOid);
        }
        R01ELabelEntityCMPLocal label = null;
        R01ERelationEntityCMPLocal relCMPLocal2 = null;
        R01EStructureDefinitionEntityCMPLocal structure = null;
        ArrayList operations = null;
        String opDesc = "Borrando la relacion de id interno " + relationId + " en la bolsa " + bagOid;
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("doRemoveRelation (init):" + opDesc);
        }
        try {
            relCMPLocal2 = R01ERelationEntityCMPUtil.getLocalHome().findByPrimaryKey(new R01ERelationEntityCMPPK(relationId));
        }
        catch (FinderException fndExc) {
            R01FLog.to((String)"r01e.manager").severe("No se encuentra la relaci\u00f3n " + relationId + ".Error:" + fndExc.getMessage());
            fndExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se encuentra la relaci\u00f3n " + relationId + ".Error:" + fndExc.getMessage());
        }
        catch (NamingException namExc) {
            R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de relaciones.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se encuentra el CMP de relaciones.Error:" + namExc.getMessage());
        }
        R01MRelation bidirectionalRelation = null;
        int relationParentId = relCMPLocal2.getRelationParentId();
        char relationType = relCMPLocal2.getRelationType();
        try {
            try {
                label = R01ELabelEntityCMPUtil.getLocalHome().findByPrimaryKey(new R01ELabelEntityCMPPK(relCMPLocal2.getLabelId2()));
            }
            catch (FinderException fndExc) {
                R01FLog.to((String)"r01e.manager").severe("No se encuentra la etiqueta " + relCMPLocal2.getLabelId2() + ".Error:" + fndExc.getMessage());
                fndExc.printStackTrace(System.out);
                throw new R01MCatalogException("No se encuentra la etiqueta " + relCMPLocal2.getLabelId2() + ".Error:" + fndExc.getMessage());
            }
            catch (NamingException namExc) {
                R01FLog.to((String)"r01e.manager").severe("Error al encontrar el CMP de la etiqueta " + relCMPLocal2.getLabelId2() + ".Error:" + namExc.getMessage());
                namExc.printStackTrace(System.out);
                throw new R01MCatalogException("Error al encontrar el CMP de la etiqueta " + relCMPLocal2.getLabelId2() + ".Error:" + namExc.getMessage());
            }
            R01EDAOCoreModelObjsLoader relationLoader = new R01EDAOCoreModelObjsLoader();
            try {
                bidirectionalRelation = relationLoader.executeLoadSimilarRelation(relCMPLocal2.getLabelId2(), relCMPLocal2.getLabelId1());
            }
            catch (R01ECatalogException ex) {
            }
            catch (R01EElementNotFoundException ex) {
                // empty catch block
            }
            int structureId = 0;
            if (relationType == 'H') {
                structureId = Integer.parseInt(relCMPLocal2.getStructureId().toString());
                structure = R01EStructureDefinitionEntityCMPUtil.getLocalHome().findByPrimaryKey(new R01EStructureDefinitionEntityCMPPK(structureId));
                List childRelations = this.doLoadChildRelations(structure.getStructureGUID(), relationId);
                if (childRelations != null && !childRelations.isEmpty()) {
                    operations = new ArrayList();
                    this._removeRelations(operations, childRelations, structure.getStructureGUID(), role + 1);
                }
            }
            relCMPLocal2.remove();
            if (bidirectionalRelation != null) {
                try {
                    R01ERelationEntityCMPLocal relBidirecCMPLocal = R01ERelationEntityCMPUtil.getLocalHome().findByPrimaryKey(new R01ERelationEntityCMPPK(bidirectionalRelation.getRelationId()));
                    relBidirecCMPLocal.remove();
                }
                catch (FinderException fndExc) {
                    R01FLog.to((String)"r01e.manager").severe("No se encuentra la relaci\u00f3n " + relationId + ".Error:" + fndExc.getMessage());
                    throw new R01MCatalogException("No se encuentra la relaci\u00f3n " + relationId + ".Error:" + fndExc.getMessage());
                }
                catch (NamingException namExc) {
                    R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de relaciones.Error:" + namExc.getMessage());
                    throw new R01MCatalogException("No se encuentra el CMP de relaciones.Error:" + namExc.getMessage());
                }
            }
            if (relationType == 'H') {
                Collection relations = R01ERelationEntityCMPUtil.getLocalHome().findByLabelChildRelationsByPkParent(structureId, relationParentId);
                int order = 1;
                for (R01ERelationEntityCMPLocal relCMPLocal2 : relations) {
                    relCMPLocal2.setOrder(order);
                    ++order;
                }
            }
        }
        catch (FinderException ignore) {
        }
        catch (NamingException namExc) {
            R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de relaciones.Error:" + namExc.getMessage());
            throw new R01MCatalogException("No se encuentra el CMP de relaciones..Error:" + namExc.getMessage());
        }
        catch (EJBException ejbExc) {
            R01FLog.to((String)"r01e.manager").severe("Error borrando la relacion de jerarqu\u00eda " + relationId + ".Error:" + ejbExc.getMessage());
            throw new R01MCatalogException("Error borrando la relacion de jerarqu\u00eda " + relationId + ".Error:" + ejbExc.getMessage());
        }
        catch (RemoveException rmExc) {
            R01FLog.to((String)"r01e.manager").severe("No se puede borrar la relacion de jerarqu\u00eda " + relationId + ".Error:" + rmExc.getMessage());
            throw new R01MCatalogException("No se puede borrar la relacion de jerarqu\u00eda" + relationId + ".Error:" + rmExc.getMessage());
        }
        if (relationType == 'H') {
            R01EOperationsManager opManager = new R01EOperationsManager();
            R01MChangesLabelOperation operation = new R01MChangesLabelOperation();
            operation.setLabelOid(label.getLabelGUID());
            operation.setSourceRole(role);
            operation.setSourceStructureOid(structure.getStructureGUID());
            operation.setOperationType(3);
            opManager.doAccountNewLabelOperation(userCtx, operation);
            if (operations != null && !operations.isEmpty()) {
                for (R01MChangesLabelOperation currOperation : operations) {
                    opManager.doAccountNewLabelOperation(userCtx, currOperation);
                }
            }
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("doRemoveRelation (end):" + opDesc);
        }
    }

    public void doUpdateOrderRelations(R01MUserContext userCtx, String bagOid, List relations) throws R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogException {
        if (!super.validateContext(userCtx, bagOid)) {
            throw new R01MSecurityException("El usuario no tiene acceso a la bolsa " + bagOid);
        }
        String opDesc = "Actualizando el orden de las relaciones en la bolsa " + bagOid;
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        if (relations != null && !relations.isEmpty()) {
            for (int i = 0; i < relations.size(); ++i) {
                R01EStructureDefinitionEntityCMPLocal structureDef;
                R01MRelation relation = (R01MRelation)relations.get(i);
                try {
                    structureDef = R01EStructureDefinitionEntityCMPUtil.getLocalHome().findByStructureId(relation.getStructureId());
                }
                catch (FinderException fndExc) {
                    R01FLog.to((String)"r01e.manager").info("No existe la estructura " + relation.getStructureId() + ".Error:" + fndExc.getMessage());
                    fndExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No existe la estructura " + relation.getStructureId() + ".Error:" + fndExc.getMessage());
                }
                catch (NamingException namExc) {
                    R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de estructuras.Error:" + namExc.getMessage());
                    namExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No se encuentra el CMP de estructuras.Error:" + namExc.getMessage());
                }
                try {
                    R01ERelationEntityCMPUtil.getLocalHome().findByStructureRelationId(structureDef.getStructureId(), relation.getRelationId()).setOrder(relation.getOrder());
                    continue;
                }
                catch (NumberFormatException numExc) {
                    R01FLog.to((String)"r01e.manager").info("El valor de la relaci\u00f3n " + relation.getRelationId() + " o del orden " + relation.getOrder() + " no es num\u00e9rico.Error:" + numExc.getMessage());
                    numExc.printStackTrace(System.out);
                    throw new R01MCatalogException("El valor de la relaci\u00f3n " + relation.getRelationId() + " o del orden " + relation.getOrder() + " no es num\u00e9rico.Error:" + numExc.getMessage());
                }
                catch (FinderException fndExc) {
                    R01FLog.to((String)"r01e.manager").info("No existe la relaci\u00f3n " + relation.getRelationId() + ".Error:" + fndExc.getMessage());
                    fndExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No existe la relaci\u00f3n " + relation.getRelationId() + ".Error:" + fndExc.getMessage());
                }
                catch (NamingException namExc) {
                    R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de relaciones.Error:" + namExc.getMessage());
                    namExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No se encuentra el CMP de relaciones.Error:" + namExc.getMessage());
                }
            }
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
    }

    public List doLoadChildRelations(String structureOid, int relationId) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        return this.doLoadChildRelations(structureOid, relationId, R01MConstants.DEFAULT_LANG);
    }

    public List doLoadChildRelations(String structureOid, int relationId, String languageCode) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        StringBuffer opDesc = new StringBuffer(82);
        opDesc.append("Carga de las relacciones hijas de un nodo para la estructura '");
        opDesc.append(structureOid);
        opDesc.append("', relacion ");
        opDesc.append(relationId);
        opDesc.append(",idioma ");
        opDesc.append(languageCode);
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader structureLoader = new R01EDAOCoreModelObjsLoader();
        List childRelations = null;
        try {
            childRelations = structureLoader.executeLoadRelations(structureOid, relationId, languageCode);
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException(ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
        return childRelations;
    }

    public List doLoadChildren(List nodes, boolean ordered) throws R01MCatalogException, R01MCatalogElementNotFoundException {
        List children;
        String opDesc = "Carga de los hijos de los nodos.";
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader structureLoader = new R01EDAOCoreModelObjsLoader();
        try {
            children = structureLoader.executeLoadChildren(nodes, ordered);
        }
        catch (R01EElementNotFoundException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogElementNotFoundException(ex.getMessage());
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException(ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
        return children;
    }

    public void doMoveLabel(R01MUserContext userCtx, String bagOid, String structureGuid, String labelGuid, int relationId, int role, String targetStructureGuid, int targetStructureId, int targetLabelId, int targetRelationId, int targetRole) throws R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogException {
        R01ELabelsManager labelManager;
        List childRelations;
        R01ERelationEntityCMPLocal relationEntityCMP;
        if (!super.validateContext(userCtx, bagOid)) {
            throw new R01MSecurityException("El usuario no tiene acceso a la bolsa " + bagOid);
        }
        String opDesc = "Moviendo la etiqueta " + labelGuid + " de la bolsa " + bagOid + " desde la estructura " + structureGuid + " a la estructura " + targetStructureGuid;
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        try {
            relationEntityCMP = R01ERelationEntityCMPUtil.getLocalHome().findByPrimaryKey(new R01ERelationEntityCMPPK(relationId));
        }
        catch (FinderException findExc) {
            R01FLog.to((String)"r01e.manager").severe("No se encuentra la relaci\u00f3n de etiquetas  " + relationId + ".Error:" + findExc.getMessage());
            findExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se encuentra la relaci\u00f3n de etiquetas  " + relationId + ".Error:" + findExc.getMessage());
        }
        catch (NumberFormatException numExc) {
            R01FLog.to((String)"r01e.manager").severe("La relaci\u00f3n  " + relationId + " no es un valor num\u00e9rico.Error:" + numExc.getMessage());
            numExc.printStackTrace(System.out);
            throw new R01MCatalogException("La relaci\u00f3n  " + relationId + " no es un valor num\u00e9rico.Error:" + numExc.getMessage());
        }
        catch (NamingException namExc) {
            R01FLog.to((String)"r01e.manager").severe("Error al encontrar el CMP de la relaci\u00f3n de etiquetas " + relationId + ".Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error al encontrar el CMP de la relaci\u00f3n de etiquetas " + relationId + ".Error:" + namExc.getMessage());
        }
        if (!structureGuid.equals(targetStructureGuid)) {
            relationEntityCMP.setStructureId(new Integer(targetStructureId));
        }
        relationEntityCMP.setRelationParentId(targetRelationId);
        relationEntityCMP.setLabelId1(targetLabelId);
        int targetRoleAux = targetRole + 1;
        ArrayList operations = null;
        boolean bChangeStructure = false;
        if (!structureGuid.equals(targetStructureGuid)) {
            bChangeStructure = true;
        }
        if ((childRelations = (labelManager = new R01ELabelsManager()).doLoadChildRelations(structureGuid, relationId)) != null && !childRelations.isEmpty()) {
            operations = new ArrayList();
            this._updateStructureMoveLabels(operations, childRelations, structureGuid, targetStructureGuid, targetStructureId, role + 1, targetRoleAux + 1, bChangeStructure);
        }
        R01EOperationsManager opManager = new R01EOperationsManager();
        R01MChangesLabelOperation operation = new R01MChangesLabelOperation();
        operation.setLabelOid(labelGuid);
        operation.setSourceStructureOid(structureGuid);
        operation.setTargetStructureOid(targetStructureGuid);
        operation.setSourceRole(role);
        operation.setTargetRole(targetRoleAux);
        operation.setOperationType(2);
        opManager.doAccountNewLabelOperation(userCtx, operation);
        if (operations != null && !operations.isEmpty()) {
            for (R01MChangesLabelOperation currOperation : operations) {
                opManager.doAccountNewLabelOperation(userCtx, currOperation);
            }
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
    }

    public List doLoadSimilarLabels(String labelGuid) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        List similarLabels;
        String opDesc = "Carga de las etiquetas similares a " + labelGuid;
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader structureLoader = new R01EDAOCoreModelObjsLoader();
        try {
            similarLabels = structureLoader.executeLoadSimilarLabels(labelGuid);
        }
        catch (R01EElementNotFoundException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogElementNotFoundException(ex.getMessage());
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException(ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
        return similarLabels;
    }

    public List doLoadSimilarRelations(String labelGuid) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        List similarRelations;
        String opDesc = "Carga de las etiquetas similares a " + labelGuid;
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader structureLoader = new R01EDAOCoreModelObjsLoader();
        try {
            similarRelations = structureLoader.executeLoadSimilarRelations(labelGuid);
        }
        catch (R01EElementNotFoundException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogElementNotFoundException(ex.getMessage());
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException(ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
        return similarRelations;
    }

    public List doLoadSimilarBidirectionalRelations(String labelGuid) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        List similarRelations;
        String opDesc = "Carga de las etiquetas similares a " + labelGuid;
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader structureLoader = new R01EDAOCoreModelObjsLoader();
        try {
            similarRelations = structureLoader.executeLoadSimilarBidirectionalRelations(labelGuid);
        }
        catch (R01EElementNotFoundException ex) {
            throw new R01MCatalogElementNotFoundException(ex.getMessage());
        }
        catch (R01ECatalogException ex) {
            throw new R01MCatalogException(ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01e.manager").info("ADMIN SERVER (end):" + opDesc);
        }
        return similarRelations;
    }

    private int _execCreateLabel(R01MLabel label) throws R01MCatalogException {
        int labelId;
        R01ELabelEntityCMPValue labelVO;
        try {
            labelVO = (R01ELabelEntityCMPValue)R01MDozerMappingUtils.map((String)R01MConstants.STRUCTURES_APPCODE, (Object)label, R01ELabelEntityCMPValue.class);
            labelVO.setLabelState('S');
        }
        catch (MappingException mapEx) {
            R01FLog.to((String)"r01e.operationsManager").severe("LABELS MANAGER (" + label.getOid() + ") >  Error al mapear los miembros del objeto etiqueta al Value Object correspondiente.");
            mapEx.printStackTrace(System.out);
            throw new R01MCatalogException("Error al mapear los miembros del objeto etiqueta al Value Object correspondiente: " + mapEx.getMessage());
        }
        catch (Exception e) {
            R01FLog.to((String)"r01e.operationsManager").severe("LABELS MANAGER (" + label.getOid() + ") >  Ha fallado el Mapeo de la etiqueta : " + e.getMessage());
            e.printStackTrace(System.out);
            throw new R01MCatalogException("Error al mapear los miembros del objeto etiqueta al Value Object correspondiente: " + e.getMessage());
        }
        catch (Throwable thEx) {
            thEx.printStackTrace(System.out);
            R01FLog.to((String)"r01e.operationsManager").severe("LABELS MANAGER (" + label.getOid() + ") >  Ha fallado el Mapeo de la etiqueta : " + thEx.getMessage());
            throw new R01MCatalogException("Error al mapear los miembros del objeto etiqueta al Value Object correspondiente.Error:" + thEx.getMessage());
        }
        try {
            labelId = R01ELabelEntityCMPUtil.getLocalHome().create(labelVO).getLabelId();
        }
        catch (CreateException crtExc) {
            R01FLog.to((String)"r01e.manager").info("No se puede crear la etiqueta " + label.getOid() + ".Error:" + crtExc.getMessage());
            crtExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se puede crear la etiqueta " + label.getOid() + ".Error:" + crtExc.getMessage());
        }
        catch (NamingException namExc) {
            R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de etiquetas.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se encuentra el CMP de etiquetas.Error:" + namExc.getMessage());
        }
        if (label.getStandardizedTerms() != null && !label.getStandardizedTerms().isEmpty()) {
            Iterator eStandard = label.getStandardizedTerms().keySet().iterator();
            while (eStandard.hasNext()) {
                R01MTerm currTerm = (R01MTerm)label.getStandardizedTerms().get(eStandard.next());
                currTerm.setLabelId(labelId);
                this._insertNewTerm(currTerm);
            }
        }
        if (label.getLanguageSynonyms() != null && !label.getLanguageSynonyms().isEmpty()) {
            Iterator eSynonymous = label.getLanguageSynonyms().keySet().iterator();
            while (eSynonymous.hasNext()) {
                List vSynonymous = (List)label.getLanguageSynonyms().get(eSynonymous.next());
                if (vSynonymous == null || vSynonymous.isEmpty()) continue;
                for (R01MTerm currTerm : vSynonymous) {
                    currTerm.setLabelId(labelId);
                    currTerm.setType('N');
                    this._insertNewTerm(currTerm);
                }
            }
        }
        return labelId;
    }

    private void _execUpdateLabel(R01MLabel label, R01ELabelEntityCMPLocal labelCMP) throws R01MCatalogException {
        R01ELabelEntityCMPValue labelVO;
        boolean termChange = false;
        int standarsTotal = 0;
        if (label.getStandardizedTerms() != null && !label.getStandardizedTerms().isEmpty()) {
            standarsTotal = label.getStandardizedTerms().size();
        }
        try {
            labelVO = (R01ELabelEntityCMPValue)R01MDozerMappingUtils.map((String)R01MConstants.STRUCTURES_APPCODE, (Object)label, R01ELabelEntityCMPValue.class);
            labelVO.setLabelState('S');
        }
        catch (MappingException mapEx) {
            R01FLog.to((String)"r01e.operationsManager").severe("LABELS MANAGER (" + label.getOid() + ") >  Error al mapear los miembros del objeto etiqueta al Value Object correspondiente.");
            mapEx.printStackTrace(System.out);
            throw new R01MCatalogException("Error al mapear los miembros del objeto etiqueta al Value Object correspondiente: " + mapEx.getMessage());
        }
        catch (Exception e) {
            R01FLog.to((String)"r01e.operationsManager").severe("LABELS MANAGER (" + label.getOid() + ") >  Ha fallado el Mapeo de la etiqueta : " + e.getMessage());
            e.printStackTrace(System.out);
            throw new R01MCatalogException("Error al mapear los miembros del objeto etiqueta al Value Object correspondiente: " + e.getMessage());
        }
        catch (Throwable thEx) {
            thEx.printStackTrace(System.out);
            R01FLog.to((String)"r01e.operationsManager").severe("LABELS MANAGER (" + label.getOid() + ") >  Ha fallado el Mapeo de la etiqueta : " + thEx.getMessage());
            throw new R01MCatalogException("Error al mapear los miembros del objeto etiqueta al Value Object correspondiente.Error:" + thEx.getMessage());
        }
        labelCMP.setR01ELabelEntityCMPValue(labelVO);
        try {
            Collection terms = R01ETermEntityCMPUtil.getLocalHome().findByLabelGUID(label.getOid());
            if (terms != null && !terms.isEmpty()) {
                for (R01ETermEntityCMPLocal termCMP : terms) {
                    try {
                        if (!termChange) {
                            if (label.getStandardizedTerms() != null && !label.getStandardizedTerms().isEmpty() && label.getStandardizedTerms().containsKey(termCMP.getLanguageId())) {
                                if (termCMP.getTermType() == 'S') {
                                    --standarsTotal;
                                    if (((R01MTerm)label.getStandardizedTerms().get(termCMP.getLanguageId())).getTermId() != termCMP.getTermId()) {
                                        termChange = true;
                                    }
                                }
                            } else {
                                termChange = true;
                            }
                        }
                        termCMP.remove();
                    }
                    catch (RemoveException rmExc) {
                        R01FLog.to((String)"r01e.manager").severe("No se puede borrar el t\u00e9rmino " + termCMP.getTermId() + ".Error:" + rmExc.getMessage());
                        rmExc.printStackTrace(System.out);
                        throw new R01MCatalogException("No se puede borrar el t\u00e9rmino " + termCMP.getTermId() + ".Error:" + rmExc.getMessage());
                    }
                }
            }
            if (!termChange && standarsTotal > 0) {
                termChange = true;
            }
        }
        catch (FinderException ignore) {
            R01FLog.to((String)"r01e.manager").severe("No se encuentran terminos");
        }
        catch (NamingException namExc) {
            R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de t\u00e9rminos.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se encuentra el CMP de t\u00e9rminos.", (Exception)namExc);
        }
        if (label.getStandardizedTerms() != null && !label.getStandardizedTerms().isEmpty()) {
            Iterator eStandard = label.getStandardizedTerms().keySet().iterator();
            while (eStandard.hasNext()) {
                R01MTerm currTerm = (R01MTerm)label.getStandardizedTerms().get(eStandard.next());
                currTerm.setLabelId(label.getLabelId());
                this._insertNewTerm(currTerm);
            }
        }
        if (label.getLanguageSynonyms() != null && !label.getLanguageSynonyms().isEmpty()) {
            Iterator eSynonymous = label.getLanguageSynonyms().keySet().iterator();
            while (eSynonymous.hasNext()) {
                List vSynonymous = (List)label.getLanguageSynonyms().get(eSynonymous.next());
                if (vSynonymous == null || vSynonymous.isEmpty()) continue;
                for (R01MTerm currTerm : vSynonymous) {
                    currTerm.setLabelId(label.getLabelId());
                    currTerm.setType('N');
                    this._insertNewTerm(currTerm);
                }
            }
        }
        if (termChange) {
            R01EOperationsManager opManager = new R01EOperationsManager();
            R01MChangesLabelOperation operation = new R01MChangesLabelOperation();
            operation.setLabelOid(label.getOid());
            operation.setOperationType(1);
            opManager.doAccountNewLabelOperation(this._userCtx, operation);
        }
    }

    private boolean _checkLabelRemoval(String labelGuid) throws R01MCatalogException {
        Collection relations;
        if (DEBUG) {
            R01FLog.to((String)"r01e.ejb").info("SE va a comprobar el borrado de la etiqueta: buscando relaciones");
        }
        try {
            relations = R01ERelationEntityCMPUtil.getLocalHome().findLabelRelations(labelGuid, 'H');
        }
        catch (FinderException fndExc) {
            return true;
        }
        catch (NamingException namExc) {
            R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de relaciones.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se encuentra el CMP de relaciones.Error:" + namExc.getMessage());
        }
        return relations != null && relations.isEmpty();
    }

    private void _insertNewTerm(R01MTerm termino) throws R01MCatalogException {
        R01ETermEntityCMPValue termVO;
        try {
            termVO = (R01ETermEntityCMPValue)R01MDozerMappingUtils.map((String)R01MConstants.STRUCTURES_APPCODE, (Object)termino, R01ETermEntityCMPValue.class);
        }
        catch (MappingException mapEx) {
            R01FLog.to((String)"r01e.operationsManager").severe("LABELS MANAGER (" + termino.getTermId() + ") >  Error al mapear los miembros del objeto termino al Value Object correspondiente.");
            mapEx.printStackTrace(System.out);
            throw new R01MCatalogException("Error al mapear los miembros del objeto termino al Value Object correspondiente: " + mapEx.getMessage());
        }
        catch (Exception e) {
            R01FLog.to((String)"r01e.operationsManager").severe("LABELS MANAGER (" + termino.getTermId() + ") >  Ha fallado el Mapeo del termino : " + e.getMessage());
            e.printStackTrace(System.out);
            throw new R01MCatalogException("Error al mapear los miembros del objeto termino al Value Object correspondiente: " + e.getMessage());
        }
        catch (Throwable thEx) {
            thEx.printStackTrace(System.out);
            R01FLog.to((String)"r01e.operationsManager").severe("LABELS MANAGER (" + termino.getTermId() + ") >  Ha fallado el Mapeo del termino : " + thEx.getMessage());
            throw new R01MCatalogException("Error al mapear los miembros del objeto termino al Value Object correspondiente.Error:" + thEx.getMessage());
        }
        try {
            R01ETermEntityCMPUtil.getLocalHome().create(termVO).setTermType(termino.getType());
        }
        catch (CreateException crtExc) {
            R01FLog.to((String)"r01e.manager").info("No se puede crear el termino " + termino.getTermId() + ".Error:" + crtExc.getMessage());
            crtExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se puede crear el termino " + termino.getTermId() + ".Error:" + crtExc.getMessage());
        }
        catch (NamingException namExc) {
            R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de terminos.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se encuentra el CMP de terminos.Error:" + namExc.getMessage());
        }
    }

    private List _removeRelations(List operations, List relations, String structureGuid, int role) throws R01MCatalogException, R01MCatalogElementNotFoundException {
        R01ELabelEntityCMPPK labelPK = new R01ELabelEntityCMPPK();
        R01ERelationEntityCMPPK relationPK = new R01ERelationEntityCMPPK();
        for (R01MRelation relation : relations) {
            List childRelations;
            R01ELabelEntityCMPLocal label;
            labelPK.setLabelId(relation.getLabelId2());
            try {
                label = R01ELabelEntityCMPUtil.getLocalHome().findByPrimaryKey(labelPK);
            }
            catch (FinderException fndExc) {
                R01FLog.to((String)"r01e.manager").severe("No se encuentra la etiqueta " + relation.getLabelId2() + ".Error:" + fndExc.getMessage());
                fndExc.printStackTrace(System.out);
                throw new R01MCatalogException("No se encuentra la etiqueta " + relation.getLabelId2() + ".Error:" + fndExc.getMessage());
            }
            catch (NamingException namExc) {
                R01FLog.to((String)"r01e.manager").severe("Error al encontrar el CMP de la etiqueta " + relation.getLabelId2() + ".Error:" + namExc.getMessage());
                namExc.printStackTrace(System.out);
                throw new R01MCatalogException("Error al encontrar el CMP de la etiqueta " + relation.getLabelId2() + ".Error:" + namExc.getMessage());
            }
            try {
                childRelations = this.doLoadChildRelations(structureGuid, relation.getRelationId());
            }
            catch (R01MCatalogElementNotFoundException catExc) {
                R01FLog.to((String)"r01e.manager").severe("No se encuentra la estructura " + structureGuid + ".Error:" + catExc.getMessage());
                catExc.printStackTrace(System.out);
                throw new R01MCatalogElementNotFoundException("No se encuentra la estructura " + structureGuid + ".Error:" + catExc.getMessage());
            }
            if (childRelations != null && !childRelations.isEmpty()) {
                this._removeRelations(operations, childRelations, structureGuid, role + 1);
            }
            relationPK.setRelationId(relation.getRelationId());
            try {
                R01ERelationEntityCMPUtil.getLocalHome().findByPrimaryKey(relationPK).remove();
            }
            catch (FinderException fndExc) {
                R01FLog.to((String)"r01e.manager").severe("No se encuentra la relaci\u00f3n " + relation.getRelationId() + ".Error:" + fndExc.getMessage());
                fndExc.printStackTrace(System.out);
                throw new R01MCatalogException("No se encuentra la relaci\u00f3n " + relation.getRelationId() + ".Error:" + fndExc.getMessage());
            }
            catch (NamingException namExc) {
                R01FLog.to((String)"r01e.manager").severe("No se encuentra el CMP de relaciones.Error:" + namExc.getMessage());
                namExc.printStackTrace(System.out);
                throw new R01MCatalogException("No se encuentra el CMP de relaciones.Error:" + namExc.getMessage());
            }
            catch (EJBException ejbExc) {
                R01FLog.to((String)"r01e.manager").severe("Error borrando la relacion de jerarqu\u00eda " + relation.getRelationId() + ".Error:" + ejbExc.getMessage());
                ejbExc.printStackTrace(System.out);
                throw new R01MCatalogException("Error borrando la relacion de jerarqu\u00eda " + relation.getRelationId() + ".Error:" + ejbExc.getMessage());
            }
            catch (RemoveException rmExc) {
                R01FLog.to((String)"r01e.manager").severe("No se puede borrar la relacion de jerarqu\u00eda " + relation.getRelationId() + ".Error:" + rmExc.getMessage());
                rmExc.printStackTrace(System.out);
                throw new R01MCatalogException("No se puede borrar la relacion de jerarqu\u00eda" + relation.getRelationId() + ".Error:" + rmExc.getMessage());
            }
            R01MChangesLabelOperation operation = new R01MChangesLabelOperation();
            operation.setLabelOid(label.getLabelGUID());
            operation.setSourceStructureOid(structureGuid);
            operation.setSourceRole(role);
            operation.setOperationType(3);
            operations.add(operation);
        }
        return operations;
    }

    private List _updateStructureMoveLabels(List operations, List relations, String structureGuid, String targetStructureGuid, int structureIdTarget, int role, int targetRole, boolean bChangeStructure) throws R01MCatalogException, R01MCatalogElementNotFoundException {
        R01ERelationEntityCMPPK relationPK = new R01ERelationEntityCMPPK();
        R01ELabelsManager labelManager = new R01ELabelsManager();
        for (R01MRelation rel : relations) {
            List childRelations;
            R01ELabelEntityCMPValue labelEntityVO;
            if (bChangeStructure) {
                try {
                    relationPK.setRelationId(rel.getRelationId());
                    R01ERelationEntityCMPUtil.getLocalHome().findByPrimaryKey(relationPK).setStructureId(Integer.valueOf("" + structureIdTarget));
                }
                catch (FinderException findExc) {
                    R01FLog.to((String)"r01e.manager").severe("No se encuentra la relaci\u00f3n de etiquetas  " + rel.getRelationId() + ".Error:" + findExc.getMessage());
                    findExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No se encuentra la relaci\u00f3n de etiquetas  " + rel.getRelationId() + ".Error:" + findExc.getMessage());
                }
                catch (NumberFormatException numExc) {
                    R01FLog.to((String)"r01e.manager").severe("La relaci\u00f3n  " + rel.getRelationId() + " no es un valor num\u00e9rico.Error:" + numExc.getMessage());
                    numExc.printStackTrace(System.out);
                    throw new R01MCatalogException("La relaci\u00f3n  " + rel.getRelationId() + " no es un valor num\u00e9rico.Error:" + numExc.getMessage());
                }
                catch (NamingException namExc) {
                    R01FLog.to((String)"r01e.manager").severe("Error al encontrar el CMP de la relaci\u00f3n de etiquetas " + rel.getRelationId() + ".Error:" + namExc.getMessage());
                    namExc.printStackTrace(System.out);
                    throw new R01MCatalogException("Error al encontrar el CMP de la relaci\u00f3n de etiquetas " + rel.getRelationId() + ".Error:" + namExc.getMessage());
                }
            }
            try {
                labelEntityVO = R01ELabelEntityCMPUtil.getLocalHome().findByLabelId(rel.getLabelId2()).getR01ELabelEntityCMPValue();
            }
            catch (FinderException fndExc) {
                R01FLog.to((String)"r01e.manager").severe("No se encuentra la etiqueta " + rel.getLabelId2() + ".Error:" + fndExc.getMessage());
                fndExc.printStackTrace(System.out);
                throw new R01MCatalogException("No se encuentra la etiqueta " + rel.getLabelId2() + ".Error:" + fndExc.getMessage());
            }
            catch (NamingException namExc) {
                R01FLog.to((String)"r01e.manager").severe("Error al encontrar el CMP de la etiqueta " + rel.getLabelId2() + ".Error:" + namExc.getMessage());
                namExc.printStackTrace(System.out);
                throw new R01MCatalogException("Error al encontrar el CMP de la etiqueta " + rel.getLabelId2() + ".Error:" + namExc.getMessage());
            }
            try {
                childRelations = labelManager.doLoadChildRelations(structureGuid, rel.getRelationId());
            }
            catch (R01MCatalogElementNotFoundException catExc) {
                R01FLog.to((String)"r01e.manager").severe("No se encuentra la estructura " + structureGuid + ".Error:" + catExc.getMessage());
                catExc.printStackTrace(System.out);
                throw new R01MCatalogElementNotFoundException("No se encuentra la estructura " + structureGuid + ".Error:" + catExc.getMessage());
            }
            if (childRelations != null && !childRelations.isEmpty()) {
                this._updateStructureMoveLabels(operations, childRelations, structureGuid, targetStructureGuid, structureIdTarget, role + 1, targetRole + 1, bChangeStructure);
            }
            R01MChangesLabelOperation operation = new R01MChangesLabelOperation();
            operation.setLabelOid(labelEntityVO.getLabelGUID());
            operation.setSourceStructureOid(structureGuid);
            operation.setTargetStructureOid(targetStructureGuid);
            operation.setSourceRole(role);
            operation.setTargetRole(targetRole);
            operation.setOperationType(2);
            operations.add(operation);
        }
        return operations;
    }
}

