/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01e.services;

import com.ejie.r01e.gestorejes.dbhelppers.dao.R01EDAOCoreModelObjsLoader;
import com.ejie.r01e.structures.exceptions.R01ECatalogException;
import com.ejie.r01e.structures.exceptions.R01EElementNotFoundException;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.context.R01MUserContext;
import java.util.List;

public abstract class R01EBaseCatalogManager {
    protected boolean validateContext(R01MUserContext userCtx, String bagOid) {
        if (userCtx == null || StringUtils.isEmptyString((String)bagOid)) {
            return false;
        }
        List accessibleBags = userCtx.getUserBags();
        if (accessibleBags != null && !accessibleBags.isEmpty()) {
            String bagXLNetsUid;
            try {
                bagXLNetsUid = new R01EDAOCoreModelObjsLoader().executeGetBagXlNetsUidFromOid(bagOid);
            }
            catch (R01EElementNotFoundException ex) {
                return false;
            }
            catch (R01ECatalogException ex) {
                return false;
            }
            if (accessibleBags.contains(bagXLNetsUid)) {
                return true;
            }
        }
        return false;
    }
}

