/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01e.services;

import com.ejie.r01e.catalog.ejb.bagGroups.R01EBagGroupEntityCMPLocal;
import com.ejie.r01e.catalog.ejb.bagGroups.R01EBagGroupEntityCMPPK;
import com.ejie.r01e.catalog.ejb.bagGroups.R01EBagGroupEntityCMPUtil;
import com.ejie.r01e.catalog.ejb.bagGroups.R01EBagGroupEntityCMPValue;
import com.ejie.r01e.catalog.ejb.bagGroups.R01EBagGroupRelationEntityCMPLocal;
import com.ejie.r01e.catalog.ejb.bagGroups.R01EBagGroupRelationEntityCMPPK;
import com.ejie.r01e.catalog.ejb.bagGroups.R01EBagGroupRelationEntityCMPUtil;
import com.ejie.r01e.catalog.ejb.bags.R01EBagEntityCMPLocal;
import com.ejie.r01e.catalog.ejb.bags.R01EBagEntityCMPUtil;
import com.ejie.r01e.catalog.ejb.bags.R01EBagEntityCMPValue;
import com.ejie.r01e.catalog.ejb.elementnames.R01EElementNameEntityCMPLocal;
import com.ejie.r01e.catalog.ejb.elementnames.R01EElementNameEntityCMPUtil;
import com.ejie.r01e.catalog.ejb.elementnames.R01EElementNameEntityCMPValue;
import com.ejie.r01e.catalog.ejb.labels.R01ELabelEntityCMPUtil;
import com.ejie.r01e.catalog.ejb.relations.R01ERelationEntityCMPUtil;
import com.ejie.r01e.gestorejes.dbhelppers.dao.R01EDAOCoreModelObjsLoader;
import com.ejie.r01e.services.R01EBaseCatalogManager;
import com.ejie.r01e.structures.exceptions.R01ECatalogException;
import com.ejie.r01e.structures.exceptions.R01EElementNotFoundException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MCatalogElementNotFoundException;
import com.ejie.r01m.exceptions.R01MCatalogElementNotRemovableException;
import com.ejie.r01m.exceptions.R01MCatalogException;
import com.ejie.r01m.exceptions.R01MDuplicateCatalogElementException;
import com.ejie.r01m.objects.cataloguing.structures.R01MBag;
import com.ejie.r01m.objects.cataloguing.structures.R01MBagGroup;
import com.ejie.r01m.objects.cataloguing.structures.R01MLabel;
import com.ejie.r01m.services.bzd.R01MCatalogBagsBzd;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MDozerMappingUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import net.sf.dozer.util.mapping.MappingException;
import weblogic.utils.StringUtils;

public class R01EBagsManager
extends R01EBaseCatalogManager
implements R01MCatalogBagsBzd {
    private static final String LOG_TYPE_ID = "r01e.manager";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01e.manager").intValue() != Level.OFF.intValue();
    private transient R01MUserContext _userCtx = null;

    public R01EBagsManager() {
    }

    public R01EBagsManager(R01MUserContext userCtx) {
        this._userCtx = userCtx;
    }

    public R01MBag doLoadBag(String bagOid) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        R01MBag bag;
        String opDesc = "Cargando la bolsa " + bagOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader bagLoader = new R01EDAOCoreModelObjsLoader();
        try {
            bag = bagLoader.executeLoadBag(bagOid);
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException(ex.getMessage());
        }
        catch (R01EElementNotFoundException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogElementNotFoundException(ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return bag;
    }

    public R01MBag doLoadBag(int bagId) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        R01MBag bag;
        String opDesc = "Cargando la bolsa " + bagId;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader bagLoader = new R01EDAOCoreModelObjsLoader();
        try {
            bag = bagLoader.executeLoadBag(bagId);
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException(ex.getMessage());
        }
        catch (R01EElementNotFoundException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogElementNotFoundException(ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return bag;
    }

    public R01MBag doLoadBagByXlnetsUid(String xlnetsBagUid) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        R01MBag bag;
        String opDesc = "Cargando la bolsa con el identificador de XL-Nets " + xlnetsBagUid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader bagLoader = new R01EDAOCoreModelObjsLoader();
        try {
            bag = bagLoader.executeLoadBagByXLNETSUid(xlnetsBagUid);
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException(ex.getMessage());
        }
        catch (R01EElementNotFoundException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogElementNotFoundException(ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return bag;
    }

    public String doGetBagOidFromXlNetsUid(String xlnetsBagUid) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        String bagOid;
        String opDesc = "Cargando el identificador de bolsa que se corresponde con el identificador de XL-Nets " + xlnetsBagUid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader bagLoader = new R01EDAOCoreModelObjsLoader();
        try {
            bagOid = bagLoader.executeGetBagOidFromXlNetsUid(xlnetsBagUid);
        }
        catch (R01EElementNotFoundException enfExc) {
            enfExc.printStackTrace(System.out);
            throw new R01MCatalogElementNotFoundException(enfExc.getMessage());
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException(ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return bagOid;
    }

    public String doGetBagXlNetsUidFromOid(String bagOid) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        String bagXLNetsOid;
        String opDesc = "Cargando el identificador de seguridad de la bolsa " + bagOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader bagLoader = new R01EDAOCoreModelObjsLoader();
        try {
            bagXLNetsOid = bagLoader.executeGetBagXlNetsUidFromOid(bagOid);
        }
        catch (R01EElementNotFoundException enfExc) {
            enfExc.printStackTrace(System.out);
            throw new R01MCatalogElementNotFoundException(enfExc.getMessage());
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException(ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return bagXLNetsOid;
    }

    public List doLoadBags(String languageCode) throws R01MCatalogException {
        List bags;
        String opDesc = "Cargando las bolsas de catalogacion en el idioma " + languageCode;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader bagLoader = new R01EDAOCoreModelObjsLoader();
        try {
            bags = bagLoader.executeLoadBags(languageCode);
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException(ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        return bags;
    }

    public List<String> doGetAllBagXLNetsUids() throws R01MCatalogException {
        List bagOids;
        String opDesc = "Cargando TODOS los identificadores de seguridad de bolsas.";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader bagLoader = new R01EDAOCoreModelObjsLoader();
        try {
            bagOids = bagLoader.executeGetAllBagXLNetsUids();
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException(ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return bagOids;
    }

    public int doSaveBag(R01MUserContext userCtx, R01MBag bag) throws R01MCatalogException, R01MDuplicateCatalogElementException {
        String opDesc = "Creando/actualizando la bolsa con el identificador " + bag.getBagGUID() + " y el identificador num\u00e9rico " + bag.getBagId();
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        try {
            if (new R01EDAOCoreModelObjsLoader().executeExistBagName("es", bag)) {
                throw new R01MDuplicateCatalogElementException();
            }
            if (new R01EDAOCoreModelObjsLoader().executeExistBagName("eu", bag)) {
                throw new R01MDuplicateCatalogElementException();
            }
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException(ex.getMessage());
        }
        R01EBagEntityCMPLocal bagCMP = null;
        int idCreateBag = 0;
        try {
            bagCMP = R01EBagEntityCMPUtil.getLocalHome().findByBagGUID(bag.getBagGUID());
        }
        catch (FinderException fndExc) {
            idCreateBag = this._execCreateBag(bag);
            bag.setBagId(idCreateBag);
        }
        catch (NamingException namExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se encuentra el CMP de etiquetas.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se encuentra el CMP de etiquetas.Error:" + namExc.getMessage());
        }
        if (idCreateBag == 0) {
            this._execUpdateBag(bag, bagCMP);
        }
        if (userCtx != null) {
            List<String> accesibleLabelBags = new ArrayList();
            accesibleLabelBags = userCtx.getUserBags();
            if (!accesibleLabelBags.contains(bag.getBagXlnetsUID())) {
                accesibleLabelBags.add(bag.getBagXlnetsUID());
                userCtx.setUserBags(accesibleLabelBags);
            }
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        return bag.getBagId();
    }

    public R01MBag doLoadBagWithLabel(String labelOid) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        R01MBag bag;
        String opDesc = "Carga de la bolsa que contiene la etiqueta " + labelOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader bagLoader = new R01EDAOCoreModelObjsLoader();
        try {
            bag = bagLoader.executeLoadBagWithLabel(labelOid);
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException(ex.getMessage());
        }
        catch (R01EElementNotFoundException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogElementNotFoundException(ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return bag;
    }

    public R01MBag doLoadBagWithStructure(String structureOid) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        R01MBag bag;
        String opDesc = "Cargando la bolsa que contiene la estructura con el identificador " + structureOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader bagLoader = new R01EDAOCoreModelObjsLoader();
        try {
            bag = bagLoader.executeLoadBagWithStructure(structureOid);
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException(ex.getMessage());
        }
        catch (R01EElementNotFoundException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogElementNotFoundException(ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return bag;
    }

    public List doLoadBagGroupsByBag(int bagId) throws R01MCatalogException {
        List bags;
        String opDesc = "Carga de grupos de bolsas a partir del id num\u00e9rico de la bolsa " + bagId;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader bagLoader = new R01EDAOCoreModelObjsLoader();
        try {
            bags = bagLoader.executeLoadBagGroupsByBag(bagId);
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException(ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return bags;
    }

    public List<R01MBagGroup> doLoadBagGroups(String userLang) throws R01MCatalogException {
        List groups;
        String opDesc = "Carga de grupos de bolsas a partir del idioma del usuario " + userLang;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        try {
            groups = new R01EDAOCoreModelObjsLoader().executeLoadBagGroups(userLang);
        }
        catch (R01ECatalogException e) {
            e.printStackTrace(System.out);
            throw new R01MCatalogException("Error en la carga de grupos de Bolsas.Error:" + e.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return groups;
    }

    public R01MBagGroup doLoadBagGroup(int bagGroupId, String userLang) throws R01MCatalogException, R01MCatalogElementNotFoundException {
        R01MBagGroup group;
        String opDesc = "Carga del grupo de bolsas con id numerico " + bagGroupId + " a partir del idioma del usuario " + userLang;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        try {
            group = new R01EDAOCoreModelObjsLoader().executeLoadBagGroup(bagGroupId, userLang);
        }
        catch (R01ECatalogException e) {
            e.printStackTrace(System.out);
            throw new R01MCatalogException("Error en la carga del grupo de Bolsas.Error:" + e.getMessage());
        }
        catch (R01EElementNotFoundException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogElementNotFoundException("No existe el grupo de Bolsas especificado.");
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return group;
    }

    public void doRemoveBagGroup(int bagGroupId) throws R01MCatalogException {
        String guid;
        String opDesc = "Borrando el grupo de bolsas con id numerico " + bagGroupId;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        try {
            R01EBagGroupEntityCMPLocal bagGroupEntity = R01EBagGroupEntityCMPUtil.getLocalHome().findByPrimaryKey(new R01EBagGroupEntityCMPPK(bagGroupId));
            guid = bagGroupEntity.getGuid();
            bagGroupEntity.remove();
        }
        catch (FinderException findExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No existe la bolsa con id " + bagGroupId + ".Error:" + findExc.getMessage());
            findExc.printStackTrace(System.out);
            throw new R01MCatalogException("No existe la bolsa con id " + bagGroupId + ".Error:" + findExc.getMessage());
        }
        catch (NumberFormatException numExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("El id de la bolsa de valor " + bagGroupId + " no es num\u00e9rico.Error:" + numExc.getMessage());
            numExc.printStackTrace(System.out);
            throw new R01MCatalogException("El id de la bolsa de valor " + bagGroupId + " no es num\u00e9rico.Error:" + numExc.getMessage());
        }
        catch (NamingException namExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se encuentra el CMP de bolsas.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se encuentra el CMP de bolsas.Error:" + namExc.getMessage());
        }
        catch (EJBException ejbExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en el borrado de la bolsa de id " + bagGroupId + ".Error:" + ejbExc.getMessage());
            ejbExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error en el borrado de la bolsa de id " + bagGroupId + ".Error:" + ejbExc.getMessage());
        }
        catch (RemoveException remExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se puede borrar la bolsa de id " + bagGroupId + ".Error:" + remExc.getMessage());
            remExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se puede borrar la bolsa de id " + bagGroupId + ".Error:" + remExc.getMessage());
        }
        try {
            Collection elementsNameEntityCMP = R01EElementNameEntityCMPUtil.getLocalHome().findByElementGUID(guid);
            if (elementsNameEntityCMP != null && !elementsNameEntityCMP.isEmpty()) {
                for (R01EElementNameEntityCMPLocal element : elementsNameEntityCMP) {
                    element.remove();
                }
            }
        }
        catch (FinderException fndExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No existen nombres para el grupo de bolsas con guid:" + guid + ".Error:" + fndExc.getMessage());
            fndExc.printStackTrace(System.out);
            throw new R01MCatalogException("No existen nombres para el grupo de bolsas con guid:" + guid + ".Error:" + fndExc.getMessage());
        }
        catch (NamingException namExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se puede obtener el CMP de nombres de grupo de bolsas.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se puede obtener el CMP de nombres de grupo de bolsas.Error:" + namExc.getMessage());
        }
        catch (EJBException ejbExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en el borrado de nombres del grupo de bolsas " + guid + ".Error:" + ejbExc.getMessage());
            ejbExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error en el borrado de nombres del grupo de bolsas " + guid + ".Error:" + ejbExc.getMessage());
        }
        catch (RemoveException remExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se puede borrar los nombres del grupo de bolsas " + guid + ".Error:" + remExc.getMessage());
            remExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se puede borrar los nombres del grupo de bolsas " + guid + ".Error:" + remExc.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
    }

    public int doSaveBagGroup(R01MBagGroup theBagGroup) throws R01MCatalogException, R01MDuplicateCatalogElementException {
        int bagGroupId;
        String opDesc = "Creando/actualizando el grupo de bolsas " + theBagGroup.getGuid();
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        try {
            if (new R01EDAOCoreModelObjsLoader().executeExistBagGroupName("es", theBagGroup)) {
                throw new R01MDuplicateCatalogElementException("El nombre del grupo de bolsas ya existe.");
            }
            if (new R01EDAOCoreModelObjsLoader().executeExistBagGroupName("eu", theBagGroup)) {
                throw new R01MDuplicateCatalogElementException("El nombre del grupo de bolsas ya existe.");
            }
        }
        catch (R01ECatalogException ex) {
            ex.printStackTrace(System.out);
            throw new R01MCatalogException((Exception)((Object)ex));
        }
        if (theBagGroup.getId() == -1) {
            bagGroupId = this._createBagGroup(theBagGroup);
        } else {
            bagGroupId = theBagGroup.getId();
            this._updateBagGroup(theBagGroup);
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return bagGroupId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doRemoveBag(R01MUserContext userCtx, String bagGuid, int bagId) throws R01MCatalogElementNotRemovableException, R01MCatalogElementNotFoundException, R01MCatalogException {
        List groupsBag;
        List structuresBag;
        String opDesc = "Iniciando eliminar la bolsa con identificador: " + bagGuid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01EDAOCoreModelObjsLoader bagLoader = new R01EDAOCoreModelObjsLoader();
        try {
            structuresBag = bagLoader.executeLoadStructuresInBag(bagGuid, '\u0000', '\u0000', R01MConstants.DEFAULT_LANG, -1);
        }
        catch (R01ECatalogException catExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en la carga de la bolsa expecificada: " + catExc.getMessage());
            catExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error en la carga de la bolsa expecificada: ", (Exception)((Object)catExc));
        }
        List labelsBag = null;
        try {
            labelsBag = bagLoader.executeLoadLabels(bagGuid);
        }
        catch (R01EElementNotFoundException foundExc) {
        }
        catch (R01ECatalogException catExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en la carga de las etiquetas de la bolsa expecificada: " + catExc.getMessage());
            catExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error en la carga de las etiquetas de la bolsa expecificada: ", (Exception)((Object)catExc));
        }
        try {
            groupsBag = bagLoader.executeLoadBagGroupsByBag(bagId);
        }
        catch (R01ECatalogException catExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en la carga de las Agrupaciones de la bolsa expecificada: " + catExc.getMessage());
            catExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error en la carga de las Agrupaciones de la bolsa expecificada: ", (Exception)((Object)catExc));
        }
        if (!this._checkBagRemoval(structuresBag, labelsBag)) throw new R01MCatalogElementNotRemovableException("NO se permite borrar la bolsa, revisar las relaciones.");
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).finer("se van a borrar las etiquetas de la bolsa");
        }
        if (labelsBag != null && !labelsBag.isEmpty()) {
            for (R01MLabel label : labelsBag) {
                try {
                    R01ELabelEntityCMPUtil.getLocalHome().findByLabelGUID(label.getOid()).remove();
                }
                catch (EJBException ejbExc) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("Error borrando la etiqueta " + label.getOid() + ".Error:" + ejbExc.getMessage());
                    ejbExc.printStackTrace(System.out);
                    throw new R01MCatalogException("Error borrando la etiqueta " + label.getOid() + ".Error:" + ejbExc.getMessage());
                }
                catch (RemoveException rmExc) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("No se puede borrar la etiqueta " + label.getOid() + ".Error:" + rmExc.getMessage());
                    rmExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No se puede borrar la etiqueta " + label.getOid() + ".Error:" + rmExc.getMessage());
                }
                catch (FinderException fndExc) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("La etiqueta " + label.getOid() + " no existe.Error:" + fndExc.getMessage());
                    fndExc.printStackTrace(System.out);
                    throw new R01MCatalogElementNotFoundException("La etiqueta " + label.getOid() + " no existe.Error:" + fndExc.getMessage());
                }
                catch (NamingException namExc) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("No se encuentra el CMP de etiqueta.Error:" + namExc.getMessage());
                    namExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No se encuentra el CMP de etiqueta.Error:" + namExc.getMessage());
                }
            }
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).finer("se van a borrar las relaciones con las agrupaciones a las que pertenece la bolsa");
        }
        if (groupsBag != null && !groupsBag.isEmpty()) {
            R01EBagGroupRelationEntityCMPPK bagGroupPK = new R01EBagGroupRelationEntityCMPPK();
            for (R01MBagGroup bagGroup : groupsBag) {
                bagGroupPK.setBagGroupId(bagGroup.getId());
                bagGroupPK.setBagId(bagId);
                try {
                    R01EBagGroupRelationEntityCMPUtil.getLocalHome().findByPrimaryKey(bagGroupPK).remove();
                }
                catch (RemoveException rmExc) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("No se puede borrar la relaci\u00f3n con la agrupaci\u00f3n " + bagGroup.getId() + ".Error:" + rmExc.getMessage());
                    rmExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No se puede borrar la relaci\u00f3n con la agrupaci\u00f3n " + bagGroup.getId() + ".Error:" + rmExc.getMessage());
                }
                catch (EJBException ejbExc) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("Error borrando la relaci\u00f3n con la agrupaci\u00f3n " + bagGroup.getId() + ".Error:" + ejbExc.getMessage());
                    ejbExc.printStackTrace(System.out);
                    throw new R01MCatalogException("Error borrando la relaci\u00f3n con la agrupaci\u00f3n " + bagGroup.getId() + ".Error:" + ejbExc.getMessage());
                }
                catch (FinderException fndExc) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("La relaci\u00f3n con la agrupaci\u00f3n " + bagGroup.getId() + " no existe.Error:" + fndExc.getMessage());
                    fndExc.printStackTrace(System.out);
                    throw new R01MCatalogElementNotFoundException("La relaci\u00f3n con la agrupaci\u00f3n " + bagGroup.getId() + " no existe.Error:" + fndExc.getMessage());
                }
                catch (NamingException namExc) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("No se encuentra el CMP de la relaci\u00f3n con la agrupaci\u00f3n.Error:" + namExc.getMessage());
                    namExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No se encuentra el CMP de la relaci\u00f3n con la agrupaci\u00f3n.Error:" + namExc.getMessage());
                }
            }
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).finer("Borrando la bolsa " + bagGuid);
        }
        try {
            R01EBagEntityCMPUtil.getLocalHome().findByBagGUID(bagGuid).remove();
        }
        catch (EJBException ejbExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error borrando la bolsa " + bagGuid + ".Error:" + ejbExc.getMessage());
            ejbExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error borrando la bolsa " + bagGuid + ".Error:" + ejbExc.getMessage());
        }
        catch (RemoveException rmExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se puede borrar la bolsa " + bagGuid + ".Error:" + rmExc.getMessage());
            rmExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se puede borrar la bolsa " + bagGuid + ".Error:" + rmExc.getMessage());
        }
        catch (FinderException fndExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("La bolsa " + bagGuid + " no existe.Error:" + fndExc.getMessage());
            fndExc.printStackTrace(System.out);
            throw new R01MCatalogElementNotFoundException("La bolsa " + bagGuid + " no existe.Error:" + fndExc.getMessage());
        }
        catch (NamingException namExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se encuentra el CMP de bolsa.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se encuentra el CMP de bolsa.Error:" + namExc.getMessage());
        }
        try {
            Collection elementsNameEntityCMP = R01EElementNameEntityCMPUtil.getLocalHome().findByElementGUID(bagGuid);
            if (elementsNameEntityCMP == null || elementsNameEntityCMP.isEmpty()) return;
            for (R01EElementNameEntityCMPLocal element : elementsNameEntityCMP) {
                element.remove();
            }
            return;
        }
        catch (FinderException fndExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No existen nombres para la bolsa con guid:" + bagGuid + ".Error:" + fndExc.getMessage());
            fndExc.printStackTrace(System.out);
            throw new R01MCatalogException("No existen nombres para la bolsa con guid:" + bagGuid + ".Error:" + fndExc.getMessage());
        }
        catch (NamingException namExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se puede obtener el CMP de nombres de la bolsa.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se puede obtener el CMP de nombres de la bolsa.Error:" + namExc.getMessage());
        }
        catch (EJBException ejbExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en el borrado de nombres de la bolsa " + bagGuid + ".Error:" + ejbExc.getMessage());
            ejbExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error en el borrado de nombres de la bolsa " + bagGuid + ".Error:" + ejbExc.getMessage());
        }
        catch (RemoveException remExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se puede borrar los nombres de la bolsa " + bagGuid + ".Error:" + remExc.getMessage());
            remExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se puede borrar los nombres de la bolsa " + bagGuid + ".Error:" + remExc.getMessage());
        }
    }

    public boolean doCheckBagExistence(String bagOid, boolean useGuid) throws R01MCatalogException {
        if (StringUtils.isEmptyString((String)bagOid)) {
            return false;
        }
        String opDesc = "Comprobar la existencia de la bolsa " + bagOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01EDAOCoreModelObjsLoader bagLoader = new R01EDAOCoreModelObjsLoader();
            boolean exist = bagLoader.executeExistsBag(bagOid, useGuid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return exist;
        }
        catch (R01ECatalogException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MCatalogException("Error en la validaci\u00f3n de la existencia de la bolsa '" + bagOid + "'.Error:" + cmEx.getMessage());
        }
    }

    private int _execCreateBag(R01MBag bag) throws R01MCatalogException {
        int bagId;
        R01EBagEntityCMPValue bagVO;
        try {
            bagVO = (R01EBagEntityCMPValue)R01MDozerMappingUtils.map((String)R01MConstants.STRUCTURES_APPCODE, (Object)bag, R01EBagEntityCMPValue.class);
        }
        catch (MappingException mapEx) {
            R01FLog.to((String)"r01e.operationsManager").severe("BAGS MANAGER (" + bag.getBagGUID() + ") >  Error al mapear los miembros del objeto bolsa al Value Object correspondiente.");
            mapEx.printStackTrace(System.out);
            throw new R01MCatalogException("Error al mapear los miembros del objeto bolsa al Value Object correspondiente: " + mapEx.getMessage());
        }
        catch (Exception e) {
            R01FLog.to((String)"r01e.operationsManager").severe("BAGS MANAGER (" + bag.getBagGUID() + ") >  Ha fallado el Mapeo de la bolsa : " + e.getMessage());
            e.printStackTrace(System.out);
            throw new R01MCatalogException("Error al mapear los miembros del objeto bolsa al Value Object correspondiente: " + e.getMessage());
        }
        catch (Throwable thEx) {
            thEx.printStackTrace(System.out);
            R01FLog.to((String)"r01e.operationsManager").severe("BAGS MANAGER (" + bag.getBagGUID() + ") >  Ha fallado el Mapeo de la bolsa : " + thEx.getMessage());
            throw new R01MCatalogException("Error al mapear los miembros del objeto bolsa al Value Object correspondiente. Error:" + thEx.getMessage());
        }
        try {
            bagId = R01EBagEntityCMPUtil.getLocalHome().create(bagVO).getBagId();
        }
        catch (CreateException crtExc) {
            R01FLog.to((String)LOG_TYPE_ID).info("No se puede crear la bolsa " + bag.getBagGUID() + ".Error:" + crtExc.getMessage());
            crtExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se puede crear la bolsa " + bag.getBagGUID() + ".Error:" + crtExc.getMessage());
        }
        catch (NamingException namExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se encuentra el CMP de bolsas.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se encuentra el CMP de bolsas.Error:" + namExc.getMessage());
        }
        if (bag.getBagNames() != null && !bag.getBagNames().isEmpty()) {
            for (String languageKey : bag.getBagNames().keySet()) {
                String value = (String)bag.getBagNames().get(languageKey);
                try {
                    R01EElementNameEntityCMPUtil.getLocalHome().create(value, languageKey, bag.getBagGUID(), null);
                }
                catch (CreateException crtExc) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("No se puede crear el nombre " + value + " para la bolsa " + bag.getBagGUID() + ".Error:" + crtExc.getMessage());
                    crtExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No se puede crear el nombre " + value + " para la bolsa " + bag.getBagGUID() + ".Error:" + crtExc.getMessage());
                }
                catch (NamingException namExc) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("No se encuentra el CMP de nombres de catalogaci\u00f3n.Error:" + namExc.getMessage());
                    namExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No se encuentra el CMP de nombres de catalogaci\u00f3n.Error:" + namExc.getMessage());
                }
            }
        }
        return bagId;
    }

    public void _execUpdateBag(R01MBag bag, R01EBagEntityCMPLocal bagCMP) throws R01MCatalogException {
        R01EBagEntityCMPValue bagVO;
        try {
            bagVO = (R01EBagEntityCMPValue)R01MDozerMappingUtils.map((String)R01MConstants.STRUCTURES_APPCODE, (Object)bag, R01EBagEntityCMPValue.class);
        }
        catch (MappingException mapEx) {
            R01FLog.to((String)"r01e.operationsManager").severe("BAGS MANAGER (" + bag.getBagGUID() + ") >  Error al mapear los miembros del objeto bolsa al Value Object correspondiente.");
            mapEx.printStackTrace(System.out);
            throw new R01MCatalogException("Error al mapear los miembros del objeto bolsa al Value Object correspondiente: " + mapEx.getMessage());
        }
        catch (Exception e) {
            R01FLog.to((String)"r01e.operationsManager").severe("BAGS MANAGER (" + bag.getBagGUID() + ") >  Ha fallado el Mapeo de la bolsa : " + e.getMessage());
            e.printStackTrace(System.out);
            throw new R01MCatalogException("Error al mapear los miembros del objeto bolsa al Value Object correspondiente: " + e.getMessage());
        }
        catch (Throwable thEx) {
            thEx.printStackTrace(System.out);
            R01FLog.to((String)"r01e.operationsManager").severe("BAGS MANAGER (" + bag.getBagGUID() + ") >  Ha fallado el Mapeo de la bolsa : " + thEx.getMessage());
            throw new R01MCatalogException("Error al mapear los miembros del objeto bolsa al Value Object correspondiente. Error:" + thEx.getMessage());
        }
        bagCMP.setR01EBagEntityCMPValue(bagVO);
        if (bag.getBagNames() != null && !bag.getBagNames().isEmpty()) {
            for (String language : bag.getBagNames().keySet()) {
                String nameValue = ((String)bag.getBagNames().get(language)).toString();
                try {
                    R01EElementNameEntityCMPLocal elementNameCMPLocal = R01EElementNameEntityCMPUtil.getLocalHome().findByElementGUID(bagCMP.getBagGUID(), language);
                    elementNameCMPLocal.setValue(nameValue);
                    elementNameCMPLocal.setGuid(bagCMP.getBagGUID());
                }
                catch (FinderException ex) {
                    try {
                        R01EElementNameEntityCMPUtil.getLocalHome().create(nameValue, language, bagCMP.getBagGUID(), "");
                    }
                    catch (CreateException crtExc) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("No se puede crear el t\u00e9rmino " + nameValue + " para la bolsa " + bagCMP.getBagGUID() + " en el idioma " + language + ".Error:" + crtExc.getMessage());
                        crtExc.printStackTrace(System.out);
                        throw new R01MCatalogException("o se puede crear el t\u00e9rmino " + nameValue + " para la bolsa " + bagCMP.getBagGUID() + " en el idioma " + language + ".Error:" + crtExc.getMessage());
                    }
                    catch (NamingException namExc) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("No se encuentra el CMP de t\u00e9rminos.Error:" + namExc.getMessage());
                        namExc.printStackTrace(System.out);
                        throw new R01MCatalogException("No se encuentra el CMP de t\u00e9rminos.Error:" + namExc.getMessage());
                    }
                }
                catch (NamingException namExc) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("No se encuentra el CMP de t\u00e9rminos.Error:" + namExc.getMessage());
                    namExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No se encuentra el CMP de t\u00e9rminos.Error:" + namExc.getMessage());
                }
            }
        }
        try {
            Collection elementNameCMPLocalCol = R01EElementNameEntityCMPUtil.getLocalHome().findByElementGUID(bagCMP.getBagGUID());
            for (R01EElementNameEntityCMPLocal elementNameEntityLocal : elementNameCMPLocalCol) {
                if (bag.getBagNames().containsKey(elementNameEntityLocal.getLanguageId())) continue;
                try {
                    elementNameEntityLocal.remove();
                }
                catch (EJBException ex) {
                }
                catch (RemoveException ex) {}
            }
        }
        catch (FinderException ignore) {
        }
        catch (NamingException ignore) {
            // empty catch block
        }
    }

    private int _createBagGroup(R01MBagGroup theBagGroup) throws R01MCatalogException {
        int bagGroupId;
        R01EBagGroupEntityCMPValue bagGroupVO = new R01EBagGroupEntityCMPValue();
        bagGroupVO.setGuid(theBagGroup.getGuid());
        try {
            bagGroupId = R01EBagGroupEntityCMPUtil.getLocalHome().create(bagGroupVO).getId();
        }
        catch (CreateException crtExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se puede crear el grupo de bolsas " + theBagGroup.getGuid() + ".Error:" + crtExc.getMessage());
            crtExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se puede crear el grupo de bolsas " + theBagGroup.getGuid() + ".Error:" + crtExc.getMessage());
        }
        catch (NamingException namExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se encuentra el CMP de grupo de bolsas.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se encuentra el CMP de grupo de bolsas.Error:" + namExc.getMessage());
        }
        if (theBagGroup.getNames() != null) {
            Map names = theBagGroup.getNames();
            for (String languageKey : names.keySet()) {
                String value = (String)names.get(languageKey);
                String descripcion = theBagGroup.getDescription(languageKey);
                try {
                    R01EElementNameEntityCMPUtil.getLocalHome().create(value, languageKey, theBagGroup.getGuid(), descripcion);
                }
                catch (CreateException crtExc) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("No se puede crear los nombres del grupo de bolsas " + theBagGroup.getGuid() + ".Error:" + crtExc.getMessage());
                    crtExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No se puede crear los nombres del grupo de bolsas " + theBagGroup.getGuid() + ".Error:" + crtExc.getMessage());
                }
                catch (NamingException namExc) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("No se encuentra el CMP de nombres del grupo de bolsas.Error:" + namExc.getMessage());
                    namExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No se encuentra el CMP de nombres del grupo de bolsas.Error:" + namExc.getMessage());
                }
            }
        }
        if (theBagGroup.getBelongBags() != null && !theBagGroup.getBelongBags().isEmpty() && theBagGroup.getBelongBags() != null && !theBagGroup.getBelongBags().isEmpty()) {
            for (R01MBag eBag : theBagGroup.getBelongBags()) {
                try {
                    R01EBagGroupRelationEntityCMPUtil.getLocalHome().create(bagGroupId, eBag.getBagId());
                }
                catch (NumberFormatException numExc) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("El valor de la bolsa la bolsa " + theBagGroup.getId() + " no es numerico.Error:" + numExc.getMessage());
                    numExc.printStackTrace(System.out);
                    throw new R01MCatalogException("El valor de la bolsa la bolsa " + theBagGroup.getId() + " no es numerico.Error:" + numExc.getMessage());
                }
                catch (CreateException crtExc) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("No se puede crear la relacion entre la bolsa " + eBag.getBagId() + " y el grupo de bolsas " + theBagGroup.getGuid() + ".Error:" + crtExc.getMessage());
                    crtExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No se puede crear la relacion entre la bolsa " + eBag.getBagId() + " y el grupo de bolsas " + theBagGroup.getGuid() + ".Error:" + crtExc.getMessage());
                }
                catch (NamingException namExc) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("No se encuentra el CMP de relacion entre bolsas y grupo de bolsas.Error:" + namExc.getMessage());
                    namExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No se encuentra el CMP de relacion entre bolsas y grupo de bolsas.Error:" + namExc.getMessage());
                }
            }
        }
        return bagGroupId;
    }

    private R01MBagGroup _updateBagGroup(R01MBagGroup theBagGroup) throws R01MCatalogException {
        if (theBagGroup.getNames() != null && !theBagGroup.getNames().isEmpty()) {
            for (String language : theBagGroup.getNames().keySet()) {
                String nameValue = (String)theBagGroup.getNames().get(language);
                String descripcion = theBagGroup.getDescription(language);
                try {
                    R01EElementNameEntityCMPLocal entityCMP = R01EElementNameEntityCMPUtil.getLocalHome().findByElementGUID(theBagGroup.getGuid(), language);
                    R01EElementNameEntityCMPValue elementNameVO = entityCMP.getR01EElementNameEntityCMPValue();
                    elementNameVO.setValue(nameValue);
                    elementNameVO.setDescription(descripcion);
                    entityCMP.setR01EElementNameEntityCMPValue(elementNameVO);
                }
                catch (FinderException finderEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("No existe t\u00e9rmino para el grupo de bolsas con guid " + theBagGroup.getGuid() + ".Error:" + finderEx.getMessage());
                    finderEx.printStackTrace(System.out);
                    throw new R01MCatalogException("No existe t\u00e9rmino para el grupo de bolsas con guid " + theBagGroup.getGuid() + ".Error:" + finderEx.getMessage());
                }
                catch (NamingException namExc) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("No se encuentra el CMP de t\u00e9rminos para el grupo de bolsas.Error:" + namExc.getMessage());
                    namExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No se encuentra el CMP de t\u00e9rminos para el grupo de bolsas.Error:" + namExc.getMessage());
                }
            }
        }
        try {
            Collection belongBagsBD = R01EBagGroupRelationEntityCMPUtil.getLocalHome().findByBagGroupId(theBagGroup.getId());
            if (belongBagsBD != null && !belongBagsBD.isEmpty()) {
                for (R01EBagGroupRelationEntityCMPLocal relation : belongBagsBD) {
                    relation.remove();
                }
            }
        }
        catch (FinderException finderEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No existen relaciones para el grupo de bolsas con id:" + theBagGroup.getId() + ".Error:" + finderEx.getMessage());
            finderEx.printStackTrace(System.out);
            throw new R01MCatalogException("No existen relaciones para el grupo de bolsas con id:" + theBagGroup.getId() + ".Error:" + finderEx.getMessage());
        }
        catch (NamingException namExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se encuentra el CMP de relaciones para el grupo de bolsas.Error:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se encuentra el CMP de relaciones para el grupo de bolsas.Error:" + namExc.getMessage());
        }
        catch (EJBException ejbExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al borrar la relaci\u00f3n para el grupo de bolsas " + theBagGroup.getId() + ".Error:" + ejbExc.getMessage());
            ejbExc.printStackTrace(System.out);
            throw new R01MCatalogException("Error al borrar la relaci\u00f3n para el grupo de bolsas " + theBagGroup.getId() + ".Error:" + ejbExc.getMessage());
        }
        catch (RemoveException remExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se puede borrar la relaci\u00f3n para el grupo de bolsas " + theBagGroup.getId() + ".Error:" + remExc.getMessage());
            remExc.printStackTrace(System.out);
            throw new R01MCatalogException("No se puede borrar la relaci\u00f3n para el grupo de bolsas " + theBagGroup.getId() + ".Error:" + remExc.getMessage());
        }
        if (theBagGroup.getBelongBags() != null && !theBagGroup.getBelongBags().isEmpty()) {
            for (R01MBag eBag : theBagGroup.getBelongBags()) {
                try {
                    R01EBagGroupRelationEntityCMPUtil.getLocalHome().create(theBagGroup.getId(), eBag.getBagId());
                }
                catch (NumberFormatException numExc) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("El valor de la bolsa la bolsa " + theBagGroup.getId() + " no es numerico.Error:" + numExc.getMessage());
                    numExc.printStackTrace(System.out);
                    throw new R01MCatalogException("El valor de la bolsa la bolsa " + theBagGroup.getId() + " no es numerico.Error:" + numExc.getMessage());
                }
                catch (CreateException crtExc) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("No se puede crear la relacion entre la bolsa " + eBag.getBagId() + " y el grupo de bolsas " + theBagGroup.getId() + ".Error:" + crtExc.getMessage());
                    crtExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No se puede crear la relacion entre la bolsa " + eBag.getBagId() + " y el grupo de bolsas " + theBagGroup.getId() + ".Error:" + crtExc.getMessage());
                }
                catch (NamingException namExc) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("No se encuentra el CMP de relacion entre bolsas y grupo de bolsas.Error:" + namExc.getMessage());
                    namExc.printStackTrace(System.out);
                    throw new R01MCatalogException("No se encuentra el CMP de relacion entre bolsas y grupo de bolsas.Error:" + namExc.getMessage());
                }
            }
        }
        return theBagGroup;
    }

    private boolean _checkBagRemoval(List structuresBag, List labelsBag) throws R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)"r01e.ejb").info("SE va a comprobar el borrado de la bolsa");
        }
        if (structuresBag != null && !structuresBag.isEmpty()) {
            return false;
        }
        if (labelsBag == null || labelsBag.isEmpty()) {
            return true;
        }
        for (R01MLabel label : labelsBag) {
            try {
                Collection relations = R01ERelationEntityCMPUtil.getLocalHome().findLabelRelations(label.getOid(), 'H');
                if (relations == null || relations.isEmpty()) continue;
                return false;
            }
            catch (FinderException fndExc) {
            }
            catch (NamingException namExc) {
                R01FLog.to((String)LOG_TYPE_ID).severe("No se encuentra el CMP de relaciones.Error:" + namExc.getMessage());
                namExc.printStackTrace(System.out);
                throw new R01MCatalogException("No se encuentra el CMP de relaciones.Error:" + namExc.getMessage());
            }
        }
        return true;
    }
}

