/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01e.ejb.services.catalog;

import com.ejie.r01e.services.R01EBagsManager;
import com.ejie.r01e.services.R01ELabelsManager;
import com.ejie.r01e.services.R01EOperationsManager;
import com.ejie.r01e.services.R01EStructuresManager;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.NumberUtils;
import com.ejie.r01m.config.objects.cataloguing.R01MChangesLabelsPacket;
import com.ejie.r01m.config.objects.cataloguing.R01MPacketInfo;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MCatalogElementNotFoundException;
import com.ejie.r01m.exceptions.R01MCatalogElementNotRemovableException;
import com.ejie.r01m.exceptions.R01MCatalogException;
import com.ejie.r01m.exceptions.R01MDuplicateCatalogElementException;
import com.ejie.r01m.exceptions.R01MJMSException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.cataloguing.structures.R01MBag;
import com.ejie.r01m.objects.cataloguing.structures.R01MBagGroup;
import com.ejie.r01m.objects.cataloguing.structures.R01MLabel;
import com.ejie.r01m.objects.cataloguing.structures.R01MLabelSearchFilter;
import com.ejie.r01m.objects.cataloguing.structures.R01MRelation;
import com.ejie.r01m.objects.cataloguing.structures.R01MStructure;
import com.ejie.r01m.objects.cataloguing.structures.R01MStructureDefinition;
import com.ejie.r01m.services.bzd.R01MCatalogManagerBzd;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01n.ejb.notifier.R01NCachesNotifierSLUtil;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import weblogic.utils.StringUtils;

public class R01ECatalogServicesSLBaseBean
implements SessionBean,
R01MCatalogManagerBzd {
    private static final long serialVersionUID = 6998737441879439717L;
    private static final String LOG_TYPE_ID = "r01e.services";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01e.services").intValue() != Level.OFF.intValue();
    private SessionContext context;

    public void setSessionContext(SessionContext newContext) throws EJBException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tsetSessionContext()");
        }
        this.context = newContext;
    }

    public void ejbRemove() throws EJBException, RemoteException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tejbRemove()");
        }
    }

    public void ejbActivate() throws EJBException, RemoteException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tejbActivate()");
        }
    }

    public void ejbPassivate() throws EJBException, RemoteException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tejbPassivate()");
        }
    }

    public void ejbCreate() throws CreateException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tejbCreate()");
        }
    }

    public R01MBag doLoadBag(String bagGuid) throws EJBException, R01MCatalogException, R01MCatalogElementNotFoundException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadBag() con identificador bagGuid: " + bagGuid);
        }
        if (!this.doCheckBagExistence(bagGuid, true)) {
            R01FLog.to((String)LOG_TYPE_ID).warning("La bolsa de identificador '" + bagGuid + "' NO EXISTE.");
            return null;
        }
        try {
            R01EBagsManager bagsConfig = new R01EBagsManager();
            return bagsConfig.doLoadBag(bagGuid);
        }
        catch (R01MCatalogElementNotFoundException enfEx) {
            throw new EJBException((Exception)((Object)enfEx));
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
    }

    public R01MBag doLoadBag(int bagId) throws EJBException, R01MCatalogException, R01MCatalogElementNotFoundException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadBag() con identificador bagGuid: " + bagId);
        }
        if (!this.doCheckBagExistence("" + bagId, false)) {
            R01FLog.to((String)LOG_TYPE_ID).warning("La bolsa de identificador '" + bagId + "' NO EXISTE.");
            return null;
        }
        try {
            R01EBagsManager bagsConfig = new R01EBagsManager();
            return bagsConfig.doLoadBag(bagId);
        }
        catch (R01MCatalogElementNotFoundException enfEx) {
            throw new EJBException((Exception)((Object)enfEx));
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
    }

    public R01MBag doLoadBagByXlnetsUid(String xlnetsBagUid) throws EJBException, R01MCatalogException, R01MCatalogElementNotFoundException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadBagByXlnetsUid() con identificador de xlnets: " + xlnetsBagUid);
        }
        try {
            R01EBagsManager bagsConfig = new R01EBagsManager();
            return bagsConfig.doLoadBagByXlnetsUid(xlnetsBagUid);
        }
        catch (R01MCatalogElementNotFoundException enfEx) {
            throw new EJBException((Exception)((Object)enfEx));
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
    }

    public String doGetBagOidFromXlNetsUid(String xlnetsBagUid) throws EJBException, R01MCatalogElementNotFoundException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoGetBagOidFromXldetsUid()");
        }
        try {
            R01EBagsManager bagsConfig = new R01EBagsManager();
            return bagsConfig.doGetBagOidFromXlNetsUid(xlnetsBagUid);
        }
        catch (R01MCatalogElementNotFoundException enfEx) {
            throw new EJBException((Exception)((Object)enfEx));
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
    }

    public List doLoadBags(String languageCode) throws EJBException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadBags()");
        }
        try {
            R01EBagsManager bagsConfig = new R01EBagsManager();
            return bagsConfig.doLoadBags(languageCode);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
    }

    public List doGetAllBagXLNetsUids() throws EJBException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoGetAllBagXLNetsUids()");
        }
        try {
            R01EBagsManager bagsConfig = new R01EBagsManager();
            return bagsConfig.doGetAllBagXLNetsUids();
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
    }

    public R01MBag doLoadBagWithLabel(String labelGuid) throws EJBException, R01MCatalogException, R01MCatalogElementNotFoundException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadBagWithLabel labelGuid" + labelGuid);
        }
        try {
            R01EBagsManager bagsConfig = new R01EBagsManager();
            return bagsConfig.doLoadBagWithLabel(labelGuid);
        }
        catch (R01MCatalogElementNotFoundException enfEx) {
            throw new EJBException((Exception)((Object)enfEx));
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
    }

    public R01MBag doLoadBagWithStructure(String structureGuid) throws EJBException, R01MCatalogException, R01MCatalogElementNotFoundException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadBagWithStructure structureGuid" + structureGuid);
        }
        try {
            R01EBagsManager bagsConfig = new R01EBagsManager();
            return bagsConfig.doLoadBagWithStructure(structureGuid);
        }
        catch (R01MCatalogElementNotFoundException enfEx) {
            throw new EJBException((Exception)((Object)enfEx));
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
    }

    public int doSaveBag(R01MUserContext userCtx, R01MBag mbag) throws EJBException, R01MDuplicateCatalogElementException, R01MCatalogException {
        int bagId;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoCreateBag()");
        }
        try {
            R01EBagsManager bagsConfig = new R01EBagsManager();
            bagId = bagsConfig.doSaveBag(userCtx, mbag);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MDuplicateCatalogElementException dupExc) {
            throw new EJBException((Exception)((Object)dupExc));
        }
        this._reloadCaches();
        return bagId;
    }

    public void doRemoveBag(R01MUserContext userCtx, String bagGuid, int bagId) throws EJBException, R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogElementNotRemovableException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoRemoveBag bagGuid: " + bagGuid);
        }
        try {
            R01EBagsManager bagsConfig = new R01EBagsManager();
            bagsConfig.doRemoveBag(userCtx, bagGuid, bagId);
        }
        catch (R01MCatalogElementNotRemovableException notRemExc) {
            throw new EJBException((Exception)((Object)notRemExc));
        }
        catch (R01MCatalogElementNotFoundException enfEx) {
            throw new EJBException((Exception)((Object)enfEx));
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        this._reloadCaches();
    }

    public R01MLabel doLoadLabel(String labelGuid) throws EJBException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadLabel labelGuid: " + labelGuid);
        }
        try {
            R01ELabelsManager labelsManager = new R01ELabelsManager();
            return labelsManager.doLoadLabel(labelGuid);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
    }

    public R01MLabel doLoadLabelByExtOID(String extOID) throws EJBException, R01MCatalogException, R01MCatalogElementNotFoundException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadLabelByExtOID extOID: " + extOID);
        }
        try {
            R01ELabelsManager labelsManager = new R01ELabelsManager();
            return labelsManager.doLoadLabelByExtOID(extOID);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MCatalogElementNotFoundException enfEx) {
            throw new EJBException((Exception)((Object)enfEx));
        }
    }

    public List doLoadOrderedLabels(String bagGuid, String languageCode) throws EJBException, R01MCatalogException, R01MCatalogElementNotFoundException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadLabelByExtOID bagGuid, languageCode: " + bagGuid + ":" + languageCode);
        }
        try {
            R01ELabelsManager labelsManager = new R01ELabelsManager();
            return labelsManager.doLoadOrderedLabels(bagGuid, languageCode);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MCatalogElementNotFoundException enfEx) {
            throw new EJBException((Exception)((Object)enfEx));
        }
    }

    public List doLoadLabels(String bagGuid) throws EJBException, R01MCatalogException, R01MCatalogElementNotFoundException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadLabels bagGuid: " + bagGuid);
        }
        try {
            R01ELabelsManager labelsManager = new R01ELabelsManager();
            return labelsManager.doLoadLabels(bagGuid);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MCatalogElementNotFoundException enfEx) {
            throw new EJBException((Exception)((Object)enfEx));
        }
    }

    public R01MLabel doLoadLabel(int labelId) throws EJBException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadLabel labelId: " + labelId);
        }
        try {
            R01ELabelsManager labelsManager = new R01ELabelsManager();
            return labelsManager.doLoadLabel(labelId);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
    }

    public int doSaveLabel(R01MUserContext userCtx, String bagOid, R01MLabel label) throws EJBException, R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogException {
        int labelId;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoSaveLabel label GUID: " + label.getOid() + " en la bolsa " + bagOid);
        }
        try {
            R01ELabelsManager labelsManager = new R01ELabelsManager();
            labelId = labelsManager.doSaveLabel(userCtx, bagOid, label);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MCatalogElementNotFoundException enfEx) {
            throw new EJBException((Exception)((Object)enfEx));
        }
        this._reloadCaches();
        return labelId;
    }

    public void doRemoveLabel(R01MUserContext userCtx, String bagOid, String labelGuid) throws EJBException, R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogElementNotRemovableException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoRemoveLabel labelGuid: " + labelGuid);
        }
        try {
            R01ELabelsManager labelsManager = new R01ELabelsManager();
            labelsManager.doRemoveLabel(userCtx, bagOid, labelGuid);
        }
        catch (R01MCatalogElementNotRemovableException notRemExc) {
            throw new EJBException((Exception)((Object)notRemExc));
        }
        catch (R01MCatalogElementNotFoundException enfEx) {
            throw new EJBException((Exception)((Object)enfEx));
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        this._reloadCaches();
    }

    public void doMoveLabelToBag(R01MUserContext userCtx, String labelGuid, String bagGuid, String newBagGuid) throws EJBException, R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoMoveLavelToBag labelGuid: " + labelGuid);
        }
        try {
            R01ELabelsManager labelsManager = new R01ELabelsManager();
            labelsManager.doMoveLabelToBag(userCtx, labelGuid, bagGuid, newBagGuid);
        }
        catch (R01MCatalogElementNotFoundException enfExc) {
            throw new EJBException((Exception)((Object)enfExc));
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        this._reloadCaches();
    }

    public void doMoveLabel(R01MUserContext userCtx, String bagOid, String structureGuid, String labelGuid, int relationId, int role, String targetStructureGuid, int targetStructureId, int targetLabelId, int targetRelationId, int targetRole) throws EJBException, R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoMoveLavel RelationId: " + relationId);
        }
        try {
            R01ELabelsManager labelsManager = new R01ELabelsManager();
            labelsManager.doMoveLabel(userCtx, bagOid, structureGuid, labelGuid, relationId, role, targetStructureGuid, targetStructureId, targetLabelId, targetRelationId, targetRole);
        }
        catch (R01MCatalogElementNotFoundException enfExc) {
            throw new EJBException((Exception)((Object)enfExc));
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        this._reloadCaches();
    }

    public List doLoadSearchLabel(R01MLabelSearchFilter searchCriteriaObj) throws EJBException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadSearchLabel texto: " + searchCriteriaObj.getTermText());
        }
        try {
            R01ELabelsManager labelsManager = new R01ELabelsManager();
            return labelsManager.doLoadSearchLabel(searchCriteriaObj);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
    }

    public List doLoadLabelInStructureWithRole(String structureOid, String labelOid, int role) throws EJBException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadLabelInStructureWithRole label: " + labelOid + " estructura " + structureOid + " en el rol " + role);
        }
        try {
            R01ELabelsManager labelsManager = new R01ELabelsManager();
            return labelsManager.doLoadLabelInStructureWithRole(structureOid, labelOid, role);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
    }

    public R01MStructure doLoadStructure(String structureGuid) throws EJBException, R01MCatalogElementNotFoundException, R01MCatalogException {
        return this.doLoadStructure(structureGuid, R01MConstants.DEFAULT_LANG, 0, -1);
    }

    public R01MStructure doLoadStructure(String structureOid, String languageCode, int relationParentId, int numRolesToReturn) throws EJBException, R01MCatalogElementNotFoundException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoloadStructure structureOid: " + structureOid + " desde el nodo " + relationParentId + " devolver " + numRolesToReturn + " niveles en el idioma " + languageCode);
        }
        try {
            R01EStructuresManager structuresManager = new R01EStructuresManager();
            return structuresManager.doLoadStructure(structureOid, languageCode, relationParentId, numRolesToReturn);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MCatalogElementNotFoundException catEnfEx) {
            throw new EJBException((Exception)((Object)catEnfEx));
        }
    }

    public List doLoadStructuresWithLabel(String labelGuid) throws EJBException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoloadStructure labelGuid: " + labelGuid);
        }
        if (StringUtils.isEmptyString((String)labelGuid)) {
            return null;
        }
        try {
            R01EStructuresManager structuresManager = new R01EStructuresManager();
            return structuresManager.doLoadStructuresWithLabel(labelGuid);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
    }

    public R01MStructureDefinition doLoadStructureDefinition(String structureGuid) throws EJBException, R01MCatalogElementNotFoundException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadStructureDefinition structureGuid: " + structureGuid);
        }
        if (StringUtils.isEmptyString((String)structureGuid)) {
            return null;
        }
        try {
            R01EStructuresManager structuresManager = new R01EStructuresManager();
            return structuresManager.doLoadStructureDefinition(structureGuid);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MCatalogElementNotFoundException catEnfEx) {
            throw new EJBException((Exception)((Object)catEnfEx));
        }
    }

    public List doLoadStructureDefinitions(Collection bags, char structureType, char structureStatus) throws EJBException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadStructureDefinitions structureType: " + structureType);
        }
        try {
            R01EStructuresManager structuresManager = new R01EStructuresManager();
            return structuresManager.doLoadStructureDefinitions(bags, structureType, structureStatus);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
    }

    public List doLoadStructuresInBag(String bagGuid, char type, char status, String languageCode) throws EJBException, R01MCatalogElementNotFoundException, R01MCatalogException {
        return this.doLoadStructuresInBag(bagGuid, type, status, languageCode, -1);
    }

    public List doLoadStructuresInBag(String bagGuid, char type, char status, String languageCode, int maxRole) throws EJBException, R01MCatalogElementNotFoundException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadStructuresInBag bagGUID: " + bagGuid + " type:" + type + " status:" + status + " languageCode:" + languageCode + " maxRole:" + maxRole);
        }
        if (!this.doCheckBagExistence(bagGuid, true)) {
            R01FLog.to((String)LOG_TYPE_ID).warning("La bolsa de identificador '" + bagGuid + "' NO EXISTE.");
            return null;
        }
        try {
            R01EStructuresManager structuresManager = new R01EStructuresManager();
            return structuresManager.doLoadStructuresInBag(bagGuid, type, status, languageCode, maxRole);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MCatalogElementNotFoundException catEnfEx) {
            throw new EJBException((Exception)((Object)catEnfEx));
        }
    }

    public List doGetLabelsInItsStructures(String[] labelOids) throws EJBException, R01MCatalogElementNotFoundException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoGetLabelsInItsStructures");
        }
        R01EStructuresManager structuresManager = new R01EStructuresManager();
        try {
            return structuresManager.doGetLabelsInItsStructures(labelOids);
        }
        catch (R01MCatalogElementNotFoundException enfEx) {
            throw new EJBException((Exception)((Object)enfEx));
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
    }

    public List doLoadBranches(List vBranchCriteria) throws EJBException, R01MCatalogElementNotFoundException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadBranches");
        }
        try {
            R01EStructuresManager structuresManager = new R01EStructuresManager();
            return structuresManager.doLoadBranches(vBranchCriteria);
        }
        catch (R01MCatalogElementNotFoundException enfEx) {
            throw new EJBException((Exception)((Object)enfEx));
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
    }

    public List doGetStructuresConfig(String propXPath) throws EJBException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoGetStructuresConfig");
        }
        R01EStructuresManager structuresManager = new R01EStructuresManager();
        return structuresManager.doGetStructuresConfig(propXPath);
    }

    public List doLoadChildren(List vNodes, boolean ordered) throws EJBException, R01MCatalogElementNotFoundException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadChildren");
        }
        try {
            R01ELabelsManager labelsManager = new R01ELabelsManager();
            return labelsManager.doLoadChildren(vNodes, ordered);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MCatalogElementNotFoundException catEnfEx) {
            throw new EJBException((Exception)((Object)catEnfEx));
        }
    }

    public List doLoadChildRelations(String structureOid, int relationId, String languageCode) throws EJBException, R01MCatalogException, R01MCatalogElementNotFoundException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadChildren");
        }
        try {
            R01ELabelsManager labelsManager = new R01ELabelsManager();
            return labelsManager.doLoadChildRelations(structureOid, relationId, languageCode);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MCatalogElementNotFoundException catEnfEx) {
            throw new EJBException((Exception)((Object)catEnfEx));
        }
    }

    public List doLoadSimilarLabels(String labelGuid) throws EJBException, R01MCatalogElementNotFoundException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadSimilarLabels labelGuid:" + labelGuid);
        }
        try {
            R01ELabelsManager labelsManager = new R01ELabelsManager();
            return labelsManager.doLoadSimilarLabels(labelGuid);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MCatalogElementNotFoundException catEnfEx) {
            throw new EJBException((Exception)((Object)catEnfEx));
        }
    }

    public List doLoadSimilarRelations(String labelGuid) throws EJBException, R01MCatalogElementNotFoundException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadSimilarLabels labelGuid:" + labelGuid);
        }
        try {
            R01ELabelsManager labelsManager = new R01ELabelsManager();
            return labelsManager.doLoadSimilarRelations(labelGuid);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MCatalogElementNotFoundException catEnfEx) {
            throw new EJBException((Exception)((Object)catEnfEx));
        }
    }

    public List doLoadSimilarBidirectionalRelations(String labelGuid) throws EJBException, R01MCatalogElementNotFoundException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadSimilarLabels labelGuid:" + labelGuid);
        }
        try {
            R01ELabelsManager labelsManager = new R01ELabelsManager();
            return labelsManager.doLoadSimilarBidirectionalRelations(labelGuid);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MCatalogElementNotFoundException catEnfEx) {
            throw new EJBException((Exception)((Object)catEnfEx));
        }
    }

    public int doSaveStructure(R01MUserContext userCtx, R01MStructure structure, String bagGuid) throws EJBException, R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogException {
        int structureId;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoCreateStructure structure:" + structure + " bagGuid:" + bagGuid);
        }
        try {
            R01EStructuresManager structuresManager = new R01EStructuresManager();
            structureId = structuresManager.doSaveStructure(userCtx, structure, bagGuid);
        }
        catch (R01MCatalogElementNotFoundException enfEx) {
            throw new EJBException((Exception)((Object)enfEx));
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MSecurityException secExc) {
            throw new EJBException((Exception)((Object)secExc));
        }
        this._reloadCaches();
        return structureId;
    }

    public int doAddRelation(R01MUserContext userCtx, String bagOid, R01MRelation relation, int role) throws EJBException, R01MSecurityException, R01MCatalogException {
        int relationId;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoAddRelation()");
        }
        try {
            R01ELabelsManager labelsManager = new R01ELabelsManager();
            relationId = labelsManager.doAddRelation(userCtx, bagOid, relation, role);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MSecurityException secExc) {
            throw new EJBException((Exception)((Object)secExc));
        }
        this._reloadCaches();
        return relationId;
    }

    public int doAddBidirectionalRelation(R01MUserContext userCtx, String bagOid, R01MRelation relation, int role) throws EJBException, R01MSecurityException, R01MCatalogException {
        int relationId;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoAddRelation()");
        }
        try {
            R01ELabelsManager labelsManager = new R01ELabelsManager();
            relationId = labelsManager.doAddBidirectionalRelation(userCtx, bagOid, relation, role);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MSecurityException secExc) {
            throw new EJBException((Exception)((Object)secExc));
        }
        this._reloadCaches();
        return relationId;
    }

    public void doRemoveRelation(R01MUserContext userCtx, String bagOid, int role, int relationId) throws EJBException, R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoRemoveRelation()");
        }
        try {
            R01ELabelsManager labelsManager = new R01ELabelsManager();
            labelsManager.doRemoveRelation(userCtx, bagOid, role, relationId);
        }
        catch (R01MCatalogElementNotFoundException enfEx) {
            throw new EJBException((Exception)((Object)enfEx));
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MSecurityException secExc) {
            throw new EJBException((Exception)((Object)secExc));
        }
        this._reloadCaches();
    }

    public void doUpdateOrderRelations(R01MUserContext userCtx, String bagOid, List relations) throws EJBException, R01MSecurityException, R01MCatalogException, R01MCatalogElementNotFoundException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tddoUpdateOrderRelations");
        }
        try {
            R01ELabelsManager labelsManager = new R01ELabelsManager();
            labelsManager.doUpdateOrderRelations(userCtx, bagOid, relations);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MSecurityException secExc) {
            throw new EJBException((Exception)((Object)secExc));
        }
        catch (R01MCatalogElementNotFoundException catEnfEx) {
            throw new EJBException((Exception)((Object)catEnfEx));
        }
        this._reloadCaches();
    }

    public void doRemoveStructure(R01MUserContext userCtx, String bagOid, String structureGuid) throws EJBException, R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoRemoveStructure structureGuid:" + structureGuid);
        }
        try {
            R01EStructuresManager structuresManager = new R01EStructuresManager();
            structuresManager.doRemoveStructure(userCtx, bagOid, structureGuid);
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MCatalogElementNotFoundException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
        catch (Exception catEx) {
            throw new EJBException(catEx);
        }
        this._reloadCaches();
    }

    public void doMoveStructure(R01MUserContext userCtx, String structureGuid, String bagGuid, String newBagGuid) throws EJBException, R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoMoveStructure structureGuid: " + structureGuid);
        }
        try {
            R01EStructuresManager structuresManager = new R01EStructuresManager();
            structuresManager.doMoveStructure(userCtx, structureGuid, bagGuid, newBagGuid);
        }
        catch (R01MCatalogElementNotFoundException enfExc) {
            throw new EJBException((Exception)((Object)enfExc));
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        this._reloadCaches();
    }

    public List doLoadStructuresInGroup(String tagGroup) throws EJBException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadStructuresInGroup tagGroup:" + tagGroup);
        }
        try {
            R01EStructuresManager structuresManager = new R01EStructuresManager();
            return structuresManager.doLoadStructuresInGroup(tagGroup);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
    }

    public void doExecuteRecatalogationProcess(R01MUserContext userCtx, R01MChangesLabelsPacket packet) throws EJBException, R01MSecurityException, R01MCatalogException {
        if (packet == null || StringUtils.isEmptyString((String)packet.getPacketOid())) {
            return;
        }
        if (!this._validateAdminContext(userCtx)) {
            throw new EJBException((Exception)((Object)new R01MSecurityException("El usuario no tiene permisos de ejecuci\u00f3n del proceso.")));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoExecuteRecatalogationProcess\r\n");
            R01FLog.to((String)LOG_TYPE_ID).info(packet.composeDebugInfo().toString());
        }
        this._reloadCaches();
        try {
            R01EOperationsManager operationManager = new R01EOperationsManager();
            operationManager.doExecuteRecatalogationProcess(userCtx, packet);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
    }

    public void doLaunchPacket(R01MUserContext userCtx, String packetOid, int numOperations, List listeners, int typeProcessor, boolean forceProcessor) throws EJBException, R01MSecurityException, R01MCatalogException {
        if (StringUtils.isEmptyString((String)packetOid) || !NumberUtils.isInteger((String)("" + numOperations)) || numOperations <= 0) {
            return;
        }
        if (!this._validateAdminContext(userCtx)) {
            throw new EJBException((Exception)((Object)new R01MSecurityException("El usuario no tiene permisos de ejecuci\u00f3n del proceso.")));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLaunchPacket\r\n");
        }
        try {
            R01EOperationsManager operationManager = new R01EOperationsManager();
            operationManager.doLaunchPacket(userCtx, packetOid, numOperations, listeners, typeProcessor, forceProcessor);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
    }

    public List doLoadPacketsInfo(R01MUserContext userCtx) throws EJBException, R01MSecurityException, R01MCatalogException {
        if (!this._validateAdminContext(userCtx)) {
            throw new EJBException((Exception)((Object)new R01MSecurityException("El usuario no tiene permisos de ejecuci\u00f3n del proceso.")));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadPacketsInfo\r\n");
            R01FLog.to((String)LOG_TYPE_ID).info("Cargando la informaci\u00f3n de los paquetes de recatalogaci\u00f3n procesados ........");
        }
        try {
            R01EOperationsManager operationManager = new R01EOperationsManager();
            return operationManager.doLoadPacketsInfo(userCtx);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
    }

    public Map doLoadPacketAdminInfo(R01MUserContext userCtx) throws EJBException, R01MSecurityException, R01MCatalogException {
        if (!this._validateAdminContext(userCtx)) {
            throw new EJBException((Exception)((Object)new R01MSecurityException("El usuario no tiene permisos de ejecuci\u00f3n del proceso.")));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadPacketAdminInfo\r\n");
            R01FLog.to((String)LOG_TYPE_ID).info("Cargando la informaci\u00f3n del paquete de administraci\u00f3n a generar");
        }
        try {
            R01EOperationsManager operationManager = new R01EOperationsManager();
            return operationManager.doLoadPacketAdminInfo(userCtx);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
    }

    public R01MPacketInfo doLoadPacketInfo(R01MUserContext userCtx, String packetOid) throws EJBException, R01MSecurityException, R01MCatalogException, R01MCatalogElementNotFoundException {
        if (!this._validateAdminContext(userCtx)) {
            throw new EJBException((Exception)((Object)new R01MSecurityException("El usuario no tiene permisos de ejecuci\u00f3n del proceso.")));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadPacketInfo\r\n");
            R01FLog.to((String)LOG_TYPE_ID).info("Cargando la informaci\u00f3n del paquete " + packetOid);
        }
        try {
            R01EOperationsManager operationManager = new R01EOperationsManager();
            return operationManager.doLoadPacketInfo(userCtx, packetOid);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MCatalogElementNotFoundException enfExc) {
            throw new EJBException((Exception)((Object)enfExc));
        }
    }

    public void doMovePacketToHistory(R01MUserContext userCtx, String packetOid) throws EJBException, R01MSecurityException, R01MCatalogException {
        if (!this._validateAdminContext(userCtx)) {
            throw new EJBException((Exception)((Object)new R01MSecurityException("El usuario no tiene permisos de ejecuci\u00f3n del proceso.")));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoMovePacketToHistory\r\n");
            R01FLog.to((String)LOG_TYPE_ID).info("Archivando el paquete de oid '" + packetOid + "' ........");
        }
        try {
            R01EOperationsManager operationManager = new R01EOperationsManager();
            operationManager.doMovePacketToHistory(userCtx, packetOid);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
    }

    public List doPreviewReport(R01MUserContext userCtx, String packetOid, int numOperations, String system) throws EJBException, R01MSecurityException, R01MCatalogException {
        if (!this._validateAdminContext(userCtx)) {
            throw new EJBException((Exception)((Object)new R01MSecurityException("El usuario no tiene permisos de ejecuci\u00f3n del proceso.")));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLaunchPacket\r\n");
        }
        try {
            R01EOperationsManager operationManager = new R01EOperationsManager();
            return operationManager.doPreviewReport(userCtx, packetOid, numOperations, system);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
    }

    public List doLoadBagGroupsByBag(int bagId) throws EJBException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadGroupsByBag bagId:" + bagId);
        }
        try {
            R01EBagsManager bagsManager = new R01EBagsManager();
            return bagsManager.doLoadBagGroupsByBag(bagId);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
    }

    public List<R01MBagGroup> doLoadBagGroups(String userLang) throws EJBException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadBagGroups");
        }
        try {
            R01EBagsManager bagsManager = new R01EBagsManager();
            return bagsManager.doLoadBagGroups(userLang);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
    }

    public R01MBagGroup doLoadBagGroup(int bagGroupId, String userLang) throws EJBException, R01MCatalogException, R01MCatalogElementNotFoundException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoLoadBagGroup bagGroupId = " + bagGroupId);
        }
        try {
            R01EBagsManager bagsManager = new R01EBagsManager();
            return bagsManager.doLoadBagGroup(bagGroupId, userLang);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MCatalogElementNotFoundException enfExc) {
            throw new EJBException((Exception)((Object)enfExc));
        }
    }

    public void doRemoveBagGroup(int bagGroupId) throws EJBException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoRemoveBagGroup bagGroupId = " + bagGroupId);
        }
        try {
            R01EBagsManager bagsManager = new R01EBagsManager();
            bagsManager.doRemoveBagGroup(bagGroupId);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
    }

    public int doSaveBagGroup(R01MBagGroup theBagGroup) throws EJBException, R01MCatalogException, R01MDuplicateCatalogElementException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoSaveBagGroup bagGroupId = " + theBagGroup.getId());
        }
        try {
            R01EBagsManager bagsManager = new R01EBagsManager();
            return bagsManager.doSaveBagGroup(theBagGroup);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
        catch (R01MDuplicateCatalogElementException dupliEx) {
            throw new EJBException((Exception)((Object)dupliEx));
        }
    }

    public List doValidateLabelsInOtherStructure(String structureGuid) throws EJBException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tdoValidateLabelsInOtherStructure structureDef = " + structureGuid);
        }
        try {
            R01EStructuresManager structuresManager = new R01EStructuresManager();
            return structuresManager.doValidateLabelsInOtherStructure(structureGuid);
        }
        catch (R01MCatalogException catEx) {
            throw new EJBException((Exception)((Object)catEx));
        }
    }

    public boolean doCheckBagExistence(String bagOid, boolean useGuid) throws EJBException, R01MCatalogException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01ECatalogServicesSL.doCheckBagExistence()...");
        }
        try {
            R01EBagsManager service = new R01EBagsManager();
            return service.doCheckBagExistence(bagOid, useGuid);
        }
        catch (R01MCatalogException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    private boolean _validateAdminContext(R01MUserContext userCtx) {
        if (userCtx == null) {
            return false;
        }
        return userCtx.getUserProfile().equals("masterSystem");
    }

    private void _reloadCaches() {
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01e.cache").info("Notificando la recarga de caches de ejes");
            }
            R01NCachesNotifierSLUtil.getHome().create().reloadCatalogCache();
            if (DEBUG) {
                R01FLog.to((String)"r01e.cache").info("Fin notificaci\u00f3n de la recarga de caches de ejes");
            }
        }
        catch (R01MJMSException jmsExc) {
            if (DEBUG) {
                R01FLog.to((String)"r01e.cache").severe("REGENERADOR: Error en la recarga de caches de ejes:" + jmsExc.getMessage());
            }
            jmsExc.printStackTrace(System.out);
        }
        catch (RemoteException rmtExc) {
            if (DEBUG) {
                R01FLog.to((String)"r01e.cache").severe("REGENERADOR: No se encuentra el EJB de recarga de caches de ejes:" + rmtExc.getMessage());
            }
            rmtExc.printStackTrace(System.out);
        }
        catch (CreateException crtExc) {
            if (DEBUG) {
                R01FLog.to((String)"r01e.cache").severe("REGENERADOR: No se puede crear el servicio de recarga de caches de ejes:" + crtExc.getMessage());
            }
            crtExc.printStackTrace(System.out);
        }
        catch (NamingException namExc) {
            if (DEBUG) {
                R01FLog.to((String)"r01e.cache").severe("REGENERADOR: No se encuentra el EJB de recarga de ejes:" + namExc.getMessage());
            }
            namExc.printStackTrace(System.out);
        }
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01e.cache").info("Notificando la recarga de caches del buscador");
            }
            R01NCachesNotifierSLUtil.getHome().create().reloadSearchEngineCache();
            if (DEBUG) {
                R01FLog.to((String)"r01e.cache").info("Fin notificaci\u00f3n de la recarga de caches del buscador");
            }
        }
        catch (R01MJMSException jmsExc) {
            if (DEBUG) {
                R01FLog.to((String)"r01e.cache").severe("REGENERADOR: Error en la recarga de caches del buscador:" + jmsExc.getMessage());
            }
            jmsExc.printStackTrace(System.out);
        }
        catch (RemoteException rmtExc) {
            if (DEBUG) {
                R01FLog.to((String)"r01e.cache").severe("REGENERADOR: No se encuentra el EJB de recarga de caches del buscador:" + rmtExc.getMessage());
            }
            rmtExc.printStackTrace(System.out);
        }
        catch (CreateException crtExc) {
            if (DEBUG) {
                R01FLog.to((String)"r01e.cache").severe("REGENERADOR: No se puede crear el servicio de recarga de caches del buscador:" + crtExc.getMessage());
            }
            crtExc.printStackTrace(System.out);
        }
        catch (NamingException namExc) {
            if (DEBUG) {
                R01FLog.to((String)"r01e.cache").severe("REGENERADOR: No se encuentra el EJB de recarga del buscador:" + namExc.getMessage());
            }
            namExc.printStackTrace(System.out);
        }
        R01FLog.to((String)LOG_TYPE_ID).info("%%%%%%%%%%%%%%%%% FIN PROCESO DE CARGA DE CACHES DE EJES Y GUIAS DE NAVEGACION ( " + new Date() + " )%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\r\n\r\n\r\n\r\n\r\n\r\n");
    }
}

