/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.runtime.internal;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.runtime.CFlow;
import org.aspectj.runtime.internal.CFlowPlusState;

public class CFlowStack {
    private Hashtable stacks = new Hashtable();
    private Thread cached_thread;
    private Stack cached_stack;
    private int change_count = 0;
    private static final int COLLECT_AT = 20000;
    private static final int MIN_COLLECT_AT = 100;

    private synchronized Stack getThreadStack() {
        if (Thread.currentThread() != this.cached_thread) {
            this.cached_thread = Thread.currentThread();
            this.cached_stack = (Stack)this.stacks.get(this.cached_thread);
            if (this.cached_stack == null) {
                this.cached_stack = new Stack();
                this.stacks.put(this.cached_thread, this.cached_stack);
            }
            ++this.change_count;
            int size = Math.max(1, this.stacks.size());
            if (this.change_count > Math.max(100, 20000 / size)) {
                Stack<Thread> dead_stacks = new Stack<Thread>();
                Enumeration e = this.stacks.keys();
                while (e.hasMoreElements()) {
                    Thread t = (Thread)e.nextElement();
                    if (t.isAlive()) continue;
                    dead_stacks.push(t);
                }
                Enumeration e2 = dead_stacks.elements();
                while (e2.hasMoreElements()) {
                    Thread t = (Thread)e2.nextElement();
                    this.stacks.remove(t);
                }
                this.change_count = 0;
            }
        }
        return this.cached_stack;
    }

    public void push(Object obj) {
        this.getThreadStack().push(obj);
    }

    public void pushInstance(Object obj) {
        this.getThreadStack().push(new CFlow(obj));
    }

    public void push(Object[] obj) {
        this.getThreadStack().push(new CFlowPlusState(obj));
    }

    public void pop() {
        this.getThreadStack().pop();
    }

    public Object peek() {
        Stack stack = this.getThreadStack();
        if (stack.isEmpty()) {
            throw new NoAspectBoundException();
        }
        return stack.peek();
    }

    public Object get(int index) {
        CFlow cf = this.peekCFlow();
        return null == cf ? null : cf.get(index);
    }

    public Object peekInstance() {
        CFlow cf = this.peekCFlow();
        if (cf != null) {
            return cf.getAspect();
        }
        throw new NoAspectBoundException();
    }

    public CFlow peekCFlow() {
        Stack stack = this.getThreadStack();
        if (stack.isEmpty()) {
            return null;
        }
        return (CFlow)stack.peek();
    }

    public CFlow peekTopCFlow() {
        Stack stack = this.getThreadStack();
        if (stack.isEmpty()) {
            return null;
        }
        return (CFlow)stack.elementAt(0);
    }

    public boolean isValid() {
        return !this.getThreadStack().isEmpty();
    }
}

