/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01k.searchorchestrator.searchperformers;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.NumberUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01k.searchorchestrator.searchperformers.R01KMetaDataStorageWrapper;
import com.ejie.r01k.searchorchestrator.searchperformers.R01KSearchEngineReturnedDataToResultItemTransformer;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MClusterStorageConfig;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MFamilyStorageConfig;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MMetaDataStorageConfig;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MSearchMetaDataStorageConfig;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MTypeStorageConfig;
import com.ejie.r01m.exceptions.R01MSearchPerformerException;
import com.ejie.r01m.objects.searchengine.indexer.R01MRispDocument;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItemDocumentLinkedDataInfo;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItemPublicationInfo;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItemStructureCatalog;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class R01KSearchEngineReturnedDataToResultItemTransformerDefImpl
implements R01KSearchEngineReturnedDataToResultItemTransformer {
    private static boolean DEBUG = R01FLog.getLogLevel((String)"r01k.searchResultMapper").intValue() != Level.OFF.intValue();
    private static Map _SEARCHENGINE_COLS_TO_METADATA_MAPPINGS = new HashMap();
    private transient String _metaDataToSearchEngineReturnedColMappingPropertyName = null;
    private transient Properties _props = null;
    private transient String _nativeDateFormat = "dd/MM/yyyy";

    public R01KSearchEngineReturnedDataToResultItemTransformerDefImpl() {
    }

    public R01KSearchEngineReturnedDataToResultItemTransformerDefImpl(String metaDataToSearchEngineReturnedColMappingPropertyName) {
        this._metaDataToSearchEngineReturnedColMappingPropertyName = metaDataToSearchEngineReturnedColMappingPropertyName;
    }

    @Override
    public void setProperties(Properties props) {
        this._props = props;
    }

    @Override
    public Properties getProperties() {
        return this._props;
    }

    @Override
    public void setNativeDateFormat(String dateFormat) {
        this._nativeDateFormat = dateFormat;
    }

    @Override
    public String getNativeDateFormat() {
        return this._nativeDateFormat;
    }

    public String getMetaDataToSearchEngineReturnedColMappingPropertyName() {
        return this._metaDataToSearchEngineReturnedColMappingPropertyName;
    }

    public void setMetaDataToSearchEngineReturnedColMappingPropertyName(String metaDataToSearchEngineReturnedColMappingPropertyName) {
        this._metaDataToSearchEngineReturnedColMappingPropertyName = metaDataToSearchEngineReturnedColMappingPropertyName;
    }

    @Override
    public void setSearchMetaDataStorageConfig(R01MSearchMetaDataStorageConfig metaDataStorageConfig) {
    }

    @Override
    public R01MSearchResultItem mapSearchEngineReturnedDataToResultItem(R01MSearchMetaDataStorageConfig searchMetaDataStorageCfg, Map searchEngineReturnedCols, int itemNumber) throws R01MSearchPerformerException {
        return this._composeResultItem(searchMetaDataStorageCfg, searchEngineReturnedCols, itemNumber);
    }

    private R01MSearchResultItem _composeResultItem(R01MSearchMetaDataStorageConfig searchEngineMetaDataStorageCfg, Map record, int itemNumber) throws R01MSearchPerformerException {
        R01MSearchResultItem outItem = new R01MSearchResultItem();
        outItem.itemNumber = itemNumber;
        outItem.score = 0.0f;
        Map searchEngineColsToMetaDataMapping = (Map)_SEARCHENGINE_COLS_TO_METADATA_MAPPINGS.get(this._metaDataToSearchEngineReturnedColMappingPropertyName);
        if (searchEngineColsToMetaDataMapping == null) {
            searchEngineColsToMetaDataMapping = this._mapColumnsToMetaData(searchEngineMetaDataStorageCfg, this._metaDataToSearchEngineReturnedColMappingPropertyName);
            _SEARCHENGINE_COLS_TO_METADATA_MAPPINGS.put(this._metaDataToSearchEngineReturnedColMappingPropertyName, searchEngineColsToMetaDataMapping);
        }
        Map.Entry currColItem2 = null;
        StringBuffer currItemDebugStr = null;
        if (DEBUG) {
            currItemDebugStr = new StringBuffer();
        }
        for (Map.Entry currColItem2 : record.entrySet()) {
            Map colMapping = (Map)searchEngineColsToMetaDataMapping.get(currColItem2.getKey().toString());
            if (DEBUG) {
                currItemDebugStr.setLength(0);
            }
            if (colMapping == null) {
                if (!DEBUG) continue;
                currItemDebugStr.append("\r\n\t...columna-metaDato: ");
                currItemDebugStr.append(currColItem2.getKey());
                currItemDebugStr.append(" [**WARNING**] NO se ha definido el miembro del objeto R01MSearchResultItem en el que poner el resultado para la columna. Revisa el fichero searchMetaDataStorage.xml");
                continue;
            }
            R01KMetaDataStorageWrapper currSearchResultItemMetadataStorageWrap2 = null;
            for (R01KMetaDataStorageWrapper currSearchResultItemMetadataStorageWrap2 : colMapping.values()) {
                if (DEBUG) {
                    currItemDebugStr.append("\r\n\t...columna-metaDato: ");
                    currItemDebugStr.append(currColItem2.getKey());
                }
                if (currSearchResultItemMetadataStorageWrap2 != null) {
                    ArrayList memberValue;
                    if (DEBUG) {
                        currItemDebugStr.append(" <-> ");
                        currItemDebugStr.append(currSearchResultItemMetadataStorageWrap2.getMetaDataStCfg().getOid());
                    }
                    if (currColItem2.getValue() == null) {
                        if (!DEBUG) continue;
                        currItemDebugStr.append(": null");
                        continue;
                    }
                    if (DEBUG) {
                        currItemDebugStr.append(": NO null (");
                        currItemDebugStr.append(currColItem2.getValue());
                        currItemDebugStr.append(')');
                    }
                    if ((memberValue = this._obtainMetaDataValue(currSearchResultItemMetadataStorageWrap2.getMetaDataStCfg(), (String)currColItem2.getValue())) == null) continue;
                    try {
                        if ("documentMetaData".equals(currSearchResultItemMetadataStorageWrap2.getMemberType())) {
                            if (outItem.getDocumentMetaData() == null) {
                                outItem.setDocumentMetaData(new HashMap());
                            }
                            outItem.getDocumentMetaData().put(currSearchResultItemMetadataStorageWrap2.getMetaDataStCfg().getOid(), memberValue);
                            continue;
                        }
                        if ("member".equals(currSearchResultItemMetadataStorageWrap2.getMemberType())) {
                            ReflectionUtils.setMemberValueUsingPath((Object)outItem, (String)currSearchResultItemMetadataStorageWrap2.getMetaDataStCfg().getSearchResultItemMember(), (Object)memberValue, (boolean)true);
                            continue;
                        }
                        if (currSearchResultItemMetadataStorageWrap2.getMemberType().equals("Map")) {
                            HashMap theMap = (HashMap)ReflectionUtils.getMemberValue((Object)outItem, (String)currSearchResultItemMetadataStorageWrap2.getMetaDataStCfg().getSearchResultItemMember(), (boolean)true);
                            if (theMap == null) {
                                theMap = new HashMap();
                            }
                            theMap.put(currSearchResultItemMetadataStorageWrap2.getMetaDataStCfg().getOid(), currColItem2.getValue());
                            ReflectionUtils.setMemberValue((Object)outItem, (String)currSearchResultItemMetadataStorageWrap2.getMetaDataStCfg().getSearchResultItemMember(), HashMap.class, memberValue, (boolean)true);
                            continue;
                        }
                        if (!currSearchResultItemMetadataStorageWrap2.getMemberType().equals("List")) continue;
                        List theList = (List)ReflectionUtils.getMemberValue((Object)outItem, (String)currSearchResultItemMetadataStorageWrap2.getMetaDataStCfg().getSearchResultItemMember(), (boolean)true);
                        if (theList == null) {
                            memberValue = new ArrayList();
                        }
                        theList.add(currColItem2.getValue());
                        ReflectionUtils.setMemberValue((Object)outItem, (String)currSearchResultItemMetadataStorageWrap2.getMetaDataStCfg().getSearchResultItemMember(), ArrayList.class, memberValue, (boolean)true);
                    }
                    catch (NoSuchFieldException nsfEx) {
                        if (!DEBUG) continue;
                        currItemDebugStr.append(" [**WARNING**] No se encuentra el miembro ");
                        currItemDebugStr.append(currSearchResultItemMetadataStorageWrap2.getMetaDataStCfg().getSearchResultItemMember());
                        currItemDebugStr.append(": ");
                        currItemDebugStr.append(nsfEx.getMessage());
                    }
                    catch (ReflectionException refEx) {
                        if (!DEBUG) continue;
                        currItemDebugStr.append(" [**WARNING**] Error al establecer el valor en el miembro ");
                        currItemDebugStr.append(currSearchResultItemMetadataStorageWrap2.getMetaDataStCfg().getSearchResultItemMember());
                        currItemDebugStr.append(": ");
                        currItemDebugStr.append(refEx.getMessage());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                if (!DEBUG) continue;
                currItemDebugStr.append(" [**WARNING**] NO se ha definido el miembro del objeto R01MSearchResultItem en el que poner el resultado devuelto para la columna. Revisa el fichero searchMetaDataStorage.xml");
            }
            if (!DEBUG) continue;
            R01FLog.to((String)"r01k.searchResultMapper").info(currItemDebugStr.toString());
        }
        if (outItem != null && outItem.getContentTypology() != null && outItem.getContentTypology().isValid() && outItem.getDocumentMetaData() != null) {
            ArrayList<String> metaDataToRemove = new ArrayList<String>();
            String currMetaDataOid2 = null;
            R01MClusterStorageConfig clusterStorage = null;
            R01MFamilyStorageConfig familyStorage = null;
            R01MTypeStorageConfig typeStorage = null;
            for (String currMetaDataOid2 : outItem.getDocumentMetaData().keySet()) {
                clusterStorage = searchEngineMetaDataStorageCfg.getClusterStorageConfigs(outItem.getContentTypology().getClusterOid());
                familyStorage = clusterStorage.getFamilyStorageConfig(outItem.getContentTypology().getFamilyOid());
                if (familyStorage != null) {
                    typeStorage = familyStorage.getTypeStorageConfig(outItem.getContentTypology().getTypeOid());
                }
                if (typeStorage == null || typeStorage.getMetaDataStorageConfig(currMetaDataOid2) != null) continue;
                metaDataToRemove.add(currMetaDataOid2);
            }
            Iterator<Object> it = metaDataToRemove.iterator();
            while (it.hasNext()) {
                outItem.getDocumentMetaData().remove(it.next());
            }
        }
        return outItem;
    }

    private Object _obtainMetaDataValue(R01MMetaDataStorageConfig mdStorageCfg, String searchEngineColValue) {
        Object memberValue = null;
        if (mdStorageCfg.getDataType().trim().toUpperCase().equals("FLOAT") && NumberUtils.isFloat((String)searchEngineColValue)) {
            memberValue = new Float(NumberUtils.toFloat((String)searchEngineColValue));
        } else if (mdStorageCfg.getDataType().trim().toUpperCase().equals("DOUBLE") && NumberUtils.isDouble((String)searchEngineColValue)) {
            memberValue = new Double(NumberUtils.toDouble((String)searchEngineColValue));
        } else if (mdStorageCfg.getDataType().trim().toUpperCase().equals("INTEGER") && NumberUtils.isInteger((String)searchEngineColValue)) {
            memberValue = new Integer(NumberUtils.toInt((String)searchEngineColValue));
        } else if (mdStorageCfg.getDataType().trim().toUpperCase().equals("LONG") && NumberUtils.isLong((String)searchEngineColValue)) {
            memberValue = new Long(NumberUtils.toLong((String)searchEngineColValue));
        } else if (mdStorageCfg.getDataType().trim().toUpperCase().equals("DATE")) {
            memberValue = DateUtils.getDateFromFormatedString((String)searchEngineColValue, (String)this.getNativeDateFormat());
            if (memberValue == null) {
                R01FLog.to((String)"r01k.searchResultMapper").warning("NO se ha podido formatear la fecha " + searchEngineColValue + " al formato " + this.getNativeDateFormat() + ". Revisa el parametro <nativeDateFormat> del fichero de configuracion r01kSearchEngineConfig.xml para el performer de b\u00fasqueda utilizado");
            }
        } else if (mdStorageCfg.getDataType().toUpperCase().startsWith("DATE(")) {
            String dateFormat = mdStorageCfg.getDataType().substring(5, mdStorageCfg.getDataType().length() - 2);
            memberValue = DateUtils.getDateFromFormatedString((String)searchEngineColValue, (String)dateFormat);
            if (memberValue == null) {
                R01FLog.to((String)"r01k.searchResultMapper").warning("NO se ha podido formatear la fecha " + searchEngineColValue + " al formato " + dateFormat + ". Revisa el parametro <nativeDateFormat> del fichero de configuracion r01kSearchEngineConfig.xml para el performer de b\u00fasqueda utilizado");
            }
        } else if (mdStorageCfg.getDataType().indexOf("R01MSearchResultItemStructureCatalog") > 0) {
            memberValue = this._parseStructureCats(searchEngineColValue);
        } else if (mdStorageCfg.getDataType().indexOf("R01MSearchResultItemPublicationInfo") > 0) {
            memberValue = this._parsePubInfo(searchEngineColValue);
        } else if (mdStorageCfg.getDataType().indexOf("R01MSearchResultItemDocumentLinkedDataInfo") > 0) {
            memberValue = this._parseLinkedDataInfo(searchEngineColValue);
        } else if (mdStorageCfg.getDataType().equals("Map(String)")) {
            if (mdStorageCfg.getOid().equals("documentMainDataFileGeneratedFilesDocumentRelativePaths")) {
                memberValue = this._parseDocumentDataFileGeneratedFilesDocumentRelativePaths(searchEngineColValue);
            } else if (mdStorageCfg.getOid().equals("documentDataFilesGeneratedFilesDocumentRelativePaths")) {
                memberValue = this._parseDocumentDataFilesGeneratedFilesDocumentRelativePaths(searchEngineColValue);
            } else if (mdStorageCfg.getOid().equals("contentRispDocumentsInfo")) {
                Map stringBufferMapValue = R01MRispDocument.jsonArrayToMap((String)searchEngineColValue);
                if (stringBufferMapValue != null) {
                    HashMap stringMapValue = new HashMap();
                    for (Map.Entry entry : stringBufferMapValue.entrySet()) {
                        stringMapValue.put(entry.getKey(), ((StringBuffer)entry.getValue()).toString());
                    }
                    memberValue = stringMapValue;
                }
                if (memberValue == null) {
                    memberValue = this._parseStringToMap(searchEngineColValue);
                }
            } else {
                memberValue = mdStorageCfg.getOid().equals("linkedSizeByTagSrc") ? this._parseLinkedSize(searchEngineColValue.replace('\u001f', '\"')) : this._parseStringToMap(searchEngineColValue);
            }
        } else {
            memberValue = searchEngineColValue;
        }
        return memberValue;
    }

    private List _parsePubInfo(String pubInfo) {
        if (StringUtils.isEmptyString((String)pubInfo)) {
            return null;
        }
        String[] pubInfos = pubInfo.split(",");
        Pattern p = Pattern.compile("\\(([^;]+);([^;]+);([^;]+);([^)]+)\\)");
        ArrayList<R01MSearchResultItemPublicationInfo> outPubInfo = new ArrayList<R01MSearchResultItemPublicationInfo>(pubInfos.length);
        R01MSearchResultItemPublicationInfo currPubInfo = null;
        for (int i = 0; i < pubInfos.length; ++i) {
            Matcher m = p.matcher(pubInfos[i]);
            if (!m.find()) continue;
            long dateNum = Long.parseLong(m.group(4));
            if ("seconds".equals(this._nativeDateFormat)) {
                dateNum *= 1000L;
            }
            currPubInfo = new R01MSearchResultItemPublicationInfo(m.group(1), m.group(2), Integer.parseInt(m.group(3)), new Date(dateNum));
            outPubInfo.add(currPubInfo);
        }
        return outPubInfo.size() == 0 ? null : outPubInfo;
    }

    private List _parseStructureCats(String cats) {
        if (StringUtils.isEmptyString((String)cats)) {
            return null;
        }
        String[] catInfos = cats.split(",");
        Pattern p = Pattern.compile("\\(([^;]+);([^;]+);([^)]+)\\)");
        ArrayList<R01MSearchResultItemStructureCatalog> outCatInfo = new ArrayList<R01MSearchResultItemStructureCatalog>(catInfos.length);
        R01MSearchResultItemStructureCatalog currCat = null;
        for (int i = 0; i < catInfos.length; ++i) {
            Matcher m = p.matcher(catInfos[i]);
            if (!m.find()) continue;
            currCat = new R01MSearchResultItemStructureCatalog(m.group(1), m.group(2), m.group(3));
            outCatInfo.add(currCat);
        }
        return outCatInfo.size() == 0 ? null : outCatInfo;
    }

    private List _parseLinkedDataInfo(String lnkData) {
        if (StringUtils.isEmptyString((String)lnkData)) {
            return null;
        }
        R01MSearchResultItemDocumentLinkedDataInfo currLnkData = null;
        ArrayList<R01MSearchResultItemDocumentLinkedDataInfo> outLnkDataInfo = new ArrayList<R01MSearchResultItemDocumentLinkedDataInfo>();
        try {
            JSONObject json = new JSONObject(lnkData);
            Iterator iter = json.keys();
            outLnkDataInfo = new ArrayList(json.length());
            while (iter.hasNext()) {
                String jsonKey = (String)iter.next();
                try {
                    String oids = json.get(jsonKey).toString();
                    String[] oid = oids.split(",");
                    ArrayList<String> allDocumentOids = new ArrayList<String>();
                    if (oid.length > 0) {
                        for (int val = 0; val < oid.length; ++val) {
                            allDocumentOids.add(oid[val]);
                        }
                    }
                    currLnkData = new R01MSearchResultItemDocumentLinkedDataInfo(jsonKey, allDocumentOids);
                    outLnkDataInfo.add(currLnkData);
                }
                catch (JSONException ex) {}
            }
            return outLnkDataInfo.size() == 0 ? null : outLnkDataInfo;
        }
        catch (JSONException ex) {
            return null;
        }
    }

    private Map _parseLinkedSize(String lnkSize) {
        if (StringUtils.isEmptyString((String)lnkSize)) {
            return null;
        }
        try {
            JSONObject json = new JSONObject(lnkSize);
            Iterator iter = json.keys();
            HashMap<String, String> currLnkSize = new HashMap<String, String>(json.length());
            while (iter.hasNext()) {
                String jsonKey = (String)iter.next();
                try {
                    String size = json.get(jsonKey).toString();
                    currLnkSize.put(jsonKey, size);
                }
                catch (JSONException ex) {}
            }
            return currLnkSize.size() == 0 ? null : currLnkSize;
        }
        catch (JSONException ex) {
            return this._parseStringToMap(lnkSize);
        }
    }

    private Map _parseDocumentDataFilesGeneratedFilesDocumentRelativePaths(String dataFilesPaths) {
        if (StringUtils.isEmptyString((String)dataFilesPaths)) {
            return null;
        }
        String[] pathsSplitted = dataFilesPaths.split("$$");
        Pattern p = Pattern.compile("([^>>]+)>>\\((.*?)\\)");
        HashMap<String, String> outPaths = new HashMap<String, String>(pathsSplitted.length);
        for (int i = 0; i < pathsSplitted.length; ++i) {
            Matcher m = p.matcher(pathsSplitted[i]);
            if (!m.find()) continue;
            outPaths.put("datafileOid." + m.group(1), m.group(2));
        }
        return outPaths != null && outPaths.size() == 0 ? null : outPaths;
    }

    private Map _parseDocumentDataFileGeneratedFilesDocumentRelativePaths(String templateAndPaths) {
        if (StringUtils.isEmptyString((String)templateAndPaths)) {
            return null;
        }
        HashMap<String, String> outPaths = null;
        Pattern p = Pattern.compile("\\(([^;]+);(.*?)\\)");
        Matcher m = p.matcher(templateAndPaths);
        if (m.matches()) {
            String paths = m.group(2);
            String[] pathsSplitted = paths.split(",");
            outPaths = new HashMap<String, String>(pathsSplitted.length);
            for (int i = 0; i < pathsSplitted.length; ++i) {
                String[] generatedFileAndPath = pathsSplitted[i].split(":");
                if (generatedFileAndPath.length != 2) continue;
                outPaths.put(generatedFileAndPath[0], generatedFileAndPath[1]);
            }
        }
        return outPaths != null && outPaths.size() == 0 ? null : outPaths;
    }

    private Map _parseStringToMap(String mapInStringFormat) {
        if (StringUtils.isEmptyString((String)mapInStringFormat)) {
            return null;
        }
        HashMap<String, String> outMap = new HashMap<String, String>();
        Pattern p = Pattern.compile("\\(([^;]+);(.*?)\\)");
        Matcher m = p.matcher(mapInStringFormat);
        while (m.find()) {
            String key = m.group(1);
            String value = m.group(2);
            outMap.put(key, value);
        }
        return outMap.size() == 0 ? null : outMap;
    }

    Map _mapColumnsToMetaData(R01MSearchMetaDataStorageConfig cfg, String mappingPropertyName) {
        if (cfg == null) {
            return null;
        }
        HashMap outMap = new HashMap();
        R01MClusterStorageConfig currClusterStorageCfg2 = null;
        Map clustersStorage = cfg.getAllClusterStorageConfig();
        if (clustersStorage != null && clustersStorage.size() > 0) {
            for (R01MClusterStorageConfig currClusterStorageCfg2 : clustersStorage.values()) {
                this._mapMetaDataListColumns(currClusterStorageCfg2.getOid(), null, null, currClusterStorageCfg2.getNotInheritedMetaData(), outMap, mappingPropertyName);
            }
        }
        R01MFamilyStorageConfig currFamilyStorageCfg2 = null;
        Map familiesStorage = cfg.getAllFamiliesStorageConfigIgnoringCluster();
        if (familiesStorage != null && familiesStorage.size() > 0) {
            for (R01MFamilyStorageConfig currFamilyStorageCfg2 : familiesStorage.values()) {
                this._mapMetaDataListColumns(null, currFamilyStorageCfg2.getOid(), null, currFamilyStorageCfg2.getNotInheritedMetaData(), outMap, mappingPropertyName);
            }
        }
        R01MTypeStorageConfig currTypeStorageCfg2 = null;
        Map typesStorage = cfg.getAllTypesStorageConfigIgnoringFamilyAndCluster();
        if (typesStorage != null && typesStorage.size() > 0) {
            for (R01MTypeStorageConfig currTypeStorageCfg2 : typesStorage.values()) {
                this._mapMetaDataListColumns(null, null, currTypeStorageCfg2.getOid(), currTypeStorageCfg2.getNotInheritedMetaData(), outMap, mappingPropertyName);
            }
        }
        return outMap;
    }

    void _mapMetaDataListColumns(String clusterOid, String familyOid, String typeOid, Map metaDataList, Map ioColToMetaDataMap, String mappingPropertyName) {
        if (metaDataList != null && metaDataList.size() > 0) {
            if (DEBUG) {
                R01FLog.to((String)"r01k.searchResultMapper").info("...carga del mapeo de columnas devueltas por el motor de b\u00fasqueda a metaDatatos (mappingPropertyName: " + mappingPropertyName + ")");
            }
            R01MMetaDataStorageConfig currMetaDataStorageCfg2 = null;
            for (R01MMetaDataStorageConfig currMetaDataStorageCfg2 : metaDataList.values()) {
                String colName = null;
                colName = "self".equals(mappingPropertyName) ? currMetaDataStorageCfg2.getOid() : currMetaDataStorageCfg2.getProperty(mappingPropertyName);
                if (colName == null) {
                    if (!DEBUG) continue;
                    R01FLog.to((String)"r01k.searchResultMapper").info("\tmetadato " + currMetaDataStorageCfg2.getOid() + ": [WARNING] NO se puede mapear con la columna devuelta por el motor de b\u00fasqueda ya que no se define la propiedad '" + mappingPropertyName + "'. Revisa el fichero searchMetaDataStorage.xml");
                    continue;
                }
                String[] multipleCols = colName.indexOf(124) > 0 ? colName.split("\\|") : new String[]{colName};
                for (int i = 0; i < multipleCols.length; ++i) {
                    String currentColName = multipleCols[i];
                    if (currentColName == null) {
                        if (!DEBUG) continue;
                        R01FLog.to((String)"r01k.searchResultMapper").info("\tmetadato " + currMetaDataStorageCfg2.getOid() + ": [WARNING] NO se puede mapear con la columna devuelta por el motor de b\u00fasqueda ya que no se define la propiedad '" + mappingPropertyName + "'. Revisa el fichero searchMetaDataStorage.xml");
                        continue;
                    }
                    R01KMetaDataStorageWrapper currMetaDataStorageWrapper = this._obtainMetaDataStorageWrapper(currMetaDataStorageCfg2);
                    HashMap<String, R01KMetaDataStorageWrapper> colMapping = (HashMap<String, R01KMetaDataStorageWrapper>)ioColToMetaDataMap.get(currentColName);
                    if (colMapping == null) {
                        colMapping = new HashMap<String, R01KMetaDataStorageWrapper>();
                        ioColToMetaDataMap.put(currentColName, colMapping);
                    }
                    String typo = (clusterOid != null ? clusterOid : "") + ":" + (familyOid != null ? familyOid : "") + ":" + (typeOid != null ? typeOid : "");
                    colMapping.put(typo, currMetaDataStorageWrapper);
                    if (!DEBUG) continue;
                    R01FLog.to((String)"r01k.searchResultMapper").info("\ttypo " + typo + " metadato " + currMetaDataStorageCfg2.getOid() + ": " + currentColName);
                }
            }
        }
    }

    private R01KMetaDataStorageWrapper _obtainMetaDataStorageWrapper(R01MMetaDataStorageConfig currMetaDataStorageCfg) {
        String itemMemberDef = currMetaDataStorageCfg.getSearchResultItemMember();
        String itemCollection = null;
        String itemMemberName = null;
        Pattern p = Pattern.compile("(Map|List)?\\(?([^()]+)\\)?");
        Matcher m = p.matcher(itemMemberDef);
        boolean directiveValid = m.find();
        if (directiveValid && m.groupCount() == 3) {
            itemCollection = m.group(1);
            itemMemberName = m.group(2);
        } else if (directiveValid && m.groupCount() == 2) {
            itemMemberName = m.group(2);
        } else if (DEBUG) {
            R01FLog.to((String)"r01k.searchResultMapper").info(" [**WARNING**] NO est\u00e1 bien definido el miembro del objeto R01KSearchItemResult donde se va a dejar el valor de metaDato. Revisa el fichero searchMetaDataStorage.cfg");
        }
        R01KMetaDataStorageWrapper mdStgWrap = new R01KMetaDataStorageWrapper(currMetaDataStorageCfg);
        if (itemCollection == null) {
            mdStgWrap.memberType = "documentMetaData".equals(itemMemberName) ? "documentMetaData" : "member";
        } else if ("Map".equals(itemCollection) || "List".equals(itemCollection)) {
            mdStgWrap.memberType = itemCollection;
        }
        return mdStgWrap;
    }
}

