/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01k.searchorchestrator.searchperformers;

import com.ejie.r01f.net.HttpClient;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01k.searchorchestrator.searchperformers.R01KBaseContentSearchPerformer;
import com.ejie.r01k.searchorchestrator.searchperformers.R01KInitQueryResult;
import com.ejie.r01k.searchorchestrator.searchperformers.R01KSearchEngineReturnedDataToResultItemTransformer;
import com.ejie.r01k.searchorchestrator.searchperformers.R01KSearchEngineReturnedDataToResultItemTransformerDefImpl;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MSearchMetaDataStorageConfig;
import com.ejie.r01m.exceptions.R01MSearchPerformerException;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.services.R01MSearchEngineSessionAPI;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class R01KLuceneContentSearchPerformer
extends R01KBaseContentSearchPerformer {
    public static final String SEPARADOR_1 = "%&$";
    public static final String SEPARADOR_2 = "$&%";

    @Override
    protected R01KSearchEngineReturnedDataToResultItemTransformer getSearchEngineReturnedDataToResultItemTransformer(R01MSearchMetaDataStorageConfig searchMetaDataStorageConfig) {
        return new R01KSearchEngineReturnedDataToResultItemTransformerDefImpl("self");
    }

    @Override
    public String executeComposeSearchQuery(boolean isCountQuery, String searchSessionOid, String searchSessionLang, String searchSourceOid, R01MQueryObject qry, int pageNum, Object pageFirstCod, Object pageLastCod) throws R01MSearchPerformerException {
        String respuesta = null;
        HashMap<String, String> parametros = new HashMap<String, String>();
        parametros.put("funcion", "executeComposeSearchQuery");
        parametros.put("searchSessionOid", searchSessionOid);
        parametros.put("searchSessionLang", searchSessionLang);
        if (qry.isFullTextSearch()) {
            qry.setFullText(StringUtils.replaceString((String)qry.getFullText(), (String)"+", (String)"AND"));
        }
        parametros.put("query", this.getQuerySerializado(qry));
        respuesta = this.invocarLucene(parametros);
        return respuesta;
    }

    @Override
    public R01KInitQueryResult executeCountQuery(boolean lazy, boolean isGuideCountQuery, String searchSessionOid, String searchSessionLang, String searchSourceOid, R01MQueryObject query) throws R01MSearchPerformerException {
        int numResults = 0;
        HashMap<String, String> parametros = new HashMap<String, String>(4);
        parametros.put("funcion", "executeCountQuery");
        parametros.put("searchSessionOid", searchSessionOid);
        parametros.put("searchSessionLang", searchSessionLang);
        if (query.isFullTextSearch()) {
            query.setFullText(StringUtils.replaceString((String)query.getFullText(), (String)"+", (String)"AND"));
        }
        parametros.put("query", this.getQuerySerializado(query));
        String resultadoLucene = this.invocarLucene(parametros);
        try {
            if (resultadoLucene != null) {
                numResults = Integer.parseInt(resultadoLucene);
            }
            return new R01KInitQueryResult(numResults, null);
        }
        catch (NumberFormatException nfe) {
            throw new R01MSearchPerformerException("El resultado de la consulta a lucene 'executeCountQuery' (" + resultadoLucene + ") no es un n\u00famero entero");
        }
    }

    @Override
    public List executeQuery(String searchSessionOid, String searchSessionLang, String searchSourceOid, R01MQueryObject query, int pageNum, Object pageFirstElementCod, Object pageLastElementCod) throws R01MSearchPerformerException {
        List respuesta = null;
        HashMap<String, String> parametros = new HashMap<String, String>(6);
        parametros.put("funcion", "executeQuery");
        parametros.put("searchSessionOid", searchSessionOid);
        parametros.put("searchSessionLang", searchSessionLang);
        parametros.put("pageFirstElementCod", String.valueOf(pageFirstElementCod));
        parametros.put("pageLastElementCod", String.valueOf(pageLastElementCod));
        if (query.isFullTextSearch()) {
            query.setFullText(StringUtils.replaceString((String)query.getFullText(), (String)"+", (String)"AND"));
        }
        parametros.put("query", this.getQuerySerializado(query));
        String resultadoLucene = this.invocarLucene(parametros);
        respuesta = R01KLuceneContentSearchPerformer.deserializarListDeMaps(resultadoLucene);
        return respuesta;
    }

    @Override
    public List executeQueryFromAutonomyQuery(String autonomyQuery) throws R01MSearchPerformerException {
        return null;
    }

    private String getQuerySerializado(R01MQueryObject query) throws R01MSearchPerformerException {
        String respuesta = null;
        try {
            R01MSearchEngineSessionAPI apiBusqueda = new R01MSearchEngineSessionAPI();
            respuesta = apiBusqueda.getXMLFromQueryObject(query);
        }
        catch (XOMarshallerException ex) {
            throw new R01MSearchPerformerException("Se ha producido un error al serializar a XML un R01MQueryObject", (Exception)((Object)ex));
        }
        return respuesta;
    }

    private String invocarLucene(Map parametros) throws R01MSearchPerformerException {
        StringBuffer respuesta = new StringBuffer();
        try {
            String url = this.getProperty("url");
            if (url == null) {
                throw new R01MSearchPerformerException("NO se ha definido la propiedad [ulr] en la configuracion de lucene. Revisa el fichero r01kSearchEngineConfig.xml!");
            }
            String timeOutMillisStr = this.getProperty("timeOutMillis");
            long timeOutMillis = timeOutMillisStr != null ? Long.parseLong(timeOutMillisStr) : 3000L;
            HttpClient client = new HttpClient(url, parametros);
            client.setConnectionTimeout(timeOutMillis);
            InputStream streamEntrada = client.sendPostHttpCall();
            BufferedReader reader = new BufferedReader(new InputStreamReader(streamEntrada));
            String linea = null;
            while ((linea = reader.readLine()) != null) {
                if (respuesta.length() > 0) {
                    respuesta.append(linea).append("/n");
                    continue;
                }
                respuesta.append(linea);
            }
            if (respuesta.toString().equals("null")) {
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new R01MSearchPerformerException("Ha ocurrido un error al realizar una invocaci\u00f3n a Lucene.", e);
        }
        return respuesta.toString();
    }

    public static String serializarMap(Map listaParametros) {
        StringBuffer respuesta = new StringBuffer();
        for (String nombre : listaParametros.keySet()) {
            String valor = (String)listaParametros.get(nombre);
            if (respuesta.length() > 0) {
                respuesta.append(SEPARADOR_1);
            }
            respuesta.append(nombre).append("=").append(valor);
        }
        return respuesta.toString();
    }

    public static Map deserializarMap(String stringParametros) {
        HashMap<String, String> respuesta = new HashMap<String, String>();
        for (String stParametro : R01KLuceneContentSearchPerformer._getTokensSeparados(stringParametros, SEPARADOR_1)) {
            int posicion = stParametro.indexOf("=");
            String nombre = stParametro.substring(0, posicion);
            String valor = stParametro.substring(posicion + 1);
            respuesta.put(nombre, valor);
        }
        return respuesta;
    }

    public static List deserializarListDeMaps(String strListDeMaps) {
        ArrayList<Map> respuesta = new ArrayList<Map>();
        if (strListDeMaps != null) {
            for (String stMap : R01KLuceneContentSearchPerformer._getTokensSeparados(strListDeMaps, SEPARADOR_2)) {
                Map map = R01KLuceneContentSearchPerformer.deserializarMap(stMap);
                respuesta.add(map);
            }
        }
        return respuesta;
    }

    private static List _getTokensSeparados(String cadena, String separadorTokens) {
        ArrayList<String> respuesta = new ArrayList<String>();
        boolean tieneMasCaracteres = true;
        int origen = 0;
        int destino = 0;
        String valor = null;
        if (cadena != null && cadena.length() > 0) {
            while (tieneMasCaracteres) {
                destino = cadena.indexOf(separadorTokens, origen);
                if (destino != -1) {
                    valor = cadena.substring(origen, destino);
                    origen = destino + separadorTokens.length();
                    respuesta.add(valor);
                    continue;
                }
                valor = cadena.substring(origen);
                respuesta.add(valor);
                tieneMasCaracteres = false;
            }
        }
        return respuesta;
    }

    public static void main(String[] args) {
        try {
            long t1 = System.currentTimeMillis();
            R01KLuceneContentSearchPerformer instancia = new R01KLuceneContentSearchPerformer();
            Properties props = new Properties();
            props.put("url", "http://localhost/r01ktLuceneWAR/servlet/servletBusqueda");
            props.put("timeOutMillis", "200000");
            instancia.setProperties(props);
            R01MQueryObject queryObject = new R01MQueryObject();
            queryObject.addMetaData("fullText", "", "gobierno");
            String idSesion = "id_sesion_148";
            String idIdioma = "es";
            R01KInitQueryResult initResult = instancia.executeCountQuery(false, false, idSesion, idIdioma, "searchSourceOID", queryObject);
            System.out.println("N\u00ba resultados: " + initResult.getTotalResultsCount());
            String consultaRealizada = instancia.executeComposeSearchQuery(false, idSesion, idIdioma, "searchSourceOID", queryObject, 1, new Integer(0), new Integer(0));
            System.out.println("Consulta realizada: " + consultaRealizada);
            if (initResult.getTotalResultsCount() > 0) {
                List resultados = instancia.executeQuery(idSesion, idIdioma, "searchSourceOID", queryObject, 1, new Integer(0), new Integer(initResult.getTotalResultsCount() + 1));
                System.out.println("Resultados encontrados:");
                for (int i = 0; i < resultados.size(); ++i) {
                    Map resultado = (Map)resultados.get(i);
                    String rutaDocumento = (String)resultado.get("documentWorkAreaRelativePath");
                    System.out.println("Resultado " + i + ": " + rutaDocumento);
                }
            }
            long t2 = System.currentTimeMillis();
            System.out.println("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t1) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

