/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01k.searchorchestrator.searchperformers;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.CollectionConverterException;
import com.ejie.r01f.util.CollectionUtils;
import com.ejie.r01f.util.NumberUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01k.searchorchestrator.searchperformers.R01KBaseSearchQueryBuilder;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MBaseTypoStorageObject;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MMetaDataStorageConfig;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MSearchMetaDataStorageConfig;
import com.ejie.r01m.exceptions.R01MSearchPerformerException;
import com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedStorageObj;
import com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedTypoObj;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedOrderByMetaData;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedPublishRepository;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedStructureCatalog;
import com.ejie.r01m.utils.R01MConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class R01KDBSQLBuilder
extends R01KBaseSearchQueryBuilder {
    private String _publicationDateMD = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"searchEngine/publicationDateMetadata", (String)"documentPublicationDate");
    private boolean _searchInOracleText = Boolean.valueOf(XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"searchInOracleText", (String)"false").toLowerCase());
    private List _nameMetadatasIndexesInOracleText = XMLProperties.getPropertyList((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"metadatasImplementedWithOracleText/nameIndexMetadatas/metadata", (String[])new String[]{"contentName", "documentName"});
    private static final String[] propertiesKeys = new String[]{"db.queryParts", "db.basicSelectSQL", "db.contentColsSelectorSQL", "db.documentColsSelectorSQL", "db.dataFileColsSelectorSQL", "db.pagerSelectSQL", "db.fromBasicTablesListSQL", "db.basicTablesJoinSQL", "db.typoTableJoinSQL", "db.structureLabelFilterSQL", "db.labelsCondition", "db.publishRepositoriesFilterSQL", "db.storageServerFilterSQL", "db.storageDataStoreFilterSQL", "db.storageAreaFilterSQL", "db.storageWorkAreaFilterSQL", "db.typoClusterFilterSQL", "db.typoFamilyFilterSQL", "db.typoTypeFilterSQL", "db.typoExcludeTypesFilterSQL", "db.metaDataFilterSQL", "db.defaultOrderBy", "db.translatecolumn", "db.translatevalue", "db.structureLabelsSelectSQL", "db.documentPubsSelectSQL", "db.fromBasicTablesAndSubSelectListSQL", "db.fromColsSubSelectSQL", "db.fromColsCatalogStructureJoinTypeSQL", "db.fromColsCatalogLabelJoinTypeSQL", "db.fromColsCatalogRoleJoinTypeSQL", "db.fromColsSubSelectJoinSQL", "db.whereSimpleFilterSQL", "db.basicTablesSimpleJoinSQL", "db.catalogAndOrJoinSQL", "db.catalogBothAndOrJoinSQL", "db.contentJoinSQL", "db.fromPublishTablesListSQL", "db.publishColsSelectorSQL", "db.fromDefaultPublishTablesListSQL", "db.publishDefaultColsSelectorSQL", "db.publishDefaultRepositoriesFilterSQL", "db.defaultPublishOrderBy", "db.typoOneClusterFilterSQL", "db.typoOneFamilyFilterSQL", "db.typoOneTypeFilterSQL", "db.storageOneServerFilterSQL", "db.storageOneDataStoreFilterSQL", "db.storageOneAreaFilterSQL", "db.storageOneWorkAreaFilterSQL", "db.publishOneRepositoriesFilterSQL", "db.notPublishFilterSQL", "db.fullTextContains", "db.fromCatalogTablesListSQL", "db.catalogJoinSQL", "db.catalogAndOrFilterSQL", "db.linkedDocumentsColsSelectorSQL", "db.fromLinkedDocumentsTablesListSQL", "db.documentsLinkedTablesSimpleJoinSQL"};

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String composeSearchQuery(R01MSearchMetaDataStorageConfig metaDataStorageCfg, boolean isCountQuery, R01MQueryObject qry, int pageNum, Object pageFirstRow, Object pageLastRow) throws R01MSearchPerformerException {
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t[Search Query Builder](init)");
        }
        if (qry == null) {
            throw new R01MSearchPerformerException("NO se puede componer la query de b\u00fasqueda: la query es nula!");
        }
        StringBuffer[] querySentences = this.composeSearchQueryBasicParts(metaDataStorageCfg, qry);
        if (querySentences.length != 4) {
            throw new R01MSearchPerformerException("NO se han obtenido todas las partes de la query. Revisa que la propiedad db.queryParts del fichero searchMetaDataStorage.xml tiene el valor selectedCols,tablesList,where,orderBy");
        }
        StringBuffer selectedCols = querySentences[0];
        StringBuffer tablesList = querySentences[1];
        StringBuffer where = querySentences[2];
        StringBuffer orderBy = querySentences[3];
        StringBuffer queryStr = new StringBuffer(2000);
        queryStr.append("SELECT /* +ordered */ DISTINCT ");
        queryStr.append(selectedCols);
        queryStr.append(" FROM ");
        queryStr.append(tablesList);
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)where)) {
            queryStr.append(" WHERE ");
            queryStr.append(where);
        }
        if (!isCountQuery && !StringUtils.isEmptyStringBuffer((StringBuffer)orderBy)) {
            queryStr.append(" ORDER BY ");
            queryStr.append(orderBy);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t---BASIC query: " + queryStr);
        }
        StringBuffer sql = new StringBuffer();
        if (!qry.allResultsInAPage && (isCountQuery || pageNum < 0 || pageFirstRow == null && pageLastRow == null)) {
            sql.append("SELECT COUNT(*) FROM (");
            sql.append(queryStr);
            sql.append(')');
        } else if (pageFirstRow != null) {
            String pageLastElementOid;
            String pageFirstElementOid = pageFirstRow.toString();
            String string = pageLastElementOid = pageLastRow == null ? "1" : pageLastRow.toString();
            if (DEBUG) {
                R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t---Paginaci\u00f3n>>> pageFirstElementOid=" + pageFirstElementOid + " - pageLastElementOid=" + pageLastElementOid);
            }
            if (!NumberUtils.isInteger((String)pageFirstElementOid) || !NumberUtils.isInteger((String)pageLastElementOid)) throw new R01MSearchPerformerException("Error al construir la where de paginaci\u00f3n: Al menos uno de los oid de inicio o fin de p\u00e1gina NO es un n\u00famero entero.");
            if (Integer.parseInt(pageFirstElementOid) > Integer.parseInt(pageLastElementOid)) throw new R01MSearchPerformerException("Error al construir la where de paginaci\u00f3n: El valor pasado como oid del elemento de inicio de p\u00e1gina es MAYOR o IGUAL que el oid del \u00faltimo elemento de la p\u00e1gina.");
            sql.append("SELECT * FROM (SELECT filas.*,ROWNUM r FROM (");
            sql.append(queryStr);
            sql.append(") filas WHERE ROWNUM <= ");
            sql.append(pageLastElementOid);
            sql.append(") WHERE r > ");
            sql.append(pageFirstElementOid);
        } else if (pageFirstRow == null && pageLastRow == null) {
            if (!qry.allResultsInAPage) throw new R01MSearchPerformerException("Error en la paginaci\u00f3n: Al menos uno de los oid de inicio o fin de p\u00e1gina es nulo");
            sql.append(queryStr);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t---Query final a ejecutar: " + sql);
        }
        if (!DEBUG) return sql.toString();
        R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t[Search Query Builder](end)");
        return sql.toString();
    }

    @Override
    protected StringBuffer executeComposeBasicQueryPart(String partId, Map preComposedParts, R01MQueryObject qry, Map searchedClusterStorageCfgs, Map searchedFamiliesStorageCfgs, Map searchedTypesStorageCfgs, Map searchedMetaDataStorageCfgs, Properties patterns) throws R01MSearchPerformerException {
        StringBuffer outSQL = new StringBuffer(1500);
        if (partId != null) {
            if ("selectedCols".equals(partId)) {
                String linkedDocumentsColsSelectorSQL = "";
                if (qry.isReturnLinkedDocuments()) {
                    linkedDocumentsColsSelectorSQL = patterns.getProperty("db.linkedDocumentsColsSelectorSQL");
                }
                outSQL = this._composeSelectedColsSQL(patterns.getProperty("db.contentColsSelectorSQL"), patterns.getProperty("db.documentColsSelectorSQL"), linkedDocumentsColsSelectorSQL, patterns.getProperty("db.dataFileColsSelectorSQL"), qry.getPublishRepositories() != null && !qry.getPublishRepositories().isEmpty() ? patterns.getProperty("db.publishColsSelectorSQL") : null, searchedFamiliesStorageCfgs, searchedTypesStorageCfgs);
            } else if ("tablesList".equals(partId)) {
                outSQL = this._composeTablesListSQL(patterns, searchedFamiliesStorageCfgs, searchedTypesStorageCfgs, qry);
            } else if ("where".equals(partId)) {
                outSQL = this._composeWhereSQL(qry, searchedFamiliesStorageCfgs, searchedTypesStorageCfgs, searchedMetaDataStorageCfgs, patterns);
            } else if ("orderBy".equals(partId)) {
                outSQL = this._composeOrderBySQL(searchedMetaDataStorageCfgs, qry.getOrderBy(), patterns, qry.getPublishRepositories() != null && !qry.getPublishRepositories().isEmpty());
            }
        }
        return outSQL;
    }

    private StringBuffer _composeSelectedColsSQL(String contentColsSelectorSQL, String documentColsSelectorSQL, String linkedDocumentsColsSelectorSQL, String dataFileColsSelectorSQL, String publishColsSelectorSQL, Map searchedFamiliesStorageCfgs, Map searchedTypesStorageCfgs) {
        StringBuffer colsSelectorSQL = new StringBuffer(contentColsSelectorSQL);
        colsSelectorSQL.append(',');
        colsSelectorSQL.append(documentColsSelectorSQL);
        if (!StringUtils.isEmptyString((String)linkedDocumentsColsSelectorSQL)) {
            colsSelectorSQL.append(',');
            colsSelectorSQL.append(linkedDocumentsColsSelectorSQL);
        }
        if (!StringUtils.isEmptyString((String)publishColsSelectorSQL)) {
            colsSelectorSQL.append(',');
            colsSelectorSQL.append(publishColsSelectorSQL);
        }
        colsSelectorSQL.append(',');
        colsSelectorSQL.append(dataFileColsSelectorSQL);
        StringBuffer typoColsSQL = null;
        if (searchedFamiliesStorageCfgs != null && !searchedFamiliesStorageCfgs.isEmpty()) {
            typoColsSQL = this._composeTypoSelectedCols(searchedFamiliesStorageCfgs);
        } else if (searchedTypesStorageCfgs != null && !searchedTypesStorageCfgs.isEmpty()) {
            typoColsSQL = this._composeTypoSelectedCols(searchedTypesStorageCfgs);
        }
        if (!StringUtils.isEmptyStringBuffer(typoColsSQL)) {
            colsSelectorSQL.append(',');
            colsSelectorSQL.append(typoColsSQL);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t         COLUMNS: " + colsSelectorSQL);
        }
        return colsSelectorSQL;
    }

    private StringBuffer _composeTypoSelectedCols(Map searchedTypo) {
        R01MBaseTypoStorageObject currTypoStg2 = null;
        String currTypoTableName = null;
        ArrayList<String> colsList = new ArrayList<String>();
        for (R01MBaseTypoStorageObject currTypoStg2 : searchedTypo.values()) {
            if (currTypoStg2.getProperties() == null || currTypoStg2.getProperties().get("db.table") == null || (currTypoTableName = (String)currTypoStg2.getProperties().get("db.table")) == null || colsList.contains(currTypoTableName)) continue;
            colsList.add(currTypoTableName);
        }
        StringBuffer outColsSQL = new StringBuffer(250);
        if (!colsList.isEmpty()) {
            Iterator it = colsList.iterator();
            while (it.hasNext()) {
                outColsSQL.append(it.next());
                outColsSQL.append(".*");
                if (!it.hasNext()) continue;
                outColsSQL.append(',');
            }
        }
        return outColsSQL;
    }

    private StringBuffer _composeTablesListSQL(Properties patterns, Map searchedFamiliesStorageCfgs, Map searchedTypesStorageCfgs, R01MQueryObject qry) {
        StringBuffer fromBasicTablesListSQL = new StringBuffer(patterns.getProperty("db.fromBasicTablesAndSubSelectListSQL"));
        StringBuffer outTablesSQL = new StringBuffer(150);
        if (!this._searchInOracleText) {
            outTablesSQL.append(this._composeFromSubSelect(patterns, qry));
        }
        if (fromBasicTablesListSQL != null) {
            outTablesSQL.append(fromBasicTablesListSQL);
            if (qry.isReturnLinkedDocuments()) {
                outTablesSQL.append(',');
                outTablesSQL.append(patterns.getProperty("db.fromLinkedDocumentsTablesListSQL"));
            }
        }
        StringBuffer typoTablesSQL = null;
        if (searchedFamiliesStorageCfgs != null && !searchedFamiliesStorageCfgs.isEmpty()) {
            typoTablesSQL = this._composeTypoTablesList(searchedFamiliesStorageCfgs);
        } else if (searchedTypesStorageCfgs != null && !searchedTypesStorageCfgs.isEmpty()) {
            typoTablesSQL = this._composeTypoTablesList(searchedTypesStorageCfgs);
        }
        if (this._searchInOracleText) {
            boolean areCatalogLabelsOr;
            boolean areCatalogLabelsAnd = qry.getCatalogLabelsAnd() != null && !qry.getCatalogLabelsAnd().isEmpty();
            boolean bl = areCatalogLabelsOr = qry.getCatalogLabelsOr() != null && !qry.getCatalogLabelsOr().isEmpty();
            if (areCatalogLabelsAnd || areCatalogLabelsOr) {
                outTablesSQL.append(!StringUtils.isEmptyStringBuffer((StringBuffer)outTablesSQL) ? "," : "");
                outTablesSQL.append(patterns.getProperty("db.fromCatalogTablesListSQL"));
            }
        }
        boolean addPublishTable = false;
        for (R01MSearchedMetaData md : qry.getSearchedMetaData()) {
            if (!md.getOid().equals(this._publicationDateMD)) continue;
            addPublishTable = true;
        }
        if (addPublishTable || qry.getPublishRepositories() != null && !qry.getPublishRepositories().isEmpty()) {
            outTablesSQL.append(!StringUtils.isEmptyStringBuffer((StringBuffer)outTablesSQL) ? "," : "");
            outTablesSQL.append(patterns.getProperty("db.fromPublishTablesListSQL"));
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)typoTablesSQL)) {
            outTablesSQL.append(!StringUtils.isEmptyStringBuffer((StringBuffer)outTablesSQL) ? "," : "");
            outTablesSQL.append(typoTablesSQL);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\tFROM TABLES LIST: " + outTablesSQL.toString());
        }
        return outTablesSQL;
    }

    private StringBuffer _composeFromSubSelect(Properties patterns, R01MQueryObject qry) {
        ListIterator labelsIt;
        StringBuffer fromSubSelectCatalogFilter;
        boolean areCatalogLabelsOr;
        StringBuffer outSubSelectSQL = new StringBuffer(500);
        boolean areCatalogLabelsAnd = qry.getCatalogLabelsAnd() != null && !qry.getCatalogLabelsAnd().isEmpty();
        boolean bl = areCatalogLabelsOr = qry.getCatalogLabelsOr() != null && !qry.getCatalogLabelsOr().isEmpty();
        if (!areCatalogLabelsAnd && !areCatalogLabelsOr) {
            return outSubSelectSQL;
        }
        StringBuffer fromColsSubSelectJoinSQL = new StringBuffer(patterns.getProperty("db.fromColsSubSelectJoinSQL"));
        StringBuffer fromColsSubSelectSQL = new StringBuffer(patterns.getProperty("db.fromColsSubSelectSQL"));
        R01MSearchedStructureCatalog currSearchedLabel = null;
        if (areCatalogLabelsAnd) {
            outSubSelectSQL.append('(');
            fromSubSelectCatalogFilter = new StringBuffer();
            labelsIt = qry.getCatalogLabelsAnd().listIterator();
            while (labelsIt.hasNext()) {
                currSearchedLabel = (R01MSearchedStructureCatalog)labelsIt.next();
                outSubSelectSQL.append(fromColsSubSelectSQL);
                fromSubSelectCatalogFilter.setLength(0);
                fromSubSelectCatalogFilter.append(this._composeFromSubSelectCatalogFilter(patterns, currSearchedLabel, currSearchedLabel.isUseStructureAndRole()));
                outSubSelectSQL.append(fromSubSelectCatalogFilter);
                outSubSelectSQL.append(fromColsSubSelectJoinSQL);
                if (!labelsIt.hasNext()) continue;
                outSubSelectSQL.append(" INTERSECT ");
            }
            outSubSelectSQL.append(") TABLA_REDUCIDAAND, ");
        }
        if (areCatalogLabelsOr) {
            outSubSelectSQL.append('(');
            fromSubSelectCatalogFilter = new StringBuffer();
            labelsIt = qry.getCatalogLabelsOr().listIterator();
            while (labelsIt.hasNext()) {
                currSearchedLabel = (R01MSearchedStructureCatalog)labelsIt.next();
                outSubSelectSQL.append(fromColsSubSelectSQL);
                fromSubSelectCatalogFilter.setLength(0);
                fromSubSelectCatalogFilter.append(this._composeFromSubSelectCatalogFilter(patterns, currSearchedLabel, currSearchedLabel.isUseStructureAndRole()));
                outSubSelectSQL.append(fromSubSelectCatalogFilter);
                outSubSelectSQL.append(fromColsSubSelectJoinSQL);
                if (!labelsIt.hasNext()) continue;
                outSubSelectSQL.append(" UNION ALL ");
            }
            outSubSelectSQL.append(") TABLA_REDUCIDAOR,");
        }
        return outSubSelectSQL;
    }

    private StringBuffer _composeFromSubSelectCatalogFilter(Properties patterns, R01MSearchedStructureCatalog searchedCatalog, boolean useStructureAndRole) {
        StringBuffer outMetaDataFilter = new StringBuffer();
        if (searchedCatalog != null) {
            boolean isLabel;
            StringBuffer outStrctureFilter = new StringBuffer(patterns.getProperty("db.fromColsCatalogStructureJoinTypeSQL"));
            String outStrctureFilterSQL = "";
            StringBuffer outLabelFilter = new StringBuffer(patterns.getProperty("db.fromColsCatalogLabelJoinTypeSQL"));
            String outLabelFilterSQL = "";
            StringBuffer outRoleFilter = new StringBuffer(patterns.getProperty("db.fromColsCatalogRoleJoinTypeSQL"));
            String outRoleFilterSQL = "";
            boolean isStructure = false;
            boolean isRole = false;
            if (useStructureAndRole) {
                isStructure = searchedCatalog.getStructureOid() != null && !StringUtils.isEmptyString((String)searchedCatalog.getStructureOid());
                boolean bl = isRole = searchedCatalog.getRole() != null && !StringUtils.isEmptyString((String)searchedCatalog.getRole());
                if (isStructure) {
                    outStrctureFilterSQL = StringUtils.replaceString((String)outStrctureFilter.toString(), (String)"$STRUCTUREOID$", (String)searchedCatalog.getStructureOid().toString());
                }
                if (isRole) {
                    outRoleFilterSQL = StringUtils.replaceString((String)outRoleFilter.toString(), (String)"$ROLE$", (String)searchedCatalog.getRole().toString());
                }
            }
            boolean bl = isLabel = searchedCatalog.getLabelOid() != null && !StringUtils.isEmptyString((String)searchedCatalog.getLabelOid());
            if (isLabel) {
                outLabelFilterSQL = StringUtils.replaceString((String)outLabelFilter.toString(), (String)"$LABELOID$", (String)searchedCatalog.getLabelOid().toString());
            }
            StringBuffer catalogFilter = new StringBuffer();
            if (isStructure) {
                if (!StringUtils.isEmptyStringBuffer((StringBuffer)catalogFilter)) {
                    catalogFilter.append(" AND ");
                }
                catalogFilter.append(outStrctureFilterSQL);
            }
            if (isLabel) {
                if (!StringUtils.isEmptyStringBuffer((StringBuffer)catalogFilter)) {
                    catalogFilter.append(" AND ");
                }
                catalogFilter.append(outLabelFilterSQL);
            }
            if (isRole) {
                if (!StringUtils.isEmptyStringBuffer((StringBuffer)catalogFilter)) {
                    catalogFilter.append(" AND ");
                }
                catalogFilter.append(outRoleFilterSQL);
            }
            outMetaDataFilter.append(catalogFilter);
        }
        return outMetaDataFilter;
    }

    private StringBuffer _composeTypoTablesList(Map searchedTypo) {
        R01MBaseTypoStorageObject currTypoStge2 = null;
        String currTypoTableName = null;
        ArrayList<String> tablesList = new ArrayList<String>();
        for (R01MBaseTypoStorageObject currTypoStge2 : searchedTypo.values()) {
            if (currTypoStge2.getProperties() == null || currTypoStge2.getProperties().get("db.table") == null) continue;
            currTypoTableName = (String)currTypoStge2.getProperties().get("db.table");
            if (currTypoTableName == null) {
                R01FLog.to((String)"r01k.searchSentenceBuilder").warning("NO se ha definido la propiedad db.table para el tipo " + currTypoStge2.getOid() + " o alguno de sus predecesores en la jerarquia de herencia.\r\nLa tabla con los metaDatos ESPECIFICOS DEL TIPO no se incluye en la SQL por lo que no se van a devolver datos de estos metaDatos!!!");
            }
            if (tablesList.contains(currTypoTableName)) continue;
            tablesList.add(currTypoTableName);
        }
        StringBuffer outTablesSQL = new StringBuffer(100);
        if (!tablesList.isEmpty()) {
            Iterator tit = tablesList.iterator();
            while (tit.hasNext()) {
                outTablesSQL.append(tit.next());
                if (!tit.hasNext()) continue;
                outTablesSQL.append(',');
            }
        }
        return outTablesSQL;
    }

    private StringBuffer _composeWhereSQL(R01MQueryObject qry, Map searchedFamiliesStorageCfgs, Map searchedTypesStorageCfgs, Map searchedMetaDataStorageCfgs, Properties patterns) throws R01MSearchPerformerException {
        boolean areCatalogLabelsOr;
        StringBuffer serverFilterSQL = new StringBuffer("");
        if (qry.getServers() != null && !qry.getServers().isEmpty()) {
            if (qry.getServers().size() == 1) {
                serverFilterSQL.append(this._composeStorageFilterSQL(qry.getServers(), patterns.getProperty("db.storageOneServerFilterSQL")));
            } else {
                serverFilterSQL.append(this._composeStorageFilterSQL(qry.getServers(), patterns.getProperty("db.storageServerFilterSQL")));
            }
        }
        StringBuffer dataStoreFilterSQL = new StringBuffer("");
        if (qry.getDataRepositories() != null && !qry.getDataRepositories().isEmpty()) {
            if (qry.getDataRepositories().size() == 1) {
                dataStoreFilterSQL.append(this._composeStorageFilterSQL(qry.getDataRepositories(), patterns.getProperty("db.storageOneDataStoreFilterSQL")));
            } else {
                dataStoreFilterSQL.append(this._composeStorageFilterSQL(qry.getDataRepositories(), patterns.getProperty("db.storageDataStoreFilterSQL")));
            }
        }
        StringBuffer areasFilterSQL = new StringBuffer("");
        if (qry.getAreas() != null && !qry.getAreas().isEmpty()) {
            if (qry.getAreas().size() == 1) {
                areasFilterSQL.append(this._composeStorageFilterSQL(qry.getAreas(), patterns.getProperty("db.storageOneAreaFilterSQL")));
            } else {
                areasFilterSQL.append(this._composeStorageFilterSQL(qry.getAreas(), patterns.getProperty("db.storageAreaFilterSQL")));
            }
        }
        StringBuffer workAreasFilterSQL = new StringBuffer("");
        if (qry.getWorkAreas() != null && !qry.getWorkAreas().isEmpty()) {
            if (qry.getWorkAreas().size() == 1) {
                workAreasFilterSQL.append(this._composeStorageFilterSQL(qry.getWorkAreas(), patterns.getProperty("db.storageOneWorkAreaFilterSQL")));
            } else {
                workAreasFilterSQL.append(this._composeStorageFilterSQL(qry.getWorkAreas(), patterns.getProperty("db.storageWorkAreaFilterSQL")));
            }
        }
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t         STORAGE: " + serverFilterSQL + " | " + dataStoreFilterSQL + " | " + areasFilterSQL + " | " + workAreasFilterSQL);
        }
        StringBuffer basicTablesJoinSQL = new StringBuffer();
        StringBuffer basicTablesSimpleJoinSQL = new StringBuffer();
        if (qry.isReturnLinkedDocuments()) {
            basicTablesSimpleJoinSQL.append(patterns.getProperty("db.documentsLinkedTablesSimpleJoinSQL"));
        }
        basicTablesSimpleJoinSQL.append(patterns.getProperty("db.basicTablesSimpleJoinSQL"));
        StringBuffer basicTablesJoin = new StringBuffer();
        StringBuffer catalogFilterSQL = new StringBuffer();
        StringBuffer catalogLabelsStr = new StringBuffer("");
        boolean areCatalogLabelsAnd = qry.getCatalogLabelsAnd() != null && !qry.getCatalogLabelsAnd().isEmpty();
        boolean bl = areCatalogLabelsOr = qry.getCatalogLabelsOr() != null && !qry.getCatalogLabelsOr().isEmpty();
        if (areCatalogLabelsAnd || areCatalogLabelsOr) {
            if (!this._searchInOracleText) {
                if (areCatalogLabelsAnd && areCatalogLabelsOr) {
                    basicTablesJoinSQL.append(patterns.getProperty("db.catalogAndOrJoinSQL"));
                    StringBuffer catalagoAndOrJoinSQL = new StringBuffer(patterns.getProperty("db.catalogBothAndOrJoinSQL"));
                    basicTablesJoin.append(StringUtils.replaceString((String)basicTablesJoinSQL.toString(), (String)"$LOGICAL_OPERATOR$", (String)"AND"));
                    if (basicTablesJoin.length() > 0 && !StringUtils.isEmptyStringBuffer((StringBuffer)catalagoAndOrJoinSQL)) {
                        basicTablesJoin.append(" ");
                        basicTablesJoin.append(catalagoAndOrJoinSQL);
                    }
                } else {
                    basicTablesJoinSQL.append(patterns.getProperty("db.catalogAndOrJoinSQL"));
                    if (areCatalogLabelsAnd) {
                        basicTablesJoin.append(StringUtils.replaceString((String)basicTablesJoinSQL.toString(), (String)"$LOGICAL_OPERATOR$", (String)"AND"));
                    }
                    if (areCatalogLabelsOr) {
                        basicTablesJoin.append(StringUtils.replaceString((String)basicTablesJoinSQL.toString(), (String)"$LOGICAL_OPERATOR$", (String)"OR"));
                    }
                }
            } else {
                if (areCatalogLabelsAnd) {
                    for (R01MSearchedStructureCatalog searchedStructureCatalogAnd : qry.getCatalogLabelsAnd()) {
                        catalogLabelsStr.append(searchedStructureCatalogAnd.labelOid);
                        catalogLabelsStr.append(" INPATH(//structurecatalogs/catalog/label) & ");
                    }
                    catalogLabelsStr.delete(catalogLabelsStr.length() - 3, catalogLabelsStr.length());
                }
                if (areCatalogLabelsOr) {
                    boolean hasCatalogStr;
                    boolean bl2 = hasCatalogStr = !StringUtils.isEmptyStringBuffer((StringBuffer)catalogLabelsStr);
                    if (hasCatalogStr) {
                        catalogLabelsStr.append(" & ");
                        catalogLabelsStr.append("( ");
                    }
                    for (R01MSearchedStructureCatalog searchedStructureCatalogOr : qry.getCatalogLabelsOr()) {
                        catalogLabelsStr.append(searchedStructureCatalogOr.labelOid);
                        catalogLabelsStr.append(" INPATH(//structurecatalogs/catalog/label) | ");
                    }
                    catalogLabelsStr.delete(catalogLabelsStr.length() - 3, catalogLabelsStr.length());
                    if (hasCatalogStr) {
                        catalogLabelsStr.append(" )");
                    }
                }
                String catalogAndOrFilterSQL = StringUtils.replaceString((String)patterns.getProperty("db.catalogAndOrFilterSQL"), (String)"$METADATAVALUE$", (String)catalogLabelsStr.toString());
                catalogFilterSQL.append(catalogAndOrFilterSQL);
                catalogFilterSQL.append(" AND ");
                catalogFilterSQL.append(patterns.getProperty("db.catalogJoinSQL"));
                if (DEBUG) {
                    R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t         CATALOG: " + catalogFilterSQL);
                }
            }
        }
        StringBuffer clustersFilterSQL = new StringBuffer("");
        if (qry.getContentClusters() != null && !qry.getContentClusters().isEmpty()) {
            if (qry.getContentClusters().size() == 1) {
                clustersFilterSQL.append(this._composeTypoFilterSQL(qry.getContentClusters(), patterns.getProperty("db.typoOneClusterFilterSQL")));
            } else {
                clustersFilterSQL.append(this._composeTypoFilterSQL(qry.getContentClusters(), patterns.getProperty("db.typoClusterFilterSQL")));
            }
        }
        StringBuffer familiesFilterSQL = new StringBuffer("");
        if (qry.getContentFamilies() != null && !qry.getContentFamilies().isEmpty()) {
            if (qry.getContentFamilies().size() == 1) {
                familiesFilterSQL.append(this._composeTypoFilterSQL(qry.getContentFamilies(), patterns.getProperty("db.typoOneFamilyFilterSQL")));
            } else {
                familiesFilterSQL.append(this._composeTypoFilterSQL(qry.getContentFamilies(), patterns.getProperty("db.typoFamilyFilterSQL")));
            }
        }
        StringBuffer typesFilterSQL = new StringBuffer("");
        if (qry.getContentTypes() != null && !qry.getContentTypes().isEmpty()) {
            if (qry.getContentTypes().size() == 1) {
                typesFilterSQL.append(this._composeTypoFilterSQL(qry.getContentTypes(), patterns.getProperty("db.typoOneTypeFilterSQL")));
            } else {
                typesFilterSQL.append(this._composeTypoFilterSQL(qry.getContentTypes(), patterns.getProperty("db.typoTypeFilterSQL")));
            }
        }
        StringBuffer excludedTypesFilterSQL = new StringBuffer("");
        if (qry.getContentExcludedTypes() != null && !qry.getContentExcludedTypes().isEmpty()) {
            excludedTypesFilterSQL.append(this._composeTypoFilterSQL(qry.getContentExcludedTypes(), patterns.getProperty("db.typoExcludeTypesFilterSQL")));
        }
        basicTablesJoinSQL.setLength(0);
        if (this._searchInOracleText && !StringUtils.isEmptyStringBuffer((StringBuffer)catalogFilterSQL)) {
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)basicTablesJoinSQL)) {
                basicTablesJoinSQL.append(" AND ");
            }
            basicTablesJoinSQL.append(catalogFilterSQL);
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)clustersFilterSQL)) {
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)basicTablesJoinSQL)) {
                basicTablesJoinSQL.append(" AND ");
            }
            basicTablesJoinSQL.append(clustersFilterSQL);
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)familiesFilterSQL)) {
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)basicTablesJoinSQL)) {
                basicTablesJoinSQL.append(" AND ");
            }
            basicTablesJoinSQL.append(familiesFilterSQL);
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)typesFilterSQL)) {
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)basicTablesJoinSQL)) {
                basicTablesJoinSQL.append(" AND ");
            }
            basicTablesJoinSQL.append(typesFilterSQL);
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)excludedTypesFilterSQL)) {
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)basicTablesJoinSQL)) {
                basicTablesJoinSQL.append(" AND ");
            }
            basicTablesJoinSQL.append(excludedTypesFilterSQL);
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)basicTablesJoinSQL)) {
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)basicTablesJoin)) {
                basicTablesJoin.append(" AND ");
            }
            basicTablesJoin.append(basicTablesJoinSQL);
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)basicTablesJoin)) {
            basicTablesJoin.append(" AND ");
        }
        basicTablesJoin.append(patterns.getProperty("db.contentJoinSQL"));
        StringBuffer familyTablesJoinSQL = this._composeFamilyTablesJoin(searchedFamiliesStorageCfgs, searchedTypesStorageCfgs, patterns.getProperty("db.typoTableJoinSQL"));
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t    TABLES JOINS: " + basicTablesJoinSQL + " | " + familyTablesJoinSQL);
        }
        StringBuffer publishRepositoryFilterSQL = new StringBuffer("");
        StringBuffer notpublishFilterSQL = new StringBuffer("");
        if (qry.isOnlyNotPublished()) {
            notpublishFilterSQL.append(patterns.getProperty("db.notPublishFilterSQL"));
        } else if (qry.getPublishRepositories() != null && !qry.getPublishRepositories().isEmpty()) {
            if (qry.getPublishRepositories().size() == 1) {
                publishRepositoryFilterSQL.append(this._composePublicationsFilterSQL(qry.getPublishRepositories(), patterns.getProperty("db.publishOneRepositoriesFilterSQL")));
            } else {
                publishRepositoryFilterSQL.append(this._composePublicationsFilterSQL(qry.getPublishRepositories(), patterns.getProperty("db.publishRepositoriesFilterSQL")));
            }
            if (DEBUG) {
                R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t         PUBLISH: " + publishRepositoryFilterSQL);
            }
        }
        StringBuffer andMetaDataFiltersSQL = this._composeMetadataFilterSQL("AND", searchedMetaDataStorageCfgs, qry.getMetaData(), patterns);
        StringBuffer orMetaDataFiltersSQL = this._composeMetadataFilterSQL("OR", searchedMetaDataStorageCfgs, qry.getORMetaData(), patterns);
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t    METADATA AND: " + andMetaDataFiltersSQL);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t     METADATA OR: " + orMetaDataFiltersSQL);
        }
        StringBuffer outWhereStr = new StringBuffer(1500);
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)serverFilterSQL)) {
            outWhereStr.append(serverFilterSQL);
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)dataStoreFilterSQL)) {
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)outWhereStr)) {
                outWhereStr.append(" AND ");
            }
            outWhereStr.append(dataStoreFilterSQL);
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)areasFilterSQL)) {
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)outWhereStr)) {
                outWhereStr.append(" AND ");
            }
            outWhereStr.append(areasFilterSQL);
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)workAreasFilterSQL)) {
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)outWhereStr)) {
                outWhereStr.append(" AND ");
            }
            outWhereStr.append(workAreasFilterSQL);
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)basicTablesJoin)) {
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)outWhereStr)) {
                outWhereStr.append(" AND ");
            }
            outWhereStr.append(basicTablesJoin);
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)notpublishFilterSQL)) {
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)outWhereStr)) {
                outWhereStr.append(" AND ");
            }
            outWhereStr.append(notpublishFilterSQL);
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)publishRepositoryFilterSQL)) {
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)outWhereStr)) {
                outWhereStr.append(" AND ");
            }
            outWhereStr.append(publishRepositoryFilterSQL);
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)basicTablesSimpleJoinSQL)) {
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)outWhereStr)) {
                outWhereStr.append(" AND ");
            }
            outWhereStr.append(basicTablesSimpleJoinSQL);
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)familyTablesJoinSQL)) {
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)outWhereStr)) {
                outWhereStr.append(" AND ");
            }
            outWhereStr.append(familyTablesJoinSQL);
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)andMetaDataFiltersSQL)) {
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)outWhereStr)) {
                outWhereStr.append(" AND ");
            }
            outWhereStr.append(andMetaDataFiltersSQL);
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)orMetaDataFiltersSQL)) {
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)outWhereStr)) {
                outWhereStr.append(" AND ");
            }
            outWhereStr.append('(');
            outWhereStr.append(orMetaDataFiltersSQL);
            outWhereStr.append(')');
        }
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t         WHERE: " + outWhereStr.toString());
        }
        return outWhereStr;
    }

    private StringBuffer _composeFamilyTablesJoin(Map searchedFamiliesStorageCfgs, Map searchedTypesStorageCfgs, String typoTableJoinSQLPattern) {
        StringBuffer outTypoTablesJoinSQL = new StringBuffer(300);
        if (searchedFamiliesStorageCfgs != null && !searchedFamiliesStorageCfgs.isEmpty()) {
            outTypoTablesJoinSQL.append(this._composeTypoTablesJoin(searchedFamiliesStorageCfgs, typoTableJoinSQLPattern));
        } else if (searchedTypesStorageCfgs != null && !searchedTypesStorageCfgs.isEmpty()) {
            outTypoTablesJoinSQL.append(this._composeTypoTablesJoin(searchedTypesStorageCfgs, typoTableJoinSQLPattern));
        }
        return outTypoTablesJoinSQL;
    }

    private StringBuffer _composeTypoTablesJoin(Map searchedTypoStorage, String typoTableJoinSQLPattern) {
        String currTypoTableJoinSQL = null;
        R01MBaseTypoStorageObject currTypoStg2 = null;
        String currTypoTableName = null;
        String currTypoTablePK = null;
        HashMap<String, String> varValues = new HashMap<String, String>();
        ArrayList<String> tableJoins = new ArrayList<String>();
        for (R01MBaseTypoStorageObject currTypoStg2 : searchedTypoStorage.values()) {
            currTypoTableName = currTypoStg2.getProperties() != null ? (String)currTypoStg2.getProperties().get("db.table") : null;
            String string = currTypoTablePK = currTypoStg2.getProperties() != null ? (String)currTypoStg2.getProperties().get("db.pk") : null;
            if (currTypoTableName == null || currTypoTablePK == null) continue;
            currTypoTableJoinSQL = new String(typoTableJoinSQLPattern);
            varValues.clear();
            varValues.put("TYPO_TABLE", currTypoTableName);
            varValues.put("TYPO_TABLE_PK", currTypoTablePK);
            if (tableJoins.contains(currTypoTableJoinSQL = StringUtils.replaceVariableValues((String)currTypoTableJoinSQL, (String)"$", varValues))) continue;
            tableJoins.add(currTypoTableJoinSQL);
        }
        StringBuffer outTypoTablesJoinSQL = new StringBuffer(300);
        if (!tableJoins.isEmpty()) {
            Iterator tit = tableJoins.iterator();
            while (tit.hasNext()) {
                outTypoTablesJoinSQL.append(tit.next());
                if (!tit.hasNext()) continue;
                outTypoTablesJoinSQL.append(" AND ");
            }
        }
        return outTypoTablesJoinSQL;
    }

    private StringBuffer _composeOrderBySQL(Map orderedByMetaDataStorageCfgs, List orderByMetaData, Properties patterns, boolean hasRepositories) {
        StringBuffer outOrderBy = new StringBuffer();
        if (orderedByMetaDataStorageCfgs != null && !orderedByMetaDataStorageCfgs.isEmpty()) {
            R01MSearchedOrderByMetaData currSearchedOrderByMetaData = null;
            R01MMetaDataStorageConfig currMetaDataStorageCfg = null;
            Iterator it = orderByMetaData.iterator();
            while (it.hasNext()) {
                currSearchedOrderByMetaData = (R01MSearchedOrderByMetaData)it.next();
                currMetaDataStorageCfg = (R01MMetaDataStorageConfig)orderedByMetaDataStorageCfgs.get(currSearchedOrderByMetaData.getOid());
                if (currMetaDataStorageCfg.getProperty("db.tableCol").indexOf("VIRTUAL") >= 0) continue;
                outOrderBy.append(currMetaDataStorageCfg.getProperty("db.table"));
                outOrderBy.append('.');
                outOrderBy.append(currMetaDataStorageCfg.getProperty("db.tableCol"));
                outOrderBy.append(' ');
                outOrderBy.append(currSearchedOrderByMetaData.order != null ? currSearchedOrderByMetaData.order + " NULLS LAST" : "");
                if (!it.hasNext()) continue;
                outOrderBy.append(',');
            }
        }
        if (StringUtils.isEmptyStringBuffer((StringBuffer)outOrderBy) && hasRepositories) {
            outOrderBy.append(patterns.getProperty("db.defaultPublishOrderBy"));
        }
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t        ORDER BY: " + outOrderBy);
        }
        return outOrderBy;
    }

    private StringBuffer _composeStorageFilterSQL(List searchedStorageObjs, String storageFilterSQLPattern) {
        if (searchedStorageObjs != null && !searchedStorageObjs.isEmpty()) {
            StringBuffer storageObjsOids = new StringBuffer(200);
            Iterator storageIt = searchedStorageObjs.iterator();
            while (storageIt.hasNext()) {
                R01MBaseSearchedStorageObj currSearchedStorageObj = (R01MBaseSearchedStorageObj)storageIt.next();
                storageObjsOids.append("'");
                storageObjsOids.append(currSearchedStorageObj.getStorageObjOid());
                storageObjsOids.append("'");
                if (!storageIt.hasNext()) continue;
                storageObjsOids.append(",");
            }
            String outFilterSQL = new String(storageFilterSQLPattern);
            outFilterSQL = StringUtils.replaceString((String)outFilterSQL, (String)"$STORAGE_OBJS_OIDS$", (String)storageObjsOids.toString());
            return new StringBuffer(outFilterSQL);
        }
        return new StringBuffer("");
    }

    private StringBuffer _composeTypoFilterSQL(List searchedTypoObjs, String typoFilterSQLPattern) {
        if (searchedTypoObjs != null && !searchedTypoObjs.isEmpty()) {
            StringBuffer typoObjsOids = new StringBuffer(200);
            Iterator typoIt = searchedTypoObjs.iterator();
            while (typoIt.hasNext()) {
                R01MBaseSearchedTypoObj currSearchedTypoObj = (R01MBaseSearchedTypoObj)typoIt.next();
                typoObjsOids.append("'");
                typoObjsOids.append(currSearchedTypoObj.getOid());
                typoObjsOids.append("'");
                if (!typoIt.hasNext()) continue;
                typoObjsOids.append(",");
            }
            String outFilterSQL = new String(typoFilterSQLPattern);
            outFilterSQL = StringUtils.replaceString((String)outFilterSQL, (String)"$TYPO_OBJS_OIDS$", (String)typoObjsOids.toString());
            return new StringBuffer(outFilterSQL);
        }
        return new StringBuffer("");
    }

    private StringBuffer _composePublicationsFilterSQL(List publishedRepositories, String pubFilterSQLPattern) {
        StringBuffer sql = new StringBuffer(100);
        if (publishedRepositories != null && !publishedRepositories.isEmpty()) {
            StringBuffer repListSb = new StringBuffer(50);
            Iterator pIt = publishedRepositories.iterator();
            while (pIt.hasNext()) {
                R01MSearchedPublishRepository currSearchedRepository = (R01MSearchedPublishRepository)pIt.next();
                repListSb.append("'");
                repListSb.append(currSearchedRepository.getOid());
                repListSb.append("'");
                if (!pIt.hasNext()) continue;
                repListSb.append(",");
            }
            String outSQL = new String(pubFilterSQLPattern);
            outSQL = StringUtils.replaceString((String)outSQL, (String)"$PUBLISH_REPOSITORIES_LIST$", (String)repListSb.toString());
            sql.append(outSQL);
        }
        return sql;
    }

    private StringBuffer _composeMetadataFilterSQL(String union, Map searchedMetaDataStorageCfgs, List searchedMetaData, Properties patterns) throws R01MSearchPerformerException {
        String str;
        StringBuffer metaDataSubConditions = new StringBuffer(300);
        if (searchedMetaDataStorageCfgs == null || searchedMetaDataStorageCfgs.isEmpty()) {
            return metaDataSubConditions;
        }
        if (searchedMetaData != null && !searchedMetaData.isEmpty()) {
            Map searchedMetaDataMap;
            String translateValuePattern;
            String translateColumnPattern;
            StringBuffer metaDataSQL;
            StringBuffer fullTextSQL;
            R01MMetaDataStorageConfig currSearchedMetaDataStorageCfg;
            R01MSearchedMetaData currSearchedMetaData;
            block28: {
                currSearchedMetaData = null;
                currSearchedMetaDataStorageCfg = null;
                fullTextSQL = new StringBuffer();
                metaDataSQL = new StringBuffer();
                translateColumnPattern = patterns.getProperty("db.translatecolumn");
                translateValuePattern = patterns.getProperty("db.translatevalue");
                searchedMetaDataMap = null;
                try {
                    searchedMetaDataMap = CollectionUtils.convertListIntoMap((List)searchedMetaData, (String)"oid", (boolean)false);
                }
                catch (CollectionConverterException ccEx) {
                    if (!DEBUG) break block28;
                    R01FLog.to((String)"r01k.searchSentenceBuilder").warning("R01KDBSQLBuilder._composeMetadataFilterSQL: Error al transformar la lista de metadatos a buscar en un mapa. Es posible que alg\u00fan metadato de b\u00fasqueda no tenga el valor de OID de metadato: " + ccEx.getMessage());
                }
            }
            if (this._searchInOracleText) {
                String nameValue = "";
                boolean nameSearch = false;
                if (searchedMetaDataMap != null) {
                    for (String name : this._nameMetadatasIndexesInOracleText) {
                        if (searchedMetaDataMap.get(name) != null) {
                            if (StringUtils.isEmptyString((String)nameValue)) {
                                nameValue = ((R01MSearchedMetaData)searchedMetaDataMap.get(name)).getValue();
                                nameSearch = true;
                                continue;
                            }
                            if (nameValue.equalsIgnoreCase(((R01MSearchedMetaData)searchedMetaDataMap.get(name)).getValue())) {
                                nameSearch = true;
                                continue;
                            }
                            nameSearch = false;
                            break;
                        }
                        nameSearch = false;
                        break;
                    }
                }
                if (nameSearch) {
                    for (String metadataToDeleteOid : this._nameMetadatasIndexesInOracleText) {
                        searchedMetaDataMap.remove(metadataToDeleteOid);
                    }
                    searchedMetaData = new ArrayList(searchedMetaDataMap.values());
                    R01MSearchedMetaData newMetadata = new R01MSearchedMetaData("nameSearch", "LIKE", nameValue);
                    searchedMetaData.add(newMetadata);
                }
            }
            Iterator mdIt = searchedMetaData.iterator();
            while (mdIt.hasNext()) {
                currSearchedMetaData = (R01MSearchedMetaData)mdIt.next();
                if (currSearchedMetaData.getOid().equals("fullText")) {
                    if (this._searchInOracleText) {
                        String textToSearch = this._composeFullTextQuery(currSearchedMetaData.getValue().toString(), false, null, null, currSearchedMetaData.getOperationSelected());
                        fullTextSQL.append(this._composeAllCurrentMetaDataFilterSQL(textToSearch, patterns.getProperty("db.fullTextContains")));
                    } else {
                        R01MMetaDataStorageConfig contentNameStorage = (R01MMetaDataStorageConfig)searchedMetaDataStorageCfgs.get("contentName");
                        R01MMetaDataStorageConfig contentDescStorage = (R01MMetaDataStorageConfig)searchedMetaDataStorageCfgs.get("contentDescription");
                        R01MMetaDataStorageConfig documentNameStorage = (R01MMetaDataStorageConfig)searchedMetaDataStorageCfgs.get("documentName");
                        R01MMetaDataStorageConfig documentDescStorage = (R01MMetaDataStorageConfig)searchedMetaDataStorageCfgs.get("documentDescription");
                        boolean doContentNameTranslation = contentNameStorage == null || contentNameStorage.getProperty("db.doNotTranslate") == null || !contentNameStorage.getProperty("db.doNotTranslate").equalsIgnoreCase("true");
                        boolean doContentDescriptionTranslation = contentDescStorage == null || contentDescStorage.getProperty("db.doNotTranslate") == null || !contentDescStorage.getProperty("db.doNotTranslate").equalsIgnoreCase("true");
                        boolean doDocumentNameTranslation = documentNameStorage == null || documentNameStorage.getProperty("db.doNotTranslate") == null || !documentNameStorage.getProperty("db.doNotTranslate").equalsIgnoreCase("true");
                        boolean doDocumentDescriptionTranslation = documentDescStorage == null || documentDescStorage.getProperty("db.doNotTranslate") == null || !documentDescStorage.getProperty("db.doNotTranslate").equalsIgnoreCase("true");
                        String contentNameSearchConditions = this._composeFullTextQuery(currSearchedMetaData.getValue().toString(), doContentNameTranslation, translateColumnPattern, translateValuePattern, currSearchedMetaData.getOperationSelected());
                        String contentDescriptionSearchConditions = this._composeFullTextQuery(currSearchedMetaData.getValue().toString(), doContentDescriptionTranslation, translateColumnPattern, translateValuePattern, currSearchedMetaData.getOperationSelected());
                        String documentNameSearchConditions = this._composeFullTextQuery(currSearchedMetaData.getValue().toString(), doDocumentNameTranslation, translateColumnPattern, translateValuePattern, currSearchedMetaData.getOperationSelected());
                        String documentDescriptionSearchConditions = this._composeFullTextQuery(currSearchedMetaData.getValue().toString(), doDocumentDescriptionTranslation, translateColumnPattern, translateValuePattern, currSearchedMetaData.getOperationSelected());
                        StringBuffer textToSearch = new StringBuffer();
                        HashMap<String, String> varValues = new HashMap<String, String>(2);
                        if (contentNameStorage != null) {
                            varValues.put("METADATA_TABLE", (String)contentNameStorage.getProperties().get("db.table"));
                            varValues.put("METADATAFIELD", (String)contentNameStorage.getProperties().get("db.tableCol"));
                            textToSearch.append('(').append(StringUtils.replaceVariableValues((String)contentNameSearchConditions, (String)"$", varValues, (boolean)true)).append(") OR (");
                        }
                        if (contentDescStorage != null) {
                            varValues.put("METADATA_TABLE", (String)contentDescStorage.getProperties().get("db.table"));
                            varValues.put("METADATAFIELD", (String)contentDescStorage.getProperties().get("db.tableCol"));
                            textToSearch.append(StringUtils.replaceVariableValues((String)contentDescriptionSearchConditions, (String)"$", varValues, (boolean)true)).append(") OR (");
                        }
                        if (documentNameStorage != null) {
                            varValues.put("METADATA_TABLE", (String)documentNameStorage.getProperties().get("db.table"));
                            varValues.put("METADATAFIELD", (String)documentNameStorage.getProperties().get("db.tableCol"));
                            textToSearch.append(StringUtils.replaceVariableValues((String)documentNameSearchConditions, (String)"$", varValues, (boolean)true)).append(") OR (");
                        }
                        if (documentDescStorage != null) {
                            varValues.put("METADATA_TABLE", (String)documentDescStorage.getProperties().get("db.table"));
                            varValues.put("METADATAFIELD", (String)documentDescStorage.getProperties().get("db.tableCol"));
                            textToSearch.append(StringUtils.replaceVariableValues((String)documentDescriptionSearchConditions, (String)"$", varValues, (boolean)true)).append(")");
                        }
                        fullTextSQL.append(textToSearch);
                    }
                    if (StringUtils.isEmptyStringBuffer((StringBuffer)fullTextSQL)) continue;
                    fullTextSQL.insert(0, '(');
                    fullTextSQL.append(')');
                    metaDataSubConditions.append(fullTextSQL);
                    if (DEBUG) {
                        R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t\t\tmetaData oid=" + currSearchedMetaData.getOid() + ": " + fullTextSQL);
                    }
                    if (!mdIt.hasNext()) continue;
                    metaDataSubConditions.append(" ");
                    metaDataSubConditions.append(union);
                    metaDataSubConditions.append(" ");
                    continue;
                }
                currSearchedMetaDataStorageCfg = (R01MMetaDataStorageConfig)searchedMetaDataStorageCfgs.get(currSearchedMetaData.getOid());
                if (!"nameSearch".equalsIgnoreCase(currSearchedMetaData.getOid()) && currSearchedMetaDataStorageCfg == null) {
                    if (!DEBUG) continue;
                    R01FLog.to((String)"r01k.searchSentenceBuilder").warning("\t\t\t\tmetaData oid=" + currSearchedMetaData.getOid() + ": No est\u00e1 cargado en la configuraci\u00f3n de metadatos, se elimina.");
                    continue;
                }
                metaDataSQL.setLength(0);
                String metaFilterSQL = null;
                if ("nameSearch".equalsIgnoreCase(currSearchedMetaData.getOid())) {
                    String textToSearch = this._composeFullTextQuery(currSearchedMetaData.getValue().toString(), false, null, null, currSearchedMetaData.getOperationSelected());
                    metaFilterSQL = this._composeAllCurrentMetaDataFilterSQL(textToSearch, patterns.getProperty("db.fullTextContains")).toString();
                } else {
                    String currentMetadataTextPattern;
                    String string = XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"metadatasImplementedWithOracleText/contentNameMetadata", (String)"contentName").equalsIgnoreCase(currSearchedMetaData.getOid()) ? patterns.getProperty("db.documentFullTextContentName") : (XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"metadatasImplementedWithOracleText/contentDescriptionMetadata", (String)"contentDescription").equalsIgnoreCase(currSearchedMetaData.getOid()) ? patterns.getProperty("db.documentFullTextContentDescription") : (XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"metadatasImplementedWithOracleText/documentNameMetadata", (String)"documentName").equalsIgnoreCase(currSearchedMetaData.getOid()) ? patterns.getProperty("db.documentFullTextDocumentName") : (currentMetadataTextPattern = XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"metadatasImplementedWithOracleText/documentDescriptionMetadata", (String)"documentDescription").equalsIgnoreCase(currSearchedMetaData.getOid()) ? patterns.getProperty("db.documentFullTextDocumentDescription") : null)));
                    if (!StringUtils.isEmptyString((String)currentMetadataTextPattern) && currSearchedMetaData.operationSelected.equalsIgnoreCase("NEQ")) {
                        currentMetadataTextPattern = "NOT " + currentMetadataTextPattern;
                    }
                    metaFilterSQL = this._composeCurrentMetaDataFilterSQL(currSearchedMetaDataStorageCfg, currSearchedMetaData, patterns.getProperty("db.metaDataFilterSQL"), translateColumnPattern, translateValuePattern, currentMetadataTextPattern);
                }
                if (!StringUtils.isEmptyString((String)metaFilterSQL)) {
                    metaDataSQL.append(metaFilterSQL);
                }
                if (StringUtils.isEmptyStringBuffer((StringBuffer)metaDataSQL)) continue;
                metaDataSubConditions.append(metaDataSQL);
                if (DEBUG) {
                    R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t\t\tmetaData oid=" + currSearchedMetaData.getOid() + ": " + metaDataSQL);
                }
                if (!mdIt.hasNext()) continue;
                metaDataSubConditions.append(" ");
                metaDataSubConditions.append(union);
                metaDataSubConditions.append(" ");
            }
        }
        if ((str = metaDataSubConditions.toString()).endsWith(" " + union + " ")) {
            return new StringBuffer(str.substring(0, str.lastIndexOf(" " + union + " ")));
        }
        return metaDataSubConditions;
    }

    private String _composeCurrentMetaDataFilterSQL(R01MMetaDataStorageConfig currSearchedMetaDataStorageCfg, R01MSearchedMetaData currSearchedMetaData, String metaDataFilterSQLPattern, String translateColumnPattern, String translateValuePattern, String fieldTextContainsPattern) throws R01MSearchPerformerException {
        if (currSearchedMetaDataStorageCfg.getProperties() == null) {
            throw new R01MSearchPerformerException("Las propiedades del metaDato " + currSearchedMetaDataStorageCfg.getOid() + " son nulas: No se puede saber en qu\u00e9 tabla y columna se almancena. No se a\u00f1ade la condici\u00f3n sobre el metaDato");
        }
        String familyTableName = (String)currSearchedMetaDataStorageCfg.getProperties().get("db.table");
        String metaDataColName = (String)currSearchedMetaDataStorageCfg.getProperties().get("db.tableCol");
        if (metaDataColName != null && metaDataColName.indexOf("VIRTUAL") >= 0) {
            return null;
        }
        String metaDataColType = "String";
        Pattern p = Pattern.compile("(unknown|String|Integer|Long|Short|Float|Double|Date|List|Map|R01MStructureCatalog|R01MGeoCatalog|R01MSearchResultItemPublicationInfo)(?:\\((.+)\\))*");
        Matcher m = p.matcher(currSearchedMetaDataStorageCfg.getDataType());
        if (m.find() && m.groupCount() >= 2) {
            metaDataColType = m.group(1);
        }
        if (metaDataColType == null || metaDataColType.length() == 0 || currSearchedMetaData.getOperationSelected() == null || currSearchedMetaData.getOperationSelected().length() == 0 || currSearchedMetaData.getValue() == null || currSearchedMetaData.getValue().length() == 0) {
            if (DEBUG) {
                R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t\t\tmetaData oid=" + currSearchedMetaData.getOid() + " [***WARNING***] se ignora: la condici\u00f3n de filtro NO es v\u00e1lida: el tipo de dato configurado para la columna de base de datos, la operaci\u00f3n seleccionada o el valor buscado del metaDato NO son correctos");
            }
        } else {
            String[] finallyAppliedMeataDataOperatorAndValue = this.transformMetaDataOperatorAndValue(metaDataColType, currSearchedMetaData.getOperationSelected(), currSearchedMetaData.getValue());
            if (finallyAppliedMeataDataOperatorAndValue != null) {
                StringBuffer fixedMetaDataValue;
                String appliedMetaDataOperator = (String)METADATA_OPERATION_TYPES.get(finallyAppliedMeataDataOperatorAndValue[0]);
                boolean doStringTranslation = true;
                if (metaDataColType.equalsIgnoreCase("String") && currSearchedMetaDataStorageCfg.getProperty("db.doNotTranslate") != null && currSearchedMetaDataStorageCfg.getProperty("db.doNotTranslate").equalsIgnoreCase("true")) {
                    doStringTranslation = false;
                }
                if (!StringUtils.isEmptyStringBuffer((StringBuffer)(fixedMetaDataValue = this._fixMetaDataValueToConditionValue(metaDataColType, finallyAppliedMeataDataOperatorAndValue[0], appliedMetaDataOperator, finallyAppliedMeataDataOperatorAndValue[1], doStringTranslation ? translateValuePattern : null)))) {
                    if (metaDataColType.equalsIgnoreCase("String") && doStringTranslation) {
                        metaDataColName = StringUtils.replaceString((String)translateColumnPattern, (String)"$METADATAFIELD$", (String)metaDataColName);
                    }
                    if (metaDataColType.equalsIgnoreCase("Date") && (appliedMetaDataOperator.equalsIgnoreCase("=") || appliedMetaDataOperator.equalsIgnoreCase("!=") || appliedMetaDataOperator.equalsIgnoreCase("<") || appliedMetaDataOperator.equalsIgnoreCase(">") || appliedMetaDataOperator.equalsIgnoreCase(">=") || appliedMetaDataOperator.equalsIgnoreCase("<=") || appliedMetaDataOperator.equalsIgnoreCase("BETWEEN"))) {
                        metaDataColName = "TO_CHAR(" + metaDataColName + ",'" + this.getNativeDateFormat() + "')";
                    }
                    String metaDataSQL = new String(metaDataFilterSQLPattern);
                    String fixedMetaDataColName = metaDataColName;
                    if (doStringTranslation && metaDataSQL.startsWith("$METADATA_TABLE$.")) {
                        metaDataSQL = metaDataSQL.substring("$METADATA_TABLE$.".length());
                    }
                    if (finallyAppliedMeataDataOperatorAndValue[0].equalsIgnoreCase("ALL")) {
                        Pattern p1 = Pattern.compile("('%?[^(?:%')]+%?')");
                        Matcher m1 = p1.matcher(fixedMetaDataValue);
                        String partialMetadataSQL = metaDataSQL;
                        metaDataSQL = "";
                        HashMap<String, String> varValues = new HashMap<String, String>(4);
                        varValues.put("METADATA_TABLE", familyTableName);
                        varValues.put("METADATAFIELD", fixedMetaDataColName);
                        varValues.put("OPERATOR", appliedMetaDataOperator);
                        while (m1.find()) {
                            String metaDataValueFormatted = m1.group();
                            if (translateValuePattern != null) {
                                metaDataValueFormatted = StringUtils.replaceString((String)translateValuePattern, (String)"$METADATAVALUE$", (String)metaDataValueFormatted.toUpperCase());
                            }
                            varValues.put("METADATAVALUE", metaDataValueFormatted);
                            metaDataSQL = metaDataSQL + StringUtils.replaceVariableValues((String)partialMetadataSQL, (String)"$", varValues, (boolean)true) + " AND ";
                        }
                        if (metaDataSQL.endsWith(" AND ")) {
                            metaDataSQL = metaDataSQL.substring(0, metaDataSQL.length() - " AND ".length());
                        }
                        if (!StringUtils.isEmptyString((String)metaDataSQL)) {
                            metaDataSQL = "(" + metaDataSQL + ")";
                        }
                    } else if (finallyAppliedMeataDataOperatorAndValue[0].equalsIgnoreCase("ANY")) {
                        Pattern p1 = Pattern.compile("('%?[^(?:%')]+%?')");
                        Matcher m1 = p1.matcher(fixedMetaDataValue);
                        String partialMetadataSQL = metaDataSQL;
                        metaDataSQL = "";
                        HashMap<String, String> varValues = new HashMap<String, String>(4);
                        varValues.put("METADATA_TABLE", familyTableName);
                        varValues.put("METADATAFIELD", fixedMetaDataColName);
                        varValues.put("OPERATOR", appliedMetaDataOperator);
                        while (m1.find()) {
                            String metaDataValueFormatted = m1.group();
                            if (translateValuePattern != null) {
                                metaDataValueFormatted = StringUtils.replaceString((String)translateValuePattern, (String)"$METADATAVALUE$", (String)metaDataValueFormatted.toUpperCase());
                            }
                            varValues.put("METADATAVALUE", metaDataValueFormatted);
                            metaDataSQL = metaDataSQL + StringUtils.replaceVariableValues((String)partialMetadataSQL, (String)"$", varValues, (boolean)true) + " OR ";
                        }
                        if (metaDataSQL.endsWith(" OR ")) {
                            metaDataSQL = metaDataSQL.substring(0, metaDataSQL.length() - " OR ".length());
                        }
                        if (!StringUtils.isEmptyString((String)metaDataSQL)) {
                            metaDataSQL = "(" + metaDataSQL + ")";
                        }
                    } else {
                        if (this._searchInOracleText && !StringUtils.isEmptyString((String)fieldTextContainsPattern)) {
                            String textToSearch = this._composeFullTextQuery(currSearchedMetaData.getValue().toString(), false, null, null, finallyAppliedMeataDataOperatorAndValue[0]);
                            metaDataSQL = this._composeAllCurrentMetaDataFilterSQL(textToSearch, fieldTextContainsPattern).toString();
                        }
                        HashMap<String, String> varValues = new HashMap<String, String>(4);
                        varValues.put("METADATA_TABLE", familyTableName);
                        varValues.put("METADATAFIELD", fixedMetaDataColName);
                        varValues.put("OPERATOR", appliedMetaDataOperator);
                        varValues.put("METADATAVALUE", fixedMetaDataValue.toString());
                        metaDataSQL = StringUtils.replaceVariableValues((String)metaDataSQL, (String)"$", varValues, (boolean)true);
                    }
                    if (currSearchedMetaData.getOperationSelected().equals("GTEN")) {
                        metaDataSQL = "((" + metaDataSQL + ") OR (" + metaDataColName + "IS NULL) OR (" + metaDataColName + "=''))";
                    }
                    return metaDataSQL;
                }
            }
        }
        return null;
    }

    private StringBuffer _fixMetaDataValueToConditionValue(String metaDataType, String logicalOperator, String appliedMetaDataOperator, String metaDataValue, String translateValuePattern) {
        StringBuffer metaDataValueFormatted = new StringBuffer(metaDataValue);
        if (appliedMetaDataOperator == null) {
            R01FLog.to((String)"r01k.searchSentenceBuilder").warning("NO se encuentra la condici\u00f3n de filtro para metaDatos " + metaDataType + ":" + metaDataValue + " en el fichero r01k.properties.xml: Se IGNORA la condici\u00f3n");
        } else if (appliedMetaDataOperator.equalsIgnoreCase("BETWEEN")) {
            if (metaDataValue.indexOf(",") == 0) {
                R01FLog.to((String)"r01k.searchSentenceBuilder").warning("R01KSearchSQLBuilder: Los valores suministrados para  construir la condici\u00f3n de tipo BETWEEN " + metaDataValue + " NO contienen el separador que se espera (" + "," + "): NO se a\u00f1ade la condici\u00f3n del metadato");
                return null;
            }
            if (metaDataType.equalsIgnoreCase("String") || metaDataType.equalsIgnoreCase("Integer") || metaDataType.equalsIgnoreCase("Long") || metaDataType.equalsIgnoreCase("Date")) {
                StringTokenizer metaDataValTokenizer = new StringTokenizer(metaDataValue, ",");
                if (metaDataValTokenizer.countTokens() != 2) {
                    R01FLog.to((String)"r01k.searchSentenceBuilder").warning("R01KSearchSQLBuilder: El n\u00famero de elementos pasados para  construir la condici\u00f3n de tipo BETWEEN es distino de 2: NO se a\u00f1ade la condici\u00f3n del metadato");
                    return null;
                }
                String betweenBeginVal = metaDataValTokenizer.nextToken();
                String betweenEndVal = metaDataValTokenizer.nextToken();
                if (metaDataType.equalsIgnoreCase("Date")) {
                    betweenBeginVal = this._prepareDateMetaData(this.extractDateFromQuery(betweenBeginVal));
                    betweenEndVal = this._prepareDateMetaData(this.extractDateFromQuery(betweenEndVal));
                    metaDataValueFormatted.setLength(0);
                    metaDataValueFormatted.append(betweenBeginVal);
                    metaDataValueFormatted.append(" AND ");
                    metaDataValueFormatted.append(betweenEndVal);
                } else {
                    metaDataValueFormatted.setLength(0);
                    metaDataValueFormatted.append("'");
                    metaDataValueFormatted.append(betweenBeginVal);
                    metaDataValueFormatted.append("' AND '");
                    metaDataValueFormatted.append(betweenEndVal);
                    metaDataValueFormatted.append("'");
                }
            } else {
                metaDataValueFormatted = new StringBuffer(StringUtils.replaceString((String)metaDataValueFormatted.toString(), (String)",", (String)" AND "));
            }
        } else if (logicalOperator.equalsIgnoreCase("IN")) {
            Pattern p1 = Pattern.compile("\\(([^)]+)\\)");
            Matcher m1 = p1.matcher(metaDataValue);
            metaDataValueFormatted.delete(0, metaDataValueFormatted.length());
            if (m1.matches()) {
                String commaSeparatedValues = m1.group(1);
                String[] values = commaSeparatedValues.split(",");
                metaDataValueFormatted.append('(');
                for (int i = 0; i < values.length; ++i) {
                    if (metaDataType.equalsIgnoreCase("String")) {
                        if (translateValuePattern != null) {
                            metaDataValueFormatted.append(StringUtils.replaceString((String)translateValuePattern, (String)"$METADATAVALUE$", (String)("'" + values[i].toUpperCase() + "'")));
                        } else {
                            metaDataValueFormatted.append("'");
                            metaDataValueFormatted.append(values[i]);
                            metaDataValueFormatted.append("'");
                        }
                    } else if (metaDataType.equalsIgnoreCase("Date")) {
                        metaDataValueFormatted.append(this._prepareDateMetaData(this.extractDateFromQuery(values[i])));
                    } else {
                        metaDataValueFormatted.append(values[i]);
                    }
                    if (i >= values.length - 1) continue;
                    metaDataValueFormatted.append(',');
                }
                metaDataValueFormatted.append(')');
            }
        } else if (logicalOperator.equalsIgnoreCase("ANY")) {
            Pattern p1 = Pattern.compile("\\(([^)]+)\\)");
            Matcher m1 = p1.matcher(metaDataValue);
            metaDataValueFormatted.delete(0, metaDataValueFormatted.length());
            metaDataValueFormatted.delete(0, metaDataValueFormatted.length());
            if (m1.matches()) {
                String commaSeparatedValues = m1.group(1);
                String[] values = commaSeparatedValues.split(",");
                for (int i = 0; i < values.length; ++i) {
                    StringUtils.replaceString((String)values[i], (String)"%", (String)"\\%");
                    StringUtils.replaceString((String)values[i], (String)"'", (String)"\\'");
                    metaDataValueFormatted.append("'").append(values[i]).append("',");
                }
                metaDataValueFormatted.delete(metaDataValueFormatted.length() - 1, metaDataValueFormatted.length());
            }
        } else if (logicalOperator.equalsIgnoreCase("ALL")) {
            Pattern p1 = Pattern.compile("\\(([^)]+)\\)");
            Matcher m1 = p1.matcher(metaDataValue);
            metaDataValueFormatted.delete(0, metaDataValueFormatted.length());
            metaDataValueFormatted.delete(0, metaDataValueFormatted.length());
            if (m1.matches()) {
                String commaSeparatedValues = m1.group(1);
                String[] values = commaSeparatedValues.split(",");
                for (int i = 0; i < values.length; ++i) {
                    StringUtils.replaceString((String)values[i], (String)"%", (String)"\\%");
                    StringUtils.replaceString((String)values[i], (String)"'", (String)"\\'");
                    metaDataValueFormatted.append("'").append(values[i]).append("',");
                }
                metaDataValueFormatted.delete(metaDataValueFormatted.length() - 1, metaDataValueFormatted.length());
            }
        } else if (metaDataType.equalsIgnoreCase("String")) {
            StringUtils.replaceAll((StringBuffer)metaDataValueFormatted, (String)"\n", (String)"");
            StringUtils.replaceAll((StringBuffer)metaDataValueFormatted, (String)"\r", (String)"");
            String comaSimple = "'";
            String comaDoble = "\"";
            StringUtils.replaceAll((StringBuffer)metaDataValueFormatted, (String)comaDoble, (String)comaSimple);
            if (appliedMetaDataOperator.equalsIgnoreCase("LIKE") && logicalOperator.equalsIgnoreCase("LIKE")) {
                StringUtils.replaceAll((StringBuffer)metaDataValueFormatted, (String)"%", (String)"");
                metaDataValueFormatted.insert(0, '%');
                metaDataValueFormatted.append('%');
                StringUtils.replaceAll((StringBuffer)metaDataValueFormatted, (String)" + ", (String)"%");
            } else if (appliedMetaDataOperator.equalsIgnoreCase("LIKE") && logicalOperator.equalsIgnoreCase("BEGINNING")) {
                StringUtils.replaceAll((StringBuffer)metaDataValueFormatted, (String)"%", (String)"");
                metaDataValueFormatted.append('%');
                StringUtils.replaceAll((StringBuffer)metaDataValueFormatted, (String)" + ", (String)"%");
            } else if (appliedMetaDataOperator.equalsIgnoreCase("LIKE") && logicalOperator.equalsIgnoreCase("ENDING")) {
                StringUtils.replaceAll((StringBuffer)metaDataValueFormatted, (String)"%", (String)"");
                metaDataValueFormatted.insert(0, '%');
                StringUtils.replaceAll((StringBuffer)metaDataValueFormatted, (String)" + ", (String)"%");
            }
            metaDataValueFormatted.insert(0, "'");
            metaDataValueFormatted.append("'");
            if (translateValuePattern != null) {
                metaDataValueFormatted = new StringBuffer(StringUtils.replaceString((String)translateValuePattern, (String)"$METADATAVALUE$", (String)metaDataValueFormatted.toString().toUpperCase()));
            }
        } else if (metaDataType.equalsIgnoreCase("Date")) {
            metaDataValueFormatted = new StringBuffer(this._prepareDateMetaData(this.extractDateFromQuery(metaDataValueFormatted.toString())));
        }
        return metaDataValueFormatted;
    }

    private StringBuffer _composeAllCurrentMetaDataFilterSQL(String searchWords, String fullTextContainsPattern) throws R01MSearchPerformerException {
        String fullTextSQL = StringUtils.replaceString((String)fullTextContainsPattern, (String)"$METADATAVALUE$", (String)searchWords);
        return new StringBuffer(fullTextSQL);
    }

    private String _composeFullTextQuery(String textToSearch, boolean doStringTranslation, String translateColumnPattern, String translateValuePattern, String logicalOperator) {
        Pattern pattern = Pattern.compile("[\"']([^\"]+)[\"']|([^\"']+)");
        Matcher matcher = pattern.matcher(textToSearch);
        StringBuffer sb = new StringBuffer(textToSearch.length());
        while (matcher.find()) {
            String quotedText = matcher.group(1);
            String unQuotedText = matcher.group(2);
            if (quotedText != null) {
                if (this._searchInOracleText) {
                    matcher.appendReplacement(sb, '{' + quotedText.replaceAll("\\$", "\\\\\\$") + '}');
                    continue;
                }
                if (doStringTranslation) {
                    matcher.appendReplacement(sb, (translateColumnPattern + "$METADATAFIELD$ LIKE '%" + StringUtils.replaceString((String)translateValuePattern, (String)"$METADATAVALUE$", (String)quotedText.toUpperCase())).replaceAll("\\$", "\\\\\\$") + "%'");
                    continue;
                }
                matcher.appendReplacement(sb, ("$METADATAFIELD$ LIKE '%" + quotedText + "%'").replaceAll("\\$", "\\\\\\$"));
                continue;
            }
            if (unQuotedText.matches(".*[\\+\\&\\|~\\!].*")) {
                unQuotedText = StringUtils.replaceString((String)unQuotedText, (String)"+", (String)" AND ");
                unQuotedText = StringUtils.replaceString((String)unQuotedText, (String)"&", (String)" AND ");
                unQuotedText = StringUtils.replaceString((String)unQuotedText, (String)"|", (String)" OR ");
                unQuotedText = StringUtils.replaceString((String)unQuotedText, (String)"~", (String)" NOT ");
                unQuotedText = StringUtils.replaceString((String)unQuotedText, (String)"!", (String)" NOT ");
            }
            unQuotedText = unQuotedText.replaceAll("\\(\\s+", "(");
            unQuotedText = unQuotedText.replaceAll("\\s+\\)", ")");
            unQuotedText = unQuotedText.replaceAll("\\s+", " ");
            unQuotedText = unQuotedText.replaceAll("(?<!AND|OR|NEAR|NOT)([ ])(?!AND|OR|NEAR|NOT)", " AND ");
            if (this._searchInOracleText) {
                unQuotedText = StringUtils.replaceString((String)unQuotedText, (String)"_", (String)"\\_");
                unQuotedText = StringUtils.replaceString((String)unQuotedText, (String)"-", (String)"\\-");
                unQuotedText = StringUtils.replaceString((String)unQuotedText, (String)"[", (String)"");
                unQuotedText = StringUtils.replaceString((String)unQuotedText, (String)"]", (String)"");
            } else {
                unQuotedText = unQuotedText.replaceAll(" NEAR ", " OR ");
                StringBuffer sb2 = new StringBuffer(unQuotedText.length());
                Pattern pattern2 = Pattern.compile("([^ \\(\\)]+)");
                Matcher matcher2 = pattern2.matcher(unQuotedText);
                while (matcher2.find()) {
                    if (matcher2.group(1).matches("(AND|OR|NOT)")) {
                        matcher2.appendReplacement(sb2, matcher2.group(1).replaceAll("\\$", "\\\\\\$"));
                        continue;
                    }
                    if (doStringTranslation) {
                        matcher2.appendReplacement(sb2, (translateColumnPattern + " LIKE " + StringUtils.replaceString((String)translateValuePattern, (String)"$METADATAVALUE$", (String)("'%" + matcher2.group(1).toUpperCase() + "%'"))).replaceAll("\\$", "\\\\\\$"));
                        continue;
                    }
                    matcher2.appendReplacement(sb2, ("$METADATAFIELD$ LIKE '%'%" + matcher2.group(1) + "%'" + "%'").replaceAll("\\$", "\\\\\\$"));
                }
                matcher2.appendTail(sb2);
                unQuotedText = sb2.toString();
            }
            matcher.appendReplacement(sb, unQuotedText.replaceAll("\\$", "\\\\\\$"));
        }
        matcher.appendTail(sb);
        if (this._searchInOracleText) {
            pattern = Pattern.compile("(\\{[^\\{\\}]+\\})|([^\\{\\}]+)");
            matcher = pattern.matcher(sb.toString());
            StringBuffer sbOracleText = new StringBuffer(sb.toString().length());
            while (matcher.find()) {
                String quotedText = matcher.group(1);
                String unQuotedText = matcher.group(2);
                if (quotedText != null) {
                    matcher.appendReplacement(sbOracleText, quotedText.replaceAll("\\$", "\\\\\\$"));
                    continue;
                }
                Pattern patternWord = Pattern.compile("([^ ]+)");
                Matcher matcherWord = patternWord.matcher(unQuotedText);
                StringBuffer sbWord = new StringBuffer(unQuotedText.length());
                while (matcherWord.find()) {
                    String word = matcherWord.group(1);
                    if (word.matches("(AND|OR|NOT|NEAR)")) {
                        matcherWord.appendReplacement(sbWord, word.replaceAll("\\$", "\\\\\\$"));
                        continue;
                    }
                    if (StringUtils.isEmptyString((String)logicalOperator)) {
                        matcherWord.appendReplacement(sbWord, word.replaceAll("\\$", "\\\\\\$"));
                        continue;
                    }
                    if (logicalOperator.equalsIgnoreCase("LIKE")) {
                        if (unQuotedText.indexOf(" ") > 0) {
                            matcherWord.appendReplacement(sbWord, word.replaceAll("\\$", "\\\\\\$"));
                            continue;
                        }
                        matcherWord.appendReplacement(sbWord, "%" + word.replaceAll("\\$", "\\\\\\$") + "%");
                        continue;
                    }
                    if (logicalOperator.equalsIgnoreCase("BEGINNING")) {
                        matcherWord.appendReplacement(sbWord, word.replaceAll("\\$", "\\\\\\$") + "%");
                        continue;
                    }
                    if (logicalOperator.equalsIgnoreCase("ENDING")) {
                        matcherWord.appendReplacement(sbWord, "%" + word.replaceAll("\\$", "\\\\\\$"));
                        continue;
                    }
                    matcherWord.appendReplacement(sbWord, word.replaceAll("\\$", "\\\\\\$"));
                }
                matcherWord.appendTail(sbWord);
                matcher.appendReplacement(sbOracleText, sbWord.toString().replaceAll("\\$", "\\\\\\$"));
            }
            matcher.appendTail(sbOracleText);
            return sbOracleText.toString();
        }
        String conditionsToReturn = sb.toString();
        conditionsToReturn = conditionsToReturn.replaceAll("NOT $METADATAFIELD$ LIKE", "$METADATAFIELD$ NOT LIKE");
        if (!doStringTranslation) {
            conditionsToReturn = conditionsToReturn.replaceAll("$METADATAFIELD$", "$METADATA_TABLE$.$METADATAFIELD$");
        }
        return conditionsToReturn;
    }

    @Override
    protected String executeGetPatternsKey(String searchMetaDataStorageCfgID) {
        return "db." + searchMetaDataStorageCfgID;
    }

    @Override
    protected void executeCheckMetaDataStorageConfigs(Map metaDataStorageCfgs) throws R01MSearchPerformerException {
        if (metaDataStorageCfgs == null) {
            return;
        }
        R01MMetaDataStorageConfig currMetaDataStorageCfg2 = null;
        for (R01MMetaDataStorageConfig currMetaDataStorageCfg2 : metaDataStorageCfgs.values()) {
            if (currMetaDataStorageCfg2.getProperties().get("db.table") == null) {
                throw new R01MSearchPerformerException("El metaDato " + currMetaDataStorageCfg2.getOid() + " est\u00e1 mal definido en el fichero searchMetaDataStorage.xml ya que no se ha definido la tabla en la que se almacena (propiedad db.table)");
            }
            if (currMetaDataStorageCfg2.getProperties().get("db.pk") == null) {
                throw new R01MSearchPerformerException("El metaDato " + currMetaDataStorageCfg2.getOid() + " est\u00e1 mal definido en el fichero searchMetaDataStorage.xml ya que no se ha definido la columna que hace de clave primaria en la tabla " + (String)currMetaDataStorageCfg2.getProperties().get("db.table") + " (propiedad db.pk)");
            }
            if (currMetaDataStorageCfg2.getProperties().get("db.tableCol") == null) {
                throw new R01MSearchPerformerException("El metaDato " + currMetaDataStorageCfg2.getOid() + " est\u00e1 mal definido en el fichero searchMetaDataStorage.xml ya que no se ha definido la columna de la tabla " + (String)currMetaDataStorageCfg2.getProperties().get("db.table") + " en la que se almacena (propiedad db.tableCol)");
            }
            if (currMetaDataStorageCfg2.getDataType() != null) continue;
            throw new R01MSearchPerformerException("El metaDato " + currMetaDataStorageCfg2.getOid() + " est\u00e1 mal definido en el fichero searchMetaDataStorage.xml ya que no se ha definido su tipo de dato (propiedad datatype)");
        }
    }

    @Override
    protected Properties executeObtainQueryBuilderPatterns(Map<String, String> typoStorageProperties) throws R01MSearchPerformerException {
        if (typoStorageProperties == null) {
            throw new R01MSearchPerformerException("No se ha encontrado la secci\u00f3n <properties> en la configuraci\u00f3n de almacenamiento de tipos: revisa el fichero searchMetaDataStorage.xml");
        }
        for (int i = 0; i < propertiesKeys.length; ++i) {
            String currProp = propertiesKeys[i];
            if (typoStorageProperties.get(currProp) != null) continue;
            throw new R01MSearchPerformerException("No se ha encontrado el patron '" + currProp + "' en las propiedades de configuraci\u00f3n de almacenamiento de tipos: revisa el fichero searchMetaDataStorage.xml");
        }
        Properties outProps = new Properties();
        outProps.put("db.queryParts", typoStorageProperties.get("db.queryParts"));
        outProps.put("db.basicSelectSQL", typoStorageProperties.get("db.basicSelectSQL"));
        outProps.put("db.contentColsSelectorSQL", typoStorageProperties.get("db.contentColsSelectorSQL"));
        outProps.put("db.documentColsSelectorSQL", typoStorageProperties.get("db.documentColsSelectorSQL"));
        outProps.put("db.dataFileColsSelectorSQL", typoStorageProperties.get("db.dataFileColsSelectorSQL"));
        outProps.put("db.pagerSelectSQL", typoStorageProperties.get("db.pagerSelectSQL"));
        outProps.put("db.fromBasicTablesListSQL", typoStorageProperties.get("db.fromBasicTablesListSQL"));
        outProps.put("db.basicTablesJoinSQL", typoStorageProperties.get("db.basicTablesJoinSQL"));
        outProps.put("db.typoTableJoinSQL", typoStorageProperties.get("db.typoTableJoinSQL"));
        outProps.put("db.structureLabelFilterSQL", typoStorageProperties.get("db.structureLabelFilterSQL"));
        outProps.put("db.labelsCondition", typoStorageProperties.get("db.labelsCondition"));
        outProps.put("db.publishRepositoriesFilterSQL", typoStorageProperties.get("db.publishRepositoriesFilterSQL"));
        outProps.put("db.storageServerFilterSQL", typoStorageProperties.get("db.storageServerFilterSQL"));
        outProps.put("db.storageDataStoreFilterSQL", typoStorageProperties.get("db.storageDataStoreFilterSQL"));
        outProps.put("db.storageAreaFilterSQL", typoStorageProperties.get("db.storageAreaFilterSQL"));
        outProps.put("db.storageWorkAreaFilterSQL", typoStorageProperties.get("db.storageWorkAreaFilterSQL"));
        outProps.put("db.typoClusterFilterSQL", typoStorageProperties.get("db.typoClusterFilterSQL"));
        outProps.put("db.typoFamilyFilterSQL", typoStorageProperties.get("db.typoFamilyFilterSQL"));
        outProps.put("db.typoTypeFilterSQL", typoStorageProperties.get("db.typoTypeFilterSQL"));
        outProps.put("db.typoExcludeTypesFilterSQL", typoStorageProperties.get("db.typoExcludeTypesFilterSQL"));
        outProps.put("db.metaDataFilterSQL", typoStorageProperties.get("db.metaDataFilterSQL"));
        outProps.put("db.defaultOrderBy", typoStorageProperties.get("db.defaultOrderBy"));
        outProps.put("db.defaultPublishOrderBy", typoStorageProperties.get("db.defaultPublishOrderBy"));
        outProps.put("db.translatecolumn", typoStorageProperties.get("db.translatecolumn"));
        outProps.put("db.translatevalue", typoStorageProperties.get("db.translatevalue"));
        outProps.put("db.structureLabelsSelectSQL", typoStorageProperties.get("db.structureLabelsSelectSQL"));
        outProps.put("db.documentPubsSelectSQL", typoStorageProperties.get("db.documentPubsSelectSQL"));
        outProps.put("db.fromBasicTablesAndSubSelectListSQL", typoStorageProperties.get("db.fromBasicTablesAndSubSelectListSQL"));
        outProps.put("db.fromColsSubSelectSQL", typoStorageProperties.get("db.fromColsSubSelectSQL"));
        outProps.put("db.fromColsCatalogStructureJoinTypeSQL", typoStorageProperties.get("db.fromColsCatalogStructureJoinTypeSQL"));
        outProps.put("db.fromColsCatalogLabelJoinTypeSQL", typoStorageProperties.get("db.fromColsCatalogLabelJoinTypeSQL"));
        outProps.put("db.fromColsCatalogRoleJoinTypeSQL", typoStorageProperties.get("db.fromColsCatalogRoleJoinTypeSQL"));
        outProps.put("db.fromColsSubSelectJoinSQL", typoStorageProperties.get("db.fromColsSubSelectJoinSQL"));
        outProps.put("db.whereSimpleFilterSQL", typoStorageProperties.get("db.whereSimpleFilterSQL"));
        outProps.put("db.basicTablesSimpleJoinSQL", typoStorageProperties.get("db.basicTablesSimpleJoinSQL"));
        outProps.put("db.catalogAndOrJoinSQL", typoStorageProperties.get("db.catalogAndOrJoinSQL"));
        outProps.put("db.catalogBothAndOrJoinSQL", typoStorageProperties.get("db.catalogBothAndOrJoinSQL"));
        outProps.put("db.contentJoinSQL", typoStorageProperties.get("db.contentJoinSQL"));
        outProps.put("db.fromPublishTablesListSQL", typoStorageProperties.get("db.fromPublishTablesListSQL"));
        outProps.put("db.publishColsSelectorSQL", typoStorageProperties.get("db.publishColsSelectorSQL"));
        outProps.put("db.fromDefaultPublishTablesListSQL", typoStorageProperties.get("db.fromDefaultPublishTablesListSQL"));
        outProps.put("db.publishDefaultColsSelectorSQL", typoStorageProperties.get("db.publishDefaultColsSelectorSQL"));
        outProps.put("db.publishDefaultRepositoriesFilterSQL", typoStorageProperties.get("db.publishDefaultRepositoriesFilterSQL"));
        outProps.put("db.typoOneClusterFilterSQL", typoStorageProperties.get("db.typoOneClusterFilterSQL"));
        outProps.put("db.typoOneFamilyFilterSQL", typoStorageProperties.get("db.typoOneFamilyFilterSQL"));
        outProps.put("db.typoOneTypeFilterSQL", typoStorageProperties.get("db.typoOneTypeFilterSQL"));
        outProps.put("db.storageOneServerFilterSQL", typoStorageProperties.get("db.storageOneServerFilterSQL"));
        outProps.put("db.storageOneDataStoreFilterSQL", typoStorageProperties.get("db.storageOneDataStoreFilterSQL"));
        outProps.put("db.storageOneAreaFilterSQL", typoStorageProperties.get("db.storageOneAreaFilterSQL"));
        outProps.put("db.storageOneWorkAreaFilterSQL", typoStorageProperties.get("db.storageOneWorkAreaFilterSQL"));
        outProps.put("db.publishOneRepositoriesFilterSQL", typoStorageProperties.get("db.publishOneRepositoriesFilterSQL"));
        outProps.put("db.notPublishFilterSQL", typoStorageProperties.get("db.notPublishFilterSQL"));
        outProps.put("db.fullTextContains", typoStorageProperties.get("db.fullTextContains"));
        outProps.put("db.fieldTextContains", typoStorageProperties.get("db.fieldTextContains"));
        outProps.put("db.documentFullTextContentName", typoStorageProperties.get("db.documentFullTextContentName"));
        outProps.put("db.documentFullTextContentDescription", typoStorageProperties.get("db.documentFullTextContentDescription"));
        outProps.put("db.documentFullTextDocumentName", typoStorageProperties.get("db.documentFullTextDocumentName"));
        outProps.put("db.documentFullTextDocumentDescription", typoStorageProperties.get("db.documentFullTextDocumentDescription"));
        outProps.put("db.contentFullTextContains", typoStorageProperties.get("db.contentFullTextContains"));
        outProps.put("db.fromCatalogTablesListSQL", typoStorageProperties.get("db.fromCatalogTablesListSQL"));
        outProps.put("db.catalogAndOrFilterSQL", typoStorageProperties.get("db.catalogAndOrFilterSQL"));
        outProps.put("db.catalogJoinSQL", typoStorageProperties.get("db.catalogJoinSQL"));
        outProps.put("db.linkedDocumentsColsSelectorSQL", typoStorageProperties.get("db.linkedDocumentsColsSelectorSQL"));
        outProps.put("db.fromLinkedDocumentsTablesListSQL", typoStorageProperties.get("db.fromLinkedDocumentsTablesListSQL"));
        outProps.put("db.documentsLinkedTablesSimpleJoinSQL", typoStorageProperties.get("db.documentsLinkedTablesSimpleJoinSQL"));
        return outProps;
    }

    private String _prepareDateMetaData(String dateStr) {
        String dbDateConvSentence;
        if (dateStr == null) {
            return null;
        }
        String outDate = new String(dateStr);
        String string = dbDateConvSentence = this.getProperties() != null && this.getProperties().get("dbDateConvertSentence") != null ? (String)this.getProperties().get("dbDateConvertSentence") : null;
        if (dbDateConvSentence != null) {
            dbDateConvSentence = StringUtils.replaceString(dbDateConvSentence, (String)"$NATIVE_DATE_FORMAT$", (String)this.getNativeDateFormat());
            outDate = StringUtils.replaceString((String)dbDateConvSentence, (String)"$DATEVALUE$", (String)outDate);
        }
        return outDate;
    }
}

