/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01k.searchorchestrator.searchperformers;

import com.ejie.r01f.sql.DBManager;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01k.searchorchestrator.searchperformers.R01KBaseContentSearchPerformer;
import com.ejie.r01k.searchorchestrator.searchperformers.R01KBaseSearchQueryBuilder;
import com.ejie.r01k.searchorchestrator.searchperformers.R01KDBSQLBuilder;
import com.ejie.r01k.searchorchestrator.searchperformers.R01KInitQueryResult;
import com.ejie.r01k.searchorchestrator.searchperformers.R01KSearchEngineReturnedDataToResultItemTransformer;
import com.ejie.r01k.searchorchestrator.searchperformers.R01KSearchEngineReturnedDataToResultItemTransformerDefImpl;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MSearchMetaDataStorageConfig;
import com.ejie.r01m.exceptions.R01MSearchPerformerException;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.utils.R01MConstants;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class R01KDBContentSearchPerformer
extends R01KBaseContentSearchPerformer {
    private DBManager _dBManager = new DBManager(R01MConstants.SEARCHENGINE_APPCODE, "indexerConnection");

    @Override
    protected R01KSearchEngineReturnedDataToResultItemTransformer getSearchEngineReturnedDataToResultItemTransformer(R01MSearchMetaDataStorageConfig searchMetaDataStorageConfig) {
        return new R01KSearchEngineReturnedDataToResultItemTransformerDefImpl("db.tableCol");
    }

    @Override
    public R01KInitQueryResult executeCountQuery(boolean lazy, boolean isGuideCountQuery, String searchSessionOid, String searchSessionLang, String searchSourceOid, R01MQueryObject query) throws R01MSearchPerformerException {
        String querySQL = null;
        List listReturnValues = null;
        try {
            querySQL = this.composeSearchQuery(true, searchSessionOid, searchSessionLang, searchSourceOid, query, -1, null, null);
            listReturnValues = this._dBManager.executeQuery(querySQL, null);
        }
        catch (SQLException sqlEx) {
            throw new R01MSearchPerformerException("EXECUTE Query  >>>> Error al ejecutar la query " + querySQL + sqlEx.getMessage(), (Exception)sqlEx);
        }
        if (listReturnValues == null || listReturnValues.size() != 1) {
            throw new R01MSearchPerformerException("La consulta de inicializaci\u00f3n de la query (SELECT COUNT(*)) ha devuelto ninguno o m\u00e1s de un registro");
        }
        String countResult = (String)((Map)listReturnValues.get(0)).get("COUNT(*)");
        int foundRecords = Integer.parseInt(countResult);
        return new R01KInitQueryResult(foundRecords, null);
    }

    @Override
    public List executeQuery(String searchSessionOid, String searchSessionLang, String searchSourceOid, R01MQueryObject qry, int pageNum, Object pageFirstElementCod, Object pageLastElementCod) throws R01MSearchPerformerException {
        String querySQL = null;
        List outSearchResultRows = null;
        try {
            querySQL = this.composeSearchQuery(false, searchSessionOid, searchSessionLang, searchSourceOid, qry, pageNum, pageFirstElementCod, pageLastElementCod);
            outSearchResultRows = this._dBManager.executeQuery(querySQL, null);
            if (outSearchResultRows != null) {
                List pubs;
                List cats;
                Set contentOids = this._extractDistinctOids(outSearchResultRows, "OID_CONTENT_03");
                Set documentOids = this._extractDistinctOids(outSearchResultRows, "OID_DOCUMENT_04");
                R01MSearchMetaDataStorageConfig metaDataStorageCfg = this.getSearchMetaDataStorageConfig(qry, searchSourceOid);
                R01KBaseSearchQueryBuilder queryBuilder = this._obtainQueryBuilder();
                String labelsSelectSQL = queryBuilder.getPattern(metaDataStorageCfg, "db.structureLabelsSelectSQL");
                String pubsSelectSQL = queryBuilder.getPattern(metaDataStorageCfg, "db.documentPubsSelectSQL");
                HashMap contCats = null;
                HashMap docPubs = null;
                if (contentOids != null && !contentOids.isEmpty() && labelsSelectSQL != null && labelsSelectSQL.length() > 0 && (cats = this._dBManager.executeQuery(labelsSelectSQL = StringUtils.replaceString((String)labelsSelectSQL, (String)"$CONTENT_OIDs$", (String)this._stringSetToSeparatedCommaStr(contentOids)), null)) != null) {
                    contCats = new HashMap(cats.size());
                    String contCat = null;
                    Map currRow2 = null;
                    for (Map currRow2 : cats) {
                        if (currRow2.get("OID_ESTRUCTURA_07") == null || currRow2.get("OID_ETIQUETA_07") == null || currRow2.get("ROL_ETIQUETA_ESTRUCTURA_07") == null) continue;
                        contCat = (String)contCats.get(currRow2.get("OID_OBJETO_INDEXABLE_07"));
                        contCat = contCat != null ? contCat + "," : "";
                        contCat = contCat + "(" + (String)currRow2.get("OID_ESTRUCTURA_07") + ";" + (String)currRow2.get("OID_ETIQUETA_07") + ";" + (String)currRow2.get("ROL_ETIQUETA_ESTRUCTURA_07") + ")";
                        contCats.put(currRow2.get("OID_OBJETO_INDEXABLE_07"), contCat);
                    }
                }
                if (!(documentOids == null || documentOids.isEmpty() || pubsSelectSQL == null || pubsSelectSQL.length() <= 0 || qry.isOnlyNotPublished() || (pubs = this._dBManager.executeQuery(pubsSelectSQL = StringUtils.replaceString((String)pubsSelectSQL, (String)"$DOCUMENT_OIDs$", (String)this._stringSetToSeparatedCommaStr(documentOids)), null)) == null || pubs.isEmpty())) {
                    docPubs = new HashMap(pubs.size());
                    String docPub = null;
                    String docURL = null;
                    Map currRow3 = null;
                    for (Map currRow3 : pubs) {
                        if (currRow3.get("OID_REPOSITORY_08") == null || currRow3.get("STATE_08") == null || currRow3.get("FECHA_PUBLICATIONINFO_08") == null || currRow3.get("URL_PUBLICATIONINFO_08") == null) continue;
                        docPub = docPubs.get(currRow3.get("OID_DOCUMENT_08")) != null ? ((String[])docPubs.get(currRow3.get("OID_DOCUMENT_08")))[1] : null;
                        docPub = docPub != null ? docPub + "," : "";
                        String[] urlSplitted = ((String)currRow3.get("URL_PUBLICATIONINFO_08")).split("/");
                        String alias = urlSplitted.length >= 5 ? urlSplitted[1] : "alias_unknown";
                        String pubTimeStamp = DateUtils.reformatDateString((String)((String)currRow3.get("FECHA_PUBLICATIONINFO_08")), (String)this.getNativeDateFormat(), (String)"millis");
                        docPub = docPub + "(" + currRow3.get("OID_REPOSITORY_08") + ";" + alias + ";" + currRow3.get("STATE_08") + ";" + pubTimeStamp + ")";
                        docURL = currRow3.get("URL_PUBLICATIONINFO_08") != null ? (String)currRow3.get("URL_PUBLICATIONINFO_08") : "url_unknown";
                        docPubs.put(currRow3.get("OID_DOCUMENT_08"), new String[]{docURL, docPub});
                    }
                }
                Map currRow4 = null;
                String currContentOid = null;
                String currContentCats = null;
                String currDocumentOid = null;
                String[] currDocumentPubs = null;
                for (Map currRow4 : outSearchResultRows) {
                    currContentOid = (String)currRow4.get("OID_CONTENT_03");
                    if (currContentOid != null && contCats != null && (currContentCats = (String)contCats.get(currContentOid)) != null) {
                        currRow4.put("VIRTUAL_STRUCTURECATALOGSCATS", currContentCats);
                    }
                    if (currRow4.get("IDIOMA_DOCUMENT_04") != null && currRow4.get("NOMBRE_INTERNO_DOCUMENT_04") != null) {
                        currRow4.put("VIRTUAL_DOCUMENTCONTENTRELATIVEPATH", currRow4.get("IDIOMA_DOCUMENT_04") + "_" + currRow4.get("NOMBRE_INTERNO_DOCUMENT_04"));
                    }
                    if (currRow4.get("PATHRELATIVO_WORKAREA_04") != null && currRow4.get("IDIOMA_DOCUMENT_04") != null && currRow4.get("NOMBRE_INTERNO_DOCUMENT_04") != null) {
                        currRow4.put("VIRTUAL_DOCUMENTWORKAREARELATIVEPATH", currRow4.get("PATHRELATIVO_WORKAREA_04") + "/" + currRow4.get("IDIOMA_DOCUMENT_04") + "_" + currRow4.get("NOMBRE_INTERNO_DOCUMENT_04"));
                    }
                    if ((currDocumentOid = (String)currRow4.get("OID_DOCUMENT_04")) == null || docPubs == null || (currDocumentPubs = (String[])docPubs.get(currDocumentOid)) == null) continue;
                    currRow4.put("VIRTUAL_PUBLICATIONINFO", currDocumentPubs[1]);
                    Pattern p = Pattern.compile("/?[^/]+/[^/]+/[^/]+/[^_]+_[^/]+/(.*)");
                    Matcher m = p.matcher(currDocumentPubs[0]);
                    if (m.matches()) {
                        currRow4.put("VIRTUAL_DOCUMENTMAINDATAFILEDEFAULTGENERATEDFILEDOCUMENTRELATIVEPATH", m.group(1));
                        continue;
                    }
                    currRow4.put("VIRTUAL_DOCUMENTMAINDATAFILEDEFAULTGENERATEDFILEDOCUMENTRELATIVEPATH", currDocumentPubs[0]);
                }
            }
        }
        catch (SQLException sqlEx) {
            throw new R01MSearchPerformerException("EXECUTE Query  >>>> Error al ejecutar la query" + querySQL + sqlEx.getMessage(), (Exception)sqlEx);
        }
        return outSearchResultRows;
    }

    @Override
    public List executeQueryFromAutonomyQuery(String autonomyQuery) throws R01MSearchPerformerException {
        return null;
    }

    @Override
    public String executeComposeSearchQuery(boolean isCountQuery, String searchSessionOid, String searchSessionLang, String searchSourceOid, R01MQueryObject qry, int pageNum, Object pageFirstCod, Object pageLastCod) throws R01MSearchPerformerException {
        R01MSearchMetaDataStorageConfig metaDataStorageCfg = this.getSearchMetaDataStorageConfig(qry, searchSourceOid);
        R01KBaseSearchQueryBuilder queryBuilder = this._obtainQueryBuilder();
        String querySQL = queryBuilder.composeSearchQuery(metaDataStorageCfg, isCountQuery, qry, pageNum, pageFirstCod, pageLastCod);
        return querySQL;
    }

    private R01KBaseSearchQueryBuilder _obtainQueryBuilder() {
        R01KDBSQLBuilder queryBuilder = new R01KDBSQLBuilder();
        queryBuilder.setProperties(this.getProperties());
        queryBuilder.setNativeDateFormat(this.getNativeDateFormat());
        return queryBuilder;
    }

    private Set _extractDistinctOids(List searchResults, String metaDataName) {
        HashSet outOids = new HashSet();
        Map currResult2 = null;
        for (Map currResult2 : searchResults) {
            if (currResult2.get(metaDataName) == null) continue;
            outOids.add(currResult2.get(metaDataName));
        }
        return outOids;
    }

    private String _stringSetToSeparatedCommaStr(Set theSet) {
        StringBuffer outStr = new StringBuffer("");
        Iterator it = theSet.iterator();
        while (it.hasNext()) {
            outStr.append("'" + it.next() + "'");
            if (!it.hasNext()) continue;
            outStr.append(',');
        }
        return outStr.toString();
    }
}

