/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01k.searchorchestrator.searchperformers;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.NumberUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.config.objects.searchengine.R01MSearchSource;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MClusterStorageConfig;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MClusterStorageIndependentConfig;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MFamilyStorageConfig;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MMetaDataStorageConfig;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MSearchMetaDataStorageConfig;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MTypeStorageConfig;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MSearchPerformerException;
import com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedTypoObj;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedCluster;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedContentType;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedFamily;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MSearchMetaDataStorageConfigAPI;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public abstract class R01KBaseSearchQueryBuilder {
    static final boolean DEBUG = R01FLog.getLogLevel((String)"r01k.searchSentenceBuilder").intValue() != Level.OFF.intValue();
    static R01MSearchMetaDataStorageConfigAPI TYPOSTORAGECONFIG_API = R01MClientFactory.getSearchMetaDataStorageConfigAPI();
    static Map BASIC_SENTENCES_CACHE = new WeakHashMap(100);
    static Map PATTERNS_CACHE = new HashMap();
    static Map METADATA_OPERATION_TYPES;
    private String _nativeDateFormat;
    private Properties _props;

    public void setNativeDateFormat(String dateFormat) {
        this._nativeDateFormat = dateFormat;
    }

    public String getNativeDateFormat() {
        return this._nativeDateFormat;
    }

    public void setProperties(Properties props) {
        this._props = props;
    }

    public Properties getProperties() {
        return this._props;
    }

    public abstract String composeSearchQuery(R01MSearchMetaDataStorageConfig var1, boolean var2, R01MQueryObject var3, int var4, Object var5, Object var6) throws R01MSearchPerformerException;

    protected abstract StringBuffer executeComposeBasicQueryPart(String var1, Map var2, R01MQueryObject var3, Map var4, Map var5, Map var6, Map var7, Properties var8) throws R01MSearchPerformerException;

    protected StringBuffer[] composeSearchQueryBasicParts(R01MSearchMetaDataStorageConfig metaDataStorageCfg, R01MQueryObject qry) throws R01MSearchPerformerException {
        String queryParts;
        if (qry.getQueryOid() == null) {
            throw new R01MSearchPerformerException("No se puede ejecutar la query ya que esta debe tener un GUID!");
        }
        if (!qry.isModified() && BASIC_SENTENCES_CACHE.containsKey(qry.getQueryOid())) {
            if (DEBUG) {
                R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\tLa query b\u00e1sica de selecci\u00f3n para la query " + qry.getQueryOid() + " est\u00e1 en el cach\u00e9: NO se vuelve a calcular");
            }
            return (StringBuffer[])BASIC_SENTENCES_CACHE.get(qry.getQueryOid());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\tLa query b\u00e1sica de selecci\u00f3n para la query " + qry.getQueryOid() + " NO est\u00e1 en el cach\u00e9: Hay que calcular");
        }
        Properties patterns = this.getPatterns(metaDataStorageCfg);
        R01MClusterStorageIndependentConfig searchMetaDataClusterIndependentStorageCfg = null;
        Map searchedClusterStorageCfgs = null;
        Map searchedFamiliesStorageCfgs = null;
        Map searchedTypesStorageCfgs = null;
        Map searchedMetaDataStorageCfgs = null;
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t---(init) Obtener la configuraci\u00f3n de almacenamiento de clusters, familias y tipos:");
        }
        searchMetaDataClusterIndependentStorageCfg = metaDataStorageCfg.getClusterStorageIndependentConfig();
        searchedClusterStorageCfgs = R01KBaseSearchQueryBuilder.obtainClusterStorageConfig(metaDataStorageCfg, qry);
        searchedFamiliesStorageCfgs = R01KBaseSearchQueryBuilder.obtainFamiliesStorageConfig(metaDataStorageCfg, qry);
        searchedTypesStorageCfgs = R01KBaseSearchQueryBuilder.obtainTypesStorageConfig(metaDataStorageCfg, qry);
        searchedMetaDataStorageCfgs = R01KBaseSearchQueryBuilder.obtainMetaDataStorageConfigs(searchMetaDataClusterIndependentStorageCfg, searchedClusterStorageCfgs, searchedFamiliesStorageCfgs, searchedTypesStorageCfgs, qry.getMetaData(), qry.getORMetaData(), qry.getOrderBy());
        this.executeCheckMetaDataStorageConfigs(searchedMetaDataStorageCfgs);
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t---(init) Partes de la query");
        }
        if ((queryParts = patterns.getProperty(this.executeGetPatternsKey(metaDataStorageCfg.getId()).split("\\.")[0] + ".queryParts")) == null) {
            throw new R01MSearchPerformerException("NO se ha definido la propiedad " + this.executeGetPatternsKey(metaDataStorageCfg.getId()).split("\\.")[0] + ".queryParts en el fichero searchMetaDataStorage.xml. Revisa el fichero!");
        }
        String[] queryPartsSplitted = queryParts.split(",");
        LinkedHashMap<String, StringBuffer> preComposedQueryParts = new LinkedHashMap<String, StringBuffer>(queryPartsSplitted.length);
        for (int i = 0; i < queryPartsSplitted.length; ++i) {
            StringBuffer queryPart = this.executeComposeBasicQueryPart(queryPartsSplitted[i], preComposedQueryParts, qry, searchedClusterStorageCfgs, searchedFamiliesStorageCfgs, searchedTypesStorageCfgs, searchedMetaDataStorageCfgs, patterns);
            preComposedQueryParts.put(queryPartsSplitted[i], queryPart);
        }
        if (preComposedQueryParts.get("orderBy") == null) {
            StringBuffer queryPart = (StringBuffer)preComposedQueryParts.get("basicQuery");
            Pattern pattern = Pattern.compile("(.*fieldText=[^;&]+)(.*)");
            Matcher matcher = pattern.matcher(queryPart);
            if (matcher.find()) {
                StringBuffer newSB = new StringBuffer();
                newSB.append(matcher.group(1)).append("+AND+").append(patterns.getProperty("autonomy.defaultBoostRelevance", "BIAS{$CURRENT_DATE$,184375800,25}:SCOREDATE+AND+BIAS{100,100,10}:*/BOOSTINGVALUE")).append(matcher.group(2));
                queryPart = newSB;
            } else {
                queryPart.append("&fieldText=").append(patterns.getProperty("autonomy.defaultBoostRelevance", "BIAS{$CURRENT_DATE$,184375800,25}:SCOREDATE+AND+BIAS{100,100,10}:*/BOOSTINGVALUE"));
            }
            preComposedQueryParts.put("basicQuery", new StringBuffer(StringUtils.replaceString((String)queryPart.toString(), (String)"$CURRENT_DATE$", (String)DateUtils.getDateFormated((Date)new Date(), (String)"seconds"))));
        }
        StringBuffer[] outSentences = preComposedQueryParts.values().toArray(new StringBuffer[preComposedQueryParts.values().size()]);
        BASIC_SENTENCES_CACHE.put(qry.getQueryOid(), outSentences);
        return outSentences;
    }

    protected String extractDateFromQuery(String dateFromQuery) {
        if (dateFromQuery == null) {
            return null;
        }
        String outDate = new String(dateFromQuery);
        String queryDateFormat = DateUtils.getLanguageDateFormat(null, (Properties)R01MSearchEngineConstants.QUERY_DATE_FORMATS);
        if (queryDateFormat != null) {
            outDate = DateUtils.reformatDateString((String)outDate, (String)queryDateFormat, (String)this.getNativeDateFormat());
        }
        return outDate;
    }

    protected String[] transformMetaDataOperatorAndValue(String metaDataType, String metaDataOperator, String metaDataValue) {
        StringBuffer outMetaDataValue = new StringBuffer(metaDataValue);
        String outMetaDataOperator = new String(metaDataOperator);
        if (metaDataOperator.equalsIgnoreCase("LAST") || metaDataOperator.equalsIgnoreCase("NEXT")) {
            if (!metaDataType.equalsIgnoreCase("Date") || !NumberUtils.isInteger((String)metaDataValue)) {
                R01FLog.to((String)"r01k.searchSentenceBuilder").warning("R01KBaseSearchQueryBuilder: El tipo del metadato para construir la condici\u00f3n de tipo LAST NO es DATE o bien el valor pasado NO es un n\u00famero entero: NO se a\u00f1ade la condici\u00f3n del metadato");
                return null;
            }
            int numberOfDays = Integer.parseInt(metaDataValue);
            if (metaDataOperator.equalsIgnoreCase("LAST")) {
                numberOfDays = -numberOfDays;
            }
            Calendar calToday = Calendar.getInstance();
            Calendar calOtherDay = Calendar.getInstance();
            calOtherDay.add(5, numberOfDays);
            String queryDateFormat = DateUtils.getLanguageDateFormat(null, (Properties)R01MSearchEngineConstants.QUERY_DATE_FORMATS);
            if (queryDateFormat != null) {
                String todayFormatted = DateUtils.getDateFormated((Date)calToday.getTime(), (String)queryDateFormat);
                String otherDayFormatted = DateUtils.getDateFormated((Date)calOtherDay.getTime(), (String)queryDateFormat);
                outMetaDataValue.setLength(0);
                if (metaDataOperator.equalsIgnoreCase("LAST")) {
                    outMetaDataValue.append(otherDayFormatted);
                    outMetaDataValue.append(",");
                    outMetaDataValue.append(todayFormatted);
                } else if (metaDataOperator.equalsIgnoreCase("NEXT")) {
                    outMetaDataValue.append(todayFormatted);
                    outMetaDataValue.append(",");
                    outMetaDataValue.append(otherDayFormatted);
                }
            }
            outMetaDataOperator = "BETWEEN";
        } else if (metaDataOperator.equalsIgnoreCase("IN")) {
            Pattern p1 = Pattern.compile("\\(([^)]+)\\)");
            Matcher m1 = p1.matcher(metaDataValue);
            if (m1.matches()) {
                String commaSeparatedValues = m1.group(1);
                String[] values = commaSeparatedValues.split(",");
                outMetaDataValue.setLength(0);
                outMetaDataValue.append('(');
                for (int i = 0; i < values.length; ++i) {
                    Pattern p2 = Pattern.compile("(?:\"|')?\\s*([^\"']*)\\s*(?:\"|')?");
                    Matcher m2 = p2.matcher(values[i]);
                    if (m2.matches()) {
                        outMetaDataValue.append(m2.group(1));
                    }
                    if (i >= values.length - 1) continue;
                    outMetaDataValue.append(',');
                }
                outMetaDataValue.append(')');
            } else {
                R01FLog.to((String)"r01k.searchSentenceBuilder").warning("R01KBaseSearchQueryBuilder: La condici\u00f3n de tipo IN no tiene el formato correcto (val,val,..): NO se a\u00f1ade la condici\u00f3n del metadato");
                return null;
            }
        }
        return new String[]{outMetaDataOperator, outMetaDataValue.toString()};
    }

    protected Properties getPatterns(R01MSearchMetaDataStorageConfig metaDataStorageCfg) throws R01MSearchPerformerException {
        String patternsKey = this.executeGetPatternsKey(metaDataStorageCfg.getId());
        Properties patterns = null;
        if (PATTERNS_CACHE != null && PATTERNS_CACHE.get(patternsKey) != null) {
            patterns = (Properties)PATTERNS_CACHE.get(patternsKey);
        } else {
            Map props = metaDataStorageCfg.getProperties();
            patterns = this.executeObtainQueryBuilderPatterns(props);
            if (PATTERNS_CACHE == null) {
                PATTERNS_CACHE = new HashMap();
            }
            PATTERNS_CACHE.put(patternsKey, patterns);
        }
        return patterns;
    }

    protected String getPattern(R01MSearchMetaDataStorageConfig metaDataStorageCfg, String patternKey) throws R01MSearchPerformerException {
        Properties patterns = this.getPatterns(metaDataStorageCfg);
        return patterns != null ? patterns.getProperty(patternKey) : null;
    }

    protected abstract String executeGetPatternsKey(String var1);

    protected abstract Properties executeObtainQueryBuilderPatterns(Map<String, String> var1) throws R01MSearchPerformerException;

    protected abstract void executeCheckMetaDataStorageConfigs(Map var1) throws R01MSearchPerformerException;

    static Map obtainClusterStorageConfig(R01MSearchMetaDataStorageConfig metaDataStorageCfg, R01MQueryObject qry) throws R01MSearchPerformerException {
        List searchedClusters = qry != null ? qry.getContentClusters() : null;
        HashMap<String, R01MClusterStorageConfig> outClustersStorageCfg = new HashMap<String, R01MClusterStorageConfig>(qry.getContentClusters().size());
        R01MSearchedCluster currSearchedCluster2 = null;
        R01MClusterStorageConfig currClusterStorageCfg = null;
        for (R01MSearchedCluster currSearchedCluster2 : searchedClusters) {
            currClusterStorageCfg = metaDataStorageCfg.getClusterStorageConfigs(currSearchedCluster2.getOid());
            if (currClusterStorageCfg != null) {
                outClustersStorageCfg.put(currSearchedCluster2.getOid(), currClusterStorageCfg);
                if (!DEBUG) continue;
                R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t-cluster: " + currSearchedCluster2.getOid());
                continue;
            }
            throw new R01MSearchPerformerException("NO existe configuraci\u00f3n de almacenamiento para el cluster " + currSearchedCluster2.getOid() + ". Revisa el fichero searchMetaDataStorage.xml");
        }
        return outClustersStorageCfg;
    }

    static Map obtainFamiliesStorageConfig(R01MSearchMetaDataStorageConfig metaDataStorageCfg, R01MQueryObject qry) throws R01MSearchPerformerException {
        List searchedFamilies;
        List list = searchedFamilies = qry != null ? qry.getContentFamilies() : null;
        if (searchedFamilies == null || searchedFamilies.isEmpty()) {
            return null;
        }
        HashMap<String, R01MFamilyStorageConfig> outFamiliesStorageCfgs = new HashMap<String, R01MFamilyStorageConfig>(qry.getContentFamilies().size());
        R01MFamilyStorageConfig currFamilyStorageCfg = null;
        for (R01MSearchedFamily currSearchedFamily : searchedFamilies) {
            currFamilyStorageCfg = metaDataStorageCfg.getFamilyStorageConfig(currSearchedFamily.getOid());
            if (currFamilyStorageCfg != null) {
                outFamiliesStorageCfgs.put(currSearchedFamily.getOid(), currFamilyStorageCfg);
                if (!DEBUG) continue;
                R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t-family: " + currSearchedFamily.getOid());
                continue;
            }
            throw new R01MSearchPerformerException("NO existe configuraci\u00f3n de almacenamiento para la familia " + currSearchedFamily.getOid() + ". Revisa el fichero searchMetaDataStorage.xml");
        }
        return outFamiliesStorageCfgs;
    }

    static Map obtainTypesStorageConfig(R01MSearchMetaDataStorageConfig metaDataStorageCfg, R01MQueryObject qry) throws R01MSearchPerformerException {
        List searchedTypes;
        List list = searchedTypes = qry != null ? qry.getContentTypes() : null;
        if (searchedTypes == null || searchedTypes.isEmpty()) {
            return null;
        }
        HashMap<String, R01MTypeStorageConfig> outTypesStorageCfgs = new HashMap<String, R01MTypeStorageConfig>(qry.getContentTypes().size());
        R01MTypeStorageConfig currTypeStorageCfg = null;
        for (R01MSearchedContentType currSearchedType : searchedTypes) {
            currTypeStorageCfg = metaDataStorageCfg.getTypeStorageConfig(currSearchedType.getOid());
            if (currTypeStorageCfg != null) {
                outTypesStorageCfgs.put(currSearchedType.getOid(), currTypeStorageCfg);
                if (!DEBUG) continue;
                R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t-type: " + currSearchedType.getOid());
                continue;
            }
            throw new R01MSearchPerformerException("NO existe configuraci\u00f3n de almacenamiento para el tipo " + currSearchedType.getOid() + ". Revisa el fichero searchMetaDataStorage.xml");
        }
        return outTypesStorageCfgs;
    }

    static Map obtainMetaDataStorageConfigs(R01MClusterStorageIndependentConfig clusterIndependentStorageCfg, Map clusterStorageCfgs, Map familiesStorageCfgs, Map typesStorageCfgs, List andSearchedMetaData, List orSearchedMetaData, List orderByMetaData) throws R01MSearchPerformerException {
        if (!(andSearchedMetaData != null && !andSearchedMetaData.isEmpty() || orSearchedMetaData != null && !orSearchedMetaData.isEmpty() || orderByMetaData != null && !orderByMetaData.isEmpty())) {
            return null;
        }
        int metaDataCount = (andSearchedMetaData != null ? andSearchedMetaData.size() : 0) + (orSearchedMetaData != null ? orSearchedMetaData.size() : 0) + (orderByMetaData != null ? orderByMetaData.size() : 0);
        ArrayList metaData = new ArrayList(metaDataCount);
        if (andSearchedMetaData != null && !andSearchedMetaData.isEmpty()) {
            metaData.addAll(andSearchedMetaData);
        }
        if (orSearchedMetaData != null && !orSearchedMetaData.isEmpty()) {
            metaData.addAll(orSearchedMetaData);
        }
        if (orderByMetaData != null && !orderByMetaData.isEmpty()) {
            metaData.addAll(orderByMetaData);
        }
        HashMap<String, R01MMetaDataStorageConfig> outMetaDataStorageCfgs = new HashMap<String, R01MMetaDataStorageConfig>(metaDataCount);
        R01MBaseSearchedTypoObj currSearchedMetaData2 = null;
        R01MMetaDataStorageConfig currMetaDataStorageCfg = null;
        StringBuffer propsDebugInfo = new StringBuffer();
        for (R01MBaseSearchedTypoObj currSearchedMetaData2 : metaData) {
            if (currSearchedMetaData2.oid.equals("fullText")) {
                if (clusterIndependentStorageCfg != null && clusterIndependentStorageCfg.getMetaDataStorageConfig("contentName") != null) {
                    outMetaDataStorageCfgs.put("contentName", clusterIndependentStorageCfg.getMetaDataStorageConfig("contentName"));
                }
                if (clusterIndependentStorageCfg != null && clusterIndependentStorageCfg.getMetaDataStorageConfig("documentName") != null) {
                    outMetaDataStorageCfgs.put("documentName", clusterIndependentStorageCfg.getMetaDataStorageConfig("documentName"));
                }
                if (clusterIndependentStorageCfg == null || clusterIndependentStorageCfg.getMetaDataStorageConfig("documentDescription") == null) continue;
                outMetaDataStorageCfgs.put("documentDescription", clusterIndependentStorageCfg.getMetaDataStorageConfig("documentDescription"));
                continue;
            }
            currMetaDataStorageCfg = R01KBaseSearchQueryBuilder.loadMetaDataStorageConfigs(clusterIndependentStorageCfg, clusterStorageCfgs, familiesStorageCfgs, typesStorageCfgs, andSearchedMetaData, orSearchedMetaData, orderByMetaData, currSearchedMetaData2);
            if (currMetaDataStorageCfg == null) {
                try {
                    Map sources = R01MClientFactory.getSearchEngineConfigAPI().getSearchEngineConfig().getSearchSources();
                    for (R01MSearchSource searchSource : sources.values()) {
                        Map reloadedTypesStorageCfgs;
                        Map reloadedFamiliesStorageCfgs;
                        Map reloadedClusterStorageCfgs;
                        if (searchSource.getSearchMetaDataStorageConfigLocation() == null || searchSource.getSearchMetaDataStorageConfigLocation().getServerOid() == null || searchSource.getSearchMetaDataStorageConfigLocation().getDataStoreOid() == null) continue;
                        R01MSearchMetaDataStorageConfig searchMetaDataStorageCfg = null;
                        searchMetaDataStorageCfg = R01MClientFactory.getSearchMetaDataStorageConfigAPI().getSearchMetaDataStorageConfig(searchSource.getSearchMetaDataStorageConfigLocation().getServerOid(), searchSource.getSearchMetaDataStorageConfigLocation().getDataStoreOid());
                        R01MClusterStorageIndependentConfig reloadedClusterIndependentStorageCfg = searchMetaDataStorageCfg.getClusterStorageIndependentConfig();
                        currMetaDataStorageCfg = R01KBaseSearchQueryBuilder.loadMetaDataStorageConfigs(reloadedClusterIndependentStorageCfg, reloadedClusterStorageCfgs = searchMetaDataStorageCfg.getAllClusterStorageConfig(), reloadedFamiliesStorageCfgs = searchMetaDataStorageCfg.getAllFamiliesStorageConfigIgnoringCluster(), reloadedTypesStorageCfgs = searchMetaDataStorageCfg.getAllTypesStorageConfigIgnoringFamilyAndCluster(), andSearchedMetaData, orSearchedMetaData, orderByMetaData, currSearchedMetaData2);
                        if (currMetaDataStorageCfg == null) continue;
                        break;
                    }
                }
                catch (R01MConfigLoadException cfgLoadEx) {
                    throw new R01MSearchPerformerException((Exception)((Object)cfgLoadEx));
                }
            }
            if (currMetaDataStorageCfg == null) {
                R01FLog.to((String)"r01k.searchSentenceBuilder").warning("NO se ha podido encontrar la configuraci\u00f3n de almacenamiento del metaDato " + currSearchedMetaData2.getOid() + " ni en la configuraci\u00f3n de metaDatos independientes del cluster, ni en la configuraci\u00f3n de metaDatos del cluster buscado, ni en la de ninguna de las familias buscadas, ni en la de ninguno de los tipos buscados. Revisa la seccion <clusterStorageIndependent> para los metaDatos independientes del cluster y la seccion <clustersStorage> para el cluster buscado en el fichero searchMetaDataStorageConfig.xml");
                if (andSearchedMetaData.contains(currSearchedMetaData2)) {
                    andSearchedMetaData.remove(currSearchedMetaData2);
                }
                if (orSearchedMetaData.contains(currSearchedMetaData2)) {
                    orSearchedMetaData.remove(currSearchedMetaData2);
                }
                if (!orderByMetaData.contains(currSearchedMetaData2)) continue;
                orderByMetaData.remove(currSearchedMetaData2);
                continue;
            }
            if (currMetaDataStorageCfg.getProperties() == null) {
                throw new R01MSearchPerformerException("El metaDato " + currMetaDataStorageCfg.getOid() + " est\u00e1 mal definido en el fichero searchMetaDataStorage.xml: NO se han definido propiedades");
            }
            outMetaDataStorageCfgs.put(currSearchedMetaData2.getOid(), currMetaDataStorageCfg);
            if (!DEBUG) continue;
            propsDebugInfo.setLength(0);
            Map.Entry prme2 = null;
            for (Map.Entry prme2 : currMetaDataStorageCfg.getProperties().entrySet()) {
                propsDebugInfo.append("\t\t\t" + prme2.getKey() + ": " + prme2.getValue() + "\r\n");
            }
            R01FLog.to((String)"r01k.searchSentenceBuilder").info(propsDebugInfo.toString());
        }
        return outMetaDataStorageCfgs;
    }

    static R01MMetaDataStorageConfig loadMetaDataStorageConfigs(R01MClusterStorageIndependentConfig clusterIndependentStorageCfg, Map clusterStorageCfgs, Map familiesStorageCfgs, Map typesStorageCfgs, List andSearchedMetaData, List orSearchedMetaData, List orderByMetaData, R01MBaseSearchedTypoObj currSearchedMetaData) throws R01MSearchPerformerException {
        R01MMetaDataStorageConfig currMetaDataStorageCfg;
        block6: {
            currMetaDataStorageCfg = null;
            if (clusterIndependentStorageCfg != null && clusterIndependentStorageCfg.getMetaDataStorageConfigs() != null) {
                currMetaDataStorageCfg = clusterIndependentStorageCfg.getMetaDataStorageConfig(currSearchedMetaData.getOid());
            }
            R01MClusterStorageConfig clusterStorageCfg = null;
            if (currMetaDataStorageCfg == null && clusterStorageCfgs != null) {
                Iterator cIt = clusterStorageCfgs.values().iterator();
                while (cIt.hasNext() && (currMetaDataStorageCfg = (clusterStorageCfg = (R01MClusterStorageConfig)cIt.next()).getMetaDataStorageConfig(currSearchedMetaData.getOid())) == null) {
                }
            }
            R01MFamilyStorageConfig familyStorageCfg = null;
            if (currMetaDataStorageCfg == null && familiesStorageCfgs != null) {
                Iterator fIt = familiesStorageCfgs.values().iterator();
                while (fIt.hasNext() && (currMetaDataStorageCfg = (familyStorageCfg = (R01MFamilyStorageConfig)fIt.next()).getMetaDataStorageConfig(currSearchedMetaData.getOid())) == null) {
                }
            }
            R01MTypeStorageConfig typeStorageCfg = null;
            if (currMetaDataStorageCfg != null || typesStorageCfgs == null) break block6;
            Iterator tIt = typesStorageCfgs.values().iterator();
            while (tIt.hasNext() && (currMetaDataStorageCfg = (typeStorageCfg = (R01MTypeStorageConfig)tIt.next()).getMetaDataStorageConfig(currSearchedMetaData.getOid())) == null) {
            }
        }
        return currMetaDataStorageCfg;
    }

    static {
        NodeIterator dni = XMLProperties.getPropertyNodeIterator((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"metadataOperators/operator");
        METADATA_OPERATION_TYPES = new HashMap();
        if (dni != null) {
            Node currDNINode = dni.nextNode();
            while (currDNINode != null) {
                METADATA_OPERATION_TYPES.put(currDNINode.getAttributes().getNamedItem("oid").getNodeValue(), currDNINode.getFirstChild().getNodeValue());
                currDNINode = dni.nextNode();
            }
        }
    }
}

