/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01k.searchorchestrator.searchperformers;

import com.ejie.r01f.clone.CloneUtils;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.NumberUtils;
import com.ejie.r01f.util.Pager;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01k.searchorchestrator.searchperformers.R01KInitQueryResult;
import com.ejie.r01k.searchorchestrator.searchperformers.R01KSearchEngineReturnedDataToResultItemTransformer;
import com.ejie.r01k.searchorchestrator.searchperformers.R01KSearchPerformer;
import com.ejie.r01m.config.objects.searchengine.R01MSearchSource;
import com.ejie.r01m.config.objects.searchengine.R01MSearchSourcePerformer;
import com.ejie.r01m.config.objects.searchengine.guide.R01MSearchGuideDefBranch;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MSearchMetaDataStorageConfig;
import com.ejie.r01m.config.objects.typology.R01MContentCluster;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MSearchPerformerException;
import com.ejie.r01m.exceptions.R01MSearchStorageException;
import com.ejie.r01m.objects.cataloguing.structures.R01MLabel;
import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuideElement;
import com.ejie.r01m.objects.searchengine.metadataprocessors.R01MMetaDataProcessor;
import com.ejie.r01m.objects.searchengine.metadataprocessors.R01MMetaDataProcessorImpl;
import com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedTypoObj;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedDataRepository;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedPublishRepository;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedServer;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedStructureCatalog;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItemPublicationInfo;
import com.ejie.r01m.objects.searchengine.results.R01MSearchSourceInitResult;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.cachedmanagers.R01MCachedCatalogLabelsManager;
import com.ejie.r01m.utils.searchengine.R01MFullTextQueryUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public abstract class R01KBaseContentSearchPerformer
implements R01KSearchPerformer {
    private static boolean DEBUG = R01FLog.getLogLevel((String)"r01k.searchPerformer").intValue() != Level.OFF.intValue();
    private static R01MMetaDataProcessor _metaDataProcessor = new R01MMetaDataProcessorImpl();
    private String _searchPerformerId;
    private String _searchSourceOid;
    private String _nativeDateFormat;
    private Properties _props;
    private R01MSearchMetaDataStorageConfig _cachedSearchMetaDataStorageConfig = null;

    public abstract R01KInitQueryResult executeCountQuery(boolean var1, boolean var2, String var3, String var4, String var5, R01MQueryObject var6) throws R01MSearchPerformerException;

    public abstract List executeQuery(String var1, String var2, String var3, R01MQueryObject var4, int var5, Object var6, Object var7) throws R01MSearchPerformerException;

    public abstract List executeQueryFromAutonomyQuery(String var1) throws R01MSearchPerformerException;

    public abstract String executeComposeSearchQuery(boolean var1, String var2, String var3, String var4, R01MQueryObject var5, int var6, Object var7, Object var8) throws R01MSearchPerformerException;

    protected abstract R01KSearchEngineReturnedDataToResultItemTransformer getSearchEngineReturnedDataToResultItemTransformer(R01MSearchMetaDataStorageConfig var1);

    @Override
    public String getSearchPerformerId() {
        return this._searchPerformerId;
    }

    @Override
    public void setSearchPerformerId(String theSearchPerformerId) {
        this._searchPerformerId = theSearchPerformerId;
    }

    @Override
    public String getSearchSourceOid() {
        return this._searchSourceOid;
    }

    @Override
    public void setSearchSourceOid(String theSearchSourceOid) {
        this._searchSourceOid = theSearchSourceOid;
    }

    @Override
    public void setNativeDateFormat(String theDateFormat) {
        this._nativeDateFormat = theDateFormat;
    }

    @Override
    public String getNativeDateFormat() {
        return this._nativeDateFormat;
    }

    @Override
    public void setProperties(Properties props) {
        this._props = props;
    }

    @Override
    public Properties getProperties() {
        return this._props;
    }

    @Override
    public String getProperty(String propKey) {
        return this._props != null ? this._props.getProperty(propKey) : null;
    }

    @Override
    public R01MSearchMetaDataStorageConfig getSearchMetaDataStorageConfig(R01MQueryObject qry, String searchSourceOid) throws R01MSearchPerformerException {
        R01MSearchSource source;
        if (this._cachedSearchMetaDataStorageConfig != null) {
            return this._cachedSearchMetaDataStorageConfig;
        }
        try {
            source = R01MClientFactory.getSearchEngineConfigAPI().getSearchEngineConfig().getSearchSourceCfg(qry.getContext(), searchSourceOid);
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            throw new R01MSearchPerformerException((Exception)((Object)cfgLoadEx));
        }
        String[] serverAndDataStore = null;
        if (source == null) {
            if (qry.getServers() == null || qry.getServers().isEmpty() || qry.getServers().size() > 1 || qry.getDataRepositories() == null || qry.getDataRepositories().isEmpty() || qry.getDataRepositories().size() > 1) {
                throw new R01MSearchPerformerException("_obtainServerAndDataStore: Si no se configura el origen " + searchSourceOid + " para el contexto " + qry.getContext() + " en el fichero r01kSearchEngineConfig.xml, entonces, es necesario suministrar un servidor y un dataStore (de momento s\u00f3lamente uno)");
            }
            R01MSearchedServer searchedServers = (R01MSearchedServer)qry.getServers().get(0);
            R01MSearchedDataRepository searchedDataRepositories = (R01MSearchedDataRepository)qry.getDataRepositories().get(0);
            serverAndDataStore = new String[]{searchedServers.serverOid, searchedDataRepositories.dataRepositoryOid};
        } else if (source.getSearchMetaDataStorageConfigLocation() != null && source.getSearchMetaDataStorageConfigLocation().getServerOid() != null && source.getSearchMetaDataStorageConfigLocation().getDataStoreOid() != null) {
            serverAndDataStore = new String[]{source.getSearchMetaDataStorageConfigLocation().getServerOid(), source.getSearchMetaDataStorageConfigLocation().getDataStoreOid()};
        } else {
            throw new R01MSearchPerformerException("_obtainServerAndDataStore: ERROR en la configuracion del fichero r01kSearchEngineConfig.xml: NO se ha definido el server y dataStore donde se encuentra la configuraci\u00f3n de almacenamiento de metaDatos para el origen " + searchSourceOid + " en e contexto " + qry.getContext());
        }
        R01MSearchMetaDataStorageConfig searchMetaDataStorageCfg = null;
        try {
            searchMetaDataStorageCfg = R01MClientFactory.getSearchMetaDataStorageConfigAPI().getSearchMetaDataStorageConfig(serverAndDataStore[0], serverAndDataStore[1]);
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            throw new R01MSearchPerformerException("Error al cargar la configuraci\u00f3n de almacenamiento de metadatos para el servidor:dataStore " + serverAndDataStore[0] + ":" + serverAndDataStore[1] + ">> " + cfgLoadEx.getDetailedMessage(), (Exception)((Object)cfgLoadEx));
        }
        return searchMetaDataStorageCfg;
    }

    @Override
    public R01MSearchSourceInitResult init(String searchSessionOid, String searchSessionLang, String searchSourceOid, R01MQueryObject query, R01MSearchGuideElement[] guideFutureElements, boolean lazy) throws R01MSearchPerformerException {
        String fullText;
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchPerformer").info("\r\n\r\n\r\n\r\n[R01KBaseContentSearchPerformer](init) queryOID=" + query.getQueryOid() + "\r\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        }
        if (query.isFullTextSearch() && ((fullText = query.getFullText()) == null || StringUtils.isEmptyString((String)fullText)) && (query.getSearchedMetaData() == null || query.getSearchedMetaData().isEmpty()) && (query.getOrSearchedMetaData() == null || query.getOrSearchedMetaData().isEmpty())) {
            R01FLog.to((String)"r01k.searchPerformer").warning("NO se ha pasado un criterio de b\u00fasqueda para el texto libre.\r\nSe trata de una b\u00fasqueda de texto libre (el objeto query tiene el atributo fullTextSearch=true).\r\nSi se est\u00e1 utilizando el jsp tag, verifica que fullTextSearch tiene el valor correcto (true si es una b\u00fasqueda de texto libre)");
            return null;
        }
        this._cachedSearchMetaDataStorageConfig = this.getSearchMetaDataStorageConfig(query, searchSourceOid);
        R01MQueryObject efQry = this._composeEffectiveQuery(searchSourceOid, query);
        R01KInitQueryResult initQueryResult = null;
        long countStartTime = System.currentTimeMillis();
        long countEndTime = 0L;
        R01MSearchSourceInitResult outResult = null;
        Pager pager = new Pager(Integer.parseInt(efQry.getPresentationProperty("r01PageSize")), Integer.parseInt(efQry.getPresentationProperty("r01NavBarBlockSize")));
        if (!efQry.allResultsInAPage) {
            if (DEBUG) {
                R01FLog.to((String)"r01k.searchPerformer").info("--->Execute count query.....");
            }
            initQueryResult = this.executeCountQuery(lazy, false, searchSessionOid, searchSessionLang, searchSourceOid, efQry);
            countEndTime = System.currentTimeMillis();
            if (initQueryResult.getTotalResultsCount() == 0) {
                return outResult;
            }
            for (int i = 0; i < initQueryResult.getTotalResultsCount(); ++i) {
                pager.addPageElement((Object)Integer.toString(i));
            }
        }
        R01MSearchResultItem[] firstPageItems = null;
        if (initQueryResult != null) {
            if (initQueryResult.getFirstPageResults() != null && initQueryResult.getFirstPageResults().size() > 0) {
                List outResultItems = this._composeResults(efQry, initQueryResult.getFirstPageResults());
                firstPageItems = outResultItems.toArray(new R01MSearchResultItem[outResultItems.size()]);
            } else if (!lazy) {
                if (DEBUG) {
                    R01FLog.to((String)"r01k.searchPerformer").info("NOTA: NO se han devuelto resultados en la query de cuenta o bien se ha indicado una inicializacion NO lazy: obtener los resultados de la primera p\u00e1gina...");
                }
                firstPageItems = this.search(searchSessionOid, searchSessionLang, searchSourceOid, efQry, 1, pager.getCurrentPageFirstElement(), pager.getCurrentPageLastElement());
            }
            long firstPageQueryTime = System.currentTimeMillis();
            if (DEBUG) {
                R01FLog.to((String)"r01k.searchPerformer").info("\r\n\r\n\r\n[R01KBaseContentSearchPerformer](end) queryOID=" + efQry.getQueryOid() + "\r\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\r\n" + "\t-Count          :" + (countEndTime - countStartTime) + " msg\r\n" + "\t-FiresPageQuery :" + (firstPageQueryTime - countEndTime) + " msg\r\n" + "\t\t--> N\u00famero total de resultados: " + initQueryResult.getTotalResultsCount() + "\r\n\t\t-->Resultados de la primera p\u00e1gina: " + (initQueryResult.getFirstPageResults() == null ? "0" : Integer.toString(initQueryResult.getFirstPageResults().size())) + "\r\n\r\n\r\n");
            }
        } else {
            firstPageItems = this.search(searchSessionOid, searchSessionLang, searchSourceOid, efQry, 1, null, null);
            if (firstPageItems != null) {
                for (int i = 0; i < firstPageItems.length; ++i) {
                    pager.addPageElement((Object)Integer.toString(i));
                }
            }
        }
        R01MSearchGuideElement[] futureGuideEls = guideFutureElements;
        if (firstPageItems != null && firstPageItems.length > 0 && guideFutureElements != null && guideFutureElements.length > 0) {
            long guideStartTime = System.currentTimeMillis();
            futureGuideEls = this.executeComputeFutureGuideElementsCount(searchSessionOid, searchSessionLang, searchSourceOid, efQry, guideFutureElements);
            if (DEBUG && futureGuideEls != null) {
                StringBuffer guideDebugInfo = new StringBuffer(63);
                guideDebugInfo.append("[[R01KBaseContentSearchPerformer](guideCount)]");
                for (int i = 0; i < futureGuideEls.length; ++i) {
                    if (futureGuideEls[i] == null) continue;
                    guideDebugInfo.append("\r\n\t- " + futureGuideEls[i].getComputeTime() + " msg\t" + ">" + futureGuideEls[i].getNumberOfResults() + "\t" + futureGuideEls[i].getPathInGuide());
                }
                R01FLog.to((String)"r01k.searchPerformer").info(guideDebugInfo.toString());
            }
            long guideEndTime = System.currentTimeMillis();
            if (DEBUG) {
                R01FLog.to((String)"r01k.searchPerformer").info("[R01KBaseContentSearchPerformer](guideCount) " + (guideEndTime - guideStartTime) + " msg -> queryOID=" + efQry.getQueryOid() + "\r\n\r\n\r\n");
            }
        }
        outResult = new R01MSearchSourceInitResult(searchSourceOid, pager, futureGuideEls, firstPageItems);
        return outResult;
    }

    protected R01MSearchGuideElement[] executeComputeFutureGuideElementsCount(String searchSessionOid, String searchSessionLang, String searchSourceOid, R01MQueryObject query, R01MSearchGuideElement[] guideFutureElements) {
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchPerformer").info("\r\n\r\n\r\n\r\n[R01KBaseContentSearchPerformer](guideFutureElements.init) queryOID=" + query.getQueryOid() + "\r\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        }
        R01MSearchGuideElement[] outGuideFutureElements = guideFutureElements;
        String originalQueryOid = new String(query.getQueryOid());
        try {
            R01MSearchGuideDefBranch guideBranchDef = null;
            guideBranchDef = R01MClientFactory.getSearchEnginePersistenceAPI().getGuideBranchDef(guideFutureElements[0].getBranchDefPath());
            if (guideBranchDef == null) {
                R01FLog.to((String)"r01k.searchPerformer").severe("R01KBaseContentSearchPerformer.init: La guia est\u00e1 mal formada ya que el elemento NO tiene la definici\u00f3n del branch al que pertenece. Se ignora la guia!!");
            } else {
                outGuideFutureElements = new R01MSearchGuideElement[guideFutureElements.length];
                for (int i = 0; i < guideFutureElements.length; ++i) {
                    if (guideFutureElements[i].getNumberOfResults() < 0) {
                        if (DEBUG) {
                            R01FLog.to((String)"r01k.searchPerformer").info("NO se hab\u00eda calculado el n\u00famero total de resultados para el elemento futuro de la gu\u00eda " + guideFutureElements[i].getPathInGuide());
                        }
                        String elementPath = guideBranchDef.getStartingPath() + "/" + guideFutureElements[i].getElementPathInBranch();
                        String[] elementPathSplitted = elementPath.split("/");
                        if (DEBUG) {
                            R01FLog.to((String)"r01k.searchPerformer").info("...condici\u00f3n de la guia en el branch tipo: " + guideBranchDef.getBranchType() + " > path en el branch: " + elementPath);
                        }
                        query.setQueryOid(originalQueryOid + "." + guideFutureElements[i].getPathInGuide());
                        long guideNodeCountStartTime = System.currentTimeMillis();
                        if (guideBranchDef.getBranchType().equals("typo")) {
                            List originalClusters = query.getContentClusters();
                            List originalFamilies = query.getContentFamilies();
                            List originalTypes = query.getContentTypes();
                            switch (elementPathSplitted.length - 1) {
                                case 0: {
                                    query.setContentFamilies(null);
                                    query.setContentTypes(null);
                                    query.setContentClusters(null);
                                    query.addContentCluster(elementPathSplitted[0]);
                                    break;
                                }
                                case 1: {
                                    query.setContentTypes(null);
                                    query.setContentFamilies(null);
                                    query.addContentFamily(elementPathSplitted[1]);
                                    break;
                                }
                                case 2: {
                                    query.setContentTypes(null);
                                    query.addContentType(elementPathSplitted[2]);
                                    break;
                                }
                                default: {
                                    throw new R01MSearchPerformerException("Error en el path de una guia tipol\u00f3gica: " + elementPath + "> Tiene mas elementos que la profundidad de la guia cluster/familia/tipo");
                                }
                            }
                            this._obtainNumericIds(query);
                            outGuideFutureElements[i] = new R01MSearchGuideElement(guideFutureElements[i]);
                            outGuideFutureElements[i].setNumberOfResults(this.executeCountQuery(true, true, searchSessionOid, searchSessionLang, searchSourceOid, query).getTotalResultsCount());
                            query.setContentClusters(originalClusters);
                            query.setContentFamilies(originalFamilies);
                            query.setContentTypes(originalTypes);
                            if (DEBUG) {
                                String[] descs = new String[]{"cluster", "familia", "tipo"};
                                R01FLog.to((String)"r01k.searchPerformer").info("...condici\u00f3n de guia sobre " + descs[elementPathSplitted.length - 1] + ": " + elementPathSplitted[elementPathSplitted.length - 1]);
                            }
                        } else if (guideBranchDef.getBranchType().equals("structure")) {
                            if (DEBUG) {
                                R01FLog.to((String)"r01k.searchPerformer").info("...condici\u00f3n de guia sobre etiqueta de catalogaci\u00f3n: " + elementPathSplitted[elementPathSplitted.length - 1] + " del eje " + guideBranchDef.getStartingPath());
                            }
                            query.addANDStructureCatalog(elementPathSplitted[elementPathSplitted.length - 1]);
                            this._obtainNumericIds(query);
                            outGuideFutureElements[i] = new R01MSearchGuideElement(guideFutureElements[i]);
                            outGuideFutureElements[i].setNumberOfResults(this.executeCountQuery(true, true, searchSessionOid, searchSessionLang, searchSourceOid, query).getTotalResultsCount());
                            query.removeANDStructrueCatalog(elementPathSplitted[elementPathSplitted.length - 1]);
                        } else if (guideBranchDef.getBranchType().equals("geoStructure")) {
                            throw new R01MSearchPerformerException("El tipo de branch geoStructure NO est\u00e1 soportado de momento...");
                        }
                        long guideNodeCountEndTime = System.currentTimeMillis();
                        outGuideFutureElements[i].setComputeTime(guideNodeCountEndTime - guideNodeCountStartTime);
                        if (!DEBUG) continue;
                        R01FLog.to((String)"r01k.searchPerformer").info("-Numero de resultados del nodo futuro de la guia " + guideFutureElements[i].getPathInGuide() + ": " + guideFutureElements[i].getNumberOfResults() + " en " + guideFutureElements[i].getComputeTime() + " msg");
                        continue;
                    }
                    if (DEBUG) {
                        R01FLog.to((String)"r01k.searchPerformer").info("-YA se a hab\u00eda calculado el n\u00famero total de resultados para el elemento futuro de la guia: " + guideFutureElements[i].getPathInGuide() + ": NO se vuelve a calcular!");
                    }
                    outGuideFutureElements[i] = new R01MSearchGuideElement(guideFutureElements[i]);
                }
                if (DEBUG) {
                    R01FLog.to((String)"r01k.searchPerformer").info("[R01KBaseContentSearchPerformer](guideFutureElements.end) queryOID=" + query.getQueryOid() + "\r\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\r\n\r\n\r\n\r\n");
                }
            }
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            cfgLoadEx.printStackTrace(System.out);
        }
        catch (R01MSearchStorageException ssEx) {
            ssEx.printStackTrace(System.out);
            R01FLog.to((String)"r01k.searchPerformer").severe("NO se han podido calcular los elementos de la guia de navegaci\u00f3n!");
        }
        catch (R01MSearchPerformerException spEx) {
            spEx.printStackTrace(System.out);
        }
        query.setQueryOid(originalQueryOid);
        return outGuideFutureElements;
    }

    @Override
    public R01MSearchResultItem[] search(String searchSessionOid, String searchSessionLang, String searchSourceOid, R01MQueryObject query, int pageNum, Object pageFirstCod, Object pageLastCod) throws R01MSearchPerformerException {
        List searchResultItems;
        long initTime = System.currentTimeMillis();
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchSentencePerformer").info("[R01KBaseContentSearchPerformer](search-start) queryOID=" + query.getQueryOid());
        }
        this._cachedSearchMetaDataStorageConfig = this.getSearchMetaDataStorageConfig(query, searchSourceOid);
        R01MQueryObject efQry = this._composeEffectiveQuery(searchSourceOid, query);
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchPerformer").info(">> Query ejecutada: \r\n" + efQry.composeDebugInfo());
        }
        if ((searchResultItems = this.executeQuery(searchSessionOid, searchSessionLang, searchSourceOid, efQry, pageNum, pageFirstCod, pageLastCod)) == null) {
            if (DEBUG) {
                R01FLog.to((String)"r01k.searchPerformer").info("\t[searchTime: 0] N\u00famero de filas para la p\u00e1gina " + pageNum + ": NINGUN REGISTRO");
            }
            return null;
        }
        long qryTime = System.currentTimeMillis();
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchPerformer").info("[R01KBaseContentSearchPerformer](search-end) queryOID=" + efQry.getQueryOid() + " elapsed time: " + (qryTime - initTime) + "msg > N\u00famero de filas para la p\u00e1gina " + pageNum + ": " + searchResultItems.size() + "\r\n");
        }
        List outResultItems = this._composeResults(efQry, searchResultItems);
        long composeResultsTime = System.currentTimeMillis();
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchPerformer").info("[R01KBaseContentSearchPerformer](map-end) queryOID=" + efQry.getQueryOid() + " elapsed time: " + (composeResultsTime - qryTime) + "msg\r\n");
        }
        return outResultItems.toArray(new R01MSearchResultItem[outResultItems.size()]);
    }

    @Override
    public R01MSearchResultItem[] searchFromAutonomyQuery(String autonomyQuery, String context) throws R01MSearchPerformerException {
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchSentencePerformer").info("[R01KBaseContentSearchPerformer](search-start) query=" + autonomyQuery);
        }
        if (this._cachedSearchMetaDataStorageConfig != null || StringUtils.isEmptyString((String)this._searchSourceOid)) {
            throw new R01MSearchPerformerException("[R01KBaseContentSearchPerformer] searchFromAutonomyQuery - No se puede establecer la configuraci\u00f3n de las b\u00fasquedas (source nulo)");
        }
        R01MQueryObject qry = new R01MQueryObject();
        qry.setContext(context);
        this._cachedSearchMetaDataStorageConfig = this.getSearchMetaDataStorageConfig(qry, this._searchSourceOid);
        List searchResultItems = this.executeQueryFromAutonomyQuery(autonomyQuery);
        if (searchResultItems == null) {
            if (DEBUG) {
                R01FLog.to((String)"r01k.searchPerformer").info("\t[searchTime: 0] : NINGUN REGISTRO");
            }
            return null;
        }
        long qryTime = System.currentTimeMillis();
        List outResultItems = this._composeResults(null, searchResultItems);
        long composeResultsTime = System.currentTimeMillis();
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchPerformer").info("[R01KBaseContentSearchPerformer](map-end) query=" + autonomyQuery + " elapsed time: " + (composeResultsTime - qryTime) + "msg\r\n");
        }
        return outResultItems.toArray(new R01MSearchResultItem[outResultItems.size()]);
    }

    @Override
    public String composeSearchQuery(boolean isCountQuery, String searchSessionOid, String searchSessionLang, String searchSourceOid, R01MQueryObject qry, int pageNum, Object pageFirstCod, Object pageLastCod) throws R01MSearchPerformerException {
        return this.executeComposeSearchQuery(isCountQuery, searchSessionOid, searchSessionLang, searchSourceOid, qry, pageNum, pageFirstCod, pageLastCod);
    }

    private List _composeResults(R01MQueryObject query, List resultRecords) throws R01MSearchPerformerException {
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchPerformer").info("[R01KBaseContentSearchPerformer](mapeo resultItem - start): Comienzo de conversi\u00f3n de la lista de mapas del resultado a lista de objetos de tipo R01MSearchResultItem.");
        }
        ArrayList<R01MSearchResultItem> outResults = null;
        if (resultRecords == null) {
            R01FLog.to((String)"r01k.searchPerformer").warning("La lista de resultados est\u00e1 vac\u00eda o es nula!!!");
            outResults = new ArrayList<R01MSearchResultItem>();
        } else {
            R01KSearchEngineReturnedDataToResultItemTransformer mapper = this.getSearchEngineReturnedDataToResultItemTransformer(this._cachedSearchMetaDataStorageConfig);
            mapper.setNativeDateFormat(this.getNativeDateFormat());
            mapper.setProperties(this.getProperties());
            outResults = new ArrayList(resultRecords.size());
            for (int i = 0; i < resultRecords.size(); ++i) {
                R01MSearchResultItem currItem = mapper.mapSearchEngineReturnedDataToResultItem(this._cachedSearchMetaDataStorageConfig, (Map)resultRecords.get(i), i);
                currItem.setSearchSourceOid(this.getSearchSourceOid());
                _metaDataProcessor.processSearchResultItemMetaData(this._cachedSearchMetaDataStorageConfig, currItem);
                if (currItem.getDocumentPublicationInfo() != null && query != null && query.getPublishRepositories() != null) {
                    ArrayList<R01MSearchResultItemPublicationInfo> finalItemPubRep = new ArrayList<R01MSearchResultItemPublicationInfo>();
                    R01MSearchedPublishRepository currSearchedPubRep2 = null;
                    R01MSearchResultItemPublicationInfo itemPubRep2 = null;
                    for (R01MSearchedPublishRepository currSearchedPubRep2 : query.getPublishRepositories()) {
                        for (R01MSearchResultItemPublicationInfo itemPubRep2 : currItem.getDocumentPublicationInfo()) {
                            if (!itemPubRep2.repositoryOid.equals(currSearchedPubRep2.oid)) continue;
                            finalItemPubRep.add(new R01MSearchResultItemPublicationInfo(itemPubRep2));
                        }
                    }
                    currItem.setDocumentPublicationInfo(finalItemPubRep);
                }
                outResults.add(currItem);
            }
        }
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchPerformer").info("[R01KBaseContentSearchPerformer](mapeo resultItem - end): Comienzo de conversi\u00f3n de la lista de mapas del resultado a lista de objetos de tipo R01MSearchResultItem.");
        }
        return outResults;
    }

    private R01MQueryObject _composeEffectiveQuery(String searchSourceOid, R01MQueryObject qry) throws R01MSearchPerformerException {
        R01MQueryObject efQry = (R01MQueryObject)CloneUtils.cloneByReflection((Object)qry);
        this._filterIgnoreLabels(efQry);
        R01MSearchSource srchSrcCfg = null;
        R01MSearchSourcePerformer performerCfg = null;
        try {
            srchSrcCfg = R01MClientFactory.getSearchEngineConfigAPI().getSearchEngineConfig().getSearchSourceCfg(efQry.getContext(), searchSourceOid);
            performerCfg = srchSrcCfg != null ? srchSrcCfg.getSearchPerformer(this._searchPerformerId) : null;
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            throw new R01MSearchPerformerException("NO se ha podido cargar la configuraci\u00f3n del buscador: " + cfgLoadEx.getMessage(), (Exception)((Object)cfgLoadEx));
        }
        try {
            this._obtainNumericIds(efQry);
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            throw new R01MSearchPerformerException((Exception)((Object)cfgLoadEx));
        }
        if (!efQry.isPublishedItemsOnly()) {
            if (DEBUG) {
                R01FLog.to((String)"r01m.searchSentencePerformer").info("...se eliminan las condiciones sobre repositorios de publicaci\u00f3n ya que en la query se indica que se busque en contenidos publicados y no publicados");
            }
            efQry.setPublishRepositories(null);
        } else if (efQry.isPublishedItemsOnly()) {
            this._filterPublicationTargets(srchSrcCfg, efQry);
        }
        String fullText = efQry.getFullText();
        if (fullText != null && fullText.length() > 0) {
            String searchEngineFunctionsRegExp;
            String reservedWordsRegExp;
            String wordsToRemoveRegExp;
            int maxFullTextWords;
            int maxFullTextStringLength = NumberUtils.isInteger((String)performerCfg.getProperty("maxFullTextStringLength")) ? Integer.parseInt(performerCfg.getProperty("maxFullTextStringLength")) : 0;
            R01MFullTextQueryUtils.FixedQuery fixedQuery = R01MFullTextQueryUtils.fixSearchQueryString((String)fullText, (int)maxFullTextStringLength, (int)(maxFullTextWords = NumberUtils.isInteger((String)performerCfg.getProperty("maxFullTextWords")) ? Integer.parseInt(performerCfg.getProperty("maxFullTextWords")) : 0), (String)(wordsToRemoveRegExp = performerCfg.getProperty("wordsToRemoveRegExp")), (String)(reservedWordsRegExp = performerCfg.getProperty("reservedWordsRegExp")), (String)(searchEngineFunctionsRegExp = performerCfg.getProperty("searchEngineFunctionsRegExp")));
            if (fixedQuery != null && fixedQuery.fixedQuery != null && fixedQuery.fixedQuery.length() > 0) {
                efQry.setFullText(fixedQuery.fixedQuery.toString());
                efQry.setFullTextWordCount(fixedQuery.wordCount);
            } else {
                efQry.setFullText(null);
            }
        }
        efQry.setFullTextSearch(qry.isFullTextSearch());
        _metaDataProcessor.processQueryObjectMetaData(this._cachedSearchMetaDataStorageConfig, efQry);
        return efQry;
    }

    private void _filterIgnoreLabels(R01MQueryObject qry) {
        R01MSearchedStructureCatalog currCatalog;
        List ignoreCatalogLabels = XMLProperties.getPropertyList((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"ignoreLabels/labelToIgnore");
        if (ignoreCatalogLabels == null || ignoreCatalogLabels.isEmpty()) {
            return;
        }
        boolean hitCatalogLabel = false;
        if (qry.getCatalogLabelsAnd() != null && !qry.getCatalogLabelsAnd().isEmpty()) {
            List efCatalogLabelsAnd = qry.getCatalogLabelsAnd();
            for (int i = 0; i < qry.getCatalogLabelsAnd().size(); ++i) {
                currCatalog = (R01MSearchedStructureCatalog)qry.getCatalogLabelsAnd().get(i);
                if (!ignoreCatalogLabels.contains(currCatalog.getLabelOid())) continue;
                efCatalogLabelsAnd.remove(currCatalog);
                hitCatalogLabel = true;
            }
            if (hitCatalogLabel) {
                qry.setCatalogLabelsAnd(efCatalogLabelsAnd);
            }
        }
        hitCatalogLabel = false;
        if (qry.getCatalogLabelsOr() != null && !qry.getCatalogLabelsOr().isEmpty()) {
            List efCatalogLabelsOr = qry.getCatalogLabelsOr();
            for (int e = 0; e < qry.getCatalogLabelsOr().size(); ++e) {
                currCatalog = (R01MSearchedStructureCatalog)qry.getCatalogLabelsOr().get(e);
                if (!ignoreCatalogLabels.contains(currCatalog.getLabelOid())) continue;
                efCatalogLabelsOr.remove(currCatalog);
                hitCatalogLabel = true;
            }
            if (hitCatalogLabel) {
                qry.setCatalogLabelsOr(efCatalogLabelsOr);
            }
        }
    }

    private void _filterPublicationTargets(R01MSearchSource srchSrcCfg, R01MQueryObject qry) {
        if (srchSrcCfg != null && srchSrcCfg.getAvailablePublicationTargets() != null) {
            if (qry.getPublishRepositories() == null || qry.getPublishRepositories().size() == 0) {
                String pubFilterStr = "";
                qry.setPublishRepositories(new ArrayList(srchSrcCfg.getAvailablePublicationTargets().size()));
                qry.addPublishRepository("Inter");
                pubFilterStr = "Inter:";
                if (DEBUG) {
                    R01FLog.to((String)"r01k.searchSentencePerformer").info("En la query NO se indicaban repositorios de publicaci\u00f3n por los que filtrar, as\u00ed que se han a\u00f1adido los indicados en la propiedad [availablePublicationTargets] del fichero r01kSearchEngineConfig.xml: " + pubFilterStr);
                }
            }
            if (qry.getPublishRepositories() != null) {
                ArrayList publishRepsCopy = new ArrayList(qry.getPublishRepositories().size());
                Iterator pIt = qry.getPublishRepositories().iterator();
                while (pIt.hasNext()) {
                    publishRepsCopy.add(pIt.next());
                }
                R01MSearchedPublishRepository currSearchedPublishRepository2 = null;
                for (R01MSearchedPublishRepository currSearchedPublishRepository2 : publishRepsCopy) {
                    if (srchSrcCfg.getAvailablePublicationTargets().contains(currSearchedPublishRepository2.getOid())) continue;
                    R01FLog.to((String)"r01k.session").warning("En la query se ha indicado filtrar por el repositorio de publicaci\u00f3n " + currSearchedPublishRepository2.getOid() + " sin embargo, dicho repositorio NO se ha indicado como repositorio de publicaci\u00f3n disponible para el origen " + srchSrcCfg.getOid() + ".\r\nEl destino de publicaci\u00f3n se ELIMINA de la query.\r\nRevisa la secci\u00f3n [availablePublicationTargets] del fichero r01kSearchEngineConfig.xml!!!");
                    qry.removePublishRepository(currSearchedPublishRepository2.getOid());
                }
            }
        }
    }

    protected R01MQueryObject _obtainNumericIds(R01MQueryObject qry) throws R01MConfigLoadException {
        Iterator rIt;
        Iterator rIt2;
        ArrayList<String> objsToRemove = new ArrayList<String>();
        R01MContentCluster typoObj = null;
        if (qry.getContentClusters() != null) {
            R01MBaseSearchedTypoObj searchedCluster2 = null;
            for (R01MBaseSearchedTypoObj searchedCluster2 : qry.getContentClusters()) {
                if (searchedCluster2.getNumericId() > 0) continue;
                typoObj = R01MClientFactory.getTypologyConfigAPI().getClusterConfig(searchedCluster2.getOid());
                if (typoObj != null) {
                    searchedCluster2.setNumericId(typoObj.getNumericId());
                    continue;
                }
                R01FLog.to((String)"r01m.searchEngine").warning("El cluster " + searchedCluster2.getOid() + " especificado en la query NO existe... se elimina de la query!");
                objsToRemove.add(searchedCluster2.getOid());
                searchedCluster2 = null;
            }
            if (!objsToRemove.isEmpty()) {
                rIt2 = objsToRemove.iterator();
                while (rIt2.hasNext()) {
                    qry.removeContentCluster((String)rIt2.next());
                }
                objsToRemove.clear();
            }
        }
        if (qry.getContentFamilies() != null) {
            R01MBaseSearchedTypoObj searchedFamily2 = null;
            for (R01MBaseSearchedTypoObj searchedFamily2 : qry.getContentFamilies()) {
                if (searchedFamily2.getNumericId() > 0) continue;
                typoObj = R01MClientFactory.getTypologyConfigAPI().getFamilyConfig(searchedFamily2.getOid());
                if (typoObj != null) {
                    searchedFamily2.setNumericId(typoObj.getNumericId());
                    continue;
                }
                R01FLog.to((String)"r01m.searchEngine").warning("La familia " + searchedFamily2.getOid() + " especificado en la query NO existe... se elimina de la query!");
                objsToRemove.add(searchedFamily2.getOid());
                searchedFamily2 = null;
            }
            if (!objsToRemove.isEmpty()) {
                rIt2 = objsToRemove.iterator();
                while (rIt2.hasNext()) {
                    qry.removeContentFamily((String)rIt2.next());
                }
                objsToRemove.clear();
            }
        }
        if (qry.getContentTypes() != null) {
            R01MBaseSearchedTypoObj searchedType2 = null;
            for (R01MBaseSearchedTypoObj searchedType2 : qry.getContentTypes()) {
                if (searchedType2.getNumericId() > 0) continue;
                typoObj = R01MClientFactory.getTypologyConfigAPI().getTypeConfig(searchedType2.getOid());
                if (typoObj != null) {
                    searchedType2.setNumericId(typoObj.getNumericId());
                    continue;
                }
                R01FLog.to((String)"r01m.searchEngine").warning("El tipo " + searchedType2.getOid() + " especificado en la query NO existe... se elimina de la query!");
                objsToRemove.add(searchedType2.getOid());
            }
            if (!objsToRemove.isEmpty()) {
                rIt2 = objsToRemove.iterator();
                while (rIt2.hasNext()) {
                    qry.removeContentType((String)rIt2.next());
                }
                objsToRemove.clear();
            }
        }
        R01MSearchedStructureCatalog searchedStructCat2 = null;
        R01MLabel label = null;
        if (qry.getCatalogLabelsAnd() != null) {
            for (R01MSearchedStructureCatalog searchedStructCat2 : qry.getCatalogLabelsAnd()) {
                if (searchedStructCat2.getLabelNumericId() > 0) continue;
                label = R01MCachedCatalogLabelsManager.getLabel((String)searchedStructCat2.getLabelOid());
                if (label != null) {
                    searchedStructCat2.setLabelNumericId(label.getLabelId());
                    continue;
                }
                R01FLog.to((String)"r01m.searchEngine").warning("La etiqueta de catalogacion AND " + searchedStructCat2.getLabelOid() + " especificado en la query NO existe... se elimina de la query!");
                objsToRemove.add(searchedStructCat2.getLabelOid());
            }
            if (!objsToRemove.isEmpty()) {
                rIt = objsToRemove.iterator();
                while (rIt.hasNext()) {
                    qry.removeANDStructrueCatalog((String)rIt.next());
                }
                objsToRemove.clear();
            }
        }
        if (qry.getCatalogLabelsOr() != null) {
            for (R01MSearchedStructureCatalog searchedStructCat2 : qry.getCatalogLabelsOr()) {
                if (searchedStructCat2.getLabelNumericId() > 0) continue;
                label = R01MCachedCatalogLabelsManager.getLabel((String)searchedStructCat2.getLabelOid());
                if (label != null) {
                    searchedStructCat2.setLabelNumericId(label.getLabelId());
                    continue;
                }
                R01FLog.to((String)"r01m.searchEngine").warning("La etiqueta de catalogacion Or " + searchedStructCat2.getLabelOid() + " especificado en la query NO existe... se elimina de la query!");
                objsToRemove.add(searchedStructCat2.getLabelOid());
            }
            if (!objsToRemove.isEmpty()) {
                rIt = objsToRemove.iterator();
                while (rIt.hasNext()) {
                    qry.removeORStructrueCatalog((String)rIt.next());
                }
                objsToRemove.clear();
            }
        }
        return qry;
    }
}

