/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01k.searchorchestrator.searchperformers;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01k.searchorchestrator.searchperformers.R01KAutonomyQueryBuilder;
import com.ejie.r01k.searchorchestrator.searchperformers.R01KBaseContentSearchPerformer;
import com.ejie.r01k.searchorchestrator.searchperformers.R01KInitQueryResult;
import com.ejie.r01k.searchorchestrator.searchperformers.R01KSearchEngineReturnedDataToResultItemTransformer;
import com.ejie.r01k.searchorchestrator.searchperformers.R01KSearchEngineReturnedDataToResultItemTransformerDefImpl;
import com.ejie.r01m.config.objects.searchengine.guide.R01MSearchGuideDefBranch;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MSearchMetaDataStorageConfig;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MSearchPerformerException;
import com.ejie.r01m.exceptions.R01MSearchStorageException;
import com.ejie.r01m.objects.cataloguing.structures.R01MLabel;
import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuideElement;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedPublishRepository;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.cachedmanagers.R01MCachedCatalogLabelsManager;
import com.ejie.r01p.searchengine.autonomy.R01PAutonomyQueryResponseWrapper;
import com.ejie.r01p.searchengine.autonomy.R01PAutonomyUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class R01KAutonomySearchPerformer
extends R01KBaseContentSearchPerformer {
    private static boolean DEBUG = R01FLog.getLogLevel((String)"r01k.searchPerformer").intValue() != Level.OFF.intValue();

    @Override
    protected R01KSearchEngineReturnedDataToResultItemTransformer getSearchEngineReturnedDataToResultItemTransformer(R01MSearchMetaDataStorageConfig searchMetaDataStorageConfig) {
        return new R01KSearchEngineReturnedDataToResultItemTransformerDefImpl("autonomy.resultSetCol");
    }

    @Override
    public R01KInitQueryResult executeCountQuery(boolean lazy, boolean isGuideCount, String searchSessionOid, String searchSessionLang, String searchSourceOid, R01MQueryObject query) throws R01MSearchPerformerException {
        boolean effectiveLazy = false;
        boolean returnMetaData = isGuideCount ? false : !effectiveLazy;
        String queryURL = this.executeComposeSearchQuery(!returnMetaData, searchSessionOid, searchSessionLang, searchSourceOid, query, -1, null, null);
        R01PAutonomyQueryResponseWrapper autonomyResponse = this._executeAutonomyQuery(query, queryURL, returnMetaData);
        return new R01KInitQueryResult(autonomyResponse.getTotalHits(), autonomyResponse.getHits());
    }

    @Override
    public List executeQuery(String searchSessionOid, String searchSessionLang, String searchSourceOid, R01MQueryObject query, int pageNum, Object pageFirstElementCod, Object pageLastElementCod) throws R01MSearchPerformerException {
        String queryURL = this.executeComposeSearchQuery(false, searchSessionOid, searchSessionLang, searchSourceOid, query, pageNum, pageFirstElementCod, pageLastElementCod);
        R01PAutonomyQueryResponseWrapper autonomyResponse = this._executeAutonomyQuery(query, queryURL, true);
        return autonomyResponse.getHits();
    }

    @Override
    public List executeQueryFromAutonomyQuery(String autonomyQuery) throws R01MSearchPerformerException {
        R01PAutonomyQueryResponseWrapper autonomyResponse = this._executeAutonomyQuery(null, autonomyQuery, true);
        return autonomyResponse.getHits();
    }

    @Override
    public String executeComposeSearchQuery(boolean isCountQuery, String searchSessionOid, String searchSessionLang, String searchSourceOid, R01MQueryObject qry, int pageNum, Object pageFirstCod, Object pageLastCod) throws R01MSearchPerformerException {
        long t0 = System.currentTimeMillis();
        R01KAutonomyQueryBuilder queryBuilder = new R01KAutonomyQueryBuilder();
        queryBuilder.setProperties(this.getProperties());
        queryBuilder.setNativeDateFormat(this.getNativeDateFormat());
        try {
            this._obtainNumericIds(qry);
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            throw new R01MSearchPerformerException((Exception)((Object)cfgLoadEx));
        }
        String queryURL = queryBuilder.composeSearchQuery(this.getSearchMetaDataStorageConfig(qry, searchSourceOid), isCountQuery, qry, pageNum, pageFirstCod, pageLastCod);
        Properties props = this.getProperties();
        String baseParams = props != null && props.getProperty("baseParams") != null ? props.getProperty("baseParams") : "XMLMeta=false&TotalResults=true&Predict=false&WeighFieldText=false";
        String countParams = props != null && props.getProperty("countParams") != null ? props.getProperty("countParams") : "Print=none&Start=0&MaxResults=1&Summary=Off";
        String queryParams = props != null && props.getProperty("queryParams") != null ? props.getProperty("queryParams") : "Print=ALL&Highlight=SummaryTerms,Terms&StartTag=<b>&Summary=Context&Sentences=2";
        HashSet<String> autonomyDatabases = new HashSet<String>();
        if (qry.getPublishRepositories() != null && !qry.getPublishRepositories().isEmpty()) {
            Iterator itRepositories = qry.getPublishRepositories().iterator();
            while (itRepositories.hasNext()) {
                autonomyDatabases.add(XMLProperties.getProperty((String)R01MConstants.INTERNALAPI_APPCODE, (String)("autonomy/databaseInAutonomy/" + ((R01MSearchedPublishRepository)itRepositories.next()).getOid()), (String)"euskadi_db"));
            }
        } else {
            autonomyDatabases.add(XMLProperties.getProperty((String)R01MConstants.INTERNALAPI_APPCODE, (String)"autonomy/databaseInAutonomy/default", (String)"euskadi_db"));
        }
        String finalQueryURL = "DatabaseMatch=";
        Iterator itDatabases = autonomyDatabases.iterator();
        while (itDatabases.hasNext()) {
            finalQueryURL = finalQueryURL + itDatabases.next() + (itDatabases.hasNext() ? "," : "");
        }
        finalQueryURL = finalQueryURL + "&" + baseParams;
        if (isCountQuery && countParams != null) {
            finalQueryURL = finalQueryURL + "&" + countParams;
        } else if (!isCountQuery && queryParams != null) {
            finalQueryURL = finalQueryURL + "&" + queryParams;
        }
        if (queryURL != null) {
            finalQueryURL = finalQueryURL + "&" + queryURL;
        }
        long t1 = System.currentTimeMillis();
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchPerformer").info("->Autonomy Query build : " + (t1 - t0) + " msg");
        }
        return finalQueryURL;
    }

    @Override
    protected R01MSearchGuideElement[] executeComputeFutureGuideElementsCount(String searchSessionOid, String searchSessionLang, String searchSourceOid, R01MQueryObject qry, R01MSearchGuideElement[] guideFutureElements) {
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchPerformer").info("\r\n\r\n\r\n\r\n[R01KContentSearchPerformer](guideFutureElements.init) queryOID=" + qry.getQueryOid() + "\r\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        }
        boolean futureElsObtained = true;
        for (int i = 0; i < guideFutureElements.length; ++i) {
            if (guideFutureElements[i].getNumberOfResults() >= 0) continue;
            futureElsObtained = false;
        }
        if (futureElsObtained) {
            R01MSearchGuideElement[] outGuideFutureElements = new R01MSearchGuideElement[guideFutureElements.length];
            for (int i = 0; i < guideFutureElements.length; ++i) {
                outGuideFutureElements[i] = new R01MSearchGuideElement(guideFutureElements[i]);
            }
            return outGuideFutureElements;
        }
        try {
            R01MSearchGuideDefBranch guideBranchDef = null;
            guideBranchDef = R01MClientFactory.getSearchEnginePersistenceAPI().getGuideBranchDef(guideFutureElements[0].getBranchDefPath());
            if (guideBranchDef == null) {
                R01FLog.to((String)"r01k.searchPerformer").severe("R01KSearchPerformer.init: La guia est\u00e1 mal formada ya que el elemento NO tiene la definici\u00f3n del branch al que pertenece. Se ignora la guia!!");
            } else {
                String dreFieldGuideName = "guide_";
                if (guideBranchDef.getBranchType().equals("typo")) {
                    dreFieldGuideName = dreFieldGuideName + "typo_";
                    String path = guideFutureElements[0].getElementPathInBranch();
                    if (path == null || StringUtils.isEmptyString((String)path)) {
                        dreFieldGuideName = dreFieldGuideName + "cluster";
                    } else {
                        String[] pathSplitted = path.split("/");
                        if (pathSplitted.length == 1) {
                            dreFieldGuideName = dreFieldGuideName + "family";
                        } else if (pathSplitted.length == 2) {
                            dreFieldGuideName = dreFieldGuideName + "type";
                        }
                    }
                } else if (guideBranchDef.getBranchType().equals("structure")) {
                    dreFieldGuideName = dreFieldGuideName + "structure_";
                    String[] structureStartPathSplitted = guideBranchDef.getStartingPath().split("/");
                    String structureOid = structureStartPathSplitted[0];
                    dreFieldGuideName = dreFieldGuideName + structureOid + "_" + (structureStartPathSplitted.length + guideFutureElements[0].getElementPathInBranch().split("/").length - 1);
                }
                R01KAutonomyQueryBuilder queryBuilder = new R01KAutonomyQueryBuilder();
                queryBuilder.setProperties(this.getProperties());
                queryBuilder.setNativeDateFormat(this.getNativeDateFormat());
                qry.setModified(false);
                StringBuffer[] querySentences = queryBuilder.composeSearchQueryBasicParts(this.getSearchMetaDataStorageConfig(qry, searchSourceOid), qry);
                StringBuffer basicQueryStr = new StringBuffer(querySentences[0].toString());
                Properties props = this.getProperties();
                String baseParams = props != null && props.getProperty("baseParams") != null ? props.getProperty("baseParams") : "DatabaseMatch=euskadi_db";
                basicQueryStr.insert(0, baseParams + "&");
                Map guideElements = this._executeGuideCount(qry, basicQueryStr.toString(), dreFieldGuideName);
                if (guideElements != null) {
                    R01MSearchGuideElement[] outGuideFutureElements = new R01MSearchGuideElement[guideFutureElements.length];
                    Map.Entry me2 = null;
                    block5: for (Map.Entry me2 : guideElements.entrySet()) {
                        for (int i = 0; i < guideFutureElements.length; ++i) {
                            String labelOid;
                            R01MLabel label;
                            String[] elPathInBranchSplitted = guideFutureElements[i].getElementPathInBranch().split("/");
                            if (guideBranchDef.getBranchType().equals("typo")) {
                                if (!elPathInBranchSplitted[elPathInBranchSplitted.length - 1].equalsIgnoreCase((String)me2.getKey())) continue;
                                outGuideFutureElements[i] = new R01MSearchGuideElement(guideFutureElements[i]);
                                outGuideFutureElements[i].setNumberOfResults(((Integer)me2.getValue()).intValue());
                                continue block5;
                            }
                            if (!guideBranchDef.getBranchType().equals("structure") || (label = R01MCachedCatalogLabelsManager.getLabel((String)(labelOid = elPathInBranchSplitted[elPathInBranchSplitted.length - 1]))) == null || label.getLabelId() != Integer.parseInt((String)me2.getKey())) continue;
                            outGuideFutureElements[i] = new R01MSearchGuideElement(guideFutureElements[i]);
                            outGuideFutureElements[i].setNumberOfResults(((Integer)me2.getValue()).intValue());
                            continue block5;
                        }
                    }
                    return outGuideFutureElements;
                }
            }
        }
        catch (R01MSearchStorageException ssEx) {
            ssEx.printStackTrace(System.out);
            R01FLog.to((String)"r01k.searchPerformer").severe("NO se han podido calcular los elementos de la guia de navegaci\u00f3n!");
        }
        catch (R01MSearchPerformerException spEx) {
            spEx.printStackTrace(System.out);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchPerformer").info("[R01KContentSearchPerformer](guideFutureElements.end) queryOID=" + qry.getQueryOid() + "\r\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\r\n\r\n\r\n\r\n");
        }
        R01MSearchGuideElement[] outGuideFutureElements = new R01MSearchGuideElement[guideFutureElements.length];
        for (int i = 0; i < guideFutureElements.length; ++i) {
            outGuideFutureElements[i] = new R01MSearchGuideElement(guideFutureElements[i]);
        }
        return outGuideFutureElements;
    }

    private R01PAutonomyQueryResponseWrapper _executeAutonomyQuery(R01MQueryObject qry, String queryURL, boolean returnMetaData) throws R01MSearchPerformerException {
        try {
            R01PAutonomyQueryResponseWrapper autonomyResponse = R01PAutonomyUtils.executeQuery((Properties)this.getProperties(), (R01MQueryObject)qry, (String)queryURL, (boolean)returnMetaData);
            return autonomyResponse;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            throw new R01MSearchPerformerException(ex);
        }
    }

    private Map _executeGuideCount(R01MQueryObject qry, String qryURL, String dreFieldGuideName) throws R01MSearchPerformerException {
        Map outGuideElements = R01PAutonomyUtils.executeGuideCount((Properties)this.getProperties(), (R01MQueryObject)qry, (String)qryURL, (String)dreFieldGuideName);
        return outGuideElements;
    }
}

