/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01k.searchorchestrator.searchperformers;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01k.searchorchestrator.searchperformers.R01KBaseSearchQueryBuilder;
import com.ejie.r01m.config.objects.searchengine.guide.R01MSearchGuideDefBranch;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MMetaDataStorageConfig;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MSearchMetaDataStorageConfig;
import com.ejie.r01m.exceptions.R01MSearchPerformerException;
import com.ejie.r01m.exceptions.R01MSearchStorageException;
import com.ejie.r01m.objects.cataloguing.structures.R01MLabel;
import com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedStorageObj;
import com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedTypoObj;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedCluster;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedContentType;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedFamily;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedOrderByMetaData;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedPublishRepository;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedStructureCatalog;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.cachedmanagers.R01MCachedCatalogLabelsManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class R01KAutonomyQueryBuilder
extends R01KBaseSearchQueryBuilder {
    private static final int STEMMING_MIN_WORDS = XMLProperties.getInt((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"autonomy/stemmingMinWords");

    @Override
    public String composeSearchQuery(R01MSearchMetaDataStorageConfig metaDataStorageConfig, boolean isCountQuery, R01MQueryObject qry, int pageNum, Object pageFirstRow, Object pageLastRow) throws R01MSearchPerformerException {
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t[Search Autonomy Query Builder](init)");
        }
        if (qry == null) {
            throw new R01MSearchPerformerException("NO se puede componer la query de b\u00fasqueda: la query es nula!");
        }
        if (this.isQueryEmpty(qry)) {
            throw new R01MSearchPerformerException("NO se puede componer la query de b\u00fasqueda: no existe un filtro v\u00e1lido!");
        }
        StringBuffer[] querySentences = this.composeSearchQueryBasicParts(metaDataStorageConfig, qry);
        if (querySentences.length != 2) {
            throw new R01MSearchPerformerException("NO se han obtenido todas las partes de la query. Revisa que la propiedad autonomy.queryParts del fichero searchMetaDataStorage.xml tiene el valor basicQuery,orderBy");
        }
        StringBuffer basicQueryStr = querySentences[0];
        StringBuffer orderByQueryStr = querySentences[1];
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t---BASIC query: " + basicQueryStr);
        }
        StringBuffer outQueryStr = new StringBuffer(1500);
        if (!isCountQuery) {
            String pageSizeStr = qry.getPresentationProperty("r01PageSize");
            int pageSize = pageSizeStr != null ? Integer.parseInt(pageSizeStr) : 10;
            int start = -1;
            int end = -1;
            if (pageNum <= 1) {
                start = 1;
                end = pageSize;
            } else {
                start = (pageNum - 1) * pageSize + 1;
                end = start + pageSize - 1;
            }
            if (DEBUG) {
                R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t---Paginaci\u00f3n>>> start=" + start + " - end=" + end);
            }
            if (outQueryStr.length() > 0) {
                outQueryStr.insert(0, "&");
            }
            outQueryStr.insert(0, "Start=" + start + "&MaxResults=" + end);
            if (orderByQueryStr != null && orderByQueryStr.length() > 0) {
                if (outQueryStr.length() > 0) {
                    outQueryStr.append('&');
                }
                outQueryStr.append(orderByQueryStr);
            }
        }
        if (basicQueryStr.length() > 0) {
            outQueryStr.append('&');
            outQueryStr.append(basicQueryStr.toString());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t---Query final a ejecutar: " + outQueryStr.toString());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t[Search Query Builder](end)");
        }
        return outQueryStr.toString();
    }

    @Override
    protected StringBuffer executeComposeBasicQueryPart(String partId, Map preComposedParts, R01MQueryObject qry, Map searchedClusterStorageCfgs, Map searchedFamiliesStorageCfgs, Map searchedTypesStorageCfgs, Map searchedMetaDataStorageCfgs, Properties patterns) throws R01MSearchPerformerException {
        if (partId != null && partId.equals("orderBy")) {
            StringBuffer orderBy = this._composeOrderBy(searchedMetaDataStorageCfgs, qry.getOrderBy(), qry.isFullTextSearch(), qry.getPublishRepositories(), patterns);
            return orderBy;
        }
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t---(init) Partes de la query a autonomy");
        }
        StringBuffer serversQry = this._composeStorageFilter(qry.getServers(), patterns.getProperty("autonomy.storageServerFilter.fieldText"));
        StringBuffer dataStoresQry = this._composeStorageFilter(qry.getDataRepositories(), patterns.getProperty("autonomy.storageDataStoreFilter.fieldText"));
        StringBuffer areasQry = this._composeStorageFilter(qry.getAreas(), patterns.getProperty("autonomy.storageAreaFilter.fieldText"));
        StringBuffer workAreaQry = this._composeStorageFilter(qry.getWorkAreas(), patterns.getProperty("autonomy.storageWorkAreaFilter.fieldText"));
        StringBuffer guideQry = this._composeGuideConditionsFilter(qry.getGuideContentClusters(), qry.getGuideContentFamilies(), qry.getGuideContentTypes(), qry.getGuideCatalogLabelsAnd(), qry.getGuideGeoCatalogsAnd(), patterns);
        List notGuideClusters = qry.getNotGuideContentClusters();
        List notGuideFamilies = qry.getNotGuideContentFamilies();
        List notGuideTypes = qry.getNotGuideContentTypes();
        StringBuffer[] typoQry = this._composeTypoNumericIdFilter(notGuideClusters, notGuideFamilies, notGuideTypes, patterns.getProperty("autonomy.typologyFilter.fieldText"), patterns.getProperty("autonomy.typoClusterFilter.text"), patterns.getProperty("autonomy.typoFamilyFilter.text"), patterns.getProperty("autonomy.typoTypeFilter.text"));
        StringBuffer clustersQry = null;
        StringBuffer familiesQry = null;
        StringBuffer typosQry = null;
        if (typoQry == null) {
            clustersQry = this._composeTypoFilter(notGuideClusters, patterns.getProperty("autonomy.typoClusterFilter.fieldText"));
            familiesQry = this._composeTypoFilter(notGuideFamilies, patterns.getProperty("autonomy.typoFamilyFilter.fieldText"));
            typosQry = this._composeTypoFilter(notGuideTypes, patterns.getProperty("autonomy.typoTypeFilter.fieldText"));
        }
        StringBuffer catalogQry = this._composeCatalogsFilter(qry.getNotGuideCatalogLabelsAnd(), qry.getCatalogLabelsOr(), qry.getNotGuideGeoCatalogsAnd(), qry.getGeoCatalogsOr(), patterns.getProperty("autonomy.andLabelsFilter.fieldText"), patterns.getProperty("autonomy.orLabelsFilter.fieldText"), patterns.getProperty("autonomy.andGeoLabelsFilter.fieldText"), patterns.getProperty("autonomy.orGeoLabelsFilter.fieldText"));
        StringBuffer andMetaDataFiltersQry = this._composeMetadataFilter("AND", searchedMetaDataStorageCfgs, qry.getMetaData(), qry.getPublishRepositories(), patterns);
        StringBuffer orMetaDataFiltersQry = this._composeMetadataFilter("OR", searchedMetaDataStorageCfgs, qry.getORMetaData(), qry.getPublishRepositories(), patterns);
        StringBuffer publishRepositoriesQry = this._composePublicationsFilter(qry.getPublishRepositories(), patterns.getProperty("autonomy.publicationTargetFilter.fieldText"));
        StringBuffer fullTextQry = this._composeFullTextFilter(qry.getFullText(), patterns.getProperty("autonomy.fullTextFilter.text"));
        String langFilter = this._composeLangFilter(qry.getMetaData("documentLanguage"), patterns);
        StringBuffer fieldTextQry = new StringBuffer(1000);
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)guideQry)) {
            if (DEBUG) {
                R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t           GUIDES: " + guideQry.toString());
            }
            if (fieldTextQry.length() > 0) {
                fieldTextQry.append("+AND+");
            }
            fieldTextQry.append(guideQry);
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)serversQry)) {
            if (DEBUG) {
                R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t           SERVERS: " + serversQry.toString());
            }
            if (fieldTextQry.length() > 0) {
                fieldTextQry.append("+AND+");
            }
            fieldTextQry.append(serversQry);
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)dataStoresQry)) {
            if (DEBUG) {
                R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t           DATASTORES: " + dataStoresQry.toString());
            }
            if (fieldTextQry.length() > 0) {
                fieldTextQry.append("+AND+");
            }
            fieldTextQry.append(dataStoresQry);
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)areasQry)) {
            if (DEBUG) {
                R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t           AREAS: " + areasQry.toString());
            }
            if (fieldTextQry.length() > 0) {
                fieldTextQry.append("+AND+");
            }
            fieldTextQry.append(areasQry);
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)workAreaQry)) {
            if (DEBUG) {
                R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t           WORKAREAS: " + workAreaQry.toString());
            }
            if (fieldTextQry.length() > 0) {
                fieldTextQry.append("+AND+");
            }
            fieldTextQry.append(workAreaQry);
        }
        if (typoQry != null && typoQry.length > 0) {
            if (DEBUG) {
                R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t           TYPO (uniqe): " + typoQry[0].toString());
            }
            if (fieldTextQry.length() > 0) {
                fieldTextQry.append("+AND+");
            }
            fieldTextQry.append(typoQry[0]);
        } else {
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)clustersQry)) {
                if (DEBUG) {
                    R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t           CLUSTERS: " + clustersQry.toString());
                }
                if (fieldTextQry.length() > 0) {
                    fieldTextQry.append("+AND+");
                }
                fieldTextQry.append(clustersQry);
            }
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)familiesQry)) {
                if (DEBUG) {
                    R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t           FAMILIES: " + familiesQry.toString());
                }
                if (fieldTextQry.length() > 0) {
                    fieldTextQry.append("+AND+");
                }
                fieldTextQry.append(familiesQry);
            }
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)typosQry)) {
                if (DEBUG) {
                    R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t           TYPES: " + typosQry.toString());
                }
                if (fieldTextQry.length() > 0) {
                    fieldTextQry.append("+AND+");
                }
                fieldTextQry.append(typosQry);
            }
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)catalogQry)) {
            if (DEBUG) {
                R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t           CATALOGS: " + catalogQry.toString());
            }
            if (fieldTextQry.length() > 0) {
                fieldTextQry.append("+AND+");
            }
            fieldTextQry.append('(').append(catalogQry).append(')');
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)andMetaDataFiltersQry) || !StringUtils.isEmptyStringBuffer((StringBuffer)orMetaDataFiltersQry)) {
            if (fieldTextQry.length() > 0) {
                fieldTextQry.append("+AND+");
            }
            fieldTextQry.append('(');
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)andMetaDataFiltersQry)) {
                if (DEBUG) {
                    R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t           METADATA AND: " + andMetaDataFiltersQry.toString());
                }
                fieldTextQry.append(andMetaDataFiltersQry);
            }
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)orMetaDataFiltersQry)) {
                if (!StringUtils.isEmptyStringBuffer((StringBuffer)andMetaDataFiltersQry)) {
                    fieldTextQry.append("+AND+(");
                }
                if (DEBUG) {
                    R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t           METADATA OR: " + orMetaDataFiltersQry.toString());
                }
                fieldTextQry.append(orMetaDataFiltersQry);
                if (!StringUtils.isEmptyStringBuffer((StringBuffer)andMetaDataFiltersQry)) {
                    fieldTextQry.append(")");
                }
            }
            fieldTextQry.append(')');
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)publishRepositoriesQry)) {
            if (DEBUG) {
                R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t           PUBLISH REPS: " + publishRepositoriesQry.toString());
            }
            if (fieldTextQry.length() > 0) {
                fieldTextQry.append("+AND+");
            }
            fieldTextQry.append(publishRepositoriesQry);
        }
        StringBuffer textQry = new StringBuffer(100);
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)fullTextQry)) {
            textQry.append(textQry.length() == 0 ? "" : "+AND+");
            textQry.append(fullTextQry);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t       TEXTO COMPLETO: " + textQry.toString());
        }
        if (textQry.length() > 0) {
            textQry.insert(0, "text=");
        }
        StringBuffer paramsQry = new StringBuffer(200);
        boolean stemming = false;
        if (fullTextQry != null && STEMMING_MIN_WORDS > 0 && qry.getFullTextWordCount() >= STEMMING_MIN_WORDS) {
            stemming = true;
        }
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t          STEMMING: " + stemming);
        }
        paramsQry.append(patterns.getProperty("autonomy.stemming.qryParam") + String.valueOf(stemming));
        if (!StringUtils.isEmptyString((String)langFilter)) {
            if (paramsQry.length() > 0) {
                paramsQry.append('&');
            }
            if (DEBUG) {
                R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t          LENGUAJE: " + publishRepositoriesQry.toString());
            }
            paramsQry.append(langFilter);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t SEARCH ATTACHMENTS: " + qry.isReturnAttachments() + " - " + (qry.isReturnAttachments() ? patterns.getProperty("autonomy.returnAttachments.qryParam") : patterns.getProperty("autonomy.dontReturnAttachments.qryParam")));
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)paramsQry)) {
            paramsQry.append('&');
        }
        if (!(qry.isReturnAttachments() || StringUtils.isEmptyStringBuffer((StringBuffer)fieldTextQry) && StringUtils.isEmptyStringBuffer((StringBuffer)textQry))) {
            String fullTextCombineQry;
            String string = fullTextCombineQry = qry.isFullTextSearch() ? patterns.getProperty("autonomy.dontReturnAttachments.text") : "";
            if (!StringUtils.isEmptyString((String)fullTextCombineQry)) {
                textQry.append(!StringUtils.isEmptyStringBuffer((StringBuffer)textQry) ? "+AND+" : "text=");
                textQry.append(fullTextCombineQry);
            }
            paramsQry.append(patterns.getProperty("autonomy.dontReturnAttachments.qryParam"));
        } else {
            paramsQry.append(patterns.getProperty("autonomy.returnAttachments.qryParam"));
        }
        StringBuffer autonomyQry = new StringBuffer();
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)paramsQry)) {
            autonomyQry.append('&');
            autonomyQry.append(paramsQry);
        }
        if ((StringUtils.isEmptyStringBuffer((StringBuffer)fieldTextQry) || fieldTextQry.toString().equals(publishRepositoriesQry.toString())) && textQry.length() <= "text=".length()) {
            throw new R01MSearchPerformerException("NO se ha pasado ninguna condici\u00f3n para la b\u00fasqueda (b\u00fasqueda en vac\u00edo)!!!");
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)fieldTextQry)) {
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)autonomyQry)) {
                autonomyQry.append("&fieldText=");
            }
            autonomyQry.append(fieldTextQry);
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)textQry)) {
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)autonomyQry)) {
                autonomyQry.append('&');
            }
            autonomyQry.append(textQry);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t QUERY: " + autonomyQry);
        }
        return autonomyQry;
    }

    private StringBuffer _composeFullTextFilter(String fullTextMetaData, String pattern) {
        if (fullTextMetaData == null) {
            return new StringBuffer(100);
        }
        fullTextMetaData = StringUtils.replaceString((String)fullTextMetaData, (String)"+", (String)"AND");
        StringBuffer fixedFullTextQry = new StringBuffer(StringUtils.replaceString((String)pattern, (String)"$FULLTEXT$", (String)fullTextMetaData));
        return fixedFullTextQry;
    }

    private StringBuffer _composeGuideConditionsFilter(List guideClusters, List guideFamilies, List guideTypes, List guideCatalogs, List guideGeoCatalogs, Properties patterns) {
        StringBuffer outFieldTextQry = new StringBuffer(200);
        boolean useGuideFields = XMLProperties.getBoolean((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"autonomy/useGuideFieldsToComposeQuery");
        if (!useGuideFields) {
            StringBuffer clustersQry = this._composeTypoFilter(guideClusters, patterns.getProperty("autonomy.typoClusterFilter.fieldText"));
            StringBuffer familiesQry = this._composeTypoFilter(guideFamilies, patterns.getProperty("autonomy.typoFamilyFilter.fieldText"));
            StringBuffer typosQry = this._composeTypoFilter(guideTypes, patterns.getProperty("autonomy.typoTypeFilter.fieldText"));
            StringBuffer catsQry = this._composeAndCatalogFilter(guideCatalogs, patterns.getProperty("autonomy.andLabelsFilter.fieldText"));
            if (clustersQry != null && clustersQry.length() > 0) {
                outFieldTextQry.append(outFieldTextQry.length() > 0 ? "+AND+" : "");
                outFieldTextQry.append(clustersQry);
            }
            if (familiesQry != null && familiesQry.length() > 0) {
                outFieldTextQry.append(outFieldTextQry.length() > 0 ? "+AND+" : "");
                outFieldTextQry.append(familiesQry);
            }
            if (typosQry != null && typosQry.length() > 0) {
                outFieldTextQry.append(outFieldTextQry.length() > 0 ? "+AND+" : "");
                outFieldTextQry.append(typosQry);
            }
            if (catsQry != null && catsQry.length() > 0) {
                outFieldTextQry.append(outFieldTextQry.length() > 0 ? "+AND+" : "");
                outFieldTextQry.append(catsQry);
            }
        } else {
            String guideTypoFilterPattern = patterns.getProperty("autonomy.guideTypoFilter.fieldText");
            String guideCatalogsFilterPattern = patterns.getProperty("autonomy.guideANDLabelsFilter.fieldText");
            String cond = null;
            if (guideClusters != null && guideClusters.size() == 1) {
                R01MSearchedCluster cluster = (R01MSearchedCluster)guideClusters.get(0);
                cond = StringUtils.replaceString((String)guideTypoFilterPattern, (String)"$TYPOOBJ_OID$", (String)cluster.getOid());
                cond = StringUtils.replaceString((String)cond, (String)"$GUIDE_TYPO_FIELD$", (String)"GUIDE_TYPO_CLUSTER");
                outFieldTextQry.append(cond);
            }
            if (guideFamilies != null && guideFamilies.size() == 1) {
                if (outFieldTextQry.length() > 0) {
                    outFieldTextQry.append("+AND+");
                }
                R01MSearchedFamily family = (R01MSearchedFamily)guideFamilies.get(0);
                cond = StringUtils.replaceString((String)guideTypoFilterPattern, (String)"$TYPOOBJ_OID$", (String)family.getOid());
                cond = StringUtils.replaceString((String)cond, (String)"$GUIDE_TYPO_FIELD$", (String)"GUIDE_TYPO_FAMILY");
                outFieldTextQry.append(cond);
                if (guideTypes != null && guideTypes.size() == 1) {
                    R01MSearchedContentType type = (R01MSearchedContentType)guideTypes.get(0);
                    cond = StringUtils.replaceString((String)guideTypoFilterPattern, (String)"$TYPOOBJ_OID$", (String)type.getOid());
                    cond = StringUtils.replaceString((String)cond, (String)"$GUIDE_TYPO_FIELD$", (String)"GUIDE_TYPO_TYPE");
                    outFieldTextQry.append("+AND+");
                    outFieldTextQry.append(cond);
                }
            }
            if (guideCatalogs != null && !guideCatalogs.isEmpty()) {
                try {
                    R01MSearchedStructureCatalog currCat2 = null;
                    for (R01MSearchedStructureCatalog currCat2 : guideCatalogs) {
                        R01MSearchGuideDefBranch guideBranchDef = null;
                        guideBranchDef = R01MClientFactory.getSearchEnginePersistenceAPI().getGuideBranchDef(currCat2.getGuideCondition().getBranchDefPath());
                        if (guideBranchDef == null) {
                            R01FLog.to((String)"r01k.searchSentenceBuilder").severe("R01KAutonomyQueryBuilder._composeGuideConditionsFilter: La guia est\u00e1 mal formada ya que el elemento NO tiene la definici\u00f3n del branch al que pertenece. Se ignora la guia!!");
                            continue;
                        }
                        String dreFieldGuideName = "guide_structure_";
                        String[] structureStartPathSplitted = guideBranchDef.getStartingPath().split("/");
                        String structureOid = structureStartPathSplitted[0];
                        dreFieldGuideName = dreFieldGuideName + structureOid + "_" + Integer.toString(structureStartPathSplitted.length + currCat2.getGuideCondition().getElementPathInBranch().split("/").length - 1);
                        if (outFieldTextQry.length() > 0) {
                            outFieldTextQry.append("+AND+");
                        }
                        cond = StringUtils.replaceString((String)guideCatalogsFilterPattern, (String)"$STRUCTURE_CAT_ID$", (String)Integer.toString(currCat2.getLabelNumericId()));
                        cond = StringUtils.replaceString((String)cond, (String)"$GUIDE_STRUCTURE_FIELD$", (String)dreFieldGuideName);
                        outFieldTextQry.append(cond);
                    }
                }
                catch (R01MSearchStorageException ssEx) {
                    ssEx.printStackTrace(System.out);
                    R01FLog.to((String)"r01k.searchSentenceBuilder").severe("NO se han podido imponer las condiciones sobre ejes de la guia de navegaci\u00f3n!");
                }
            }
        }
        return outFieldTextQry;
    }

    private StringBuffer _composeStorageFilter(List storageObjs, String pattern) {
        StringBuffer storageObjQry = new StringBuffer(100);
        if (storageObjs != null && !storageObjs.isEmpty()) {
            R01MBaseSearchedStorageObj currSearchedObj = null;
            String storageObjsList = "";
            Iterator it = storageObjs.iterator();
            while (it.hasNext()) {
                currSearchedObj = (R01MBaseSearchedStorageObj)it.next();
                storageObjsList = storageObjsList + currSearchedObj.getStorageObjOid();
                if (!it.hasNext()) continue;
                storageObjsList = storageObjsList + ",";
            }
            if (storageObjsList.length() > 0) {
                storageObjQry.append(StringUtils.replaceString((String)pattern, (String)"$STORAGEOBJS_OIDS$", (String)storageObjsList));
            }
        } else {
            return null;
        }
        return storageObjQry;
    }

    private StringBuffer[] _composeTypoNumericIdFilter(List clusters, List families, List types, String fieldTextPattern, String clusterTextPattern, String familyTextPattern, String typeTextPattern) {
        boolean valid = false;
        if (clusters != null && clusters.size() == 1) {
            if (families != null && families.size() == 1) {
                if (types != null && types.size() == 1) {
                    valid = true;
                } else if (types == null || types.isEmpty()) {
                    valid = true;
                }
            } else if (families == null || families.isEmpty()) {
                valid = types == null || types.isEmpty();
            }
        }
        if (!valid) {
            return null;
        }
        String[] patternSplitted = fieldTextPattern.split("\\|");
        boolean useNumericIds = XMLProperties.getBoolean((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"autonomy/useTypoNumericIds");
        if (!useNumericIds) {
            return null;
        }
        StringBuffer[] outQrys = new StringBuffer[2];
        String tempStr = null;
        if (clusters != null && clusters.size() == 1) {
            R01MBaseSearchedTypoObj searchedCluster = (R01MBaseSearchedTypoObj)clusters.get(0);
            long clNumId = 1000000L * (long)searchedCluster.getNumericId();
            long chNumId = 1000000L * (long)(searchedCluster.getNumericId() + 1) - 1L;
            tempStr = StringUtils.replaceString((String)patternSplitted[1], (String)"$LOW_NUMERICID$", (String)Long.toString(clNumId));
            tempStr = StringUtils.replaceString((String)tempStr, (String)"$HIGH_NUMERICID$", (String)Long.toString(chNumId));
            outQrys[0] = new StringBuffer(tempStr);
            outQrys[1] = new StringBuffer(StringUtils.replaceString((String)clusterTextPattern, (String)"$TYPOLOGYCLUSTEROID$", (String)searchedCluster.getOid()));
            if (families != null && families.size() == 1) {
                R01MBaseSearchedTypoObj searchedFamily = (R01MBaseSearchedTypoObj)families.get(0);
                long flNumId = clNumId + 10000L * (long)searchedFamily.getNumericId();
                long fhNumId = clNumId + 10000L * (long)(searchedFamily.getNumericId() + 1) - 1L;
                tempStr = StringUtils.replaceString((String)patternSplitted[1], (String)"$LOW_NUMERICID$", (String)Long.toString(flNumId));
                tempStr = StringUtils.replaceString((String)tempStr, (String)"$HIGH_NUMERICID$", (String)Long.toString(fhNumId));
                outQrys[0] = new StringBuffer(tempStr);
                outQrys[1].append("+AND+");
                outQrys[1].append(StringUtils.replaceString((String)familyTextPattern, (String)"$TYPOLOGYFAMILYOID$", (String)searchedFamily.getOid()));
                if (types != null && types.size() == 1) {
                    R01MBaseSearchedTypoObj searchedType = (R01MBaseSearchedTypoObj)types.get(0);
                    long numId = clNumId + 10000L * (long)searchedFamily.getNumericId() + 1L * (long)searchedType.getNumericId();
                    tempStr = StringUtils.replaceString((String)patternSplitted[0], (String)"$NUMERICID$", (String)Long.toString(numId));
                    outQrys[0] = new StringBuffer(tempStr);
                    outQrys[1].append("+AND+");
                    outQrys[1].append(StringUtils.replaceString((String)typeTextPattern, (String)"$TYPOLOGYTYPEOID$", (String)searchedType.getOid()));
                }
            }
            outQrys[1].insert(0, "(");
            outQrys[1].append(")");
            return outQrys;
        }
        return null;
    }

    private StringBuffer _composeTypoFilter(List typoObjs, String pattern) {
        boolean useNumericIds = XMLProperties.getBoolean((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"autonomy/useTypoNumericIds");
        StringBuffer typoObjQry = new StringBuffer(100);
        if (typoObjs != null && !typoObjs.isEmpty()) {
            R01MBaseSearchedTypoObj currSearchedObj = null;
            String typoObjOidsCondition = "";
            String typoObjNumericIdsCondition = "";
            Iterator it = typoObjs.iterator();
            while (it.hasNext()) {
                currSearchedObj = (R01MBaseSearchedTypoObj)it.next();
                typoObjOidsCondition = typoObjOidsCondition + currSearchedObj.getOid();
                if (currSearchedObj.getNumericId() >= 0) {
                    typoObjNumericIdsCondition = typoObjNumericIdsCondition + Integer.toString(currSearchedObj.getNumericId());
                }
                if (!it.hasNext()) continue;
                typoObjOidsCondition = typoObjOidsCondition + ",";
                if (currSearchedObj.getNumericId() < 0) continue;
                typoObjNumericIdsCondition = typoObjNumericIdsCondition + ",";
            }
            if (useNumericIds && typoObjNumericIdsCondition.length() > 0) {
                typoObjQry.append(StringUtils.replaceString((String)pattern, (String)"$TYPOLOGY_OBJ_IDS$", (String)typoObjNumericIdsCondition));
            } else if (typoObjOidsCondition.length() > 0) {
                typoObjQry.append(StringUtils.replaceString((String)pattern, (String)"$TYPOLOGY_OBJ_OIDS$", (String)typoObjOidsCondition));
            }
        }
        return typoObjQry;
    }

    private StringBuffer _composeOrderBy(Map allMetaDataStorageCfgs, List orderByMetaData, boolean isFullTextQry, List publishRepositories, Properties patterns) throws R01MSearchPerformerException {
        StringBuffer outOrderBy = new StringBuffer(50);
        if (allMetaDataStorageCfgs != null && !allMetaDataStorageCfgs.isEmpty()) {
            R01MSearchedOrderByMetaData currSearchedOrderByMetaData = null;
            R01MMetaDataStorageConfig currMetaDataStorageCfg = null;
            Iterator it = orderByMetaData.iterator();
            while (it.hasNext()) {
                currSearchedOrderByMetaData = (R01MSearchedOrderByMetaData)it.next();
                currMetaDataStorageCfg = (R01MMetaDataStorageConfig)allMetaDataStorageCfgs.get(currSearchedOrderByMetaData.getOid());
                String idxField = this._obtainAutonomyMetaDataField(currMetaDataStorageCfg);
                if (idxField.indexOf("$PUBTARGET_OID$") > 0) {
                    if (publishRepositories != null && !publishRepositories.isEmpty()) {
                        R01MSearchedPublishRepository searchedPubRep = (R01MSearchedPublishRepository)publishRepositories.get(0);
                        String repoOid = searchedPubRep.getOid();
                        if (repoOid.indexOf(95) > 0) {
                            repoOid = repoOid.substring(0, repoOid.indexOf(95));
                        }
                        idxField = StringUtils.replaceString((String)idxField, (String)"$PUBTARGET_OID$", (String)repoOid);
                    } else {
                        idxField = StringUtils.replaceString((String)idxField, (String)"$PUBTARGET_OID$", (String)"Inter");
                    }
                }
                if (idxField == null) continue;
                outOrderBy.append(idxField.toUpperCase() + ":");
                if (currMetaDataStorageCfg.getDataType() != null && (currMetaDataStorageCfg.getDataType().equalsIgnoreCase("Date") || this._isNumericallyComparable(currMetaDataStorageCfg.getDataType()))) {
                    if (currSearchedOrderByMetaData.order != null && currSearchedOrderByMetaData.order.equalsIgnoreCase("DESC")) {
                        outOrderBy.append("numberdecreasing");
                    } else {
                        outOrderBy.append("numberincreasing");
                    }
                } else if (currSearchedOrderByMetaData.order != null && currSearchedOrderByMetaData.order.equalsIgnoreCase("DESC")) {
                    outOrderBy.append("reversealphabetical");
                } else {
                    outOrderBy.append("alphabetical");
                }
                if (!it.hasNext()) continue;
                outOrderBy.append('+');
            }
        }
        if (outOrderBy.length() == 0) {
            return null;
        }
        if (DEBUG) {
            R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t        ORDER BY: " + outOrderBy);
        }
        return outOrderBy != null && outOrderBy.length() > 0 ? outOrderBy.insert(0, "sort=") : new StringBuffer("sort=relevance");
    }

    private StringBuffer _composeCatalogsFilter(List structureLabelsAnd, List structureLabelsOr, List geoLabelsAnd, List geoLabelsOr, String labelsANDFilter, String labelsORFilter, String geoLabelsANDFilter, String geoLabelsORFilter) {
        StringBuffer andStructureLabelsQry = this._composeAndCatalogFilter(structureLabelsAnd, labelsANDFilter);
        StringBuffer orStructureLabelsQry = this._composeOrCatalogFilter(structureLabelsOr, labelsORFilter);
        StringBuffer outFilter = new StringBuffer(500);
        String junctionClause = null;
        if (andStructureLabelsQry.length() > 0 || orStructureLabelsQry.length() > 0) {
            junctionClause = andStructureLabelsQry.length() > 0 && orStructureLabelsQry.length() > 0 ? "+AND+" : "";
            outFilter.append(andStructureLabelsQry);
            outFilter.append(junctionClause);
            outFilter.append(orStructureLabelsQry);
        }
        return outFilter;
    }

    private StringBuffer _composeAndCatalogFilter(List labels, String catalogFilterPattern) {
        StringBuffer outFilter = new StringBuffer(100);
        String theCatalogFilterPattern = new String(catalogFilterPattern);
        boolean useNumericIds = XMLProperties.getBoolean((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"autonomy/useStructureCatalogsNumericIds");
        if (labels != null && !labels.isEmpty()) {
            if (useNumericIds) {
                R01MSearchedStructureCatalog currSearchedLabel = null;
                ListIterator labelsIt = labels.listIterator();
                while (labelsIt.hasNext()) {
                    currSearchedLabel = (R01MSearchedStructureCatalog)labelsIt.next();
                    R01MLabel currLabel = R01MCachedCatalogLabelsManager.getLabel((String)currSearchedLabel.getLabelOid());
                    if (currLabel == null) continue;
                    outFilter.append(StringUtils.replaceString((String)theCatalogFilterPattern, (String)"$STRUCTURE_CAT_ID$", (String)Integer.toString(currLabel.getLabelId())));
                    if (!labelsIt.hasNext()) continue;
                    outFilter.append("+AND+");
                }
            } else {
                R01MSearchedStructureCatalog currSearchedLabel = null;
                String labelsOids = "";
                ListIterator labelsIt = labels.listIterator();
                while (labelsIt.hasNext()) {
                    currSearchedLabel = (R01MSearchedStructureCatalog)labelsIt.next();
                    R01MLabel currLabel = R01MCachedCatalogLabelsManager.getLabel((String)currSearchedLabel.getLabelOid());
                    if (currLabel == null) continue;
                    labelsOids = labelsOids + currLabel.getOid();
                    if (!labelsIt.hasNext()) continue;
                    labelsOids = labelsOids + ",";
                }
                outFilter.append(StringUtils.replaceString((String)theCatalogFilterPattern, (String)"$STRUCTURE_CATS_OIDS$", (String)labelsOids));
            }
        }
        return outFilter;
    }

    private StringBuffer _composeOrCatalogFilter(List labels, String catalogFilterPattern) {
        StringBuffer outFilter = new StringBuffer(100);
        String theCatalogFilterPattern = new String(catalogFilterPattern);
        boolean useNumericIds = XMLProperties.getBoolean((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"autonomy/useStructureCatalogsNumericIds");
        String labelsOids = "";
        String labelsIds = "";
        if (labels != null && !labels.isEmpty()) {
            R01MSearchedStructureCatalog currSearchedLabel = null;
            ListIterator labelsIt = labels.listIterator();
            while (labelsIt.hasNext()) {
                currSearchedLabel = (R01MSearchedStructureCatalog)labelsIt.next();
                R01MLabel currLabel = R01MCachedCatalogLabelsManager.getLabel((String)currSearchedLabel.getLabelOid());
                if (currLabel == null) continue;
                labelsOids = labelsOids + currLabel.getOid();
                labelsIds = labelsIds + Integer.toString(currLabel.getLabelId());
                if (!labelsIt.hasNext()) continue;
                labelsOids = labelsOids + ",";
                labelsIds = labelsIds + ",";
            }
        }
        if (useNumericIds) {
            if (labelsIds.length() > 0) {
                outFilter.append(StringUtils.replaceString((String)theCatalogFilterPattern, (String)"$STRUCTURE_CATS_IDS$", (String)labelsIds));
            }
        } else if (labelsOids.length() > 0) {
            outFilter.append(StringUtils.replaceString((String)theCatalogFilterPattern, (String)"$STRUCTURE_CATS_OIDS$", (String)labelsOids));
        }
        return outFilter;
    }

    private StringBuffer _composePublicationsFilter(List publishedRepositories, String pubFilterPattern) {
        StringBuffer outFilter = new StringBuffer(100);
        if (publishedRepositories != null && !publishedRepositories.isEmpty()) {
            String repOidsList = "";
            Iterator pIt = publishedRepositories.iterator();
            while (pIt.hasNext()) {
                R01MSearchedPublishRepository currSearchedRepository = (R01MSearchedPublishRepository)pIt.next();
                if (StringUtils.isEmptyString((String)currSearchedRepository.getOid())) continue;
                repOidsList = repOidsList + "PUBTARGETS_" + currSearchedRepository.getOid();
                if (!pIt.hasNext()) continue;
                repOidsList = repOidsList + ":";
            }
            if (repOidsList.length() > 0) {
                outFilter.append(StringUtils.replaceString((String)pubFilterPattern, (String)"$PUB_TARGETS_OIDS$", (String)repOidsList));
            }
        }
        return outFilter;
    }

    private StringBuffer _composeMetadataFilter(String union, Map searchedMetaDataStorageCfgs, List searchedMetaData, List publishRepositories, Properties patterns) {
        StringBuffer metaDataSubConditions = new StringBuffer(400);
        if (searchedMetaDataStorageCfgs == null || searchedMetaDataStorageCfgs.isEmpty()) {
            return metaDataSubConditions;
        }
        if (searchedMetaData != null && !searchedMetaData.isEmpty()) {
            R01MSearchedMetaData currSearchedMetaData = null;
            R01MMetaDataStorageConfig currSearchedMetaDataStorageCfg = null;
            String metaDataColType = null;
            String metaDataOid = null;
            String appliedMetaDataOperator = null;
            Iterator mdIt = searchedMetaData.iterator();
            while (mdIt.hasNext()) {
                currSearchedMetaData = (R01MSearchedMetaData)mdIt.next();
                if (currSearchedMetaData.getOid().equals("documentLanguage")) continue;
                if (currSearchedMetaData.getOid().equals("fullText")) {
                    metaDataColType = "String(100)";
                    metaDataOid = "fullText";
                    appliedMetaDataOperator = "LIKE";
                } else {
                    currSearchedMetaDataStorageCfg = (R01MMetaDataStorageConfig)searchedMetaDataStorageCfgs.get(currSearchedMetaData.getOid());
                    if (currSearchedMetaDataStorageCfg.getProperties() == null) {
                        R01FLog.to((String)"r01k.searchSentenceBuilder").warning("R01KAutonomyQueryBuilder: Las propiedades del metaDato " + currSearchedMetaDataStorageCfg.getOid() + " son nulas: No se puede saber en qu\u00e9 columna se almancena. No se a\u00f1ade la condici\u00f3n sobre el metaDato");
                    }
                    metaDataColType = currSearchedMetaDataStorageCfg.getDataType();
                    metaDataOid = currSearchedMetaDataStorageCfg.getOid();
                    if (metaDataColType == null || metaDataColType.length() == 0 || currSearchedMetaData.getOperationSelected() == null || currSearchedMetaData.getOperationSelected().length() == 0 || currSearchedMetaData.getValue() == null || currSearchedMetaData.getValue().length() == 0) {
                        R01FLog.to((String)"r01k.searchSentenceBuilder").warning("R01KAutonomyQueryBuilder: Se IGNORA el metaDato " + currSearchedMetaData.getOid() + ": la condici\u00f3n de filtro NO es v\u00e1lida: el tipo de dato configurado para la columna, la operaci\u00f3n seleccionada o el valor buscado del metaDato NO son correctos");
                    } else {
                        appliedMetaDataOperator = currSearchedMetaData.getOperationSelected();
                    }
                }
                String metaDataAutonomyField = this._obtainAutonomyMetaDataField(currSearchedMetaDataStorageCfg);
                String metaDataQuery = this._composeSingleMetaDataFilter(metaDataOid, metaDataColType, metaDataAutonomyField != null ? metaDataAutonomyField : metaDataOid, appliedMetaDataOperator, currSearchedMetaData.getValue(), publishRepositories, patterns);
                if (DEBUG) {
                    R01FLog.to((String)"r01k.searchSentenceBuilder").info("\t\t\t\tmetaData oid=" + currSearchedMetaData.getOid() + ": " + metaDataQuery);
                }
                if (metaDataQuery == null) continue;
                metaDataSubConditions.append(metaDataQuery);
                if (!mdIt.hasNext()) continue;
                metaDataSubConditions.append("+" + union + "+");
            }
            if (metaDataSubConditions.toString().endsWith("+" + union + "+")) {
                metaDataSubConditions.delete(metaDataSubConditions.length() - ("+" + union + "+").length(), metaDataSubConditions.length());
            }
        }
        return metaDataSubConditions;
    }

    private String _composeSingleMetaDataFilter(String metaDataOid, String metaDataTypeDef, String metaDataField, String appliedMetaDataOperator, String metaDataValue, List publishRepositories, Properties patterns) {
        String[] finallyAppliedMetaDataOperatorAndValue;
        if (metaDataField == null || metaDataValue == null || StringUtils.isEmptyString((String)metaDataValue)) {
            return null;
        }
        String metaDataValueFormatted = new String(metaDataValue);
        metaDataValueFormatted.replaceAll("\n", "").replaceAll("\r", "");
        String metaDataType = "String";
        Pattern p = Pattern.compile("(unknown|String|Integer|Long|Short|Float|Double|Date|List|Map|R01MStructureCatalog|R01MGeoCatalog|R01MSearchResultItemPublicationInfo)(?:\\((.+)\\))*");
        Matcher m = p.matcher(metaDataTypeDef);
        boolean directiveValid = m.find();
        if (directiveValid && m.groupCount() >= 2) {
            metaDataType = m.group(1);
        }
        String repository = "";
        String newMetaDataField = "";
        if (metaDataField.startsWith("PUBTARGETS_") && publishRepositories.size() > 0) {
            if (publishRepositories.get(0) instanceof R01MSearchedPublishRepository) {
                repository = ((R01MSearchedPublishRepository)publishRepositories.get(0)).getOid().split("_")[0].toString().toUpperCase();
                newMetaDataField = "PUBTARGETS_" + repository;
            } else {
                repository = publishRepositories.get(0).toString().split("_")[0].toString().toUpperCase();
                newMetaDataField = "PUBTARGETS_" + repository;
            }
        }
        if ((finallyAppliedMetaDataOperatorAndValue = this.transformMetaDataOperatorAndValue(metaDataType, appliedMetaDataOperator, metaDataValueFormatted)) != null) {
            String finallyAppliedMetaOperator = finallyAppliedMetaDataOperatorAndValue[0];
            metaDataValueFormatted = finallyAppliedMetaDataOperatorAndValue[1];
            if (finallyAppliedMetaOperator.equals("LIKE")) {
                if (metaDataType.equalsIgnoreCase("String")) {
                    if (!metaDataOid.equals("fullText")) {
                        String pattern = patterns.getProperty("autonomy.metaDataFilterTxtLIKE.fieldText");
                        HashMap<String, String> vars = new HashMap<String, String>(2);
                        vars.put("FIELD", metaDataField);
                        vars.put("FIELDVALUE", metaDataValueFormatted);
                        return StringUtils.replaceVariableValues((String)pattern, (String)"$", vars);
                    }
                } else {
                    R01FLog.to((String)"r01k.searchSentenceBuilder").warning("R01KAutonomyQueryBuilder: Se ha indicado una operacion LIKE en un metaDato que no es textual... se pasa a una condicion EQUALS");
                    finallyAppliedMetaOperator = "EQ";
                }
            }
            if (finallyAppliedMetaOperator.equals("BEGINNING")) {
                if (metaDataType.equalsIgnoreCase("String")) {
                    if (!metaDataOid.equals("fullText")) {
                        String pattern = patterns.getProperty("autonomy.metaDataFilterTxtSTARTSWITH.fieldText");
                        HashMap<String, String> vars = new HashMap<String, String>(2);
                        vars.put("FIELD", metaDataField);
                        vars.put("FIELDVALUE", metaDataValueFormatted);
                        return StringUtils.replaceVariableValues((String)pattern, (String)"$", vars);
                    }
                } else {
                    R01FLog.to((String)"r01k.searchSentenceBuilder").warning("R01KAutonomyQueryBuilder: Se ha indicado una operacion STARTS_WITH en un metaDato que no es textual... no se trata");
                }
            }
            if (finallyAppliedMetaOperator.equals("ENDING")) {
                if (metaDataType.equalsIgnoreCase("String")) {
                    if (!metaDataOid.equals("fullText")) {
                        String pattern = patterns.getProperty("autonomy.metaDataFilterTxtENDSWITH.fieldText");
                        HashMap<String, String> vars = new HashMap<String, String>(2);
                        vars.put("FIELD", metaDataField);
                        vars.put("FIELDVALUE", metaDataValueFormatted);
                        return StringUtils.replaceVariableValues((String)pattern, (String)"$", vars);
                    }
                } else {
                    R01FLog.to((String)"r01k.searchSentenceBuilder").warning("R01KAutonomyQueryBuilder: Se ha indicado una operacion ENDS_WITH en un metaDato que no es textual... no se trata");
                }
            }
            if (finallyAppliedMetaOperator.equalsIgnoreCase("BETWEEN")) {
                if (metaDataValue.indexOf(",") == 0) {
                    R01FLog.to((String)"r01k.searchSentenceBuilder").warning("R01KAutonomyQueryBuilder: Los valores suministrados para  construir la condici\u00f3n de tipo BETWEEN " + metaDataValue + " NO contienen el separador que se espera (" + "," + "): NO se a\u00f1ade la condici\u00f3n del metadato");
                    return null;
                }
                if (metaDataType.equalsIgnoreCase("String") || metaDataType.equalsIgnoreCase("Date") || metaDataType.equalsIgnoreCase("Long") || metaDataType.equalsIgnoreCase("Short") || metaDataType.equalsIgnoreCase("Double") || metaDataType.equalsIgnoreCase("Integer") || metaDataType.equalsIgnoreCase("Float")) {
                    StringTokenizer metaDataValTokenizer = new StringTokenizer(metaDataValueFormatted, ",");
                    if (metaDataValTokenizer.countTokens() != 2) {
                        R01FLog.to((String)"r01k.searchSentenceBuilder").warning("R01KAutonomyQueryBuilder: El n\u00famero de elementos pasados para  construir la condici\u00f3n de tipo BETWEEN es distino de 2: NO se a\u00f1ade la condici\u00f3n del metadato");
                        return null;
                    }
                    String betweenBeginValStr = metaDataValTokenizer.nextToken();
                    String betweenEndValStr = metaDataValTokenizer.nextToken();
                    if (metaDataType.equalsIgnoreCase("Date")) {
                        betweenBeginValStr = this.extractDateFromQuery(betweenBeginValStr);
                        betweenEndValStr = this.extractDateFromQuery(betweenEndValStr);
                    }
                    if (betweenBeginValStr != null && betweenEndValStr != null) {
                        String rangePattern = patterns.getProperty("autonomy.metaDataFilterRANGE.fieldText");
                        HashMap<String, String> vars = new HashMap<String, String>(2);
                        vars.put("FIELD", newMetaDataField == "" ? metaDataField : newMetaDataField);
                        vars.put("RANGE", betweenBeginValStr + "," + betweenEndValStr);
                        return StringUtils.replaceVariableValues((String)rangePattern, (String)"$", vars);
                    }
                }
            } else if (finallyAppliedMetaOperator.equalsIgnoreCase("EQ")) {
                String pattern = null;
                HashMap<String, String> vars = new HashMap<String, String>(2);
                if (metaDataType.equalsIgnoreCase("String")) {
                    pattern = patterns.getProperty("autonomy.metaDataFilterTxtEQ.fieldText");
                } else if (metaDataType.equalsIgnoreCase("Date")) {
                    pattern = patterns.getProperty("autonomy.metaDataFilterEQ.fieldText");
                    metaDataValueFormatted = this.extractDateFromQuery(metaDataValueFormatted);
                } else if (this._isNumericallyComparable(metaDataType)) {
                    pattern = patterns.getProperty("autonomy.metaDataFilterEQ.fieldText");
                }
                if (pattern != null) {
                    vars.put("FIELD", newMetaDataField == "" ? metaDataField : newMetaDataField);
                    vars.put("FIELDVALUE", metaDataValueFormatted);
                    return StringUtils.replaceVariableValues((String)pattern, (String)"$", vars);
                }
                R01FLog.to((String)"r01k.searchSentenceBuilder").info("R01KAutonomyQueryBuilder: El metaDato " + metaDataField + " tiene un tipo " + metaDataType + " NO valido para una operacion " + "EQ");
            } else {
                if (finallyAppliedMetaOperator.equalsIgnoreCase("NEQ")) {
                    String pattern = null;
                    HashMap<String, String> vars = new HashMap<String, String>(2);
                    if (metaDataType.equalsIgnoreCase("String")) {
                        pattern = patterns.getProperty("autonomy.metaDataFilterTxtNEQ.fieldText");
                    } else if (metaDataType.equalsIgnoreCase("Date")) {
                        pattern = patterns.getProperty("autonomy.metaDataFilterNEQ.fieldText");
                        metaDataValueFormatted = this.extractDateFromQuery(metaDataValueFormatted);
                    } else if (this._isNumericallyComparable(metaDataType)) {
                        pattern = patterns.getProperty("autonomy.metaDataFilterNEQ.fieldText");
                    }
                    vars.put("FIELD", newMetaDataField == "" ? metaDataField : newMetaDataField);
                    vars.put("FIELDVALUE", metaDataValueFormatted);
                    return StringUtils.replaceVariableValues((String)pattern, (String)"$", vars);
                }
                if (finallyAppliedMetaOperator.equalsIgnoreCase("GT")) {
                    String pattern = patterns.getProperty("autonomy.metaDataFilterGT.fieldText");
                    HashMap<String, String> vars = new HashMap<String, String>(2);
                    if (metaDataType.equalsIgnoreCase("Date")) {
                        metaDataValueFormatted = this.extractDateFromQuery(metaDataValueFormatted);
                    }
                    vars.put("FIELD", newMetaDataField == "" ? metaDataField : newMetaDataField);
                    vars.put("FIELDVALUE", metaDataValueFormatted);
                    return StringUtils.replaceVariableValues((String)pattern, (String)"$", vars);
                }
                if (finallyAppliedMetaOperator.equalsIgnoreCase("GTE")) {
                    String pattern = patterns.getProperty("autonomy.metaDataFilterGTE.fieldText");
                    HashMap<String, String> vars = new HashMap<String, String>(2);
                    if (metaDataType.equalsIgnoreCase("Date")) {
                        metaDataValueFormatted = this.extractDateFromQuery(metaDataValueFormatted);
                    }
                    vars.put("FIELD", newMetaDataField == "" ? metaDataField : newMetaDataField);
                    vars.put("FIELDVALUE", metaDataValueFormatted);
                    return StringUtils.replaceVariableValues((String)pattern, (String)"$", vars);
                }
                if (finallyAppliedMetaOperator.equalsIgnoreCase("GTEN")) {
                    String pattern = patterns.getProperty("autonomy.metaDataFilterGTEN.fieldText");
                    HashMap<String, String> vars = new HashMap<String, String>(2);
                    if (metaDataType.equalsIgnoreCase("Date")) {
                        metaDataValueFormatted = this.extractDateFromQuery(metaDataValueFormatted);
                    }
                    vars.put("FIELD", newMetaDataField == "" ? metaDataField : newMetaDataField);
                    vars.put("FIELDVALUE", metaDataValueFormatted);
                    return StringUtils.replaceVariableValues((String)pattern, (String)"$", vars);
                }
                if (finallyAppliedMetaOperator.equalsIgnoreCase("LT")) {
                    String pattern = patterns.getProperty("autonomy.metaDataFilterLT.fieldText");
                    HashMap<String, String> vars = new HashMap<String, String>(2);
                    if (metaDataType.equalsIgnoreCase("Date")) {
                        metaDataValueFormatted = this.extractDateFromQuery(metaDataValueFormatted);
                    }
                    vars.put("FIELD", newMetaDataField == "" ? metaDataField : newMetaDataField);
                    vars.put("FIELDVALUE", metaDataValueFormatted);
                    return StringUtils.replaceVariableValues((String)pattern, (String)"$", vars);
                }
                if (finallyAppliedMetaOperator.equalsIgnoreCase("LTE")) {
                    String pattern = patterns.getProperty("autonomy.metaDataFilterLTE.fieldText");
                    HashMap<String, String> vars = new HashMap<String, String>(2);
                    if (metaDataType.equalsIgnoreCase("Date")) {
                        metaDataValueFormatted = this.extractDateFromQuery(metaDataValueFormatted);
                    }
                    vars.put("FIELD", newMetaDataField == "" ? metaDataField.toUpperCase() : newMetaDataField);
                    vars.put("FIELDVALUE", metaDataValueFormatted);
                    return StringUtils.replaceVariableValues((String)pattern, (String)"$", vars);
                }
                if (finallyAppliedMetaOperator.equalsIgnoreCase("IN")) {
                    String pattern = patterns.getProperty("autonomy.metaDataFilterIN.fieldText");
                    metaDataValueFormatted = metaDataValueFormatted.replace('(', '{');
                    metaDataValueFormatted = metaDataValueFormatted.replace(')', '}');
                    HashMap<String, String> vars = new HashMap<String, String>(2);
                    vars.put("FIELD", metaDataField);
                    vars.put("FIELDVALUE", metaDataValueFormatted);
                    return StringUtils.replaceVariableValues((String)pattern, (String)"$", vars);
                }
                if (finallyAppliedMetaOperator.equalsIgnoreCase("ANY")) {
                    String pattern = patterns.getProperty("autonomy.metaDataFilterANY.fieldText");
                    metaDataValueFormatted = metaDataValueFormatted.replace('(', '{');
                    metaDataValueFormatted = metaDataValueFormatted.replace(')', '}');
                    HashMap<String, String> vars = new HashMap<String, String>(2);
                    vars.put("FIELD", metaDataField);
                    vars.put("FIELDVALUE", metaDataValueFormatted);
                    return StringUtils.replaceVariableValues((String)pattern, (String)"$", vars);
                }
                if (finallyAppliedMetaOperator.equalsIgnoreCase("ALL")) {
                    String pattern = patterns.getProperty("autonomy.metaDataFilterALL.fieldText");
                    metaDataValueFormatted = metaDataValueFormatted.replace('(', '{');
                    metaDataValueFormatted = metaDataValueFormatted.replace(')', '}');
                    HashMap<String, String> vars = new HashMap<String, String>(2);
                    vars.put("FIELD", metaDataField);
                    vars.put("FIELDVALUE", metaDataValueFormatted);
                    return StringUtils.replaceVariableValues((String)pattern, (String)"$", vars);
                }
            }
        }
        return null;
    }

    private boolean _isNumericallyComparable(String metaDataType) {
        return metaDataType.equalsIgnoreCase("Long") || metaDataType.equalsIgnoreCase("Short") || metaDataType.equalsIgnoreCase("Double") || metaDataType.equalsIgnoreCase("Integer") || metaDataType.equalsIgnoreCase("Float");
    }

    private String _composeLangFilter(R01MSearchedMetaData langMetaData, Properties props) {
        String lang;
        String outQry = null;
        if (langMetaData != null && (lang = langMetaData.getValue()) != null && props != null) {
            String langType = props.getProperty("autonomy.languageType_" + lang);
            String fieldCheck = props.getProperty("autonomy.languageFilter.qryParam");
            if (langType != null) {
                outQry = "LanguageType=" + langType;
            }
            if (fieldCheck != null) {
                outQry = outQry + (outQry != null ? "&" : "") + fieldCheck;
            }
            if (outQry != null) {
                outQry = StringUtils.replaceString(outQry, (String)"$LANG$", (String)lang);
            }
        }
        return outQry;
    }

    private String _obtainAutonomyMetaDataField(R01MMetaDataStorageConfig mdStorageCfg) {
        if (mdStorageCfg == null) {
            return null;
        }
        String idxField = mdStorageCfg.getProperty("autonomy.resultSetCol");
        if (idxField != null) {
            String[] idxFieldSplitted = idxField.split("/");
            return idxFieldSplitted[idxFieldSplitted.length - 1];
        }
        return null;
    }

    @Override
    protected String executeGetPatternsKey(String searchMetaDataStorageCfgID) {
        return "autonomy." + searchMetaDataStorageCfgID;
    }

    @Override
    protected void executeCheckMetaDataStorageConfigs(Map metaDataStorageCfgs) throws R01MSearchPerformerException {
    }

    protected Properties executeObtainQueryBuilderPatterns(Map typoStorageProperties) throws R01MSearchPerformerException {
        if (typoStorageProperties == null) {
            throw new R01MSearchPerformerException("No se ha encontrado la secci\u00f3n <properties> en la configuraci\u00f3n de almacenamiento de tipos: revisa el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.queryParts") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.queryParts' en las propiedades de la configuraci\u00f3n de almacenamiento de tipos: revisa el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.stemming") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.stemming' en las propiedades de la configuraci\u00f3n de almacenamiento de tipos: revisa el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.returnAttachments") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.returnAttachments' en las propiedades de la configuraci\u00f3n de almacenamiento de tipos: revisa el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.dontReturnAttachments") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.dontReturnAttachments' en las propiedades de la configuraci\u00f3n de almacenamiento de tipos: revisa el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.fullTextFilter") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.fullTextFilter' en las propiedades de la configuraci\u00f3n de almacenamiento de tipos: revisa el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.storageServerFilter") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.storageServerFilter' en las propiedades de la configuraci\u00f3n de almacenamiento de tipos: revisa el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.storageDataStoreFilter") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.storageDataStoreFilter' en las propiedades de la configuraci\u00f3n de almacenamiento de tipos: revisa el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.storageAreaFilter") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.storageAreaFilter' en las propiedades de la configuraci\u00f3n de almacenamiento de tipos: revisa el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.storageWorkAreaFilter") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.storageWorkAreaFilter' en las propiedades de la configuraci\u00f3n de almacenamiento de tipos: revisa el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.typologyFilter") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.typologyFilter' en las propiedades de la configuraci\u00f3n de almacenamiento de tipos: revisa el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.typoClusterFilter") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.typoClusterFilter' en las propiedades de la configuraci\u00f3n de almacenamiento de tipos: revisa el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.typoFamilyFilter") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.typoFamilyFilter' en las propiedades de la configuraci\u00f3n de almacenamiento de tipos: revisa el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.typoTypeFilter") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.typoTypeFilter' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.andLabelsFilter") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.andLabelsFilter' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.orLabelsFilter") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.orLabelsFilter' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.andGeoLabelsFilter") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.andGeoLabelsFilter' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.orGeoLabelsFilter") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.orGeoLabelsFilter' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.guideTypoFilter") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.guideTypoFilter' en las propiedades de la configuracion del ficheor searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.guideANDLabelsFilter") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.guideANDLabelsFilter' en las propiedades de la configuracion del ficheor searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.guideANDGeoLabelsFilter") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.guideANDGeoLabelsFilter' en las propiedades de la configuracion del ficheor searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.publicationTargetFilter") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.publicationTargetFilter' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.metaDataFilterEQ") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.metaDataFilterEQ' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.metaDataFilterNEQ") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.metaDataFilterNEQ' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.metaDataFilterLT") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.metaDataFilterLT' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.metaDataFilterGT") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.metaDataFilterGT' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.metaDataFilterLTE") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.metaDataFilterLTE' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.metaDataFilterGTE") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.metaDataFilterGTE' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.metaDataFilterGTEN") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.metaDataFilterGTEN' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.metaDataFilterRANGE") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.metaDataFilterRANGE' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.metaDataFilterIN") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.metaDataFilterIN' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.metaDataFilterANY") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.metaDataFilterANY' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.metaDataFilterALL") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.metaDataFilterALL' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.metaDataFilterTxtEQ") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.metaDataFilterTxtEQ' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.metaDataFilterTxtNEQ") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.metaDataFilterTxtNEQ' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.metaDataFilterTxtLIKE") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.metaDataFilterTxtLIKE' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.metaDataFilterTxtSTARTSWITH") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.metaDataFilterTxtSTARTSWITH' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.metaDataFilterTxtENDSWITH") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.metaDataFilterTxtENDSWITH' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.metaDataFilterTxtContains") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.metaDataFilterTxtContains' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.languageFilter") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.languageFilter' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.languageType_es") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.languageType_es' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.languageType_eu") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.languageType_eu' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.languageType_en") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.languageType_en' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.languageType_fr") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.languageType_fr' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.languageType_de") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.languageType_de' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.fullTextSearchDefaultOrderBy") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.fullTextSearchDefaultOrderBy' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (typoStorageProperties.get("autonomy.metaDataSearchDefaultOrderBy") == null) {
            throw new R01MSearchPerformerException("No se ha encontrado el patr\u00f3n 'autonomy.metaDataSearchDefaultOrderBy' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        Properties outProps = new Properties();
        outProps.put("autonomy.queryParts", typoStorageProperties.get("autonomy.queryParts"));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.stemming", (String)typoStorageProperties.get("autonomy.stemming")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.returnAttachments", (String)typoStorageProperties.get("autonomy.returnAttachments")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.dontReturnAttachments", (String)typoStorageProperties.get("autonomy.dontReturnAttachments")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.fullTextFilter", (String)typoStorageProperties.get("autonomy.fullTextFilter")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.storageServerFilter", (String)typoStorageProperties.get("autonomy.storageServerFilter")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.storageDataStoreFilter", (String)typoStorageProperties.get("autonomy.storageDataStoreFilter")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.storageAreaFilter", (String)typoStorageProperties.get("autonomy.storageAreaFilter")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.storageWorkAreaFilter", (String)typoStorageProperties.get("autonomy.storageWorkAreaFilter")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.typologyFilter", (String)typoStorageProperties.get("autonomy.typologyFilter")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.typoClusterFilter", (String)typoStorageProperties.get("autonomy.typoClusterFilter")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.typoFamilyFilter", (String)typoStorageProperties.get("autonomy.typoFamilyFilter")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.typoTypeFilter", (String)typoStorageProperties.get("autonomy.typoTypeFilter")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.andLabelsFilter", (String)typoStorageProperties.get("autonomy.andLabelsFilter")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.orLabelsFilter", (String)typoStorageProperties.get("autonomy.orLabelsFilter")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.andGeoLabelsFilter", (String)typoStorageProperties.get("autonomy.andGeoLabelsFilter")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.orGeoLabelsFilter", (String)typoStorageProperties.get("autonomy.orGeoLabelsFilter")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.guideTypoFilter", (String)typoStorageProperties.get("autonomy.guideTypoFilter")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.guideANDLabelsFilter", (String)typoStorageProperties.get("autonomy.guideANDLabelsFilter")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.guideANDGeoLabelsFilter", (String)typoStorageProperties.get("autonomy.guideANDGeoLabelsFilter")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.publicationTargetFilter", (String)typoStorageProperties.get("autonomy.publicationTargetFilter")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.languageFilter", (String)typoStorageProperties.get("autonomy.languageFilter")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.metaDataFilterEQ", (String)typoStorageProperties.get("autonomy.metaDataFilterEQ")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.metaDataFilterNEQ", (String)typoStorageProperties.get("autonomy.metaDataFilterNEQ")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.metaDataFilterLT", (String)typoStorageProperties.get("autonomy.metaDataFilterLT")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.metaDataFilterGT", (String)typoStorageProperties.get("autonomy.metaDataFilterGT")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.metaDataFilterLTE", (String)typoStorageProperties.get("autonomy.metaDataFilterLTE")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.metaDataFilterGTE", (String)typoStorageProperties.get("autonomy.metaDataFilterGTE")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.metaDataFilterGTEN", (String)typoStorageProperties.get("autonomy.metaDataFilterGTEN")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.metaDataFilterRANGE", (String)typoStorageProperties.get("autonomy.metaDataFilterRANGE")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.metaDataFilterIN", (String)typoStorageProperties.get("autonomy.metaDataFilterIN")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.metaDataFilterANY", (String)typoStorageProperties.get("autonomy.metaDataFilterANY")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.metaDataFilterALL", (String)typoStorageProperties.get("autonomy.metaDataFilterALL")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.metaDataFilterTxtEQ", (String)typoStorageProperties.get("autonomy.metaDataFilterTxtEQ")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.metaDataFilterTxtNEQ", (String)typoStorageProperties.get("autonomy.metaDataFilterTxtNEQ")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.metaDataFilterTxtLIKE", (String)typoStorageProperties.get("autonomy.metaDataFilterTxtLIKE")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.metaDataFilterTxtSTARTSWITH", (String)typoStorageProperties.get("autonomy.metaDataFilterTxtSTARTSWITH")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.metaDataFilterTxtENDSWITH", (String)typoStorageProperties.get("autonomy.metaDataFilterTxtENDSWITH")));
        outProps.putAll((Map<?, ?>)R01KAutonomyQueryBuilder._parsetPattern("autonomy.metaDataFilterTxtContains", (String)typoStorageProperties.get("autonomy.metaDataFilterTxtContains")));
        outProps.put("autonomy.languageType_es", typoStorageProperties.get("autonomy.languageType_es"));
        outProps.put("autonomy.languageType_eu", typoStorageProperties.get("autonomy.languageType_eu"));
        outProps.put("autonomy.languageType_en", typoStorageProperties.get("autonomy.languageType_en"));
        outProps.put("autonomy.languageType_fr", typoStorageProperties.get("autonomy.languageType_fr"));
        outProps.put("autonomy.languageType_de", typoStorageProperties.get("autonomy.languageType_de"));
        outProps.put("autonomy.fullTextSearchDefaultOrderBy", typoStorageProperties.get("autonomy.fullTextSearchDefaultOrderBy"));
        outProps.put("autonomy.metaDataSearchDefaultOrderBy", typoStorageProperties.get("autonomy.metaDataSearchDefaultOrderBy"));
        outProps.put("autonomy.defaultBoostRelevance", typoStorageProperties.get("autonomy.defaultBoostRelevance"));
        return outProps;
    }

    private static Map _parsetPattern(String patternName, String pattern) throws R01MSearchPerformerException {
        Properties outMap = null;
        String patternRegExp = "((?:qryParam|text|fieldText)\\[\\[.*?\\]\\])";
        String subPatternRegExp = "(qryParam|text|fieldText)\\[\\[(.*?)\\]\\]";
        Pattern patternP = Pattern.compile(patternRegExp);
        Matcher patternM = patternP.matcher(pattern);
        if (patternM.find()) {
            outMap = new Properties();
            String subPattern = null;
            Pattern subPatternP = null;
            Matcher subPatternM = null;
            do {
                subPattern = patternM.group();
                subPatternP = Pattern.compile(subPatternRegExp);
                subPatternM = subPatternP.matcher(subPattern);
                if (!subPatternM.find()) continue;
                outMap.put(patternName + "." + subPatternM.group(1), subPatternM.group(2));
            } while (patternM.find());
        } else {
            throw new R01MSearchPerformerException("El patr\u00f3n " + pattern + " para construir la query de autonomy NO es v\u00e1lido. Revisa el fichero searchMetaDataStorage.xml!");
        }
        return outMap;
    }

    public boolean isTypoEmpty(R01MQueryObject qry) {
        return !(qry.getContentFamilies() != null && !qry.getContentFamilies().isEmpty() || qry.getContentTypes() != null && !qry.getContentTypes().isEmpty());
    }

    public boolean isStorageEmpty(R01MQueryObject qry) {
        return !(qry.getDataRepositories() != null && !qry.getDataRepositories().isEmpty() || qry.getAreas() != null && !qry.getAreas().isEmpty() || qry.getWorkAreas() != null && !qry.getWorkAreas().isEmpty());
    }

    public boolean isMetaDataEmpty(R01MQueryObject qry) {
        boolean isEmptyMD;
        boolean bl = isEmptyMD = qry.getMetaData() == null || qry.getMetaData().isEmpty();
        if (!isEmptyMD && qry.getMetaData().size() == 1 && !((R01MSearchedMetaData)qry.getMetaData().get(0)).getKey().equals("documentLanguage")) {
            isEmptyMD = true;
        }
        return isEmptyMD;
    }

    public boolean isFullTextEmpty(R01MQueryObject qry) {
        return StringUtils.isEmptyString((String)qry.getFullText());
    }

    public boolean isQueryEmpty(R01MQueryObject qry) {
        return this.isTypoEmpty(qry) && this.isStorageEmpty(qry) && this.isMetaDataEmpty(qry) && this.isFullTextEmpty(qry);
    }
}

