/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01k.searchorchestrator.persistence;

import com.ejie.r01f.sql.QueryExecutor;
import com.ejie.r01k.ejb.entity.storedguide.R01KStoredGuideCMPLocal;
import com.ejie.r01k.ejb.entity.storedguide.R01KStoredGuideCMPLocalHome;
import com.ejie.r01k.ejb.entity.storedguide.R01KStoredGuideCMPPK;
import com.ejie.r01k.ejb.entity.storedguide.R01KStoredGuideCMPUtil;
import com.ejie.r01k.ejb.entity.storedguide.R01KStoredGuideCMPValue;
import com.ejie.r01k.ejb.entity.storedquery.R01KStoredQueryCMPLocal;
import com.ejie.r01k.ejb.entity.storedquery.R01KStoredQueryCMPLocalHome;
import com.ejie.r01k.ejb.entity.storedquery.R01KStoredQueryCMPPK;
import com.ejie.r01k.ejb.entity.storedquery.R01KStoredQueryCMPUtil;
import com.ejie.r01m.exceptions.R01MSearchStorageException;
import com.ejie.r01m.services.bzd.R01MSearchOrchestatorPersistenceManagerBzd;
import com.ejie.r01m.utils.R01MConstants;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

public class R01KSearchOrchestatorPersistenceManager
implements R01MSearchOrchestatorPersistenceManagerBzd {
    public boolean existsQuery(String queryOid) throws R01MSearchStorageException {
        try {
            QueryExecutor qryExec = new QueryExecutor(R01MConstants.SEARCHENGINE_APPCODE, "indexerConnection");
            List data = qryExec.executeQuery("SELECT GUID_01 FROM R01K01S00 WHERE GUID_01='" + queryOid + "'");
            return data != null && !data.isEmpty();
        }
        catch (SQLException sqlEx) {
            throw new R01MSearchStorageException("Error al ejecutar la query de carga del XML de b\u00fasqueda con oid=" + queryOid + ":\r\n" + sqlEx.getMessage(), (Exception)sqlEx);
        }
    }

    public String execLoadQuery(String queryOid) throws R01MSearchStorageException {
        if (queryOid == null) {
            throw new R01MSearchStorageException("No se puede cargar la query ya que el oid es nulo");
        }
        try {
            HashMap<String, String> pk = new HashMap<String, String>();
            pk.put("GUID_01", queryOid);
            QueryExecutor qryExec = new QueryExecutor(R01MConstants.SEARCHENGINE_APPCODE, "indexerConnection");
            return qryExec.loadCLOB("R01K51T00", "BUSQUEDA_01", pk);
        }
        catch (SQLException sqlEx) {
            throw new R01MSearchStorageException("Error al ejecutar la query de carga del XML de b\u00fasqueda con oid=" + queryOid + ":\r\n" + sqlEx.getMessage(), (Exception)sqlEx);
        }
    }

    public void execSaveQuery(String qryOid, String qryXML) throws R01MSearchStorageException {
        if (qryOid == null || qryXML == null) {
            throw new R01MSearchStorageException("No se puede guardar la query ya que el OID o el XML de query es nulo!");
        }
        try {
            R01KStoredQueryCMPLocalHome storedQueryEntityLocalHome = R01KStoredQueryCMPUtil.getLocalHome();
            R01KStoredQueryCMPPK storedQueryCMPPK = new R01KStoredQueryCMPPK();
            storedQueryCMPPK.setOidStoredQuery(qryOid);
            R01KStoredQueryCMPLocal storedQueryCMPLocal = null;
            try {
                storedQueryCMPLocal = storedQueryEntityLocalHome.findByPrimaryKey(storedQueryCMPPK);
                storedQueryCMPLocal.setStoredQueryXml(qryXML);
            }
            catch (FinderException findEx) {
                storedQueryCMPLocal = storedQueryEntityLocalHome.create(qryOid, qryXML);
            }
        }
        catch (NamingException ex) {
            throw new R01MSearchStorageException((Exception)ex);
        }
        catch (CreateException ex) {
            throw new R01MSearchStorageException((Exception)((Object)ex));
        }
    }

    public String execLoadGuide(String guideOid) throws R01MSearchStorageException {
        if (guideOid == null) {
            throw new R01MSearchStorageException("No se puede cargar la guia ya que el oid es nulo");
        }
        try {
            HashMap<String, String> pk = new HashMap<String, String>();
            pk.put("GUID_50", guideOid);
            QueryExecutor qryExec = new QueryExecutor(R01MConstants.SEARCHENGINE_APPCODE, "indexerConnection");
            return qryExec.loadCLOB("R01K50T00", "GUIDE_50", pk);
        }
        catch (SQLException sqlEx) {
            throw new R01MSearchStorageException("Error al ejecutar la query de carga del XML de guia de navegacion con oid=" + guideOid + ":\r\n" + sqlEx.getMessage(), (Exception)sqlEx);
        }
    }

    public void execReloadGuidesInCache() throws R01MSearchStorageException {
    }

    public void execSaveGuide(String guideOid, String guideDesc, String guideXML) throws R01MSearchStorageException {
        if (guideOid == null || guideXML == null) {
            throw new R01MSearchStorageException("No se puede guardar la guia de navegacion ya que el OID o el XML es nulo!");
        }
        try {
            R01KStoredGuideCMPLocalHome storedGuideEntityLocalHome = R01KStoredGuideCMPUtil.getLocalHome();
            R01KStoredGuideCMPPK storedGuideCMPPK = new R01KStoredGuideCMPPK();
            storedGuideCMPPK.setOidStoredGuide(guideOid);
            R01KStoredGuideCMPValue vo = new R01KStoredGuideCMPValue();
            vo.setOidStoredGuide(guideOid);
            vo.setStoredGuideDescription(guideDesc);
            vo.setStoredGuideXml(guideXML);
            R01KStoredGuideCMPLocal storedGuideCMPLocal = null;
            try {
                storedGuideCMPLocal = storedGuideEntityLocalHome.findByPrimaryKey(storedGuideCMPPK);
                storedGuideCMPLocal.setR01KStoredGuideCMPValue(vo);
            }
            catch (FinderException findEx) {
                storedGuideCMPLocal = storedGuideEntityLocalHome.create(vo);
            }
        }
        catch (NamingException ex) {
            throw new R01MSearchStorageException((Exception)ex);
        }
        catch (CreateException ex) {
            throw new R01MSearchStorageException((Exception)((Object)ex));
        }
    }

    public void execDeleteGuide(String guideOid) throws R01MSearchStorageException {
        if (guideOid == null) {
            throw new R01MSearchStorageException("No se puede borrar la guia de navegacion ya que el OID es nulo!");
        }
        try {
            R01KStoredGuideCMPLocalHome storedGuideEntityLocalHome = R01KStoredGuideCMPUtil.getLocalHome();
            R01KStoredGuideCMPPK storedGuideCMPPK = new R01KStoredGuideCMPPK();
            storedGuideCMPPK.setOidStoredGuide(guideOid);
            R01KStoredGuideCMPLocal storedGuideCMPLocal = null;
            storedGuideCMPLocal = storedGuideEntityLocalHome.findByPrimaryKey(storedGuideCMPPK);
            storedGuideCMPLocal.remove();
        }
        catch (NamingException ex) {
            throw new R01MSearchStorageException((Exception)ex);
        }
        catch (FinderException findEx) {
            throw new R01MSearchStorageException((Exception)((Object)findEx));
        }
        catch (RemoveException ex) {
            throw new R01MSearchStorageException((Exception)((Object)ex));
        }
    }

    public List execLoadGuideList() throws R01MSearchStorageException {
        try {
            ArrayList<String[]> outGuideList = new ArrayList<String[]>();
            R01KStoredGuideCMPLocalHome storedGuideEntityLocalHome = R01KStoredGuideCMPUtil.getLocalHome();
            Collection cmps = storedGuideEntityLocalHome.findAll();
            R01KStoredGuideCMPLocal storedGuideCMPLocal2 = null;
            if (cmps != null) {
                R01KStoredGuideCMPValue currCMPValue = null;
                for (R01KStoredGuideCMPLocal storedGuideCMPLocal2 : cmps) {
                    currCMPValue = storedGuideCMPLocal2.getR01KStoredGuideCMPValue();
                    outGuideList.add(new String[]{currCMPValue.getOidStoredGuide(), currCMPValue.getStoredGuideDescription()});
                }
            }
            return outGuideList;
        }
        catch (FinderException findEx) {
            throw new R01MSearchStorageException((Exception)((Object)findEx));
        }
        catch (NamingException ex) {
            throw new R01MSearchStorageException((Exception)ex);
        }
    }

    public String execLoadXMLGuide(String guideOid) throws R01MSearchStorageException {
        R01KStoredGuideCMPPK storedGuideCMPPK = new R01KStoredGuideCMPPK();
        storedGuideCMPPK.setOidStoredGuide(guideOid);
        try {
            R01KStoredGuideCMPLocal storedGuideEntityLocal = R01KStoredGuideCMPUtil.getLocalHome().findByPrimaryKey(storedGuideCMPPK);
            return storedGuideEntityLocal.getStoredGuideXml();
        }
        catch (FinderException findEx) {
            throw new R01MSearchStorageException((Exception)((Object)findEx));
        }
        catch (NamingException ex) {
            throw new R01MSearchStorageException((Exception)ex);
        }
    }
}

