/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01k.searchorchestrator.initmultiplexors;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.process.Job;
import com.ejie.r01f.process.JobManager;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01k.searchorchestrator.R01KSearchSourceInitEventListenerImpl;
import com.ejie.r01k.searchorchestrator.initmultiplexors.R01KSearchSessionInitMultiplexor;
import com.ejie.r01k.searchorchestrator.searchperformers.R01KSearchPerformer;
import com.ejie.r01m.exceptions.R01MSearchInitializeException;
import com.ejie.r01m.exceptions.R01MSearchPerformerException;
import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuideElement;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.searchengine.results.R01MSearchSourceInitResult;
import com.ejie.r01m.utils.R01MConstants;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;

public class R01KJobManagerInitMultiplexorImpl
implements R01KSearchSessionInitMultiplexor {
    public R01KJobManagerInitMultiplexorImpl() {
    }

    public R01KJobManagerInitMultiplexorImpl(Properties props) {
        this();
        if (props != null) {
            if (props.get("minThreads") != null) {
                JobManagerSingletonHolder.MIN_THREADS = Integer.parseInt(props.getProperty("minThreads", "1"));
            }
            if (props.get("maxThreads") != null) {
                JobManagerSingletonHolder.MAX_THREADS = Integer.parseInt(props.getProperty("maxThreads", "5"));
            }
            if (props.get("maxThreadIdleTime") != null) {
                JobManagerSingletonHolder.MAX_THREADIDLETIME = Integer.parseInt(props.getProperty("maxThreadIdleTime", "-1"));
            }
            if (props.get("jobsEndTestMillis") != null) {
                JobManagerSingletonHolder.JOBS_END_TEST_MILLIS = Integer.parseInt(props.getProperty("jobsEndTestMillis", "500"));
            }
            if (props.get("jobsEndMaxMillis") != null) {
                JobManagerSingletonHolder.JOBS_END_MAX_MILLIS = Integer.parseInt(props.getProperty("jobsEndMaxMillis", Integer.toString(4 * Integer.parseInt(props.getProperty("jobsEndTestMillis")))));
            }
            if (props.get("debug") != null) {
                JobManagerSingletonHolder.DEBUG = props.getProperty("debug").equals("true");
            }
        }
    }

    @Override
    public void multiplexInitPhase(String searchSessionOid, String searchSessionLang, R01MQueryObject qry, R01MSearchGuideElement[] guideFutureElements, boolean lazy, Map srcsSearchPerformers, R01KSearchSourceInitEventListenerImpl srcSearchInitializedCallBackObj) throws R01MSearchInitializeException {
        Method srcSearchInitializedCallBackMethod = null;
        Method initMethod = null;
        try {
            srcSearchInitializedCallBackMethod = R01KSearchSourceInitEventListenerImpl.class.getMethod("searchInitializedInSource", R01MSearchSourceInitResult.class);
            initMethod = R01KSearchPerformer.class.getMethod("init", String.class, String.class, String.class, R01MQueryObject.class, R01MSearchGuideElement[].class, Boolean.TYPE);
        }
        catch (NoSuchMethodException nsmEx) {
            nsmEx.printStackTrace(System.out);
        }
        ArrayList<Job> initJobs = new ArrayList<Job>();
        Map.Entry me2 = null;
        String currSrcOid = null;
        R01KSearchPerformer currSrcSearchPerformer = null;
        for (Map.Entry me2 : srcsSearchPerformers.entrySet()) {
            currSrcOid = (String)me2.getKey();
            currSrcSearchPerformer = (R01KSearchPerformer)me2.getValue();
            Job initJob = new Job(searchSessionOid + "-" + currSrcOid, (Object)currSrcSearchPerformer, initMethod, new Object[]{searchSessionOid, searchSessionLang, currSrcOid, qry, guideFutureElements, lazy}, (Object)srcSearchInitializedCallBackObj, srcSearchInitializedCallBackMethod);
            initJobs.add(initJob);
        }
        if (JobManagerSingletonHolder.DEBUG) {
            R01FLog.to((String)"r01k.initMultiplexor").info("\r\n\r\n\r\n+++++++++++++++++++++++++++++++++++++++++++++++++\r\n::::Comienza la multiplexaci\u00f3n de las fases init()");
        }
        JobManagerSingletonHolder.jobManagerInstance.startAll(initJobs);
        JobManager.Stats stats = null;
        try {
            int maxCount = 0;
            do {
                stats = JobManagerSingletonHolder.jobManagerInstance.getStats();
                if (stats.jobsInProgress > 0) {
                    Thread.sleep(JobManagerSingletonHolder.JOBS_END_TEST_MILLIS);
                }
                maxCount += JobManagerSingletonHolder.JOBS_END_TEST_MILLIS;
                if (!JobManagerSingletonHolder.DEBUG) continue;
                R01FLog.to((String)"r01k.initMultiplexor").info("\t...aun no han finalizado todas las inicializaciones (JobsInProgress=" + stats.jobsInProgress + ", overAllMillis=" + maxCount + ")");
            } while (stats.jobsInProgress > 0 && maxCount < JobManagerSingletonHolder.JOBS_END_MAX_MILLIS);
            if (JobManagerSingletonHolder.DEBUG) {
                R01FLog.to((String)"r01k.initMultiplexor").info(":::::FIN de la multiplexaci\u00f3n de las fases init()\r\n+++++++++++++++++++++++++++++++++++++++++++++++++\r\n\r\n\r\n\r\n");
            }
            if (stats.jobsInProgress == initJobs.size()) {
                throw new R01MSearchInitializeException("Ninguno de los or\u00edgenes de resultados ha respondido a la fase de inicializaci\u00f3n init() en el tiempo m\u00e1ximo especificado: " + JobManagerSingletonHolder.JOBS_END_MAX_MILLIS + " msg");
            }
            if (stats.jobsInProgress > 0 && maxCount >= JobManagerSingletonHolder.JOBS_END_MAX_MILLIS) {
                R01FLog.to((String)"r01k.initMultiplexor").warning("ATENCION!!: Ha habido un origen de resultados de b\u00fasqueda que NO ha respondido a la fase init() en el tiempo m\u00e1ximo especificado: " + JobManagerSingletonHolder.JOBS_END_MAX_MILLIS + " msg. Sin embargo, el resto de or\u00edgenes pueden haber respondido...");
            }
            if (JobManagerSingletonHolder.DEBUG) {
                R01FLog.to((String)"r01k.initMultiplexor").info(">>> JobManager TEST: Resultados de la ejecuci\u00f3n (los objetos pager): ");
                for (Job currJob : initJobs) {
                    try {
                        if (currJob.isEnded()) {
                            Object result = currJob.getResult();
                            R01FLog.to((String)"r01k.initMultiplexor").info("\tResultado>>>>> " + (result == null ? "null" : "no null"));
                            continue;
                        }
                        R01FLog.to((String)"r01k.initMultiplexor").info("\tEl trabajo " + currJob.getJobId() + " NO se ha terminado: started=" + currJob.hasBeenStarted() + " ended=" + currJob.isEnded());
                    }
                    catch (R01MSearchPerformerException spEx) {
                        R01FLog.to((String)"r01k.initMultiplexor").info("\tResultado>>>> El origen ha lanzado una excepcion: " + spEx.getMessage());
                        spEx.printStackTrace(System.out);
                    }
                    catch (Exception ex) {
                        R01FLog.to((String)"r01k.initMultiplexor").info("\tResultado>>>> El origen ha lanzado una excepcion: " + ex.getMessage());
                        ex.printStackTrace(System.out);
                    }
                }
            }
        }
        catch (InterruptedException intEx) {
            R01FLog.to((String)"r01k.initMultiplexor").warning("Interrupted Exception en el JobManagerInitMultiplexor: " + intEx.getMessage());
            intEx.printStackTrace(System.out);
        }
    }

    private static final class JobManagerSingletonHolder {
        static int MIN_THREADS = XMLProperties.getInt((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"initMultiplexor/multiplexorImpl[@id='jobManager']/properties/minThreads");
        static int MAX_THREADS = XMLProperties.getInt((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"initMultiplexor/multiplexorImpl[@id='jobManager']/properties/maxThreads");
        static int MAX_THREADIDLETIME = XMLProperties.getInt((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"initMultiplexor/multiplexorImpl[@id='jobManager']/properties/maxThreadIdleTime");
        static int JOBS_END_TEST_MILLIS = XMLProperties.getInt((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"initMultiplexor/multiplexorImpl[@id='jobManager']/properties/jobsEndTestMillis");
        static int JOBS_END_MAX_MILLIS = XMLProperties.getInt((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"initMultiplexor/multiplexorImpl[@id='jobManager']/properties/jobsEndMaxMillis");
        static boolean DEBUG = XMLProperties.getBoolean((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"initMultiplexor/multiplexorImpl[@id='jobManager']/properties/debug");
        static final JobManager jobManagerInstance;

        private JobManagerSingletonHolder() {
        }

        static {
            if (MIN_THREADS == Integer.MIN_VALUE) {
                R01FLog.to((String)"r01k.initMultiplexor").warning("Se esta utilizando el multiplexor de llamadas a Init() en base al JobManager. No se ha definido el n\u00famero m\u00ednimo de threads en la propiedad initMultiplexor/multiplexorImpl[@id='jobManager']/properties/minTreads del fichero r01k.properties. Se toma el valor 1");
                MIN_THREADS = 1;
            }
            if (MAX_THREADS == Integer.MAX_VALUE) {
                R01FLog.to((String)"r01k.initMultiplexor").warning("Se esta utilizando el multiplexor de llamadas a Init() en base al JobManager. No se ha definido el n\u00famero m\u00e1ximo de threads en la propiedad initMultiplexor/multiplexorImpl[@id='jobManager']/properties/maxTreads del fichero r01k.properties. Se toma el valor 5");
                MAX_THREADS = 5;
            }
            if (MAX_THREADIDLETIME == Integer.MAX_VALUE) {
                R01FLog.to((String)"r01k.initMultiplexor").warning("Se esta utilizando el multiplexor de llamadas a Init() en base al JobManager. No se ha definido el tiempo m\u00e1ximo que un thread permanece en estado idle en el pool antes de ser destruido (propiedad initMultiplexor/multiplexorImpl[@id='jobManager']/properties/maxTreadIdleTime del fichero r01k.properties). Los threads creados permanecen indefinidadmente en el pool de threads!");
                MAX_THREADIDLETIME = -1;
            }
            if (JOBS_END_TEST_MILLIS == Integer.MAX_VALUE) {
                R01FLog.to((String)"r01k.initMultiplexor").warning("Se esta utilizando el multiplexor de llamadas a Init() en base al JobManager. No se ha definido el n\u00famero de milisegundos que se duerme el thread entre comprobaciones para ver si ha terminado la llamamda (propiedad initMultiplexor/multiplexorImpl[@id='jobManager']/properties/jobsEndTestMillis). Se toma el valor 500 - 0,5 sg -");
                JOBS_END_TEST_MILLIS = 500;
            }
            if (JOBS_END_MAX_MILLIS == Integer.MAX_VALUE) {
                R01FLog.to((String)"r01k.initMultiplexor").warning("Se esta utilizando el multiplexor de llamadas a Init() en base al JobManager. No se ha definido el n\u00famero de milisegundos que puede durar como m\u00e1ximo la fase init() (propiedad initMultiplexor/multiplexorImpl[@id='jobManager']/properties/jobsEndMaxMillis). Se toma el valor 4 veces el tiempo entre comprobaciones = " + 4 * JOBS_END_TEST_MILLIS);
                JOBS_END_MAX_MILLIS = 4 * JOBS_END_TEST_MILLIS;
            }
            if (DEBUG) {
                R01FLog.to((String)"r01k.initMultiplexor").warning("Las trazas del JobManager para el initMultiplexor est\u00e1n DESHABILITADAS. Se pueden habilitar poniendo a true la propiedad initMultiplexor/multiplexorImpl[@id='jobManager']/properties/maxTreads del fichero r01k.properties");
            }
            StringBuffer debugSb = new StringBuffer(327);
            debugSb.append("Configuracion del JobManager para inicializaci\u00f3n de B\u00fasquedas (DEBUG=" + DEBUG + "):\r\n" + "\tN\u00famero m\u00ednimo de threads en el pool: " + MIN_THREADS + "\r\n" + "\tN\u00famero m\u00e1ximo de threads en el pool: " + MAX_THREADS + "\r\n" + "\tTiempo m\u00e1ximo de permanencia de un thread en el pool en estado idle (-1=infinito): ");
            debugSb.append(MAX_THREADIDLETIME);
            debugSb.append(" msg\r\n\tPeriodo de comprobaci\u00f3n de finalizaci\u00f3n de trabajos multiplexados: ");
            debugSb.append(JOBS_END_TEST_MILLIS);
            debugSb.append(" msg\r\n\tTiempo m\u00e1ximo de finalizaci\u00f3n de los trabajos multiplexados: ");
            debugSb.append(JOBS_END_MAX_MILLIS);
            debugSb.append("msg \r\n");
            R01FLog.to((String)"r01k.initMultiplexor").warning(debugSb.toString());
            jobManagerInstance = new JobManager(DEBUG, MIN_THREADS, MAX_THREADS, MAX_THREADIDLETIME);
        }
    }
}

