/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01k.searchorchestrator.indexer.queueprocessors;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.net.HttpClient;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01k.ejb.entity.indexabledatafile.R01KIndexableDataFileCMPPK;
import com.ejie.r01k.ejb.entity.indexabledatafile.R01KIndexableDataFileCMPUtil;
import com.ejie.r01k.ejb.entity.indexabledocument.R01KIndexableDocumentCMPPK;
import com.ejie.r01k.ejb.entity.indexabledocument.R01KIndexableDocumentCMPUtil;
import com.ejie.r01k.ejb.entity.indexinfo.R01KIndexInfoCMPValue;
import com.ejie.r01k.searchorchestrator.indexer.R01KSearchOrchestratorIndexer;
import com.ejie.r01k.searchorchestrator.indexer.indexers.R01KApacheMetaVarsIndexer;
import com.ejie.r01k.searchorchestrator.indexer.indexers.R01KDataBaseIndexer;
import com.ejie.r01k.searchorchestrator.indexer.indexers.R01KSearchEngineIndexer;
import com.ejie.r01k.traceindex.R01KTraceIndexHelper;
import com.ejie.r01k.utils.R01KTraceUtils;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MSearchIndexerException;
import com.ejie.r01m.exceptions.R01MSearchIndexerQueueProcessorException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.misc.R01MOperationInModelObjectResult;
import com.ejie.r01m.objects.portalmodel.R01MPage;
import com.ejie.r01m.objects.searchengine.indexer.R01MBaseIndexableObject;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableContent;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexablePortalPage;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MContentModelAPI;
import com.ejie.r01m.services.R01MPortalDataAPI;
import com.ejie.r01m.services.R01MPortalManagerAPI;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.portal.R01MPortalPathHelpper;
import com.ejie.r01p.objects.searchengine.indexer.R01PIndexStatesByIndexer;
import com.ejie.r01p.objects.searchengine.indexer.R01PIndexStatesByIndexerElement;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

public class R01KObjectsToIndexProcessor {
    private static final String[] ObjectTypesDescription = new String[]{"CONTENIDO", "DOCUMENTO", "ARCHIVO DE DATOS", "PORTAL", "PORTAL_PAGE"};
    private static final String LOG_TYPE_ID = "r01k.indexerProcessor";
    private static boolean DEBUG = R01FLog.getLogLevel((String)"r01k.indexerProcessor").intValue() != Level.OFF.intValue();
    private static final boolean TRACE_INDEX = XMLProperties.getBoolean((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"traceIndex", (boolean)false);
    private static final String INIT_VA_SECTION_PATTERN = XMLProperties.getString((String)R01MConstants.API_APPCODE, (String)"indexerManager/portalModel/initVaSectionPattern", (String)"<!-- \\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\* INIT Visual Area: $visualAreaType$ \\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\* -->");
    private static final String END_VA_SECTION_PATTERN = XMLProperties.getString((String)R01MConstants.API_APPCODE, (String)"indexerManager/portalModel/endVaSectionPattern", (String)"<!-- \\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\* END Visual Area: $visualAreaType$ \\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\* -->");
    private transient R01MUserContext _userCtx;

    public R01KObjectsToIndexProcessor() {
    }

    public R01KObjectsToIndexProcessor(R01MUserContext newUserCtx) {
        this._userCtx = newUserCtx;
    }

    public R01MOperationInModelObjectResult inmediateIndexObject(String objOid, int objType, R01KSearchEngineIndexer[] indexers) throws R01MSearchIndexerQueueProcessorException {
        R01MOperationInModelObjectResult result;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% INICIO INDEXACION: OID - " + objOid + ", TIPO: " + R01MConstants.OBJECT_DESCS[objType] + " %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        }
        if ((result = this._indexObject(indexers, objOid, objType)) != null && !result.isOperationOK()) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\n\n\t[[[[[[[[[[[[[[[[[[[[[[[[[ERROR INDEXADOR: OID - " + objOid + ", TIPO: " + R01MConstants.OBJECT_DESCS[objType] + "]] ]]]]]]]]]]]]]]]]]\r\n" + result.getMsg());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n%%%%% INDEXACION objeto " + objOid + " de tipo " + ObjectTypesDescription[objType] + " indexado " + (result != null && result.isOperationOK() ? "CORRECTAMENTE" : "CON ERROR!!"));
            R01FLog.to((String)LOG_TYPE_ID).info("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% INDEXACION FINALIZADA: OID - " + objOid + ", TIPO: " + R01MConstants.OBJECT_DESCS[objType] + " %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\r\n\r\n\r\n\r\n\r\n");
        }
        if (result != null && !result.isOperationOK()) {
            throw new R01MSearchIndexerQueueProcessorException(result.getMsg());
        }
        return result;
    }

    public R01MOperationInModelObjectResult inmediateIndexObject(String objOid, int objType, R01KSearchEngineIndexer[] indexers, List<String> metadataFileNames) throws R01MSearchIndexerQueueProcessorException {
        R01MOperationInModelObjectResult result;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% INICIO INDEXACION " + (metadataFileNames == null ? "" : org.apache.commons.lang.StringUtils.join((Object[])metadataFileNames.toArray(), (String)",")) + ": OID - " + objOid + ", TIPO: " + R01MConstants.OBJECT_DESCS[objType] + " %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
            if (indexers != null && indexers.length > 0) {
                for (int i = 0; i < indexers.length; ++i) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n%%%%%%% Indexador:" + indexers[i].getClass().getName());
                }
            }
        }
        if ((result = this._indexObject(indexers, objOid, objType, metadataFileNames)) != null && !result.isOperationOK()) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\n\n\t[[[[[[[[[[[[[[[[[[[[[[[[[ERROR INDEXADOR " + (metadataFileNames == null ? "" : org.apache.commons.lang.StringUtils.join((Object[])metadataFileNames.toArray(), (String)",")) + ": OID - " + objOid + ", TIPO: " + R01MConstants.OBJECT_DESCS[objType] + "]] ]]]]]]]]]]]]]]]]]\r\n" + result.getMsg());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n%%%%% INDEXACION objeto " + objOid + " de tipo " + ObjectTypesDescription[objType] + " indexado " + (result != null && result.isOperationOK() ? "CORRECTAMENTE" : "CON ERROR!!"));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% INDEXACION FINALIZADA " + (metadataFileNames == null ? "" : org.apache.commons.lang.StringUtils.join((Object[])metadataFileNames.toArray(), (String)",")) + ": OID - " + objOid + ", TIPO: " + R01MConstants.OBJECT_DESCS[objType] + " %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\r\n\r\n\r\n\r\n\r\n");
        }
        if (result != null && !result.isOperationOK()) {
            throw new R01MSearchIndexerQueueProcessorException(result.getMsg());
        }
        return result;
    }

    public R01MOperationInModelObjectResult inmediateUnIndexObject(String objOid, int objType, R01KSearchEngineIndexer[] indexers) throws R01MSearchIndexerQueueProcessorException {
        R01MOperationInModelObjectResult result;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% INICIO DESINDEXACION: OID - " + objOid + ", TIPO: " + R01MConstants.OBJECT_DESCS[objType] + " %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
            if (indexers != null && indexers.length > 0) {
                for (int i = 0; i < indexers.length; ++i) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n%%%%%%% Indexador:" + indexers[i].getClass().getName());
                }
            }
        }
        if ((result = this._unIndexObject(indexers, objOid, objType)) != null && !result.isOperationOK()) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\n\n\t[[[[[[[[[[[[[[[[[[[[[[[[[ERROR INDEXADOR: OID - " + objOid + ", TIPO: " + R01MConstants.OBJECT_DESCS[objType] + "]] ]]]]]]]]]]]]]]]]]\r\n" + result.getMsg());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n%%%%% DESINDEXACION objeto " + objOid + " de tipo " + ObjectTypesDescription[objType] + " indexado " + (result != null && result.isOperationOK() ? "CORRECTAMENTE" : "CON ERROR!!"));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% DESINDEXACION FINALIZADA: OID - " + objOid + ", TIPO: " + R01MConstants.OBJECT_DESCS[objType] + " %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\r\n\r\n\r\n\r\n\r\n");
        }
        if (result != null && !result.isOperationOK()) {
            throw new R01MSearchIndexerQueueProcessorException(result.getMsg());
        }
        return result;
    }

    private R01MOperationInModelObjectResult _indexObject(R01KSearchEngineIndexer[] indexers, String objOid, int objType) {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("EJECUCION DE LA INDEXACION completa, del objeto " + objOid + " de tipo " + (ObjectTypesDescription[objType] == null ? "[Tipo de objeto a indexar " + String.valueOf(objType) + "no reconocido]" : ObjectTypesDescription[objType]));
        }
        R01MOperationInModelObjectResult result = null;
        switch (objType) {
            case 0: 
            case 1: 
            case 2: {
                result = this._indexContentModelObject(indexers, objOid, objType, null);
                break;
            }
            case 4: {
                result = this._indexPortalModelObject(indexers, objOid, objType, null);
                break;
            }
            default: {
                if (!DEBUG) break;
                R01FLog.to((String)LOG_TYPE_ID).warning("\r\n\r\n_indexObject: Tipo de objeto no v\u00e1lido.");
            }
        }
        return result;
    }

    private R01MOperationInModelObjectResult _indexObject(R01KSearchEngineIndexer[] indexers, String objOid, int objType, List<String> metadataFileNames) {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("EJECUCION DE LA INDEXACION parcial, del objeto " + objOid + " de tipo " + (ObjectTypesDescription[objType] == null ? "[Tipo de objeto a indexar " + String.valueOf(objType) + "no reconocido]" : ObjectTypesDescription[objType]));
            if (metadataFileNames != null && !metadataFileNames.isEmpty()) {
                for (String metFile : metadataFileNames) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\r\n\tFile:" + metFile);
                }
            }
        }
        R01MOperationInModelObjectResult result = null;
        switch (objType) {
            case 0: 
            case 1: 
            case 2: {
                result = this._indexContentModelObject(indexers, objOid, objType, metadataFileNames);
                break;
            }
            case 4: {
                result = this._indexPortalModelObject(indexers, objOid, objType, metadataFileNames);
                break;
            }
            default: {
                if (!DEBUG) break;
                R01FLog.to((String)LOG_TYPE_ID).warning("\r\n\r\n_indexObject: Tipo de objeto no v\u00e1lido.");
            }
        }
        return result;
    }

    private R01MOperationInModelObjectResult _indexContentModelObject(R01KSearchEngineIndexer[] indexers, String objOid, int objType, List<String> metadataFileNames) {
        String errorMsg;
        block46: {
            errorMsg = null;
            String contentOid = null;
            R01MContentModelAPI contentAPI = R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx);
            if (errorMsg == null) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n%%%%% INDEXACION PASO 1: Obtener los oid de contenido, documento y dataFile a indexar a partir del oid del objeto a indexar (" + objOid + "-tipo " + R01MConstants.OBJECT_DESCS[objType] + ")");
                }
                switch (objType) {
                    case 0: {
                        contentOid = objOid;
                        break;
                    }
                    case 1: {
                        contentOid = this._getContentOidFromDocumentOid(objOid, contentAPI);
                        if (contentOid != null) break;
                        errorMsg = "No se ha encontrado el oid del contenido padre del documento de oid " + objOid;
                        break;
                    }
                    case 2: {
                        contentOid = this._getContentOidFromDatafileOid(objOid, contentAPI);
                        if (contentOid != null) break;
                        errorMsg = "No se ha encontrado el oid del contenido padre del documento de oid " + objOid;
                        break;
                    }
                    default: {
                        errorMsg = "Tipo de objeto desconocido. No se indexa";
                    }
                }
            }
            R01MIndexableContent idxCont = null;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n%%%%% INDEXACION PASO 2: Obtener el contenido indexable para el objeto " + objOid + " de tipo " + ObjectTypesDescription[objType]);
            }
            boolean contentExists = false;
            try {
                contentExists = contentAPI.checkContentExistence(contentOid);
            }
            catch (R01MSecurityException secEx) {
                secEx.printStackTrace(System.out);
                errorMsg = "Error de seguridad en la indexacion del objeto " + objOid + " de tipo " + (ObjectTypesDescription[objType] == null ? "[Tipo de objeto a indexar " + String.valueOf(objType) + "no reconocido]" : ObjectTypesDescription[objType]) + ": " + secEx.getDetailedMessage();
            }
            catch (R01MContentModelException cmEx) {
                cmEx.printStackTrace(System.out);
                errorMsg = "Error en la indexacion del objeto " + objOid + " de tipo " + (ObjectTypesDescription[objType] == null ? "[Tipo de objeto a indexar " + String.valueOf(objType) + "no reconocido]" : ObjectTypesDescription[objType]) + ": " + cmEx.getDetailedMessage();
            }
            if (objType == 0 || objType == 1) {
                if (contentExists) {
                    try {
                        idxCont = contentAPI.getIndexableContent(contentOid);
                    }
                    catch (R01MSecurityException secEx) {
                        secEx.printStackTrace(System.out);
                        errorMsg = "Error de seguridad en la indexacion del objeto " + objOid + " de tipo " + (ObjectTypesDescription[objType] == null ? "[Tipo de objeto a indexar " + String.valueOf(objType) + "no reconocido]" : ObjectTypesDescription[objType]) + ": " + secEx.getDetailedMessage();
                    }
                    catch (R01MContentModelException cmEx) {
                        cmEx.printStackTrace(System.out);
                        errorMsg = "Error en el modelo de contenidos para la indexacion del objeto " + objOid + " de tipo " + (ObjectTypesDescription[objType] == null ? "[Tipo de objeto a indexar " + String.valueOf(objType) + "no reconocido]" : ObjectTypesDescription[objType]) + ": " + cmEx.getDetailedMessage();
                    }
                } else {
                    errorMsg = "Error al cargar el objeto indexable: el contenido no existe: " + objOid;
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).warning("Al indexar el objeto " + objOid + " " + "de tipo " + objType + ". " + "El contenido " + contentOid + " no existe por lo que el contenido " + "se habr\u00e1 borrado y desindexado en un mensaje que se ha tratado " + "con anterioridad");
                    }
                }
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n%%%%% INDEXACION PASO 3: Indexar el objeto indexable " + objOid + " de tipo " + ObjectTypesDescription[objType]);
            }
            if (errorMsg == null) {
                try {
                    if (contentExists) {
                        if (objType == 0 || objType == 1) {
                            if (DEBUG) {
                                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n%%%%% INDEXACION PASO 3.1: Indexando el objeto indexable " + objOid + " de tipo " + ObjectTypesDescription[objType]);
                            }
                            Properties props = null;
                            if (objType == 1) {
                                props = new Properties();
                                props.put("objectOid", objOid);
                                props.put("contentOid", idxCont.getOid());
                            }
                            R01KSearchOrchestratorIndexer soIndexer = new R01KSearchOrchestratorIndexer();
                            R01PIndexStatesByIndexer contentIndexerStates = null;
                            try {
                                contentIndexerStates = soIndexer.loadContentIndexerState(contentAPI, contentOid);
                            }
                            catch (R01MSearchIndexerException siEx) {
                                R01FLog.to((String)LOG_TYPE_ID).warning("No se ha podido cargar el XML de estados de indexaci\u00f3n para el contenido  " + contentOid + " en la indexaci\u00f3n " + "del objeto " + objOid + ". " + "Se tratar\u00e1n de lanzar las indexaciones pero no se " + "actualizar\u00e1 el estado en BD.");
                            }
                            Map<String, R01PIndexStatesByIndexer> documentIndexerStatesMap = null;
                            ArrayList<String> documentOids = new ArrayList<String>();
                            try {
                                if (objType == 1) {
                                    documentOids.add(objOid);
                                } else if (objType == 0 && idxCont.getDocuments() != null && !idxCont.getDocuments().isEmpty()) {
                                    documentOids = new ArrayList(idxCont.getDocuments().keySet());
                                }
                                documentIndexerStatesMap = soIndexer.loadDocumentIndexersStateMap(contentAPI, documentOids);
                            }
                            catch (R01MSearchIndexerException siEx) {
                                R01FLog.to((String)LOG_TYPE_ID).warning("No se ha podido cargar el XML de estados de indexaci\u00f3n para el documento / objeto " + objOid + ". " + "Se tratar\u00e1n de lanzar las indexaciones pero no se " + "actualizar\u00e1 el estado en BD.");
                            }
                            R01PIndexStatesByIndexer documentIndexersStates = documentIndexerStatesMap.get(objOid);
                            R01KIndexInfoCMPValue traceVO = new R01KIndexInfoCMPValue();
                            if (DEBUG) {
                                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n%%%%% INDEXACION PASO 3.2: Ejecutando los indexadores del objeto indexable " + objOid + " de tipo " + ObjectTypesDescription[objType]);
                            }
                            for (int j = 0; j < indexers.length; ++j) {
                                try {
                                    if (DEBUG) {
                                        R01FLog.to((String)LOG_TYPE_ID).info("Lanzando el indexador " + indexers[j].getClass().getName() + ": " + new Date() + " para el objeto " + objOid);
                                    }
                                    if (TRACE_INDEX) {
                                        traceVO.setContentOid(contentOid);
                                        traceVO.setObjectOid(idxCont.getOid());
                                        String indexerName = indexers[j].getClass().getName();
                                        traceVO.setIndexerType(indexerName.substring(indexerName.lastIndexOf(".") + 1, indexerName.length()));
                                        traceVO.setIndexerStep(Integer.parseInt("2" + j));
                                        R01KTraceUtils.traceIndex(traceVO, 1, null);
                                    }
                                    if (indexers[j] instanceof R01KDataBaseIndexer || indexers[j] instanceof R01KApacheMetaVarsIndexer || !R01MConstants.TYPES_EXCLUDED_TO_INDEX.contains(idxCont.getTypo().getType().getOid())) {
                                        indexers[j].index("contenidos", (R01MBaseIndexableObject)idxCont, objType, metadataFileNames, props);
                                    }
                                    if (TRACE_INDEX) {
                                        traceVO.setIndexerStep(Integer.parseInt("2" + j));
                                        R01KTraceUtils.traceIndex(traceVO, 2, null);
                                    }
                                    if (DEBUG) {
                                        R01FLog.to((String)LOG_TYPE_ID).info("El indexador " + indexers[j].getClass().getName() + " ha finalizado: " + new Date());
                                    }
                                    this._updateIndexerState(contentOid, documentOids, contentAPI, indexers[j], contentIndexerStates, documentIndexersStates, R01KSearchEngineIndexer.INDEX_FINISHED_OK, "OK: The last indexing finished correctly.");
                                    continue;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    R01FLog.to((String)LOG_TYPE_ID).warning("Error en el indexador '" + indexers[j].getClass() + "' " + "al indexar el objeto " + objOid + " de " + "tipo " + ObjectTypesDescription[objType] + ". " + "Error: " + e.getMessage());
                                    this._updateIndexerState(contentOid, documentOids, contentAPI, indexers[j], contentIndexerStates, documentIndexersStates, R01KSearchEngineIndexer.INDEX_FINISHED_ERRORS, "NOOK: The last indexing finished with errors.");
                                    if (!TRACE_INDEX || traceVO == null) continue;
                                    R01KTraceUtils.traceIndex(traceVO, 3, e);
                                }
                            }
                            break block46;
                        }
                        R01FLog.to((String)LOG_TYPE_ID).warning("El tipo de objeto " + Integer.toString(objType) + " NO es valido para su indexacion");
                        break block46;
                    }
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).warning("Al indexar el objeto " + objOid + " de tipo " + objType + ". El contenido " + contentOid + " no existe por lo que el contenido se habr\u00e1 borrado y desindexado en un mensaje que se ha tratado con anterioridad");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.out);
                    errorMsg = "Error desconocido en la indexacion del objeto " + (objOid != null ? objOid : " [Oid del objeto a indexar es null]") + " tipo " + (ObjectTypesDescription[objType] == null ? "[Tipo de objeto a indexar " + String.valueOf(objType) + "no reconocido]" : ObjectTypesDescription[objType]) + ": " + (ex.getMessage() == null ? "NULL" : ex.getMessage());
                }
                catch (Throwable th) {
                    th.printStackTrace(System.out);
                    errorMsg = "Error desconocido en la indexacion del objeto " + (objOid != null ? objOid : " [Oid del objeto a indexar es null]") + " tipo " + (ObjectTypesDescription[objType] == null ? "[Tipo de objeto a indexar " + String.valueOf(objType) + "no reconocido]" : ObjectTypesDescription[objType]) + ": " + (th.getMessage() == null ? "NULL" : th.getMessage());
                }
            } else {
                R01FLog.to((String)LOG_TYPE_ID).warning("ERROR en la PREPARACI\u00d3N DE LA INDEXACION del objeto " + (objOid != null ? objOid : " [Oid del objeto a indexar es null]") + " tipo " + (ObjectTypesDescription[objType] == null ? "[Tipo de objeto a indexar " + String.valueOf(objType) + "no reconocido]" : ObjectTypesDescription[objType]) + ": " + (errorMsg != null ? errorMsg : " el mensaje de error es null"));
            }
        }
        if (errorMsg != null) {
            return new R01MOperationInModelObjectResult(objOid, objType, false, errorMsg);
        }
        return new R01MOperationInModelObjectResult(objOid, objType, true, "OK");
    }

    private void _updateIndexerState(String contentOid, List<String> documentOids, R01MContentModelAPI contentAPI, R01KSearchEngineIndexer indexer, R01PIndexStatesByIndexer contentIndexerStates, R01PIndexStatesByIndexer documentIndexersStates, int finalState, String message) throws R01MSearchIndexerException {
        if (indexer.getIndexerType() == R01KSearchEngineIndexer.CONTENT_TYPE_INDEXER) {
            if (contentIndexerStates != null && contentIndexerStates.getIndexers() != null) {
                for (R01PIndexStatesByIndexerElement indexerState : contentIndexerStates.getIndexers()) {
                    if (!indexerState.getIndexerClassName().equals(indexer.getClass().getName())) continue;
                    indexerState.setMessage(message);
                    if (indexerState.getState() != R01KSearchEngineIndexer.INDEX_RUNNING) continue;
                    indexerState.setState(finalState);
                    indexerState.setMessage(message);
                }
            }
            try {
                contentAPI.setContentIndexersState(contentOid, XOManager.getXML((String)R01MConstants.INDEXABLEOBJECTS_MAPFILE, (Object)contentIndexerStates));
            }
            catch (R01MSecurityException secEx) {
                throw new R01MSearchIndexerException("Error al actualizar el XML de estado de las indexaciones para el contenido " + contentOid, (Exception)((Object)secEx));
            }
            catch (R01MContentModelException cmEx) {
                throw new R01MSearchIndexerException("Error al actualizar el XML de estado de las indexaciones para el contenido " + contentOid, (Exception)((Object)cmEx));
            }
            catch (XOMarshallerException xoEx) {
                throw new R01MSearchIndexerException("Error al pasar el objeto a XML de estado de las indexaciones para el contenido " + contentOid, (Exception)((Object)xoEx));
            }
        } else if (indexer.getIndexerType() == R01KSearchEngineIndexer.DOCUMENT_TYPE_INDEXER && documentOids != null && !documentOids.isEmpty()) {
            if (documentIndexersStates != null && documentIndexersStates.getIndexers() != null) {
                for (R01PIndexStatesByIndexerElement indexerState : documentIndexersStates.getIndexers()) {
                    if (!indexerState.getIndexerClassName().equals(indexer.getClass().getName())) continue;
                    indexerState.setMessage(message);
                    if (indexerState.getState() != R01KSearchEngineIndexer.INDEX_RUNNING) continue;
                    indexerState.setState(finalState);
                    indexerState.setMessage(message);
                }
            }
            for (String currentDocumentOid : documentOids) {
                try {
                    contentAPI.setDocumentIndexersState(currentDocumentOid, XOManager.getXML((String)R01MConstants.INDEXABLEOBJECTS_MAPFILE, (Object)documentIndexersStates));
                }
                catch (R01MSecurityException secEx) {
                    throw new R01MSearchIndexerException("Error al actualizar el XML de estado de las indexaciones para el documento " + currentDocumentOid, (Exception)((Object)secEx));
                }
                catch (R01MContentModelException cmEx) {
                    throw new R01MSearchIndexerException("Error al actualizar el XML de estado de las indexaciones para el documento " + currentDocumentOid, (Exception)((Object)cmEx));
                }
                catch (XOMarshallerException xoEx) {
                    throw new R01MSearchIndexerException("Error al pasar el objeto a XML de estado de las indexaciones para el documento " + currentDocumentOid, (Exception)((Object)xoEx));
                }
            }
        }
    }

    private R01MOperationInModelObjectResult _indexPortalModelObject(R01KSearchEngineIndexer[] indexers, String objOid, int objType, List<String> metadataFileNames) {
        String errorMsg;
        block27: {
            errorMsg = null;
            String portalOid = null;
            R01MPage portalPage = null;
            R01MPortalManagerAPI modelAPI = R01MClientFactory.getPortalModelAPI((R01MUserContext)this._userCtx, null);
            try {
                portalOid = modelAPI.getPageParentPortalOid(objOid);
                if (portalOid == null) {
                    errorMsg = "NO se ha podido obtener el portal al que pertenece la pagina " + objOid;
                    break block27;
                }
                modelAPI.setPortalOid(portalOid);
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n%%%%% INDEXACION PASO 1: Cargar la pagina de portal");
                }
                portalPage = modelAPI.loadPortalPage(objOid);
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n%%%%% INDEXACION PASO 2: Convertir la pagina de portal en su version indexable");
                }
                R01MIndexablePortalPage idxPage = null;
                idxPage = modelAPI.getIndexablePage(portalPage.getOid());
                if (portalPage.isIndexActive()) {
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n%%%%% INDEXACION PASO 3: Indexar el objeto indexable " + objOid + " de tipo " + ObjectTypesDescription[objType]);
                    }
                    for (int j = 0; j < indexers.length; ++j) {
                        try {
                            if ((indexers[j] instanceof R01KDataBaseIndexer || indexers[j] instanceof R01KApacheMetaVarsIndexer || !R01MConstants.TYPES_EXCLUDED_TO_INDEX.contains(R01MConstants.OBJECT_DESCS[objType])) && objType == 4) {
                                indexers[j].index("contenidos", (R01MBaseIndexableObject)idxPage, 4, metadataFileNames, null);
                                continue;
                            }
                            R01FLog.to((String)LOG_TYPE_ID).warning("El tipo de objeto " + objType + " NO es valido para su indexacion");
                            continue;
                        }
                        catch (R01MSearchIndexerException siEx) {
                            siEx.printStackTrace(System.out);
                            errorMsg = "Error en la indexacion del objeto " + objOid + " tipo " + ObjectTypesDescription[objType] + ": " + siEx.getDetailedMessage();
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace(System.out);
                            errorMsg = "Error desconocido en la indexacion del objeto " + objOid + " tipo " + ObjectTypesDescription[objType] + ": " + ex.getMessage();
                            continue;
                        }
                        catch (Throwable th) {
                            th.printStackTrace(System.out);
                            errorMsg = "Error desconocido en la indexacion del objeto " + objOid + " tipo " + ObjectTypesDescription[objType] + ": " + th.getMessage();
                        }
                    }
                    HashMap parametersToPost = new HashMap();
                    R01MPortalDataAPI portalInDS = new R01MPortalDataAPI(this._userCtx, portalOid);
                    Map langAVs = portalPage.getVisualAreasGroupedByLanguage();
                    if (langAVs == null || langAVs.isEmpty()) break block27;
                    for (String language : langAVs.keySet()) {
                        String pageURI = R01MPortalPathHelpper.obtainPortalPageURL((String)portalOid, (String)portalPage.getInternalName(), (String)language);
                        String pageURL = R01MConstants.URL_APACHEADMIN + pageURI;
                        if (DEBUG) {
                            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n%%%%% INDEXACION PASO 4: Obtener el html con el contenido de pagina: " + pageURL);
                        }
                        HttpClient httpClient = new HttpClient(pageURL, parametersToPost);
                        InputStream serverReturnStream = null;
                        boolean uploadPage = true;
                        try {
                            serverReturnStream = httpClient.sendPostHttpCall();
                        }
                        catch (IOException ioExc) {
                            R01FLog.to((String)LOG_TYPE_ID).severe("Error al recoger el html de p\u00e1gina con completo. Error:" + ioExc.getMessage());
                            uploadPage = false;
                        }
                        if (!uploadPage) continue;
                        try {
                            String htmlPage = StringUtils.loadFromStream((InputStream)serverReturnStream);
                            List visualAreaType = XMLProperties.getPropertyList((String)R01MConstants.API_APPCODE, (String)"indexerManager/portalModel/notIndexablesVAs/visualAreaOid");
                            if (!visualAreaType.isEmpty()) {
                                StringBuffer vaToExcludePattern = new StringBuffer();
                                vaToExcludePattern.append("(?:");
                                Iterator itVisualAreaTypes = visualAreaType.iterator();
                                while (itVisualAreaTypes.hasNext()) {
                                    String currentVA = (String)itVisualAreaTypes.next();
                                    vaToExcludePattern.append(currentVA);
                                    if (!itVisualAreaTypes.hasNext()) continue;
                                    vaToExcludePattern.append('|');
                                }
                                vaToExcludePattern.append(')');
                                HashMap<String, String> varValues = new HashMap<String, String>();
                                varValues.put("visualAreaType", vaToExcludePattern.toString());
                                StringBuffer composedPattern = new StringBuffer();
                                composedPattern.append(StringUtils.replaceVariableValues((String)INIT_VA_SECTION_PATTERN, (char)'$', varValues)).append(".*?").append(StringUtils.replaceVariableValues((String)END_VA_SECTION_PATTERN, (char)'$', varValues));
                                Pattern regex = Pattern.compile(composedPattern.toString(), 32);
                                Matcher regexMatcher = regex.matcher(htmlPage);
                                StringBuffer buf = new StringBuffer();
                                boolean htmlUpdated = false;
                                while (regexMatcher.find()) {
                                    regexMatcher.appendReplacement(buf, "");
                                    htmlUpdated = true;
                                }
                                if (htmlUpdated) {
                                    regexMatcher.appendTail(buf);
                                    htmlPage = buf.toString();
                                }
                            }
                            portalInDS.uploadPortalResource(9, portalOid + "-" + (portalPage.getInternalName() != null ? portalPage.getInternalName() : "UndefinedPage"), language != null ? language : "UndefinedLanguage", portalOid + "-" + (portalPage.getInternalName() != null ? portalPage.getInternalName() : "UndefinedPage") + "_" + (language != null ? language : "UndefinedLanguage") + ".html", (InputStream)new ByteArrayInputStream(htmlPage.getBytes()));
                        }
                        catch (IOException ex) {
                            if (!DEBUG) continue;
                            R01FLog.to((String)LOG_TYPE_ID).warning("Error al leer el stream de la carga de p\u00e1gina para indexar. Error" + ex.getMessage());
                        }
                    }
                    break block27;
                }
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n%%%%% INDEXACION: La p\u00e1gina se debe desindexar. No est\u00e1 marcada como indexable (flag de indexaci\u00f3n desactivado): " + portalOid);
                    this._unIndexObject(indexers, objOid, objType);
                }
                R01KSearchEngineIndexer indexerImpl = (R01KSearchEngineIndexer)ReflectionUtils.getObjectInstance((String)"com.ejie.r01k.searchorchestrator.indexer.indexers.R01KApacheMetaVarsIndexer");
                indexerImpl.index("contenidos", (R01MBaseIndexableObject)idxPage, 4, metadataFileNames, null);
            }
            catch (R01MPortalModelException pmEx) {
                errorMsg = "Error al obtener el portal al que pertenece la pagina " + objOid + ": " + pmEx.getMessage();
                pmEx.printStackTrace(System.out);
            }
            catch (R01MSecurityException secEx) {
                errorMsg = "Error de seguridad al cargar la pagina de portal " + objOid + ": " + secEx.getDetailedMessage();
                secEx.printStackTrace(System.out);
            }
            catch (Exception ex) {
                errorMsg = "Error desconocido al cargar la pagina de portal " + objOid + ": " + ex.getMessage();
                ex.printStackTrace(System.out);
            }
        }
        if (errorMsg != null) {
            return new R01MOperationInModelObjectResult(objOid, objType, false, errorMsg);
        }
        return new R01MOperationInModelObjectResult(objOid, objType, true, "OK");
    }

    private R01MOperationInModelObjectResult _unIndexObject(R01KSearchEngineIndexer[] indexers, String objOid, int objType) {
        String errorMsg = null;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("...desindesando el objeto " + objOid + " de tipo " + ObjectTypesDescription[objType]);
        }
        switch (objType) {
            case 0: {
                for (int j = 0; j < indexers.length; ++j) {
                    try {
                        indexers[j].unIndex("contenidos", objOid, objType, R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED);
                        continue;
                    }
                    catch (R01MSearchIndexerException sEx) {
                        sEx.printStackTrace(System.out);
                        errorMsg = "Error al desindexar el objeto " + objOid + " de tipo " + ObjectTypesDescription[objType] + ": " + sEx.getDetailedMessage();
                    }
                }
                break;
            }
            case 1: {
                try {
                    String contentOid = null;
                    R01KIndexableDocumentCMPPK pk = new R01KIndexableDocumentCMPPK(objOid);
                    try {
                        contentOid = R01KIndexableDocumentCMPUtil.getLocalHome().findByPrimaryKey(pk).getOidContent();
                    }
                    catch (EJBException ejbEx) {
                        ejbEx.printStackTrace(System.out);
                        throw new R01MSearchIndexerException("UNINDEX Document  >>>> Error al obtenet el Oid del contenido para el documento " + objOid + "-" + ejbEx.getMessage(), (Exception)((Object)ejbEx));
                    }
                    catch (FinderException findEx) {
                        if (DEBUG) {
                            R01FLog.to((String)"r01k.index").info("UNINDEX Content  >>>> Al obtenet el Oid del contenido para el documento " + objOid + ". No se elimina el registro ya que no exist\u00eda: " + findEx.getMessage());
                        }
                    }
                    catch (NamingException nameEx) {
                        nameEx.printStackTrace(System.out);
                        throw new R01MSearchIndexerException("UNINDEX Document  >>>> Error al obtenet el Oid del contenido para el documento " + objOid + "-" + nameEx.getMessage(), (Exception)nameEx);
                    }
                    if (R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx).checkContentExistence(contentOid)) {
                        R01MIndexableContent idxCont = R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx).getIndexableContent(contentOid);
                        if (idxCont == null || idxCont.getDocuments() == null) break;
                        idxCont.getDocuments().remove(objOid);
                        R01MContent content = R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx).loadContent(contentOid);
                        R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx).uploadIndexableObject(content, idxCont);
                        for (int j = 0; j < indexers.length; ++j) {
                            try {
                                indexers[j].unIndex("contenidos", (R01MBaseIndexableObject)idxCont, objOid, objType, R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED);
                                continue;
                            }
                            catch (R01MSearchIndexerException sEx) {
                                sEx.printStackTrace(System.out);
                                errorMsg = "Error al desindexar el objeto " + objOid + " de tipo " + ObjectTypesDescription[objType] + ": " + sEx.getDetailedMessage();
                            }
                        }
                        break;
                    }
                    if (!DEBUG) break;
                    R01FLog.to((String)LOG_TYPE_ID).warning("Al desindexar el documento " + objOid + ". El contenido padre " + contentOid + " no existe por lo que el contenido se habr\u00e1 borrado y desindexado en un mensaje que se ha tratado con anterioridad");
                }
                catch (R01MSecurityException secEx) {
                    secEx.printStackTrace(System.out);
                    errorMsg = "Error de seguridad en la indexacion del objeto " + (objOid != null ? objOid : " [Oid del objeto a indexar es null]") + " tipo " + (ObjectTypesDescription[objType] == null ? "[Tipo de objeto a indexar " + String.valueOf(objType) + "no reconocido]" : ObjectTypesDescription[objType]) + ": " + (secEx.getDetailedMessage() == null ? "NULL" : secEx.getDetailedMessage());
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.out);
                    errorMsg = "Error desconocido en la indexacion del objeto " + (objOid != null ? objOid : " [Oid del objeto a indexar es null]") + " tipo " + (ObjectTypesDescription[objType] == null ? "[Tipo de objeto a indexar " + String.valueOf(objType) + "no reconocido]" : ObjectTypesDescription[objType]) + ": " + (ex.getMessage() == null ? "NULL" : ex.getMessage());
                }
                catch (Throwable th) {
                    th.printStackTrace(System.out);
                    errorMsg = "Error desconocido en la indexacion del objeto " + (objOid != null ? objOid : " [Oid del objeto a indexar es null]") + " tipo " + (ObjectTypesDescription[objType] == null ? "[Tipo de objeto a indexar " + String.valueOf(objType) + "no reconocido]" : ObjectTypesDescription[objType]) + ": " + (th.getMessage() == null ? "NULL" : th.getMessage());
                }
                break;
            }
            case 4: {
                for (int j = 0; j < indexers.length; ++j) {
                    try {
                        indexers[j].unIndex("contenidos", objOid, objType, R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED);
                        continue;
                    }
                    catch (R01MSearchIndexerException sEx) {
                        sEx.printStackTrace(System.out);
                        errorMsg = "Error al desindexar el objeto " + objOid + " de tipo " + ObjectTypesDescription[objType] + ": " + sEx.getDetailedMessage();
                    }
                }
                break;
            }
            default: {
                R01FLog.to((String)LOG_TYPE_ID).warning("El tipo de objeto " + objType + " NO es valido para su indexacion");
            }
        }
        if (errorMsg != null) {
            return new R01MOperationInModelObjectResult(objOid, objType, false, errorMsg);
        }
        return new R01MOperationInModelObjectResult(objOid, objType, true, "OK");
    }

    private String _getContentOidFromDocumentOid(String documentOid, R01MContentModelAPI contentAPI) {
        String contentOid;
        block10: {
            block9: {
                contentOid = null;
                R01KIndexableDocumentCMPPK pkDocument = new R01KIndexableDocumentCMPPK(documentOid);
                try {
                    contentOid = R01KIndexableDocumentCMPUtil.getLocalHome().findByPrimaryKey(pkDocument).getOidContent();
                }
                catch (NamingException namEx) {
                    if (DEBUG) {
                        R01FLog.to((String)"r01k.index").info("R01KObjectsToIndexProcessor - _getContentOidFromDocumentOid >>>> Al obtener el Oid del contenido para el documento " + documentOid + " desde las tablas de r01k. Error: " + namEx.getMessage());
                    }
                }
                catch (FinderException findEx) {
                    if (!DEBUG) break block9;
                    R01FLog.to((String)"r01k.index").info("R01KObjectsToIndexProcessor - _getContentOidFromDocumentOid >>>> Al obtener el Oid del contenido para el documento " + documentOid + " desde las tablas de r01k. No se puede obtener el contenido padre: " + findEx.getMessage());
                }
            }
            if (StringUtils.isEmptyString((String)contentOid)) {
                try {
                    contentOid = contentAPI.getDocumentParentContent(documentOid);
                }
                catch (R01MContentModelException cmEx) {
                    if (DEBUG) {
                        R01FLog.to((String)"r01k.index").warning("R01KObjectsToIndexProcessor - _getContentOidFromDocumentOid >>>> Al obtener el Oid del contenido para el documento " + documentOid + " a trav\u00e9s del API de contenido. Error: " + cmEx.getMessage());
                    }
                }
                catch (R01MSecurityException secEx) {
                    if (!DEBUG) break block10;
                    R01FLog.to((String)"r01k.index").warning("R01KObjectsToIndexProcessor - _getContentOidFromDocumentOid >>>> Al obtener el Oid del contenido para el documento " + documentOid + " a trav\u00e9s del API de contenido. Error: " + secEx.getMessage());
                }
            }
        }
        return contentOid;
    }

    private String _getContentOidFromDatafileOid(String datafileOid, R01MContentModelAPI contentAPI) {
        String documentOid;
        String contentOid;
        block9: {
            block8: {
                contentOid = null;
                documentOid = null;
                R01KIndexableDataFileCMPPK pkDatafile = new R01KIndexableDataFileCMPPK(datafileOid);
                try {
                    documentOid = R01KIndexableDataFileCMPUtil.getLocalHome().findByPrimaryKey(pkDatafile).getOidDocument();
                }
                catch (NamingException namEx) {
                    if (DEBUG) {
                        R01FLog.to((String)"r01k.index").info("R01KObjectsToIndexProcessor - _getContentOidFromDatafileOid >>>> Al obtener el Oid del documento para el datafile " + datafileOid + " desde las tablas de r01k. Error: " + namEx.getMessage());
                    }
                }
                catch (FinderException findEx) {
                    if (!DEBUG) break block8;
                    R01FLog.to((String)"r01k.index").info("R01KObjectsToIndexProcessor - _getContentOidFromDatafileOid >>>> Al obtener el Oid del documento para el datafile " + datafileOid + " desde las tablas de r01k. No se puede obtener el documento padre: " + findEx.getMessage());
                }
            }
            if (StringUtils.isEmptyString((String)documentOid)) {
                try {
                    documentOid = contentAPI.getDataFileParentDocument(datafileOid);
                }
                catch (R01MContentModelException cmEx) {
                    if (!DEBUG) break block9;
                    R01FLog.to((String)"r01k.index").warning("R01KObjectsToIndexProcessor - _getContentOidFromDatafileOid >>>> Al obtener el Oid del documento para el datafile " + datafileOid + " a trav\u00e9s del API de contenido. Error: " + cmEx.getMessage());
                }
            }
        }
        if (!StringUtils.isEmptyString((String)documentOid)) {
            contentOid = this._getContentOidFromDocumentOid(documentOid, contentAPI);
        }
        return contentOid;
    }
}

