/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01k.searchorchestrator.indexer.queueprocessors;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class R01KObjectsToIndexFilter
implements Serializable {
    private static final long serialVersionUID = 6480959735557065292L;
    private String _filter;
    private ObjectFilter _objFilter;
    private TypoFilter _typoFilter;
    private StorageFilter _storageFilter;

    public R01KObjectsToIndexFilter() {
    }

    public R01KObjectsToIndexFilter(String newFilter) {
        this();
        this.setFilter(newFilter);
    }

    public String composeDebugInfo() {
        return "\r\nObjectsToIndexFilter: " + this._filter + (this.getObjectFilter() != null ? this.getObjectFilter().composeDebugInfo() : "") + (this.getTypoFilter() != null ? this.getTypoFilter().composeDebugInfo() : "") + (this.getStorageFilter() != null ? this.getStorageFilter().composeDebugInfo() : "");
    }

    public String getFilter() {
        return this._filter;
    }

    public void setFilter(String theFilter) {
        this._filter = theFilter;
        this._parseFilter();
    }

    public ObjectFilter getObjectFilter() {
        return this._objFilter;
    }

    public void setObjectFilter(String theObjOid, String theObjType) {
        this._objFilter = new ObjectFilter(theObjOid, theObjType);
    }

    public TypoFilter getTypoFilter() {
        return this._typoFilter;
    }

    public void setTypoFilter(String theCluster, String theFamily, String theType) {
        this._typoFilter = new TypoFilter(theCluster, theFamily, theType);
    }

    public StorageFilter getStorageFilter() {
        return this._storageFilter;
    }

    public void setStorageFilter(String theServer, String theStore, String theArea, String theWorkArea) {
        this._storageFilter = new StorageFilter(theServer, theStore, theArea, theWorkArea);
    }

    private void _parseFilter() {
        if (this._filter == null) {
            return;
        }
        Pattern p = null;
        Matcher m = null;
        String patternStr = null;
        patternStr = ".*byObj:([^:]+)-([^;]+).*";
        p = Pattern.compile(patternStr);
        m = p.matcher(this._filter);
        if (m.find()) {
            this.setObjectFilter(m.group(1), m.group(2));
        }
        if ((m = (p = Pattern.compile(patternStr = ".*byObjTypo:([^:]+)-([^:]+)-([^;]+).*")).matcher(this._filter)).find()) {
            this.setTypoFilter(m.group(1), m.group(2), m.group(3));
        }
        if ((m = (p = Pattern.compile(patternStr = ".*byObjStorage:([^:]+)-([^:]+)-([^:]+)-([^;]+).*")).matcher(this._filter)).find()) {
            this.setStorageFilter(m.group(1), m.group(2), m.group(3), m.group(4));
        }
    }

    public class StorageFilter {
        private String storageServer;
        private String storageStore;
        private String storageArea;
        private String storageWorkArea;

        public StorageFilter() {
        }

        public StorageFilter(String newServer, String newStore, String newArea, String newWorkArea) {
            String string = newServer != null ? (newServer.equals("*") ? null : newServer) : (this.storageServer = null);
            String string2 = newStore != null ? (newStore.equals("*") ? null : newStore) : (this.storageStore = null);
            String string3 = newArea != null ? (newArea.equals("*") ? null : newArea) : (this.storageArea = null);
            this.storageWorkArea = newWorkArea != null ? (newWorkArea.equals("*") ? null : newWorkArea) : null;
        }

        public String composeDebugInfo() {
            return "\r\n\tserver: " + this.storageServer + "\r\n\tstore: " + this.storageStore + "\r\n\tarea: " + this.storageArea + "\r\n\tworkArea: " + this.storageWorkArea;
        }

        public String getStorageArea() {
            return this.storageArea;
        }

        public void setStorageArea(String theStorageArea) {
            this.storageArea = theStorageArea;
        }

        public String getStorageServer() {
            return this.storageServer;
        }

        public void setStorageServer(String theStorageServer) {
            this.storageServer = theStorageServer;
        }

        public String getStorageStore() {
            return this.storageStore;
        }

        public void setStorageStore(String theStorageStore) {
            this.storageStore = theStorageStore;
        }

        public String getStorageWorkArea() {
            return this.storageWorkArea;
        }

        public void setStorageWorkArea(String theStorageWorkArea) {
            this.storageWorkArea = theStorageWorkArea;
        }
    }

    public class TypoFilter {
        private String typoCluster;
        private String typoFamily;
        private String typoType;

        public TypoFilter() {
        }

        public TypoFilter(String newCluster, String newFamily, String newType) {
            String string = newCluster != null ? (newCluster.equals("*") ? null : newCluster) : (this.typoCluster = null);
            String string2 = newFamily != null ? (newFamily.equals("*") ? null : newFamily) : (this.typoFamily = null);
            this.typoType = newType != null ? (newType.equals("*") ? null : newType) : null;
        }

        public String composeDebugInfo() {
            return "\r\n\tcluster: " + this.typoCluster + "\r\n\tfamily: " + this.typoFamily + "\r\n\ttype: " + this.typoType;
        }

        public String getTypoCluster() {
            return this.typoCluster;
        }

        public void setTypoCluster(String theTypoCluster) {
            this.typoCluster = theTypoCluster;
        }

        public String getTypoFamily() {
            return this.typoFamily;
        }

        public void setTypoFamily(String theTypoFamily) {
            this.typoFamily = theTypoFamily;
        }

        public String getTypoType() {
            return this.typoType;
        }

        public void setTypoType(String theTypoType) {
            this.typoType = theTypoType;
        }
    }

    public class ObjectFilter {
        private String objOid;
        private String objType;

        public ObjectFilter() {
        }

        public ObjectFilter(String newObjOid, String newObjType) {
            String string = newObjOid != null ? (newObjOid.equals("*") ? null : newObjOid) : (this.objOid = null);
            this.objType = newObjType != null ? (newObjType.equals("*") ? null : newObjType) : null;
        }

        public String composeDebugInfo() {
            return "\r\n\tobjOid: " + this.objOid + "\r\n\tobjType: " + this.objType;
        }

        public String getObjOid() {
            return this.objOid;
        }

        public void setObjOid(String theObjOid) {
            this.objOid = theObjOid;
        }

        public String getObjType() {
            return this.objType;
        }

        public void setObjType(String theObjType) {
            this.objType = theObjType;
        }
    }
}

