/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01k.searchorchestrator.indexer.indexers;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.net.HttpClient;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01k.ejb.entity.indexablecontent.R01KIndexableContentCMPLocal;
import com.ejie.r01k.ejb.entity.indexablecontent.R01KIndexableContentCMPPK;
import com.ejie.r01k.ejb.entity.indexablecontent.R01KIndexableContentCMPUtil;
import com.ejie.r01k.ejb.entity.indexablecontent.R01KIndexableContentCMPValue;
import com.ejie.r01m.config.objects.typology.R01MOpenDataFilters;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MSearchIndexerException;
import com.ejie.r01m.objects.R01MBaseLocationObject;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MContentLocation;
import com.ejie.r01m.objects.contentmodel.R01MContentTypologyInfo;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableContent;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableDocument;
import com.ejie.r01m.objects.searchengine.indexer.R01MRispDocument;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MContentModelAPI;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MDozerMappingUtils;
import com.ejie.r01m.utils.R01MPathHelpper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import net.sf.dozer.util.mapping.MappingException;

public class R01KRispIndexerProcessor {
    private static boolean DEBUG = R01FLog.getLogLevel((String)"r01k.index").intValue() != Level.OFF.intValue();
    private static final String URL_PACKET_CONTENT = XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"urlPackedContent/url");
    private static final long URL_PACKET_CONTENT_TIMEOUT = Long.parseLong(XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"urlPackedContent/timeout", (String)"300000"));
    private static final String URL_PACKET_CONTENT_REGEXP = XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"urlPackedContent/extractRegExp", (String)"([0-9]*)\\s*(?:/?\\w+/)*((?:[\\w-]+)\\.(?:zip|xml))");
    private static final String URL_PACKET_CONTENT_OPENDATA_DIR = XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"urlPackedContent/opendataDir", (String)"opendata");
    private static final String URL_PACKET_CONTENT_OPENDATA_SYSTEM = XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"urlPackedContent/opendatasystem", (String)"api");
    private static final String SEARCH_REGEX = "\\$";
    private static final String REPLACE_REGEX = "#REP#";
    private static final String END_FILTER = "r01_SEP";

    public void execIndexContent(String system, R01MIndexableContent idxCont) throws R01MSearchIndexerException {
        if (DEBUG) {
            R01FLog.to((String)"r01k.index").info("R01KRispIndexerProcessor: Inicio genracion de la informacion RISP correspondiente al CONTENIDO con oid " + idxCont.getOid());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01k.index").info("\t- Informacion base (contenido " + idxCont.getOid() + ")");
        }
        if (DEBUG) {
            R01FLog.to((String)"r01k.index").info("\t- Contenido (" + idxCont.getOid() + ")");
        }
        R01KIndexableContentCMPLocal indexableContentCMP = null;
        boolean existContent = false;
        try {
            indexableContentCMP = R01KIndexableContentCMPUtil.getLocalHome().findByPrimaryKey(new R01KIndexableContentCMPPK(idxCont.getOid()));
            existContent = true;
        }
        catch (FinderException findEx) {
            R01FLog.to((String)"r01k.index").info("No esta indexado el contenido con oid " + idxCont.getOid());
            existContent = false;
        }
        catch (NamingException nameEx) {
            nameEx.printStackTrace(System.out);
            throw new R01MSearchIndexerException("No se encuentra el Home del EJB de indexaci\u00f3n de contenido con oid " + idxCont.getOid(), (Exception)nameEx);
        }
        if (existContent) {
            R01MContentLocation storeLocation;
            Map rispData = null;
            if (URL_PACKET_CONTENT_OPENDATA_SYSTEM.equals("api")) {
                try {
                    R01MClientFactory.getContentAdminAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext()).exportContentToFile(idxCont.getOid());
                }
                catch (Exception ex) {
                    R01FLog.to((String)"r01k.index").severe("Error en la generacion del empaquetado del contenido con oid " + idxCont.getOid() + ".Error:" + ex.getMessage());
                    throw new R01MSearchIndexerException("Error en la generacion del empaquetado del contenido con oid " + idxCont.getOid(), ex);
                }
                try {
                    storeLocation = (R01MContentLocation)R01MDozerMappingUtils.map((String)R01MConstants.SEARCHENGINE_APPCODE, (Object)idxCont.getStorage(), R01MContentLocation.class);
                    rispData = R01MPathHelpper.composeRispContentDocumentsInfo((String)R01MPathHelpper.getLocationPath((R01MBaseLocationObject)storeLocation), (String)R01MPathHelpper.getContentWorkAreaRelativePath((R01MContentTypologyInfo)((R01MContentTypologyInfo)R01MDozerMappingUtils.map((String)R01MConstants.SEARCHENGINE_APPCODE, (Object)idxCont.getTypo(), R01MContentTypologyInfo.class)), (R01MBaseLocationObject)storeLocation, (String)idxCont.getOid(), (String)idxCont.getInternalName(), (String)idxCont.getName()), (String)idxCont.getInternalName());
                }
                catch (MappingException mapExc) {
                    mapExc.printStackTrace(System.err);
                }
            } else if (URL_PACKET_CONTENT_OPENDATA_SYSTEM.equals("api_query")) {
                try {
                    storeLocation = (R01MContentLocation)R01MDozerMappingUtils.map((String)R01MConstants.SEARCHENGINE_APPCODE, (Object)idxCont.getStorage(), R01MContentLocation.class);
                    rispData = R01MPathHelpper.composeRispContentDocumentsInfo((String)R01MPathHelpper.getLocationPath((R01MBaseLocationObject)storeLocation), (String)R01MPathHelpper.getContentWorkAreaRelativePath((R01MContentTypologyInfo)((R01MContentTypologyInfo)R01MDozerMappingUtils.map((String)R01MConstants.SEARCHENGINE_APPCODE, (Object)idxCont.getTypo(), R01MContentTypologyInfo.class)), (R01MBaseLocationObject)storeLocation, (String)idxCont.getOid(), (String)idxCont.getInternalName(), (String)idxCont.getName()), (String)idxCont.getInternalName());
                }
                catch (MappingException mapExc) {
                    mapExc.printStackTrace(System.err);
                }
            } else {
                StringBuffer contentWAPath = new StringBuffer();
                try {
                    contentWAPath.append(R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(idxCont.getStorage().getWorkArea().getOid()).getAbsolutePath());
                }
                catch (R01MConfigLoadException cfgExc) {
                    throw new R01MSearchIndexerException("Error al obtener la configuraci\u00f3n de la WA. Error:" + cfgExc.getMessage(), (Exception)((Object)cfgExc));
                }
                R01MContentLocation storeLocation2 = (R01MContentLocation)R01MDozerMappingUtils.map((String)R01MConstants.SEARCHENGINE_APPCODE, (Object)idxCont.getStorage(), R01MContentLocation.class);
                R01MContentTypologyInfo typology = (R01MContentTypologyInfo)R01MDozerMappingUtils.map((String)R01MConstants.SEARCHENGINE_APPCODE, (Object)idxCont.getTypo(), R01MContentTypologyInfo.class);
                contentWAPath.append(R01MPathHelpper.getContentWorkAreaRelativePath((R01MContentTypologyInfo)typology, (R01MBaseLocationObject)storeLocation2, (String)idxCont.getOid(), (String)idxCont.getInternalName(), (String)idxCont.getName()));
                String urlToInvoke = new String(URL_PACKET_CONTENT);
                Properties urlVars = new Properties();
                urlVars.put("contentPath", contentWAPath.toString());
                urlVars.put("packedFileFolderRelPath", URL_PACKET_CONTENT_OPENDATA_DIR);
                StringBuffer excludeDirs = new StringBuffer();
                excludeDirs.append(URL_PACKET_CONTENT_OPENDATA_DIR);
                excludeDirs.append(',');
                if (idxCont.getDocuments() != null && !idxCont.getDocuments().isEmpty()) {
                    for (Map.Entry me : idxCont.getDocuments().entrySet()) {
                        R01MIndexableDocument doc = (R01MIndexableDocument)me.getValue();
                        if (doc.isPublished()) continue;
                        excludeDirs.append(doc.getLanguage());
                        excludeDirs.append("_");
                        excludeDirs.append(doc.getInternalName());
                        excludeDirs.append(",");
                    }
                }
                excludeDirs.deleteCharAt(excludeDirs.length() - 1);
                urlVars.put("excludeDirs", excludeDirs.toString());
                urlVars.put("contentInternalName", idxCont.getInternalName());
                String excludeFilters = this.addOpendataFilters(idxCont);
                urlVars.put("excludePatterns", excludeFilters);
                String effectiveUrlToInvoke = StringUtils.replaceVariableValues((String)urlToInvoke, (char)'$', (Map)urlVars);
                effectiveUrlToInvoke = effectiveUrlToInvoke.replaceAll(REPLACE_REGEX, SEARCH_REGEX);
                if (DEBUG) {
                    R01FLog.to((String)"r01k.index").info("Invocando a :" + effectiveUrlToInvoke);
                }
                HttpClient httpClient = new HttpClient(effectiveUrlToInvoke);
                httpClient.setConnectionTimeout(URL_PACKET_CONTENT_TIMEOUT);
                InputStream responseIS = null;
                try {
                    responseIS = httpClient.sendGetHttpCall();
                }
                catch (IOException ioExc) {
                    throw new R01MSearchIndexerException("Error al invocar a la URL de empaquetado de contenidos '" + effectiveUrlToInvoke + "'. Error:" + ioExc.getMessage(), (Exception)ioExc);
                }
                byte[] totalBytes = null;
                try {
                    int availableLength = responseIS.available();
                    totalBytes = new byte[availableLength];
                    responseIS.read(totalBytes);
                }
                catch (IOException ioExc) {
                    throw new R01MSearchIndexerException("Error al leer la respuesta de empaquetado de contenidos '" + effectiveUrlToInvoke + "'. Error:" + ioExc.getMessage(), (Exception)ioExc);
                }
                finally {
                    if (responseIS != null) {
                        try {
                            responseIS.close();
                        }
                        catch (IOException ioExc) {}
                    }
                }
                if (totalBytes != null && totalBytes.length > 0) {
                    String respuesta = new String(totalBytes);
                    String[] fileLines = respuesta.split("\\|");
                    HashMap<String, String> fileSizes = new HashMap<String, String>();
                    if (fileLines != null && fileLines.length > 0) {
                        Pattern p = Pattern.compile(URL_PACKET_CONTENT_REGEXP);
                        for (int i = 0; i < fileLines.length; ++i) {
                            String currLine = fileLines[i];
                            Matcher m = p.matcher(currLine);
                            if (!m.matches()) continue;
                            fileSizes.put(m.group(2), m.group(1));
                        }
                    }
                    try {
                        rispData = R01KRispIndexerProcessor.composeRispContentDocumentsInfo(R01MPathHelpper.getLocationPath((R01MBaseLocationObject)storeLocation2), R01MPathHelpper.getContentWorkAreaRelativePath((R01MContentTypologyInfo)typology, (R01MBaseLocationObject)storeLocation2, (String)idxCont.getOid(), (String)idxCont.getInternalName(), (String)idxCont.getName()), idxCont.getInternalName(), fileSizes);
                    }
                    catch (MappingException mapExc) {
                        mapExc.printStackTrace(System.err);
                    }
                }
            }
            if (rispData != null && !rispData.isEmpty()) {
                R01KIndexableContentCMPValue indexableContentVO = indexableContentCMP.getR01KIndexableContentCMPValue();
                indexableContentVO.setContentRispDocumentsInfo(R01MRispDocument.mapObjectsToJsonString((Map)rispData));
                idxCont.setContentRispDocumentsInfo(rispData);
                try {
                    indexableContentVO.setXmlIndexableContent(XOManager.getXML((String)R01MConstants.INDEXABLEOBJECTS_MAPFILE, (Object)idxCont));
                }
                catch (XOMarshallerException ex) {
                    R01FLog.to((String)"r01k.index").severe("Error en el mapeo del Objeto indexable a XML.Error: " + ex.getMessage());
                    throw new R01MSearchIndexerException("Error en el mapeo del Objeto indexable a XML.", (Exception)((Object)ex));
                }
                indexableContentCMP.setR01KIndexableContentCMPValue(indexableContentVO);
                try {
                    R01MContentModelAPI contentAPI = R01MClientFactory.getContentModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext());
                    R01MContent content = contentAPI.loadContent(idxCont.getOid());
                    contentAPI.uploadIndexableObject(content, idxCont);
                }
                catch (Exception ex) {
                    R01FLog.to((String)"r01k.index").severe("Error al subir el objeto indexable a la carpeta del contenido.Error: " + ex.getMessage());
                    throw new R01MSearchIndexerException("Error al subir el objeto indexable a la carpeta del contenido.", ex);
                }
            }
        }
    }

    private String addOpendataFilters(R01MIndexableContent idxCont) throws R01MSearchIndexerException {
        List filters = null;
        StringBuffer processedFilters = new StringBuffer();
        try {
            R01MOpenDataFilters opendataFilter = R01MClientFactory.getTypologyConfigAPI().getTypeConfig(idxCont.getTypo().getCluster().getOid(), idxCont.getTypo().getFamily().getOid(), idxCont.getTypo().getType().getOid()).getOpendata();
            if (null != opendataFilter) {
                filters = opendataFilter.getExcludeFilters();
            }
        }
        catch (R01MConfigLoadException ex) {
            R01FLog.to((String)"r01k.index").severe("Error al obtener la informaci\u00f3n de la tipolog\u00eda " + idxCont.getTypo().composeMemoCode() + ".Error:" + ex.getMessage());
            throw new R01MSearchIndexerException("Error al obtener la informaci\u00f3n de la tipolog\u00eda " + idxCont.getTypo().composeMemoCode(), (Exception)((Object)ex));
        }
        if (null != filters) {
            Iterator itRegEx = filters.iterator();
            while (itRegEx.hasNext()) {
                String theRegExp = itRegEx.next().toString();
                if (StringUtils.isEmptyString((String)theRegExp)) continue;
                theRegExp = theRegExp.replaceAll(SEARCH_REGEX, REPLACE_REGEX);
                processedFilters.append(theRegExp);
                if (!itRegEx.hasNext()) continue;
                processedFilters.append(END_FILTER);
            }
        }
        return processedFilters.toString();
    }

    public static Map composeRispContentDocumentsInfo(String waPath, String contentWARelPath, String contentInternalName, Map fileSizes) {
        HashMap<Object, R01MRispDocument> contentRispDocumentsInfo = new HashMap<Object, R01MRispDocument>();
        Properties vars = new Properties();
        vars.setProperty("contentInternalName", contentInternalName);
        Properties generatesFilesRelativePaths = XMLProperties.getProperties((String)R01MConstants.API_APPCODE, (String)"rispContentGeneratedData");
        Enumeration<Object> e = generatesFilesRelativePaths.keys();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            String fileContentRelPath = StringUtils.replaceVariableValues((String)generatesFilesRelativePaths.getProperty(obj.toString()), (char)'$', (Map)vars);
            String fileName = fileContentRelPath.substring(fileContentRelPath.lastIndexOf(47) + 1, fileContentRelPath.length());
            String fileSize = "";
            if (fileSizes.containsKey(fileName)) {
                fileSize = (String)fileSizes.get(fileName);
            }
            R01MRispDocument rispDoc = new R01MRispDocument((String)obj, fileContentRelPath, fileSize);
            contentRispDocumentsInfo.put(obj, rispDoc);
        }
        return contentRispDocumentsInfo;
    }

    public void execUnIndexContent(String system, String contOid) throws R01MSearchIndexerException {
    }

    public void execUnIndexDocument(String system, String contOid) throws R01MSearchIndexerException {
    }
}

