/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01k.searchorchestrator.indexer.indexers;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01k.searchorchestrator.indexer.indexers.R01KRispIndexerProcessor;
import com.ejie.r01k.searchorchestrator.indexer.indexers.R01KSearchEngineIndexer;
import com.ejie.r01k.traceindex.R01KTraceIndexHelper;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MSearchIndexerException;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.searchengine.indexer.R01MBaseIndexableObject;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableContent;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MSearchMetaDataStorageConfigAPI;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;

public class R01KRispIndexer
implements R01KSearchEngineIndexer {
    private static boolean DEBUG = R01FLog.getLogLevel((String)"r01k.index").intValue() != Level.OFF.intValue();
    static R01MSearchMetaDataStorageConfigAPI SEARCH_METADATA_STORAGE_CONFIG = R01MClientFactory.getSearchMetaDataStorageConfigAPI();
    private static int indexerType = R01KSearchEngineIndexer.CONTENT_TYPE_INDEXER;
    private transient Properties _props = null;
    private transient String _nativeDateFormat = "dd/MM/yyyy";

    @Override
    public void setNativeDateFormat(String dateFormat) {
        this._nativeDateFormat = dateFormat;
    }

    @Override
    public String getNativeDateFormat() {
        return this._nativeDateFormat;
    }

    @Override
    public void setProperties(Properties props) {
        this._props = props;
    }

    @Override
    public Properties getProperties() {
        return this._props;
    }

    @Override
    public int getIndexerType() {
        return indexerType;
    }

    @Override
    public void index(String systemId, R01MBaseIndexableObject idxObj, int objType, List<String> metadataFileName, Properties props) throws R01MSearchIndexerException {
        if (idxObj == null) {
            if (DEBUG) {
                R01FLog.to((String)"r01k.index").warning("Se ha intentado indexar un objeto NULO!!!");
            }
            return;
        }
        if (objType != 0 && objType != 1) {
            R01FLog.to((String)"r01k.index").severe("Se ha intentado ejecutar la indexaci\u00f3n Risp para un objeto que no es contenido: Tipo " + objType + "!!!");
            return;
        }
        String traceObjOid = idxObj.getOid();
        if (props != null && props.containsKey("objectOid")) {
            traceObjOid = props.getProperty("objectOid").toString();
        }
        if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
            this._traceIndex(traceObjOid, objType, 1, "");
        }
        switch (objType) {
            case 0: 
            case 1: {
                R01MIndexableContent objIndexable = (R01MIndexableContent)idxObj;
                boolean generateRispFiles = false;
                try {
                    generateRispFiles = R01MClientFactory.getTypologyConfigAPI().getTypeConfig(objIndexable.getTypo().getCluster().getOid(), objIndexable.getTypo().getFamily().getOid(), objIndexable.getTypo().getType().getOid()).getOpendata().isGenerateRispFiles();
                }
                catch (R01MConfigLoadException ex) {
                    String errorMsg = "Error al obtener la informaci\u00f3n de la tipolog\u00eda " + objIndexable.getTypo().composeMemoCode() + ".Error:" + ex.getMessage();
                    R01FLog.to((String)"r01k.index").severe(errorMsg);
                    if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                        this._traceIndex(traceObjOid, objType, 2, errorMsg);
                    }
                    throw new R01MSearchIndexerException("Error al obtener la informaci\u00f3n de la tipolog\u00eda " + objIndexable.getTypo().composeMemoCode(), (Exception)((Object)ex));
                }
                if (!generateRispFiles) break;
                try {
                    this._execGenerateRispContent(systemId, objIndexable);
                    break;
                }
                catch (R01MSearchIndexerException idxExc) {
                    if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                        this._traceIndex(traceObjOid, objType, 2, "Error:" + idxExc.getMessage());
                    }
                    throw idxExc;
                }
                catch (Exception e) {
                    if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                        this._traceIndex(traceObjOid, objType, 2, "Error general:" + e.getMessage());
                    }
                    throw new R01MSearchIndexerException(e);
                }
            }
            case 4: {
                break;
            }
            default: {
                String errorMsg = "El tipo de objeto " + objType + " NO es valido para su indexacion de RISP.";
                if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                    this._traceIndex(traceObjOid, objType, 2, errorMsg);
                }
                throw new R01MSearchIndexerException(errorMsg);
            }
        }
        if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
            this._traceIndex(traceObjOid, objType, 3, "");
        }
    }

    @Override
    public void unIndex(String systemId, R01MBaseIndexableObject idxObj, String objOid, int objType, boolean traceIndex) throws R01MSearchIndexerException {
        if (DEBUG) {
            R01FLog.to((String)"r01k.index").info("R01KDataBaseIndexer: Des-Indexar informaci\u00f3n Risp de objeto indexable");
        }
        R01KRispIndexerProcessor idxProc = new R01KRispIndexerProcessor();
        switch (objType) {
            case 0: {
                idxProc.execUnIndexContent("contenidos", objOid);
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                idxProc.execUnIndexDocument("contenidos", objOid);
                break;
            }
            default: {
                throw new R01MSearchIndexerException("El tipo de objeto " + objType + " NO es valido para su indexacion en BD");
            }
        }
    }

    @Override
    public void unIndex(String systemId, String objOid, int objType, boolean traceIndex) throws R01MSearchIndexerException {
        this.unIndex(systemId, null, objOid, objType, traceIndex);
    }

    @Override
    public boolean checkIndex(String systemId, String objOid, int objType) throws R01MSearchIndexerException {
        if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
            this._traceIndex(objOid, objType, 4, "");
        }
        return true;
    }

    @Override
    public boolean checkUnIndex(String systemId, String objOid, int objType) throws R01MSearchIndexerException {
        if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
            this._traceIndex(objOid, objType, 4, "");
        }
        return true;
    }

    private void _execGenerateRispContent(String systemId, R01MIndexableContent idxCont) throws R01MSearchIndexerException {
        if (idxCont.getStorage() == null || idxCont.getTypo() == null) {
            R01FLog.to((String)"r01k.index").severe("Se ha intentado indexar un contenido que no tiene almacenamiento o tipolog\u00eda!!");
            return;
        }
        R01KRispIndexerProcessor idxProc = new R01KRispIndexerProcessor();
        if (DEBUG) {
            R01FLog.to((String)"r01k.index").info("R01KDataBaseIndexer: Indexar datos del contenido");
        }
        idxProc.execIndexContent("contenidos", idxCont);
    }

    private void _traceIndex(String objOid, int objType, int action, String errorMsg) {
        if (objType == 1) {
            switch (action) {
                case 1: {
                    R01KTraceIndexHelper.execRispTraceIndexInit((String)objOid);
                    break;
                }
                case 2: {
                    R01KTraceIndexHelper.execRispTraceIndexEndErr((String)objOid, (String)errorMsg);
                    break;
                }
                case 3: {
                    R01KTraceIndexHelper.execRispTraceIndexEnd((String)objOid);
                    break;
                }
                case 4: {
                    R01KTraceIndexHelper.execRispCheckIndexOK((String)objOid);
                    break;
                }
            }
        } else if (objType == 0) {
            try {
                R01MContent theContent = R01MClientFactory.getContentModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext()).loadContent(objOid);
                if (theContent.getDocuments() != null && !theContent.getDocuments().isEmpty()) {
                    for (String documentOid : theContent.getDocuments().keySet()) {
                        switch (action) {
                            case 1: {
                                R01KTraceIndexHelper.execRispTraceIndexInit((String)documentOid);
                                break;
                            }
                            case 2: {
                                R01KTraceIndexHelper.execRispTraceIndexEndErr((String)documentOid, (String)errorMsg);
                                break;
                            }
                            case 3: {
                                R01KTraceIndexHelper.execRispTraceIndexEnd((String)documentOid);
                                break;
                            }
                            case 4: {
                                R01KTraceIndexHelper.execRispCheckIndexOK((String)documentOid);
                                break;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }
}

