/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01k.searchorchestrator.indexer.indexers;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.net.HttpClient;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.NumberUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01k.searchorchestrator.indexer.indexers.R01KSearchEngineIndexer;
import com.ejie.r01k.traceindex.R01KTraceIndexHelper;
import com.ejie.r01m.config.objects.typology.R01MContentType;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MSearchIndexerException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.contentmodel.R01MDocumentPublicationTarget;
import com.ejie.r01m.objects.portalmodel.R01MPage;
import com.ejie.r01m.objects.searchengine.indexer.R01MBaseIndexableObject;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableContent;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MTypologyConfigAPI;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MDateUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class R01KResultFormaterIndexer
implements R01KSearchEngineIndexer {
    private static final String LOG_TYPE_ID = "r01k.index";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01k.index").intValue() != Level.OFF.intValue();
    public static final String TYPOLOGY_GUIDE_INDEX_FILE = XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"indexerContents/filesToIndexGuides/typologyGuides");
    public static final String CATALOG_GUIDE_INDEX_FILE = XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"indexerContents/filesToIndexGuides/catalogGuides");
    public static final String DEFAULT_INDEX_EXTENSSION = XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"indexerContents/idxExtenssion", (String)"idx");
    private static final int indexerType = R01KSearchEngineIndexer.DOCUMENT_TYPE_INDEXER;
    public static final String IDOLMETAS_URI_NODE1 = XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"autonomyIndexService/queryMetasUri1");
    public static final String IDOLMETAS_URI_NODE2 = XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"autonomyIndexService/queryMetasUri2");
    public static final String IDOLFULL_URI_NODE1 = XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"autonomyIndexService/queryFullUri1");
    public static final String IDOLFULL_URI_NODE2 = XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"autonomyIndexService/queryFullUri2");
    private transient Properties _props = null;
    private transient String _nativeDateFormat = "seconds";
    private static R01MTypologyConfigAPI typoConfigAPI = R01MClientFactory.getTypologyConfigAPI();

    public R01KResultFormaterIndexer() {
    }

    public R01KResultFormaterIndexer(Properties props) {
        this();
        this._props = props;
    }

    @Override
    public void setNativeDateFormat(String dateFormat) {
        this._nativeDateFormat = dateFormat;
    }

    @Override
    public String getNativeDateFormat() {
        return this._nativeDateFormat;
    }

    @Override
    public void setProperties(Properties props) {
        this._props = props;
    }

    @Override
    public Properties getProperties() {
        return this._props;
    }

    @Override
    public int getIndexerType() {
        return indexerType;
    }

    @Override
    public void index(String systemId, R01MBaseIndexableObject idxObj, int objType, List<String> metadataFileNames, Properties props) throws R01MSearchIndexerException {
        if (idxObj == null) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Se ha intentado indexar un objeto NULO!!!");
            return;
        }
        if (objType == 0 || objType == 1 || objType == 4) {
            String webPath;
            String traceObjOid;
            block26: {
                R01MIndexableContent idxCont = (R01MIndexableContent)idxObj;
                switch (objType) {
                    case 0: 
                    case 1: {
                        if (props != null && props.containsKey("objectOid")) {
                            traceObjOid = props.getProperty("objectOid").toString();
                            break;
                        }
                        traceObjOid = idxObj.getOid();
                        break;
                    }
                    case 4: {
                        traceObjOid = idxObj.getOid();
                        break;
                    }
                    default: {
                        throw new R01MSearchIndexerException("El tipo de objeto " + objType + " NO es valido para su indexacion de resultados de b\u00fasqueda");
                    }
                }
                if (idxCont.getStorage() == null || idxCont.getTypo() == null) {
                    String errorMsg = "Se ha intentado indexar un contenido que no tiene almacenamiento o tipolog\u00eda!!";
                    R01FLog.to((String)LOG_TYPE_ID).severe(errorMsg);
                    if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                        R01KResultFormaterIndexer._traceIndex(traceObjOid, objType, 1, "", "");
                        R01KResultFormaterIndexer._traceIndex(traceObjOid, objType, 21, errorMsg, "");
                        R01KResultFormaterIndexer._traceIndex(traceObjOid, objType, 22, errorMsg, "");
                    }
                    return;
                }
                webPath = null;
                if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                    webPath = idxCont.getTypo().getType().getOid() + "/" + idxCont.getInternalName() + "/";
                    if (objType == 1) {
                        webPath = webPath + idxCont.getDocument((String)props.get("objectOid")).getLanguage() + "_" + idxCont.getDocument((String)props.get("objectOid")).getInternalName() + "/";
                    }
                    R01KResultFormaterIndexer._traceIndex(traceObjOid, objType, 1, "", webPath);
                }
                if (idxCont.getStorage() == null || idxCont.getStorage().getServer() == null || idxCont.getStorage().getServer().getOid() == null || idxCont.getStorage().getDataStore() == null || idxCont.getStorage().getDataStore().getOid() == null) {
                    String errorMsg = "No se puede obtener el fichero .idx para resultados de b\u00fasqueda ya que el contenido indexable suministrado NO contiene informaci\u00f3n de almacenamiento suficiente: al menos han de llegar el servidor y dataStore!!!";
                    if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                        R01KResultFormaterIndexer._traceIndex(traceObjOid, objType, 21, errorMsg, webPath);
                        R01KResultFormaterIndexer._traceIndex(traceObjOid, objType, 22, errorMsg, webPath);
                    }
                    throw new R01MSearchIndexerException(errorMsg);
                }
                try {
                    R01MContentType typeConfig = typoConfigAPI.getTypeConfig(idxCont.getTypo().getType().getOid());
                    Map searchResultIndexers = typeConfig.getSearchResultIndexerConfig();
                    if (objType == 1) {
                        try {
                            this._generateHTML((String)props.get("objectOid"), idxCont, searchResultIndexers);
                        }
                        catch (R01MSearchIndexerException siEx) {
                            String errorMsg = "Error al generar los ficheros de resultado para el documento " + (String)props.get("objectOid") + " " + "(padre " + idxCont.getOid() + ", indexaci\u00f3n para el tipo " + objType + ". Error: " + siEx.getMessage();
                            R01FLog.to((String)LOG_TYPE_ID).severe(errorMsg);
                            if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                                R01KResultFormaterIndexer._traceIndex(traceObjOid, objType, 21, errorMsg, webPath);
                                R01KResultFormaterIndexer._traceIndex(traceObjOid, objType, 22, errorMsg, webPath);
                            }
                        }
                    } else if (objType == 0 || objType == 4) {
                        for (String currentDocument : idxCont.getDocuments().keySet()) {
                            try {
                                this._generateHTML(currentDocument, idxCont, searchResultIndexers);
                            }
                            catch (R01MSearchIndexerException siEx) {
                                String errorMsg = "Error al generar los ficheros de resultado para el documento " + currentDocument + " " + "(padre " + idxCont.getOid() + ", indexaci\u00f3n para el tipo " + objType + ". Error: " + siEx.getMessage();
                                R01FLog.to((String)LOG_TYPE_ID).severe(errorMsg);
                                if (!R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) continue;
                                R01KResultFormaterIndexer._traceIndex(traceObjOid, objType, 21, errorMsg, webPath);
                                R01KResultFormaterIndexer._traceIndex(traceObjOid, objType, 22, errorMsg, webPath);
                            }
                        }
                    }
                }
                catch (R01MConfigLoadException clEx) {
                    String errorMsg = "Error al cargar la configuraci\u00f3n de la tipolog\u00eda para el objeto " + idxCont.getOid() + " de tipo " + objType + ". " + "Tipo que ha fallado al cargarse: " + idxCont.getTypo().getType().getOid() + ". Error: " + clEx.getMessage();
                    R01FLog.to((String)LOG_TYPE_ID).severe(errorMsg);
                    if (!R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) break block26;
                    R01KResultFormaterIndexer._traceIndex(traceObjOid, objType, 21, errorMsg, webPath);
                    R01KResultFormaterIndexer._traceIndex(traceObjOid, objType, 22, errorMsg, webPath);
                }
            }
            if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                R01KResultFormaterIndexer._traceIndex(traceObjOid, objType, 3, "", webPath);
            }
        } else {
            R01FLog.to((String)LOG_TYPE_ID).severe("SEARCHRESULTINDEXER > NO se puede indexar un objeto tipo " + R01MConstants.OBJECT_DESCS[objType]);
        }
    }

    private void _generateHTML(String documentOid, R01MIndexableContent idxCont, Map searchResultIndexers) throws R01MSearchIndexerException {
    }

    @Override
    public void unIndex(String systemId, String objectOid, int objectType, boolean traceIndex) throws R01MSearchIndexerException {
    }

    @Override
    public void unIndex(String systemId, R01MBaseIndexableObject indexableObj, String objectOid, int objectType, boolean traceIndex) throws R01MSearchIndexerException {
    }

    @Override
    public boolean checkIndex(String systemId, String objOid, int objType) throws R01MSearchIndexerException {
        boolean indexInIDOL1 = R01KResultFormaterIndexer._testAutonomy(objOid, 0, objType, true);
        boolean indexInIDOL2 = R01KResultFormaterIndexer._testAutonomy(objOid, 0, objType, false);
        return indexInIDOL1 && indexInIDOL2;
    }

    @Override
    public boolean checkUnIndex(String systemId, String objOid, int objType) throws R01MSearchIndexerException {
        boolean indexInIDOL1 = R01KResultFormaterIndexer._testAutonomy(objOid, 1, objType, true);
        boolean indexInIDOL2 = R01KResultFormaterIndexer._testAutonomy(objOid, 1, objType, false);
        return indexInIDOL1 && indexInIDOL2;
    }

    private static void _traceIndex(String objOid, int objType, int action, String errorMsg, String path) {
        if (objType == 1 || objType == 4) {
            switch (action) {
                case 1: {
                    R01KTraceIndexHelper.execAutonomyMetasTraceIndexInit((String)objOid, (String)path);
                    R01KTraceIndexHelper.execAutonomyFullTraceIndexInit((String)objOid);
                    break;
                }
                case 21: {
                    R01KTraceIndexHelper.execAutonomyFullTraceIndexEndErr((String)objOid, (String)errorMsg);
                    break;
                }
                case 22: {
                    R01KTraceIndexHelper.execAutonomyMetasTraceIndexEndErr((String)objOid, (String)errorMsg);
                    break;
                }
                case 3: {
                    R01KTraceIndexHelper.execAutonomyFullTraceIndexEnd((String)objOid);
                    R01KTraceIndexHelper.execAutonomyMetasTraceIndexEnd((String)objOid);
                    break;
                }
                case 41: {
                    R01KTraceIndexHelper.execAutonomyFullCheckIndexOK((String)objOid);
                    break;
                }
                case 42: {
                    R01KTraceIndexHelper.execAutonomyMetasCheckIndexOK((String)objOid);
                    break;
                }
            }
        } else if (objType == 0) {
            try {
                R01MContent theContent = R01MClientFactory.getContentModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext()).loadContent(objOid);
                if (theContent.getDocuments() != null && !theContent.getDocuments().isEmpty()) {
                    for (String documentOid : theContent.getDocuments().keySet()) {
                        switch (action) {
                            case 1: {
                                R01KTraceIndexHelper.execAutonomyMetasTraceIndexInit((String)documentOid, (String)(path + "/" + ((R01MDocument)theContent.getDocuments().get(documentOid)).getInternalName()));
                                R01KTraceIndexHelper.execAutonomyFullTraceIndexInit((String)documentOid);
                                break;
                            }
                            case 21: {
                                R01KTraceIndexHelper.execAutonomyFullTraceIndexEndErr((String)documentOid, (String)errorMsg);
                                break;
                            }
                            case 22: {
                                R01KTraceIndexHelper.execAutonomyMetasTraceIndexEndErr((String)documentOid, (String)errorMsg);
                                break;
                            }
                            case 3: {
                                R01KTraceIndexHelper.execAutonomyFullTraceIndexEnd((String)documentOid);
                                R01KTraceIndexHelper.execAutonomyMetasTraceIndexEnd((String)documentOid);
                                break;
                            }
                            case 41: {
                                R01KTraceIndexHelper.execAutonomyFullCheckIndexOK((String)documentOid);
                                break;
                            }
                            case 42: {
                                R01KTraceIndexHelper.execAutonomyMetasCheckIndexOK((String)documentOid);
                                break;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private static boolean _testAutonomy(String objectOid, int action, int objType, boolean checkDIHMetas) throws R01MSearchIndexerException {
        String uriCheckIDOL2;
        String uriCheckIDOL1;
        if (checkDIHMetas) {
            uriCheckIDOL1 = IDOLMETAS_URI_NODE1;
            uriCheckIDOL2 = IDOLMETAS_URI_NODE2;
        } else {
            uriCheckIDOL1 = IDOLFULL_URI_NODE1;
            uriCheckIDOL2 = IDOLFULL_URI_NODE2;
        }
        String dreReference = R01KTraceIndexHelper.readAutonomyDREReference((String)objectOid);
        String returnData = R01KResultFormaterIndexer.readContentIdx(uriCheckIDOL1, dreReference);
        boolean isIndexedOK = false;
        if (returnData != null) {
            isIndexedOK = R01KResultFormaterIndexer.chekIndexUnindexHttpImpl(returnData, objectOid, action, objType, checkDIHMetas);
        }
        if (isIndexedOK && (returnData = R01KResultFormaterIndexer.readContentIdx(uriCheckIDOL2, dreReference)) != null) {
            isIndexedOK = R01KResultFormaterIndexer.chekIndexUnindexHttpImpl(returnData, objectOid, action, objType, checkDIHMetas);
        }
        return isIndexedOK;
    }

    public static String readContentIdx(String dahUriNode, String dreReference) {
        String autonomyXMLResponse = "";
        StringBuffer indexURL = new StringBuffer();
        indexURL.append(dahUriNode);
        indexURL.append("/action=getcontent&reference=");
        indexURL.append(dreReference);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Checking if content is indexed on " + indexURL);
        }
        HttpClient httpClient = new HttpClient(indexURL.toString());
        InputStream serverReturnStream = null;
        try {
            serverReturnStream = httpClient.sendGetHttpCall();
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("El resultado de la indexaci\u00f3n para " + indexURL + " es:");
            }
            if (serverReturnStream != null) {
                autonomyXMLResponse = IOUtils.toString((InputStream)serverReturnStream);
            } else if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("null");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.out);
            autonomyXMLResponse = "";
        }
        return autonomyXMLResponse;
    }

    private static boolean chekIndexUnindexHttpImpl(String returnData, String objectOid, int action, int objType, boolean checkDIHMetas) throws R01MSearchIndexerException {
        Pattern pattern;
        Matcher matcher;
        boolean responseError = false;
        boolean responseSuccess = false;
        if (StringUtils.isEmptyString((String)returnData)) {
            if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                if (checkDIHMetas) {
                    R01KResultFormaterIndexer._traceIndex(objectOid, objType, 22, "Autonomy ha devuelto null.", "");
                } else {
                    R01KResultFormaterIndexer._traceIndex(objectOid, objType, 21, "Autonomy ha devuelto null.", "");
                }
            }
            return false;
        }
        String patternStr = "<response>(.*)</response>";
        if (returnData.indexOf("<response>") > 0 && (matcher = (pattern = Pattern.compile(patternStr)).matcher(returnData)).find()) {
            if (matcher.group(1).equals("ERROR")) {
                responseError = true;
            } else if (matcher.group(1).equals("SUCCESS")) {
                responseSuccess = true;
            }
        }
        if (action == 1) {
            if (responseError) {
                if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                    if (checkDIHMetas) {
                        R01KResultFormaterIndexer._traceIndex(objectOid, objType, 42, "", "");
                    } else {
                        R01KResultFormaterIndexer._traceIndex(objectOid, objType, 41, "", "");
                    }
                }
                return true;
            }
            if (responseSuccess) {
                if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                    if (checkDIHMetas) {
                        R01KResultFormaterIndexer._traceIndex(objectOid, objType, 22, "Autonomy deber\u00eda tener desindexados los datos.", "");
                    } else {
                        R01KResultFormaterIndexer._traceIndex(objectOid, objType, 21, "Autonomy deber\u00eda tener desindexados los datos.", "");
                    }
                }
            } else if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                if (checkDIHMetas) {
                    R01KResultFormaterIndexer._traceIndex(objectOid, objType, 22, "Error en la consulta sobre Autonomy.", "");
                } else {
                    R01KResultFormaterIndexer._traceIndex(objectOid, objType, 21, "Error en la consulta sobre Autonomy.", "");
                }
            }
            return false;
        }
        if (responseSuccess) {
            String publicationDateInMilliSeconds = "0";
            try {
                Pattern pattern2;
                Matcher matcher2;
                patternStr = "<DREDATE>[^0-9]*([0-9]+)[^0-9]*</DREDATE>";
                if (returnData.indexOf("<DREDATE>") > 0 && (matcher2 = (pattern2 = Pattern.compile(patternStr)).matcher(returnData)).find()) {
                    publicationDateInMilliSeconds = matcher2.group(1) + "000";
                }
            }
            catch (Exception e) {
                String errorMsg = "Error al tratar el XML de autonomy para el objeto " + objectOid + ".Error:" + e.getMessage();
                if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                    if (checkDIHMetas) {
                        R01KResultFormaterIndexer._traceIndex(objectOid, objType, 22, errorMsg, "");
                    } else {
                        R01KResultFormaterIndexer._traceIndex(objectOid, objType, 21, errorMsg, "");
                    }
                }
                throw new R01MSearchIndexerException(errorMsg);
            }
            long millisecondsOnIDX = 0L;
            if (!NumberUtils.isLong((String)publicationDateInMilliSeconds)) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("El objeto " + objectOid + " no tiene una fecha de publicaci\u00f3n en AUTONOMY.");
                }
                if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                    if (checkDIHMetas) {
                        R01KResultFormaterIndexer._traceIndex(objectOid, objType, 22, "El objeto " + objectOid + " no tiene una fecha de publicaci\u00f3n en AUTONOMY.", "");
                    } else {
                        R01KResultFormaterIndexer._traceIndex(objectOid, objType, 21, "El objeto " + objectOid + " no tiene una fecha de publicaci\u00f3n en AUTONOMY.", "");
                    }
                }
                return false;
            }
            millisecondsOnIDX = Long.parseLong(publicationDateInMilliSeconds);
            boolean isPublished = false;
            List publications = null;
            String objName = "";
            if (objType == 1) {
                R01MDocument currDocument;
                try {
                    currDocument = R01MClientFactory.getContentModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext()).loadDocument(objectOid);
                }
                catch (R01MSecurityException ex) {
                    String errorMsg = "Error de seguridad al cargar el documento " + objectOid + ".Error:" + ex.getMessage();
                    if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                        if (checkDIHMetas) {
                            R01KResultFormaterIndexer._traceIndex(objectOid, objType, 22, errorMsg, "");
                        } else {
                            R01KResultFormaterIndexer._traceIndex(objectOid, objType, 21, errorMsg, "");
                        }
                    }
                    R01FLog.to((String)LOG_TYPE_ID).warning(errorMsg);
                    throw new R01MSearchIndexerException(errorMsg);
                }
                catch (R01MContentModelException ex) {
                    String errorMsg = "Error alcargar el documento " + objectOid + ".Error:" + ex.getMessage();
                    if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                        if (checkDIHMetas) {
                            R01KResultFormaterIndexer._traceIndex(objectOid, objType, 22, errorMsg, "");
                        } else {
                            R01KResultFormaterIndexer._traceIndex(objectOid, objType, 21, errorMsg, "");
                        }
                    }
                    R01FLog.to((String)LOG_TYPE_ID).warning(errorMsg);
                    throw new R01MSearchIndexerException(errorMsg);
                }
                try {
                    isPublished = currDocument.isPublishedInAnyRepository();
                }
                catch (Exception ex) {
                    String errorMsg = "Error al validar si el documento " + currDocument.getInternalName() + " est\u00e1 publicado.Error:" + ex.getMessage();
                    if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                        if (checkDIHMetas) {
                            R01KResultFormaterIndexer._traceIndex(objectOid, objType, 22, errorMsg, "");
                        } else {
                            R01KResultFormaterIndexer._traceIndex(objectOid, objType, 21, errorMsg, "");
                        }
                    }
                    R01FLog.to((String)LOG_TYPE_ID).warning(errorMsg);
                    throw new R01MSearchIndexerException(errorMsg);
                }
                publications = currDocument.getPublicationInfo();
                objName = currDocument.getInternalName();
            } else if (objType == 4) {
                R01MPage currPage;
                try {
                    currPage = R01MClientFactory.getPortalModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext(), null).loadPortalPage(objectOid);
                }
                catch (R01MSecurityException ex) {
                    String errorMsg = "Error de seguridad al cargar la p\u00e1gina " + objectOid + ".Error:" + ex.getMessage();
                    if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                        if (checkDIHMetas) {
                            R01KResultFormaterIndexer._traceIndex(objectOid, objType, 22, errorMsg, "");
                        } else {
                            R01KResultFormaterIndexer._traceIndex(objectOid, objType, 21, errorMsg, "");
                        }
                    }
                    R01FLog.to((String)LOG_TYPE_ID).warning(errorMsg);
                    throw new R01MSearchIndexerException(errorMsg);
                }
                catch (R01MPortalModelException ex) {
                    String errorMsg = "Error alcargar la p\u00e1gina " + objectOid + ".Error:" + ex.getMessage();
                    if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                        if (checkDIHMetas) {
                            R01KResultFormaterIndexer._traceIndex(objectOid, objType, 22, errorMsg, "");
                        } else {
                            R01KResultFormaterIndexer._traceIndex(objectOid, objType, 21, errorMsg, "");
                        }
                    }
                    R01FLog.to((String)LOG_TYPE_ID).warning(errorMsg);
                    throw new R01MSearchIndexerException(errorMsg);
                }
                try {
                    isPublished = currPage.isPublishedInAnyRepository();
                }
                catch (Exception ex) {
                    String errorMsg = "Error al validar si la p\u00e1gina " + currPage.getInternalName() + " est\u00e1 publicada.Error:" + ex.getMessage();
                    if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                        if (checkDIHMetas) {
                            R01KResultFormaterIndexer._traceIndex(objectOid, objType, 22, errorMsg, "");
                        } else {
                            R01KResultFormaterIndexer._traceIndex(objectOid, objType, 21, errorMsg, "");
                        }
                    }
                    R01FLog.to((String)LOG_TYPE_ID).warning(errorMsg);
                    throw new R01MSearchIndexerException(errorMsg);
                }
                publications = currPage.getPublicationInfo();
                objName = currPage.getInternalName();
            }
            if (isPublished && publications != null) {
                long millisecondsOnDatabase = 0L;
                if (objType == 1) {
                    for (R01MDocumentPublicationTarget pub : publications) {
                        if (pub.getState() != 1) continue;
                        String dateOnMillis = "" + DateUtils.getDateAsMillis((Date)pub.getPublishDate());
                        dateOnMillis = dateOnMillis.substring(0, dateOnMillis.length() - 3) + "000";
                        millisecondsOnDatabase = Long.parseLong(dateOnMillis);
                    }
                } else if (objType == 4) {
                    for (R01MDocumentPublicationTarget pub : publications) {
                        if (pub.getState() != 1) continue;
                        String dateOnMillis = "" + DateUtils.getDateAsMillis((Date)pub.getPublishDate());
                        dateOnMillis = dateOnMillis.substring(0, dateOnMillis.length() - 3) + "000";
                        millisecondsOnDatabase = Long.parseLong(dateOnMillis);
                    }
                }
                if (millisecondsOnIDX != 0L && millisecondsOnIDX != millisecondsOnDatabase) {
                    StringBuffer idxCompareFail = new StringBuffer();
                    idxCompareFail.append("DISTINTOS $$$$$$ fecha en Autonomy (");
                    idxCompareFail.append(R01MDateUtils.dateTimeSecondsToStr((Date)new Date(millisecondsOnIDX), (String)"es"));
                    idxCompareFail.append(" (");
                    idxCompareFail.append(millisecondsOnIDX);
                    idxCompareFail.append(" msecs)) - Fecha r01d (");
                    idxCompareFail.append(R01MDateUtils.dateTimeSecondsToStr((Date)new Date(millisecondsOnDatabase), (String)"es"));
                    idxCompareFail.append(" (");
                    idxCompareFail.append(millisecondsOnDatabase);
                    idxCompareFail.append(" msecs)).\n");
                    if (DEBUG) {
                        String errorMsg = "El objeto " + objName + " tiene fechas distintas en AUTONOMY y en la Base de datos del Gestor de Contenidos." + idxCompareFail.toString();
                        R01FLog.to((String)LOG_TYPE_ID).info(errorMsg);
                        if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                            if (checkDIHMetas) {
                                R01KResultFormaterIndexer._traceIndex(objectOid, objType, 22, errorMsg, "");
                            } else {
                                R01KResultFormaterIndexer._traceIndex(objectOid, objType, 21, errorMsg, "");
                            }
                        }
                    }
                    return false;
                }
                if (millisecondsOnIDX == 0L) {
                    if (DEBUG) {
                        String errorMsg = "El objeto " + objName + " no tiene una fecha de publicaci\u00f3n indexada en AUTONOMY.";
                        R01FLog.to((String)LOG_TYPE_ID).info(errorMsg);
                        if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                            if (checkDIHMetas) {
                                R01KResultFormaterIndexer._traceIndex(objectOid, objType, 22, errorMsg, "");
                            } else {
                                R01KResultFormaterIndexer._traceIndex(objectOid, objType, 21, errorMsg, "");
                            }
                        }
                    }
                    return false;
                }
            }
        } else {
            if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                if (checkDIHMetas) {
                    R01KResultFormaterIndexer._traceIndex(objectOid, objType, 22, "El objeto NO est\u00e1 indexado.", "");
                } else {
                    R01KResultFormaterIndexer._traceIndex(objectOid, objType, 21, "El objeto NO est\u00e1 indexado.", "");
                }
            }
            return false;
        }
        if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
            if (checkDIHMetas) {
                R01KResultFormaterIndexer._traceIndex(objectOid, objType, 42, null, "");
            } else {
                R01KResultFormaterIndexer._traceIndex(objectOid, objType, 41, null, "");
            }
        }
        return true;
    }
}

