/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01k.searchorchestrator.indexer.indexers;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.sql.DBManager;
import com.ejie.r01f.util.CollectionUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01k.searchorchestrator.indexer.indexers.R01KRDFIndexerProcessor;
import com.ejie.r01k.searchorchestrator.indexer.indexers.R01KSearchEngineIndexer;
import com.ejie.r01k.traceindex.R01KTraceIndexHelper;
import com.ejie.r01m.config.objects.publisher.R01MLogicalPublicationInfo;
import com.ejie.r01m.config.objects.publisher.R01MPublicationConfig;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MCatalogException;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MSearchIndexerException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.cataloguing.R01MStructureCatalog;
import com.ejie.r01m.objects.cataloguing.structures.R01MLabel;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MDataFile;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.contentmodel.R01MDocumentPublicationTarget;
import com.ejie.r01m.objects.searchengine.indexer.R01MBaseIndexableObject;
import com.ejie.r01m.services.R01MCatalogManagerAPI;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01p.objects.opendata.templating.R01PDataSetRecordFile;
import com.ejie.r01p.objects.opendata.templating.R01POpendataDatasetFile;
import com.ejie.r01p.objects.opendata.templating.R01POpendataDatasetItem;
import com.ejie.r01p.objects.opendata.templating.R01POpendataDatasetMapping;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public class R01KRDFIndexer
implements R01KSearchEngineIndexer {
    static boolean DEBUG = R01FLog.getLogLevel((String)"r01k.index").intValue() != Level.OFF.intValue();
    private static final String COMBOLIST_OID = XMLProperties.get((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"comboOpendataTemplateList", (String)"");
    static final transient String OPENDATA_URL = XMLProperties.getString((String)R01MConstants.API_APPCODE, (String)"opendata/url", (String)"http://opendata.euskadi.eus");
    private static int indexerType = R01KSearchEngineIndexer.CONTENT_TYPE_INDEXER;
    private transient Properties _props = null;

    public R01KRDFIndexer() {
    }

    public R01KRDFIndexer(Properties props) {
        this();
        this._props = props;
    }

    @Override
    public void setNativeDateFormat(String dateFormat) {
    }

    @Override
    public String getNativeDateFormat() {
        return null;
    }

    @Override
    public void setProperties(Properties props) {
        this._props = props;
    }

    @Override
    public Properties getProperties() {
        return this._props;
    }

    @Override
    public int getIndexerType() {
        return indexerType;
    }

    @Override
    public void index(String systemId, R01MBaseIndexableObject idxObj, int objType, List<String> metadataFileNames, Properties props) throws R01MSearchIndexerException {
        if (idxObj == null) {
            R01FLog.to((String)"r01k.index").severe("Se ha intentado indexar un objeto NULO!!!");
            return;
        }
        if (objType != 0 && objType != 1) {
            R01FLog.to((String)"r01k.index").severe("Se ha intentado ejecutar la indexaci\u00f3n de RDF para un objeto que no es contenido!!!");
            return;
        }
        String traceObjOid = idxObj.getOid();
        if (props != null && props.containsKey("objectOid")) {
            traceObjOid = props.getProperty("objectOid").toString();
        }
        if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
            this._traceIndex(traceObjOid, objType, 1, "");
        }
        R01MContent content = null;
        try {
            content = R01MClientFactory.getContentModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext()).loadContent(idxObj.getOid());
        }
        catch (Exception ex) {
            String errorMsg = "Error al cargar el contenido de Oid " + idxObj.getOid() + ". Mensaje: " + ex.getMessage();
            R01FLog.to((String)"r01k.index").severe(errorMsg);
            if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                this._traceIndex(traceObjOid, objType, 2, errorMsg);
            }
            return;
        }
        try {
            StringBuffer rdfFile = this._getRDFContent(content);
            R01KRDFIndexerProcessor idxProc = new R01KRDFIndexerProcessor();
            idxProc.execIndexContent(content, rdfFile);
        }
        catch (R01MSearchIndexerException idxExc) {
            if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                this._traceIndex(traceObjOid, objType, 2, "Error:" + idxExc.getMessage());
            }
            throw idxExc;
        }
        catch (Exception e) {
            if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                this._traceIndex(traceObjOid, objType, 2, "Error general:" + e.getMessage());
            }
            throw new R01MSearchIndexerException(e);
        }
        if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
            this._traceIndex(traceObjOid, objType, 3, "");
        }
        if (DEBUG) {
            R01FLog.to((String)"r01k.index").info("El fichero RDF se ha generado con \u00e9xito.");
        }
    }

    @Override
    public void unIndex(String systemId, String objectOid, int objectType, boolean traceIndex) throws R01MSearchIndexerException {
    }

    @Override
    public void unIndex(String systemId, R01MBaseIndexableObject idxObj, String objectOid, int objectType, boolean traceIndex) throws R01MSearchIndexerException {
        this.unIndex(systemId, objectOid, objectType, traceIndex);
    }

    @Override
    public boolean checkIndex(String systemId, String objOid, int objType) throws R01MSearchIndexerException {
        if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
            this._traceIndex(objOid, objType, 4, "");
        }
        return true;
    }

    @Override
    public boolean checkUnIndex(String systemId, String objOid, int objType) throws R01MSearchIndexerException {
        if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
            this._traceIndex(objOid, objType, 4, "");
        }
        return true;
    }

    private StringBuffer _getRDFContent(R01MContent content) throws R01MSearchIndexerException {
        StringBuffer outRDF = new StringBuffer(2000);
        R01MDocument documentResume = null;
        R01MDataFile dataFile = null;
        ArrayList<R01MDocument> publishedDocuments = new ArrayList<R01MDocument>();
        HashMap<String, R01PDataSetRecordFile> datasets = new HashMap<String, R01PDataSetRecordFile>();
        Object objDocument2 = null;
        if (content.getDocuments() != null && !content.getDocuments().isEmpty()) {
            R01MPublicationConfig pub;
            try {
                pub = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(content.getStoreLocation().getWorkAreaOid()).getAllowedPublicationTargetsConfig();
            }
            catch (R01MConfigLoadException cfgExc) {
                R01FLog.to((String)"r01k.index").severe("Error al obtener los repositorios de publicaci\u00f3n de la workarea, los documentos del contenido " + content.getOid() + " no se publican.Error:" + cfgExc.getMessage());
                throw new R01MSearchIndexerException("Error al obtener los repositorios de publicaci\u00f3n de la workarea, los documentos del contenido " + content.getOid() + " no se publican.", (Exception)((Object)cfgExc));
            }
            if (pub.getAllowedTargets() != null && !pub.getAllowedTargets().isEmpty()) {
                for (Object objDocument2 : content.getDocuments().values()) {
                    R01PDataSetRecordFile dataset;
                    boolean isDocPublished = false;
                    documentResume = objDocument2;
                    for (String targetRepOid : pub.getAllowedTargets().keySet()) {
                        try {
                            if (!R01MClientFactory.getContentModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext()).isDocumentPublished(targetRepOid, documentResume.getOid())) continue;
                            isDocPublished = true;
                            break;
                        }
                        catch (R01MSecurityException ex) {
                            R01FLog.to((String)"r01k.index").severe("Error de seguridad para el documento: [" + documentResume.getOid() + "].Error:" + ex.getMessage());
                            throw new R01MSearchIndexerException("Error de seguridad para el documento: [" + documentResume.getOid() + "]", (Exception)((Object)ex));
                        }
                        catch (R01MContentModelException ex) {
                            R01FLog.to((String)"r01k.index").severe("Error al saber si un documento est\u00e1 publicado o no para el oid: [" + documentResume.getOid() + "].Error:" + ex.getMessage());
                            throw new R01MSearchIndexerException("Error al saber si un documento est\u00e1 publicado o no para el oid: [" + documentResume.getOid() + "]", (Exception)((Object)ex));
                        }
                    }
                    if (!isDocPublished) continue;
                    try {
                        content = R01MClientFactory.getContentModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext()).loadContentDocumentLazy(content, documentResume.getOid());
                    }
                    catch (R01MSecurityException ex) {
                        R01FLog.to((String)"r01k.index").severe("Error de seguridad para el documento: [" + documentResume.getOid() + "].Error:" + ex.getMessage());
                        throw new R01MSearchIndexerException("Error de seguridad para el documento: [" + documentResume.getOid() + "]", (Exception)((Object)ex));
                    }
                    catch (R01MContentModelException ex) {
                        R01FLog.to((String)"r01k.index").severe("Error al saber si un documento est\u00e1 publicado o no para el oid: [" + documentResume.getOid() + "].Error:" + ex.getMessage());
                        throw new R01MSearchIndexerException("Error al saber si un documento est\u00e1 publicado o no para el oid: [" + documentResume.getOid() + "]", (Exception)((Object)ex));
                    }
                    R01MDocument document = content.getDocument(documentResume.getOid());
                    publishedDocuments.add(document);
                    if (document.getDataFiles() == null || document.getDataFiles().isEmpty()) continue;
                    dataFile = (R01MDataFile)document.getDataFiles().values().iterator().next();
                    try {
                        dataset = R01POpendataDatasetMapping.mapObject((R01MUserContext)R01MAuthManager.createMasterSystemUserContext(), (R01MContent)content, (R01MDocument)document, (String)dataFile.getOid());
                    }
                    catch (R01MSecurityException secExc) {
                        throw new R01MSearchIndexerException("El contexto de usuario no es valido, o el usuario no tiene acceso.", (Exception)((Object)secExc));
                    }
                    if (dataset == null) continue;
                    datasets.put(document.getOid(), dataset);
                }
            }
            outRDF = this._formatAsRDF(content, publishedDocuments, datasets);
            outRDF = this._decorateRDF(outRDF);
        }
        return outRDF;
    }

    private StringBuffer _formatAsRDF(R01MContent content, List publishedDocuments, Map datasets) {
        StringBuffer rdfFile = new StringBuffer(471);
        rdfFile.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n");
        rdfFile.append("<rdf:RDF xmlns:cc=\"http://creativecommons.org/ns#\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:dctype=\"http://purl.org/dc/dcmitype/\" xmlns:foaf=\"http://xmlns.com/foaf/0.1/\" xmlns:prv=\"http://purl.org/net/provenance/ns#\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\" xmlns:void=\"http://rdfs.org/ns/void#\">\r\n");
        if (publishedDocuments != null && !publishedDocuments.isEmpty()) {
            R01MDocument document2 = null;
            R01MDocument es_document = null;
            R01PDataSetRecordFile dataset = null;
            R01PDataSetRecordFile es_dataset = null;
            for (R01MDocument document2 : publishedDocuments) {
                if (!document2.getLanguage().equals("es")) continue;
                es_document = document2;
                break;
            }
            if (es_document != null) {
                Map logicalPublications = null;
                try {
                    logicalPublications = R01MClientFactory.getPublisherConfigAPI().getLogicalPublicationsConfigs();
                }
                catch (R01MConfigLoadException ex) {
                    // empty catch block
                }
                String contentAlias = "contenidos";
                if (logicalPublications != null && es_document.getPublicationInfo() != null && !es_document.getPublicationInfo().isEmpty()) {
                    for (R01MDocumentPublicationTarget currPublication : es_document.getPublicationInfo()) {
                        if (currPublication.getState() != 1 || !logicalPublications.containsKey(currPublication.getOid())) continue;
                        contentAlias = ((R01MLogicalPublicationInfo)logicalPublications.get(currPublication.getOid())).getContentAlias();
                        if (!StringUtils.isEmptyString((String)contentAlias)) break;
                        contentAlias = "contenidos";
                        break;
                    }
                }
                String contentUrl = OPENDATA_URL + "/" + contentAlias + "/" + content.getTypo().getTypeOid() + "/" + content.getInternalName();
                String documentUrl = contentUrl + "/" + es_document.getInternalName() + "/";
                rdfFile.append("<dctype:Dataset rdf:about=\"");
                rdfFile.append(documentUrl);
                if (document2.getDataFiles() != null && !document2.getDataFiles().isEmpty()) {
                    String datafileUrl = ((R01MDataFile)document2.getDataFiles().values().iterator().next()).getName();
                    documentUrl = documentUrl + datafileUrl;
                    rdfFile.append(datafileUrl);
                }
                rdfFile.append("\">\r\n");
                rdfFile.append("<dcterms:identifier>");
                rdfFile.append(content.getInternalName());
                rdfFile.append("</dcterms:identifier>\r\n");
                for (R01MDocument document2 : publishedDocuments) {
                    rdfFile.append("<dcterms:language rdf:datatype=\"dcterms:RFC4646\">");
                    rdfFile.append(document2.getLanguage());
                    rdfFile.append("</dcterms:language>\r\n");
                }
                for (R01MDocument document2 : publishedDocuments) {
                    dataset = (R01PDataSetRecordFile)datasets.get(document2.getOid());
                    if (dataset == null) continue;
                    if (document2.getLanguage().equals("es")) {
                        es_dataset = dataset;
                    }
                    rdfFile.append("<dcterms:title xml:lang=\"");
                    rdfFile.append(document2.getLanguage());
                    rdfFile.append("\">");
                    rdfFile.append(StringUtils.isEmptyString((String)dataset.getGeneralData().getDenomination()) ? "" : StringEscapeUtils.escapeXml((String)dataset.getGeneralData().getDenomination()));
                    rdfFile.append("</dcterms:title>\r\n");
                }
                for (R01MDocument document2 : publishedDocuments) {
                    dataset = (R01PDataSetRecordFile)datasets.get(document2.getOid());
                    if (dataset == null) continue;
                    rdfFile.append("<rdfs:label xml:lang=\"");
                    rdfFile.append(document2.getLanguage());
                    rdfFile.append("\">");
                    rdfFile.append(StringUtils.isEmptyString((String)dataset.getGeneralData().getDenomination()) ? "" : StringEscapeUtils.escapeXml((String)dataset.getGeneralData().getDenomination()));
                    rdfFile.append("</rdfs:label>\r\n");
                }
                for (R01MDocument document2 : publishedDocuments) {
                    dataset = (R01PDataSetRecordFile)datasets.get(document2.getOid());
                    if (dataset == null) continue;
                    rdfFile.append("<dcterms:description xml:lang=\"");
                    rdfFile.append(document2.getLanguage());
                    rdfFile.append("\">");
                    rdfFile.append(StringUtils.isEmptyString((String)dataset.getGeneralData().getDescription()) ? "" : StringEscapeUtils.escapeXml((String)StringEscapeUtils.unescapeHtml((String)StringUtils.filterInvalidXMLCharacters((String)dataset.getGeneralData().getDescription().replaceAll("</?\\w++[^>]*+>", "")))));
                    rdfFile.append("</dcterms:description>\r\n");
                }
                if (es_dataset != null) {
                    rdfFile.append("<dcterms:issued rdf:datatype=\"dcterms:W3CDTF\">");
                    rdfFile.append(es_dataset.getDetailsData().getCreateData());
                    rdfFile.append("</dcterms:issued>\r\n");
                    rdfFile.append("<dcterms:modified rdf:datatype=\"dcterms:W3CDTF\">");
                    rdfFile.append(es_dataset.getDetailsData().getUpdateDate());
                    rdfFile.append("</dcterms:modified>\r\n");
                }
                rdfFile.append("<dcterms:accrualPeriodicity rdf:parseType=\"Resource\">\r\n\t<rdf:type rdf:resource=\"http://purl.org/dc/terms/Frequency\" />\r\n");
                for (R01MDocument document2 : publishedDocuments) {
                    dataset = (R01PDataSetRecordFile)datasets.get(document2.getOid());
                    if (dataset == null) continue;
                    rdfFile.append("\t<rdfs:label xml:lang=\"");
                    rdfFile.append(document2.getLanguage());
                    rdfFile.append("\">");
                    rdfFile.append(StringUtils.isEmptyString((String)dataset.getDetailsData().getPeriodicity()) ? "" : "$[" + dataset.getDetailsData().getPeriodicity() + "_" + document2.getLanguage() + "]$");
                    rdfFile.append("</rdfs:label>\r\n");
                    rdfFile.append("\t<rdfs:comment xml:lang=\"");
                    rdfFile.append(document2.getLanguage());
                    rdfFile.append("\">");
                    rdfFile.append(StringUtils.isEmptyString((String)dataset.getDetailsData().getPeriodicity()) ? "" : StringEscapeUtils.escapeXml((String)MessageFormat.format(R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)document2.getLanguage(), (String)"rdf.frecuencia"), "$[" + dataset.getDetailsData().getPeriodicity() + "_" + document2.getLanguage() + "]$")));
                    rdfFile.append("</rdfs:comment>\r\n");
                }
                rdfFile.append("</dcterms:accrualPeriodicity>\r\n");
                if (!(es_dataset == null || es_dataset.getDetailsData() == null || StringUtils.isEmptyString((String)es_dataset.getDetailsData().getStartUpPeriod()) && StringUtils.isEmptyString((String)es_dataset.getDetailsData().getEndPeriod()))) {
                    rdfFile.append("<dcterms:valid rdf:parseType=\"Resource\">\r\n\t<rdf:type rdf:resource=\"http://purl.org/dc/terms/PeriodOfTime\" />\r\n");
                    for (R01MDocument document2 : publishedDocuments) {
                        rdfFile.append("\t<rdfs:label xml:lang=\"");
                        rdfFile.append(document2.getLanguage());
                        rdfFile.append("\">");
                        rdfFile.append(StringEscapeUtils.escapeXml((String)R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)document2.getLanguage(), (String)"rdf.periodo.title")));
                        rdfFile.append("</rdfs:label>\r\n");
                        rdfFile.append("\t<rdfs:comment xml:lang=\"");
                        rdfFile.append(document2.getLanguage());
                        rdfFile.append("\">");
                        rdfFile.append(StringEscapeUtils.escapeXml((String)R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)document2.getLanguage(), (String)"rdf.periodo.descripcion")));
                        rdfFile.append("</rdfs:comment>\r\n");
                    }
                    rdfFile.append("\t<dcterms:date rdf:datatype=\"dcterms:W3CDTF\">");
                    rdfFile.append(es_dataset.getDetailsData().getStartUpPeriod());
                    rdfFile.append("</dcterms:date>\r\n");
                    rdfFile.append("\t<dcterms:date rdf:datatype=\"dcterms:W3CDTF\">");
                    rdfFile.append(es_dataset.getDetailsData().getEndPeriod());
                    rdfFile.append("</dcterms:date>\r\n");
                    rdfFile.append("</dcterms:valid>\r\n");
                }
                rdfFile.append("<dcterms:spatial rdf:resource=\"http://sws.geonames.org/3336903/\" />\r\n<dcterms:spatial rdf:resource=\"http://sws.geonames.org/3130717/\" />\r\n<dcterms:spatial rdf:resource=\"http://sws.geonames.org/3104469/\" />\r\n<dcterms:spatial rdf:resource=\"http://sws.geonames.org/3120935/\" />\r\n");
                if (dataset != null && dataset.getGeneralData() != null) {
                    if (dataset.getGeneralData().isStatistic()) {
                        rdfFile.append("<dcterms:creator><dcterms:Agent rdf:about=\"http://www.eustat.es/\">\r\n");
                        for (R01MDocument document2 : publishedDocuments) {
                            dataset = (R01PDataSetRecordFile)datasets.get(document2.getOid());
                            rdfFile.append("\t<rdfs:label xml:lang=\"");
                            rdfFile.append(document2.getLanguage());
                            rdfFile.append("\">");
                            rdfFile.append(StringUtils.isEmptyString((String)dataset.getDetailsData().getDptoSource()) ? "" : StringEscapeUtils.escapeXml((String)dataset.getDetailsData().getDptoSource()));
                            rdfFile.append("</rdfs:label>\r\n\t<rdfs:comment xml:lang=\"");
                            rdfFile.append(document2.getLanguage());
                            rdfFile.append("\">");
                            rdfFile.append(StringEscapeUtils.escapeXml((String)R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)document2.getLanguage(), (String)"rdf.creador.eustat.descripcion")));
                            rdfFile.append("</rdfs:comment>\r\n");
                        }
                        rdfFile.append("</dcterms:Agent>\r\n</dcterms:creator>\r\n<prv:createdBy rdf:resource=\"http://www.eustat.es/\" />\r\n");
                    } else {
                        rdfFile.append("<dcterms:creator>\r\n<dcterms:Agent rdf:about=\"http://www.ejgv.euskadi.eus/\">\r\n");
                        for (R01MDocument document2 : publishedDocuments) {
                            rdfFile.append("\t<rdfs:label xml:lang=\"");
                            rdfFile.append(document2.getLanguage());
                            rdfFile.append("\">");
                            rdfFile.append(StringEscapeUtils.escapeXml((String)R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)document2.getLanguage(), (String)"rdf.creador.gobierno.descripcion")));
                            rdfFile.append("</rdfs:label>\r\n");
                        }
                        for (R01MDocument document2 : publishedDocuments) {
                            rdfFile.append("\t<rdfs:comment xml:lang=\"");
                            rdfFile.append(document2.getLanguage());
                            rdfFile.append("\">");
                            rdfFile.append(StringEscapeUtils.escapeXml((String)dataset.getDetailsData().getDptoSource()));
                            rdfFile.append("</rdfs:comment>\r\n");
                        }
                        rdfFile.append("</dcterms:Agent>\r\n</dcterms:creator>\r\n<prv:createdBy rdf:resource=\"http://www.ejgv.euskadi.eus/\" />\r\n");
                    }
                }
                rdfFile.append("<dcterms:publisher>\r\n<dcterms:Agent rdf:about=\"");
                rdfFile.append(OPENDATA_URL);
                rdfFile.append("/\">\r\n");
                for (R01MDocument document2 : publishedDocuments) {
                    rdfFile.append("\t<rdfs:label xml:lang=\"");
                    rdfFile.append(document2.getLanguage());
                    rdfFile.append("\">");
                    rdfFile.append(StringEscapeUtils.escapeXml((String)R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)document2.getLanguage(), (String)"rdf.publicador.title")));
                    rdfFile.append("</rdfs:label>\r\n");
                    rdfFile.append("\t<rdfs:comment xml:lang=\"");
                    rdfFile.append(document2.getLanguage());
                    rdfFile.append("\">");
                    rdfFile.append(StringEscapeUtils.escapeXml((String)R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)document2.getLanguage(), (String)"rdf.publicador.descripcion")));
                    rdfFile.append("</rdfs:comment>\r\n");
                }
                rdfFile.append("</dcterms:Agent>\r\n</dcterms:publisher>\r\n");
                rdfFile.append("<foaf:homepage rdf:resource=\"");
                rdfFile.append(documentUrl);
                rdfFile.append("\" />\r\n");
                for (R01MDocument document2 : publishedDocuments) {
                    dataset = (R01PDataSetRecordFile)datasets.get(document2.getOid());
                    if (dataset == null || dataset.getGeneralData().getDownloadDataset() == null || dataset.getGeneralData().getDownloadDataset().isEmpty()) continue;
                    R01POpendataDatasetItem datasetItem2 = null;
                    for (R01POpendataDatasetItem datasetItem2 : dataset.getGeneralData().getDownloadDataset()) {
                        rdfFile.append("<dcterms:hasFormat>\r\n<dcterms:FileFormat rdf:about=\"");
                        rdfFile.append(StringEscapeUtils.escapeXml((String)(datasetItem2.getContentRelativePath().toLowerCase().indexOf("http:") != -1 ? datasetItem2.getContentRelativePath() : OPENDATA_URL + datasetItem2.getContentRelativePath())));
                        rdfFile.append("\">\r\n");
                        rdfFile.append("<dcterms:format>\r\n<dcterms:IMT>\r\n\t<rdf:value>");
                        rdfFile.append(datasetItem2.getMimeType());
                        rdfFile.append("</rdf:value>\r\n\t<rdfs:label>");
                        rdfFile.append(StringUtils.isEmptyString((String)datasetItem2.getType()) ? "" : "$[" + datasetItem2.getType() + "_" + document2.getLanguage() + "]$");
                        rdfFile.append("</rdfs:label>\r\n</dcterms:IMT>\r\n</dcterms:format>\r\n<dcterms:extent>\r\n<dcterms:SizeOrDuration>\r\n<rdf:value>");
                        rdfFile.append(datasetItem2.getSize());
                        rdfFile.append(" ");
                        rdfFile.append(StringUtils.isEmptyString((String)datasetItem2.getUnits()) ? "" : "$[" + datasetItem2.getUnits() + "_" + document2.getLanguage() + "]$");
                        rdfFile.append("</rdf:value>\r\n<rdfs:label>");
                        rdfFile.append(StringEscapeUtils.escapeXml((String)R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)document2.getLanguage(), (String)"rdf.fichero.tamanio.descripcion")));
                        rdfFile.append("</rdfs:label>\r\n</dcterms:SizeOrDuration>\r\n</dcterms:extent>\r\n");
                        if (datasetItem2.getType().toLowerCase().equals("csv")) {
                            rdfFile.append("<rdfs:comment xml:lang=\"en\">Comma Separated Values</rdfs:comment>");
                        } else {
                            rdfFile.append("<rdfs:comment xml:lang=\"");
                            rdfFile.append(document2.getLanguage());
                            rdfFile.append("\">");
                            rdfFile.append(StringUtils.isEmptyString((String)datasetItem2.getType()) ? "" : StringEscapeUtils.escapeXml((String)MessageFormat.format(R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)document2.getLanguage(), (String)"rdf.fichero.formato.descripcion"), "$[" + datasetItem2.getType() + "_" + document2.getLanguage() + "]$")));
                            rdfFile.append("</rdfs:comment>\r\n");
                        }
                        rdfFile.append("</dcterms:FileFormat>\r\n</dcterms:hasFormat>\r\n<void:feature>\r\n<void:TechnicalFeature  rdf:about=\"");
                        rdfFile.append(StringEscapeUtils.escapeXml((String)(datasetItem2.getContentRelativePath().toLowerCase().indexOf("http:") != -1 ? datasetItem2.getContentRelativePath() : OPENDATA_URL + datasetItem2.getContentRelativePath())));
                        rdfFile.append("\">\r\n");
                        rdfFile.append("<dcterms:format>\r\n<dcterms:IMT>\r\n\t<rdf:value>");
                        rdfFile.append(datasetItem2.getMimeType());
                        rdfFile.append("</rdf:value>\r\n\t<rdfs:label>");
                        rdfFile.append(StringUtils.isEmptyString((String)datasetItem2.getType()) ? "" : "$[" + datasetItem2.getType() + "_" + document2.getLanguage() + "]$");
                        rdfFile.append("</rdfs:label>\r\n</dcterms:IMT>\r\n</dcterms:format>\r\n<dcterms:extent>\r\n<dcterms:SizeOrDuration>\r\n<rdf:value>");
                        rdfFile.append(datasetItem2.getSize());
                        rdfFile.append(" ");
                        rdfFile.append(StringUtils.isEmptyString((String)datasetItem2.getUnits()) ? "" : "$[" + datasetItem2.getUnits() + "_" + document2.getLanguage() + "]$");
                        rdfFile.append("</rdf:value>\r\n<rdfs:label>");
                        rdfFile.append(StringEscapeUtils.escapeXml((String)R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)document2.getLanguage(), (String)"rdf.fichero.tamanio.descripcion")));
                        rdfFile.append("</rdfs:label>\r\n</dcterms:SizeOrDuration>\r\n</dcterms:extent>\r\n");
                        if (datasetItem2.getType().toLowerCase().equals("csv")) {
                            rdfFile.append("<rdfs:comment xml:lang=\"en\">Comma Separated Values</rdfs:comment>");
                        } else {
                            rdfFile.append("<rdfs:comment xml:lang=\"");
                            rdfFile.append(document2.getLanguage());
                            rdfFile.append("\">");
                            rdfFile.append(StringUtils.isEmptyString((String)datasetItem2.getType()) ? "" : StringEscapeUtils.escapeXml((String)MessageFormat.format(R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)document2.getLanguage(), (String)"rdf.fichero.formato.descripcion"), "$[" + datasetItem2.getType() + "_" + document2.getLanguage() + "]$")));
                            rdfFile.append("</rdfs:comment>\r\n");
                        }
                        rdfFile.append("</void:TechnicalFeature>\r\n</void:feature>\r\n");
                    }
                }
                if (dataset != null && dataset.getGeneralData().isStatistic()) {
                    rdfFile.append("<dcterms:rights rdf:resource=\"http://www.eustat.es/informacionLegal_c.html\"/>\r\n");
                } else if (content.getTypo().getTypeOid().equals("ds_meteorologicos")) {
                    rdfFile.append("<dcterms:rights rdf:resource=\"http://www.euskalmet.euskadi.eus/s07-5893/es/");
                    rdfFile.append("contenidos");
                    rdfFile.append("/informacion/informacion_legal/es_6303/informacion_legal.html\" />\r\n");
                } else {
                    rdfFile.append("<dcterms:rights rdf:resource=\"");
                    rdfFile.append(OPENDATA_URL);
                    rdfFile.append("/w79-contgen/es/");
                    rdfFile.append("contenidos");
                    rdfFile.append("/informacion/info_legal/es_info_leg/info_legal.html\"/>\r\n");
                }
                if (content.getLabels() != null && !content.getLabels().isEmpty()) {
                    R01MStructureCatalog structureCatalog2 = null;
                    R01MLabel label = null;
                    R01MCatalogManagerAPI catalogAPI = new R01MCatalogManagerAPI();
                    for (R01MStructureCatalog structureCatalog2 : content.getLabels()) {
                        try {
                            String labelValue = "";
                            label = catalogAPI.loadLabel(structureCatalog2.getOid(), false);
                            if (label != null && label.getStandardizedTerm("en") != null) {
                                labelValue = label.getStandardizedTerm("en").getValue();
                            } else if (label != null && label.getStandardizedTerm("es") != null) {
                                labelValue = label.getStandardizedTerm("es").getValue();
                                labelValue = labelValue.replaceAll("[\u00c0\u00c1\u00c4\u00e1\u00e0\u00e4]", "a").replaceAll("[\u00c8\u00c9\u00cb\u00e8\u00e9\u00eb]", "e").replaceAll("[\u00cc\u00cd\u00cf\u00ec\u00ed\u00ef]", "i").replaceAll("[\u00d2\u00d3\u00d6\u00f2\u00f3\u00f6]", "o").replaceAll("[\u00d9\u00da\u00dc\u00f9\u00fa\u00fc]", "u").replaceAll("[\u00d1\u00f1]", "n");
                            } else if (label != null && label.getStandardizedTerm("eu") != null) {
                                labelValue = label.getStandardizedTerm("eu").getValue();
                            }
                            if (StringUtils.isEmptyString((String)labelValue)) continue;
                            labelValue = labelValue.trim().replaceAll("[\\s]+", " ");
                            labelValue = StringUtils.capitalizeAllFirstLetters((String)labelValue);
                            labelValue = labelValue.replaceAll(" ", "_").replaceAll("[,+:]/", "").replaceAll("['\u00b4]", "_");
                            rdfFile.append("<dcterms:subject rdf:resource=\"");
                            rdfFile.append(OPENDATA_URL);
                            rdfFile.append("/taxonomy/labels/");
                            rdfFile.append(StringEscapeUtils.escapeXml((String)StringUtils.capitalizeAllFirstLetters((String)labelValue.trim()).replaceAll(" ", "_")));
                            rdfFile.append("\" />\r\n");
                        }
                        catch (R01MCatalogException ex1) {
                            R01FLog.to((String)"r01k.index").warning("Excepci\u00f3n a la hora de recuperar la etiqueta");
                        }
                    }
                }
                rdfFile.append("<dcterms:subject rdf:resource=\"");
                rdfFile.append(OPENDATA_URL);
                rdfFile.append("/taxonomy/types/");
                rdfFile.append(StringEscapeUtils.escapeXml((String)StringUtils.capitalizeAllFirstLetters((String)content.getTypo().getTypeOid())));
                rdfFile.append("\" />\r\n");
                for (R01MDocument document2 : publishedDocuments) {
                    dataset = (R01PDataSetRecordFile)datasets.get(document2.getOid());
                    if (dataset == null) continue;
                    String[] etiquetas = null;
                    if (dataset.getDetailsData() == null || dataset.getDetailsData().getTags() == null) continue;
                    etiquetas = dataset.getDetailsData().getTags().split(",");
                    for (int i = 0; i < etiquetas.length; ++i) {
                        rdfFile.append("<dcterms:subject xml:lang=\"");
                        rdfFile.append(document2.getLanguage());
                        rdfFile.append("\">");
                        rdfFile.append(StringEscapeUtils.escapeXml((String)etiquetas[i].trim()));
                        rdfFile.append("</dcterms:subject>\r\n");
                    }
                }
                rdfFile.append("<void:subset rdf:resource=\"#dataset2Geonames\" />\r\n");
                for (R01MDocument document2 : publishedDocuments) {
                    dataset = (R01PDataSetRecordFile)datasets.get(document2.getOid());
                    if (dataset == null || dataset.getDatasetFiles() == null || dataset.getDatasetFiles().isEmpty()) continue;
                    R01POpendataDatasetFile datasetFile2 = null;
                    for (R01POpendataDatasetFile datasetFile2 : dataset.getDatasetFiles()) {
                        rdfFile.append("<dcterms:references rdf:parseType=\"Resource\">\r\n<rdf:type rdf:resource=\"http://xmlns.com/foaf/0.1/Document\" />\r\n<rdfs:label xml:lang=\"");
                        rdfFile.append(document2.getLanguage());
                        rdfFile.append("\">");
                        rdfFile.append(StringEscapeUtils.escapeXml((String)datasetFile2.getText()));
                        rdfFile.append("</rdfs:label>\r\n<foaf:homepage rdf:resource=\"");
                        rdfFile.append(StringEscapeUtils.escapeXml((String)datasetFile2.getContentRelativePath()));
                        rdfFile.append("\" />\r\n");
                        rdfFile.append("</dcterms:references>\r\n");
                    }
                }
                rdfFile.append("</dctype:Dataset>\r\n<dctype:Dataset rdf:about=\"#Geonames\">\r\n");
                for (R01MDocument document2 : publishedDocuments) {
                    rdfFile.append("<rdfs:comment xml:lang=\"");
                    rdfFile.append(document2.getLanguage());
                    rdfFile.append("\">");
                    rdfFile.append(StringEscapeUtils.escapeXml((String)R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)document2.getLanguage(), (String)"rdf.geonames.descripcion")));
                    rdfFile.append("</rdfs:comment>\r\n");
                    rdfFile.append("<rdfs:label xml:lang=\"");
                    rdfFile.append(document2.getLanguage());
                    rdfFile.append("\">");
                    rdfFile.append("GeoNames</rdfs:label>\r\n");
                }
                rdfFile.append("<foaf:homepage rdf:resource=\"http://sws.geonames.org\" />\r\n</dctype:Dataset>\r\n<void:Linkset rdf:about=\"#dataset2Geonames\">\r\n<dcterms:subject rdf:resource=\"http://dbpedia.org/resource/Location_%28geography%29\" />\r\n<void:linkPredicate rdf:resource=\"http://purl.org/dc/terms#spatial\" />\r\n<void:objectsTarget rdf:resource=\"#Geonames\" />\r\n<void:subjectsTarget rdf:resource=\"");
                rdfFile.append(OPENDATA_URL);
                rdfFile.append('/');
                rdfFile.append(contentAlias);
                rdfFile.append('/');
                rdfFile.append(content.getTypo().getTypeOid());
                rdfFile.append('/');
                rdfFile.append(content.getInternalName());
                rdfFile.append('/');
                rdfFile.append(es_document.getInternalName());
                rdfFile.append("\" />\r\n");
                for (R01MDocument document2 : publishedDocuments) {
                    rdfFile.append("<rdfs:comment xml:lang=\"");
                    rdfFile.append(document2.getLanguage());
                    rdfFile.append("\">");
                    rdfFile.append(StringEscapeUtils.escapeXml((String)R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)document2.getLanguage(), (String)"rdf.dataset2Geonames.descripcion")));
                    rdfFile.append("</rdfs:comment>\r\n");
                    rdfFile.append("<rdfs:label xml:lang=\"");
                    rdfFile.append(document2.getLanguage());
                    rdfFile.append("\">");
                    rdfFile.append(StringEscapeUtils.escapeXml((String)R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)document2.getLanguage(), (String)"rdf.dataset2Geonames.title")));
                    rdfFile.append("</rdfs:label>\r\n");
                }
                rdfFile.append("</void:Linkset>\r\n");
            }
        }
        rdfFile.append("</rdf:RDF>");
        return rdfFile;
    }

    private StringBuffer _decorateRDF(StringBuffer rdf) {
        Map comboMap = null;
        StringBuffer finalRDF = new StringBuffer("");
        try {
            comboMap = this._obtainComboValues();
        }
        catch (SQLException ex) {
            ex.printStackTrace(System.out);
        }
        Pattern p = Pattern.compile("\\$\\[([^\\$\\[\\]\\$]*)\\]\\$");
        Matcher m = p.matcher(rdf);
        while (m.find()) {
            if (comboMap.containsKey(m.group(1))) {
                m.appendReplacement(finalRDF, (String)comboMap.get(m.group(1)));
                continue;
            }
            m.appendReplacement(finalRDF, "");
        }
        m.appendTail(finalRDF);
        return finalRDF;
    }

    private Map _obtainComboValues() throws SQLException {
        String[] cols = new String[]{"R01D21T01.PK_21,R01D21T01.NOMBRE_21,R01D21T01.HTML_21,R01D21T01.IDIOMA_COMBO_21"};
        String[] tables = new String[]{"R01D21T01"};
        String where = "COMBO_ID_21 IN (" + COMBOLIST_OID + ")";
        ArrayList params = new ArrayList(3);
        DBManager dbManager = new DBManager(R01MConstants.CONTENTMANAGER_APPCODE, "contentQueryConnection");
        List rows = dbManager.executeSelect(CollectionUtils.strArrayToList((String[])cols), CollectionUtils.strArrayToList((String[])tables), params, where, null, false, false);
        if (rows == null) {
            return null;
        }
        LinkedHashMap<String, String> comboValues = new LinkedHashMap<String, String>(rows.size());
        Map aux = null;
        for (int i = 0; i < rows.size(); ++i) {
            aux = (Map)rows.get(i);
            comboValues.put(aux.get("PK_21") + "_" + aux.get("IDIOMA_COMBO_21"), StringUtils.encodeUTF((String)aux.get("NOMBRE_21").toString()));
        }
        return comboValues;
    }

    private void _traceIndex(String objOid, int objType, int action, String errorMsg) {
        if (objType == 1) {
            switch (action) {
                case 1: {
                    R01KTraceIndexHelper.execRdfTraceIndexInit((String)objOid);
                    break;
                }
                case 2: {
                    R01KTraceIndexHelper.execRdfTraceIndexEndErr((String)objOid, (String)errorMsg);
                    break;
                }
                case 3: {
                    R01KTraceIndexHelper.execRdfTraceIndexEnd((String)objOid);
                    break;
                }
                case 4: {
                    R01KTraceIndexHelper.execRdfCheckIndexOK((String)objOid);
                    break;
                }
            }
        } else if (objType == 0) {
            try {
                R01MContent theContent = R01MClientFactory.getContentModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext()).loadContent(objOid);
                if (theContent.getDocuments() != null && !theContent.getDocuments().isEmpty()) {
                    for (String documentOid : theContent.getDocuments().keySet()) {
                        switch (action) {
                            case 1: {
                                R01KTraceIndexHelper.execRdfTraceIndexInit((String)documentOid);
                                break;
                            }
                            case 2: {
                                R01KTraceIndexHelper.execRdfTraceIndexEndErr((String)documentOid, (String)errorMsg);
                                break;
                            }
                            case 3: {
                                R01KTraceIndexHelper.execRdfTraceIndexEnd((String)documentOid);
                                break;
                            }
                            case 4: {
                                R01KTraceIndexHelper.execRdfCheckIndexOK((String)documentOid);
                                break;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }
}

