/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01k.searchorchestrator.indexer.indexers;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01k.searchorchestrator.indexer.indexers.R01KAutonomyIndexer;
import com.ejie.r01m.exceptions.R01MSearchIndexerException;
import com.ejie.r01m.objects.searchengine.indexer.R01MBaseIndexableObject;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;

public class R01KLuceneIndexer
extends R01KAutonomyIndexer {
    static boolean DEBUG = R01FLog.getLogLevel((String)"r01k.index").intValue() != Level.OFF.intValue();
    private Properties _props = null;

    public R01KLuceneIndexer() {
    }

    public R01KLuceneIndexer(Properties props) {
        this();
        super.setProperties(props);
    }

    @Override
    public void setProperties(Properties props) {
        super.setProperties(props);
        this._props = props;
    }

    @Override
    public Properties getProperties() {
        return super.getProperties();
    }

    public void index(String systemId, R01MBaseIndexableObject idxObj, int objType) throws R01MSearchIndexerException {
        if (objType == 0) {
            try {
                this.unIndex(systemId, idxObj.getOid(), 0);
            }
            catch (Exception e) {}
        } else {
            throw new R01MSearchIndexerException("El tipo de objeto " + Integer.toString(objType) + " NO es valido para su indexacion en BD");
        }
        super.index(systemId, idxObj, objType, null, null);
    }

    public void index(String systemId, R01MBaseIndexableObject idxObj, int objType, List<String> metadataFileNames) throws R01MSearchIndexerException {
        if (objType == 0) {
            try {
                this.unIndex(systemId, idxObj.getOid(), 0);
            }
            catch (Exception e) {}
        } else {
            throw new R01MSearchIndexerException("El tipo de objeto " + Integer.toString(objType) + " NO es valido para su indexacion en BD");
        }
        super.index(systemId, idxObj, objType, metadataFileNames, null);
    }

    public void unIndex(String systemId, String objectOid, int objectType) throws R01MSearchIndexerException {
        if (objectType == 0) {
            if (this._props == null) {
                throw new R01MSearchIndexerException("NO se ha especificado la propiedad monitorFilePath en la configuracion del indexador para lucene. Revisa el fichero r01kSearchEngineConfig.xml!!!");
            }
            String deleteFilePath = this._props.getProperty("monitorFilePath");
            if (deleteFilePath == null) {
                throw new R01MSearchIndexerException("NO se ha especificado la propiedad monitorFilePath en la configuracion del indexador para lucene. Revisa el fichero r01kSearchEngineConfig.xml!!!");
            }
            String fileName = deleteFilePath + "lucene-" + Long.toString(System.currentTimeMillis()) + ".del";
            R01FLog.to((String)"r01k.index").info("Escribiendo fichero de borrado para lucene en el fichero: " + fileName);
            try {
                StringUtils.saveToFile((String)fileName, (String)objectOid);
            }
            catch (IOException ioEx) {
                ioEx.printStackTrace(System.out);
            }
        }
    }

    public void unIndex(String systemId, String objectOid, int objectType, String metadataFileName) throws R01MSearchIndexerException {
        if (objectType == 0) {
            if (this._props == null) {
                throw new R01MSearchIndexerException("NO se ha especificado la propiedad monitorFilePath en la configuracion del indexador para lucene. Revisa el fichero r01kSearchEngineConfig.xml!!!");
            }
            String deleteFilePath = this._props.getProperty("monitorFilePath");
            if (deleteFilePath == null) {
                throw new R01MSearchIndexerException("NO se ha especificado la propiedad monitorFilePath en la configuracion del indexador para lucene. Revisa el fichero r01kSearchEngineConfig.xml!!!");
            }
            String fileName = deleteFilePath + "lucene-" + Long.toString(System.currentTimeMillis()) + ".del";
            R01FLog.to((String)"r01k.index").info("Escribiendo fichero de borrado para lucene en el fichero: " + fileName);
            try {
                StringUtils.saveToFile((String)fileName, (String)objectOid);
            }
            catch (IOException ioEx) {
                ioEx.printStackTrace(System.out);
            }
        }
    }
}

