/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01k.searchorchestrator.indexer.indexers;

import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01k.searchorchestrator.indexer.indexers.R01KAutonomyIndexer;
import com.ejie.r01k.searchorchestrator.indexer.indexers.R01KIDXProcessor;
import com.ejie.r01k.traceindex.R01KTraceIndexHelper;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.datastore.R01MByExtenssionFilter;
import com.ejie.r01m.datastore.R01MDataStoreItemFilter;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MSearchIndexerException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.R01MBaseLocationObject;
import com.ejie.r01m.objects.contentmodel.R01MContentLocation;
import com.ejie.r01m.objects.datastore.R01MDataStoreItem;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableContent;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableDocument;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexablePortalPage;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MContentDataAPI;
import com.ejie.r01m.services.R01MPortalDataAPI;
import com.ejie.r01m.services.R01MPortalManagerAPI;
import com.ejie.r01m.services.R01MRawDataAPI;
import com.ejie.r01m.services.bzd.R01MRawDataManagerBzd;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MPathHelpper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class R01KInterwovenAutonomyIDXProcessor
implements R01KIDXProcessor {
    private static String LOG_TYPE_ID = "r01k.index";
    private static boolean DEBUG = R01FLog.getLogLevel((String)LOG_TYPE_ID).intValue() != Level.OFF.intValue();
    private static final String IDX_RELATIVE_PATH = XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"relativeIndexPath/contents", (String)"/r01Index/");

    @Override
    public void setProperties(Properties props) {
    }

    @Override
    public Properties getProperties() {
        return null;
    }

    @Override
    public void processIndexData(R01MIndexableContent idxCont, R01MIndexableDocument idxDoc, Map<String, StringBuffer> indexFilesData) throws R01MSearchIndexerException {
        if (idxCont != null && ReflectionUtils.isSameClassAs(idxCont.getClass(), R01MIndexableContent.class)) {
            R01MContentLocation loc = new R01MContentLocation(idxCont.getStorage().getServer().getOid(), idxCont.getStorage().getDataStore().getOid(), idxCont.getStorage().getArea().getOid(), idxCont.getStorage().getWorkArea().getOid());
            String WAPath = R01MPathHelpper.getLocationPath((R01MBaseLocationObject)loc);
            String waRelPath = idxCont.getWorkAreaRelativePath();
            if (waRelPath.endsWith("/") && IDX_RELATIVE_PATH.startsWith("/")) {
                waRelPath = waRelPath.substring(0, waRelPath.length());
            }
            if (indexFilesData != null & indexFilesData.size() > 0) {
                try {
                    R01MRawDataAPI rawDataApi = R01MClientFactory.getRawDataAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext());
                    for (Map.Entry<String, StringBuffer> entry : indexFilesData.entrySet()) {
                        String autonomyFileDocRelativePath = entry.getKey();
                        if (entry.getValue().length() <= 0) continue;
                        String indexData = indexFilesData.get(autonomyFileDocRelativePath).toString();
                        try {
                            String folderRelativePath;
                            boolean isContentFile = false;
                            if (autonomyFileDocRelativePath.startsWith("contentObject.")) {
                                isContentFile = true;
                                autonomyFileDocRelativePath = autonomyFileDocRelativePath.substring("contentObject.".length());
                            }
                            String string = folderRelativePath = autonomyFileDocRelativePath.lastIndexOf(47) > 0 ? autonomyFileDocRelativePath.substring(0, autonomyFileDocRelativePath.lastIndexOf(47)) : "";
                            if (folderRelativePath.startsWith("/") && IDX_RELATIVE_PATH.endsWith("/")) {
                                folderRelativePath = folderRelativePath.substring(1);
                            }
                            if (DEBUG) {
                                R01FLog.to((String)LOG_TYPE_ID).info("Escribiendo idx en el fichero: " + autonomyFileDocRelativePath + (idxDoc == null ? "del contenido " + idxCont.getOid() : "del documento " + idxDoc.getOid()));
                            }
                            if (isContentFile) {
                                if (!rawDataApi.checkFolder(WAPath, waRelPath + IDX_RELATIVE_PATH + folderRelativePath)) {
                                    rawDataApi.createFolder(WAPath, waRelPath + IDX_RELATIVE_PATH + folderRelativePath);
                                }
                            } else if (!rawDataApi.checkFolder(WAPath, waRelPath + IDX_RELATIVE_PATH + folderRelativePath)) {
                                rawDataApi.createFolder(WAPath, waRelPath + IDX_RELATIVE_PATH + folderRelativePath);
                            }
                            try {
                                if (autonomyFileDocRelativePath.endsWith("storage.idx")) {
                                    R01KTraceIndexHelper.execUpdateStorageIdxFile((String)idxDoc.getOid(), (String)indexData);
                                } else if (autonomyFileDocRelativePath.endsWith("typology.idx")) {
                                    R01KTraceIndexHelper.execUpdateTypologyIdxFile((String)idxDoc.getOid(), (String)indexData);
                                } else if (autonomyFileDocRelativePath.endsWith("catalog.idx")) {
                                    R01KTraceIndexHelper.execUpdateCatalogIdxFile((String)idxDoc.getOid(), (String)indexData);
                                } else if (autonomyFileDocRelativePath.endsWith("content.idx")) {
                                    R01KTraceIndexHelper.execUpdateContentIdxFile((String)idxDoc.getOid(), (String)indexData);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace(System.err);
                            }
                            R01MContentDataAPI dataAPI = R01MClientFactory.getContentDataAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext(), (String)idxCont.getOid());
                            if (isContentFile) {
                                dataAPI.uploadFileInContent(IDX_RELATIVE_PATH + autonomyFileDocRelativePath, (InputStream)new ByteArrayInputStream(indexData.getBytes()), true);
                                dataAPI.submmitFileInContent(IDX_RELATIVE_PATH + autonomyFileDocRelativePath);
                                continue;
                            }
                            dataAPI.uploadAttachmentFile(idxDoc.getOid(), IDX_RELATIVE_PATH + autonomyFileDocRelativePath, (InputStream)new ByteArrayInputStream(indexData.getBytes()), true);
                            dataAPI.submmitAttachmentFile(idxDoc.getOid(), IDX_RELATIVE_PATH + autonomyFileDocRelativePath);
                        }
                        catch (R01MSecurityException secEx) {
                            secEx.printStackTrace(System.out);
                        }
                        catch (R01MContentModelException cmEx) {
                            cmEx.printStackTrace(System.out);
                        }
                        catch (R01MDataStoreException dsEx) {
                            dsEx.printStackTrace(System.out);
                        }
                    }
                }
                catch (R01MSecurityException secEx) {
                    secEx.printStackTrace(System.out);
                }
            }
        } else if (idxCont != null && idxCont instanceof R01MIndexablePortalPage) {
            String portalOid;
            R01MPortalManagerAPI portalAPI;
            try {
                portalAPI = R01MClientFactory.getPortalModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext(), null);
            }
            catch (R01MSecurityException secExc) {
                throw new R01MSearchIndexerException("El contexto de usuario no es valido, o el usuario no tiene acceso.", (Exception)((Object)secExc));
            }
            try {
                portalOid = portalAPI.getPageParentPortalOid(idxCont.getOid());
            }
            catch (R01MPortalModelException pmEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error al cargar el portal de la p\u00e1gina " + (idxCont.getOid() != null ? idxCont.getOid() : "Objeto indexable o p\u00e1gina null") + ": " + " del lenguaje " + idxDoc.getOid() + " de la pagina " + idxCont.getOid());
                portalOid = null;
            }
            if (portalOid != null) {
                R01MPortalDataAPI dataAPI;
                try {
                    dataAPI = R01MClientFactory.getPortalDataAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext(), (String)portalOid);
                }
                catch (R01MSecurityException secExc) {
                    throw new R01MSearchIndexerException("El contexto de usuario no es valido, o el usuario no tiene acceso.", (Exception)((Object)secExc));
                }
                R01FLog.to((String)LOG_TYPE_ID).info("R01KInterwovenAutonomyIDXProcessor > Num ficheros de indexacion: " + indexFilesData.size());
                for (String autonomyFileDocRelativePath : indexFilesData.keySet()) {
                    if (indexFilesData.get(autonomyFileDocRelativePath).length() <= 0) continue;
                    try {
                        if (DEBUG) {
                            R01FLog.to((String)LOG_TYPE_ID).info("Escribiendo idx en el fichero: " + autonomyFileDocRelativePath + " del lenguaje " + idxDoc.getOid() + " de la pagina " + idxCont.getOid());
                        }
                        try {
                            if (autonomyFileDocRelativePath.endsWith("storage.idx")) {
                                R01KTraceIndexHelper.execUpdateStorageIdxFile((String)idxDoc.getOid(), (String)indexFilesData.get(autonomyFileDocRelativePath).toString());
                            } else if (autonomyFileDocRelativePath.endsWith("typology.idx")) {
                                R01KTraceIndexHelper.execUpdateTypologyIdxFile((String)idxDoc.getOid(), (String)indexFilesData.get(autonomyFileDocRelativePath).toString());
                            } else if (autonomyFileDocRelativePath.endsWith("catalog.idx")) {
                                R01KTraceIndexHelper.execUpdateCatalogIdxFile((String)idxDoc.getOid(), (String)indexFilesData.get(autonomyFileDocRelativePath).toString());
                            } else if (autonomyFileDocRelativePath.endsWith("content.idx")) {
                                R01KTraceIndexHelper.execUpdateContentIdxFile((String)idxDoc.getOid(), (String)indexFilesData.get(autonomyFileDocRelativePath).toString());
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                        }
                        if (indexFilesData.get(autonomyFileDocRelativePath).toString().endsWith("\r\n")) {
                            dataAPI.uploadPortalResource(10, idxCont.getInternalName(), idxDoc.getLanguage(), autonomyFileDocRelativePath, (InputStream)new ByteArrayInputStream(indexFilesData.get(autonomyFileDocRelativePath).toString().getBytes()));
                            continue;
                        }
                        dataAPI.uploadPortalResource(10, idxCont.getInternalName(), idxDoc.getLanguage(), autonomyFileDocRelativePath, (InputStream)new ByteArrayInputStream((indexFilesData.get(autonomyFileDocRelativePath).toString() + "\r\n").getBytes()));
                    }
                    catch (R01MSecurityException secEx) {
                        secEx.printStackTrace(System.out);
                    }
                    catch (R01MPortalModelException pmEx) {
                        pmEx.printStackTrace(System.out);
                    }
                }
            } else {
                R01FLog.to((String)LOG_TYPE_ID).severe("NO se ha podido obtener el idx de la pagina " + idxCont.getOid() + " ya que no se ha podido obtener el portal al que pertenece");
            }
        } else {
            R01FLog.to((String)LOG_TYPE_ID).severe("El objeto idxCont es null............");
        }
    }

    @Override
    public StringBuffer loadIndexData(R01MIndexableContent idxCont, R01MIndexableDocument idxDoc, List<String> indexFileNames, boolean includeIndexFileName) throws R01MSearchIndexerException {
        StringBuffer lines = new StringBuffer();
        R01MContentLocation loc = new R01MContentLocation(idxCont.getStorage().getServer().getOid(), idxCont.getStorage().getDataStore().getOid(), idxCont.getStorage().getArea().getOid(), idxCont.getStorage().getWorkArea().getOid());
        String WAPath = R01MPathHelpper.getLocationPath((R01MBaseLocationObject)loc);
        try {
            R01MRawDataAPI rawDataApi = R01MClientFactory.getRawDataAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext());
            rawDataApi.getFolderContents(WAPath, idxCont.getWorkAreaRelativePath() + IDX_RELATIVE_PATH, false);
            R01MDataStoreItem[] indexFiles = null;
            indexFiles = rawDataApi.getFolderContents(WAPath, idxDoc.getWorkAreaRelativePath() + IDX_RELATIVE_PATH, false);
            for (R01MDataStoreItem currentIndexFile : Arrays.asList(indexFiles)) {
                boolean addLines = false;
                if (indexFileNames != null) {
                    for (String indexFileName : indexFileNames) {
                        if ((!includeIndexFileName || !currentIndexFile.getItemName().equalsIgnoreCase(indexFileName) || !currentIndexFile.getItemName().endsWith("." + R01KAutonomyIndexer.DEFAULT_INDEX_EXTENSSION)) && (includeIndexFileName || currentIndexFile.getItemName().equalsIgnoreCase(indexFileName) || !currentIndexFile.getItemName().endsWith("." + R01KAutonomyIndexer.DEFAULT_INDEX_EXTENSSION))) continue;
                        addLines = true;
                        break;
                    }
                } else {
                    addLines = true;
                }
                if (!addLines) continue;
                InputStream is = rawDataApi.readFile(WAPath, indexFiles[0].getWorkAreaRelativePath());
                String line = "";
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                while ((line = br.readLine()) != null) {
                    lines.append(line).append("\r\n");
                }
            }
        }
        catch (R01MSecurityException secEx) {
            secEx.printStackTrace();
            throw new R01MSearchIndexerException("Error al cargar ficheros de indexacion del objeto " + (idxCont == null ? "[objeto indexable null] " : (idxCont.getOid() == null ? " [Oid del objeto es null]" : idxCont.getOid())) + " de tipo " + (idxCont.getObjectType() == 0 ? "contenido" : (idxCont.getObjectType() == 4 ? "p\u00e1gina de portal" : "[tipo no reconocido]: " + Integer.toString(idxCont.getObjectType()))) + ". Error:" + secEx.getMessage(), (Exception)((Object)secEx));
        }
        catch (R01MDataStoreException dsEx) {
            dsEx.printStackTrace();
            throw new R01MSearchIndexerException("Error al cargar ficheros de indexacion del objeto " + (idxCont == null ? "[objeto indexable null] " : (idxCont.getOid() == null ? " [Oid del objeto es null]" : idxCont.getOid())) + " de tipo " + (idxCont.getObjectType() == 0 ? "contenido" : (idxCont.getObjectType() == 4 ? "p\u00e1gina de portal" : "[tipo no reconocido]: " + Integer.toString(idxCont.getObjectType()))) + ". Error:" + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
            throw new R01MSearchIndexerException("Error al cargar ficheros de indexacion del objeto " + (idxCont == null ? "[objeto indexable null] " : (idxCont.getOid() == null ? " [Oid del objeto es null]" : idxCont.getOid())) + " de tipo " + (idxCont.getObjectType() == 0 ? "contenido" : (idxCont.getObjectType() == 4 ? "p\u00e1gina de portal" : "[tipo no reconocido]: " + Integer.toString(idxCont.getObjectType()))) + ". Error:" + ioEx.getMessage(), (Exception)ioEx);
        }
        return lines;
    }

    @Override
    public void removeIndexData(R01MIndexableContent idxCont, List<String> filesToDelete) throws R01MSearchIndexerException {
        R01MRawDataAPI rawDataApi;
        R01MContentLocation loc = new R01MContentLocation(idxCont.getStorage().getServer().getOid(), idxCont.getStorage().getDataStore().getOid(), idxCont.getStorage().getArea().getOid(), idxCont.getStorage().getWorkArea().getOid());
        String WAPath = R01MPathHelpper.getLocationPath((R01MBaseLocationObject)loc);
        try {
            rawDataApi = R01MClientFactory.getRawDataAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext());
        }
        catch (R01MSecurityException e) {
            throw new R01MSearchIndexerException("Error de seguridad al acceder al datastore.Error:" + e.getMessage(), (Exception)((Object)e));
        }
        for (String fileToDeletePath : filesToDelete) {
            if (fileToDeletePath.length() <= 0 || fileToDeletePath.equals("/")) continue;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("Eliminando fichero idx: " + fileToDeletePath);
            }
            try {
                rawDataApi.deleteFile(WAPath, fileToDeletePath, true);
            }
            catch (Exception ex) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error al borrar ficheros de indexacion del objeto " + (idxCont == null ? "[objeto indexable null] " : (idxCont.getOid() == null ? " [Oid del objeto es null]" : idxCont.getOid())) + " de tipo " + (idxCont.getObjectType() == 0 ? "contenido" : (idxCont.getObjectType() == 4 ? "p\u00e1gina de portal" : "[tipo no reconocido]: " + Integer.toString(idxCont.getObjectType()))) + ". Error al borrar el fichero: " + (fileToDeletePath == null ? "NULL" : fileToDeletePath) + ". Error: " + ex.getMessage());
            }
        }
    }

    @Override
    public void removeIndexData(R01MIndexableContent idxCont, String extenssion) throws R01MSearchIndexerException {
        if (idxCont != null && ReflectionUtils.isSameClassAs(idxCont.getClass(), R01MIndexableContent.class)) {
            R01MContentLocation loc = new R01MContentLocation(idxCont.getStorage().getServer().getOid(), idxCont.getStorage().getDataStore().getOid(), idxCont.getStorage().getArea().getOid(), idxCont.getStorage().getWorkArea().getOid());
            String WAPath = R01MPathHelpper.getLocationPath((R01MBaseLocationObject)loc);
            String waRelPath = idxCont.getWorkAreaRelativePath();
            if (waRelPath.endsWith("/") && IDX_RELATIVE_PATH.startsWith("/")) {
                waRelPath = waRelPath.substring(0, waRelPath.length());
            }
            try {
                R01MRawDataAPI rawDataApi = R01MClientFactory.getRawDataAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext());
                R01MDataStoreItem[] conts = ((R01MRawDataManagerBzd)rawDataApi.getBzd()).doGetFolderContents(R01MAuthManager.createMasterSystemUserContext(), WAPath, waRelPath + IDX_RELATIVE_PATH, false, (R01MDataStoreItemFilter)new R01MByExtenssionFilter("idx"), null);
                for (int i = 0; i < conts.length; ++i) {
                    rawDataApi.deleteFile(WAPath, conts[i].getWorkAreaRelativePath(), true);
                }
            }
            catch (R01MSecurityException secEx) {
                secEx.printStackTrace(System.out);
            }
            catch (R01MDataStoreException dsEx) {
                dsEx.printStackTrace(System.out);
            }
            catch (BzdConfigException bzdEx) {
                bzdEx.printStackTrace(System.out);
            }
        }
    }
}

