/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01k.searchorchestrator.indexer.indexers;

import com.ejie.r01f.file.FileUtils;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01k.searchorchestrator.indexer.indexers.R01KAutonomyIndexer;
import com.ejie.r01k.searchorchestrator.indexer.indexers.R01KIDXProcessor;
import com.ejie.r01k.traceindex.R01KTraceIndexHelper;
import com.ejie.r01m.exceptions.R01MSearchIndexerException;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableContent;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableDocument;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexablePortalPage;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.portal.R01MPortalPathHelpper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class R01KFileSystemAutonomyIDXProcessor
implements R01KIDXProcessor {
    private static final String IDX_RELATIVE_PATH = XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"relativeIndexPath/contents", (String)"/r01Index/");

    @Override
    public void setProperties(Properties props) {
    }

    @Override
    public Properties getProperties() {
        return null;
    }

    @Override
    public StringBuffer loadIndexData(R01MIndexableContent idxCont, R01MIndexableDocument idxDoc, List<String> indexFileNames, boolean includeIndexFileName) throws R01MSearchIndexerException {
        StringBuffer lines = new StringBuffer();
        String path = R01MConstants.CONTENT_DATA_BASE_PATH + "/" + idxCont.getTypo().getType().getOid() + "/" + idxCont.getName().trim() + "/" + idxDoc.getLanguage() + "_" + idxDoc.getInternalName().trim() + IDX_RELATIVE_PATH;
        List idxFiles = FileUtils.readDirFiles((String)path, (boolean)false, null);
        for (String absoluteFilePath : idxFiles) {
            boolean addLines = false;
            if (indexFileNames != null) {
                for (String indexFileName : indexFileNames) {
                    if ((!includeIndexFileName || !absoluteFilePath.endsWith(indexFileName) || !absoluteFilePath.endsWith("." + R01KAutonomyIndexer.DEFAULT_INDEX_EXTENSSION)) && (includeIndexFileName || absoluteFilePath.endsWith(indexFileName) || !absoluteFilePath.endsWith("." + R01KAutonomyIndexer.DEFAULT_INDEX_EXTENSSION))) continue;
                    addLines = true;
                    break;
                }
            } else {
                addLines = true;
            }
            if (!addLines) continue;
            List linesList = FileUtils.readLinesFromFile((String)absoluteFilePath);
            Iterator itLines = linesList.iterator();
            while (itLines.hasNext()) {
                lines.append(itLines.next()).append("\r\n");
            }
        }
        return lines;
    }

    public void processIndexData(R01MIndexableContent idxCont, R01MIndexableDocument idxDoc, Map indexFilesData) throws R01MSearchIndexerException {
        for (String autonomyFileDocRelativePath : indexFilesData.keySet()) {
            if (((StringBuffer)indexFilesData.get(autonomyFileDocRelativePath)).length() <= 0) continue;
            String indexData = ((StringBuffer)indexFilesData.get(autonomyFileDocRelativePath)).toString();
            try {
                if (autonomyFileDocRelativePath.endsWith("storage.idx")) {
                    R01KTraceIndexHelper.execUpdateStorageIdxFile((String)idxDoc.getOid(), (String)indexData);
                } else if (autonomyFileDocRelativePath.endsWith("typology.idx")) {
                    R01KTraceIndexHelper.execUpdateTypologyIdxFile((String)idxDoc.getOid(), (String)indexData);
                } else if (autonomyFileDocRelativePath.endsWith("catalog.idx")) {
                    R01KTraceIndexHelper.execUpdateCatalogIdxFile((String)idxDoc.getOid(), (String)indexData);
                } else if (autonomyFileDocRelativePath.endsWith("content.idx")) {
                    R01KTraceIndexHelper.execUpdateContentIdxFile((String)idxDoc.getOid(), (String)indexData);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            if (ReflectionUtils.isSameClassAs(idxCont.getClass(), R01MIndexableContent.class)) {
                String path = "";
                path = autonomyFileDocRelativePath.startsWith("contentObject.") ? R01MConstants.CONTENT_DATA_BASE_PATH + "/" + idxCont.getTypo().getType().getOid() + "/" + idxCont.getName().trim() + "/" + idxDoc.getLanguage() + "_" + idxDoc.getInternalName().trim() + IDX_RELATIVE_PATH + autonomyFileDocRelativePath.substring("contentObject.".length()) : R01MConstants.CONTENT_DATA_BASE_PATH + "/" + idxCont.getTypo().getType().getOid() + "/" + idxCont.getName().trim() + "/" + idxDoc.getLanguage() + "_" + idxDoc.getInternalName().trim() + IDX_RELATIVE_PATH + autonomyFileDocRelativePath;
                R01FLog.to((String)"r01k.index").info("Escribiendo idx en el path: " + path);
                this._flushIdxToFile(indexData, path);
                continue;
            }
            if (!(idxCont instanceof R01MIndexablePortalPage)) continue;
            String portal = idxCont == null || idxCont.getInternalName() == null ? "  [InternalName del contenido es null] " : idxCont.getInternalName().substring(0, idxCont.getInternalName().indexOf("-"));
            String page = idxCont == null || idxCont.getInternalName() == null ? "  [InternalName del contenido es null] " : idxCont.getInternalName().substring(idxCont.getInternalName().indexOf("-") + 1);
            String path = R01MConstants.PORTAL_DATA_BASE_PATH + (idxCont != null ? "" : " [contenido es null] - ") + (idxCont == null || idxCont.getStorage().getWorkArea() == null && idxCont.getStorage().getWorkArea().getOid() != null ? "  [workarea es null] " : idxCont.getStorage().getWorkArea().getOid()) + "/" + portal + "/html/pages" + R01MPortalPathHelpper.replacePortalPageLanguageCodeInPath((String)XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"relativeIndexPath/portalPages", (String)"/data/[?0]-[?1]/[?2]_[?0]-[?1]/r01Index/"), (String)portal, (String)page, (String)(idxDoc.getLanguage() != null ? idxDoc.getLanguage() : "[null]")) + autonomyFileDocRelativePath;
            R01FLog.to((String)"r01k.index").info("Escribiendo idx en el path: " + path);
            this._flushIdxToFile(indexData, path);
        }
    }

    public void removeIndexData(R01MIndexableContent idxCont, List filesToDelete) throws R01MSearchIndexerException {
        for (String fileToRemovePath : filesToDelete) {
            if (ReflectionUtils.isSameClassAs(idxCont.getClass(), R01MIndexableContent.class)) {
                fileToRemovePath = R01MConstants.CONTENT_DATA_BASE_PATH + (idxCont != null ? "" : " [contenido es null] - ") + (idxCont == null || idxCont.getStorage().getWorkArea() == null && idxCont.getStorage().getWorkArea().getOid() != null ? "  [workarea es null] " : idxCont.getStorage().getWorkArea().getOid()) + fileToRemovePath;
            } else if (idxCont instanceof R01MIndexablePortalPage) {
                fileToRemovePath = R01MConstants.PORTAL_DATA_BASE_PATH + (idxCont != null ? "" : " [contenido es null] - ") + (idxCont == null || idxCont.getStorage().getWorkArea() == null && idxCont.getStorage().getWorkArea().getOid() != null ? "  [workarea es null] " : idxCont.getStorage().getWorkArea().getOid()) + fileToRemovePath;
            }
            if (fileToRemovePath.length() <= 0) continue;
            R01FLog.to((String)"r01k.index").info("Borrando el idx de path: " + fileToRemovePath);
            File fileToDelete = new File(fileToRemovePath);
            try {
                if (!fileToDelete.exists() || FileUtils.delete((File)fileToDelete)) continue;
                R01FLog.to((String)"r01k.index").warning("Al desindexar un documento o pagina idiomatica " + ". No se ha podido borrar el fichero de indexacion: " + fileToRemovePath);
            }
            catch (IOException ioEx) {
                R01FLog.to((String)"r01k.index").warning("Al desindexar un documento o pagina idiomatica " + ". No se ha podido borrar el fichero de indexacion: " + fileToRemovePath + ioEx.getMessage());
            }
        }
    }

    @Override
    public void removeIndexData(R01MIndexableContent idxCont, String extenssion) throws R01MSearchIndexerException {
    }

    private void _flushIdxToFile(String idxFileContent, String filePath) throws R01MSearchIndexerException {
        boolean success;
        byte[] totalBytes = null;
        OutputStream out = null;
        String path = filePath.substring(0, filePath.lastIndexOf(47));
        boolean bl = success = new File(path).mkdirs() || new File(path).exists();
        if (success) {
            try {
                out = new FileOutputStream(new File(filePath));
                totalBytes = idxFileContent.getBytes();
                out.write(totalBytes);
            }
            catch (IOException ioEx) {
                throw new R01MSearchIndexerException("No se puede escribir en el fichero " + filePath + ": " + ioEx.getMessage(), (Exception)ioEx);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException innerIoEx) {
                        innerIoEx.printStackTrace();
                        throw new R01MSearchIndexerException("Error al cerrar el fichero IDX: " + innerIoEx.getLocalizedMessage(), (Exception)innerIoEx);
                    }
                }
            }
        }
        throw new R01MSearchIndexerException("No se puede crear el directorio " + path);
    }
}

