/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01k.searchorchestrator.indexer.indexers;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.sql.QueryExecutor;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01k.ejb.bzd.R01KDBIndexerSLBzd;
import com.ejie.r01k.ejb.entity.baseindexableobject.R01KBaseIndexableObjectCMPLocal;
import com.ejie.r01k.ejb.entity.baseindexableobject.R01KBaseIndexableObjectCMPPK;
import com.ejie.r01k.ejb.entity.baseindexableobject.R01KBaseIndexableObjectCMPUtil;
import com.ejie.r01k.ejb.entity.baseindexableobject.R01KBaseIndexableObjectCMPValue;
import com.ejie.r01k.ejb.entity.indexablecontent.R01KIndexableContentCMPLocal;
import com.ejie.r01k.ejb.entity.indexablecontent.R01KIndexableContentCMPPK;
import com.ejie.r01k.ejb.entity.indexablecontent.R01KIndexableContentCMPUtil;
import com.ejie.r01k.ejb.entity.indexablecontent.R01KIndexableContentCMPValue;
import com.ejie.r01k.ejb.entity.indexabledatafile.R01KIndexableDataFileCMPLocal;
import com.ejie.r01k.ejb.entity.indexabledatafile.R01KIndexableDataFileCMPPK;
import com.ejie.r01k.ejb.entity.indexabledatafile.R01KIndexableDataFileCMPUtil;
import com.ejie.r01k.ejb.entity.indexabledatafile.R01KIndexableDataFileCMPValue;
import com.ejie.r01k.ejb.entity.indexabledocument.R01KIndexableDocumentCMPLocal;
import com.ejie.r01k.ejb.entity.indexabledocument.R01KIndexableDocumentCMPPK;
import com.ejie.r01k.ejb.entity.indexabledocument.R01KIndexableDocumentCMPUtil;
import com.ejie.r01k.ejb.entity.indexabledocument.R01KIndexableDocumentCMPValue;
import com.ejie.r01k.ejb.entity.indexabledocumentlinkeddata.R01KIndexableDocumentLinkedDataCMPLocal;
import com.ejie.r01k.ejb.entity.indexabledocumentlinkeddata.R01KIndexableDocumentLinkedDataCMPUtil;
import com.ejie.r01k.ejb.entity.indexabledocumentlinkeddata.R01KIndexableDocumentLinkedDataCMPValue;
import com.ejie.r01k.ejb.entity.indexablestructurecatalog.R01KIndexableOracleTextCatalogCMPLocal;
import com.ejie.r01k.ejb.entity.indexablestructurecatalog.R01KIndexableOracleTextCatalogCMPUtil;
import com.ejie.r01k.ejb.entity.indexablestructurecatalog.R01KIndexableOracleTextCatalogCMPValue;
import com.ejie.r01k.ejb.entity.indexablestructurecatalog.R01KIndexableStructureCatalogCMPLocal;
import com.ejie.r01k.ejb.entity.indexablestructurecatalog.R01KIndexableStructureCatalogCMPUtil;
import com.ejie.r01k.ejb.entity.indexablestructurecatalog.R01KIndexableStructureCatalogCMPValue;
import com.ejie.r01k.ejb.entity.publicationinfo.R01KPublicationInfoCMPLocal;
import com.ejie.r01k.ejb.entity.publicationinfo.R01KPublicationInfoCMPUtil;
import com.ejie.r01k.ejb.entity.publicationinfo.R01KPublicationInfoCMPValue;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MMetaDataStorageConfig;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MSearchIndexerException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.portalmodel.R01MPage;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableContent;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableDataFile;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableDocument;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexablePublicationInfo;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableStorageInfo;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableStorageObject;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableStructureCatalog;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableTypoInfo;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableTypoObject;
import com.ejie.r01m.objects.searchengine.indexer.R01MRispDocument;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MPortalManagerAPI;
import com.ejie.r01m.utils.R01MConstants;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.NoSuchEntityException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.json.JSONException;
import org.json.JSONObject;

public class R01KDataBaseIndexerProcessor
implements R01KDBIndexerSLBzd {
    private static boolean DEBUG = R01FLog.getLogLevel((String)"r01k.index").intValue() != Level.OFF.intValue();

    public void execIndexContent(String system, R01MIndexableContent idxCont) throws R01MSearchIndexerException {
        if (DEBUG) {
            R01FLog.to((String)"r01k.index").info("R01KDataBaseIndexerSL: Inicio almacenamiento en Base de Datos de la informaci\u00f3n de indexaci\u00f3n correspondiente al CONTENIDO con oid " + idxCont.getOid());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01k.index").info("\t- Informacion base (contenido " + idxCont.getOid() + ")");
        }
        R01KBaseIndexableObjectCMPValue baseIndexableObjectVO = new R01KBaseIndexableObjectCMPValue();
        baseIndexableObjectVO.setTipoObjeto(Integer.toString(idxCont.getObjectType()));
        baseIndexableObjectVO.setAutor(idxCont.getAuthor());
        R01MIndexableStorageInfo idxStorageInfo = idxCont.getStorage();
        R01MIndexableStorageObject server = idxStorageInfo.getServer();
        baseIndexableObjectVO.setOidServidorAlmac(server.getOid());
        R01MIndexableStorageObject datastore = idxStorageInfo.getDataStore();
        baseIndexableObjectVO.setOidDatastoreAlmac(datastore.getOid());
        R01MIndexableStorageObject areaAlmac = idxStorageInfo.getArea();
        baseIndexableObjectVO.setOidAreaAlmac(areaAlmac.getOid());
        R01MIndexableStorageObject workareaAlmac = idxStorageInfo.getWorkArea();
        baseIndexableObjectVO.setOidWorkareaAlmac(workareaAlmac.getOid());
        baseIndexableObjectVO.setPathRelativoWorkarea(idxCont.getWorkAreaRelativePath());
        R01MIndexableTypoInfo idxTypoInfo = idxCont.getTypo();
        R01MIndexableTypoObject cluster = idxTypoInfo.getCluster();
        baseIndexableObjectVO.setOidClusterTipologia(cluster.getOid());
        R01MIndexableTypoObject familia = idxTypoInfo.getFamily();
        baseIndexableObjectVO.setOidFamiliaTipologia(familia.getOid());
        R01MIndexableTypoObject tipoTipologia = idxTypoInfo.getType();
        baseIndexableObjectVO.setOidTipoTipologia(tipoTipologia.getOid());
        baseIndexableObjectVO.setOidObjetoIndexable(idxCont.getOid());
        R01KBaseIndexableObjectCMPLocal baseIndexableObjectCMP = null;
        try {
            baseIndexableObjectCMP = R01KBaseIndexableObjectCMPUtil.getLocalHome().findByPrimaryKey(new R01KBaseIndexableObjectCMPPK(baseIndexableObjectVO.getOidObjetoIndexable()));
        }
        catch (FinderException findEx) {
            if (DEBUG) {
                R01FLog.to((String)"r01k.index").info("INDEX CONTENT  >>>> El objeto indexable base con oid " + idxCont.getOid() + " se indexa por primera vez.");
            }
        }
        catch (NamingException nameEx) {
            nameEx.printStackTrace(System.out);
            throw new R01MSearchIndexerException("No se encuentra el Home del EJB de indexaci\u00f3n b\u00e1sica correspondiente al objeto indexable base con oid " + idxCont.getOid(), (Exception)nameEx);
        }
        if (baseIndexableObjectCMP != null) {
            baseIndexableObjectCMP.setR01KBaseIndexableObjectCMPValue(baseIndexableObjectVO);
        } else {
            try {
                R01KBaseIndexableObjectCMPUtil.getLocalHome().create(baseIndexableObjectVO);
            }
            catch (CreateException createEx) {
                createEx.printStackTrace(System.out);
                throw new R01MSearchIndexerException("Error al intentar almacenar en Base de Datos la informaci\u00f3n de indexaci\u00f3n correspondiente al objeto indexable base con oid " + idxCont.getOid() + "-" + createEx.getMessage(), (Exception)((Object)createEx));
            }
            catch (NamingException nameEx) {
                nameEx.printStackTrace(System.out);
                throw new R01MSearchIndexerException("Error al intentar almacenar en Base de Datos la informaci\u00f3n de indexaci\u00f3n correspondiente al objeto indexable base con oid " + idxCont.getOid() + "-" + nameEx.getMessage(), (Exception)nameEx);
            }
        }
        R01FLog.to((String)"r01k.index").info("\t- Contenido (" + idxCont.getOid() + ")");
        R01KIndexableContentCMPValue indexableContentVO = new R01KIndexableContentCMPValue();
        indexableContentVO.setOidContent(idxCont.getOid());
        indexableContentVO.setNombreContent(idxCont.getName());
        indexableContentVO.setNombreInternoContent(idxCont.getInternalName());
        indexableContentVO.setDescripcionContent(idxCont.getDescription());
        indexableContentVO.setUrlEdicionContent(StringUtils.mapToString((Map)idxCont.getEditURLs()));
        indexableContentVO.setSistemaContent(system);
        indexableContentVO.setCreationDate(idxCont.getCreateDate());
        indexableContentVO.setContentResponsible(idxCont.getResponsible());
        indexableContentVO.setNewnessUntilDate(idxCont.getNewnessUntilDate());
        indexableContentVO.setPortalDataSEOName(idxCont.getPortalDataContentSEOName());
        indexableContentVO.setPortalDataSEODescription(idxCont.getPortalDataContentSEODescription());
        try {
            indexableContentVO.setXmlIndexableContent(XOManager.getXML((String)R01MConstants.INDEXABLEOBJECTS_MAPFILE, (Object)idxCont));
        }
        catch (XOMarshallerException xoEx) {
            throw new R01MSearchIndexerException("R01KDataBaseIndexer: Error, no se puede obtener el xml a partir del objeto R01MBaseIndexableObject pasado como par\u00e1metro:" + xoEx.getMessage(), (Exception)((Object)xoEx));
        }
        R01KIndexableContentCMPLocal indexableContentCMP = null;
        try {
            indexableContentCMP = R01KIndexableContentCMPUtil.getLocalHome().findByPrimaryKey(new R01KIndexableContentCMPPK(indexableContentVO.getOidContent()));
        }
        catch (FinderException findEx) {
            if (DEBUG) {
                R01FLog.to((String)"r01k.index").info("INDEX CONTENT  >>>> El contenido con oid " + idxCont.getOid() + " se indexa por primera vez.");
            }
        }
        catch (NamingException nameEx) {
            nameEx.printStackTrace(System.out);
            throw new R01MSearchIndexerException("No se encuentra el Home del EJB de indexaci\u00f3n de contenido con oid " + idxCont.getOid(), (Exception)nameEx);
        }
        if (indexableContentCMP != null) {
            indexableContentCMP.setR01KIndexableContentCMPValue(indexableContentVO);
        } else {
            try {
                R01KIndexableContentCMPUtil.getHome().create(indexableContentVO);
            }
            catch (CreateException createEx) {
                createEx.printStackTrace(System.out);
                throw new R01MSearchIndexerException("Error al intentar almacenar en Base de Datos la informaci\u00f3n de indexaci\u00f3n correspondiente al contenido con oid " + idxCont.getOid() + "-" + createEx.getMessage(), (Exception)((Object)createEx));
            }
            catch (NamingException nameEx) {
                nameEx.printStackTrace(System.out);
                throw new R01MSearchIndexerException("Error al intentar almacenar en Base de Datos la informaci\u00f3n de indexaci\u00f3n correspondiente al contenido con oid " + idxCont.getOid() + "-" + nameEx.getMessage(), (Exception)nameEx);
            }
            catch (RemoteException rmtExc) {
                rmtExc.printStackTrace(System.out);
                throw new R01MSearchIndexerException((Exception)rmtExc);
            }
        }
        Collection catalogs = null;
        try {
            catalogs = R01KIndexableStructureCatalogCMPUtil.getLocalHome().findByOidContent(idxCont.getOid());
        }
        catch (FinderException findEx) {
            R01FLog.to((String)"r01k.index").info("INDEX Document  >>>> Contenido " + idxCont.getOid() + " no ten\u00eda catalogaciones indexadas.");
        }
        catch (NamingException nameEx) {
            throw new R01MSearchIndexerException("Error al obtener el interfaz Home del EJB CMP de catalogacion de contenidos. Error:" + nameEx.getMessage(), (Exception)nameEx);
        }
        if (catalogs != null) {
            for (R01KIndexableStructureCatalogCMPLocal catalogCMP : catalogs) {
                try {
                    catalogCMP.remove();
                }
                catch (RemoveException rmvEx) {
                    rmvEx.printStackTrace(System.out);
                    throw new R01MSearchIndexerException("No se puede borrar la informaci\u00f3n de catalogacion del contenido de oid " + idxCont.getOid() + "-" + rmvEx.getMessage(), (Exception)((Object)rmvEx));
                }
            }
            if (DEBUG) {
                R01FLog.to((String)"r01k.index").info("\t- Eliminada informacion de catalogacion del contenido " + idxCont.getOid());
            }
        } else if (DEBUG) {
            R01FLog.to((String)"r01k.index").info("\t- El contenido " + idxCont.getOid() + " NO tiene catalogaciones");
        }
        List structureCatalogs = idxCont.getStructureCatalogs();
        if (DEBUG) {
            R01FLog.to((String)"r01k.index").info("\t- Etiquetas de catalogaci\u00f3n (contenido " + idxCont.getOid() + ")");
        }
        if (structureCatalogs != null && !structureCatalogs.isEmpty()) {
            R01KIndexableOracleTextCatalogCMPLocal idxStructureCatalogCMP;
            Iterator iteratorStructureCatalogs = structureCatalogs.iterator();
            StringBuffer allObjectCatalogations = new StringBuffer("");
            allObjectCatalogations.append("<structurecatalogs>");
            while (iteratorStructureCatalogs.hasNext()) {
                R01MIndexableStructureCatalog idxStructureCatalog = (R01MIndexableStructureCatalog)iteratorStructureCatalogs.next();
                allObjectCatalogations.append("<catalog><structure>");
                allObjectCatalogations.append(idxStructureCatalog.getStructureOid());
                allObjectCatalogations.append("</structure><label>");
                allObjectCatalogations.append(idxStructureCatalog.getLabelOid());
                allObjectCatalogations.append("</label><role>");
                allObjectCatalogations.append(idxStructureCatalog.getLabelRoleInStructure());
                allObjectCatalogations.append("</role></catalog>");
                R01KIndexableStructureCatalogCMPValue idxStructureCatalogVO = new R01KIndexableStructureCatalogCMPValue();
                idxStructureCatalogVO.setOidObjetoIndexable(idxCont.getOid());
                idxStructureCatalogVO.setOidEstructura(idxStructureCatalog.getStructureOid());
                idxStructureCatalogVO.setOidEtiqueta(idxStructureCatalog.getLabelOid());
                idxStructureCatalogVO.setRolEtiquetaEstructura(idxStructureCatalog.getLabelRoleInStructure());
                idxStructureCatalogCMP = null;
                try {
                    idxStructureCatalogCMP = R01KIndexableStructureCatalogCMPUtil.getLocalHome().findByPrimaryKey(idxStructureCatalogVO.getPrimaryKey());
                }
                catch (FinderException findEx) {
                }
                catch (NamingException nameEx) {
                    nameEx.printStackTrace(System.out);
                    throw new R01MSearchIndexerException("No se encuentra el Home del EJB catalogaci\u00f3n de contenido con oid " + idxCont.getOid(), (Exception)nameEx);
                }
                if (DEBUG) {
                    R01FLog.to((String)"r01k.index").info("\t\t" + idxStructureCatalog.getStructureOid() + "." + idxStructureCatalog.getLabelOid() + "." + idxStructureCatalog.getLabelRoleInStructure() + (idxStructureCatalogCMP != null ? " actualizar" : " nueva"));
                }
                if (idxStructureCatalogCMP != null) {
                    idxStructureCatalogCMP.setR01KIndexableStructureCatalogCMPValue(idxStructureCatalogVO);
                    continue;
                }
                try {
                    R01KIndexableStructureCatalogCMPUtil.getLocalHome().create(idxStructureCatalogVO);
                }
                catch (CreateException createEx) {
                    createEx.printStackTrace(System.out);
                    throw new R01MSearchIndexerException("Error al intentar almacenar en Base de Datos la informaci\u00f3n de catalogaci\u00f3n del contenido con oid " + idxCont.getOid() + "-" + createEx.getMessage(), (Exception)((Object)createEx));
                }
                catch (NamingException nameEx) {
                    nameEx.printStackTrace(System.out);
                    throw new R01MSearchIndexerException("No se encuentra el Home del EJB catalogaci\u00f3n de contenido con oid " + idxCont.getOid(), (Exception)nameEx);
                }
            }
            allObjectCatalogations.append("</structurecatalogs>");
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)allObjectCatalogations)) {
                R01KIndexableOracleTextCatalogCMPValue idxOracleTextCatalogVO = new R01KIndexableOracleTextCatalogCMPValue();
                idxOracleTextCatalogVO.setOidIndexableObject(idxCont.getOid());
                idxOracleTextCatalogVO.setCatalogDefinition(allObjectCatalogations.toString());
                idxStructureCatalogCMP = null;
                try {
                    idxStructureCatalogCMP = R01KIndexableOracleTextCatalogCMPUtil.getLocalHome().findByPrimaryKey(idxOracleTextCatalogVO.getPrimaryKey());
                }
                catch (FinderException findEx) {
                }
                catch (NamingException nameEx) {
                    nameEx.printStackTrace(System.out);
                    throw new R01MSearchIndexerException("No se encuentra el Home del EJB de indexaci\u00f3n de catalogaci\u00f3n  (Oracle Text) para el objeto con oid " + idxCont.getOid(), (Exception)nameEx);
                }
                if (idxStructureCatalogCMP != null) {
                    idxStructureCatalogCMP.setR01KIndexableOracleTextCatalogCMPValue(idxOracleTextCatalogVO);
                } else {
                    try {
                        R01KIndexableOracleTextCatalogCMPUtil.getLocalHome().create(idxOracleTextCatalogVO);
                    }
                    catch (CreateException createEx) {
                        createEx.printStackTrace(System.out);
                        throw new R01MSearchIndexerException("Error al intentar almacenar en Base de Datos (Oracle Text) la informaci\u00f3n de catalogaci\u00f3n del contenido con oid " + idxCont.getOid() + "-" + createEx.getMessage(), (Exception)((Object)createEx));
                    }
                    catch (NamingException nameEx) {
                        nameEx.printStackTrace(System.out);
                        throw new R01MSearchIndexerException("No se encuentra el Home del EJB de indexaci\u00f3n de catalogaci\u00f3n  (Oracle Text) para el objeto con oid " + idxCont.getOid(), (Exception)nameEx);
                    }
                }
            }
        }
    }

    public void execIndexContent(String system, R01MIndexableContent idxCont, List<String> metadataFileNames, Map clusterIndependentMetadataStorageConfig) throws R01MSearchIndexerException {
        if (DEBUG) {
            R01FLog.to((String)"r01k.index").info("R01KDataBaseIndexerSL: Inicio almacenamiento en Base de Datos de la informaci\u00f3n de indexaci\u00f3n correspondiente al CONTENIDO con oid " + idxCont.getOid() + "\t- Informacion base (contenido " + idxCont.getOid() + ")");
        }
        R01KBaseIndexableObjectCMPLocal baseIndexableObjectCMP = null;
        try {
            baseIndexableObjectCMP = R01KBaseIndexableObjectCMPUtil.getLocalHome().findByPrimaryKey(new R01KBaseIndexableObjectCMPPK(idxCont.getOid()));
        }
        catch (FinderException findEx) {
            if (DEBUG) {
                R01FLog.to((String)"r01k.index").info("INDEX CONTENT  >>>> El objeto indexable base con oid " + idxCont.getOid() + " se indexa por primera vez.");
            }
        }
        catch (NamingException nameEx) {
            nameEx.printStackTrace(System.out);
            throw new R01MSearchIndexerException("No se encuentra el Home del EJB de indexaci\u00f3n b\u00e1sica correspondiente al objeto indexable base con oid " + idxCont.getOid(), (Exception)nameEx);
        }
        R01KIndexableContentCMPLocal indexableContentCMP = null;
        try {
            indexableContentCMP = R01KIndexableContentCMPUtil.getLocalHome().findByPrimaryKey(new R01KIndexableContentCMPPK(idxCont.getOid()));
        }
        catch (FinderException findEx) {
            if (DEBUG) {
                R01FLog.to((String)"r01k.index").info("INDEX CONTENT  >>>> El contenido con oid " + idxCont.getOid() + " se indexa por primera vez.");
            }
        }
        catch (NamingException nameEx) {
            nameEx.printStackTrace(System.out);
            throw new R01MSearchIndexerException("No se encuentra el Home del EJB de indexaci\u00f3n de contenido con oid " + idxCont.getOid(), (Exception)nameEx);
        }
        if (baseIndexableObjectCMP == null || indexableContentCMP == null) {
            this.execIndexContent(system, idxCont);
        } else {
            R01MIndexableContent newIdxCont = new R01MIndexableContent();
            R01MIndexableContent oldIdxCont = new R01MIndexableContent();
            try {
                newIdxCont = (R01MIndexableContent)XOManager.getObject((String)R01MConstants.INDEXABLEOBJECTS_MAPFILE, (String)indexableContentCMP.getR01KIndexableContentCMPValue().getXmlIndexableContent());
                oldIdxCont = (R01MIndexableContent)XOManager.getObject((String)R01MConstants.INDEXABLEOBJECTS_MAPFILE, (String)indexableContentCMP.getR01KIndexableContentCMPValue().getXmlIndexableContent());
            }
            catch (XOMarshallerException e) {
                throw new R01MSearchIndexerException("Error al mapear el XML indexable del contenido " + idxCont.getOid(), (Exception)((Object)e));
            }
            R01KBaseIndexableObjectCMPValue baseIndexableObjectVO = new R01KBaseIndexableObjectCMPValue();
            baseIndexableObjectVO.setAutor(oldIdxCont.getAuthor());
            baseIndexableObjectVO.setPathRelativoWorkarea(oldIdxCont.getWorkAreaRelativePath());
            baseIndexableObjectVO.setOidObjetoIndexable(oldIdxCont.getOid());
            baseIndexableObjectVO.setTipoObjeto(Integer.toString(oldIdxCont.getObjectType()));
            baseIndexableObjectVO.setOidWorkareaAlmac(oldIdxCont.getStorage().getWorkArea().getOid());
            baseIndexableObjectVO.setOidAreaAlmac(oldIdxCont.getStorage().getArea().getOid());
            baseIndexableObjectVO.setOidDatastoreAlmac(oldIdxCont.getStorage().getDataStore().getOid());
            baseIndexableObjectVO.setOidServidorAlmac(oldIdxCont.getStorage().getServer().getOid());
            baseIndexableObjectVO.setOidTipoTipologia(oldIdxCont.getTypo().getType().getOid());
            baseIndexableObjectVO.setOidFamiliaTipologia(oldIdxCont.getTypo().getFamily().getOid());
            baseIndexableObjectVO.setOidClusterTipologia(oldIdxCont.getTypo().getCluster().getOid());
            newIdxCont.setObjectType(oldIdxCont.getObjectType());
            if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("contentOid")).getProperties().get("autonomy.idxFile"))) {
                newIdxCont.setOid(idxCont.getOid());
            }
            if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("contentAuthor")).getProperties().get("autonomy.idxFile"))) {
                baseIndexableObjectVO.setAutor(idxCont.getAuthor());
                newIdxCont.setAuthor(idxCont.getAuthor());
            }
            R01MIndexableStorageInfo idxStorageInfo = idxCont.getStorage();
            if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("storageServerOid")).getProperties().get("autonomy.idxFile"))) {
                R01MIndexableStorageObject server = idxStorageInfo.getServer();
                baseIndexableObjectVO.setOidServidorAlmac(server.getOid());
            }
            if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("storageDataStoreOid")).getProperties().get("autonomy.idxFile"))) {
                R01MIndexableStorageObject datastore = idxStorageInfo.getDataStore();
                baseIndexableObjectVO.setOidDatastoreAlmac(datastore.getOid());
            }
            if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("storageAreaOid")).getProperties().get("autonomy.idxFile"))) {
                R01MIndexableStorageObject areaAlmac = idxStorageInfo.getArea();
                baseIndexableObjectVO.setOidAreaAlmac(areaAlmac.getOid());
            }
            if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("storageWorkAreaOid")).getProperties().get("autonomy.idxFile"))) {
                R01MIndexableStorageObject workareaAlmac = idxStorageInfo.getWorkArea();
                baseIndexableObjectVO.setOidWorkareaAlmac(workareaAlmac.getOid());
            }
            newIdxCont.setStorage(idxStorageInfo);
            if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("contentWorkAreaRelativePath")).getProperties().get("autonomy.idxFile"))) {
                baseIndexableObjectVO.setPathRelativoWorkarea(idxCont.getWorkAreaRelativePath());
                newIdxCont.setWorkAreaRelativePath(idxCont.getWorkAreaRelativePath());
            }
            R01MIndexableTypoInfo idxTypoInfo = idxCont.getTypo();
            if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("typologyClusterOid")).getProperties().get("autonomy.idxFile"))) {
                R01MIndexableTypoObject cluster = idxTypoInfo.getCluster();
                baseIndexableObjectVO.setOidClusterTipologia(cluster.getOid());
            }
            if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("typologyFamilyOid")).getProperties().get("autonomy.idxFile"))) {
                R01MIndexableTypoObject familia = idxTypoInfo.getFamily();
                baseIndexableObjectVO.setOidFamiliaTipologia(familia.getOid());
            }
            if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("typologyTypeOid")).getProperties().get("autonomy.idxFile"))) {
                R01MIndexableTypoObject tipoTipologia = idxTypoInfo.getType();
                baseIndexableObjectVO.setOidTipoTipologia(tipoTipologia.getOid());
            }
            newIdxCont.setTypo(idxTypoInfo);
            baseIndexableObjectCMP.setR01KBaseIndexableObjectCMPValue(baseIndexableObjectVO);
            if (DEBUG) {
                R01FLog.to((String)"r01k.index").info("\t- Contenido (" + idxCont.getOid() + ")");
            }
            R01KIndexableContentCMPValue indexableContentVO = new R01KIndexableContentCMPValue();
            indexableContentVO.setOidContent(oldIdxCont.getOid());
            indexableContentVO.setSistemaContent(system);
            indexableContentVO.setContentResponsible(oldIdxCont.getResponsible());
            indexableContentVO.setCreationDate(oldIdxCont.getCreateDate());
            indexableContentVO.setDescripcionContent(oldIdxCont.getDescription());
            indexableContentVO.setNewnessUntilDate(oldIdxCont.getNewnessUntilDate());
            indexableContentVO.setNombreContent(oldIdxCont.getName());
            indexableContentVO.setNombreInternoContent(oldIdxCont.getInternalName());
            indexableContentVO.setUrlEdicionContent(StringUtils.mapToString((Map)oldIdxCont.getEditURLs()));
            indexableContentVO.setPortalDataSEOName(oldIdxCont.getPortalDataContentSEOName());
            indexableContentVO.setPortalDataSEODescription(oldIdxCont.getPortalDataContentSEODescription());
            if (metadataFileNames != null && !metadataFileNames.isEmpty()) {
                if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("contentName")).getProperties().get("autonomy.idxFile"))) {
                    indexableContentVO.setNombreContent(idxCont.getName());
                    indexableContentVO.setNombreInternoContent(idxCont.getInternalName());
                    newIdxCont.setName(idxCont.getName());
                    newIdxCont.setInternalName(idxCont.getInternalName());
                }
                if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("contentDescription")).getProperties().get("autonomy.idxFile"))) {
                    indexableContentVO.setDescripcionContent(idxCont.getDescription());
                    newIdxCont.setDescription(idxCont.getDescription());
                }
                if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("contentEditURLs")).getProperties().get("autonomy.idxFile"))) {
                    indexableContentVO.setUrlEdicionContent(StringUtils.mapToString((Map)idxCont.getEditURLs()));
                    newIdxCont.setEditURLs(idxCont.getEditURLs());
                }
                if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("contentRispDocumentsInfo")).getProperties().get("autonomy.idxFile"))) {
                    indexableContentVO.setContentRispDocumentsInfo(R01MRispDocument.mapObjectsToJsonString((Map)idxCont.getContentRispDocumentsInfo()));
                    newIdxCont.setContentRispDocumentsInfo(idxCont.getContentRispDocumentsInfo());
                }
                if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("contentCreateDate")).getProperties().get("autonomy.idxFile"))) {
                    indexableContentVO.setCreationDate(idxCont.getCreateDate());
                    newIdxCont.setCreateDate(idxCont.getCreateDate());
                }
                if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("contentResponsible")).getProperties().get("autonomy.idxFile"))) {
                    indexableContentVO.setContentResponsible(idxCont.getResponsible());
                    newIdxCont.setResponsible(idxCont.getResponsible());
                }
                if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("contentNewnessUntilDate")).getProperties().get("autonomy.idxFile"))) {
                    indexableContentVO.setNewnessUntilDate(idxCont.getNewnessUntilDate());
                    newIdxCont.setNewnessUntilDate(idxCont.getNewnessUntilDate());
                }
                try {
                    indexableContentVO.setXmlIndexableContent(XOManager.getXML((String)R01MConstants.INDEXABLEOBJECTS_MAPFILE, (Object)newIdxCont));
                }
                catch (XOMarshallerException xoEx) {
                    throw new R01MSearchIndexerException("R01KDataBaseIndexer: Error, no se puede obtener el xml a partir del objeto R01MBaseIndexableObject pasado como par\u00e1metro:" + xoEx.getMessage(), (Exception)((Object)xoEx));
                }
            }
            indexableContentCMP.setR01KIndexableContentCMPValue(indexableContentVO);
            if (metadataFileNames == null || metadataFileNames.isEmpty() || metadataFileNames.contains("catalog.idx")) {
                Collection catalogs = null;
                try {
                    catalogs = R01KIndexableStructureCatalogCMPUtil.getLocalHome().findByOidContent(idxCont.getOid());
                }
                catch (FinderException findEx) {
                    R01FLog.to((String)"r01k.index").info("INDEX Document  >>>> Contenido " + idxCont.getOid() + " no ten\u00eda catalogaciones indexadas.");
                }
                catch (NamingException nameEx) {
                    throw new R01MSearchIndexerException("Error al obtener el interfaz Home del EJB CMP de catalogacion de contenidos. Error:" + nameEx.getMessage(), (Exception)nameEx);
                }
                if (catalogs != null && !catalogs.isEmpty()) {
                    for (R01KIndexableStructureCatalogCMPLocal catalogCMP : catalogs) {
                        try {
                            catalogCMP.remove();
                        }
                        catch (RemoveException rmvEx) {
                            rmvEx.printStackTrace(System.out);
                            throw new R01MSearchIndexerException("No se puede borrar la informaci\u00f3n de catalogacion del contenido de oid " + idxCont.getOid() + "-" + rmvEx.getMessage(), (Exception)((Object)rmvEx));
                        }
                    }
                    if (DEBUG) {
                        R01FLog.to((String)"r01k.index").info("\t- Eliminada informacion de catalogacion del contenido " + idxCont.getOid());
                    }
                } else if (DEBUG) {
                    R01FLog.to((String)"r01k.index").info("\t- El contenido " + idxCont.getOid() + " NO tiene catalogaciones");
                }
                List structureCatalogs = idxCont.getStructureCatalogs();
                if (DEBUG) {
                    R01FLog.to((String)"r01k.index").info("\t- Etiquetas de catalogaci\u00f3n (contenido " + idxCont.getOid() + ")");
                }
                if (structureCatalogs != null && !structureCatalogs.isEmpty()) {
                    R01KIndexableOracleTextCatalogCMPLocal idxStructureCatalogCMP;
                    Iterator iteratorStructureCatalogs = structureCatalogs.iterator();
                    StringBuffer allObjectCatalogations = new StringBuffer("");
                    allObjectCatalogations.append("<structurecatalogs>");
                    while (iteratorStructureCatalogs.hasNext()) {
                        R01MIndexableStructureCatalog idxStructureCatalog = (R01MIndexableStructureCatalog)iteratorStructureCatalogs.next();
                        allObjectCatalogations.append("<catalog><structure>");
                        allObjectCatalogations.append(idxStructureCatalog.getStructureOid());
                        allObjectCatalogations.append("</structure><label>");
                        allObjectCatalogations.append(idxStructureCatalog.getLabelOid());
                        allObjectCatalogations.append("</label><role>");
                        allObjectCatalogations.append(idxStructureCatalog.getLabelRoleInStructure());
                        allObjectCatalogations.append("</role></catalog>");
                        R01KIndexableStructureCatalogCMPValue idxStructureCatalogVO = new R01KIndexableStructureCatalogCMPValue();
                        idxStructureCatalogVO.setOidObjetoIndexable(idxCont.getOid());
                        idxStructureCatalogVO.setOidEstructura(idxStructureCatalog.getStructureOid());
                        idxStructureCatalogVO.setOidEtiqueta(idxStructureCatalog.getLabelOid());
                        idxStructureCatalogVO.setRolEtiquetaEstructura(idxStructureCatalog.getLabelRoleInStructure());
                        idxStructureCatalogCMP = null;
                        try {
                            idxStructureCatalogCMP = R01KIndexableStructureCatalogCMPUtil.getLocalHome().findByPrimaryKey(idxStructureCatalogVO.getPrimaryKey());
                        }
                        catch (FinderException findEx) {
                        }
                        catch (NamingException nameEx) {
                            nameEx.printStackTrace(System.out);
                            throw new R01MSearchIndexerException("No se encuentra el Home del EJB catalogaci\u00f3n de contenido con oid " + idxCont.getOid(), (Exception)nameEx);
                        }
                        if (DEBUG) {
                            R01FLog.to((String)"r01k.index").info("\t\t" + idxStructureCatalog.getStructureOid() + "." + idxStructureCatalog.getLabelOid() + "." + idxStructureCatalog.getLabelRoleInStructure() + (idxStructureCatalogCMP != null ? " actualizar" : " nueva"));
                        }
                        if (idxStructureCatalogCMP != null) {
                            idxStructureCatalogCMP.setR01KIndexableStructureCatalogCMPValue(idxStructureCatalogVO);
                            continue;
                        }
                        try {
                            R01KIndexableStructureCatalogCMPUtil.getLocalHome().create(idxStructureCatalogVO);
                        }
                        catch (CreateException createEx) {
                            createEx.printStackTrace(System.out);
                            throw new R01MSearchIndexerException("Error al intentar almacenar en Base de Datos la informaci\u00f3n de catalogaci\u00f3n del contenido con oid " + idxCont.getOid() + "-" + createEx.getMessage(), (Exception)((Object)createEx));
                        }
                        catch (NamingException nameEx) {
                            nameEx.printStackTrace(System.out);
                            throw new R01MSearchIndexerException("No se encuentra el Home del EJB catalogaci\u00f3n de contenido con oid " + idxCont.getOid(), (Exception)nameEx);
                        }
                    }
                    allObjectCatalogations.append("</structurecatalogs>");
                    if (!StringUtils.isEmptyStringBuffer((StringBuffer)allObjectCatalogations)) {
                        R01KIndexableOracleTextCatalogCMPValue idxOracleTextCatalogVO = new R01KIndexableOracleTextCatalogCMPValue();
                        idxOracleTextCatalogVO.setOidIndexableObject(idxCont.getOid());
                        idxOracleTextCatalogVO.setCatalogDefinition(allObjectCatalogations.toString());
                        idxStructureCatalogCMP = null;
                        try {
                            idxStructureCatalogCMP = R01KIndexableOracleTextCatalogCMPUtil.getLocalHome().findByPrimaryKey(idxOracleTextCatalogVO.getPrimaryKey());
                        }
                        catch (FinderException findEx) {
                        }
                        catch (NamingException nameEx) {
                            nameEx.printStackTrace(System.out);
                            throw new R01MSearchIndexerException("No se encuentra el Home del EJB de indexaci\u00f3n de catalogaci\u00f3n  (Oracle Text) para el objeto con oid " + idxCont.getOid(), (Exception)nameEx);
                        }
                        if (idxStructureCatalogCMP != null) {
                            idxStructureCatalogCMP.setR01KIndexableOracleTextCatalogCMPValue(idxOracleTextCatalogVO);
                        } else {
                            try {
                                R01KIndexableOracleTextCatalogCMPUtil.getLocalHome().create(idxOracleTextCatalogVO);
                            }
                            catch (CreateException createEx) {
                                createEx.printStackTrace(System.out);
                                throw new R01MSearchIndexerException("Error al intentar almacenar en Base de Datos (Oracle Text) la informaci\u00f3n de catalogaci\u00f3n del contenido con oid " + idxCont.getOid() + "-" + createEx.getMessage(), (Exception)((Object)createEx));
                            }
                            catch (NamingException nameEx) {
                                nameEx.printStackTrace(System.out);
                                throw new R01MSearchIndexerException("No se encuentra el Home del EJB de indexaci\u00f3n de catalogaci\u00f3n  (Oracle Text) para el objeto con oid " + idxCont.getOid(), (Exception)nameEx);
                            }
                        }
                    }
                }
            }
        }
    }

    public void execIndexDocument(String system, R01MIndexableContent idxCont, String documentOid) throws R01MSearchIndexerException {
        R01MIndexableDocument idxDoc = idxCont.getDocument(documentOid);
        if (idxDoc == null) {
            throw new R01MSearchIndexerException("NO se ha encontrado el documento indexable " + documentOid + " en el contenido " + idxCont.getOid());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01k.index").info("R01KDataBaseIndexerSL: Inicio almacenamiento en Base de Datos de la informaci\u00f3n de indexaci\u00f3n correspondiente al DOCUMENTO con oid " + idxDoc.getOid());
        }
        R01FLog.to((String)"r01k.index").info("\t- Datos basicos del documento " + idxDoc.getOid());
        R01KIndexableDocumentCMPValue idxDocVO = new R01KIndexableDocumentCMPValue();
        idxDocVO.setOidDocument(idxDoc.getOid());
        idxDocVO.setNombreDocument(idxDoc.getName());
        idxDocVO.setNombreInternoDocument(idxDoc.getInternalName());
        idxDocVO.setDescripcionDocument(idxDoc.getDescription());
        idxDocVO.setUrlEdicionDocument(StringUtils.mapToString((Map)idxDoc.getEditURLs()));
        idxDocVO.setApprovalStatus(Integer.toString(idxDoc.getApprovalStatus()));
        idxDocVO.setOidContent(idxCont.getOid());
        idxDocVO.setSistemaDocument(system);
        idxDocVO.setDocumentLanguage(idxDoc.getLanguage());
        idxDocVO.setDepthLevel(idxDoc.getDepthLevel());
        idxDocVO.setCreationDate(idxDoc.getCreateDate());
        idxDocVO.setDocumentAuthor(idxDoc.getAuthor());
        idxDocVO.setTags(idxDoc.getTags());
        idxDocVO.setPortalDataInitDate(idxDoc.getPortalDataInitDate());
        idxDocVO.setPortalDataEndDate(idxDoc.getPortalDataEndDate());
        idxDocVO.setPortalDataSEOName(idxDoc.getPortalDataDocumentSEOName());
        idxDocVO.setPortalDataSEODescription(idxDoc.getPortalDataDocumentSEODescription());
        idxDocVO.setMainFriendlyURL(idxDoc.getMainFriendlyURL());
        idxDocVO.setBoosting(idxDoc.getBoosting());
        idxDocVO.setAutor(idxCont.getAuthor());
        idxDocVO.setOidClusterTipologia(idxCont.getTypo().getCluster().getOid());
        idxDocVO.setOidFamiliaTipologia(idxCont.getTypo().getFamily().getOid());
        idxDocVO.setOidTipoTipologia(idxCont.getTypo().getType().getOid());
        idxDocVO.setOidServidorAlmac(idxCont.getStorage().getServer().getOid());
        idxDocVO.setOidDatastoreAlmac(idxCont.getStorage().getDataStore().getOid());
        idxDocVO.setOidAreaAlmac(idxCont.getStorage().getArea().getOid());
        idxDocVO.setOidWorkareaAlmac(idxCont.getStorage().getWorkArea().getOid());
        idxDocVO.setPathRelativoWorkarea(idxCont.getWorkAreaRelativePath());
        R01KIndexableDocumentCMPLocal idxDocCMP = null;
        try {
            idxDocCMP = R01KIndexableDocumentCMPUtil.getLocalHome().findByPrimaryKey(idxDocVO.getPrimaryKey());
        }
        catch (FinderException findEx) {
            R01FLog.to((String)"r01k.index").info("INDEX Document  >>>> El documento con oid " + idxDoc.getOid() + " se indexa por primera vez.");
        }
        catch (NamingException nameEx) {
            nameEx.printStackTrace(System.out);
            throw new R01MSearchIndexerException("No se encuentra el Home del EJB de indexaci\u00f3n de documento con oid " + idxDoc.getOid(), (Exception)nameEx);
        }
        if (idxDocCMP != null) {
            idxDocCMP.setR01KIndexableDocumentCMPValue(idxDocVO);
            try {
                idxDocCMP.setXmlIndexableDocument(XOManager.getXML((String)R01MConstants.INDEXABLEOBJECTS_MAPFILE, (Object)idxDoc));
            }
            catch (XOMarshallerException xoEx) {
                throw new R01MSearchIndexerException("R01KDataBaseIndexer: Error, no se puede obtener el xml a partir del objeto R01MBaseIndexableObject pasado como par\u00e1metro:" + xoEx.getMessage(), (Exception)((Object)xoEx));
            }
        }
        try {
            R01KIndexableDocumentCMPLocal idxDocCMPLocal = R01KIndexableDocumentCMPUtil.getLocalHome().create(idxDocVO);
            try {
                idxDocCMPLocal.setXmlIndexableDocument(XOManager.getXML((String)R01MConstants.INDEXABLEOBJECTS_MAPFILE, (Object)idxDoc));
            }
            catch (XOMarshallerException xoEx) {
                throw new R01MSearchIndexerException("R01KDataBaseIndexer: Error, no se puede obtener el xml a partir del objeto R01MBaseIndexableObject pasado como par\u00e1metro:" + xoEx.getMessage(), (Exception)((Object)xoEx));
            }
        }
        catch (CreateException createEx) {
            createEx.printStackTrace(System.out);
            throw new R01MSearchIndexerException("Error al intentar almacenar en Base de Datos la informaci\u00f3n de indexaci\u00f3n correspondiente al documento con oid " + idxDoc.getOid() + "-" + createEx.getMessage(), (Exception)((Object)createEx));
        }
        catch (NamingException nameEx) {
            nameEx.printStackTrace(System.out);
            R01FLog.to((String)"r01k.index").severe("INDEX Document  >>>> Error al intentar almacenar en Base de Datos la informaci\u00f3n de indexaci\u00f3n correspondiente al documento con oid " + idxDoc.getOid() + "-" + nameEx.getMessage());
            throw new R01MSearchIndexerException("Error al intentar almacenar en Base de Datos la informaci\u00f3n de indexaci\u00f3n correspondiente al documento con oid " + idxDoc.getOid() + "-" + nameEx.getMessage(), (Exception)nameEx);
        }
        R01FLog.to((String)"r01k.index").info("\t- Datos de vinculaciones del documento " + idxDoc.getOid());
        if (idxDoc.getDocumentLinkedData() != null && (idxDoc.getDocumentLinkedData().getAllLinkedDocumentDst() != null || idxDoc.getDocumentLinkedData().getAllLinkedDocumentSrc() != null || idxDoc.getDocumentLinkedData().getLinkedDocumentInfo() != null || idxDoc.getDocumentLinkedData().getLinkedDocumentsByTagDst() != null || idxDoc.getDocumentLinkedData().getLinkedDocumentsByTagSrc() != null || idxDoc.getDocumentLinkedData().getLinkedSizeByTagSrc() != null)) {
            R01KIndexableDocumentLinkedDataCMPValue idxDocLnkVO = new R01KIndexableDocumentLinkedDataCMPValue();
            idxDocLnkVO.setOidDocument(idxDoc.getOid());
            if (!StringUtils.isEmptyString((String)idxDoc.getDocumentLinkedData().getLinkedDocumentInfo())) {
                idxDocLnkVO.setLinkedDocumentInfo(idxDoc.getDocumentLinkedData().getLinkedDocumentInfo());
            }
            if (!StringUtils.isEmptyString((String)idxDoc.getDocumentLinkedData().getAllLinkedDocumentSrc())) {
                idxDocLnkVO.setLinkedDocumentsSrc(idxDoc.getDocumentLinkedData().getAllLinkedDocumentSrc());
            }
            if (!StringUtils.isEmptyString((String)idxDoc.getDocumentLinkedData().getAllLinkedDocumentDst())) {
                idxDocLnkVO.setLinkedDocumentsDst(idxDoc.getDocumentLinkedData().getAllLinkedDocumentDst());
            }
            if (idxDoc.getDocumentLinkedData().getLinkedDocumentsByTagSrc() != null && !idxDoc.getDocumentLinkedData().getLinkedDocumentsByTagSrc().isEmpty()) {
                JSONObject allLinkedDocumentsByTagSrc = new JSONObject();
                for (Map.Entry me : idxDoc.getDocumentLinkedData().getLinkedDocumentsByTagSrc().entrySet()) {
                    try {
                        allLinkedDocumentsByTagSrc.put((String)me.getKey(), me.getValue());
                    }
                    catch (JSONException jsonExc) {
                        R01FLog.to((String)"r01k.index").warning("Error al crear la estructura JSON de vinculaciones para el tag " + (String)me.getKey() + " del documento con oid " + idxDoc.getOid() + "-" + jsonExc.getMessage());
                    }
                }
                idxDocLnkVO.setLinkedDocumentsGroupByTagsSrc(allLinkedDocumentsByTagSrc.toString());
            }
            if (idxDoc.getDocumentLinkedData().getLinkedDocumentsByTagDst() != null && !idxDoc.getDocumentLinkedData().getLinkedDocumentsByTagDst().isEmpty()) {
                JSONObject allLinkedDocumentsByTagDst = new JSONObject();
                for (Map.Entry me : idxDoc.getDocumentLinkedData().getLinkedDocumentsByTagDst().entrySet()) {
                    try {
                        allLinkedDocumentsByTagDst.put((String)me.getKey(), me.getValue());
                    }
                    catch (JSONException jsonExc) {
                        R01FLog.to((String)"r01k.index").warning("Error al crear la estructura JSON de vinculaciones para el tag " + (String)me.getKey() + " del documento con oid " + idxDoc.getOid() + "-" + jsonExc.getMessage());
                    }
                }
                idxDocLnkVO.setLinkedDocumentsGroupByTagsDst(allLinkedDocumentsByTagDst.toString());
            }
            if (idxDoc.getDocumentLinkedData().getLinkedSizeByTagSrc() != null && !idxDoc.getDocumentLinkedData().getLinkedSizeByTagSrc().isEmpty()) {
                JSONObject allLinkedSizeByTagSrc = new JSONObject();
                for (Map.Entry me : idxDoc.getDocumentLinkedData().getLinkedSizeByTagSrc().entrySet()) {
                    try {
                        allLinkedSizeByTagSrc.put((String)me.getKey(), me.getValue());
                    }
                    catch (JSONException jsonExc) {
                        R01FLog.to((String)"r01k.index").warning("Error al crear la estructura JSON de vinculaciones para el tag " + (String)me.getKey() + " del documento con oid " + idxDoc.getOid() + "-" + jsonExc.getMessage());
                    }
                }
                idxDocLnkVO.setLinkedSizeByTagsSrc(allLinkedSizeByTagSrc.toString());
            }
            R01KIndexableDocumentLinkedDataCMPLocal idxDocLnkCMP = null;
            try {
                idxDocLnkCMP = R01KIndexableDocumentLinkedDataCMPUtil.getLocalHome().findByPrimaryKey(idxDocLnkVO.getPrimaryKey());
            }
            catch (FinderException findEx) {
                R01FLog.to((String)"r01k.index").info("INDEX Document  >>>> El documento con oid " + idxDoc.getOid() + " se indexa por primera vez.");
            }
            catch (NamingException nameEx) {
                nameEx.printStackTrace(System.out);
                throw new R01MSearchIndexerException("No se encuentra el Home del EJB de indexaci\u00f3n de vinculaciones del documento con oid " + idxDoc.getOid(), (Exception)nameEx);
            }
            if (idxDocLnkCMP != null) {
                idxDocLnkCMP.setR01KIndexableDocumentLinkedDataCMPValue(idxDocLnkVO);
            } else {
                try {
                    R01KIndexableDocumentLinkedDataCMPUtil.getLocalHome().create(idxDocLnkVO);
                }
                catch (CreateException createEx) {
                    createEx.printStackTrace(System.out);
                    throw new R01MSearchIndexerException("Error al intentar almacenar en Base de Datos la informaci\u00f3n de indexaci\u00f3n de vinculaciones correspondiente al documento con oid " + idxDoc.getOid() + "-" + createEx.getMessage(), (Exception)((Object)createEx));
                }
                catch (NamingException nameEx) {
                    nameEx.printStackTrace(System.out);
                    R01FLog.to((String)"r01k.index").severe("INDEX Document  >>>> Error al intentar almacenar en Base de Datos la informaci\u00f3n de indexaci\u00f3n de vinculaciones correspondiente al documento con oid " + idxDoc.getOid() + "-" + nameEx.getMessage());
                    throw new R01MSearchIndexerException("Error al intentar almacenar en Base de Datos la informaci\u00f3n de indexaci\u00f3n de vinculaciones correspondiente al documento con oid " + idxDoc.getOid() + "-" + nameEx.getMessage(), (Exception)nameEx);
                }
            }
        }
        String urlPublicationInfo = null;
        if ("portales".equalsIgnoreCase(system)) {
            try {
                R01MPortalManagerAPI modelAPI = R01MClientFactory.getPortalModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext(), null);
                R01MPage page = modelAPI.loadPortalPage(idxCont.getOid());
                urlPublicationInfo = "/" + page.getPortalOid() + "-" + idxCont.getInternalName() + "/" + idxDoc.getLanguage() + "/";
            }
            catch (R01MSecurityException secEx) {
                secEx.printStackTrace(System.out);
                throw new R01MSearchIndexerException("Error al intentar almacenar en Base de Datos la informaci\u00f3n de publicaci\u00f3n. Al crear el contexto de usuario maestro para recoger la informaci\u00f3n del portal. Documento con oid " + documentOid + "-" + secEx.getMessage(), (Exception)((Object)secEx));
            }
            catch (R01MPortalModelException pmEx) {
                pmEx.printStackTrace(System.out);
                throw new R01MSearchIndexerException("Error al intentar almacenar en Base de Datos la informaci\u00f3n de publicaci\u00f3n. Al cargar la informaci\u00f3n de la p\u00e1gina para obtener el portal. Correspondiente al documento con oid " + documentOid + "-" + pmEx.getMessage(), (Exception)((Object)pmEx));
            }
        } else {
            urlPublicationInfo = idxDoc.getMainDataFile() != null ? idxDoc.getWorkAreaRelativePath() + "/" + idxDoc.getMainDataFile().getDefaultTemplateGeneratedFileDocumentRelativePath() : "[ERROR]: No se ha obtenido el fichero de inicio";
        }
        this._indexPublishInfo(system, idxDoc.getOid(), idxDoc.getPublicationInfo(), urlPublicationInfo);
    }

    public void execIndexDocument(String system, R01MIndexableContent idxCont, String documentOid, List<String> metadataFileNames, Map clusterIndependentMetadataStorageConfig) throws R01MSearchIndexerException {
        R01MIndexableDocument idxDoc = idxCont.getDocument(documentOid);
        if (idxDoc == null) {
            throw new R01MSearchIndexerException("NO se ha encontrado el documento indexable " + documentOid + " en el contenido " + idxCont.getOid());
        }
        R01KIndexableDocumentCMPValue idxDocVO = new R01KIndexableDocumentCMPValue();
        R01KIndexableDocumentCMPLocal idxDocCMP = null;
        try {
            idxDocCMP = R01KIndexableDocumentCMPUtil.getLocalHome().findByPrimaryKey(idxDocVO.getPrimaryKey());
        }
        catch (FinderException findEx) {
            R01FLog.to((String)"r01k.index").info("INDEX Document  >>>> El documento con oid " + idxDoc.getOid() + " se indexa por primera vez.");
        }
        catch (NamingException nameEx) {
            nameEx.printStackTrace(System.out);
            throw new R01MSearchIndexerException("No se encuentra el Home del EJB de indexaci\u00f3n de documento con oid " + idxDoc.getOid(), (Exception)nameEx);
        }
        if (idxDocCMP == null) {
            this.execIndexDocument(system, idxCont, documentOid);
        } else {
            R01MIndexableDocument newIdxDoc = new R01MIndexableDocument();
            try {
                newIdxDoc = (R01MIndexableDocument)XOManager.getObject((String)R01MConstants.INDEXABLEOBJECTS_MAPFILE, (String)idxDocCMP.getXmlIndexableDocument());
            }
            catch (XOMarshallerException e) {
                throw new R01MSearchIndexerException("", (Exception)((Object)e));
            }
            if (DEBUG) {
                R01FLog.to((String)"r01k.index").info("R01KDataBaseIndexerSL: Inicio almacenamiento en Base de Datos de la informaci\u00f3n de indexaci\u00f3n correspondiente al DOCUMENTO con oid " + idxDoc.getOid());
            }
            R01FLog.to((String)"r01k.index").info("\t- Datos basicos del documento " + idxDoc.getOid());
            if (metadataFileNames != null && metadataFileNames.isEmpty()) {
                if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("documentOid")).getProperties().get("autonomy.idxFile"))) {
                    idxDocVO.setOidDocument(idxDoc.getOid());
                    newIdxDoc.setOid(idxDoc.getOid());
                }
                if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("documentName")).getProperties().get("autonomy.idxFile"))) {
                    idxDocVO.setNombreDocument(idxDoc.getName());
                    newIdxDoc.setName(idxDoc.getName());
                }
                if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("documentInternalName")).getProperties().get("autonomy.idxFile"))) {
                    idxDocVO.setNombreInternoDocument(idxDoc.getInternalName());
                    newIdxDoc.setInternalName(idxDoc.getInternalName());
                }
                if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("documentDescription")).getProperties().get("autonomy.idxFile"))) {
                    idxDocVO.setDescripcionDocument(idxDoc.getDescription());
                    newIdxDoc.setDescription(idxDoc.getDescription());
                }
                if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("documentEditURLs")).getProperties().get("autonomy.idxFile"))) {
                    idxDocVO.setUrlEdicionDocument(StringUtils.mapToString((Map)idxDoc.getEditURLs()));
                    newIdxDoc.setEditURLs(idxDoc.getEditURLs());
                }
                if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("documentApprovalStatus")).getProperties().get("autonomy.idxFile"))) {
                    idxDocVO.setApprovalStatus(Integer.toString(idxDoc.getApprovalStatus()));
                    newIdxDoc.setApprovalStatus(idxDoc.getApprovalStatus());
                }
                if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("contentOid")).getProperties().get("autonomy.idxFile"))) {
                    idxDocVO.setOidContent(idxCont.getOid());
                }
                idxDocVO.setSistemaDocument(system);
                idxDocVO.setBoosting(idxDoc.getBoosting());
                if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("documentLanguage")).getProperties().get("autonomy.idxFile"))) {
                    idxDocVO.setDocumentLanguage(idxDoc.getLanguage());
                    newIdxDoc.setLanguage(idxDoc.getLanguage());
                }
                if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("documentDepthLevel")).getProperties().get("autonomy.idxFile"))) {
                    idxDocVO.setDepthLevel(idxDoc.getDepthLevel());
                    newIdxDoc.setDepthLevel(idxDoc.getDepthLevel());
                }
                if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("documentCreateDate")).getProperties().get("autonomy.idxFile"))) {
                    idxDocVO.setCreationDate(idxDoc.getCreateDate());
                    newIdxDoc.setCreateDate(idxDoc.getCreateDate());
                }
                if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("documentAuthor")).getProperties().get("autonomy.idxFile"))) {
                    idxDocVO.setDocumentAuthor(idxDoc.getAuthor());
                    newIdxDoc.setAuthor(idxDoc.getAuthor());
                }
                if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("tags")).getProperties().get("autonomy.idxFile"))) {
                    idxDocVO.setTags(idxDoc.getTags());
                    newIdxDoc.setTags(idxDoc.getTags());
                }
                if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("portalDataInitDate")).getProperties().get("autonomy.idxFile"))) {
                    idxDocVO.setPortalDataInitDate(idxDoc.getPortalDataInitDate());
                    newIdxDoc.setPortalDataInitDate(idxDoc.getPortalDataInitDate());
                }
                if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("portalDataEndDate")).getProperties().get("autonomy.idxFile"))) {
                    idxDocVO.setPortalDataEndDate(idxDoc.getPortalDataEndDate());
                    newIdxDoc.setPortalDataEndDate(idxDoc.getPortalDataEndDate());
                }
                if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("portalDataDocumentSEOName")).getProperties().get("autonomy.idxFile"))) {
                    idxDocVO.setPortalDataSEOName(idxDoc.getPortalDataDocumentSEOName());
                    newIdxDoc.setPortalDataDocumentSEOName(idxDoc.getPortalDataDocumentSEOName());
                }
                if (metadataFileNames.contains(((R01MMetaDataStorageConfig)clusterIndependentMetadataStorageConfig.get("portalDataDocumentSEODescription")).getProperties().get("autonomy.idxFile"))) {
                    idxDocVO.setPortalDataSEODescription(idxDoc.getPortalDataDocumentSEODescription());
                    newIdxDoc.setPortalDataDocumentSEODescription(idxDoc.getPortalDataDocumentSEODescription());
                }
                idxDocCMP.setR01KIndexableDocumentCMPValue(idxDocVO);
                try {
                    idxDocCMP.setXmlIndexableDocument(XOManager.getXML((String)R01MConstants.INDEXABLEOBJECTS_MAPFILE, (Object)newIdxDoc));
                }
                catch (XOMarshallerException xoEx) {
                    throw new R01MSearchIndexerException("R01KDataBaseIndexer: Error, no se puede obtener el xml a partir del objeto R01MBaseIndexableObject pasado como par\u00e1metro:" + xoEx.getMessage(), (Exception)((Object)xoEx));
                }
            }
            String urlPublicationInfo = null;
            urlPublicationInfo = idxDoc.getMainDataFile() != null ? idxDoc.getWorkAreaRelativePath() + "/" + idxDoc.getMainDataFile().getDefaultTemplateGeneratedFileDocumentRelativePath() : "[ERROR]: No se ha obtenido el fichero de inicio";
            this._indexPublishInfo(system, idxDoc.getOid(), idxDoc.getPublicationInfo(), urlPublicationInfo);
        }
    }

    public void execIndexDataFile(String system, R01MIndexableContent idxCont, String documentOid, String dataFileOid) throws R01MSearchIndexerException {
        R01MIndexableDocument idxDoc = idxCont.getDocument(documentOid);
        if (idxDoc == null) {
            throw new R01MSearchIndexerException("NO se ha encontrado el documento indexable " + documentOid + " en el contenido " + idxCont.getOid());
        }
        R01MIndexableDataFile idxDf = idxDoc.getDataFile(dataFileOid);
        if (idxDf == null) {
            throw new R01MSearchIndexerException("NO se ha encontrado el dataFile indexable " + dataFileOid + " en el documento " + documentOid + " en el contenido " + idxCont.getOid());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01k.index").info("R01KDataBaseIndexerSL: Inicio almacenamiento en Base de Datos de la informaci\u00f3n de indexaci\u00f3n del DataFile con oid " + idxDf.getOid());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01k.index").info("\t- Informacion basica del dataFile " + idxDf.getOid());
        }
        R01KIndexableDataFileCMPValue indexableDataFileVO = new R01KIndexableDataFileCMPValue();
        indexableDataFileVO.setOidDatafile(idxDf.getOid());
        indexableDataFileVO.setNombreDatafile(idxDf.getName());
        indexableDataFileVO.setNombreInternoDatafile(idxDf.getInternalName());
        indexableDataFileVO.setDescripcionDatafile(idxDf.getDescription());
        indexableDataFileVO.setDataCaptureTemplate(idxDf.getDataCaptureTemplate());
        indexableDataFileVO.setUrlEdicionDatafile(StringUtils.mapToString((Map)idxDf.getEditURLs()));
        indexableDataFileVO.setApprovalStatusDatafile(Integer.toString(idxDoc.getApprovalStatus()));
        indexableDataFileVO.setOidDocument(idxDoc.getOid());
        indexableDataFileVO.setSistemaDatafile(system);
        indexableDataFileVO.setCreationDate(idxDf.getCreateDate());
        indexableDataFileVO.setInitialPage(idxDf.isMainDataFile() ? 1 : 0);
        indexableDataFileVO.setGeneratedFiles(StringUtils.mapToString((Map)idxDf.getGeneratedFilesDocumentRelativePaths()));
        try {
            indexableDataFileVO.setXmlIndexableDatafile(XOManager.getXML((String)R01MConstants.INDEXABLEOBJECTS_MAPFILE, (Object)idxDf));
        }
        catch (XOMarshallerException xoEx) {
            throw new R01MSearchIndexerException("R01KDataBaseIndexer: Error, no se puede obtener el xml a partir del objeto R01MBaseIndexableObject pasado como par\u00e1metro:" + xoEx.getMessage(), (Exception)((Object)xoEx));
        }
        R01KIndexableDataFileCMPLocal idxDataFileCMP = null;
        try {
            idxDataFileCMP = R01KIndexableDataFileCMPUtil.getLocalHome().findByPrimaryKey(indexableDataFileVO.getPrimaryKey());
        }
        catch (FinderException findEx) {
            R01FLog.to((String)"r01k.index").info("INDEX DataFile  >>>> El archivo de datos con oid " + idxDf.getOid() + " se indexa por primera vez.");
        }
        catch (NamingException nameEx) {
            nameEx.printStackTrace(System.out);
            throw new R01MSearchIndexerException("No se encuentra el Home del EJB de indexaci\u00f3n de archivo de datos con oid " + idxDf.getOid(), (Exception)nameEx);
        }
        if (idxDataFileCMP != null) {
            idxDataFileCMP.setR01KIndexableDataFileCMPValue(indexableDataFileVO);
        } else {
            try {
                R01KIndexableDataFileCMPUtil.getLocalHome().create(indexableDataFileVO);
            }
            catch (CreateException createEx) {
                createEx.printStackTrace(System.out);
                R01FLog.to((String)"r01k.index").severe("INDEX DataFile  >>>> Error al intentar almacenar en Base de Datos la informaci\u00f3n de indexaci\u00f3n correspondiente al DataFile con oid " + idxDf.getOid() + "-" + createEx.getMessage());
                throw new R01MSearchIndexerException("Error al intentar almacenar en Base de Datos la informaci\u00f3n de indexaci\u00f3n correspondiente al DataFile con oid " + idxDf.getOid() + "-" + createEx.getMessage(), (Exception)((Object)createEx));
            }
            catch (NamingException nameEx) {
                nameEx.printStackTrace(System.out);
                throw new R01MSearchIndexerException("Error al intentar almacenar en Base de Datos la informaci\u00f3n de indexaci\u00f3n correspondiente al DataFile con oid " + idxDf.getOid() + "-" + nameEx.getMessage(), (Exception)nameEx);
            }
        }
    }

    public void execIndexDataFileSpecificMetaDataUsingSQLStatement(String system, String insertSQL) throws R01MSearchIndexerException {
        try {
            QueryExecutor qryExec = new QueryExecutor(R01MConstants.SEARCHENGINE_APPCODE, "indexerConnection");
            qryExec.executeInsert(insertSQL);
        }
        catch (SQLException sqlEx) {
            sqlEx.printStackTrace(System.out);
            throw new R01MSearchIndexerException("EXECUTE Statement  >>>> Error al ejeutar la sentencia " + insertSQL + ".Error:" + sqlEx.getMessage(), (Exception)sqlEx);
        }
    }

    public void execUnIndexContent(String system, String contOid) throws R01MSearchIndexerException {
        R01KBaseIndexableObjectCMPPK pk = new R01KBaseIndexableObjectCMPPK(contOid);
        if (DEBUG) {
            R01FLog.to((String)"r01k.index").info("R01KDataBaseIndexerSL: Desindexaci\u00f3n del contenido oid=" + contOid);
        }
        try {
            R01KBaseIndexableObjectCMPUtil.getLocalHome().findByPrimaryKey(pk).remove();
        }
        catch (NoSuchEntityException nsEx) {
            if (DEBUG) {
                R01FLog.to((String)"r01k.index").info("UNINDEX Content  >>>> Al eliminar el contenido con oid " + contOid + ". No se elimina el registro ya que no exist\u00eda: " + nsEx.getMessage());
            }
        }
        catch (EJBException ejbEx) {
            ejbEx.printStackTrace(System.out);
            throw new R01MSearchIndexerException("UNINDEX Content  >>>> Error al eliminar el contenido con oid " + contOid + "-" + ejbEx.getMessage(), (Exception)((Object)ejbEx));
        }
        catch (RemoveException removeEx) {
            removeEx.printStackTrace(System.out);
            throw new R01MSearchIndexerException("UNINDEX Content  >>>> Error al eliminar el contenido con oid " + contOid + "-" + removeEx.getMessage(), (Exception)((Object)removeEx));
        }
        catch (FinderException findEx) {
            if (DEBUG) {
                R01FLog.to((String)"r01k.index").info("UNINDEX Content  >>>> Al eliminar el contenido con oid " + contOid + ". No se elimina el registro ya que no exist\u00eda: " + findEx.getMessage());
            }
        }
        catch (NamingException nameEx) {
            nameEx.printStackTrace(System.out);
            throw new R01MSearchIndexerException("UNINDEX Content  >>>> Error al eliminar el contenido con oid " + contOid + "-" + nameEx.getMessage(), (Exception)nameEx);
        }
    }

    public void execUnIndexDocument(String system, String contOid, String docOid) throws R01MSearchIndexerException {
        R01KIndexableDocumentCMPPK pk = new R01KIndexableDocumentCMPPK(docOid);
        if (DEBUG) {
            R01FLog.to((String)"r01k.index").info("R01KDataBaseIndexerSL: Desindexaci\u00f3n del documento oid=" + docOid);
        }
        try {
            R01KIndexableDocumentCMPUtil.getLocalHome().findByPrimaryKey(pk).remove();
        }
        catch (NoSuchEntityException nsEx) {
            if (DEBUG) {
                R01FLog.to((String)"r01k.index").info("UNINDEX Document  >>>> Al eliminar el documento con oid " + docOid + ". No se elimina el registro ya que no exist\u00eda: " + nsEx.getMessage());
            }
        }
        catch (EJBException ejbEx) {
            ejbEx.printStackTrace(System.out);
            throw new R01MSearchIndexerException("UNINDEX Document  >>>> Error al eliminar la indexaci\u00f3n del documento con oid " + docOid + "-" + ejbEx.getMessage(), (Exception)((Object)ejbEx));
        }
        catch (RemoveException removeEx) {
            removeEx.printStackTrace(System.out);
            throw new R01MSearchIndexerException("UNINDEX Document  >>>> Error al eliminar la indexaci\u00f3n del documento con oid " + docOid + "-" + removeEx.getMessage(), (Exception)((Object)removeEx));
        }
        catch (FinderException findEx) {
            if (DEBUG) {
                R01FLog.to((String)"r01k.index").info("UNINDEX Content  >>>> Al eliminar el documento con oid " + docOid + ". No se elimina el registro ya que no exist\u00eda: " + findEx.getMessage());
            }
        }
        catch (NamingException nameEx) {
            nameEx.printStackTrace(System.out);
            throw new R01MSearchIndexerException("UNINDEX Document  >>>> Error al eliminar la indexaci\u00f3n del documento con oid " + docOid + "-" + nameEx.getMessage(), (Exception)nameEx);
        }
    }

    public void execUnIndexDataFile(String system, String contentOid, String documentOid, String dataFileOid) throws R01MSearchIndexerException {
        R01KIndexableDataFileCMPPK pk = new R01KIndexableDataFileCMPPK(dataFileOid);
        if (DEBUG) {
            R01FLog.to((String)"r01k.index").info("R01KDataBaseIndexerSL: Desindexaci\u00f3n del datafile oid=" + dataFileOid);
        }
        try {
            R01KIndexableDataFileCMPUtil.getLocalHome().findByPrimaryKey(pk).remove();
        }
        catch (NoSuchEntityException nsEx) {
            if (DEBUG) {
                R01FLog.to((String)"r01k.index").info("UNINDEX datafile  >>>> Al eliminar el datafile con oid " + dataFileOid + ". No se elimina el registro ya que no exist\u00eda: " + nsEx.getMessage());
            }
        }
        catch (EJBException ejbEx) {
            ejbEx.printStackTrace(System.out);
            throw new R01MSearchIndexerException("Error al eliminar la indexaci\u00f3n del datafile con oid " + dataFileOid + " .Error:" + ejbEx.getMessage(), (Exception)((Object)ejbEx));
        }
        catch (RemoveException removeEx) {
            removeEx.printStackTrace(System.out);
            throw new R01MSearchIndexerException("Error al eliminar la indexaci\u00f3n del datafile con oid " + dataFileOid + "-" + removeEx.getMessage(), (Exception)((Object)removeEx));
        }
        catch (FinderException findEx) {
            findEx.printStackTrace(System.out);
            R01FLog.to((String)"r01k.index").warning("UNINDEX DataFile  >>>> Error al eliminar la indxaci\u00f3n del datafile con oid " + dataFileOid + "-" + findEx.getMessage());
        }
        catch (NamingException nameEx) {
            nameEx.printStackTrace(System.out);
            throw new R01MSearchIndexerException("Error al eliminar la indexaci\u00f3n del datafile con oid " + dataFileOid + "-" + nameEx.getMessage(), (Exception)nameEx);
        }
    }

    public void execUnIndexDataFileSpecificMetaDataUsingSQLStatement(String system, String deleteSQL) throws R01MSearchIndexerException {
        try {
            QueryExecutor qryExec = new QueryExecutor(R01MConstants.SEARCHENGINE_APPCODE, "indexerConnection");
            qryExec.executeInsert(deleteSQL);
        }
        catch (SQLException sqlEx) {
            sqlEx.printStackTrace(System.out);
            throw new R01MSearchIndexerException("EXECUTE Statement  >>>> Error al ejeutar la sentencia " + deleteSQL + ".Error:" + sqlEx.getMessage(), (Exception)sqlEx);
        }
    }

    private void _indexPublishInfo(String system, String documentOid, List publicationInfo, String urlPublicationInfo) throws R01MSearchIndexerException {
        Collection publications = null;
        try {
            publications = R01KPublicationInfoCMPUtil.getLocalHome().findByOidDocument(documentOid);
        }
        catch (FinderException findEx) {
            R01FLog.to((String)"r01k.index").info("INDEX Document  >>>> El documento " + documentOid + " no ten\u00eda publicaciones indexadas.");
        }
        catch (NamingException nameEx) {
            R01FLog.to((String)"r01k.index").severe("INDEX Document  >>>> Error al obtener el interfaz Home del EJB CMP de publicaci\u00f3n de documentos.");
            throw new R01MSearchIndexerException("Error al obtener el interfaz Home del EJB CMP de publicaci\u00f3n de documentos. Error:" + nameEx.getMessage(), (Exception)nameEx);
        }
        if (publications != null && !publications.isEmpty()) {
            for (R01KPublicationInfoCMPLocal publicationCMP : publications) {
                try {
                    publicationCMP.remove();
                }
                catch (RemoveException rmvEx) {
                    rmvEx.printStackTrace(System.out);
                    throw new R01MSearchIndexerException("No se puede borrar la informaci\u00f3n de publicaci\u00f3n del documento de oid " + documentOid + "-" + rmvEx.getMessage(), (Exception)((Object)rmvEx));
                }
            }
            if (DEBUG) {
                R01FLog.to((String)"r01k.index").info("\t- Eliminada informacion de publicacion del documento " + documentOid);
            }
        } else if (DEBUG) {
            R01FLog.to((String)"r01k.index").info("\t- El documento " + documentOid + " NO tiene publicaciones");
        }
        HashMap<String, R01MIndexablePublicationInfo> publicationsToInsert = new HashMap<String, R01MIndexablePublicationInfo>();
        if (publicationInfo != null && !publicationInfo.isEmpty()) {
            for (R01MIndexablePublicationInfo pub : publicationInfo) {
                String mapKey = pub.getRepositoryOid() + pub.getState();
                if (publicationsToInsert.containsKey(mapKey)) {
                    if (!((R01MIndexablePublicationInfo)publicationsToInsert.get(mapKey)).getPublishDate().before(pub.getPublishDate())) continue;
                    publicationsToInsert.put(mapKey, pub);
                    continue;
                }
                publicationsToInsert.put(mapKey, pub);
            }
        }
        if (publicationsToInsert != null && !publicationsToInsert.isEmpty()) {
            if (DEBUG) {
                R01FLog.to((String)"r01k.index").info("\t- Publicaciones del documento " + documentOid);
            }
            for (R01MIndexablePublicationInfo idxPubInfo : publicationsToInsert.values()) {
                R01KPublicationInfoCMPValue publicationInfoVO = new R01KPublicationInfoCMPValue();
                publicationInfoVO.setOidRepository(idxPubInfo.getRepositoryOid());
                publicationInfoVO.setState(idxPubInfo.getState());
                publicationInfoVO.setOidDocument(documentOid);
                publicationInfoVO.setFechaPublicationInfo(idxPubInfo.getPublishDate());
                if ("portales".equalsIgnoreCase(system)) {
                    publicationInfoVO.setUrlPublicationInfo(urlPublicationInfo);
                } else {
                    publicationInfoVO.setUrlPublicationInfo("/" + idxPubInfo.getRepositoryAlias() + "/" + urlPublicationInfo);
                }
                try {
                    R01KPublicationInfoCMPUtil.getLocalHome().create(publicationInfoVO);
                }
                catch (CreateException createEx) {
                    createEx.printStackTrace(System.out);
                    throw new R01MSearchIndexerException("Error al intentar almacenar en Base de Datos la informaci\u00f3n de publicaci\u00f3n correspondiente al documento con oid " + documentOid + "-" + createEx.getMessage(), (Exception)((Object)createEx));
                }
                catch (NamingException nameEx) {
                    nameEx.printStackTrace(System.out);
                    throw new R01MSearchIndexerException("Error al intentar almacenar en Base de Datos la informaci\u00f3n de publicaci\u00f3n correspondiente al documento con oid " + documentOid + "-" + nameEx.getMessage(), (Exception)nameEx);
                }
            }
        }
    }
}

