/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01k.searchorchestrator.indexer.indexers;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.NumberUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01k.ejb.entity.indexablecontent.R01KIndexableContentCMPLocal;
import com.ejie.r01k.ejb.entity.indexablecontent.R01KIndexableContentCMPPK;
import com.ejie.r01k.ejb.entity.indexablecontent.R01KIndexableContentCMPUtil;
import com.ejie.r01k.ejb.entity.indexabledocument.R01KIndexableDocumentCMPLocal;
import com.ejie.r01k.ejb.entity.indexabledocument.R01KIndexableDocumentCMPPK;
import com.ejie.r01k.ejb.entity.indexabledocument.R01KIndexableDocumentCMPUtil;
import com.ejie.r01k.ejb.entity.publicationinfo.R01KPublicationInfoCMPPK;
import com.ejie.r01k.ejb.entity.publicationinfo.R01KPublicationInfoCMPUtil;
import com.ejie.r01k.ejb.entity.publicationinfo.R01KPublicationInfoCMPValue;
import com.ejie.r01k.searchorchestrator.indexer.indexers.R01KDataBaseIndexerProcessor;
import com.ejie.r01k.searchorchestrator.indexer.indexers.R01KSearchEngineIndexer;
import com.ejie.r01k.traceindex.R01KTraceIndexHelper;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MClusterStorageConfig;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MClusterStorageIndependentConfig;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MFamilyStorageConfig;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MMetaDataStorageConfig;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MSearchMetaDataStorageConfig;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MTypeStorageConfig;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MSearchIndexerException;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.contentmodel.R01MDocumentPublicationTarget;
import com.ejie.r01m.objects.portalmodel.R01MPage;
import com.ejie.r01m.objects.searchengine.indexer.R01MBaseIndexableObject;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableContent;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableDataFile;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableDocument;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableMetaData;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexablePortalLangPage;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexablePortalPage;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableStorageInfo;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableTypoInfo;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MSearchMetaDataStorageConfigAPI;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MDateUtils;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.FinderException;
import javax.naming.NamingException;

public class R01KDataBaseIndexer
implements R01KSearchEngineIndexer {
    private static final String LOG_TYPE_ID = "r01k.index";
    private static boolean DEBUG = R01FLog.getLogLevel((String)"r01k.index").intValue() != Level.OFF.intValue();
    static R01MSearchMetaDataStorageConfigAPI SEARCH_METADATA_STORAGE_CONFIG = R01MClientFactory.getSearchMetaDataStorageConfigAPI();
    private static int indexerType = R01KSearchEngineIndexer.DOCUMENT_TYPE_INDEXER;
    private transient Properties _props = null;
    private transient String _nativeDateFormat = "dd/MM/yyyy";

    @Override
    public void setNativeDateFormat(String dateFormat) {
        this._nativeDateFormat = dateFormat;
    }

    @Override
    public String getNativeDateFormat() {
        return this._nativeDateFormat;
    }

    @Override
    public void setProperties(Properties props) {
        this._props = props;
    }

    @Override
    public Properties getProperties() {
        return this._props;
    }

    @Override
    public int getIndexerType() {
        return indexerType;
    }

    @Override
    public void index(String systemId, R01MBaseIndexableObject idxObj, int objType, List<String> metadataFileNames, Properties props) throws R01MSearchIndexerException {
        String traceObjOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Indexando el objeto " + idxObj.getOid() + " EN BASE DE DATOS ..........");
        }
        if (idxObj == null) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Se ha intentado indexar un objeto NULO!!!");
            return;
        }
        switch (objType) {
            case 0: 
            case 1: {
                if (props != null && props.containsKey("objectOid")) {
                    traceObjOid = props.getProperty("objectOid").toString();
                    break;
                }
                traceObjOid = idxObj.getOid();
                break;
            }
            case 4: {
                traceObjOid = idxObj.getOid();
                break;
            }
            default: {
                throw new R01MSearchIndexerException("El tipo de objeto " + objType + " NO es valido para su indexacion en BD");
            }
        }
        if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
            this._traceIndex(traceObjOid, objType, 1, "");
        }
        switch (objType) {
            case 0: 
            case 1: {
                try {
                    this._execIndexContentModelObject(systemId, (R01MIndexableContent)idxObj, objType, metadataFileNames, props, traceObjOid);
                    break;
                }
                catch (R01MSearchIndexerException idxExc) {
                    if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                        this._traceIndex(traceObjOid, objType, 2, "Error en la indexaci\u00f3n del objeto " + objType + ":" + idxExc.getMessage());
                    }
                    throw idxExc;
                }
                catch (Exception e) {
                    if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                        this._traceIndex(traceObjOid, objType, 2, "Error general en la indexaci\u00f3n del objeto " + objType + ":" + e.getMessage());
                    }
                    throw new R01MSearchIndexerException(e);
                }
            }
            case 4: {
                try {
                    this._execIndexPortalPage(systemId, (R01MIndexablePortalPage)idxObj, metadataFileNames);
                    break;
                }
                catch (R01MSearchIndexerException idxExc) {
                    if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                        this._traceIndex(traceObjOid, objType, 2, "Error en la indexaci\u00f3n del objeto " + objType + ":" + idxExc.getMessage());
                    }
                    throw idxExc;
                }
                catch (Exception e) {
                    if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                        this._traceIndex(traceObjOid, objType, 2, "Error general en la indexaci\u00f3n del objeto " + objType + ":" + e.getMessage());
                    }
                    throw new R01MSearchIndexerException(e);
                }
            }
            default: {
                if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                    this._traceIndex(traceObjOid, objType, 2, "El tipo de objeto " + objType + " NO es valido para su indexacion en BD.");
                }
                throw new R01MSearchIndexerException("El tipo de objeto " + objType + " NO es valido para su indexacion en BD");
            }
        }
    }

    @Override
    public void unIndex(String systemId, String objOid, int objType, boolean traceIndex) throws R01MSearchIndexerException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("R01KDataBaseIndexer: Des-Indexar objeto indexable " + objOid);
        }
        R01KDataBaseIndexerProcessor idxProc = new R01KDataBaseIndexerProcessor();
        switch (objType) {
            case 0: {
                idxProc.execUnIndexContent("contenidos", objOid);
                if (!traceIndex) break;
                this._traceIndex(objOid, objType, 3, "");
                break;
            }
            case 1: {
                boolean unindex = true;
                R01KIndexableDocumentCMPLocal indexableDocumentCMP = null;
                try {
                    indexableDocumentCMP = R01KIndexableDocumentCMPUtil.getLocalHome().findByPrimaryKey(new R01KIndexableDocumentCMPPK(objOid));
                }
                catch (FinderException findEx) {
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("INDEX CONTENT  >>>> El documento con oid " + (objOid == null ? " [null] " : objOid) + " no existe. No se desindexa");
                    }
                    unindex = false;
                }
                catch (NamingException nameEx) {
                    nameEx.printStackTrace(System.out);
                    String errorMsg = "No se encuentra el Home del EJB de indexaci\u00f3n de documento con oid " + (objOid == null ? " [null] " : objOid);
                    if (traceIndex) {
                        this._traceIndex(objOid, objType, 2, errorMsg);
                    }
                    throw new R01MSearchIndexerException("No se encuentra el Home del EJB de indexaci\u00f3n de documento con oid " + (objOid == null ? " [null] " : objOid), (Exception)nameEx);
                }
                if (!unindex) break;
                idxProc.execUnIndexDocument("contenidos", indexableDocumentCMP.getOidContent(), objOid);
                if (!traceIndex) break;
                this._traceIndex(objOid, objType, 3, "");
                break;
            }
            case 4: {
                idxProc.execUnIndexContent("portales", objOid);
                if (!traceIndex) break;
                this._traceIndex(objOid, objType, 3, "");
                break;
            }
            default: {
                if (traceIndex) {
                    this._traceIndex(objOid, objType, 2, "El tipo de objeto " + objType + " NO es valido para su desindexacion en BD.");
                }
                throw new R01MSearchIndexerException("El tipo de objeto " + objType + " NO es valido para su desindexacion en BD.");
            }
        }
    }

    @Override
    public void unIndex(String systemId, R01MBaseIndexableObject idxObj, String objOid, int objType, boolean traceIndex) throws R01MSearchIndexerException {
        if (objType == 1) {
            R01KIndexableContentCMPLocal indexableContentCMP = null;
            try {
                indexableContentCMP = R01KIndexableContentCMPUtil.getLocalHome().findByPrimaryKey(new R01KIndexableContentCMPPK(idxObj.getOid()));
            }
            catch (FinderException findEx) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("INDEX CONTENT  >>>> El contenido con oid " + idxObj.getOid() + " se indexa por primera vez.");
                }
            }
            catch (NamingException nameEx) {
                nameEx.printStackTrace(System.out);
                if (traceIndex) {
                    this._traceIndex(objOid, objType, 2, "No se encuentra el Home del EJB de indexaci\u00f3n de contenido con oid " + idxObj.getOid());
                }
                throw new R01MSearchIndexerException("No se encuentra el Home del EJB de indexaci\u00f3n de contenido con oid " + idxObj.getOid(), (Exception)nameEx);
            }
            if (indexableContentCMP != null) {
                try {
                    indexableContentCMP.setXmlIndexableContent(XOManager.getXML((String)R01MConstants.INDEXABLEOBJECTS_MAPFILE, (Object)idxObj));
                }
                catch (XOMarshallerException xoEx) {
                    if (traceIndex) {
                        this._traceIndex(objOid, objType, 2, "R01KDataBaseIndexer: Error, no se puede obtener el xml a partir del objeto R01MBaseIndexableObject pasado como par\u00e1metro:" + xoEx.getMessage());
                    }
                    throw new R01MSearchIndexerException("R01KDataBaseIndexer: Error, no se puede obtener el xml a partir del objeto R01MBaseIndexableObject pasado como par\u00e1metro:" + xoEx.getMessage(), (Exception)((Object)xoEx));
                }
            }
        }
        this.unIndex(systemId, objOid, objType, traceIndex);
    }

    public boolean exists(String objOid) throws R01MSearchIndexerException {
        boolean exists = false;
        try {
            R01KIndexableContentCMPUtil.getLocalHome().findByPrimaryKey(new R01KIndexableContentCMPPK(objOid));
            exists = true;
        }
        catch (FinderException findEx) {
            exists = false;
        }
        catch (NamingException nameEx) {
            nameEx.printStackTrace(System.out);
            throw new R01MSearchIndexerException("No se encuentra el Home del EJB de indexaci\u00f3n de contenido con oid " + objOid, (Exception)nameEx);
        }
        return exists;
    }

    @Override
    public boolean checkIndex(String systemId, String objOid, int objType) throws R01MSearchIndexerException {
        String dateOnMillis;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Comprobar la indexaci\u00f3n del documento/p\u00e1gina " + objOid);
        }
        boolean isPublished = false;
        List publications = null;
        String publishRepositoryOid = null;
        long millisecondsOnR01D = 0L;
        String objName = "";
        if (objType == 1) {
            R01MDocument currDocument;
            try {
                currDocument = R01MClientFactory.getContentModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext()).loadDocument(objOid);
                objName = currDocument.getInternalName();
            }
            catch (Exception ex) {
                String errorMsg = "Error al obtener el contenido del documento '" + objOid + "'.Error:" + ex.getMessage();
                if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                    this._traceIndex(objOid, objType, 2, errorMsg);
                }
                R01FLog.to((String)LOG_TYPE_ID).warning(errorMsg);
                throw new R01MSearchIndexerException(errorMsg);
            }
            try {
                R01KIndexableDocumentCMPUtil.getLocalHome().findByPrimaryKey(new R01KIndexableDocumentCMPPK(currDocument.getOid()));
            }
            catch (FinderException ex) {
                if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                    this._traceIndex(objOid, objType, 2, "El documento no est\u00e1 indexado.");
                }
                return false;
            }
            catch (NamingException ex) {
                String errorMsg = "Error al obtener la informaci\u00f3n de indexaci\u00f3n del documento " + objName + " en la Base de Datos.Error:" + ex.getMessage();
                if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                    this._traceIndex(objOid, objType, 2, errorMsg);
                }
                R01FLog.to((String)LOG_TYPE_ID).warning(errorMsg);
                throw new R01MSearchIndexerException(errorMsg);
            }
            try {
                isPublished = currDocument.isPublishedInAnyRepository();
            }
            catch (Exception ex) {
                String errorMsg = "Error al validar si el documento " + objName + " est\u00e1 publicado.Error:" + ex.getMessage();
                if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                    this._traceIndex(objOid, objType, 2, errorMsg);
                }
                R01FLog.to((String)LOG_TYPE_ID).warning(errorMsg);
                throw new R01MSearchIndexerException(errorMsg);
            }
            if (isPublished) {
                publications = currDocument.getPublicationInfo();
                for (R01MDocumentPublicationTarget pub : publications) {
                    if (pub.getState() != 1) continue;
                    dateOnMillis = "" + DateUtils.getDateAsMillis((Date)pub.getPublishDate());
                    dateOnMillis = dateOnMillis.substring(0, dateOnMillis.length() - 3) + "000";
                    millisecondsOnR01D = Long.parseLong(dateOnMillis);
                    publishRepositoryOid = pub.getOid();
                }
            }
        } else if (objType == 4) {
            R01MPage currPage;
            try {
                currPage = R01MClientFactory.getPortalModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext(), null).loadPortalPage(objOid);
                objName = currPage.getInternalName();
            }
            catch (Exception ex) {
                String errorMsg = "Error al obtener el contenido de la p\u00e1gina '" + objOid + "'.Error:" + ex.getMessage();
                if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                    this._traceIndex(objOid, objType, 2, errorMsg);
                }
                R01FLog.to((String)LOG_TYPE_ID).warning(errorMsg);
                throw new R01MSearchIndexerException(errorMsg);
            }
            try {
                R01KIndexableDocumentCMPUtil.getLocalHome().findByPrimaryKey(new R01KIndexableDocumentCMPPK(currPage.getOid()));
            }
            catch (FinderException ex) {
                if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                    this._traceIndex(objOid, objType, 2, "El documento no est\u00e1 indexado.");
                }
                return false;
            }
            catch (NamingException ex) {
                String errorMsg = "Error al obtener la informaci\u00f3n de indexaci\u00f3n de la p\u00e1gina " + objName + " en la Base de Datos.Error:" + ex.getMessage();
                if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                    this._traceIndex(objOid, objType, 2, errorMsg);
                }
                R01FLog.to((String)LOG_TYPE_ID).warning(errorMsg);
                throw new R01MSearchIndexerException(errorMsg);
            }
            try {
                isPublished = currPage.isPublishedInAnyRepository();
            }
            catch (Exception ex) {
                String errorMsg = "Error al validar si la p\u00e1gina " + objName + " est\u00e1 publicada.Error:" + ex.getMessage();
                if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                    this._traceIndex(objOid, objType, 2, errorMsg);
                }
                R01FLog.to((String)LOG_TYPE_ID).warning(errorMsg);
                throw new R01MSearchIndexerException(errorMsg);
            }
            if (isPublished) {
                publications = currPage.getPublicationInfo();
                for (R01MDocumentPublicationTarget pub : publications) {
                    if (pub.getState() != 1) continue;
                    dateOnMillis = "" + DateUtils.getDateAsMillis((Date)pub.getPublishDate());
                    dateOnMillis = dateOnMillis.substring(0, dateOnMillis.length() - 3) + "000";
                    millisecondsOnR01D = Long.parseLong(dateOnMillis);
                    publishRepositoryOid = pub.getOid();
                }
            }
        } else {
            return false;
        }
        if (isPublished && !StringUtils.isEmptyString(publishRepositoryOid)) {
            long millisecondsOnR01K = 0L;
            try {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("Obtener la publicaci\u00f3n del documento/p\u00e1gina " + objName + " de identificador " + objOid);
                }
                R01KPublicationInfoCMPValue publicationInfoCMPValue = R01KPublicationInfoCMPUtil.getLocalHome().findByPrimaryKey(new R01KPublicationInfoCMPPK(publishRepositoryOid, 1, objOid)).getR01KPublicationInfoCMPValue();
                dateOnMillis = "" + DateUtils.getDateAsMillis((Date)publicationInfoCMPValue.getFechaPublicationInfo());
                dateOnMillis = dateOnMillis.substring(0, dateOnMillis.length() - 3) + "000";
                millisecondsOnR01K = Long.parseLong(dateOnMillis);
            }
            catch (FinderException ex) {
                if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                    this._traceIndex(objOid, objType, 2, "El documento no tiene informacion de publicaci\u00f3n.");
                }
                return false;
            }
            catch (NamingException ex) {
                String errorMsg = "Error al obtener la fecha de publicaci\u00f3n del documento " + objName + " en la indexaci\u00f3n de Base de Datos.Error:" + ex.getMessage();
                if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                    this._traceIndex(objOid, objType, 2, errorMsg);
                }
                R01FLog.to((String)LOG_TYPE_ID).warning(errorMsg);
                throw new R01MSearchIndexerException(errorMsg);
            }
            if (millisecondsOnR01K != millisecondsOnR01D) {
                StringBuffer idxCompareFail = new StringBuffer();
                idxCompareFail.append("Fecha de publicacion en Base de datos incorrecta R01D=");
                idxCompareFail.append(R01MDateUtils.dateTimeSecondsToStr((Date)new Date(millisecondsOnR01D), (String)"es"));
                idxCompareFail.append(" (");
                idxCompareFail.append(millisecondsOnR01D);
                idxCompareFail.append(" msecs)) <-> R01K=");
                idxCompareFail.append(R01MDateUtils.dateTimeSecondsToStr((Date)new Date(millisecondsOnR01K), (String)"es"));
                idxCompareFail.append(" (");
                idxCompareFail.append(millisecondsOnR01K);
                idxCompareFail.append(" msecs))\n");
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("La fecha de publicaci\u00f3n del documento " + objName + " en la Base de Datos del Gestor de contenidos y del Indexador es diferente." + idxCompareFail.toString());
                }
                if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                    this._traceIndex(objOid, objType, 2, "El documento esta indexado, pero no cumple los criterios de fecha de publicacion.");
                }
                return false;
            }
        }
        if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
            this._traceIndex(objOid, objType, 4, "");
        }
        return true;
    }

    @Override
    public boolean checkUnIndex(String systemId, String objOid, int objType) throws R01MSearchIndexerException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Comprobar la desindexaci\u00f3n del documento/p\u00e1gina " + objOid);
        }
        try {
            R01KIndexableDocumentCMPUtil.getLocalHome().findByPrimaryKey(new R01KIndexableDocumentCMPPK(objOid));
        }
        catch (FinderException ex) {
            if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                this._traceIndex(objOid, objType, 4, "");
            }
            return true;
        }
        catch (NamingException ex) {
            String errorMsg = "Error al obtener la informaci\u00f3n de indexaci\u00f3n del documento/p\u00e1gina " + objOid + " en la Base de Datos.Error:" + ex.getMessage();
            if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                this._traceIndex(objOid, objType, 2, errorMsg);
            }
            R01FLog.to((String)LOG_TYPE_ID).warning(errorMsg);
            throw new R01MSearchIndexerException(errorMsg);
        }
        if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
            this._traceIndex(objOid, objType, 2, "El objeto contin\u00faa indexado en la Base de Datos.");
        }
        return false;
    }

    private void _execSpecificMetadataIndex(R01MIndexableDataFile idxDf, R01MIndexableDocument idxDoc, R01KDataBaseIndexerProcessor idxProc, TypoStorageConfig typoStorage) throws R01MSearchIndexerException {
        if (idxDf.getMetaData() == null || idxDf.getMetaData().size() == 0) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\t\tNO existen metaDatos especificos a indexar en una tabla particular del tipo");
            }
        } else if (typoStorage.familyStorage.getProperties() != null && typoStorage.familyStorage.getProperties().get("db.pk") != null) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\t\texisten metaDatos especificos a indexar en una tabla particular del tipo");
            }
            String familyInsertSQL = this._buildFamilyInsertSQL(typoStorage, idxDoc, idxDf);
            String familyDeleteSQL = this._buildFamilyDeleteSQL(typoStorage, idxDf);
            String familyDeleteSQLByDatafileOID = StringUtils.replaceString((String)familyDeleteSQL, (String)"?", (String)idxDf.getOid());
            idxProc.execUnIndexDataFileSpecificMetaDataUsingSQLStatement("contenidos", familyDeleteSQLByDatafileOID);
            idxProc.execIndexDataFileSpecificMetaDataUsingSQLStatement("contenidos", familyInsertSQL);
        } else if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("No existe tabla de almacenamiento de metadatos para la familia: cluster='" + typoStorage.clusterStorageConfig.getOid() + "' " + "familia='" + typoStorage.familyStorage.getOid() + "'");
        }
    }

    private void _execIndexContentModelObject(String systemId, R01MIndexableContent idxCont, int objType, List<String> metadataFileNames, Properties props, String traceObjOid) throws R01MSearchIndexerException {
        if (idxCont.getStorage() == null || idxCont.getTypo() == null) {
            String errorMsg = "Se ha intentado indexar un contenido que no tiene almacenamiento o tipolog\u00eda!!";
            R01FLog.to((String)LOG_TYPE_ID).severe(errorMsg);
            if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                this._traceIndex(traceObjOid, objType, 2, errorMsg);
            }
            return;
        }
        if (metadataFileNames == null || metadataFileNames.isEmpty()) {
            try {
                if (objType == 1) {
                    this.unIndex(systemId, (String)props.get("objectOid"), objType, false);
                } else if (objType == 0) {
                    this.unIndex(systemId, idxCont.getOid(), objType, false);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        R01MIndexableStorageInfo storageInfo = idxCont.getStorage();
        R01MIndexableTypoInfo typoInfo = idxCont.getTypo();
        if (storageInfo == null || storageInfo.getServer() == null || storageInfo.getDataStore() == null) {
            String errorMsg = "No se puede indexar el contenido " + idxCont.getOid() + " ya que la informaci\u00f3n de almacenamiento NO es v\u00e1lida (server/dataStore == null?)!";
            if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                this._traceIndex(traceObjOid, objType, 2, errorMsg);
            }
            throw new R01MSearchIndexerException(errorMsg);
        }
        if (typoInfo == null) {
            String errorMsg = "No se puede indexar el contenido " + idxCont.getOid() + " ya que la informaci\u00f3n de tipolog\u00eda NO es v\u00e1lida (cluster == null?)";
            if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                this._traceIndex(traceObjOid, objType, 2, errorMsg);
            }
            throw new R01MSearchIndexerException(errorMsg);
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\t\talmacenamiento> server='" + storageInfo.getServer().getOid() + "' datastore='" + storageInfo.getDataStore().getOid() + "'");
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\t\ttipolog\u00eda     > cluster='" + typoInfo.getCluster().getOid() + "' familia='" + typoInfo.getFamily().getOid() + "'");
        }
        TypoStorageConfig typoStorage = new TypoStorageConfig();
        try {
            typoStorage.load(storageInfo, typoInfo);
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            String errorMsg = "Error en la carga del storage y de la tipolog\u00eda:" + cfgLoadEx.getMessage();
            R01FLog.to((String)LOG_TYPE_ID).severe(errorMsg);
            if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                this._traceIndex(traceObjOid, objType, 2, errorMsg);
            }
            throw new R01MSearchIndexerException(errorMsg, (Exception)((Object)cfgLoadEx));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("R01KDataBaseIndexer: Indexar datos del contenido/documento ............");
        }
        R01KDataBaseIndexerProcessor idxProc = new R01KDataBaseIndexerProcessor();
        R01MClusterStorageIndependentConfig clusterStorageIndependentConfig = null;
        try {
            R01MSearchMetaDataStorageConfig searchMetaDataStorage = SEARCH_METADATA_STORAGE_CONFIG.getSearchMetaDataStorageConfig(storageInfo.getServer().getOid(), storageInfo.getDataStore().getOid());
            clusterStorageIndependentConfig = searchMetaDataStorage.getClusterStorageIndependentConfig();
            if (metadataFileNames == null || metadataFileNames.isEmpty()) {
                idxProc.execIndexContent("contenidos", idxCont);
            } else if (clusterStorageIndependentConfig == null) {
                R01FLog.to((String)LOG_TYPE_ID).severe("ERROR: No se ha recogido la configuraci\u00f3n del clusterIndependent. No se indexar\u00e1 el contenido: " + idxCont.getOid());
            } else {
                idxProc.execIndexContent("contenidos", idxCont, metadataFileNames, clusterStorageIndependentConfig.getMetaDataStorageConfigs());
            }
        }
        catch (R01MConfigLoadException e) {
            String errorMsg = "Error al cargar la configuraci\u00f3n de los metadatos para el clusterIndependent";
            if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                this._traceIndex(traceObjOid, objType, 2, errorMsg);
            }
            throw new R01MSearchIndexerException(errorMsg, (Exception)((Object)e));
        }
        ArrayList<Object> documentsToIndex = new ArrayList<Object>();
        if (objType == 1) {
            documentsToIndex.add(idxCont.getDocument((String)props.get("objectOid")));
        } else if (objType == 0) {
            documentsToIndex.addAll(idxCont.getDocuments().values());
        }
        if (documentsToIndex != null && !documentsToIndex.isEmpty()) {
            for (R01MIndexableDocument r01MIndexableDocument : documentsToIndex) {
                if (r01MIndexableDocument == null) continue;
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("R01KDataBaseIndexer: Indexar el documento " + r01MIndexableDocument.getOid());
                }
                if (metadataFileNames == null || metadataFileNames.isEmpty()) {
                    idxProc.execIndexDocument("contenidos", idxCont, r01MIndexableDocument.getOid());
                } else if (clusterStorageIndependentConfig != null) {
                    idxProc.execIndexDocument("contenidos", idxCont, r01MIndexableDocument.getOid(), metadataFileNames, clusterStorageIndependentConfig.getMetaDataStorageConfigs());
                }
                if (r01MIndexableDocument.getDataFiles() == null || r01MIndexableDocument.getDataFiles().isEmpty()) continue;
                for (R01MIndexableDataFile idxDf : r01MIndexableDocument.getDataFiles().values()) {
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("R01KDataBaseIndexer: Indexar el datafile " + idxDf.getOid());
                    }
                    if (metadataFileNames == null || metadataFileNames.isEmpty()) {
                        idxProc.execIndexDataFile("contenidos", idxCont, r01MIndexableDocument.getOid(), idxDf.getOid());
                    } else if (clusterStorageIndependentConfig != null) {
                        idxProc.execIndexDataFile("contenidos", idxCont, r01MIndexableDocument.getOid(), idxDf.getOid());
                    }
                    if (idxDf.getMetaData() == null || idxDf.getMetaData().isEmpty()) {
                        if (!DEBUG) continue;
                        R01FLog.to((String)LOG_TYPE_ID).info("\t\tNO existen metaDatos especificos a indexar en una tabla particular del tipo");
                        continue;
                    }
                    if (typoStorage.familyStorage.getProperties() != null && typoStorage.familyStorage.getProperties().get("db.pk") != null) {
                        if (DEBUG) {
                            R01FLog.to((String)LOG_TYPE_ID).info("\t\texisten metaDatos especificos a indexar en una tabla particular del tipo");
                        }
                        if (metadataFileNames == null || metadataFileNames.isEmpty()) {
                            String familyInsertSQL = this._buildFamilyInsertSQL(typoStorage, r01MIndexableDocument, idxDf);
                            String familyDeleteSQL = this._buildFamilyDeleteSQL(typoStorage, idxDf);
                            String familyDeleteSQLByDatafileOID = StringUtils.replaceString((String)familyDeleteSQL, (String)"?", (String)idxDf.getOid());
                            idxProc.execUnIndexDataFileSpecificMetaDataUsingSQLStatement("contenidos", familyDeleteSQLByDatafileOID);
                            idxProc.execIndexDataFileSpecificMetaDataUsingSQLStatement("contenidos", familyInsertSQL);
                            continue;
                        }
                        String familyUpdateSQL = this._buildFamilyUpdateSQL(typoStorage, r01MIndexableDocument, idxDf, metadataFileNames);
                        if (familyUpdateSQL == null) continue;
                        String familyUpdateSQLByDatafileOID = StringUtils.replaceString((String)familyUpdateSQL, (String)"?", (String)idxDf.getOid());
                        idxProc.execIndexDataFileSpecificMetaDataUsingSQLStatement("contenidos", familyUpdateSQLByDatafileOID);
                        continue;
                    }
                    if (!DEBUG) continue;
                    R01FLog.to((String)LOG_TYPE_ID).info("No existe tabla de almacenamiento de metadatos para la familia: cluster='" + typoInfo.getCluster().getOid() + "' familia='" + typoInfo.getFamily().getOid() + "'");
                }
            }
        }
        if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
            this._traceIndex(traceObjOid, objType, 3, "");
        }
    }

    private String _buildFamilyInsertSQL(TypoStorageConfig typoStorage, R01MIndexableDocument indexableDoc, R01MIndexableDataFile indexableDataFile) throws R01MSearchIndexerException {
        if (indexableDataFile == null || typoStorage == null) {
            return null;
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\t[Contrucci\u00f3n de sentencia de inserci\u00f3n en la tabla de metaDatos espec\u00edficos de la familia " + typoStorage.familyStorage.getOid() + "]");
        }
        Map familyCommonMetaData = typoStorage.familyStorage.getMetaDataStorageConfigs();
        Map typeSpecificMetaData = typoStorage.typeStorage.getMetaDataStorageConfigs();
        StringBuffer tableFields = new StringBuffer();
        StringBuffer tableValues = new StringBuffer();
        HashMap<String, String> fieldNamesAndValues = new HashMap<String, String>();
        String pkFieldName = (String)typoStorage.familyStorage.getProperties().get("db.pk");
        if (pkFieldName == null) {
            throw new R01MSearchIndexerException("R01KDataBaseIndexer: No se ha configurado la columna PK (primaryKey) para la tabla de la familia " + typoStorage.familyStorage.getOid() + ". NO se indexar\u00e1n los metaDatos especificos de esta familia: Revisa el fichero searchMetadataStorage.xml");
        }
        String pkFieldValue = "'" + indexableDataFile.getOid() + "'";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\t\tcampo pk = oid >> " + pkFieldName + "=" + pkFieldValue);
        }
        tableFields.append(pkFieldName);
        tableValues.append(pkFieldValue);
        Map datafileMetadata = indexableDataFile.getMetaData();
        R01MIndexableMetaData currMetaData2 = null;
        R01MMetaDataStorageConfig currMetaDataStorageCfg = null;
        String currMetaDataFieldName = null;
        String currMetaDataTypeDef = null;
        String currMetaDataType = null;
        String currMetaDataMaxLength = null;
        String currMetaDataValue = null;
        String debugStr = null;
        for (R01MIndexableMetaData currMetaData2 : datafileMetadata.values()) {
            debugStr = "\t\tMetaDato: " + currMetaData2.getMetaDataOid() + "(" + currMetaData2.getMetaDataType() + ")-" + (currMetaData2.getMetaDataValue() == null ? "null" : "no null") + " > ";
            currMetaDataStorageCfg = (R01MMetaDataStorageConfig)familyCommonMetaData.get(currMetaData2.getMetaDataOid());
            if (currMetaDataStorageCfg == null) {
                currMetaDataStorageCfg = (R01MMetaDataStorageConfig)typeSpecificMetaData.get(currMetaData2.getMetaDataOid());
            }
            if (currMetaDataStorageCfg == null) {
                if (!DEBUG) continue;
                R01FLog.to((String)LOG_TYPE_ID).info(debugStr + "[WARNING] NO est\u00e1 definido en la configuraci\u00f3n de almacenamiento. NO se indexa: Revisa el fichero searchMetaDataStorage.xml");
                continue;
            }
            if (!currMetaDataStorageCfg.isIndexable()) {
                if (!DEBUG) continue;
                R01FLog.to((String)LOG_TYPE_ID).info(debugStr + "[WARNING] NO es indexable. Se ignora");
                continue;
            }
            currMetaDataFieldName = (String)currMetaDataStorageCfg.getProperties().get("db.tableCol");
            if (currMetaDataFieldName == null || StringUtils.isEmptyString((String)currMetaDataFieldName)) {
                if (!DEBUG) continue;
                R01FLog.to((String)LOG_TYPE_ID).info(debugStr + "[WARNING] NO se ha definido la propiedad db.tableCol indicando la columna en la que se guarda el metaDato. NO se indexa: Revisa el fichero searchMetaDataStorage.xml");
                continue;
            }
            currMetaDataTypeDef = currMetaDataStorageCfg.getDataType();
            Pattern p = Pattern.compile("(unknown|String|Integer|Long|Short|Float|Double|Date|List|Map|R01MStructureCatalog|R01MGeoCatalog|R01MSearchResultItemPublicationInfo)(?:\\((.+)\\))*");
            Matcher m = p.matcher(currMetaDataTypeDef);
            boolean directiveValid = m.find();
            if (directiveValid && m.groupCount() >= 2) {
                currMetaDataType = m.group(1);
                currMetaDataMaxLength = m.group(2);
            } else if (directiveValid && m.groupCount() == 1) {
                currMetaDataType = m.group(1);
            }
            if ((currMetaDataValue = currMetaData2.getMetaDataValue()) == null || StringUtils.isEmptyString((String)currMetaDataValue)) continue;
            if (currMetaDataType.equalsIgnoreCase("String")) {
                if (currMetaDataMaxLength != null && NumberUtils.isInteger((String)currMetaDataMaxLength)) {
                    if (currMetaDataValue.length() > Integer.parseInt(currMetaDataMaxLength)) {
                        debugStr = debugStr + " -truncado- ";
                        currMetaDataValue = currMetaDataValue.substring(0, Integer.parseInt(currMetaDataMaxLength));
                    }
                } else {
                    if (!DEBUG) continue;
                    R01FLog.to((String)LOG_TYPE_ID).info(debugStr + "[WARNING] No se indica el tama\u00f1o m\u00e1ximo de la columna de la tabla de base de datos donde se indexa el metaDato o bien el valor no es un entero. NO se indexar\u00e1: Revisa el fichero searchMetaDataStorage.xml");
                    continue;
                }
                currMetaDataValue = "'" + currMetaDataValue.replaceAll("'", "''") + "'";
            } else if (currMetaDataType.equalsIgnoreCase("Date")) {
                String currMetaDateValueDateFormated = DateUtils.reformatDateString((String)currMetaDataValue, (String)DateUtils.getLanguageDateFormat((String)indexableDoc.getLanguage(), (Properties)R01MSearchEngineConstants.IDX_DATE_FORMATS), (String)this._nativeDateFormat);
                currMetaDataValue = this._prepareDateMetaDataToSQL(currMetaDateValueDateFormated);
            }
            tableFields.append(',');
            tableFields.append(currMetaDataFieldName);
            tableValues.append(',');
            tableValues.append(currMetaDataValue);
            fieldNamesAndValues.put(currMetaDataFieldName, currMetaDataValue);
            debugStr = debugStr + currMetaDataFieldName + "=" + currMetaDataValue;
            if (!DEBUG) continue;
            R01FLog.to((String)LOG_TYPE_ID).info(debugStr);
        }
        String familyInsertSQL = new String(typoStorage.familySpecificMetaDataInsertSQL);
        HashMap varValues = new HashMap();
        varValues.put("TABLE_NAME", typoStorage.familyStorage.getProperties().get("db.table"));
        varValues.put("TABLE_FIELDS", tableFields.toString());
        varValues.put("TABLE_VALUES", tableValues.toString());
        familyInsertSQL = StringUtils.replaceVariableValues((String)familyInsertSQL, (String)"$", varValues);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\t\tSQL de inserci\u00f3n: " + familyInsertSQL);
        }
        return familyInsertSQL;
    }

    private String _buildFamilyUpdateSQL(TypoStorageConfig typoStorage, R01MIndexableDocument indexableDoc, R01MIndexableDataFile indexableDataFile, List<String> metadataFileNames) throws R01MSearchIndexerException {
        if (indexableDataFile == null || typoStorage == null) {
            return null;
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\t[Contrucci\u00f3n de sentencia de actualizaci\u00f3n en la tabla de metaDatos espec\u00edficos de la familia " + typoStorage.familyStorage.getOid() + "]");
        }
        Map familyCommonMetaData = typoStorage.familyStorage.getMetaDataStorageConfigs();
        Map typeSpecificMetaData = typoStorage.typeStorage.getMetaDataStorageConfigs();
        StringBuffer tableFieldValues = new StringBuffer();
        Map datafileMetadata = indexableDataFile.getMetaData();
        R01MIndexableMetaData currMetaData2 = null;
        R01MMetaDataStorageConfig currMetaDataStorageCfg = null;
        String currMetaDataFieldName = null;
        String currMetaDataTypeDef = null;
        String currMetaDataType = null;
        String currMetaDataMaxLength = null;
        String currMetaDataValue = null;
        String currMetadataIDXType = null;
        String debugStr = null;
        for (R01MIndexableMetaData currMetaData2 : datafileMetadata.values()) {
            debugStr = "\t\tMetaDato: " + currMetaData2.getMetaDataOid() + "(" + currMetaData2.getMetaDataType() + ")-" + (currMetaData2.getMetaDataValue() == null ? "null" : "no null") + " > ";
            currMetaDataStorageCfg = (R01MMetaDataStorageConfig)familyCommonMetaData.get(currMetaData2.getMetaDataOid());
            if (currMetaDataStorageCfg == null) {
                currMetaDataStorageCfg = (R01MMetaDataStorageConfig)typeSpecificMetaData.get(currMetaData2.getMetaDataOid());
            }
            if (currMetaDataStorageCfg == null) {
                if (!DEBUG) continue;
                R01FLog.to((String)LOG_TYPE_ID).info(debugStr + "[WARNING] NO est\u00e1 definido en la configuraci\u00f3n de almacenamiento. NO se indexa: Revisa el fichero searchMetaDataStorage.xml");
                continue;
            }
            if (!currMetaDataStorageCfg.isIndexable()) {
                if (!DEBUG) continue;
                R01FLog.to((String)LOG_TYPE_ID).info(debugStr + "[WARNING] NO es indexable. Se ignora");
                continue;
            }
            currMetaDataFieldName = (String)currMetaDataStorageCfg.getProperties().get("db.tableCol");
            if (currMetaDataFieldName == null || StringUtils.isEmptyString((String)currMetaDataFieldName)) {
                if (!DEBUG) continue;
                R01FLog.to((String)LOG_TYPE_ID).info(debugStr + "[WARNING] NO se ha definido la propiedad db.tableCol indicando la columna en la que se guarda el metaDato. NO se indexa: Revisa el fichero searchMetaDataStorage.xml");
                continue;
            }
            currMetadataIDXType = (String)currMetaDataStorageCfg.getProperties().get("autonomy.idxFile");
            if (metadataFileNames == null || metadataFileNames.isEmpty() || !metadataFileNames.contains(currMetadataIDXType)) continue;
            currMetaDataTypeDef = currMetaDataStorageCfg.getDataType();
            Pattern p = Pattern.compile("(unknown|String|Integer|Long|Short|Float|Double|Date|List|Map|R01MStructureCatalog|R01MGeoCatalog|R01MSearchResultItemPublicationInfo)(?:\\((.+)\\))*");
            Matcher m = p.matcher(currMetaDataTypeDef);
            boolean directiveValid = m.find();
            if (directiveValid && m.groupCount() >= 2) {
                currMetaDataType = m.group(1);
                currMetaDataMaxLength = m.group(2);
            } else if (directiveValid && m.groupCount() == 1) {
                currMetaDataType = m.group(1);
            }
            if ((currMetaDataValue = currMetaData2.getMetaDataValue()) == null || StringUtils.isEmptyString((String)currMetaDataValue)) continue;
            if (currMetaDataType.equalsIgnoreCase("String")) {
                if (currMetaDataMaxLength != null && NumberUtils.isInteger((String)currMetaDataMaxLength)) {
                    if (currMetaDataValue.length() > Integer.parseInt(currMetaDataMaxLength)) {
                        debugStr = debugStr + " -truncado- ";
                        currMetaDataValue = currMetaDataValue.substring(0, Integer.parseInt(currMetaDataMaxLength));
                    }
                } else {
                    if (!DEBUG) continue;
                    R01FLog.to((String)LOG_TYPE_ID).info(debugStr + "[WARNING] No se indica el tama\u00f1o m\u00e1ximo de la columna de la tabla de base de datos donde se indexa el metaDato o bien el valor no es un entero. NO se indexar\u00e1: Revisa el fichero searchMetaDataStorage.xml");
                    continue;
                }
                currMetaDataValue = "'" + currMetaDataValue.replaceAll("'", "''") + "'";
            } else if (currMetaDataType.equalsIgnoreCase("Date")) {
                String currMetaDateValueDateFormated = DateUtils.reformatDateString((String)currMetaDataValue, (String)DateUtils.getLanguageDateFormat((String)indexableDoc.getLanguage(), (Properties)R01MSearchEngineConstants.IDX_DATE_FORMATS), (String)this._nativeDateFormat);
                currMetaDataValue = this._prepareDateMetaDataToSQL(currMetaDateValueDateFormated);
            }
            tableFieldValues.append(currMetaDataFieldName);
            tableFieldValues.append('=');
            tableFieldValues.append(currMetaDataValue);
            debugStr = debugStr + currMetaDataFieldName + "=" + currMetaDataValue;
            if (!DEBUG) continue;
            R01FLog.to((String)LOG_TYPE_ID).info(debugStr);
        }
        String familyUpdateSQL = null;
        if (tableFieldValues != null && tableFieldValues.length() > 0) {
            familyUpdateSQL = new String(typoStorage.familySpecificMetaDataUpdateSQL);
            HashMap varValues = new HashMap();
            String pkFieldName = (String)typoStorage.familyStorage.getProperties().get("db.pk");
            if (pkFieldName == null) {
                throw new R01MSearchIndexerException("R01KDataBaseIndexer: No se ha configurado la columna PK (primaryKey) para la tabla de la familia " + typoStorage.familyStorage.getOid() + ". NO se indexar\u00e1n los metaDatos especificos de esta familia: Revisa el fichero searchMetadataStorage.xml");
            }
            String pkFieldValue = "'" + indexableDataFile.getOid() + "'";
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\t\tcampo pk = oid >> " + pkFieldName + "=" + pkFieldValue);
            }
            varValues.put("TABLE_NAME", typoStorage.familyStorage.getProperties().get("db.table"));
            varValues.put("TABLE_FIELDS_VALUES", tableFieldValues.toString());
            varValues.put("PK_FIELD", pkFieldName);
            varValues.put("PK_FIELD_VALUE", pkFieldValue);
            familyUpdateSQL = StringUtils.replaceVariableValues((String)familyUpdateSQL, (String)"$", varValues);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\t\tSQL de inserci\u00f3n: " + familyUpdateSQL);
            }
        }
        return familyUpdateSQL;
    }

    private String _buildFamilyDeleteSQL(TypoStorageConfig typoStorage, R01MIndexableDataFile indexableDataFile) throws R01MSearchIndexerException {
        String pkFieldName;
        if (indexableDataFile == null || typoStorage == null) {
            return null;
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\t[Contrucci\u00f3n de sentencia de borrado en la tabla de metaDatos espec\u00edficos de la familia " + typoStorage.familyStorage.getOid() + "]");
        }
        if ((pkFieldName = (String)typoStorage.familyStorage.getProperties().get("db.pk")) == null) {
            throw new R01MSearchIndexerException("R01KDataBaseIndexer: No se ha configurado la columna PK (primaryKey) para la tabla de la familia " + typoStorage.familyStorage.getOid() + "NO se indexar\u00e1 informaci\u00f3n relativa a este metaDato: Revisa el fichero searchMetadataStorage.xml");
        }
        String pkFieldValue = "'" + indexableDataFile.getOid() + "'";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\t\tcampo pk = oid >> " + pkFieldName + "=" + pkFieldValue);
        }
        String familyDeleteSQL = new String(typoStorage.familySpecificMetaDataDeleteSQL);
        HashMap varValues = new HashMap();
        varValues.put("TABLE_NAME", typoStorage.familyStorage.getProperties().get("db.table"));
        varValues.put("PK_FIELD", pkFieldName);
        varValues.put("PK_FIELD_VALUE", pkFieldValue);
        familyDeleteSQL = StringUtils.replaceVariableValues((String)familyDeleteSQL, (String)"$", varValues);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\t\tSQL de borrado: " + familyDeleteSQL);
        }
        return familyDeleteSQL;
    }

    private void _execIndexPortalPage(String systemId, R01MIndexablePortalPage idxPage, List<String> metadataFileNames) throws R01MSearchIndexerException {
        block23: {
            if (idxPage.getStorage() == null || idxPage.getTypo() == null) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Se ha intentado indexar una pagina de portal que no tiene almacenamiento o tipolog\u00eda!!");
                return;
            }
            try {
                this.unIndex(systemId, idxPage.getOid(), 4, false);
            }
            catch (Exception e) {
                if (!DEBUG) break block23;
                R01FLog.to((String)LOG_TYPE_ID).info("R01KDataBaseIndexer: No se ha desindexado la p\u00e1gina del portal " + idxPage.getOid() + " Este comportamiento es normal si la p\u00e1gina es nueva");
            }
        }
        R01KDataBaseIndexerProcessor idxProc = new R01KDataBaseIndexerProcessor();
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("R01KDataBaseIndexer: Indexar datos del contenido");
        }
        R01MClusterStorageIndependentConfig clusterStorageIndependentConfig = null;
        if (metadataFileNames == null || metadataFileNames.isEmpty()) {
            idxProc.execIndexContent("portales", (R01MIndexableContent)idxPage);
        } else {
            R01MIndexableStorageInfo storageInfo = idxPage.getStorage();
            try {
                R01MSearchMetaDataStorageConfig searchMetaDataStorage = SEARCH_METADATA_STORAGE_CONFIG.getSearchMetaDataStorageConfig(storageInfo.getServer().getOid(), storageInfo.getDataStore().getOid());
                clusterStorageIndependentConfig = searchMetaDataStorage.getClusterStorageIndependentConfig();
                if (clusterStorageIndependentConfig == null) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("ERROR: No se ha recogido la configuraci\u00f3n del clusterIndependent. No se indexar\u00e1 la p\u00e1gina: " + idxPage.getOid());
                } else {
                    idxProc.execIndexContent("portales", (R01MIndexableContent)idxPage, metadataFileNames, clusterStorageIndependentConfig.getMetaDataStorageConfigs());
                }
            }
            catch (R01MConfigLoadException e) {
                throw new R01MSearchIndexerException("Error al cargar la configuraci\u00f3n de los metadatos para el clusterIndependent", (Exception)((Object)e));
            }
        }
        if (idxPage.getLangPages() != null) {
            TypoStorageConfig typoStorage = new TypoStorageConfig();
            R01MIndexableStorageInfo storageInfo = idxPage.getStorage();
            R01MIndexableTypoInfo typoInfo = idxPage.getTypo();
            if (storageInfo == null || storageInfo.getServer() == null || storageInfo.getDataStore() == null) {
                throw new R01MSearchIndexerException("No se puede indexar la pagina " + idxPage.getOid() + " ya que la informaci\u00f3n de almacenamiento NO es v\u00e1lida (server/dataStore == null?)!");
            }
            if (typoInfo == null) {
                throw new R01MSearchIndexerException("No se puede indexar la pagina " + idxPage.getOid() + " ya que la informaci\u00f3n de tipolog\u00eda NO es v\u00e1lida (cluster == null?)");
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\t\talmacenamiento> server='" + storageInfo.getServer().getOid() + "' datastore='" + storageInfo.getDataStore().getOid() + "'");
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\t\ttipolog\u00eda     > cluster='" + typoInfo.getCluster().getOid() + "' familia='" + typoInfo.getFamily().getOid() + "'");
            }
            try {
                typoStorage.load(storageInfo, typoInfo);
            }
            catch (R01MConfigLoadException cfgLoadEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error en la carga del storage y de la tipolog\u00eda:" + cfgLoadEx.getMessage());
                throw new R01MSearchIndexerException("Error en la carga del storage y de la tipolog\u00eda:" + cfgLoadEx.getMessage(), (Exception)((Object)cfgLoadEx));
            }
            for (R01MIndexablePortalLangPage idxLangPage : idxPage.getLangPages().values()) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("R01KDataBaseIndexer: Indexar la version " + idxLangPage.getOid() + " de la pagina " + idxPage.getOid());
                }
                if (metadataFileNames == null || metadataFileNames.isEmpty()) {
                    idxProc.execIndexDocument("portales", (R01MIndexableContent)idxPage, idxLangPage.getOid());
                } else {
                    idxProc.execIndexDocument("portales", (R01MIndexableContent)idxPage, idxLangPage.getOid(), metadataFileNames, clusterStorageIndependentConfig.getMetaDataStorageConfigs());
                }
                if (idxLangPage.getDataFiles() == null) continue;
                for (R01MIndexableDataFile idxDf : idxLangPage.getDataFiles().values()) {
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("R01KDataBaseIndexer: Indexar el datafile " + idxDf.getOid());
                    }
                    idxProc.execIndexDataFile("contenidos", (R01MIndexableContent)idxPage, idxLangPage.getOid(), idxDf.getOid());
                    this._execSpecificMetadataIndex(idxDf, (R01MIndexableDocument)idxLangPage, idxProc, typoStorage);
                }
            }
        }
    }

    private String _prepareDateMetaDataToSQL(String dateStr) {
        String outDate = new String(dateStr);
        String dbDateConvSentence = this.getProperties() != null && this.getProperties().get("dbInsertDateConvertSentence") != null ? (String)this.getProperties().get("dbInsertDateConvertSentence") : "TO_DATE('$DATEVALUE$','$NATIVE_DATE_FORMAT$')";
        dbDateConvSentence = StringUtils.replaceString((String)dbDateConvSentence, (String)"$NATIVE_DATE_FORMAT$", (String)this.getNativeDateFormat());
        outDate = StringUtils.replaceString((String)dbDateConvSentence, (String)"$DATEVALUE$", (String)outDate);
        return outDate;
    }

    private void _traceIndex(String objOid, int objType, int action, String errorMsg) {
        if (objType == 1 || objType == 4) {
            switch (action) {
                case 1: {
                    R01KTraceIndexHelper.execDatabaseTraceIndexInit((String)objOid);
                    break;
                }
                case 2: {
                    R01KTraceIndexHelper.execDatabaseTraceIndexEndErr((String)objOid, (String)errorMsg);
                    break;
                }
                case 3: {
                    R01KTraceIndexHelper.execDatabaseTraceIndexEnd((String)objOid);
                    break;
                }
                case 4: {
                    R01KTraceIndexHelper.execDatabaseCheckIndexOK((String)objOid);
                    break;
                }
            }
        } else if (objType == 0) {
            try {
                R01MContent theContent = R01MClientFactory.getContentModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext()).loadContent(objOid);
                if (theContent.getDocuments() != null && !theContent.getDocuments().isEmpty()) {
                    for (String documentOid : theContent.getDocuments().keySet()) {
                        switch (action) {
                            case 1: {
                                R01KTraceIndexHelper.execDatabaseTraceIndexInit((String)documentOid);
                                break;
                            }
                            case 2: {
                                R01KTraceIndexHelper.execDatabaseTraceIndexEndErr((String)documentOid, (String)errorMsg);
                                break;
                            }
                            case 3: {
                                R01KTraceIndexHelper.execDatabaseTraceIndexEnd((String)documentOid);
                                break;
                            }
                            case 4: {
                                R01KTraceIndexHelper.execDatabaseCheckIndexOK((String)documentOid);
                                break;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private class TypoStorageConfig {
        R01MClusterStorageConfig clusterStorageConfig = null;
        transient R01MFamilyStorageConfig familyStorage = null;
        transient R01MTypeStorageConfig typeStorage = null;
        transient String familySpecificMetaDataInsertSQL = null;
        transient String familySpecificMetaDataUpdateSQL = null;
        transient String familySpecificMetaDataDeleteSQL = null;

        TypoStorageConfig() {
        }

        void load(R01MIndexableStorageInfo storageInfo, R01MIndexableTypoInfo typoInfo) throws R01MConfigLoadException {
            R01MSearchMetaDataStorageConfig searchMetaDataStorage = SEARCH_METADATA_STORAGE_CONFIG.getSearchMetaDataStorageConfig(storageInfo.getServer().getOid(), storageInfo.getDataStore().getOid());
            R01MClusterStorageConfig clusterStorage = (R01MClusterStorageConfig)searchMetaDataStorage.getClustersStorageConfig().get(typoInfo.getCluster().getOid());
            if (clusterStorage == null) {
                throw new R01MConfigLoadException("Error al indexar: No se encuentra informaci\u00f3n de configuraci\u00f3n de almacenamiento de metadatos para contenidos del cluster '" + typoInfo.getCluster().getOid() + ". Revisa el fichero searchMetaDataStorage.xml");
            }
            this.familyStorage = (R01MFamilyStorageConfig)clusterStorage.getFamiliesStorageConfigs().get(typoInfo.getFamily().getOid());
            if (this.familyStorage == null) {
                throw new R01MConfigLoadException("Error al indexar: No se encuentra informaci\u00f3n de configuraci\u00f3n de almacenamiento de metadatos para contenidos de la familia " + typoInfo.getFamily().getOid() + " en el cluster " + typoInfo.getCluster().getOid() + ". Revisa el fichero searchMetaDataStorage.xml");
            }
            this.typeStorage = (R01MTypeStorageConfig)this.familyStorage.getTypesStorageConfigs().get(typoInfo.getType().getOid());
            if (this.typeStorage == null) {
                throw new R01MConfigLoadException("Error al indexar: No se encuentra la informaci\u00f3n de configuraci\u00f3n de almacenamiento de metadatos para el tipo " + typoInfo.getType().getOid() + " de la familia " + typoInfo.getFamily().getOid() + " en el cluster " + typoInfo.getCluster().getOid() + ". Revisa el fichero searchMetadataStorage.xml");
            }
            this.familySpecificMetaDataInsertSQL = (String)searchMetaDataStorage.getProperties().get("db.specificFamilyMetaDataInsertSQL");
            if (this.familySpecificMetaDataInsertSQL == null) {
                throw new R01MConfigLoadException("Error al indexar: No se encuentra la plantilla de SQL de inserci\u00f3n de metaDatos espec\u00edficos de una familia. Revisa el fichero searchMetaDataStorage.xml");
            }
            this.familySpecificMetaDataUpdateSQL = (String)searchMetaDataStorage.getProperties().get("db.specificFamilyMetaDataUpdateSQL");
            if (this.familySpecificMetaDataUpdateSQL == null) {
                throw new R01MConfigLoadException("Error al indexar: No se encuentra la plantilla de SQL de actualizaci\u00f3n de metaDatos espec\u00edficos de una familia. Revisa el fichero searchMetaDataStorage.xml");
            }
            this.familySpecificMetaDataDeleteSQL = (String)searchMetaDataStorage.getProperties().get("db.specificFamilyMetaDataDeleteSQL");
            if (this.familySpecificMetaDataDeleteSQL == null) {
                throw new R01MConfigLoadException("Error al indexar: No se encuentra la plantilla de SQL de borrado de metaDatos espec\u00edficos de una familia. Revisa el fichero searchMetaDataStorage.xml");
            }
        }
    }
}

