/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01k.searchorchestrator.indexer.indexers;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.sql.DBManager;
import com.ejie.r01f.util.CollectionUtils;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01k.searchorchestrator.indexer.indexers.R01KDCATIndexerProcessor;
import com.ejie.r01k.searchorchestrator.indexer.indexers.R01KSearchEngineIndexer;
import com.ejie.r01k.traceindex.R01KTraceIndexHelper;
import com.ejie.r01m.config.objects.publisher.R01MLogicalPublicationInfo;
import com.ejie.r01m.config.objects.publisher.R01MPublicationConfig;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MCatalogException;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MSearchIndexerException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.cataloguing.R01MStructureCatalog;
import com.ejie.r01m.objects.cataloguing.structures.R01MLabel;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MDataFile;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.contentmodel.R01MDocumentPublicationTarget;
import com.ejie.r01m.objects.searchengine.indexer.R01MBaseIndexableObject;
import com.ejie.r01m.services.R01MCatalogManagerAPI;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01p.objects.opendata.templating.R01PDataSetRecordFile;
import com.ejie.r01p.objects.opendata.templating.R01POpendataDatasetFile;
import com.ejie.r01p.objects.opendata.templating.R01POpendataDatasetItem;
import com.ejie.r01p.objects.opendata.templating.R01POpendataDatasetMapping;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public class R01KDCATIndexer
implements R01KSearchEngineIndexer {
    static boolean DEBUG = R01FLog.getLogLevel((String)"r01k.index").intValue() != Level.OFF.intValue();
    private static final String COMBOLIST_OID = XMLProperties.get((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"comboOpendataTemplateList", (String)"");
    static final transient String OPENDATA_URL = XMLProperties.getString((String)R01MConstants.API_APPCODE, (String)"opendata/url", (String)"http://opendata.euskadi.eus");
    private static int indexerType = R01KSearchEngineIndexer.CONTENT_TYPE_INDEXER;
    private transient Properties _props = null;

    public R01KDCATIndexer() {
    }

    public R01KDCATIndexer(Properties props) {
        this();
        this._props = props;
    }

    @Override
    public void setNativeDateFormat(String dateFormat) {
    }

    @Override
    public String getNativeDateFormat() {
        return null;
    }

    @Override
    public void setProperties(Properties props) {
        this._props = props;
    }

    @Override
    public Properties getProperties() {
        return this._props;
    }

    @Override
    public int getIndexerType() {
        return indexerType;
    }

    @Override
    public void index(String systemId, R01MBaseIndexableObject idxObj, int objType, List<String> metadataFileNames, Properties props) throws R01MSearchIndexerException {
        if (idxObj == null) {
            R01FLog.to((String)"r01k.index").severe("Se ha intentado indexar un objeto NULO!!!");
            return;
        }
        if (objType != 0 && objType != 1) {
            R01FLog.to((String)"r01k.index").severe("Se ha intentado ejecutar la indexaci\u00f3n de DCAT para un objeto que no es contenido!!!");
            return;
        }
        String traceObjOid = idxObj.getOid();
        if (props != null && props.containsKey("objectOid")) {
            traceObjOid = props.getProperty("objectOid").toString();
        }
        if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
            this._traceIndex(traceObjOid, objType, 1, "");
        }
        R01MContent content = null;
        try {
            content = R01MClientFactory.getContentModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext()).loadContent(idxObj.getOid());
        }
        catch (Exception ex) {
            String errorMsg = "Error al cargar el contenido de Oid " + idxObj.getOid() + ". Mensaje: " + ex.getMessage();
            R01FLog.to((String)"r01k.index").severe(errorMsg);
            if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                this._traceIndex(traceObjOid, objType, 2, errorMsg);
            }
            return;
        }
        try {
            StringBuffer dcatFile = this._getDCATContent(content);
            R01KDCATIndexerProcessor idxProc = new R01KDCATIndexerProcessor();
            idxProc.execIndexContent(content, dcatFile);
        }
        catch (R01MSearchIndexerException idxExc) {
            if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                this._traceIndex(traceObjOid, objType, 2, "Error:" + idxExc.getMessage());
            }
            throw idxExc;
        }
        catch (Exception e) {
            if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                this._traceIndex(traceObjOid, objType, 2, "Error general:" + e.getMessage());
            }
            throw new R01MSearchIndexerException(e);
        }
        if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
            this._traceIndex(traceObjOid, objType, 3, "");
        }
        if (DEBUG) {
            R01FLog.to((String)"r01k.index").info("El fichero DCAT se ha generado con \u00e9xito.");
        }
    }

    @Override
    public void unIndex(String systemId, String objectOid, int objectType, boolean traceIndex) throws R01MSearchIndexerException {
    }

    @Override
    public void unIndex(String systemId, R01MBaseIndexableObject idxObj, String objectOid, int objectType, boolean traceIndex) throws R01MSearchIndexerException {
        this.unIndex(systemId, objectOid, objectType, traceIndex);
    }

    @Override
    public boolean checkIndex(String systemId, String objOid, int objType) throws R01MSearchIndexerException {
        if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
            this._traceIndex(objOid, objType, 4, "");
        }
        return true;
    }

    @Override
    public boolean checkUnIndex(String systemId, String objOid, int objType) throws R01MSearchIndexerException {
        if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
            this._traceIndex(objOid, objType, 4, "");
        }
        return true;
    }

    private StringBuffer _getDCATContent(R01MContent content) throws R01MSearchIndexerException {
        StringBuffer outDCAT = new StringBuffer(2000);
        R01MDocument documentResume = null;
        R01MDataFile dataFile = null;
        ArrayList<R01MDocument> publishedDocuments = new ArrayList<R01MDocument>();
        HashMap<String, R01PDataSetRecordFile> datasets = new HashMap<String, R01PDataSetRecordFile>();
        Object objDocument2 = null;
        if (content.getDocuments() != null && !content.getDocuments().isEmpty()) {
            R01MPublicationConfig pub;
            try {
                pub = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(content.getStoreLocation().getWorkAreaOid()).getAllowedPublicationTargetsConfig();
            }
            catch (R01MConfigLoadException cfgExc) {
                R01FLog.to((String)"r01k.index").severe("Error al obtener los repositorios de publicaci\u00f3n de la workarea, los documentos del contenido " + content.getOid() + " no se publican.Error:" + cfgExc.getMessage());
                throw new R01MSearchIndexerException("Error al obtener los repositorios de publicaci\u00f3n de la workarea, los documentos del contenido " + content.getOid() + " no se publican.", (Exception)((Object)cfgExc));
            }
            if (pub.getAllowedTargets() != null && !pub.getAllowedTargets().isEmpty()) {
                for (Object objDocument2 : content.getDocuments().values()) {
                    R01PDataSetRecordFile dataset;
                    boolean isDocPublished = false;
                    documentResume = objDocument2;
                    for (String targetRepOid : pub.getAllowedTargets().keySet()) {
                        try {
                            if (!R01MClientFactory.getContentModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext()).isDocumentPublished(targetRepOid, documentResume.getOid())) continue;
                            isDocPublished = true;
                            break;
                        }
                        catch (R01MSecurityException ex) {
                            R01FLog.to((String)"r01k.index").severe("Error de seguridad para el documento: [" + documentResume.getOid() + "].Error:" + ex.getMessage());
                            throw new R01MSearchIndexerException("Error de seguridad para el documento: [" + documentResume.getOid() + "]", (Exception)((Object)ex));
                        }
                        catch (R01MContentModelException ex) {
                            R01FLog.to((String)"r01k.index").severe("Error al saber si un documento est\u00e1 publicado o no para el oid: [" + documentResume.getOid() + "].Error:" + ex.getMessage());
                            throw new R01MSearchIndexerException("Error al saber si un documento est\u00e1 publicado o no para el oid: [" + documentResume.getOid() + "]", (Exception)((Object)ex));
                        }
                    }
                    if (!isDocPublished) continue;
                    try {
                        content = R01MClientFactory.getContentModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext()).loadContentDocumentLazy(content, documentResume.getOid());
                    }
                    catch (R01MSecurityException ex) {
                        R01FLog.to((String)"r01k.index").severe("Error de seguridad para el documento: [" + documentResume.getOid() + "].Error:" + ex.getMessage());
                        throw new R01MSearchIndexerException("Error de seguridad para el documento: [" + documentResume.getOid() + "]", (Exception)((Object)ex));
                    }
                    catch (R01MContentModelException ex) {
                        R01FLog.to((String)"r01k.index").severe("Error al saber si un documento est\u00e1 publicado o no para el oid: [" + documentResume.getOid() + "].Error:" + ex.getMessage());
                        throw new R01MSearchIndexerException("Error al saber si un documento est\u00e1 publicado o no para el oid: [" + documentResume.getOid() + "]", (Exception)((Object)ex));
                    }
                    R01MDocument document = content.getDocument(documentResume.getOid());
                    publishedDocuments.add(document);
                    if (document.getDataFiles() == null || document.getDataFiles().isEmpty()) continue;
                    dataFile = (R01MDataFile)document.getDataFiles().values().iterator().next();
                    try {
                        dataset = R01POpendataDatasetMapping.mapObject((R01MUserContext)R01MAuthManager.createMasterSystemUserContext(), (R01MContent)content, (R01MDocument)document, (String)dataFile.getOid());
                    }
                    catch (R01MSecurityException secExc) {
                        throw new R01MSearchIndexerException("El contexto de usuario no es valido, o el usuario no tiene acceso.", (Exception)((Object)secExc));
                    }
                    if (dataset == null) continue;
                    datasets.put(document.getOid(), dataset);
                }
            }
            outDCAT = this._formatAsDCAT(content, publishedDocuments, datasets);
            outDCAT = this._decorateDCAT(outDCAT);
        }
        return outDCAT;
    }

    private StringBuffer _formatAsDCAT(R01MContent content, List publishedDocuments, Map datasets) {
        StringBuffer dcatFile = new StringBuffer(471);
        dcatFile.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n");
        dcatFile.append("<rdf:RDF xmlns:cc=\"http://creativecommons.org/ns#\" \r\n\txmlns:foaf=\"http://xmlns.com/foaf/0.1/\" \r\n\txmlns:prv=\"http://purl.org/net/provenance/ns#\" \r\n\txmlns:dc=\"http://purl.org/dc/elements/1.1/\" \r\n\txmlns:dctype=\"http://purl.org/dc/dcmitype/\" \r\n\txmlns:dcterms=\"http://purl.org/dc/terms/\" \r\n\txmlns:dcat=\"http://www.w3.org/ns/dcat#\"\r\n\txmlns:dct=\"http://purl.org/dc/terms/\"\r\n\txmlns:skos=\"http://www.w3.org/2004/02/skos/core#\"\r\n\txmlns:vcard=\"http://www.w3.org/2006/vcard/ns#\"\r\n\txmlns:xsd=\"http://www.w3.org/2001/XMLSchema#\"\r\n\txmlns:time=\"http://www.w3.org/TR/owl-time/#\"\r\n\txmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" \r\n\txmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\" \r\n\txmlns:void=\"http://rdfs.org/ns/void#\">\r\n");
        String opendataDirectoryURL = OPENDATA_URL + "/w79-contgen/es/" + "contenidos" + "/" + content.getTypo().getTypeOid() + "/" + content.getInternalName() + "/opendata/";
        dcatFile.append("\t<dcat:Catalog rdf:about=\"").append(opendataDirectoryURL).append("\">\r\n");
        R01MDocument mainDocument = null;
        for (R01MDocument currentDocument : publishedDocuments) {
            if (!currentDocument.getLanguage().equals("es")) continue;
            mainDocument = currentDocument;
            break;
        }
        Map logicalPublications = null;
        try {
            logicalPublications = R01MClientFactory.getPublisherConfigAPI().getLogicalPublicationsConfigs();
        }
        catch (R01MConfigLoadException ex) {
            // empty catch block
        }
        String contentAlias = "contenidos";
        if (logicalPublications != null && mainDocument != null && mainDocument.getPublicationInfo() != null && !mainDocument.getPublicationInfo().isEmpty()) {
            for (R01MDocumentPublicationTarget currPublication : mainDocument.getPublicationInfo()) {
                if (currPublication.getState() != 1 || !logicalPublications.containsKey(currPublication.getOid())) continue;
                contentAlias = ((R01MLogicalPublicationInfo)logicalPublications.get(currPublication.getOid())).getContentAlias();
                if (!StringUtils.isEmptyString((String)contentAlias)) break;
                contentAlias = "contenidos";
                break;
            }
        }
        HashMap<String, String> titles = new HashMap<String, String>();
        HashMap<String, String> descriptions = new HashMap<String, String>();
        HashMap<String, String[]> periodicity = new HashMap<String, String[]>();
        HashMap<String, String[]> creator = new HashMap<String, String[]>();
        HashMap<String, String> datasetTypes = new HashMap<String, String>();
        HashMap<String, String> datasetTypesSize = new HashMap<String, String>();
        HashMap<String, String> datasetContentsRelativePath = new HashMap<String, String>();
        HashMap<String, String> datasetMimeTypes = new HashMap<String, String>();
        HashMap<String, String> datasetSubjects = new HashMap<String, String>();
        HashMap<String, String[]> datasetReferences = new HashMap<String, String[]>();
        R01PDataSetRecordFile mainDataset = null;
        for (R01MDocument currentDocument : publishedDocuments) {
            R01PDataSetRecordFile currentDataset = (R01PDataSetRecordFile)datasets.get(currentDocument.getOid());
            if (currentDocument.getLanguage().equals("es")) {
                mainDataset = currentDataset;
            }
            if (currentDataset != null && currentDataset.getGeneralData() != null) {
                if (!StringUtils.isEmptyString((String)currentDataset.getGeneralData().getDenomination())) {
                    titles.put(currentDocument.getLanguage(), StringEscapeUtils.escapeXml((String)currentDataset.getGeneralData().getDenomination()));
                }
                if (!StringUtils.isEmptyString((String)currentDataset.getGeneralData().getDescription())) {
                    descriptions.put(currentDocument.getLanguage(), StringEscapeUtils.unescapeHtml((String)StringUtils.filterInvalidXMLCharacters((String)currentDataset.getGeneralData().getDescription().replaceAll("</?\\w++[^>]*+>", ""))));
                }
                if (!StringUtils.isEmptyString((String)currentDataset.getDetailsData().getPeriodicity())) {
                    periodicity.put(currentDocument.getLanguage(), new String[]{"$[" + currentDataset.getDetailsData().getPeriodicity() + "_" + currentDocument.getLanguage() + "]$", StringEscapeUtils.escapeXml((String)MessageFormat.format(R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)currentDocument.getLanguage(), (String)"rdf.frecuencia"), "$[" + currentDataset.getDetailsData().getPeriodicity() + "_" + currentDocument.getLanguage() + "]$"))});
                }
                if (!StringUtils.isEmptyString((String)currentDataset.getDetailsData().getDptoSource())) {
                    if (currentDataset.getGeneralData().isStatistic()) {
                        creator.put(currentDocument.getLanguage(), new String[]{StringEscapeUtils.escapeXml((String)currentDataset.getDetailsData().getDptoSource()), StringEscapeUtils.escapeXml((String)R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)currentDocument.getLanguage(), (String)"rdf.creador.eustat.descripcion"))});
                    } else {
                        creator.put(currentDocument.getLanguage(), new String[]{StringEscapeUtils.escapeXml((String)currentDataset.getDetailsData().getDptoSource()), StringEscapeUtils.escapeXml((String)R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)currentDocument.getLanguage(), (String)"rdf.creador.gobierno.descripcion"))});
                    }
                }
                if (currentDataset.getGeneralData().getDownloadDataset() != null && !currentDataset.getGeneralData().getDownloadDataset().isEmpty()) {
                    R01POpendataDatasetItem datasetItem2 = null;
                    for (R01POpendataDatasetItem datasetItem2 : currentDataset.getGeneralData().getDownloadDataset()) {
                        if (datasetItem2 == null) continue;
                        datasetContentsRelativePath.put(currentDocument.getLanguage(), datasetItem2.getContentRelativePath() == null ? null : StringEscapeUtils.escapeXml((String)(datasetItem2.getContentRelativePath().toLowerCase().indexOf("http:") != -1 ? datasetItem2.getContentRelativePath() : OPENDATA_URL + datasetItem2.getContentRelativePath())));
                        datasetTypes.put(currentDocument.getLanguage(), datasetItem2.getType() == null ? null : "$[" + datasetItem2.getType() + "_" + currentDocument.getLanguage() + "]$");
                        datasetTypesSize.put(currentDocument.getLanguage(), datasetItem2.getSize() == null ? null : datasetItem2.getSize() + " " + (StringUtils.isEmptyString((String)datasetItem2.getUnits()) ? "" : "$[" + datasetItem2.getUnits() + "_" + currentDocument.getLanguage() + "]$"));
                        datasetMimeTypes.put(currentDocument.getLanguage(), datasetItem2.getMimeType());
                    }
                }
            }
            if (currentDataset != null && currentDataset.getDetailsData() != null && currentDataset.getDetailsData().getTags() != null) {
                String[] etiquetas = currentDataset.getDetailsData().getTags().split(",");
                for (int i = 0; i < etiquetas.length; ++i) {
                    datasetSubjects.put(currentDocument.getLanguage(), StringEscapeUtils.escapeXml((String)etiquetas[i].trim()));
                }
            }
            if (currentDataset == null || currentDataset.getDatasetFiles() == null || currentDataset.getDatasetFiles().isEmpty()) continue;
            R01POpendataDatasetFile datasetFile2 = null;
            for (R01POpendataDatasetFile datasetFile2 : currentDataset.getDatasetFiles()) {
                datasetReferences.put(currentDocument.getLanguage(), new String[]{StringEscapeUtils.escapeXml((String)datasetFile2.getText()), StringEscapeUtils.escapeXml((String)datasetFile2.getContentRelativePath())});
            }
        }
        if (mainDocument != null) {
            if (!StringUtils.isEmptyString((String)mainDocument.getName())) {
                dcatFile.append("\t\t<dct:title xml:lang=\"es\">").append(StringUtils.encodeUTF((String)mainDocument.getName())).append("</dct:title>\r\n");
            }
            if (!StringUtils.isEmptyString((String)mainDocument.getDescription())) {
                dcatFile.append("\t\t<dct:description xml:lang=\"es\">").append(mainDocument.getDescription()).append("</dct:description>\r\n");
            }
        }
        dcatFile.append("\t\t<dct:issued rdf:datatype=\"http://www.w3.org/2001/XMLSchema#dateTime\">").append(DateUtils.getDateFormated((Date)content.getCreateDate(), (String)"yyyy-MM-dd hh:mm:ss:SS")).append("</dct:issued>\r\n");
        dcatFile.append("\t\t<dct:modified rdf:datatype=\"http://www.w3.org/2001/XMLSchema#dateTime\">").append(DateUtils.getDateFormated((Date)new Date(), (String)"yyyy-MM-dd hh:mm:ss:SS")).append("</dct:modified>\r\n");
        dcatFile.append("\r\n");
        for (R01MDocument currentDocument : publishedDocuments) {
            dcatFile.append("\t\t<dct:language>").append(currentDocument.getLanguage()).append("</dct:language>\r\n");
        }
        dcatFile.append("\t\t<dct:publisher rdf:resource=\"").append(R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)"es", (String)"rdf.publicador.title")).append("\" />\r\n");
        dcatFile.append("\t\t<dct:spatial rdf:resource=\"http://sws.geonames.org/3336903/\" />\r\n\t\t<dct:spatial rdf:resource=\"http://sws.geonames.org/3130717/\" />\r\n\t\t<dct:spatial rdf:resource=\"http://sws.geonames.org/3104469/\" />\r\n\t\t<dct:spatial rdf:resource=\"http://sws.geonames.org/3120935/\" />\r\n");
        if (content.getLabels() != null && !content.getLabels().isEmpty()) {
            R01MStructureCatalog structureCatalog2 = null;
            R01MLabel label = null;
            R01MCatalogManagerAPI catalogAPI = new R01MCatalogManagerAPI();
            for (R01MStructureCatalog structureCatalog2 : content.getLabels()) {
                try {
                    String labelValue = "";
                    label = catalogAPI.loadLabel(structureCatalog2.getOid(), false);
                    if (label != null && label.getStandardizedTerm("en") != null) {
                        labelValue = label.getStandardizedTerm("en").getValue();
                    } else if (label != null && label.getStandardizedTerm("es") != null) {
                        labelValue = label.getStandardizedTerm("es").getValue();
                        labelValue = labelValue.replaceAll("[\u00c0\u00c1\u00c4\u00e1\u00e0\u00e4]", "a").replaceAll("[\u00c8\u00c9\u00cb\u00e8\u00e9\u00eb]", "e").replaceAll("[\u00cc\u00cd\u00cf\u00ec\u00ed\u00ef]", "i").replaceAll("[\u00d2\u00d3\u00d6\u00f2\u00f3\u00f6]", "o").replaceAll("[\u00d9\u00da\u00dc\u00f9\u00fa\u00fc]", "u").replaceAll("[\u00d1\u00f1]", "n");
                    } else if (label != null && label.getStandardizedTerm("eu") != null) {
                        labelValue = label.getStandardizedTerm("eu").getValue();
                    }
                    if (StringUtils.isEmptyString((String)labelValue)) continue;
                    labelValue = labelValue.trim().replaceAll("[\\s]+", " ");
                    labelValue = StringUtils.capitalizeAllFirstLetters((String)labelValue);
                    labelValue = labelValue.replaceAll(" ", "_").replaceAll("[,+:]/", "").replaceAll("['\u00b4]", "_");
                    dcatFile.append("\t\t<dcat:themeTaxonomy rdf:resource=\"").append(OPENDATA_URL).append("/taxonomy/labels/").append(StringEscapeUtils.escapeXml((String)StringUtils.capitalizeAllFirstLetters((String)labelValue.trim()).replaceAll(" ", "_"))).append("\" />\r\n");
                }
                catch (R01MCatalogException ex1) {
                    R01FLog.to((String)"r01k.index").warning("Excepci\u00f3n a la hora de recuperar la etiqueta");
                }
            }
        }
        dcatFile.append("\t\t<dcat:dataset>\r\n");
        String contentUrl = OPENDATA_URL + "/" + contentAlias + "/" + content.getTypo().getTypeOid() + "/" + content.getInternalName();
        for (R01MDocument currentDocument : publishedDocuments) {
            String currentLanguage;
            R01PDataSetRecordFile dataset = (R01PDataSetRecordFile)datasets.get(currentDocument.getOid());
            String language = currentDocument.getLanguage();
            String documentUrl = contentUrl + "/" + mainDocument.getLanguage() + "_" + mainDocument.getInternalName() + "/";
            if (currentDocument.getDataFiles() != null && !currentDocument.getDataFiles().isEmpty()) {
                String datafileName = ((R01MDataFile)currentDocument.getDataFiles().values().iterator().next()).getPreviewUrl().replaceAll("^.*/([^/]+)$", "$1");
                documentUrl = documentUrl + datafileName;
            }
            dcatFile.append("\t\t\t<dcat:Dataset rdf:about=\"").append(documentUrl).append("\">\r\n");
            if (dataset != null && dataset.getGeneralData() != null && !StringUtils.isEmptyString((String)dataset.getGeneralData().getDenomination())) {
                dcatFile.append("\t\t\t\t<dct:title xml:lang=\"").append(language).append("\">").append(StringEscapeUtils.escapeXml((String)dataset.getGeneralData().getDenomination())).append("</dct:title>\r\n");
            }
            if (!StringUtils.isEmptyString((String)currentDocument.getDescription())) {
                dcatFile.append("\t\t\t\t<dct:description xml:lang=\"").append(language).append("\">").append(currentDocument.getDescription()).append("</dct:description>\r\n");
            }
            dcatFile.append("\r\n");
            if (dataset != null && dataset.getGeneralData() != null && dataset.getGeneralData().getDenomination() != null) {
                dcatFile.append("\t\t\t\t<rdfs:label xml:lang=\"").append(language).append("\">").append(StringEscapeUtils.escapeXml((String)dataset.getGeneralData().getDenomination())).append("</rdfs:label>\r\n");
            }
            if (dataset != null && dataset.getDetailsData() != null && dataset.getDetailsData().getCreateData() != null) {
                dcatFile.append("\t\t\t\t<dct:issued rdf:datatype=\"http://www.w3.org/2001/XMLSchema#date\">").append(dataset.getDetailsData().getCreateData()).append("</dct:issued>\r\n");
            }
            if (dataset != null && dataset.getDetailsData() != null && dataset.getDetailsData().getUpdateDate() != null) {
                dcatFile.append("\t\t\t\t<dct:modified rdf:datatype=\"http://www.w3.org/2001/XMLSchema#date\">").append(dataset.getDetailsData().getUpdateDate()).append("</dct:modified>\r\n");
            }
            dcatFile.append("\r\n");
            dcatFile.append("\t\t\t\t<dct:language>").append(language).append("</dct:language>\r\n");
            dcatFile.append("\r\n");
            dcatFile.append("\t\t\t\t<dct:publisher rdf:resource=\"").append(R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)language, (String)"rdf.publicador.title")).append("\" />\r\n");
            dcatFile.append("\r\n");
            if (creator.size() > 0) {
                dcatFile.append("\t\t\t\t<dcterms:creator>\r\n");
                if (dataset.getGeneralData().isStatistic()) {
                    dcatFile.append("\t\t\t\t\t<dcterms:Agent rdf:about=\"http://www.eustat.es/\">\r\n");
                } else {
                    dcatFile.append("\t\t\t\t\t<dcterms:Agent rdf:about=\"http://www.ejgv.euskadi.eus/\">\r\n");
                }
                for (Map.Entry entry : creator.entrySet()) {
                    String currentLanguage2 = (String)entry.getKey();
                    String[] creatorTexts = (String[])entry.getValue();
                    dcatFile.append("\t\t\t\t\t\t<rdfs:label xml:lang=\"").append(currentLanguage2).append("\">").append(creatorTexts[0]).append("</rdfs:label>\r\n");
                    dcatFile.append("\t\t\t\t\t\t<rdfs:comment xml:lang=\"").append(currentLanguage2).append("\">").append(creatorTexts[1]).append("</rdfs:comment>\r\n");
                }
                dcatFile.append("\t\t\t\t\t</dcterms:Agent>\r\n\t\t\t\t</dcterms:creator>\r\n");
                if (dataset.getGeneralData().isStatistic()) {
                    dcatFile.append("\t\t\t\t<prv:createdBy rdf:resource=\"http://www.eustat.es/\" />\r\n");
                } else {
                    dcatFile.append("\t\t\t\t<prv:createdBy rdf:resource=\"http://www.ejgv.euskadi.eus/\" />\r\n");
                }
                dcatFile.append("\r\n");
            }
            String licenseUrl = OPENDATA_URL + "/w79-contgen/es/" + "contenidos" + "/informacion/info_legal/es_info_leg/info_legal.html";
            if (dataset != null && dataset.getGeneralData() != null && dataset.getGeneralData().isStatistic()) {
                licenseUrl = "http://www.eustat.es/informacionLegal_c.html";
            } else if (content.getTypo().getTypeOid().equals("ds_meteorologicos")) {
                licenseUrl = "http://www.euskalmet.euskadi.eus/s07-5893/es/contenidos/informacion/informacion_legal/es_6303/informacion_legal.html";
            }
            dcatFile.append("\t\t\t\t<dct:license rdf:resource=\"").append(licenseUrl).append("\" />\r\n");
            dcatFile.append("\r\n");
            if (dataset != null && dataset.getDetailsData() != null && !StringUtils.isEmptyString((String)dataset.getDetailsData().getPeriodicity())) {
                dcatFile.append("\t\t\t\t<dct:accrualPeriodicity>\r\n\t\t\t\t\t<dct:Frequency>\r\n\t\t\t\t\t\t<rdfs:label>").append(StringEscapeUtils.escapeXml((String)MessageFormat.format(R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)language, (String)"rdf.frecuencia"), "$[" + dataset.getDetailsData().getPeriodicity() + "_" + language + "]$"))).append("</rdfs:label>\r\n\t\t\t\t\t\t<rdf:value>\r\n\t\t\t\t\t\t\t<time:DurationDescription>\r\n\t\t\t\t\t\t\t\t<rdfs:label>").append("$[" + dataset.getDetailsData().getPeriodicity() + "_" + language + "]$").append("</rdfs:label>\r\n\t\t\t\t\t\t\t\t<time:days rdf:datatype=\"http://www.w3.org/2001/XMLSchema#decimal\">").append(dataset.getDetailsData().getPeriodicity()).append("</time:days>\r\n\t\t\t\t\t\t\t</time:DurationDescription>\r\n\t\t\t\t\t\t</rdf:value>\r\n\t\t\t\t\t</dct:Frequency>\r\n\t\t\t\t</dct:accrualPeriodicity>\r\n");
                dcatFile.append("\r\n");
            }
            dcatFile.append("\t\t\t\t<dct:identifier>").append(content.getTypo().getTypeOid() + "/" + content.getInternalName() + "/" + language + "_" + currentDocument.getInternalName()).append("</dct:identifier>\r\n");
            dcatFile.append("\r\n");
            dcatFile.append("\t\t\t\t<dct:spatial rdf:resource=\"http://sws.geonames.org/3336903/\" />\r\n\t\t\t\t<dct:spatial rdf:resource=\"http://sws.geonames.org/3130717/\" />\r\n\t\t\t\t<dct:spatial rdf:resource=\"http://sws.geonames.org/3104469/\" />\r\n\t\t\t\t<dct:spatial rdf:resource=\"http://sws.geonames.org/3120935/\" />\r\n");
            dcatFile.append("\r\n");
            if (!(dataset == null || dataset.getDetailsData() == null || StringUtils.isEmptyString((String)dataset.getDetailsData().getStartUpPeriod()) && StringUtils.isEmptyString((String)dataset.getDetailsData().getEndPeriod()))) {
                dcatFile.append("<dcterms:valid rdf:parseType=\"Resource\">\r\n\t<rdf:type rdf:resource=\"http://purl.org/dc/terms/PeriodOfTime\" />\r\n");
                dcatFile.append("\t<rdfs:label xml:lang=\"");
                dcatFile.append(language).append("\">").append(StringEscapeUtils.escapeXml((String)R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)language, (String)"rdf.periodo.title")));
                dcatFile.append("</rdfs:label>\r\n");
                dcatFile.append("\t<rdfs:comment xml:lang=\"");
                dcatFile.append(language).append("\">").append(StringEscapeUtils.escapeXml((String)R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)language, (String)"rdf.periodo.descripcion")));
                dcatFile.append("</rdfs:comment>\r\n");
                dcatFile.append("\t<dcterms:date rdf:datatype=\"dcterms:W3CDTF\">");
                dcatFile.append(dataset.getDetailsData().getStartUpPeriod());
                dcatFile.append("</dcterms:date>\r\n");
                dcatFile.append("\t<dcterms:date rdf:datatype=\"dcterms:W3CDTF\">");
                dcatFile.append(dataset.getDetailsData().getEndPeriod());
                dcatFile.append("</dcterms:date>\r\n");
                dcatFile.append("</dcterms:valid>\r\n");
            }
            dcatFile.append("\t\t\t\t<foaf:homepage rdf:resource=\"").append(documentUrl).append("\" />\r\n");
            dcatFile.append("\t\t\t\t<dcat:keyword rdf:resource=\"").append(OPENDATA_URL).append("/taxonomy/types/").append(StringEscapeUtils.escapeXml((String)StringUtils.capitalizeAllFirstLetters((String)content.getTypo().getTypeOid()))).append("\" />\r\n");
            if (datasetSubjects.size() > 0) {
                for (Map.Entry entry : datasetSubjects.entrySet()) {
                    currentLanguage = (String)entry.getKey();
                    String datasetSubject = (String)entry.getValue();
                    dcatFile.append("\t\t\t\t<dcat:keyword xml:lang=\"").append(currentLanguage).append("\">").append(datasetSubject).append("</dcat:keyword>\r\n");
                }
                dcatFile.append("\r\n");
            }
            dcatFile.append("\t\t\t\t<void:Linkset rdf:about=\"#dataset2Geonames\">\r\n\t\t\t\t\t<dcterms:subject rdf:resource=\"http://dbpedia.org/resource/Location_%28geography%29\" />\r\n\t\t\t\t\t<void:linkPredicate rdf:resource=\"http://purl.org/dc/terms#spatial\" />\r\n\t\t\t\t\t<void:objectsTarget rdf:resource=\"#Geonames\" />\r\n\t\t\t\t\t<void:subjectsTarget rdf:resource=\"");
            dcatFile.append(OPENDATA_URL).append('/').append(contentAlias).append('/').append(content.getTypo().getTypeOid()).append('/').append(content.getInternalName()).append('/').append(currentDocument.getLanguage()).append('_').append(currentDocument.getInternalName()).append("\" />\r\n");
            dcatFile.append("\t\t\t\t\t<rdfs:comment xml:lang=\"").append(language).append("\">");
            dcatFile.append(StringEscapeUtils.escapeXml((String)R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)language, (String)"rdf.dataset2Geonames.descripcion")));
            dcatFile.append("</rdfs:comment>\r\n");
            dcatFile.append("\t\t\t\t\t<rdfs:label xml:lang=\"").append(language).append("\">");
            dcatFile.append(StringEscapeUtils.escapeXml((String)R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)language, (String)"rdf.dataset2Geonames.title")));
            dcatFile.append("</rdfs:label>\r\n");
            dcatFile.append("\t\t\t\t</void:Linkset>\r\n");
            if (datasetReferences.size() > 0) {
                for (Map.Entry entry : datasetReferences.entrySet()) {
                    currentLanguage = (String)entry.getKey();
                    String[] datasetReference = (String[])entry.getValue();
                    dcatFile.append("\t\t\t\t<dcterms:references rdf:parseType=\"Resource\">\r\n\t\t\t\t\t<rdf:type rdf:resource=\"http://xmlns.com/foaf/0.1/Document\" />\r\n\t\t\t\t\t<rdfs:label xml:lang=\"").append(currentLanguage).append("\">").append(datasetReference[0]).append("</rdfs:label>\r\n\t\t\t\t\t<foaf:homepage rdf:resource=\"").append(datasetReference[1]).append("\" />\r\n\t\t\t\t</dcterms:references>\r\n");
                }
                dcatFile.append("\r\n");
            }
            if (content.getLabels() != null && !content.getLabels().isEmpty()) {
                R01MStructureCatalog structureCatalog3 = null;
                R01MLabel label = null;
                R01MCatalogManagerAPI catalogAPI = new R01MCatalogManagerAPI();
                for (R01MStructureCatalog structureCatalog3 : content.getLabels()) {
                    try {
                        String labelValue = "";
                        label = catalogAPI.loadLabel(structureCatalog3.getOid(), false);
                        if (label != null && label.getStandardizedTerm("en") != null) {
                            labelValue = label.getStandardizedTerm("en").getValue();
                        } else if (label != null && label.getStandardizedTerm("es") != null) {
                            labelValue = label.getStandardizedTerm("es").getValue();
                            labelValue = labelValue.replaceAll("[\u00c0\u00c1\u00c4\u00e1\u00e0\u00e4]", "a").replaceAll("[\u00c8\u00c9\u00cb\u00e8\u00e9\u00eb]", "e").replaceAll("[\u00cc\u00cd\u00cf\u00ec\u00ed\u00ef]", "i").replaceAll("[\u00d2\u00d3\u00d6\u00f2\u00f3\u00f6]", "o").replaceAll("[\u00d9\u00da\u00dc\u00f9\u00fa\u00fc]", "u").replaceAll("[\u00d1\u00f1]", "n");
                        } else if (label != null && label.getStandardizedTerm("eu") != null) {
                            labelValue = label.getStandardizedTerm("eu").getValue();
                        }
                        if (StringUtils.isEmptyString((String)labelValue)) continue;
                        labelValue = labelValue.trim().replaceAll("[\\s]+", " ");
                        labelValue = StringUtils.capitalizeAllFirstLetters((String)labelValue);
                        labelValue = labelValue.replaceAll(" ", "_").replaceAll("[,+:]/", "").replaceAll("['\u00b4]", "_");
                        dcatFile.append("\t\t\t\t<dcterms:subject rdf:resource=\"").append(OPENDATA_URL).append("/taxonomy/labels/").append(StringEscapeUtils.escapeXml((String)StringUtils.capitalizeAllFirstLetters((String)labelValue.trim()).replaceAll(" ", "_"))).append("\" />\r\n");
                    }
                    catch (R01MCatalogException ex1) {
                        R01FLog.to((String)"r01k.index").warning("Excepci\u00f3n a la hora de recuperar la etiqueta");
                    }
                }
                dcatFile.append("\r\n");
            }
            if (!(mainDataset == null || mainDataset.getDetailsData() == null || StringUtils.isEmptyString((String)mainDataset.getDetailsData().getStartUpPeriod()) && StringUtils.isEmptyString((String)mainDataset.getDetailsData().getEndPeriod()))) {
                dcatFile.append("\t\t\t\t<dcterms:valid rdf:parseType=\"Resource\">\r\n\t\t\t\t\t<rdf:type rdf:resource=\"http://purl.org/dc/terms/PeriodOfTime\" />\r\n");
                dcatFile.append("\t\t\t\t\t<rdfs:label xml:lang=\"").append(language).append("\">");
                dcatFile.append(StringEscapeUtils.escapeXml((String)R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)language, (String)"rdf.periodo.title")));
                dcatFile.append("</rdfs:label>\r\n");
                dcatFile.append("\t\t\t\t\t<rdfs:comment xml:lang=\"").append(language).append("\">");
                dcatFile.append(StringEscapeUtils.escapeXml((String)R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)language, (String)"rdf.periodo.descripcion")));
                dcatFile.append("</rdfs:comment>\r\n");
                if (!StringUtils.isEmptyString((String)mainDataset.getDetailsData().getStartUpPeriod())) {
                    dcatFile.append("\t\t\t\t\t<dcterms:date rdf:datatype=\"dcterms:W3CDTF\">").append(mainDataset.getDetailsData().getStartUpPeriod()).append("</dcterms:date>\r\n");
                }
                if (!StringUtils.isEmptyString((String)mainDataset.getDetailsData().getEndPeriod())) {
                    dcatFile.append("\t\t\t\t\t<dcterms:date rdf:datatype=\"dcterms:W3CDTF\">").append(mainDataset.getDetailsData().getEndPeriod()).append("</dcterms:date>\r\n");
                }
                dcatFile.append("\t\t\t\t</dcterms:valid>\r\n");
                dcatFile.append("\r\n");
            }
            if (dataset != null && dataset.getDatasetFiles() != null && !dataset.getDatasetFiles().isEmpty()) {
                R01POpendataDatasetFile datasetFile3 = null;
                for (R01POpendataDatasetFile datasetFile3 : dataset.getDatasetFiles()) {
                    dcatFile.append("\t\t\t\t<dcterms:references rdf:parseType=\"Resource\">\r\n\t\t\t\t\t<rdf:type rdf:resource=\"http://xmlns.com/foaf/0.1/Document\" />\r\n\t\t\t\t\t<rdfs:label xml:lang=\"").append(language).append("\">");
                    dcatFile.append(StringEscapeUtils.escapeXml((String)datasetFile3.getText()));
                    dcatFile.append("</rdfs:label>\r\n\t\t\t\t\t<foaf:homepage rdf:resource=\"").append(StringEscapeUtils.escapeXml((String)datasetFile3.getContentRelativePath())).append("\" />\r\n");
                    dcatFile.append("\t\t\t\t</dcterms:references>\r\n");
                }
            }
            if (datasetContentsRelativePath.size() > 0 && datasetContentsRelativePath.get(language) != null) {
                dcatFile.append("\t\t\t\t<dcat:distribution>\r\n");
                dcatFile.append("\t\t\t\t\t<dcat:Distribution>\r\n");
                if (datasetContentsRelativePath.size() > 0 && datasetContentsRelativePath.get(language) != null) {
                    String datasetContentRelativePath = (String)datasetContentsRelativePath.get(language);
                    String datasetType = (String)datasetTypes.get(language);
                    String datasetMimeType = (String)datasetMimeTypes.get(language);
                    String datasetTypeSize = (String)datasetTypesSize.get(language);
                    dcatFile.append("\t\t\t\t\t\t<dcterms:hasFormat>\r\n\t\t\t\t\t\t\t<dcterms:FileFormat rdf:about=\"").append(datasetContentRelativePath).append("\">\r\n");
                    if (datasetMimeType != null || datasetType != null) {
                        dcatFile.append("\t\t\t\t\t\t\t\t<dcterms:format>\r\n\t\t\t\t\t\t\t\t\t<dcterms:IMT>\r\n");
                        if (datasetMimeType != null) {
                            dcatFile.append("\t\t\t\t\t\t\t\t\t\t<rdf:value>").append(datasetMimeType).append("</rdf:value>\r\n");
                        }
                        if (datasetType != null) {
                            dcatFile.append("\t\t\t\t\t\t\t\t\t\t<rdfs:label>").append(datasetType).append("</rdfs:label>\r\n");
                        }
                        dcatFile.append("\t\t\t\t\t\t\t\t\t</dcterms:IMT>\r\n\t\t\t\t\t\t\t\t</dcterms:format>\r\n");
                    }
                    if (datasetTypeSize != null) {
                        dcatFile.append("\t\t\t\t\t\t\t\t<dcterms:extent>\r\n");
                        dcatFile.append("\t\t\t\t\t\t\t\t\t<dcterms:SizeOrDuration>\r\n");
                        dcatFile.append("\t\t\t\t\t\t\t\t\t\t<rdf:value>").append(datasetTypeSize).append("</rdf:value>\r\n");
                        dcatFile.append("\t\t\t\t\t\t\t\t\t\t<rdfs:label>").append(StringEscapeUtils.escapeXml((String)R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)language, (String)"rdf.fichero.tamanio.descripcion"))).append("</rdfs:label>\r\n");
                        dcatFile.append("\t\t\t\t\t\t\t\t\t</dcterms:SizeOrDuration>\r\n");
                        dcatFile.append("\t\t\t\t\t\t\t\t</dcterms:extent>\r\n");
                    }
                    if (datasetType != null && datasetType.toLowerCase().indexOf("csv") > 0) {
                        dcatFile.append("\t\t\t\t\t\t\t\t<rdfs:comment xml:lang=\"en\">Comma Separated Values</rdfs:comment>");
                    } else if (datasetType != null) {
                        dcatFile.append("\t\t\t\t\t\t\t\t<rdfs:comment xml:lang=\"").append(language).append("\">");
                        dcatFile.append(StringEscapeUtils.escapeXml((String)MessageFormat.format(R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)language, (String)"rdf.fichero.formato.descripcion"), datasetType)));
                        dcatFile.append("</rdfs:comment>\r\n");
                    }
                    dcatFile.append("\t\t\t\t\t\t\t</dcterms:FileFormat>\r\n\t\t\t\t\t\t</dcterms:hasFormat>\r\n");
                    dcatFile.append("\t\t\t\t\t\t<dcat:accessURL>\r\n\t\t\t\t\t\t\t<void:TechnicalFeature  rdf:about=\"").append(datasetContentRelativePath).append("\">\r\n");
                    if (datasetMimeType != null || datasetType != null) {
                        dcatFile.append("\t\t\t\t\t\t\t\t<dcterms:format>\r\n\t\t\t\t\t\t\t\t\t<dcterms:IMT>\r\n");
                        if (datasetMimeType != null) {
                            dcatFile.append("\t\t\t\t\t\t\t\t\t\t<rdf:value>").append(datasetMimeType).append("</rdf:value>\r\n");
                        }
                        if (datasetType != null) {
                            dcatFile.append("\t\t\t\t\t\t\t\t\t\t<rdfs:label>").append(datasetType).append("</rdfs:label>\r\n");
                        }
                        dcatFile.append("\t\t\t\t\t\t\t\t\t</dcterms:IMT>\r\n\t\t\t\t\t\t\t</dcterms:format>\r\n");
                    }
                    if (datasetTypeSize != null) {
                        dcatFile.append("\t\t\t\t\t\t\t<dcterms:extent>\r\n\t\t\t\t\t\t\t\t<dcterms:SizeOrDuration>\r\n");
                        dcatFile.append("\t\t\t\t\t\t\t\t\t<rdf:value>").append(datasetTypeSize).append("</rdf:value>\r\n");
                        dcatFile.append("\t\t\t\t\t\t\t\t\t<rdfs:label>").append(StringEscapeUtils.escapeXml((String)R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)language, (String)"rdf.fichero.tamanio.descripcion"))).append("</rdfs:label>\r\n");
                        dcatFile.append("\t\t\t\t\t\t\t\t</dcterms:SizeOrDuration>\r\n\t\t\t\t\t\t\t</dcterms:extent>\r\n");
                    }
                    if (datasetType != null && datasetType.toLowerCase().indexOf("csv") > 0) {
                        dcatFile.append("\t\t\t\t\t\t\t<rdfs:comment xml:lang=\"en\">Comma Separated Values</rdfs:comment>");
                    } else if (datasetType != null) {
                        dcatFile.append("\t\t\t\t\t\t\t<rdfs:comment xml:lang=\"").append(language).append("\">").append(StringEscapeUtils.escapeXml((String)MessageFormat.format(R01MUtils.getLiteral((String)R01MConstants.API_APPCODE, (String)"indexerResources", (String)language, (String)"rdf.fichero.formato.descripcion"), datasetType)));
                        dcatFile.append("</rdfs:comment>\r\n");
                    }
                    dcatFile.append("\t\t\t\t\t\t\t</void:TechnicalFeature>\r\n\t\t\t\t\t\t</dcat:accessURL>\r\n");
                    dcatFile.append("\r\n");
                }
                dcatFile.append("\t\t\t\t\t</dcat:Distribution>\r\n");
                dcatFile.append("\t\t\t\t</dcat:distribution>\r\n");
            }
            dcatFile.append("\t\t\t</dcat:Dataset>\r\n");
        }
        dcatFile.append("\t\t</dcat:dataset>\r\n");
        dcatFile.append("\t</dcat:Catalog>\r\n");
        dcatFile.append("</rdf:RDF>");
        return dcatFile;
    }

    private StringBuffer _decorateDCAT(StringBuffer rdf) {
        Map comboMap = null;
        StringBuffer finalDCAT = new StringBuffer("");
        try {
            comboMap = this._obtainComboValues();
        }
        catch (SQLException ex) {
            ex.printStackTrace(System.out);
        }
        Pattern p = Pattern.compile("\\$\\[([^\\$\\[\\]\\$]*)\\]\\$");
        Matcher m = p.matcher(rdf);
        while (m.find()) {
            if (comboMap.containsKey(m.group(1))) {
                m.appendReplacement(finalDCAT, (String)comboMap.get(m.group(1)));
                continue;
            }
            m.appendReplacement(finalDCAT, "");
        }
        m.appendTail(finalDCAT);
        return finalDCAT;
    }

    private Map _obtainComboValues() throws SQLException {
        String[] cols = new String[]{"R01D21T01.PK_21,R01D21T01.NOMBRE_21,R01D21T01.HTML_21,R01D21T01.IDIOMA_COMBO_21"};
        String[] tables = new String[]{"R01D21T01"};
        String where = "COMBO_ID_21 IN (" + COMBOLIST_OID + ")";
        ArrayList params = new ArrayList(3);
        DBManager dbManager = new DBManager(R01MConstants.CONTENTMANAGER_APPCODE, "contentQueryConnection");
        List rows = dbManager.executeSelect(CollectionUtils.strArrayToList((String[])cols), CollectionUtils.strArrayToList((String[])tables), params, where, null, false, false);
        if (rows == null) {
            return null;
        }
        LinkedHashMap<String, String> comboValues = new LinkedHashMap<String, String>(rows.size());
        Map aux = null;
        for (int i = 0; i < rows.size(); ++i) {
            aux = (Map)rows.get(i);
            comboValues.put(aux.get("PK_21") + "_" + aux.get("IDIOMA_COMBO_21"), StringUtils.encodeUTF((String)aux.get("NOMBRE_21").toString()));
        }
        return comboValues;
    }

    private void _traceIndex(String objOid, int objType, int action, String errorMsg) {
        if (objType == 1) {
            switch (action) {
                case 1: {
                    R01KTraceIndexHelper.execDcatTraceIndexInit((String)objOid);
                    break;
                }
                case 2: {
                    R01KTraceIndexHelper.execDcatTraceIndexEndErr((String)objOid, (String)errorMsg);
                    break;
                }
                case 3: {
                    R01KTraceIndexHelper.execDcatTraceIndexEnd((String)objOid);
                    break;
                }
                case 4: {
                    R01KTraceIndexHelper.execDcatCheckIndexOK((String)objOid);
                    break;
                }
            }
        } else if (objType == 0) {
            try {
                R01MContent theContent = R01MClientFactory.getContentModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext()).loadContent(objOid);
                if (theContent.getDocuments() != null && !theContent.getDocuments().isEmpty()) {
                    for (String documentOid : theContent.getDocuments().keySet()) {
                        switch (action) {
                            case 1: {
                                R01KTraceIndexHelper.execDcatTraceIndexInit((String)documentOid);
                                break;
                            }
                            case 2: {
                                R01KTraceIndexHelper.execDcatTraceIndexEndErr((String)documentOid, (String)errorMsg);
                                break;
                            }
                            case 3: {
                                R01KTraceIndexHelper.execDcatTraceIndexEnd((String)documentOid);
                                break;
                            }
                            case 4: {
                                R01KTraceIndexHelper.execDcatCheckIndexOK((String)documentOid);
                                break;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }
}

