/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01k.searchorchestrator.indexer.indexers;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.net.HttpClient;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.NumberUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01k.searchorchestrator.indexer.R01KSearchOrchestratorIndexer;
import com.ejie.r01k.searchorchestrator.indexer.indexers.R01KIDXProcessor;
import com.ejie.r01k.searchorchestrator.indexer.indexers.R01KSearchEngineIndexer;
import com.ejie.r01k.traceindex.R01KTraceIndexHelper;
import com.ejie.r01m.config.objects.searchengine.R01MSearchSource;
import com.ejie.r01m.config.objects.searchengine.R01MSearchSourceIndexer;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MMetaDataStorageConfig;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MSearchMetaDataStorageConfig;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MSearchIndexerException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.contentmodel.R01MDocumentPublicationTarget;
import com.ejie.r01m.objects.portalmodel.R01MPage;
import com.ejie.r01m.objects.searchengine.indexer.R01MBaseIndexableObject;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableContent;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableDataFile;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableDocument;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableDocumentLinkedData;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableLabelTerm;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableMetaData;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexablePortalPage;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexablePublicationInfo;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableStructureCatalog;
import com.ejie.r01m.objects.searchengine.indexer.R01MRispDocument;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MPortalManagerAPI;
import com.ejie.r01m.services.R01MPublisherConfigAPI;
import com.ejie.r01m.services.R01MSearchMetaDataStorageConfigAPI;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MDateUtils;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class R01KAutonomyIndexer
implements R01KSearchEngineIndexer {
    private static transient String REG_EX = "(CONTENT|DOCUMENT|DOCUMENT_DATAFILES|DOCUMENT_MAINDATAFILE|METADATA)\\.(.*)";
    private static final String LOG_TYPE_ID = "r01k.autonomyindex";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01k.autonomyindex").intValue() != Level.OFF.intValue();
    private static final String DEFAULT_IDX_NAME = XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"indexerContents/defaultIdxFile", (String)"metadata.idx");
    public static final String TYPOLOGY_GUIDE_INDEX_FILE = XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"indexerContents/filesToIndexGuides/typologyGuides");
    public static final String CATALOG_GUIDE_INDEX_FILE = XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"indexerContents/filesToIndexGuides/catalogGuides");
    public static final String DEFAULT_INDEX_EXTENSSION = XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"indexerContents/idxExtenssion", (String)"idx");
    private static final int indexerType = R01KSearchEngineIndexer.DOCUMENT_TYPE_INDEXER;
    public static final String IDOLMETAS_URI_NODE1 = XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"autonomyIndexService/queryMetasUri1");
    public static final String IDOLMETAS_URI_NODE2 = XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"autonomyIndexService/queryMetasUri2");
    public static final String IDOLFULL_URI_NODE1 = XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"autonomyIndexService/queryFullUri1");
    public static final String IDOLFULL_URI_NODE2 = XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"autonomyIndexService/queryFullUri2");
    private transient Properties _props = null;
    private transient String _nativeDateFormat = "seconds";
    private static R01MSearchMetaDataStorageConfigAPI typoStorageConfigAPI = R01MClientFactory.getSearchMetaDataStorageConfigAPI();
    private static R01MPublisherConfigAPI publisherAPI = R01MClientFactory.getPublisherConfigAPI();
    private static Map memberMappingsCache = new HashMap();

    public R01KAutonomyIndexer() {
    }

    public R01KAutonomyIndexer(Properties props) {
        this();
        this._props = props;
    }

    @Override
    public void setNativeDateFormat(String dateFormat) {
        this._nativeDateFormat = dateFormat;
    }

    @Override
    public String getNativeDateFormat() {
        return this._nativeDateFormat;
    }

    @Override
    public void setProperties(Properties props) {
        this._props = props;
    }

    @Override
    public Properties getProperties() {
        return this._props;
    }

    @Override
    public int getIndexerType() {
        return indexerType;
    }

    @Override
    public void index(String systemId, R01MBaseIndexableObject idxObj, int objType, List<String> metadataFileNames, Properties props) throws R01MSearchIndexerException {
        R01FLog.to((String)LOG_TYPE_ID).info(">>>>>>>>>>>>>> Indexando el objeto " + idxObj.getOid() + " en AUTONOMY ........");
        if (idxObj == null) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Se ha intentado indexar un objeto NULO!!!");
            return;
        }
        if (objType == 0 || objType == 1 || objType == 4) {
            Map<String, R01MMetaDataStorageConfig> md;
            String traceObjOid;
            R01MIndexableContent idxCont = (R01MIndexableContent)idxObj;
            switch (objType) {
                case 0: 
                case 1: {
                    if (props != null && props.containsKey("objectOid")) {
                        traceObjOid = props.getProperty("objectOid").toString();
                        break;
                    }
                    traceObjOid = idxObj.getOid();
                    break;
                }
                case 4: {
                    traceObjOid = idxObj.getOid();
                    break;
                }
                default: {
                    throw new R01MSearchIndexerException("El tipo de objeto " + objType + " NO es valido para su indexacion en BD");
                }
            }
            if (idxCont.getStorage() == null || idxCont.getTypo() == null) {
                String errorMsg = "Se ha intentado indexar un contenido que no tiene almacenamiento o tipolog\u00eda!!";
                R01FLog.to((String)LOG_TYPE_ID).severe(errorMsg);
                if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                    R01KAutonomyIndexer._traceIndex(traceObjOid, objType, 1, "", "");
                    R01KAutonomyIndexer._traceIndex(traceObjOid, objType, 21, errorMsg, "");
                    R01KAutonomyIndexer._traceIndex(traceObjOid, objType, 22, errorMsg, "");
                }
                return;
            }
            String webPath = null;
            if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                webPath = idxCont.getTypo().getType().getOid() + "/" + idxCont.getInternalName() + "/";
                if (objType == 1) {
                    webPath = webPath + idxCont.getDocument((String)props.get("objectOid")).getLanguage() + "_" + idxCont.getDocument((String)props.get("objectOid")).getInternalName() + "/";
                }
                R01KAutonomyIndexer._traceIndex(traceObjOid, objType, 1, "", webPath);
            }
            if (idxCont.getStorage() == null || idxCont.getStorage().getServer() == null || idxCont.getStorage().getServer().getOid() == null || idxCont.getStorage().getDataStore() == null || idxCont.getStorage().getDataStore().getOid() == null) {
                String errorMsg = "No se puede obtener el fichero .idx para autonomy ya que el contenido indexable suministrado NO contiene informaci\u00f3n de almacenamiento suficiente: al menos han de llegar el servidor y dataStore!!!";
                if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                    R01KAutonomyIndexer._traceIndex(traceObjOid, objType, 21, errorMsg, webPath);
                    R01KAutonomyIndexer._traceIndex(traceObjOid, objType, 22, errorMsg, webPath);
                }
                throw new R01MSearchIndexerException(errorMsg);
            }
            Properties autonomyMappings = R01KAutonomyIndexer._obtainAutonomyMemberMappingInfo(idxCont.getStorage().getServer().getOid(), idxCont.getStorage().getDataStore().getOid());
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("AUTONOMYINDEXER [" + traceObjOid + "]> Componer los elementos del fichero idx para el objeto " + traceObjOid);
            }
            if (idxCont.getDocuments() == null) {
                R01FLog.to((String)LOG_TYPE_ID).warning("AUTONOMYINDEXER [" + traceObjOid + "]> El contenido no tiene documentos, as\u00ed que no se genera fichero de indexacion en autonomy");
                return;
            }
            try {
                md = this._getMetadataStorageConfigMap(idxCont);
            }
            catch (R01MConfigLoadException clEx) {
                String errorMsg = "Error al cargar la configuraci\u00f3n de metadatos para el storage del contenido " + idxCont.getOid() + ": " + clEx.getMessage();
                R01FLog.to((String)LOG_TYPE_ID).severe(errorMsg);
                if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                    R01KAutonomyIndexer._traceIndex(traceObjOid, objType, 21, errorMsg, webPath);
                    R01KAutonomyIndexer._traceIndex(traceObjOid, objType, 22, errorMsg, webPath);
                }
                return;
            }
            ArrayList<Object> documentsToIndex = new ArrayList<Object>();
            if (objType == 1) {
                documentsToIndex.add(idxCont.getDocument((String)props.get("objectOid")));
            } else if (objType == 0 || objType == 4) {
                documentsToIndex.addAll(idxCont.getDocuments().values());
            }
            HashMap<String, StringBuffer> idxFilesLines = new HashMap<String, StringBuffer>();
            for (R01MIndexableDocument r01MIndexableDocument : documentsToIndex) {
                block56: {
                    if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                        webPath = webPath + r01MIndexableDocument.getLanguage() + "_" + r01MIndexableDocument.getInternalName() + "/";
                    }
                    for (Map.Entry<Object, Object> me : autonomyMappings.entrySet()) {
                        Pattern pp;
                        Matcher mm;
                        boolean valid;
                        String currPropName = (String)me.getKey();
                        String currPropValue = (String)me.getValue();
                        if (DEBUG) {
                            R01FLog.to((String)LOG_TYPE_ID).info("\telemento de la configuracion de searchMetaDataStorage.xml <" + currPropName + ">" + (currPropValue != null ? currPropValue : "") + "</" + currPropName + ">");
                        }
                        if (valid = (mm = (pp = Pattern.compile("autonomy.(DRE[^_]*)(_(metaData|guides))?")).matcher(currPropName)).find()) {
                            String dreField = mm.group(1);
                            String dreSubField = mm.group(3);
                            if (dreSubField != null) {
                                if (dreSubField.equalsIgnoreCase("metaData")) {
                                    this._mergeBufferStringMaps(idxFilesLines, this._composeMetaDataIDXLines(dreField, idxCont, r01MIndexableDocument, md, metadataFileNames));
                                    continue;
                                }
                                if (!dreSubField.equalsIgnoreCase("guides")) continue;
                                this._mergeBufferStringMaps(idxFilesLines, this._composeGuidesIDXLines(dreField, idxCont, metadataFileNames));
                                continue;
                            }
                            this._mergeBufferStringMaps(idxFilesLines, this._composeMiscIDXLines(dreField, currPropValue, objType, idxCont, r01MIndexableDocument, metadataFileNames));
                            continue;
                        }
                        R01FLog.to((String)LOG_TYPE_ID).severe("AUTONOMYINDEXER [" + traceObjOid + "] Hay un error en las lineas del fichero IDX definidas en el fichero searchMetaDataStorage.xml: La propiedad debe seguir el patr\u00f3n autonomy.DRE[fieldName](_[subFieldName])opt");
                    }
                    if (this._props == null || this._props.get("processorClass") == null) {
                        String theContext = R01MSearchEngineUtils.obtainContext((String)XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"searchEngine/defaultSearchEngineContext"), null);
                        Map searchSources = null;
                        try {
                            searchSources = R01MClientFactory.getSearchEngineConfigAPI().getSearchEngineConfig().getSearchSources(theContext);
                        }
                        catch (R01MConfigLoadException cfgLoadEx) {
                            R01FLog.to((String)LOG_TYPE_ID).warning("AUTONOMYINDEXER [" + traceObjOid + "] > Error al recoger la configuraci\u00f3n del motor de b\u00fasqueda para recoger los indexadores comunes. Error:" + cfgLoadEx.getMessage());
                        }
                        for (R01MSearchSource currentSearchSource : searchSources.values()) {
                            if (currentSearchSource.getIndexers() == null) continue;
                            for (R01MSearchSourceIndexer currentIndexer : currentSearchSource.getIndexers()) {
                                if (!currentIndexer.getImplClassName().equalsIgnoreCase("com.ejie.r01k.searchorchestrator.indexer.indexers.R01KAutonomyIndexer") || currentIndexer.getProperties() == null) continue;
                                Properties properties = new Properties();
                                properties.clear();
                                properties.putAll((Map<?, ?>)currentIndexer.getProperties());
                                this.setProperties(properties);
                                break;
                            }
                            if (this._props == null) continue;
                            break;
                        }
                    }
                    StringBuffer idxLinesBuffer = null;
                    if (!idxFilesLines.isEmpty() && this._props != null && this._props.get("processorClass") != null) {
                        try {
                            String documentPublishedRepoOid;
                            R01KIDXProcessor processor;
                            block57: {
                                processor = (R01KIDXProcessor)ReflectionUtils.getObjectInstance((String)((String)this._props.get("processorClass")));
                                processor.setProperties(this._props);
                                processor.removeIndexData(idxCont, "idx");
                                processor.processIndexData(idxCont, r01MIndexableDocument, idxFilesLines);
                                if (!XMLProperties.getBoolean((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"autonomyIndexService/activeDirectIndex", (boolean)true) || R01MConstants.TYPES_EXCLUDED_TO_INDEX.contains(idxCont.getTypo().getType().getOid())) break block56;
                                documentPublishedRepoOid = null;
                                try {
                                    R01MPortalManagerAPI portalAPI;
                                    R01MPage page;
                                    if (objType == 1 || objType == 0) {
                                        List docPublishedRepo = null;
                                        try {
                                            docPublishedRepo = R01MClientFactory.getContentModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext()).getDocumentRepositoriesPublished(r01MIndexableDocument.getOid());
                                        }
                                        catch (R01MConfigLoadException e) {
                                            // empty catch block
                                        }
                                        if (docPublishedRepo != null && !docPublishedRepo.isEmpty()) {
                                            documentPublishedRepoOid = (String)docPublishedRepo.get(0);
                                        }
                                        break block57;
                                    }
                                    if (objType == 4 && (page = (portalAPI = R01MClientFactory.getPortalModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext(), null)).loadPortalPage(idxObj.getOid())) != null && page.getPublishedRepository() != null) {
                                        documentPublishedRepoOid = page.getPublishedRepository();
                                    }
                                }
                                catch (R01MSecurityException secEx) {
                                    secEx.printStackTrace();
                                    R01FLog.to((String)LOG_TYPE_ID).severe("AUTONOMYINDEXER [" + traceObjOid + "] Error al comprobar si el documento esta publicado para lanzar la indexacion directa de autonomy: " + secEx.getMessage());
                                }
                                catch (R01MContentModelException cmEx) {
                                    cmEx.printStackTrace();
                                    R01FLog.to((String)LOG_TYPE_ID).severe("AUTONOMYINDEXER [" + traceObjOid + "] Error al comprobar si el documento esta publicado para lanzar la indexacion directa de autonomy: " + cmEx.getMessage());
                                }
                                catch (R01MPortalModelException pmEx) {
                                    pmEx.printStackTrace();
                                    R01FLog.to((String)LOG_TYPE_ID).severe("AUTONOMYINDEXER [" + traceObjOid + "] Error al comprobar si la pagina esta publicada para lanzar la indexacion directa de autonomy: " + pmEx.getMessage());
                                }
                            }
                            if (StringUtils.isEmptyString(documentPublishedRepoOid)) break block56;
                            idxLinesBuffer = new StringBuffer();
                            Iterator<StringBuffer> itLines = idxFilesLines.values().iterator();
                            while (itLines.hasNext()) {
                                idxLinesBuffer.append(itLines.next());
                            }
                            if (metadataFileNames != null && !metadataFileNames.isEmpty()) {
                                idxLinesBuffer.append(processor.loadIndexData(idxCont, r01MIndexableDocument, metadataFileNames, false));
                            }
                            if (idxLinesBuffer == null) break block56;
                            StringBuffer gendataUrl = new StringBuffer();
                            String gendataDomainPrefix = XMLProperties.getProperty((String)R01MConstants.INTERNALAPI_APPCODE, (String)"autonomy/gendataPrefixInAutonomy/default", (String)"http://www.euskadi.net");
                            if (StringUtils.isEmptyString((String)documentPublishedRepoOid)) break block56;
                            gendataDomainPrefix = XMLProperties.getProperty((String)R01MConstants.INTERNALAPI_APPCODE, (String)("autonomy/gendataPrefixInAutonomy/" + documentPublishedRepoOid), (String)"http://www.euskadi.net");
                            gendataUrl.append(gendataDomainPrefix);
                            String pubBasePath = "";
                            try {
                                if (objType == 4) {
                                    String[] pubBasePathParts = r01MIndexableDocument.getWorkAreaRelativePath().split("/");
                                    if (pubBasePathParts.length > 0) {
                                        for (int i = 1; i < pubBasePathParts.length - 1; ++i) {
                                            if (StringUtils.isEmptyString((String)pubBasePathParts[i])) continue;
                                            pubBasePath = pubBasePath + pubBasePathParts[i] + '/';
                                            if (i <= 2) continue;
                                            gendataUrl.append('/').append(pubBasePathParts[i]);
                                        }
                                    }
                                    gendataUrl.append('/').append(XMLProperties.getProperty((String)R01MConstants.INTERNALAPI_APPCODE, (String)"autonomy/autonomyIndexService/gendataFileName", (String)"r01_gendata.txt"));
                                    pubBasePath = pubBasePath + XMLProperties.getProperty((String)R01MConstants.INTERNALAPI_APPCODE, (String)"autonomy/autonomyIndexService/gendataFileName", (String)"r01_gendata.txt");
                                    pubBasePath = publisherAPI.getLogicalPublicationConfig(documentPublishedRepoOid).getPortalBasePath() + pubBasePath;
                                } else {
                                    pubBasePath = r01MIndexableDocument.getWorkAreaRelativePath() + '/' + XMLProperties.getProperty((String)R01MConstants.INTERNALAPI_APPCODE, (String)"autonomy/autonomyIndexService/gendataFileName", (String)"r01_gendata.txt");
                                    if (!pubBasePath.startsWith("/contenidos/")) {
                                        gendataUrl.append("/contenidos/");
                                    }
                                    gendataUrl.append(pubBasePath);
                                    pubBasePath = publisherAPI.getLogicalPublicationConfig(documentPublishedRepoOid).getContentBasePath() + "/html/" + pubBasePath;
                                }
                            }
                            catch (R01MConfigLoadException e) {
                                e.printStackTrace();
                            }
                            pubBasePath = "#DREFIELD DREFULLFILENAME=\"" + pubBasePath + "\"\n";
                            idxLinesBuffer.insert(0, pubBasePath);
                            new R01KSearchOrchestratorIndexer().injectDataForIndexInAutonomy(idxCont.getOid(), r01MIndexableDocument.getOid(), 0, idxLinesBuffer.toString(), gendataUrl.toString(), documentPublishedRepoOid);
                            if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                                R01KTraceIndexHelper.execAutonomyDREReference((String)r01MIndexableDocument.getOid(), (String)gendataUrl.toString());
                            }
                        }
                        catch (ReflectionException refEx) {
                            refEx.printStackTrace();
                            R01FLog.to((String)LOG_TYPE_ID).severe("[" + traceObjOid + "]Error al procesar el idx de autonomy: " + refEx.getMessage());
                        }
                    }
                }
                idxFilesLines.clear();
                if (!R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) continue;
                R01KAutonomyIndexer._traceIndex(traceObjOid, objType, 3, "", webPath);
            }
        } else {
            R01FLog.to((String)LOG_TYPE_ID).severe("AUTONOMYINDEXER > NO se puede indexar un objeto tipo " + R01MConstants.OBJECT_DESCS[objType]);
        }
    }

    @Override
    public void unIndex(String systemId, String objectOid, int objectType, boolean traceIndex) throws R01MSearchIndexerException {
        if (objectType != 1 && objectType != 0 && this._props != null && this._props.get("processorClass") != null) {
            R01MIndexablePortalPage idxCont = null;
            try {
                if (objectType == 0) {
                    if (R01MClientFactory.getContentModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext()).checkContentExistence(objectOid)) {
                        idxCont = R01MClientFactory.getContentModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext()).getIndexableContent(objectOid);
                    }
                } else if (objectType == 4) {
                    idxCont = R01MClientFactory.getPortalModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext(), null).preparePageToBeIndexed(objectOid);
                }
            }
            catch (R01MSecurityException secExc) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("unIndex >> No se puede acceder al gestor de contenidos. Error:" + secExc.getMessage() + "\r\n");
                }
                return;
            }
            catch (R01MContentModelException cmExc) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("unIndex >> Error al cargar el contenido de oid " + objectOid + ". Error:" + cmExc.getMessage() + "\r\n");
                }
                return;
            }
            catch (R01MPortalModelException pmExc) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("unIndex >> Error al cargar la pagina de portal de oid " + objectOid + ". Error:" + pmExc.getMessage() + "\r\n");
                }
                return;
            }
            if (idxCont == null) {
                R01FLog.to((String)LOG_TYPE_ID).warning("AUTONOMYINDEXER > No existe el contenido, as\u00ed que no se desindexan ficheros del autonomy");
                return;
            }
            if (idxCont.getDocuments() == null || idxCont.getDocuments().isEmpty()) {
                R01FLog.to((String)LOG_TYPE_ID).warning("AUTONOMYINDEXER > El contenido no tiene documentos, as\u00ed que no se desindexan ficheros del autonomy");
                return;
            }
            if (idxCont.getStorage() == null || idxCont.getStorage().getServer() == null || idxCont.getStorage().getServer().getOid() == null || idxCont.getStorage().getDataStore() == null || idxCont.getStorage().getDataStore().getOid() == null) {
                throw new R01MSearchIndexerException("No se puede obtener el fichero .idx para autonomy ya que el contenido indexable suministrado NO contiene informaci\u00f3n de almacenamiento suficiente: al menos han de llegar el servidor y dataStore!!!");
            }
            Properties autonomyMappings = R01KAutonomyIndexer._obtainAutonomyMemberMappingInfo(idxCont.getStorage().getServer().getOid(), idxCont.getStorage().getDataStore().getOid());
            R01MSearchMetaDataStorageConfig mdStrgCfg = null;
            try {
                mdStrgCfg = typoStorageConfigAPI.getSearchMetaDataStorageConfig(idxCont.getStorage().getServer().getOid(), idxCont.getStorage().getDataStore().getOid());
            }
            catch (R01MConfigLoadException clEx) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("Al desindexar el objeto de OID: " + (objectOid == null ? " [null] " : objectOid) + " de tipo " + (objectType == 0 ? "contenido" : (objectType == 4 ? "p\u00e1gina de portal" : "[tipo no reconocido]: " + Integer.toString(objectType))) + ". Error al cargar la configuracion de metadatos: " + clEx.getMessage());
                }
                return;
            }
            Map md = mdStrgCfg.getTypeSearchMetaDataStorageCfgs(idxCont.getTypo().getCluster() != null ? idxCont.getTypo().getCluster().getOid() : null, idxCont.getTypo().getFamily() != null ? idxCont.getTypo().getFamily().getOid() : null, idxCont.getTypo().getType() != null ? idxCont.getTypo().getType().getOid() : null);
            if (md == null) {
                R01FLog.to((String)LOG_TYPE_ID).warning("NO se ha encontrado informaci\u00f3n sobre los metaDatos para el tipo cluster:familia:tipo=" + idxCont.getTypo().getCluster().getOid() + ":" + idxCont.getTypo().getFamily().getOid() + ":" + idxCont.getTypo().getType().getOid() + ". REVISA EL FICHERO searchMetaDataStorage.xml");
            }
            String currPropName = null;
            String currPropValue = null;
            String basePath = "";
            if (objectType == 4) {
                String portal = idxCont == null || idxCont.getInternalName() == null ? "  [InternalName del contenido es null] " : idxCont.getInternalName().substring(0, idxCont.getInternalName().indexOf("-"));
                basePath = basePath + "/" + portal + "/html/pages/data/" + (idxCont == null || idxCont.getInternalName() == null ? "  [InternalName del contenido es null] " : idxCont.getInternalName());
            } else if (objectType == 0) {
                basePath = basePath + "/" + (idxCont == null || idxCont.getTypo() == null || idxCont.getTypo().getType() == null ? " [typo es null] " : idxCont.getTypo().getType().getOid()) + "/" + (idxCont == null || idxCont.getInternalName() == null ? " [name es null] " : idxCont.getInternalName());
            }
            String idxRelativePath = XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"relativeIndexPath/contents", (String)"/r01Index/");
            ArrayList<String> filesToDelete = new ArrayList<String>();
            for (R01MIndexableDocument currIdxDoc : idxCont.getDocuments().values()) {
                filesToDelete.add(StringUtils.isEmptyString((String)basePath) ? " [basePath vacio o nulo] " : basePath + (currIdxDoc != null ? "" : " [documento es null] - ") + "/" + (currIdxDoc == null || currIdxDoc.getInternalName() == null ? " [InternalName del documento es null] " : currIdxDoc.getLanguage() + "_" + currIdxDoc.getInternalName()) + idxRelativePath + DEFAULT_IDX_NAME);
                filesToDelete.add(StringUtils.isEmptyString((String)basePath) ? " [basePath vacio o nulo] " : basePath + (currIdxDoc != null ? "" : " [documento es null] - ") + "/" + (currIdxDoc == null || currIdxDoc.getInternalName() == null ? " [InternalName del documento es null] " : currIdxDoc.getLanguage() + "_" + currIdxDoc.getInternalName()) + idxRelativePath + CATALOG_GUIDE_INDEX_FILE);
                filesToDelete.add(StringUtils.isEmptyString((String)basePath) ? " [basePath vacio o nulo] " : basePath + (currIdxDoc != null ? "" : " [documento es null] - ") + "/" + (currIdxDoc == null || currIdxDoc.getInternalName() == null ? " [InternalName del documento es null] " : currIdxDoc.getInternalName()) + "/" + (idxCont == null || idxCont.getInternalName() == null ? "  [InternalName del contenido es null] " : idxCont.getInternalName()) + "_" + (currIdxDoc == null || currIdxDoc.getLanguage() == null ? " [lenguaje del documento es null] " : currIdxDoc.getLanguage()) + ".html");
                for (Map.Entry<Object, Object> me : autonomyMappings.entrySet()) {
                    Pattern pp;
                    Matcher mm;
                    boolean valid;
                    currPropName = (String)me.getKey();
                    currPropValue = (String)me.getValue();
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("\telemento de la configuracion de searchMetaDataStorage.xml <" + currPropName + ">" + (currPropValue != null ? currPropValue : "") + "</" + currPropName + ">");
                    }
                    if (valid = (mm = (pp = Pattern.compile("autonomy.(DRE[^_]*)(_(metaData))?")).matcher(currPropName)).find()) {
                        String dreSubField = mm.group(3);
                        if (dreSubField != null) {
                            if (!dreSubField.equalsIgnoreCase("metaData")) continue;
                            String currMDAutonomyIdxFile = null;
                            for (R01MMetaDataStorageConfig currMDStorageCfg : md.values()) {
                                currMDAutonomyIdxFile = (String)currMDStorageCfg.getProperties().get("autonomy.idxFile");
                                if (StringUtils.isEmptyString((String)currMDAutonomyIdxFile)) {
                                    currMDAutonomyIdxFile = DEFAULT_IDX_NAME;
                                }
                                String relativePath = "";
                                if (ReflectionUtils.isSameClassAs(idxCont.getClass(), R01MIndexableContent.class)) {
                                    relativePath = (currIdxDoc != null ? "" : " [documento es null] - ") + "/" + (currIdxDoc == null || currIdxDoc.getLanguage() == null || currIdxDoc.getInternalName() == null ? " [nombre interno del documento es null] " : currIdxDoc.getLanguage() + "_" + currIdxDoc.getInternalName().trim()) + idxRelativePath + (StringUtils.isEmptyString((String)currMDAutonomyIdxFile) ? " [path relativo es null] " : currMDAutonomyIdxFile);
                                } else if (idxCont instanceof R01MIndexablePortalPage) {
                                    relativePath = (currIdxDoc != null ? "" : " [documento es null] - ") + "/" + (currIdxDoc == null || currIdxDoc.getInternalName() == null ? " [nombre interno del documento es null] " : currIdxDoc.getInternalName().trim()) + idxRelativePath + (StringUtils.isEmptyString((String)currMDAutonomyIdxFile) ? " [path relativo es null] " : currMDAutonomyIdxFile);
                                }
                                if (filesToDelete.contains((StringUtils.isEmptyString((String)basePath) ? " [basePath vacio o nulo] " : basePath) + (StringUtils.isEmptyString((String)relativePath) ? " [relativePath vacio o nulo] " : relativePath))) continue;
                                filesToDelete.add((StringUtils.isEmptyString((String)basePath) ? " [basePath vacio o nulo] " : basePath) + (StringUtils.isEmptyString((String)relativePath) ? " [relativePath vacio o nulo] " : relativePath));
                            }
                            continue;
                        }
                        String idxFileName = "";
                        int firstPointPosition = currPropValue.indexOf(46);
                        if (firstPointPosition > 0) {
                            idxFileName = currPropValue.substring(0, firstPointPosition) + ".idx";
                        }
                        if (StringUtils.isEmptyString((String)idxFileName)) continue;
                        String relativePath = "";
                        if (ReflectionUtils.isSameClassAs(idxCont.getClass(), R01MIndexableContent.class)) {
                            relativePath = (currIdxDoc != null ? "" : " [documento es null] - ") + "/" + (currIdxDoc == null || currIdxDoc.getLanguage() == null || currIdxDoc.getInternalName() == null ? " [nombre interno del documento es null] " : currIdxDoc.getLanguage() + "_" + currIdxDoc.getInternalName().trim()) + idxRelativePath + (StringUtils.isEmptyString((String)idxFileName) ? " [path relativo es null] " : idxFileName);
                        } else if (idxCont instanceof R01MIndexablePortalPage) {
                            relativePath = (currIdxDoc != null ? "" : " [documento es null] - ") + "/" + (currIdxDoc == null || currIdxDoc.getInternalName() == null ? " [nombre interno del documento es null] " : currIdxDoc.getInternalName().trim()) + idxRelativePath + (StringUtils.isEmptyString((String)idxFileName) ? " [path relativo es null] " : idxFileName);
                        }
                        if (filesToDelete.contains((StringUtils.isEmptyString((String)basePath) ? " [basePath vacio o nulo] " : basePath) + (StringUtils.isEmptyString((String)relativePath) ? " [relativePath vacio o nulo] " : relativePath))) continue;
                        filesToDelete.add((StringUtils.isEmptyString((String)basePath) ? " [basePath vacio o nulo] " : basePath) + (StringUtils.isEmptyString((String)relativePath) ? " [relativePath vacio o nulo] " : relativePath));
                        continue;
                    }
                    R01FLog.to((String)LOG_TYPE_ID).severe("Hay un error en las lineas del fichero IDX definidas en el fichero searchMetaDataStorage.xml: La propiedad debe seguir el patr\u00f3n autonomy.DRE[fieldName](_[subFieldName])opt");
                }
                if (!filesToDelete.isEmpty()) {
                    try {
                        R01KIDXProcessor processor = (R01KIDXProcessor)ReflectionUtils.getObjectInstance((String)((String)this._props.get("processorClass")));
                        processor.setProperties(this._props);
                        processor.removeIndexData((R01MIndexableContent)idxCont, filesToDelete);
                    }
                    catch (ReflectionException refEx) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("Error al procesar el idx de autonomy: " + refEx.getMessage());
                    }
                }
                filesToDelete.clear();
            }
        }
    }

    @Override
    public void unIndex(String systemId, R01MBaseIndexableObject indexableObj, String objectOid, int objectType, boolean traceIndex) throws R01MSearchIndexerException {
        this.unIndex(systemId, objectOid, objectType, traceIndex);
    }

    @Override
    public boolean checkIndex(String systemId, String objOid, int objType) throws R01MSearchIndexerException {
        boolean indexInIDOL1 = R01KAutonomyIndexer._testAutonomy(objOid, 0, objType, true);
        boolean indexInIDOL2 = R01KAutonomyIndexer._testAutonomy(objOid, 0, objType, false);
        return indexInIDOL1 && indexInIDOL2;
    }

    @Override
    public boolean checkUnIndex(String systemId, String objOid, int objType) throws R01MSearchIndexerException {
        boolean indexInIDOL1 = R01KAutonomyIndexer._testAutonomy(objOid, 1, objType, true);
        boolean indexInIDOL2 = R01KAutonomyIndexer._testAutonomy(objOid, 1, objType, false);
        return indexInIDOL1 && indexInIDOL2;
    }

    private Map<String, R01MMetaDataStorageConfig> _getMetadataStorageConfigMap(R01MIndexableContent idxCont) throws R01MConfigLoadException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\t\tSe recoge el mapa de configuraci\u00f3n de storage para metaDatos: cluster:family:type=" + idxCont.getTypo().getCluster().getOid() + ":" + idxCont.getTypo().getFamily().getOid() + ":" + idxCont.getTypo().getType().getOid());
        }
        return typoStorageConfigAPI.getSearchMetaDataStorageConfig(idxCont.getStorage().getServer().getOid(), idxCont.getStorage().getDataStore().getOid()).getTypeSearchMetaDataStorageCfgs(idxCont.getTypo().getCluster() != null ? idxCont.getTypo().getCluster().getOid() : null, idxCont.getTypo().getFamily() != null ? idxCont.getTypo().getFamily().getOid() : null, idxCont.getTypo().getType() != null ? idxCont.getTypo().getType().getOid() : null);
    }

    private Map<String, StringBuffer> _composeMetaDataIDXLines(String dreField, R01MIndexableContent idxCont, R01MIndexableDocument idxDoc, Map<String, R01MMetaDataStorageConfig> md, List<String> metadataFileNames) {
        HashMap<String, StringBuffer> idxFilesLines = new HashMap<String, StringBuffer>();
        if (md == null) {
            R01FLog.to((String)LOG_TYPE_ID).warning("NO se ha encontrado informaci\u00f3n sobre los metaDatos para el tipo cluster:familia:tipo=" + idxCont.getTypo().getCluster().getOid() + ":" + idxCont.getTypo().getFamily().getOid() + ":" + idxCont.getTypo().getType().getOid() + ". " + "REVISA EL FICHERO searchMetaDataStorage.xml");
            return idxFilesLines;
        }
        R01MMetaDataStorageConfig currMDStorageCfg = null;
        String idxLine = null;
        String currMDAutonomyIdxFile = null;
        String currMDDataTypeDef = null;
        String currMDAutonomyField = null;
        String currMDataType = null;
        String currMDDataSubType = null;
        String currMDAutonomyFieldValue = null;
        for (Map.Entry<String, R01MMetaDataStorageConfig> entry : md.entrySet()) {
            currMDStorageCfg = entry.getValue();
            currMDDataTypeDef = currMDStorageCfg.getDataType();
            currMDAutonomyIdxFile = (String)currMDStorageCfg.getProperties().get("autonomy.idxFile");
            currMDAutonomyField = (String)currMDStorageCfg.getProperties().get("autonomy.idxFieldSrc");
            currMDataType = (String)currMDStorageCfg.getProperties().get("autonomy.idxFieldType");
            currMDDataSubType = (String)currMDStorageCfg.getProperties().get("autonomy.idxFieldSubType");
            if (StringUtils.isEmptyString((String)currMDAutonomyIdxFile)) {
                currMDAutonomyIdxFile = DEFAULT_IDX_NAME;
            }
            if (!StringUtils.isEmptyString((String)currMDAutonomyField) && (metadataFileNames == null || metadataFileNames.isEmpty() || metadataFileNames.contains(currMDAutonomyIdxFile))) {
                Throwable th;
                if (!idxFilesLines.containsKey(currMDAutonomyIdxFile)) {
                    idxFilesLines.put(currMDAutonomyIdxFile, new StringBuffer(270));
                }
                StringBuffer mdIDXLines = idxFilesLines.get(currMDAutonomyIdxFile);
                idxLine = "#" + dreField + " " + currMDStorageCfg.getOid() + "=";
                if (currMDStorageCfg.getOid().equalsIgnoreCase("documentPublicationInfo") && (currMDataType == null || !currMDataType.equalsIgnoreCase("List"))) {
                    currMDataType = "List";
                    currMDDataSubType = "R01MSearchResultItemPublicationInfo";
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("Durante la indexaci\u00f3n de ficheros idx del documento " + idxDoc == null ? "[null]" : idxDoc.getOid() + ". " + "No se han cargado correctamente los metadatos ya que el metadatos de " + "publicacion tiene tipo null o distinto de List. Se indica el tipo directamente.\n" + "A continuaci\u00f3n se indican las traza de llamadas que han llegado a este punto:");
                    }
                    th = new Throwable();
                    th.printStackTrace();
                    mdIDXLines.append("\r\n#DREFIELD documentPublicationInfo=\"Configuration loaded with ERRORS\"\r\n");
                }
                if (currMDStorageCfg.getOid().equalsIgnoreCase("structureCatalogs") && (currMDataType == null || !currMDataType.equalsIgnoreCase("List"))) {
                    currMDataType = "List";
                    currMDDataSubType = "R01MSearchResultItemStructureCatalog";
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("Durante la indexaci\u00f3n de ficheros idx del documento " + idxDoc == null ? "[null]" : idxDoc.getOid() + ". " + "No se han cargado correctamente los metadatos ya que el metadatos de " + "catalogacion tiene tipo null o distinto de List. Se indica el tipo directamente.\n" + "A continuaci\u00f3n se indican las traza de llamadas que han llegado a este punto:");
                    }
                    th = new Throwable();
                    th.printStackTrace();
                    mdIDXLines.append("\r\n#DREFIELD structureCatalogs=\"Configuration loaded with ERRORS\"\r\n");
                }
                if (currMDStorageCfg.getOid().equalsIgnoreCase("geoCatalogs") && (currMDataType == null || !currMDataType.equalsIgnoreCase("List"))) {
                    currMDataType = "List";
                    currMDDataSubType = "R01MSearchResultItemGeoCatalog";
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("Durante la indexaci\u00f3n de ficheros idx del documento " + idxDoc == null ? "[null]" : idxDoc.getOid() + ". " + "No se han cargado correctamente los metadatos ya que el metadatos de " + "catalogacion geografica  tiene tipo null o distinto de List. " + "Se indica el tipo directamente.\n" + "A continuaci\u00f3n se indican las traza de llamadas que han llegado a este punto:");
                    }
                    th = new Throwable();
                    th.printStackTrace();
                    mdIDXLines.append("\r\n#DREFIELD geoCatalogs=\"Configuration loaded with ERRORS\"\r\n");
                }
                if (!(!currMDStorageCfg.getOid().equalsIgnoreCase("linkedDocumentsByTagSrc") && !currMDStorageCfg.getOid().equalsIgnoreCase("linkedDocumentsByTagDst") || currMDataType != null && currMDataType.equalsIgnoreCase("List"))) {
                    currMDataType = "List";
                    currMDDataSubType = "R01MSearchResultItemDocumentLinkedDataInfo";
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("Durante la indexaci\u00f3n de ficheros idx del documento " + idxDoc == null ? "[null]" : idxDoc.getOid() + ". " + "No se han cargado correctamente los metadatos ya que el metadatos de " + "enlaces tiene tipo null o distinto de List. Se indica el tipo directamente.\n" + "A continuaci\u00f3n se indican las traza de llamadas que han llegado a este punto:");
                    }
                    th = new Throwable();
                    th.printStackTrace();
                    mdIDXLines.append("\r\n#DREFIELD ");
                    mdIDXLines.append(currMDStorageCfg.getOid());
                    mdIDXLines.append("=\"Configuration loaded with ERRORS\"\r\n");
                }
                if (currMDataType != null && currMDataType.equalsIgnoreCase("List") && currMDDataSubType != null) {
                    if ("R01MSearchResultItemStructureCatalog".equals(currMDDataSubType)) {
                        mdIDXLines.append(this._composeStructureCatalogsIDXLines(dreField, "structureCatalogs", idxCont, idxDoc));
                    } else if ("R01MSearchResultItemPublicationInfo".equals(currMDDataSubType)) {
                        mdIDXLines.append(this._composePublicationTargetsIDXLines(dreField, "pubTargets", idxDoc));
                    } else if ("R01MSearchResultItemDocumentLinkedDataInfo".equals(currMDDataSubType)) {
                        if (idxDoc.getDocumentLinkedData() != null && (idxDoc.getDocumentLinkedData().getLinkedDocumentsByTagDst() != null || idxDoc.getDocumentLinkedData().getLinkedDocumentsByTagSrc() != null)) {
                            mdIDXLines.append(this._composeDocumentLinkedDataIDXLines(dreField, "linkedDocumentsByTag", idxDoc.getDocumentLinkedData(), currMDAutonomyField));
                        }
                    } else {
                        mdIDXLines.append(idxLine).append("[WARNING] El tipo de datos ").append(currMDDataTypeDef).append(" NO es valido. NO se indexa\r\n");
                    }
                } else {
                    if (dreField != null && (currMDAutonomyField.indexOf("friendlyUrlsByLanguage") > 0 || currMDAutonomyField.indexOf("urlsByLanguage") > 0)) {
                        Map urlsMap = currMDAutonomyField.indexOf("friendlyUrlsByLanguage") > 0 ? idxDoc.getFriendlyUrlsByLanguage() : idxDoc.getUrlsByLanguage();
                        StringBuffer resultList = new StringBuffer();
                        if (urlsMap != null && !urlsMap.isEmpty()) {
                            for (Map.Entry entry2 : urlsMap.entrySet()) {
                                String repository = (String)entry2.getKey();
                                String lang = "";
                                String url = "";
                                Map value = (Map)entry2.getValue();
                                for (Map.Entry entry3 : value.entrySet()) {
                                    lang = (String)entry3.getKey();
                                    url = (String)entry3.getValue();
                                    resultList.append('(').append(idxDoc.getInternalName()).append(';').append(repository).append(';').append(lang).append(';').append(url).append("),");
                                }
                            }
                        }
                        if ((currMDAutonomyFieldValue = resultList.toString()).endsWith(",")) {
                            currMDAutonomyFieldValue = currMDAutonomyFieldValue.substring(0, currMDAutonomyFieldValue.length() - 1);
                        }
                    } else {
                        currMDAutonomyFieldValue = this._getMemberValue(currMDStorageCfg, idxCont, idxDoc, currMDAutonomyField);
                    }
                    if (currMDAutonomyFieldValue != null) {
                        if (currMDataType != null && currMDataType.equalsIgnoreCase("String") && currMDDataSubType != null && NumberUtils.isInteger((String)currMDDataSubType) && currMDAutonomyFieldValue.length() > Integer.parseInt(currMDDataSubType)) {
                            currMDAutonomyFieldValue = currMDAutonomyFieldValue.substring(0, Integer.parseInt(currMDDataSubType));
                        }
                        idxLine = idxLine + "\"" + currMDAutonomyFieldValue + "\"";
                        mdIDXLines.append(idxLine);
                        mdIDXLines.append("\r\n");
                    }
                }
                StringUtils.replaceAll((StringBuffer)mdIDXLines, (String)"\r\n\r\n", (String)"\r\n");
                continue;
            }
            if (!DEBUG) continue;
            R01FLog.to((String)LOG_TYPE_ID).info("Durante la indexaci\u00f3n de ficheros idx del documento " + idxDoc == null ? "[null]" : idxDoc.getOid() + " el tipo definido en el metadato " + currMDStorageCfg.getOid() + " es null (autonomy.idxFieldType)");
        }
        if (DEBUG) {
            for (Map.Entry<String, Object> entry : idxFilesLines.entrySet()) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\nFICHERO: " + entry.getKey());
            }
        }
        return idxFilesLines;
    }

    private StringBuffer _composeStructureCatalogsIDXLines(String dreField, String dreSubField, R01MIndexableContent idxCont, R01MIndexableDocument idxDoc) {
        StringBuffer catsIDXLines = new StringBuffer();
        Collection uniqueStructureCatalogs = null;
        if (idxCont.getStructureCatalogs() != null) {
            HashMap<String, R01MIndexableStructureCatalog> uniqueCats = new HashMap<String, R01MIndexableStructureCatalog>();
            for (R01MIndexableStructureCatalog idxStructureCatalog : idxCont.getStructureCatalogs()) {
                if (uniqueCats.containsKey(idxStructureCatalog.getLabelOid())) continue;
                uniqueCats.put(idxStructureCatalog.getLabelOid(), idxStructureCatalog);
            }
            Collection collection = uniqueStructureCatalogs = !uniqueCats.isEmpty() ? uniqueCats.values() : null;
        }
        if (uniqueStructureCatalogs != null) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\t\tCatalogaciones en ejes....");
            }
            StringBuffer idxLabelsOidsLine = new StringBuffer("#" + dreField + " " + dreSubField + "Oids=\"");
            StringBuffer idxLabelsOidsBoolLine = new StringBuffer("#" + dreField + " " + dreSubField + "OidsBool=\"");
            StringBuffer idxLabelsNumericOidsLine = new StringBuffer("#" + dreField + " " + dreSubField + "Numeric=\"");
            StringBuffer idxLabelsNumericOidsBoolLine = new StringBuffer("#" + dreField + " " + dreSubField + "NumericBool=\"");
            StringBuffer idxLabelsTermsLine = new StringBuffer("#" + dreField + " " + dreSubField + "Terms=\"");
            Iterator cIt = uniqueStructureCatalogs.iterator();
            while (cIt.hasNext()) {
                List idxStructureCatalogTerms;
                R01MIndexableStructureCatalog idxStructureCatalog = (R01MIndexableStructureCatalog)cIt.next();
                idxLabelsOidsLine.append(idxStructureCatalog.getLabelOid());
                idxLabelsOidsBoolLine.append(idxStructureCatalog.getLabelOid());
                if (cIt.hasNext()) {
                    idxLabelsOidsLine.append(',');
                    idxLabelsOidsBoolLine.append(" OR ");
                }
                idxLabelsNumericOidsLine.append(idxStructureCatalog.getLabelNumericId());
                idxLabelsNumericOidsBoolLine.append(idxStructureCatalog.getLabelNumericId());
                if (cIt.hasNext()) {
                    idxLabelsNumericOidsLine.append(',');
                    idxLabelsNumericOidsBoolLine.append(" OR ");
                }
                if ((idxStructureCatalogTerms = idxStructureCatalog.getTerms()) == null) continue;
                boolean hasTerms = false;
                String currTermText = null;
                for (R01MIndexableLabelTerm idxStructureCatalogTerm : idxStructureCatalogTerms) {
                    if (!idxStructureCatalogTerm.getLang().equals(idxDoc.getLanguage())) continue;
                    if (hasTerms) {
                        idxLabelsTermsLine.append(';');
                    }
                    currTermText = this._fixStringValue(idxStructureCatalogTerm.getTermText());
                    currTermText = currTermText.replaceAll(",", "");
                    idxLabelsTermsLine.append(currTermText);
                    hasTerms = true;
                }
                if (!cIt.hasNext()) continue;
                idxLabelsTermsLine.append(',');
            }
            catsIDXLines.append(idxLabelsOidsLine);
            catsIDXLines.append("\"\r\n");
            catsIDXLines.append(idxLabelsOidsBoolLine);
            catsIDXLines.append("\"\r\n");
            catsIDXLines.append(idxLabelsNumericOidsLine);
            catsIDXLines.append("\"\r\n");
            catsIDXLines.append(idxLabelsNumericOidsBoolLine);
            catsIDXLines.append("\"\r\n");
            catsIDXLines.append(idxLabelsTermsLine);
            catsIDXLines.append("\"\r\n");
        }
        if (idxCont.getStructureCatalogs() != null) {
            StringBuffer idxLabelsStructureAndRoleLine = new StringBuffer("#" + dreField + " " + dreSubField + "Cats=\"");
            Iterator cIt = idxCont.getStructureCatalogs().iterator();
            while (cIt.hasNext()) {
                R01MIndexableStructureCatalog idxStructureCatalog;
                idxStructureCatalog = (R01MIndexableStructureCatalog)cIt.next();
                idxLabelsStructureAndRoleLine.append('(');
                idxLabelsStructureAndRoleLine.append(idxStructureCatalog.getStructureOid());
                idxLabelsStructureAndRoleLine.append(';');
                idxLabelsStructureAndRoleLine.append(idxStructureCatalog.getLabelOid());
                idxLabelsStructureAndRoleLine.append(';');
                idxLabelsStructureAndRoleLine.append(idxStructureCatalog.getLabelRoleInStructure());
                idxLabelsStructureAndRoleLine.append(')');
                if (!cIt.hasNext()) continue;
                idxLabelsStructureAndRoleLine.append(',');
            }
            catsIDXLines.append(idxLabelsStructureAndRoleLine);
            catsIDXLines.append("\"\r\n");
        }
        return catsIDXLines;
    }

    private Map<String, StringBuffer> _composeGuidesIDXLines(String dreField, R01MIndexableContent idxCont, List<String> metadataFileNames) {
        HashMap<String, StringBuffer> idxFilesLines = new HashMap<String, StringBuffer>();
        if ((metadataFileNames == null || metadataFileNames.isEmpty() || metadataFileNames.contains(CATALOG_GUIDE_INDEX_FILE)) && idxCont.getStructureCatalogs() != null) {
            StringBuffer catalogGuidesIDXLines = new StringBuffer(83);
            Comparator<R01MIndexableStructureCatalog> structureCatsComp = new Comparator<R01MIndexableStructureCatalog>(){

                @Override
                public int compare(R01MIndexableStructureCatalog first, R01MIndexableStructureCatalog second) {
                    R01MIndexableStructureCatalog firstCat = first;
                    R01MIndexableStructureCatalog secondCat = second;
                    int compResult = firstCat.getStructureOid().compareTo(secondCat.getStructureOid());
                    if (compResult == 0 && (compResult = firstCat.getLabelRoleInStructure().compareTo(secondCat.getLabelRoleInStructure())) == 0) {
                        compResult = firstCat.getLabelOid().compareTo(secondCat.getLabelOid());
                    }
                    return compResult;
                }
            };
            ArrayList catsStructuresOrdered = new ArrayList(idxCont.getStructureCatalogs());
            Collections.sort(catsStructuresOrdered, structureCatsComp);
            StringBuffer idxCatsGuideLines = new StringBuffer("");
            R01MIndexableStructureCatalog prevCat = null;
            boolean isSameStructAndRole = false;
            for (R01MIndexableStructureCatalog currCat : catsStructuresOrdered) {
                String currId;
                isSameStructAndRole = prevCat == null ? false : (!currCat.getStructureOid().equals(prevCat.getStructureOid()) ? false : currCat.getLabelRoleInStructure().equals(prevCat.getLabelRoleInStructure()));
                String string = currId = currCat.getLabelNumericId() != null ? currCat.getLabelNumericId() : "-1";
                if (!isSameStructAndRole) {
                    idxCatsGuideLines.append("\"\r\n#").append(dreField).append(" guide_structure_").append(currCat.getStructureOid()).append('_').append(currCat.getLabelRoleInStructure()).append("=\"").append(currId);
                } else {
                    idxCatsGuideLines.append(',').append(currId);
                }
                prevCat = currCat;
            }
            if (idxCatsGuideLines.indexOf("\"\r\n") == 0) {
                idxCatsGuideLines.delete(0, 3);
                idxCatsGuideLines.append("\"\r\n");
            }
            catalogGuidesIDXLines.append(idxCatsGuideLines);
            if (!StringUtils.isEmptyString((String)CATALOG_GUIDE_INDEX_FILE)) {
                idxFilesLines.put(CATALOG_GUIDE_INDEX_FILE, catalogGuidesIDXLines);
            } else {
                idxFilesLines.put(DEFAULT_IDX_NAME, catalogGuidesIDXLines);
            }
        }
        if (metadataFileNames == null || metadataFileNames.isEmpty() || metadataFileNames.contains(TYPOLOGY_GUIDE_INDEX_FILE)) {
            StringBuffer typologyGuidesIDXLines = new StringBuffer(83);
            if (idxCont.getTypo() != null && idxCont.getTypo().getCluster() != null && idxCont.getTypo().getCluster().getOid() != null) {
                typologyGuidesIDXLines.append('#');
                typologyGuidesIDXLines.append(dreField);
                typologyGuidesIDXLines.append(" guide_typo_cluster=\"");
                typologyGuidesIDXLines.append(idxCont.getTypo().getCluster().getOid());
                typologyGuidesIDXLines.append("\"\r\n");
            }
            if (idxCont.getTypo() != null && idxCont.getTypo().getFamily() != null && idxCont.getTypo().getFamily().getOid() != null) {
                typologyGuidesIDXLines.append('#');
                typologyGuidesIDXLines.append(dreField);
                typologyGuidesIDXLines.append(" guide_typo_family=\"");
                typologyGuidesIDXLines.append(idxCont.getTypo().getFamily().getOid());
                typologyGuidesIDXLines.append("\"\r\n");
            }
            if (idxCont.getTypo() != null && idxCont.getTypo().getType() != null && idxCont.getTypo().getType().getOid() != null) {
                typologyGuidesIDXLines.append('#');
                typologyGuidesIDXLines.append(dreField);
                typologyGuidesIDXLines.append(" guide_typo_type=\"");
                typologyGuidesIDXLines.append(idxCont.getTypo().getType().getOid());
                typologyGuidesIDXLines.append("\"\r\n");
            }
            if (typologyGuidesIDXLines.length() > 0) {
                if (!StringUtils.isEmptyString((String)TYPOLOGY_GUIDE_INDEX_FILE)) {
                    idxFilesLines.put(TYPOLOGY_GUIDE_INDEX_FILE, typologyGuidesIDXLines);
                } else {
                    idxFilesLines.put(DEFAULT_IDX_NAME, typologyGuidesIDXLines);
                }
            }
        }
        return idxFilesLines;
    }

    private StringBuffer _composePublicationTargetsIDXLines(String dreField, String dreSubField, R01MIndexableDocument idxDoc) {
        StringBuffer pubsIDXLines = new StringBuffer();
        if (idxDoc.getPublicationInfo() != null) {
            List pubTargets = idxDoc.getPublicationInfo();
            StringBuffer pubTgtsDetailsIdxLine = new StringBuffer("#" + dreField + " " + dreSubField + "Details=\"");
            StringBuffer pubTgtsOidsIdxLine = null;
            StringBuffer pubTgtsNumericIdsIdxLine = null;
            StringBuffer pubTgtsDatesIdxLines = null;
            boolean first = true;
            Iterator pIt = pubTargets.iterator();
            while (pIt.hasNext()) {
                R01MIndexablePublicationInfo currPubTarget = (R01MIndexablePublicationInfo)pIt.next();
                pubTgtsDetailsIdxLine.append('(');
                pubTgtsDetailsIdxLine.append(currPubTarget.getRepositoryOid());
                pubTgtsDetailsIdxLine.append(';');
                pubTgtsDetailsIdxLine.append(currPubTarget.getRepositoryAlias());
                pubTgtsDetailsIdxLine.append(';');
                pubTgtsDetailsIdxLine.append(currPubTarget.getState());
                pubTgtsDetailsIdxLine.append(';');
                pubTgtsDetailsIdxLine.append(DateUtils.getDateFormated((java.util.Date)currPubTarget.getPublishDate(), (String)this.getNativeDateFormat()));
                pubTgtsDetailsIdxLine.append(')');
                if (pIt.hasNext()) {
                    pubTgtsDetailsIdxLine.append(',');
                }
                if (currPubTarget.getState() != 1 || !idxDoc.isPublishedInRepository(currPubTarget.getRepositoryOid())) continue;
                if (first) {
                    pubTgtsOidsIdxLine = new StringBuffer().append('#').append(dreField).append(' ').append(dreSubField).append("Oids=\"");
                    pubTgtsNumericIdsIdxLine = new StringBuffer().append('#').append(dreField).append(' ').append(dreSubField).append("NumericIds=\"");
                    pubTgtsDatesIdxLines = new StringBuffer("");
                    first = false;
                } else {
                    pubTgtsOidsIdxLine.append(',');
                    pubTgtsNumericIdsIdxLine.append(',');
                    pubTgtsDatesIdxLines.append("\r\n");
                }
                pubTgtsOidsIdxLine.append(currPubTarget.getRepositoryOid());
                pubTgtsNumericIdsIdxLine.append(currPubTarget.getRepositoryNumericId());
                pubTgtsDatesIdxLines.append('#');
                pubTgtsDatesIdxLines.append(dreField);
                pubTgtsDatesIdxLines.append(' ');
                pubTgtsDatesIdxLines.append(dreSubField);
                pubTgtsDatesIdxLines.append('_');
                pubTgtsDatesIdxLines.append(currPubTarget.getRepositoryOid());
                pubTgtsDatesIdxLines.append("=\"");
                pubTgtsDatesIdxLines.append(DateUtils.getDateFormated((java.util.Date)currPubTarget.getPublishDate(), (String)this.getNativeDateFormat()));
                pubTgtsDatesIdxLines.append('\"');
            }
            pubsIDXLines.append(pubTgtsDetailsIdxLine);
            pubsIDXLines.append("\"\r\n");
            if (pubTgtsOidsIdxLine != null) {
                pubsIDXLines.append(pubTgtsOidsIdxLine);
                pubsIDXLines.append("\"\r\n");
            }
            if (pubTgtsNumericIdsIdxLine != null) {
                pubsIDXLines.append(pubTgtsNumericIdsIdxLine);
                pubsIDXLines.append("\"\r\n");
            }
            if (pubTgtsDatesIdxLines != null) {
                pubsIDXLines.append(pubTgtsDatesIdxLines);
                pubsIDXLines.append("\r\n");
            }
        }
        return pubsIDXLines;
    }

    private StringBuffer _composeDocumentLinkedDataIDXLines(String dreField, String dreSubField, R01MIndexableDocumentLinkedData idxLnkDoc, String currMDAutonomyField) {
        Map linkedDocumentsByTag;
        StringBuffer lnkIDXLines = new StringBuffer();
        if (currMDAutonomyField.endsWith("linkedDocumentsByTagSrc")) {
            linkedDocumentsByTag = idxLnkDoc.getLinkedDocumentsByTagSrc();
            dreSubField = dreSubField + "Src";
        } else {
            linkedDocumentsByTag = idxLnkDoc.getLinkedDocumentsByTagDst();
            dreSubField = dreSubField + "Dst";
        }
        if (currMDAutonomyField.endsWith("linkedSizeByTagSrc")) {
            Map linkedSizeByTag = idxLnkDoc.getLinkedSizeByTagSrc();
            StringBuffer lnkSizeIdxLine = new StringBuffer();
            lnkSizeIdxLine.append('#');
            lnkSizeIdxLine.append(dreField);
            lnkSizeIdxLine.append(' ');
            lnkSizeIdxLine.append(dreSubField);
            lnkSizeIdxLine.append("=\"");
            JSONObject allLinkedSizeByTagSrc = new JSONObject();
            for (Map.Entry me : linkedSizeByTag.entrySet()) {
                try {
                    allLinkedSizeByTagSrc.put((String)me.getKey(), me.getValue());
                }
                catch (JSONException jsonExc) {}
            }
            lnkSizeIdxLine.append(allLinkedSizeByTagSrc.toString().replace('\"', '\u001f'));
            lnkSizeIdxLine.append('\"');
            lnkIDXLines.append(lnkSizeIdxLine);
            lnkIDXLines.append("\r\n");
        }
        if (linkedDocumentsByTag != null && !linkedDocumentsByTag.isEmpty()) {
            for (Map.Entry me : linkedDocumentsByTag.entrySet()) {
                lnkIDXLines.setLength(0);
                lnkIDXLines.append('#');
                lnkIDXLines.append(dreField);
                lnkIDXLines.append(' ');
                lnkIDXLines.append(dreSubField);
                lnkIDXLines.append('_');
                lnkIDXLines.append((String)me.getKey());
                lnkIDXLines.append("=\"");
                lnkIDXLines.append((String)me.getValue());
                lnkIDXLines.append("\"\r\n");
            }
        }
        return lnkIDXLines;
    }

    private Map<String, StringBuffer> _composeMiscIDXLines(String dreField, String propValue, int objType, R01MIndexableContent idxCont, R01MIndexableDocument idxDoc, List<String> metadataFileNames) {
        String idxFileName;
        String memberValue;
        StringBuffer miscIDXLines = new StringBuffer();
        HashMap<String, StringBuffer> idxFilesLines = new HashMap<String, StringBuffer>();
        int firstPointPosition = propValue.indexOf(46);
        if (firstPointPosition > 0) {
            memberValue = this._getMemberValue(null, idxCont, idxDoc, propValue.substring(firstPointPosition + 1));
            idxFileName = propValue.substring(0, firstPointPosition) + ".idx";
            if (idxFileName.indexOf(37) >= 0 && (objType == 0 || objType == 1)) {
                idxFileName = StringUtils.replaceVariableValues((String)idxFileName, (char)'%', (Map)R01MSearchEngineConstants.CONTENT_TYPE_NAMES);
            } else if (idxFileName.indexOf(37) >= 0 && objType == 4) {
                idxFileName = StringUtils.replaceVariableValues((String)idxFileName, (char)'%', (Map)R01MSearchEngineConstants.PORTAL_TYPE_NAMES);
            }
        } else {
            R01FLog.to((String)LOG_TYPE_ID).warning("Error en el formato del elemento " + dreField + ". " + propValue + " debe tener un formato file.tipo.valor/ruta");
            memberValue = this._getMemberValue(null, idxCont, idxDoc, propValue);
            idxFileName = DEFAULT_IDX_NAME;
        }
        if (metadataFileNames == null || metadataFileNames.isEmpty() || metadataFileNames.contains(idxFileName)) {
            if (memberValue != null) {
                String idxLine = "#" + dreField + " " + memberValue;
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\t\t" + idxLine);
                }
                miscIDXLines.append(idxLine).append("\r\n");
            } else {
                R01FLog.to((String)LOG_TYPE_ID).warning("\tel valor asociado para el campo " + dreField + " est\u00e1 vac\u00edo o es una cadena arbitraria... Se toma este valor a pelo!");
                String idxLine = propValue.indexOf(46) > 0 ? "#" + dreField + " " + propValue.substring(propValue.indexOf(46) + 1) : "#" + dreField + " " + propValue;
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\t\t" + idxLine);
                }
                miscIDXLines.append(idxLine);
                miscIDXLines.append("\r\n");
            }
            idxFilesLines.put(idxFileName, miscIDXLines);
        }
        return idxFilesLines;
    }

    private String _getMemberValue(R01MMetaDataStorageConfig mdStorageCfg, R01MIndexableContent idxCont, R01MIndexableDocument idxDoc, String memberSrc) {
        String metaDataTypeDef = null;
        String metaDataType = null;
        String metaDataMaxLength = null;
        if (mdStorageCfg != null) {
            metaDataTypeDef = mdStorageCfg.getDataType();
            Pattern mdTypePattern = Pattern.compile("(unknown|String|Integer|Long|Short|Float|Double|Date|List|Map|R01MStructureCatalog|R01MGeoCatalog|R01MSearchResultItemPublicationInfo)(?:\\((.+)\\))*");
            Matcher mdTypeMatcher = mdTypePattern.matcher(metaDataTypeDef);
            if (mdTypeMatcher.matches() && mdTypeMatcher.groupCount() >= 2) {
                metaDataType = mdTypeMatcher.group(1);
                metaDataMaxLength = mdTypeMatcher.group(2);
            } else if (mdTypeMatcher.matches() && mdTypeMatcher.groupCount() == 1) {
                metaDataType = mdTypeMatcher.group(1);
            }
        }
        String objectType = null;
        String memberPath = null;
        Object memberValue = null;
        Pattern mdValuePattern = Pattern.compile(REG_EX);
        Matcher mdValueMatcher = mdValuePattern.matcher(memberSrc);
        if (mdValueMatcher.matches()) {
            objectType = mdValueMatcher.group(1);
            memberPath = mdValueMatcher.group(2);
            try {
                int mapClauseIndex = memberPath.indexOf("($LANG$)");
                if (mapClauseIndex > 0) {
                    memberPath = memberPath.substring(0, mapClauseIndex);
                }
                if (objectType.equalsIgnoreCase("CONTENT") && idxCont != null) {
                    memberValue = ReflectionUtils.getMemberValueUsingPath((Object)idxCont, (String)memberPath, (boolean)true);
                } else if (objectType.equalsIgnoreCase("DOCUMENT") && idxDoc != null) {
                    memberValue = ReflectionUtils.getMemberValueUsingPath((Object)idxDoc, (String)memberPath, (boolean)true);
                } else if (objectType.equalsIgnoreCase("DOCUMENT_DATAFILES")) {
                    if (idxDoc.getDataFiles() != null && !idxDoc.getDataFiles().isEmpty()) {
                        memberValue = new StringBuffer(idxDoc.getDataFiles().size() * 60);
                        R01MIndexableDataFile currIdxDf = null;
                        Object currDfMemberValue = null;
                        Iterator dfIt = idxDoc.getDataFiles().values().iterator();
                        while (dfIt.hasNext()) {
                            currIdxDf = (R01MIndexableDataFile)dfIt.next();
                            currDfMemberValue = ReflectionUtils.getMemberValueUsingPath((Object)currIdxDf, (String)memberPath, (boolean)true);
                            if (currDfMemberValue == null) continue;
                            ((StringBuffer)memberValue).append(currIdxDf.getOid());
                            ((StringBuffer)memberValue).append(">>");
                            ((StringBuffer)memberValue).append(this._serializeToString(currDfMemberValue));
                            if (StringUtils.isEmptyStringBuffer((StringBuffer)((StringBuffer)memberValue)) || !dfIt.hasNext()) continue;
                            ((StringBuffer)memberValue).append("$$");
                        }
                    }
                } else if (objectType.equalsIgnoreCase("DOCUMENT_MAINDATAFILE") && idxDoc != null) {
                    R01MIndexableDataFile mainDF = idxDoc.getMainDataFile();
                    if (mainDF != null) {
                        memberValue = ReflectionUtils.getMemberValueUsingPath((Object)mainDF, (String)memberPath, (boolean)true);
                    }
                } else if (objectType.equalsIgnoreCase("METADATA") && idxDoc != null && idxDoc.getDataFiles() != null) {
                    for (R01MIndexableDataFile currIdxDf : idxDoc.getDataFiles().values()) {
                        if (!currIdxDf.isMetaDataContainer() || currIdxDf.getMetaData() == null || currIdxDf.getMetaData().isEmpty()) continue;
                        R01MIndexableMetaData metaData = currIdxDf.getMetaData(memberPath);
                        if (metaData != null && mdStorageCfg != null) {
                            memberValue = metaData.getMetaDataValue();
                            if (memberValue != null && metaDataType != null && metaDataType.equalsIgnoreCase("String") && metaDataMaxLength != null && NumberUtils.isInteger((String)metaDataMaxLength) && ((String)memberValue).length() > Integer.parseInt(metaDataMaxLength)) {
                                memberValue = ((String)memberValue).substring(0, Integer.parseInt(metaDataMaxLength));
                            }
                            if (memberValue != null && metaDataType != null && metaDataType.equalsIgnoreCase("Date")) {
                                if ((memberValue = DateUtils.reformatDateString((String)((String)memberValue), (String)DateUtils.getLanguageDateFormat((String)idxDoc.getLanguage(), (Properties)R01MSearchEngineConstants.IDX_DATE_FORMATS), (String)this._nativeDateFormat)) != null) continue;
                                R01FLog.to((String)LOG_TYPE_ID).warning("NO se ha podido obtener una fecha con el formato dd/MM/yyyy del metaDato " + mdStorageCfg.getOid());
                                continue;
                            }
                            if (memberValue != null) continue;
                            R01FLog.to((String)LOG_TYPE_ID).info("NO se encuentra el valor del metaDato " + memberPath + ": NO se ha obtenido el metaDato <autonomy.idxFieldSrc>" + memberSrc + "</autonomy.idxFieldSrc>\r\nPosibles Causas:\r\n\t-El valor de esta propiedad autonomy.idxFieldSrc debe coincidir con el oid de un metaDato del objeto R01MIndexableDataFile\r\n\t-El objeto R01MIndexableDataFile NO tenga un valor para el metaDato (es nulo)\r\n\t-La sentencia xpath especificada en la configuracion del metaDato en el fichero searchMetaDataStorage.xml y que permite obtener su valor desde el DCR NO es correcta");
                            continue;
                        }
                        R01FLog.to((String)LOG_TYPE_ID).info("NO se encuentra el valor del metaDato " + memberPath + ": NO se han obtenido el metaDatos especificos en el DCR\r\nPosibles causas:\r\n\t-El DCR no contiene valores para los metaDatos especificos\r\n\t-La sentencia xpath especificada en la configuracion del metaDato del fichero searchMetaDataStorageConfig.xml no es valida");
                    }
                }
                if (mapClauseIndex > 0 && memberValue != null && ReflectionUtils.isMap(memberValue.getClass())) {
                    memberValue = ((Map)memberValue).get(idxDoc.getLanguage());
                }
            }
            catch (ReflectionException refEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error al acceder al miembro " + memberPath + " :" + refEx.getMessage() + ".Se ignora la linea correspondiente al metaDato en el fichero IDX generado!!!");
            }
        } else {
            R01FLog.to((String)LOG_TYPE_ID).warning("La propiedad <autonomy.idxFieldSrc>" + memberSrc + "</autonomy.idxFieldSrc> para un metaDato especificada en el fichero searchMetaDataStorage.xml que NO tiene el formato correcto!!!");
        }
        if ("contentRispDocumentsInfo".equals(memberPath)) {
            return R01MRispDocument.mapObjectsToJsonString((Map)((Map)memberValue));
        }
        return this._serializeToString(memberValue);
    }

    private String _serializeToString(Object memberValue) {
        String outMemberValueStr = null;
        if (memberValue != null) {
            if (memberValue instanceof String) {
                outMemberValueStr = this._fixStringValue((String)memberValue);
            } else if (memberValue instanceof StringBuffer) {
                outMemberValueStr = this._fixStringValue(((StringBuffer)memberValue).toString());
            } else if (memberValue instanceof java.util.Date) {
                java.util.Date date = (java.util.Date)memberValue;
                outMemberValueStr = DateUtils.getDateFormated((java.util.Date)date, (String)this._nativeDateFormat);
            } else if (memberValue instanceof Date) {
                Date date = (Date)memberValue;
                outMemberValueStr = DateUtils.getDateFormated((java.util.Date)date, (String)this._nativeDateFormat);
            } else if (ReflectionUtils.isMap(memberValue.getClass())) {
                outMemberValueStr = "";
                Map theMap = (Map)memberValue;
                Map.Entry me = null;
                Iterator mIt = theMap.entrySet().iterator();
                while (mIt.hasNext()) {
                    me = mIt.next();
                    outMemberValueStr = outMemberValueStr + "(" + (String)me.getKey() + ";" + me.getValue().toString() + ")" + (mIt.hasNext() ? "," : "");
                }
                outMemberValueStr = this._fixStringValue(outMemberValueStr);
            } else {
                outMemberValueStr = this._fixStringValue(memberValue.toString());
            }
            return outMemberValueStr;
        }
        return null;
    }

    private String _fixStringValue(String theString) {
        return theString.replaceAll("\"", "\\\"");
    }

    private static Properties _obtainAutonomyMemberMappingInfo(String serverOid, String dataStoreOid) throws R01MSearchIndexerException {
        String patternsKey = serverOid + ":" + dataStoreOid;
        if (memberMappingsCache != null && memberMappingsCache.get(patternsKey) != null) {
            return (Properties)memberMappingsCache.get(patternsKey);
        }
        Map theMappings = null;
        try {
            R01MSearchMetaDataStorageConfig searchMetaDataStorageCfg = typoStorageConfigAPI.getSearchMetaDataStorageConfig(serverOid, dataStoreOid);
            theMappings = searchMetaDataStorageCfg.getProperties();
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            throw new R01MSearchIndexerException("Error al cargar la configuraci\u00f3n de almacenamiento de tipos: " + cfgLoadEx.getDetailedMessage(), (Exception)((Object)cfgLoadEx));
        }
        if (theMappings.get("autonomy.DRETITLE") == null) {
            throw new R01MSearchIndexerException("No se ha encontrado el patr\u00f3n 'autonomy.DRETITLE' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (theMappings.get("autonomy.DREFIELD_metaData") == null) {
            throw new R01MSearchIndexerException("No se ha encontrado el patr\u00f3n 'autonomy.DREFIELD_metaData' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (theMappings.get("autonomy.DREFIELD_guides") == null) {
            throw new R01MSearchIndexerException("No se ha encontrado el patr\u00f3n 'autonomy.DREFIELD_guides' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        Properties outProps = new Properties();
        outProps.put("autonomy.DRETITLE", theMappings.get("autonomy.DRETITLE"));
        outProps.put("autonomy.DREFIELD_metaData", theMappings.get("autonomy.DREFIELD_metaData"));
        outProps.put("autonomy.DREFIELD_guides", theMappings.get("autonomy.DREFIELD_guides"));
        if (memberMappingsCache == null) {
            memberMappingsCache = new HashMap();
        }
        memberMappingsCache.put(patternsKey, outProps);
        return outProps;
    }

    private void _mergeBufferStringMaps(Map<String, StringBuffer> originalMap, Map<String, StringBuffer> mapToAppend) {
        for (Map.Entry<String, StringBuffer> me : mapToAppend.entrySet()) {
            if (originalMap.containsKey(me.getKey())) {
                if (originalMap.get(me.getKey()).toString().endsWith("\r\n")) {
                    originalMap.put(me.getKey(), originalMap.get(me.getKey()).append(mapToAppend.get(me.getKey())));
                    continue;
                }
                originalMap.put(me.getKey(), originalMap.get(me.getKey()).append("\r\n").append(mapToAppend.get(me.getKey())));
                continue;
            }
            originalMap.put(me.getKey(), mapToAppend.get(me.getKey()));
        }
    }

    private static void _traceIndex(String objOid, int objType, int action, String errorMsg, String path) {
        if (objType == 1 || objType == 4) {
            switch (action) {
                case 1: {
                    R01KTraceIndexHelper.execAutonomyMetasTraceIndexInit((String)objOid, (String)path);
                    R01KTraceIndexHelper.execAutonomyFullTraceIndexInit((String)objOid);
                    break;
                }
                case 21: {
                    R01KTraceIndexHelper.execAutonomyFullTraceIndexEndErr((String)objOid, (String)errorMsg);
                    break;
                }
                case 22: {
                    R01KTraceIndexHelper.execAutonomyMetasTraceIndexEndErr((String)objOid, (String)errorMsg);
                    break;
                }
                case 3: {
                    R01KTraceIndexHelper.execAutonomyFullTraceIndexEnd((String)objOid);
                    R01KTraceIndexHelper.execAutonomyMetasTraceIndexEnd((String)objOid);
                    break;
                }
                case 41: {
                    R01KTraceIndexHelper.execAutonomyFullCheckIndexOK((String)objOid);
                    break;
                }
                case 42: {
                    R01KTraceIndexHelper.execAutonomyMetasCheckIndexOK((String)objOid);
                    break;
                }
            }
        } else if (objType == 0) {
            try {
                R01MContent theContent = R01MClientFactory.getContentModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext()).loadContent(objOid);
                if (theContent.getDocuments() != null && !theContent.getDocuments().isEmpty()) {
                    for (String documentOid : theContent.getDocuments().keySet()) {
                        switch (action) {
                            case 1: {
                                R01KTraceIndexHelper.execAutonomyMetasTraceIndexInit((String)documentOid, (String)(path + "/" + theContent.getDocument(documentOid).getInternalName()));
                                R01KTraceIndexHelper.execAutonomyFullTraceIndexInit((String)documentOid);
                                break;
                            }
                            case 21: {
                                R01KTraceIndexHelper.execAutonomyFullTraceIndexEndErr((String)documentOid, (String)errorMsg);
                                break;
                            }
                            case 22: {
                                R01KTraceIndexHelper.execAutonomyMetasTraceIndexEndErr((String)documentOid, (String)errorMsg);
                                break;
                            }
                            case 3: {
                                R01KTraceIndexHelper.execAutonomyFullTraceIndexEnd((String)documentOid);
                                R01KTraceIndexHelper.execAutonomyMetasTraceIndexEnd((String)documentOid);
                                break;
                            }
                            case 41: {
                                R01KTraceIndexHelper.execAutonomyFullCheckIndexOK((String)documentOid);
                                break;
                            }
                            case 42: {
                                R01KTraceIndexHelper.execAutonomyMetasCheckIndexOK((String)documentOid);
                                break;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private static boolean _testAutonomy(String objectOid, int action, int objType, boolean checkDIHMetas) throws R01MSearchIndexerException {
        String uriCheckIDOL2;
        String uriCheckIDOL1;
        if (checkDIHMetas) {
            uriCheckIDOL1 = IDOLMETAS_URI_NODE1;
            uriCheckIDOL2 = IDOLMETAS_URI_NODE2;
        } else {
            uriCheckIDOL1 = IDOLFULL_URI_NODE1;
            uriCheckIDOL2 = IDOLFULL_URI_NODE2;
        }
        String dreReference = R01KTraceIndexHelper.readAutonomyDREReference((String)objectOid);
        String returnData = R01KAutonomyIndexer.readContentIdx(uriCheckIDOL1, dreReference);
        boolean isIndexedOK = false;
        if (returnData != null) {
            isIndexedOK = R01KAutonomyIndexer.chekIndexUnindexHttpImpl(returnData, objectOid, action, objType, checkDIHMetas);
        }
        if (isIndexedOK && (returnData = R01KAutonomyIndexer.readContentIdx(uriCheckIDOL2, dreReference)) != null) {
            isIndexedOK = R01KAutonomyIndexer.chekIndexUnindexHttpImpl(returnData, objectOid, action, objType, checkDIHMetas);
        }
        return isIndexedOK;
    }

    public static String readContentIdx(String dahUriNode, String dreReference) {
        String autonomyXMLResponse = "";
        StringBuffer indexURL = new StringBuffer();
        indexURL.append(dahUriNode);
        indexURL.append("/action=getcontent&reference=");
        indexURL.append(dreReference);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Checking if content is indexed on " + indexURL);
        }
        HttpClient httpClient = new HttpClient(indexURL.toString());
        InputStream serverReturnStream = null;
        try {
            serverReturnStream = httpClient.sendGetHttpCall();
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("El resultado de la indexaci\u00f3n para " + indexURL + " es:");
            }
            if (serverReturnStream != null) {
                autonomyXMLResponse = IOUtils.toString((InputStream)serverReturnStream);
            } else if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("null");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.out);
            autonomyXMLResponse = "";
        }
        return autonomyXMLResponse;
    }

    private static boolean chekIndexUnindexHttpImpl(String returnData, String objectOid, int action, int objType, boolean checkDIHMetas) throws R01MSearchIndexerException {
        Pattern pattern;
        Matcher matcher;
        boolean responseError = false;
        boolean responseSuccess = false;
        if (StringUtils.isEmptyString((String)returnData)) {
            if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                if (checkDIHMetas) {
                    R01KAutonomyIndexer._traceIndex(objectOid, objType, 22, "Autonomy ha devuelto null.", "");
                } else {
                    R01KAutonomyIndexer._traceIndex(objectOid, objType, 21, "Autonomy ha devuelto null.", "");
                }
            }
            return false;
        }
        String patternStr = "<response>(.*)</response>";
        if (returnData.indexOf("<response>") > 0 && (matcher = (pattern = Pattern.compile(patternStr)).matcher(returnData)).find()) {
            if (matcher.group(1).equals("ERROR")) {
                responseError = true;
            } else if (matcher.group(1).equals("SUCCESS")) {
                responseSuccess = true;
            }
        }
        if (action == 1) {
            if (responseError) {
                if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                    if (checkDIHMetas) {
                        R01KAutonomyIndexer._traceIndex(objectOid, objType, 42, "", "");
                    } else {
                        R01KAutonomyIndexer._traceIndex(objectOid, objType, 41, "", "");
                    }
                }
                return true;
            }
            if (responseSuccess) {
                if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                    if (checkDIHMetas) {
                        R01KAutonomyIndexer._traceIndex(objectOid, objType, 22, "Autonomy deber\u00eda tener desindexados los datos.", "");
                    } else {
                        R01KAutonomyIndexer._traceIndex(objectOid, objType, 21, "Autonomy deber\u00eda tener desindexados los datos.", "");
                    }
                }
            } else if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                if (checkDIHMetas) {
                    R01KAutonomyIndexer._traceIndex(objectOid, objType, 22, "Error en la consulta sobre Autonomy.", "");
                } else {
                    R01KAutonomyIndexer._traceIndex(objectOid, objType, 21, "Error en la consulta sobre Autonomy.", "");
                }
            }
            return false;
        }
        if (responseSuccess) {
            String publicationDateInMilliSeconds = "0";
            try {
                Pattern pattern2;
                Matcher matcher2;
                patternStr = "<DREDATE>[^0-9]*([0-9]+)[^0-9]*</DREDATE>";
                if (returnData.indexOf("<DREDATE>") > 0 && (matcher2 = (pattern2 = Pattern.compile(patternStr)).matcher(returnData)).find()) {
                    publicationDateInMilliSeconds = matcher2.group(1) + "000";
                }
            }
            catch (Exception e) {
                String errorMsg = "Error al tratar el XML de autonomy para el objeto " + objectOid + ".Error:" + e.getMessage();
                if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                    if (checkDIHMetas) {
                        R01KAutonomyIndexer._traceIndex(objectOid, objType, 22, errorMsg, "");
                    } else {
                        R01KAutonomyIndexer._traceIndex(objectOid, objType, 21, errorMsg, "");
                    }
                }
                throw new R01MSearchIndexerException(errorMsg);
            }
            long millisecondsOnIDX = 0L;
            if (!NumberUtils.isLong((String)publicationDateInMilliSeconds)) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("El objeto " + objectOid + " no tiene una fecha de publicaci\u00f3n en AUTONOMY.");
                }
                if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                    if (checkDIHMetas) {
                        R01KAutonomyIndexer._traceIndex(objectOid, objType, 22, "El objeto " + objectOid + " no tiene una fecha de publicaci\u00f3n en AUTONOMY.", "");
                    } else {
                        R01KAutonomyIndexer._traceIndex(objectOid, objType, 21, "El objeto " + objectOid + " no tiene una fecha de publicaci\u00f3n en AUTONOMY.", "");
                    }
                }
                return false;
            }
            millisecondsOnIDX = Long.parseLong(publicationDateInMilliSeconds);
            boolean isPublished = false;
            List publications = null;
            String objName = "";
            if (objType == 1) {
                R01MDocument currDocument;
                try {
                    currDocument = R01MClientFactory.getContentModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext()).loadDocument(objectOid);
                }
                catch (R01MSecurityException ex) {
                    String errorMsg = "Error de seguridad al cargar el documento " + objectOid + ".Error:" + ex.getMessage();
                    if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                        if (checkDIHMetas) {
                            R01KAutonomyIndexer._traceIndex(objectOid, objType, 22, errorMsg, "");
                        } else {
                            R01KAutonomyIndexer._traceIndex(objectOid, objType, 21, errorMsg, "");
                        }
                    }
                    R01FLog.to((String)LOG_TYPE_ID).warning(errorMsg);
                    throw new R01MSearchIndexerException(errorMsg);
                }
                catch (R01MContentModelException ex) {
                    String errorMsg = "Error alcargar el documento " + objectOid + ".Error:" + ex.getMessage();
                    if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                        if (checkDIHMetas) {
                            R01KAutonomyIndexer._traceIndex(objectOid, objType, 22, errorMsg, "");
                        } else {
                            R01KAutonomyIndexer._traceIndex(objectOid, objType, 21, errorMsg, "");
                        }
                    }
                    R01FLog.to((String)LOG_TYPE_ID).warning(errorMsg);
                    throw new R01MSearchIndexerException(errorMsg);
                }
                try {
                    isPublished = currDocument.isPublishedInAnyRepository();
                }
                catch (Exception ex) {
                    String errorMsg = "Error al validar si el documento " + currDocument.getInternalName() + " est\u00e1 publicado.Error:" + ex.getMessage();
                    if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                        if (checkDIHMetas) {
                            R01KAutonomyIndexer._traceIndex(objectOid, objType, 22, errorMsg, "");
                        } else {
                            R01KAutonomyIndexer._traceIndex(objectOid, objType, 21, errorMsg, "");
                        }
                    }
                    R01FLog.to((String)LOG_TYPE_ID).warning(errorMsg);
                    throw new R01MSearchIndexerException(errorMsg);
                }
                publications = currDocument.getPublicationInfo();
                objName = currDocument.getInternalName();
            } else if (objType == 4) {
                R01MPage currPage;
                try {
                    currPage = R01MClientFactory.getPortalModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext(), null).loadPortalPage(objectOid);
                }
                catch (R01MSecurityException ex) {
                    String errorMsg = "Error de seguridad al cargar la p\u00e1gina " + objectOid + ".Error:" + ex.getMessage();
                    if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                        if (checkDIHMetas) {
                            R01KAutonomyIndexer._traceIndex(objectOid, objType, 22, errorMsg, "");
                        } else {
                            R01KAutonomyIndexer._traceIndex(objectOid, objType, 21, errorMsg, "");
                        }
                    }
                    R01FLog.to((String)LOG_TYPE_ID).warning(errorMsg);
                    throw new R01MSearchIndexerException(errorMsg);
                }
                catch (R01MPortalModelException ex) {
                    String errorMsg = "Error alcargar la p\u00e1gina " + objectOid + ".Error:" + ex.getMessage();
                    if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                        if (checkDIHMetas) {
                            R01KAutonomyIndexer._traceIndex(objectOid, objType, 22, errorMsg, "");
                        } else {
                            R01KAutonomyIndexer._traceIndex(objectOid, objType, 21, errorMsg, "");
                        }
                    }
                    R01FLog.to((String)LOG_TYPE_ID).warning(errorMsg);
                    throw new R01MSearchIndexerException(errorMsg);
                }
                try {
                    isPublished = currPage.isPublishedInAnyRepository();
                }
                catch (Exception ex) {
                    String errorMsg = "Error al validar si la p\u00e1gina " + currPage.getInternalName() + " est\u00e1 publicada.Error:" + ex.getMessage();
                    if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                        if (checkDIHMetas) {
                            R01KAutonomyIndexer._traceIndex(objectOid, objType, 22, errorMsg, "");
                        } else {
                            R01KAutonomyIndexer._traceIndex(objectOid, objType, 21, errorMsg, "");
                        }
                    }
                    R01FLog.to((String)LOG_TYPE_ID).warning(errorMsg);
                    throw new R01MSearchIndexerException(errorMsg);
                }
                publications = currPage.getPublicationInfo();
                objName = currPage.getInternalName();
            }
            if (isPublished && publications != null) {
                long millisecondsOnDatabase = 0L;
                if (objType == 1) {
                    for (R01MDocumentPublicationTarget pub : publications) {
                        if (pub.getState() != 1) continue;
                        String dateOnMillis = "" + DateUtils.getDateAsMillis((java.util.Date)pub.getPublishDate());
                        dateOnMillis = dateOnMillis.substring(0, dateOnMillis.length() - 3) + "000";
                        millisecondsOnDatabase = Long.parseLong(dateOnMillis);
                    }
                } else if (objType == 4) {
                    for (R01MDocumentPublicationTarget pub : publications) {
                        if (pub.getState() != 1) continue;
                        String dateOnMillis = "" + DateUtils.getDateAsMillis((java.util.Date)pub.getPublishDate());
                        dateOnMillis = dateOnMillis.substring(0, dateOnMillis.length() - 3) + "000";
                        millisecondsOnDatabase = Long.parseLong(dateOnMillis);
                    }
                }
                if (millisecondsOnIDX != 0L && millisecondsOnIDX != millisecondsOnDatabase) {
                    StringBuffer idxCompareFail = new StringBuffer();
                    idxCompareFail.append("DISTINTOS $$$$$$ fecha en Autonomy (");
                    idxCompareFail.append(R01MDateUtils.dateTimeSecondsToStr((java.util.Date)new java.util.Date(millisecondsOnIDX), (String)"es"));
                    idxCompareFail.append(" (");
                    idxCompareFail.append(millisecondsOnIDX);
                    idxCompareFail.append(" msecs)) - Fecha r01d (");
                    idxCompareFail.append(R01MDateUtils.dateTimeSecondsToStr((java.util.Date)new java.util.Date(millisecondsOnDatabase), (String)"es"));
                    idxCompareFail.append(" (");
                    idxCompareFail.append(millisecondsOnDatabase);
                    idxCompareFail.append(" msecs)).\n");
                    if (DEBUG) {
                        String errorMsg = "El objeto " + objName + " tiene fechas distintas en AUTONOMY y en la Base de datos del Gestor de Contenidos." + idxCompareFail.toString();
                        R01FLog.to((String)LOG_TYPE_ID).info(errorMsg);
                        if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                            if (checkDIHMetas) {
                                R01KAutonomyIndexer._traceIndex(objectOid, objType, 22, errorMsg, "");
                            } else {
                                R01KAutonomyIndexer._traceIndex(objectOid, objType, 21, errorMsg, "");
                            }
                        }
                    }
                    return false;
                }
                if (millisecondsOnIDX == 0L) {
                    if (DEBUG) {
                        String errorMsg = "El objeto " + objName + " no tiene una fecha de publicaci\u00f3n indexada en AUTONOMY.";
                        R01FLog.to((String)LOG_TYPE_ID).info(errorMsg);
                        if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                            if (checkDIHMetas) {
                                R01KAutonomyIndexer._traceIndex(objectOid, objType, 22, errorMsg, "");
                            } else {
                                R01KAutonomyIndexer._traceIndex(objectOid, objType, 21, errorMsg, "");
                            }
                        }
                    }
                    return false;
                }
            }
        } else {
            if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                if (checkDIHMetas) {
                    R01KAutonomyIndexer._traceIndex(objectOid, objType, 22, "El objeto NO est\u00e1 indexado.", "");
                } else {
                    R01KAutonomyIndexer._traceIndex(objectOid, objType, 21, "El objeto NO est\u00e1 indexado.", "");
                }
            }
            return false;
        }
        if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
            if (checkDIHMetas) {
                R01KAutonomyIndexer._traceIndex(objectOid, objType, 42, null, "");
            } else {
                R01KAutonomyIndexer._traceIndex(objectOid, objType, 41, null, "");
            }
        }
        return true;
    }
}

