/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01k.searchorchestrator.indexer.indexers;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.NumberUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01k.searchorchestrator.indexer.indexers.R01KIDXProcessor;
import com.ejie.r01k.searchorchestrator.indexer.indexers.R01KSearchEngineIndexer;
import com.ejie.r01k.traceindex.R01KTraceIndexHelper;
import com.ejie.r01m.config.objects.searchengine.R01MSearchSource;
import com.ejie.r01m.config.objects.searchengine.R01MSearchSourceIndexer;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MMetaDataStorageConfig;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MSearchMetaDataStorageConfig;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MSearchIndexerException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.searchengine.indexer.R01MBaseIndexableObject;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableContent;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableDataFile;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableDocument;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableGeoCatalog;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableMetaData;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexablePortalPage;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexablePublicationInfo;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableStructureCatalog;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MSearchMetaDataStorageConfigAPI;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class R01KApacheMetaVarsIndexer
implements R01KSearchEngineIndexer {
    private static final transient String REG_EX = "(CONTENT|DOCUMENT|DOCUMENT_DATAFILES|DOCUMENT_MAINDATAFILE|METADATA)\\.(.*)";
    private static final transient String VAR_LINE_PATTERN = "<!--#set var=\"$varName$\" value=\"$varValue$\" -->";
    private static final transient String META_LINE_PATTERN = "<meta name=\"$varName$\" content=\"$varValue$\" />";
    private static final String LOG_TYPE_ID = "r01k.index";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01k.index").intValue() != Level.OFF.intValue();
    private static final String CONTENT_PREFIX = "contentObject";
    private static final String DEFAULT_APACHE_VAR_FILENAME = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"indexerManager/defaultApacheVarFile", (String)"r01ContVars.content.shtml");
    private static final String DEFAULT_APACHE_META_FILENAME = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"indexerManager/defaultApacheMetaFile", (String)"r01ContMetas.content.inc");
    private static final String DEFAULT_IDX_NAME = XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"indexerContents/defaultIdxFile", (String)"metadata.idx");
    private static final String STRUCTURE_TEMAS = "r01e00000fe4e6676dda470b898e584a4a1047312";
    private static final String STRUCTURE_DEPARTAMENTO = "r01e00000fe4e6676dda470b8deed65c9bfe02f4c";
    private static Map memberMappingsCache = new HashMap();
    private static int indexerType = R01KSearchEngineIndexer.DOCUMENT_TYPE_INDEXER;
    private transient Properties _props = null;
    private static R01MSearchMetaDataStorageConfigAPI typoStorageConfigAPI = R01MClientFactory.getSearchMetaDataStorageConfigAPI();

    public R01KApacheMetaVarsIndexer() {
    }

    public R01KApacheMetaVarsIndexer(Properties props) {
        this();
        this._props = props;
    }

    @Override
    public void setNativeDateFormat(String dateFormat) {
    }

    @Override
    public String getNativeDateFormat() {
        return null;
    }

    @Override
    public void setProperties(Properties props) {
        this._props = props;
    }

    @Override
    public Properties getProperties() {
        return this._props;
    }

    @Override
    public int getIndexerType() {
        return indexerType;
    }

    @Override
    public void index(String systemId, R01MBaseIndexableObject idxObj, int objType, List<String> metadataFileNames, Properties props) throws R01MSearchIndexerException {
        String traceObjOid;
        if (idxObj == null) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Se ha intentado indexar un objeto NULO!!!");
            return;
        }
        switch (objType) {
            case 0: 
            case 1: {
                if (props != null && props.containsKey("objectOid")) {
                    traceObjOid = props.getProperty("objectOid").toString();
                    break;
                }
                traceObjOid = idxObj.getOid();
                break;
            }
            case 4: {
                traceObjOid = idxObj.getOid();
                break;
            }
            default: {
                throw new R01MSearchIndexerException("El tipo de objeto " + objType + " NO es valido para su indexacion en BD");
            }
        }
        if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
            this._traceIndex(traceObjOid, objType, 1, "");
        }
        if (objType == 0 || objType == 1 || objType == 4) {
            block48: {
                Map md;
                R01MIndexableContent idxCont = (R01MIndexableContent)idxObj;
                if (idxCont.getStorage() == null || idxCont.getTypo() == null) {
                    String errorMsg = "Se ha intentado indexar un contenido que no tiene almacenamiento o tipolog\u00eda!!";
                    R01FLog.to((String)LOG_TYPE_ID).severe(errorMsg);
                    if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                        this._traceIndex(traceObjOid, objType, 2, errorMsg);
                    }
                    return;
                }
                if (idxCont.getStorage() == null || idxCont.getStorage().getServer() == null || idxCont.getStorage().getServer().getOid() == null || idxCont.getStorage().getDataStore() == null || idxCont.getStorage().getDataStore().getOid() == null) {
                    String errorMsg = "No se puede obtener el fichero .idx para autonomy ya que el contenido indexable suministrado NO contiene informaci\u00f3n de almacenamiento suficiente: al menos han de llegar el servidor y dataStore!!!";
                    if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                        this._traceIndex(traceObjOid, objType, 2, errorMsg);
                    }
                    throw new R01MSearchIndexerException(errorMsg);
                }
                Properties autonomyMappings = R01KApacheMetaVarsIndexer._obtainAutonomyMemberMappingInfo(idxCont.getStorage().getServer().getOid(), idxCont.getStorage().getDataStore().getOid());
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("APACHE INDEXER > Componer los elementos del fichero idx");
                }
                HashMap<String, StringBuffer> idxFilesLines = new HashMap<String, StringBuffer>();
                if (idxCont.getDocuments() == null) {
                    R01FLog.to((String)LOG_TYPE_ID).warning("APACHE INDEXER > El contenido no tiene documentos, as\u00ed que no se genera fichero de indexacion en apache");
                    if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                        this._traceIndex(traceObjOid, objType, 3, "");
                    }
                    return;
                }
                try {
                    md = this._getMetadataStorageConfigMap(idxCont);
                }
                catch (R01MConfigLoadException clEx) {
                    String errorMsg = "Error al cargar la configuraci\u00f3n de metadatos para el storage del contenido " + idxCont.getOid() + ": " + clEx.getMessage();
                    R01FLog.to((String)LOG_TYPE_ID).severe(errorMsg);
                    if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                        this._traceIndex(traceObjOid, objType, 2, errorMsg);
                    }
                    return;
                }
                ArrayList<Object> documentsToIndex = new ArrayList<Object>();
                if (objType == 1) {
                    documentsToIndex.add(idxCont.getDocument((String)props.get("objectOid")));
                } else if (objType == 0 || objType == 4) {
                    documentsToIndex.addAll(idxCont.getDocuments().values());
                }
                for (R01MIndexableDocument r01MIndexableDocument : documentsToIndex) {
                    block47: {
                        for (Map.Entry<Object, Object> me : autonomyMappings.entrySet()) {
                            Pattern pp;
                            Matcher mm;
                            boolean valid;
                            String currPropName = (String)me.getKey();
                            String currPropValue = (String)me.getValue();
                            if (DEBUG) {
                                R01FLog.to((String)LOG_TYPE_ID).info("\telemento de la configuracion de searchMetaDataStorage.xml <" + currPropName + ">" + (currPropValue != null ? currPropValue : "") + "</" + currPropName + ">");
                            }
                            if (valid = (mm = (pp = Pattern.compile("autonomy.(DRE[^_]*)(_(metaData|VAR_|META_.*))?")).matcher(currPropName)).find()) {
                                String dreSubField = mm.group(3);
                                if (dreSubField != null && dreSubField.equalsIgnoreCase("metaData")) {
                                    this._mergeBufferStringMaps(idxFilesLines, this._composeMetaDataApacheDocumentVarsLines(idxCont, r01MIndexableDocument, md, metadataFileNames));
                                    continue;
                                }
                                if (dreSubField != null && dreSubField.startsWith("VAR_")) {
                                    this._mergeBufferStringMaps(idxFilesLines, this._composeMiscApacheMetaVarsLines(dreSubField.substring("VAR_".length()), currPropValue, idxCont, r01MIndexableDocument, metadataFileNames, VAR_LINE_PATTERN));
                                    continue;
                                }
                                if (dreSubField != null && dreSubField.startsWith("META_")) {
                                    this._mergeBufferStringMaps(idxFilesLines, this._composeMiscApacheMetaVarsLines(dreSubField.substring("META_".length()), currPropValue, idxCont, r01MIndexableDocument, metadataFileNames, META_LINE_PATTERN));
                                    continue;
                                }
                                if (dreSubField == null) continue;
                                R01FLog.to((String)LOG_TYPE_ID).severe("Patron de metadato no reconocido en el fichero searchMetaDataStorage.xml: " + dreSubField);
                                continue;
                            }
                            R01FLog.to((String)LOG_TYPE_ID).warning("Hay un error en las lineas del fichero IDX definidas en el fichero searchMetaDataStorage.xml: La propiedad debe seguir el patr\u00f3n autonomy.DRE[fieldName](_[subFieldName])opt");
                        }
                        if (objType == 4) {
                            StringBuffer linesBuffer = (StringBuffer)idxFilesLines.get(DEFAULT_APACHE_VAR_FILENAME);
                            String idxLine = "";
                            Iterator itLanguages = ((R01MIndexablePortalPage)idxObj).getDocuments().entrySet().iterator();
                            while (itLanguages.hasNext()) {
                                R01MIndexableDocument docIdx = (R01MIndexableDocument)itLanguages.next().getValue();
                                idxLine = StringUtils.replaceString((String)VAR_LINE_PATTERN, (String)"$varName$", (String)("r01_page_" + docIdx.getLanguage()));
                                idxLine = StringUtils.replaceString((String)idxLine, (String)"$varValue$", (String)("/" + docIdx.getInternalName() + "/" + docIdx.getLanguage()));
                                linesBuffer.append(idxLine + "\r\n");
                                if (StringUtils.isEmptyString((String)docIdx.getMainFriendlyURL())) continue;
                                idxLine = StringUtils.replaceString((String)VAR_LINE_PATTERN, (String)"$varName$", (String)("r01_page_friendly_" + docIdx.getLanguage()));
                                idxLine = StringUtils.replaceString((String)idxLine, (String)"$varValue$", (String)docIdx.getMainFriendlyURL());
                                linesBuffer.append(idxLine + "\r\n");
                            }
                        }
                        if (this._props == null || this._props.get("processorClass") == null) {
                            String theContext = R01MSearchEngineUtils.obtainContext((String)XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"searchEngine/defaultSearchEngineContext"), null);
                            Map searchSources = null;
                            try {
                                searchSources = R01MClientFactory.getSearchEngineConfigAPI().getSearchEngineConfig().getSearchSources(theContext);
                            }
                            catch (R01MConfigLoadException cfgLoadEx) {
                                R01FLog.to((String)LOG_TYPE_ID).warning("R01KSearchOrchestratorIndexer._loadIndexers > Error al recoger la configuraci\u00f3n del motor de b\u00fasqueda para recoger los indexadores comunes. Error:" + cfgLoadEx.getMessage());
                            }
                            for (R01MSearchSource currentSearchSource : searchSources.values()) {
                                if (currentSearchSource.getIndexers() == null) continue;
                                for (R01MSearchSourceIndexer currentIndexer : currentSearchSource.getIndexers()) {
                                    if (!currentIndexer.getImplClassName().equalsIgnoreCase("com.ejie.r01k.searchorchestrator.indexer.indexers.R01KApacheMetaVarsIndexer") || currentIndexer.getProperties() == null) continue;
                                    Properties properties = new Properties();
                                    properties.clear();
                                    properties.putAll((Map<?, ?>)currentIndexer.getProperties());
                                    this.setProperties(properties);
                                    break;
                                }
                                if (this._props == null) continue;
                                break;
                            }
                        }
                        if (!idxFilesLines.isEmpty() && this._props != null && this._props.get("processorClass") != null) {
                            try {
                                R01KIDXProcessor processor = (R01KIDXProcessor)ReflectionUtils.getObjectInstance((String)((String)this._props.get("processorClass")));
                                processor.setProperties(this._props);
                                processor.processIndexData(idxCont, r01MIndexableDocument, idxFilesLines);
                            }
                            catch (ReflectionException refEx) {
                                refEx.printStackTrace(System.err);
                                String errorMsg = "Error al procesar el idx de autonomy: " + refEx.getMessage();
                                R01FLog.to((String)LOG_TYPE_ID).severe("Error al procesar el idx de autonomy: " + refEx.getMessage());
                                if (!R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) break block47;
                                this._traceIndex(r01MIndexableDocument.getOid(), 1, 2, errorMsg);
                            }
                        }
                    }
                    idxFilesLines.clear();
                }
                for (Map.Entry<Object, Object> entry : autonomyMappings.entrySet()) {
                    Pattern pp;
                    Matcher mm;
                    boolean valid;
                    String currPropName = (String)entry.getKey();
                    String currPropValue = (String)entry.getValue();
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("\telemento de la configuracion de searchMetaDataStorage.xml <" + currPropName + ">" + (currPropValue != null ? currPropValue : "") + "</" + currPropName + ">");
                    }
                    if (valid = (mm = (pp = Pattern.compile("autonomy.(DRE[^_]*)(_(metaData|VAR_|META_.*))?")).matcher(currPropName)).find()) {
                        String dreSubField = mm.group(3);
                        if (dreSubField == null || !dreSubField.equalsIgnoreCase("metaData")) continue;
                        this._mergeBufferStringMaps(idxFilesLines, this._composeMetaDataApacheContentVarsLines(idxCont));
                        continue;
                    }
                    R01FLog.to((String)LOG_TYPE_ID).warning("Hay un error en las lineas del fichero IDX definidas en el fichero searchMetaDataStorage.xml: La propiedad debe seguir el patr\u00f3n autonomy.DRE[fieldName](_[subFieldName])opt");
                }
                if (!idxFilesLines.isEmpty() && this._props != null && this._props.get("processorClass") != null) {
                    try {
                        R01KIDXProcessor processor = (R01KIDXProcessor)ReflectionUtils.getObjectInstance((String)((String)this._props.get("processorClass")));
                        processor.setProperties(this._props);
                        processor.processIndexData(idxCont, null, idxFilesLines);
                    }
                    catch (ReflectionException reflectionException) {
                        reflectionException.printStackTrace(System.err);
                        String errorMsg = "Error al procesar el idx de autonomy: " + reflectionException.getMessage();
                        R01FLog.to((String)LOG_TYPE_ID).severe(errorMsg);
                        if (!R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) break block48;
                        this._traceIndex(traceObjOid, objType, 2, errorMsg);
                    }
                }
            }
            if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
                this._traceIndex(traceObjOid, objType, 3, "");
            }
        } else if (objType != 4) {
            R01FLog.to((String)LOG_TYPE_ID).severe("APACHE INDEXER > NO se puede indexar un objeto tipo " + R01MConstants.OBJECT_DESCS[objType]);
        }
    }

    @Override
    public void unIndex(String systemId, String objectOid, int objectType, boolean traceIndex) throws R01MSearchIndexerException {
        if (objectType != 1 && objectType != 0 && this._props != null && this._props.get("processorClass") != null && objectType == 4) {
            ArrayList<String> filesToDelete = new ArrayList<String>();
            R01MIndexablePortalPage idxPage = null;
            try {
                idxPage = R01MClientFactory.getPortalModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext(), null).preparePageToBeIndexed(objectOid);
                if (traceIndex) {
                    this._traceIndex(objectOid, objectType, 1, "");
                }
            }
            catch (R01MSecurityException secExc) {
                String errorMsg = "No se puede acceder al gestor de contenidos. Error:" + secExc.getMessage();
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("unIndex >> " + errorMsg + "\r\n");
                }
                if (traceIndex) {
                    this._traceIndex(objectOid, objectType, 2, errorMsg);
                }
                return;
            }
            catch (R01MPortalModelException pmExc) {
                String errorMsg = "Error al cargar la pagina de portal de oid " + objectOid + ". Error:" + pmExc.getMessage();
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("unIndex >> " + errorMsg + "\r\n");
                }
                if (traceIndex) {
                    this._traceIndex(objectOid, objectType, 2, errorMsg);
                }
                return;
            }
            if (idxPage == null) {
                String errorMsg = "No existe la p\u00e1gina, as\u00ed que no se desindexan ficheros para la indexaci\u00f3n de apache.";
                R01FLog.to((String)LOG_TYPE_ID).warning("APACHE INDEXER > " + errorMsg);
                if (traceIndex) {
                    this._traceIndex(objectOid, objectType, 2, errorMsg);
                }
                return;
            }
            if (idxPage.getDocuments() == null) {
                String errorMsg = "La p\u00e1gina no tiene idiomas, as\u00ed que no se desindexan ficheros para la indexaci\u00f3n de apache.";
                R01FLog.to((String)LOG_TYPE_ID).warning("APACHE INDEXER > " + errorMsg);
                if (traceIndex) {
                    this._traceIndex(objectOid, objectType, 2, errorMsg);
                }
                return;
            }
            if (idxPage.getStorage() == null || idxPage.getStorage().getServer() == null || idxPage.getStorage().getServer().getOid() == null || idxPage.getStorage().getDataStore() == null || idxPage.getStorage().getDataStore().getOid() == null) {
                String errorMsg = "No se puede obtener el fichero .idx para autonomy ya que la p\u00e1gina indexable suministrada NO contiene informaci\u00f3n de almacenamiento suficiente: al menos han de llegar el servidor y dataStore!!!";
                if (traceIndex) {
                    this._traceIndex(objectOid, objectType, 2, errorMsg);
                }
                throw new R01MSearchIndexerException(errorMsg);
            }
            Properties autonomyMappings = R01KApacheMetaVarsIndexer._obtainAutonomyMemberMappingInfo(idxPage.getStorage().getServer().getOid(), idxPage.getStorage().getDataStore().getOid());
            R01MSearchMetaDataStorageConfig mdStrgCfg = null;
            try {
                mdStrgCfg = typoStorageConfigAPI.getSearchMetaDataStorageConfig(idxPage.getStorage().getServer().getOid(), idxPage.getStorage().getDataStore().getOid());
            }
            catch (R01MConfigLoadException clEx) {
                String errorMsg = "Al desindexar el objeto de OID: " + (objectOid == null ? " [null] " : objectOid) + " de tipo p\u00e1gina de portal[tipo no reconocido]: " + Integer.toString(objectType) + ". Error al cargar la configuracion de metadatos: " + clEx.getMessage();
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).severe(errorMsg);
                }
                if (traceIndex) {
                    this._traceIndex(objectOid, objectType, 2, errorMsg);
                }
                return;
            }
            Map md = mdStrgCfg.getTypeSearchMetaDataStorageCfgs(idxPage.getTypo().getCluster() != null ? idxPage.getTypo().getCluster().getOid() : null, idxPage.getTypo().getFamily() != null ? idxPage.getTypo().getFamily().getOid() : null, idxPage.getTypo().getType() != null ? idxPage.getTypo().getType().getOid() : null);
            if (md == null) {
                R01FLog.to((String)LOG_TYPE_ID).warning("NO se ha encontrado informaci\u00f3n sobre los metaDatos para el tipo cluster:familia:tipo=" + idxPage.getTypo().getCluster().getOid() + ":" + idxPage.getTypo().getFamily().getOid() + ":" + idxPage.getTypo().getType().getOid() + ". REVISA EL FICHERO searchMetaDataStorage.xml");
            }
            Map.Entry<Object, Object> me2 = null;
            String currPropName = null;
            String currPropValue = null;
            String portal = idxPage == null || idxPage.getInternalName() == null ? "  [InternalName de la pagina es null] " : idxPage.getInternalName().substring(0, idxPage.getInternalName().indexOf("-"));
            String basePath = "/" + portal + "/html/pages/data/" + (idxPage == null || idxPage.getInternalName() == null ? "  [InternalName del contenido es null] " : idxPage.getInternalName());
            String idxRelativePath = XMLProperties.getProperty((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"relativeIndexPath/contents", (String)"/r01Index/");
            for (R01MIndexableDocument currPageLangIdx : idxPage.getDocuments().values()) {
                block41: {
                    String defaultFile = DEFAULT_APACHE_META_FILENAME;
                    filesToDelete.add(StringUtils.isEmptyString((String)basePath) ? " [basePath vacio o nulo] " : basePath + (currPageLangIdx != null ? "" : " [pagina es null] - ") + "/" + (currPageLangIdx == null || currPageLangIdx.getInternalName() == null ? " [InternalName de la pagina es null] " : currPageLangIdx.getInternalName()) + idxRelativePath + defaultFile);
                    defaultFile = DEFAULT_APACHE_VAR_FILENAME;
                    filesToDelete.add(StringUtils.isEmptyString((String)basePath) ? " [basePath vacio o nulo] " : basePath + (currPageLangIdx != null ? "" : " [documento es null] - ") + "/" + (currPageLangIdx == null || currPageLangIdx.getInternalName() == null ? " [InternalName del documento es null] " : currPageLangIdx.getInternalName()) + idxRelativePath + defaultFile);
                    for (Map.Entry<Object, Object> me2 : autonomyMappings.entrySet()) {
                        Pattern pp;
                        Matcher mm;
                        boolean valid;
                        currPropName = (String)me2.getKey();
                        currPropValue = (String)me2.getValue();
                        if (DEBUG) {
                            R01FLog.to((String)LOG_TYPE_ID).info("\telemento de la configuracion de searchMetaDataStorage.xml <" + currPropName + ">" + (currPropValue != null ? currPropValue : "") + "</" + currPropName + ">");
                        }
                        if (valid = (mm = (pp = Pattern.compile("autonomy.(DRE[^_]*)(_(metaData))?")).matcher(currPropName)).find()) {
                            String dreSubField = mm.group(3);
                            if (dreSubField != null) {
                                if (!dreSubField.equalsIgnoreCase("metaData")) continue;
                                R01MMetaDataStorageConfig currMDStorageCfg2 = null;
                                String currMDDataTypeDef = null;
                                String currMDAutonomyIdxFile = null;
                                for (R01MMetaDataStorageConfig currMDStorageCfg2 : md.values()) {
                                    String relativePath;
                                    if (!currMDStorageCfg2.isIndexable()) {
                                        if (!DEBUG) continue;
                                        R01FLog.to((String)LOG_TYPE_ID).info("\t\t" + currMDStorageCfg2.getOid() + "[WARNING] El metaDato NO es indexable.");
                                        continue;
                                    }
                                    currMDDataTypeDef = currMDStorageCfg2.getDataType();
                                    if (currMDDataTypeDef == null) {
                                        if (!DEBUG) continue;
                                        R01FLog.to((String)LOG_TYPE_ID).info("\t\t" + currMDStorageCfg2.getOid() + "[WARNING] NO se ha definido la propiedad dataType. NO se indexa\r\n");
                                        continue;
                                    }
                                    currMDAutonomyIdxFile = (String)currMDStorageCfg2.getProperties().get("apache.varFile");
                                    if (StringUtils.isEmptyString((String)currMDAutonomyIdxFile)) {
                                        currMDAutonomyIdxFile = DEFAULT_APACHE_VAR_FILENAME;
                                    }
                                    if (currMDAutonomyIdxFile != null) {
                                        if (currMDAutonomyIdxFile.indexOf(37) >= 0) {
                                            currMDAutonomyIdxFile = StringUtils.replaceVariableValues((String)currMDAutonomyIdxFile, (char)'%', (Map)R01MSearchEngineConstants.PORTAL_TYPE_NAMES);
                                        }
                                        relativePath = "";
                                        if (idxPage instanceof R01MIndexablePortalPage) {
                                            relativePath = (currPageLangIdx != null ? "" : " [pagina es null] - ") + "/" + (currPageLangIdx == null || currPageLangIdx.getInternalName() == null ? " [nombre interno de la pagina es null] " : currPageLangIdx.getInternalName().trim()) + idxRelativePath + (StringUtils.isEmptyString((String)currMDAutonomyIdxFile) ? " [path relativo es null] " : currMDAutonomyIdxFile);
                                        }
                                        if (!filesToDelete.contains((StringUtils.isEmptyString((String)basePath) ? " [basePath vacio o nulo] " : basePath) + (StringUtils.isEmptyString((String)relativePath) ? " [relativePath vacio o nulo] " : relativePath))) {
                                            filesToDelete.add((StringUtils.isEmptyString((String)basePath) ? " [basePath vacio o nulo] " : basePath) + (StringUtils.isEmptyString((String)relativePath) ? " [relativePath vacio o nulo] " : relativePath));
                                        }
                                    }
                                    if (StringUtils.isEmptyString((String)(currMDAutonomyIdxFile = (String)currMDStorageCfg2.getProperties().get("apache.metaFile")))) {
                                        currMDAutonomyIdxFile = DEFAULT_APACHE_META_FILENAME;
                                    }
                                    if (currMDAutonomyIdxFile == null) continue;
                                    if (currMDAutonomyIdxFile.indexOf(37) >= 0) {
                                        currMDAutonomyIdxFile = StringUtils.replaceVariableValues((String)currMDAutonomyIdxFile, (char)'%', (Map)R01MSearchEngineConstants.PORTAL_TYPE_NAMES);
                                    }
                                    relativePath = "";
                                    if (idxPage instanceof R01MIndexablePortalPage) {
                                        relativePath = (currPageLangIdx != null ? "" : " [pagina es null] - ") + "/" + (currPageLangIdx == null || currPageLangIdx.getInternalName() == null ? " [nombre interno de la pagina es null] " : currPageLangIdx.getInternalName().trim()) + idxRelativePath + (StringUtils.isEmptyString((String)currMDAutonomyIdxFile) ? " [path relativo es null] " : currMDAutonomyIdxFile);
                                    }
                                    if (filesToDelete.contains((StringUtils.isEmptyString((String)basePath) ? " [basePath vacio o nulo] " : basePath) + (StringUtils.isEmptyString((String)relativePath) ? " [relativePath vacio o nulo] " : relativePath))) continue;
                                    filesToDelete.add((StringUtils.isEmptyString((String)basePath) ? " [basePath vacio o nulo] " : basePath) + (StringUtils.isEmptyString((String)relativePath) ? " [relativePath vacio o nulo] " : relativePath));
                                }
                                continue;
                            }
                            String idxFileName = "";
                            int firstPointPosition = currPropValue.indexOf(46);
                            if (firstPointPosition > 0 && (idxFileName = currPropValue.substring(0, firstPointPosition) + ".shtml").indexOf(37) >= 0) {
                                idxFileName = StringUtils.replaceVariableValues((String)idxFileName, (char)'%', (Map)R01MSearchEngineConstants.PORTAL_TYPE_NAMES);
                            }
                            if (StringUtils.isEmptyString((String)idxFileName)) continue;
                            String relativePath = "";
                            if (idxPage instanceof R01MIndexablePortalPage) {
                                relativePath = (currPageLangIdx != null ? "" : " [pagina es null] - ") + "/" + (currPageLangIdx == null || currPageLangIdx.getInternalName() == null ? " [nombre interno de la pagina es null] " : currPageLangIdx.getInternalName().trim()) + idxRelativePath + (StringUtils.isEmptyString((String)idxFileName) ? " [path relativo es null] " : idxFileName);
                            }
                            if (filesToDelete.contains((StringUtils.isEmptyString((String)basePath) ? " [basePath vacio o nulo] " : basePath) + (StringUtils.isEmptyString((String)relativePath) ? " [relativePath vacio o nulo] " : relativePath))) continue;
                            filesToDelete.add((StringUtils.isEmptyString((String)basePath) ? " [basePath vacio o nulo] " : basePath) + (StringUtils.isEmptyString((String)relativePath) ? " [relativePath vacio o nulo] " : relativePath));
                            continue;
                        }
                        R01FLog.to((String)LOG_TYPE_ID).warning("Hay un error en las lineas del fichero IDX definidas en el fichero searchMetaDataStorage.xml: La propiedad debe seguir el patr\u00f3n autonomy.DRE[fieldName](_[subFieldName])opt");
                    }
                    if (!filesToDelete.isEmpty()) {
                        try {
                            R01KIDXProcessor processor = (R01KIDXProcessor)ReflectionUtils.getObjectInstance((String)((String)this._props.get("processorClass")));
                            processor.setProperties(this._props);
                            processor.removeIndexData((R01MIndexableContent)idxPage, filesToDelete);
                        }
                        catch (ReflectionException refEx) {
                            refEx.printStackTrace(System.err);
                            String errorMsg = "Error al procesar el idx de autonomy: " + refEx.getMessage();
                            R01FLog.to((String)LOG_TYPE_ID).severe(errorMsg);
                            if (!traceIndex) break block41;
                            this._traceIndex(objectOid, objectType, 2, errorMsg);
                        }
                    }
                }
                filesToDelete.clear();
                if (!traceIndex) continue;
                this._traceIndex(objectOid, objectType, 3, "");
            }
        }
    }

    @Override
    public void unIndex(String systemId, R01MBaseIndexableObject idxObj, String objectOid, int objectType, boolean traceIndex) throws R01MSearchIndexerException {
        this.unIndex(systemId, objectOid, objectType, traceIndex);
    }

    @Override
    public boolean checkIndex(String systemId, String objOid, int objType) throws R01MSearchIndexerException {
        if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
            this._traceIndex(objOid, objType, 4, "");
        }
        return true;
    }

    @Override
    public boolean checkUnIndex(String systemId, String objOid, int objType) throws R01MSearchIndexerException {
        if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
            this._traceIndex(objOid, objType, 4, "");
        }
        return true;
    }

    private Map _getMetadataStorageConfigMap(R01MIndexableContent idxCont) throws R01MConfigLoadException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\t\tSe recoge el mapa de configuraci\u00f3n de storage para metaDatos: cluster:family:type=" + idxCont.getTypo().getCluster().getOid() + ":" + idxCont.getTypo().getFamily().getOid() + ":" + idxCont.getTypo().getType().getOid());
        }
        return typoStorageConfigAPI.getSearchMetaDataStorageConfig(idxCont.getStorage().getServer().getOid(), idxCont.getStorage().getDataStore().getOid()).getTypeSearchMetaDataStorageCfgs(idxCont.getTypo().getCluster() != null ? idxCont.getTypo().getCluster().getOid() : null, idxCont.getTypo().getFamily() != null ? idxCont.getTypo().getFamily().getOid() : null, idxCont.getTypo().getType() != null ? idxCont.getTypo().getType().getOid() : null);
    }

    private Map _composeMetaDataApacheDocumentVarsLines(R01MIndexableContent idxCont, R01MIndexableDocument idxDoc, Map md, List<String> metadataFileNames) {
        HashMap<String, StringBuffer> apacheVarsFilesLines = new HashMap<String, StringBuffer>();
        R01MMetaDataStorageConfig currMDStorageCfg2 = null;
        String currMDapacheVarField = null;
        String currMDataType = null;
        String currMDDataSubType = null;
        String currMDApacheIdxFile = null;
        String currMDAutonomyIdxFile = null;
        for (R01MMetaDataStorageConfig currMDStorageCfg2 : md.values()) {
            StringBuffer mdApacheVarsLines;
            if ((currMDStorageCfg2.getProperty("apache.varName") == null || currMDStorageCfg2.getProperty("apache.varName").length() <= 0) && (currMDStorageCfg2.getProperty("apache.metaName") == null || currMDStorageCfg2.getProperty("apache.metaName").length() <= 0)) continue;
            currMDataType = (String)currMDStorageCfg2.getProperties().get("autonomy.idxFieldType");
            currMDDataSubType = (String)currMDStorageCfg2.getProperties().get("autonomy.idxFieldSubType");
            currMDapacheVarField = (String)currMDStorageCfg2.getProperties().get("autonomy.idxFieldSrc");
            if (StringUtils.isEmptyString((String)currMDataType)) continue;
            if (!(currMDStorageCfg2.getProperty("apache.varName") == null || currMDStorageCfg2.getProperty("apache.varName").length() <= 0 || currMDStorageCfg2.getProperty("apache.isContentVar") != null && currMDStorageCfg2.getProperty("apache.isContentVar").equalsIgnoreCase("true"))) {
                currMDApacheIdxFile = (String)currMDStorageCfg2.getProperties().get("apache.varFile");
                currMDAutonomyIdxFile = (String)currMDStorageCfg2.getProperties().get("autonomy.idxFile");
                if (StringUtils.isEmptyString((String)currMDApacheIdxFile)) {
                    currMDApacheIdxFile = DEFAULT_APACHE_VAR_FILENAME;
                }
                if (StringUtils.isEmptyString((String)currMDAutonomyIdxFile)) {
                    currMDAutonomyIdxFile = DEFAULT_IDX_NAME;
                }
                if (metadataFileNames == null || metadataFileNames.isEmpty() || metadataFileNames.contains(currMDApacheIdxFile) || metadataFileNames.contains(currMDAutonomyIdxFile)) {
                    if (!apacheVarsFilesLines.containsKey(currMDApacheIdxFile)) {
                        apacheVarsFilesLines.put(currMDApacheIdxFile, new StringBuffer(270));
                    }
                    mdApacheVarsLines = (StringBuffer)apacheVarsFilesLines.get(currMDApacheIdxFile);
                    if (!StringUtils.isEmptyString((String)currMDapacheVarField) && currMDataType.equalsIgnoreCase("List") && currMDDataSubType != null) {
                        if ("R01MSearchResultItemPublicationInfo".equals(currMDDataSubType)) {
                            mdApacheVarsLines.append(this._composePublicationTargetsVarsLines(idxDoc));
                        } else {
                            mdApacheVarsLines.append(this._composeMetaVarListLines(idxCont, idxDoc, currMDStorageCfg2, currMDapacheVarField, VAR_LINE_PATTERN));
                        }
                    } else if (!StringUtils.isEmptyString((String)currMDapacheVarField)) {
                        mdApacheVarsLines.append(this._composeMetaVarElementLine(currMDStorageCfg2, idxCont, idxDoc, currMDapacheVarField, currMDataType, currMDDataSubType, currMDStorageCfg2.getProperty("apache.varName"), VAR_LINE_PATTERN));
                    } else if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("Durante la indexaci\u00f3n de variables de apache del documento " + idxDoc == null ? "[null]" : idxDoc.getOid() + " el campo de captura en el metadato " + currMDStorageCfg2.getOid() + " es null (autonomy.idxFieldSrc)");
                    }
                }
            }
            if (currMDStorageCfg2.getProperty("apache.metaName") != null && currMDStorageCfg2.getProperty("apache.metaName").length() > 0) {
                currMDApacheIdxFile = (String)currMDStorageCfg2.getProperties().get("apache.metaFile");
                if (StringUtils.isEmptyString((String)currMDApacheIdxFile)) {
                    currMDApacheIdxFile = DEFAULT_APACHE_META_FILENAME;
                }
                if (metadataFileNames == null || metadataFileNames.isEmpty() || metadataFileNames.contains(currMDApacheIdxFile)) {
                    if (!apacheVarsFilesLines.containsKey(currMDApacheIdxFile)) {
                        apacheVarsFilesLines.put(currMDApacheIdxFile, new StringBuffer(270));
                    }
                    mdApacheVarsLines = (StringBuffer)apacheVarsFilesLines.get(currMDApacheIdxFile);
                    if (currMDataType != null && currMDataType.equalsIgnoreCase("List") && currMDDataSubType != null || currMDapacheVarField.indexOf("urlsByLanguage") > 0 || currMDapacheVarField.indexOf("friendlyUrlsByLanguage") > 0) {
                        mdApacheVarsLines.append(this._composeMetaVarListLines(idxCont, idxDoc, currMDStorageCfg2, currMDapacheVarField, META_LINE_PATTERN));
                    } else {
                        mdApacheVarsLines.append(this._composeMetaVarElementLine(currMDStorageCfg2, idxCont, idxDoc, currMDapacheVarField, currMDataType, currMDDataSubType, currMDStorageCfg2.getProperty("apache.metaName"), META_LINE_PATTERN));
                    }
                }
            }
            if (!"r01ContVars.catalog.shtml".equals(currMDApacheIdxFile)) continue;
            if (!apacheVarsFilesLines.containsKey("r01ContMetas.content.inc")) {
                apacheVarsFilesLines.put("r01ContMetas.content.inc", new StringBuffer(270));
            }
            mdApacheVarsLines = (StringBuffer)apacheVarsFilesLines.get("r01ContMetas.content.inc");
            String currMDapacheVarFieldValue = this._getMemberValue(currMDStorageCfg2, idxCont, idxDoc, currMDapacheVarField);
            String[] structures = currMDapacheVarFieldValue.split(",");
            StringBuffer temasValue = null;
            StringBuffer departValue = null;
            for (int i = 0; i < structures.length; ++i) {
                String[] catalogData;
                String structure;
                String catalogInfo = structures[i];
                if (catalogInfo.length() > 0 && catalogInfo.charAt(0) == '(' && catalogInfo.indexOf(41) > 0) {
                    catalogInfo = catalogInfo.substring(1, catalogInfo.indexOf(41));
                }
                if (STRUCTURE_TEMAS.equals(structure = (catalogData = catalogInfo.split(";"))[0])) {
                    if (temasValue == null) {
                        temasValue = new StringBuffer();
                    } else {
                        temasValue.append(",");
                    }
                    temasValue.append(catalogData[1]);
                    continue;
                }
                if (!STRUCTURE_DEPARTAMENTO.equals(structure)) continue;
                if (departValue == null) {
                    departValue = new StringBuffer();
                } else {
                    departValue.append(",");
                }
                departValue.append(catalogData[1]);
            }
            if (!StringUtils.isEmptyStringBuffer(temasValue)) {
                String line = StringUtils.replaceString((String)META_LINE_PATTERN, (String)"$varName$", (String)"dc.subject");
                line = StringUtils.replaceString((String)line, (String)"$varValue$", (String)this._fixStringValue(temasValue.toString()));
                mdApacheVarsLines.append(line).append("\n");
            }
            if (StringUtils.isEmptyStringBuffer(departValue)) continue;
            String line = StringUtils.replaceString((String)META_LINE_PATTERN, (String)"$varName$", (String)"dc.creator");
            line = StringUtils.replaceString((String)line, (String)"$varValue$", (String)this._fixStringValue(departValue.toString()));
            mdApacheVarsLines.append(line).append("\n");
        }
        if (DEBUG) {
            for (Map.Entry entry : apacheVarsFilesLines.entrySet()) {
                String file = (String)entry.getKey();
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\nFICHERO _composeMetaDataApacheDocumentVarsLines: " + file + "\r\n" + entry.getValue().toString());
            }
        }
        return apacheVarsFilesLines;
    }

    private Map _composeMetaDataApacheContentVarsLines(R01MIndexableContent idxCont) {
        HashMap<String, StringBuffer> apacheVarsFilesLines = new HashMap<String, StringBuffer>();
        R01MSearchMetaDataStorageConfig mdStrgCfg = null;
        try {
            Map md;
            mdStrgCfg = typoStorageConfigAPI.getSearchMetaDataStorageConfig(idxCont.getStorage().getServer().getOid(), idxCont.getStorage().getDataStore().getOid());
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\t\tMetaDatos: cluster:family:type=" + idxCont.getTypo().getCluster().getOid() + ":" + idxCont.getTypo().getFamily().getOid() + ":" + idxCont.getTypo().getType().getOid());
            }
            if ((md = mdStrgCfg.getTypeSearchMetaDataStorageCfgs(idxCont.getTypo().getCluster() != null ? idxCont.getTypo().getCluster().getOid() : null, idxCont.getTypo().getFamily() != null ? idxCont.getTypo().getFamily().getOid() : null, idxCont.getTypo().getType() != null ? idxCont.getTypo().getType().getOid() : null)) == null) {
                R01FLog.to((String)LOG_TYPE_ID).warning("NO se ha encontrado informaci\u00f3n sobre los metaDatos para el tipo cluster:familia:tipo=" + idxCont.getTypo().getCluster().getOid() + ":" + idxCont.getTypo().getFamily().getOid() + ":" + idxCont.getTypo().getType().getOid() + ". REVISA EL FICHERO searchMetaDataStorage.xml");
                return apacheVarsFilesLines;
            }
            R01MMetaDataStorageConfig currMDStorageCfg2 = null;
            String currMDapacheVarField = null;
            String currMDataType = null;
            String currMDDataSubType = null;
            String currMDApacheIdxFile = null;
            for (R01MMetaDataStorageConfig currMDStorageCfg2 : md.values()) {
                if (currMDStorageCfg2.getProperty("apache.varName") == null || currMDStorageCfg2.getProperty("apache.varName").length() <= 0 || currMDStorageCfg2.getProperty("apache.isContentVar") == null || !currMDStorageCfg2.getProperty("apache.isContentVar").equalsIgnoreCase("true")) continue;
                Iterator documentIt = idxCont.getDocuments().entrySet().iterator();
                while (documentIt.hasNext()) {
                    R01MIndexableDocument idxDoc = (R01MIndexableDocument)documentIt.next().getValue();
                    currMDataType = (String)currMDStorageCfg2.getProperties().get("autonomy.idxFieldType");
                    currMDapacheVarField = (String)currMDStorageCfg2.getProperties().get("autonomy.idxFieldSrc");
                    currMDApacheIdxFile = (String)currMDStorageCfg2.getProperties().get("apache.varFile");
                    if (StringUtils.isEmptyString((String)currMDApacheIdxFile)) {
                        currMDApacheIdxFile = DEFAULT_APACHE_VAR_FILENAME;
                    }
                    HashMap<String, String> documentNameMap = new HashMap<String, String>();
                    documentNameMap.put("docName", idxDoc.getLanguage() + "_" + idxDoc.getInternalName());
                    currMDApacheIdxFile = StringUtils.replaceVariableValues((String)currMDApacheIdxFile, (char)'%', documentNameMap);
                    currMDApacheIdxFile = "contentObject." + currMDApacheIdxFile;
                    if (StringUtils.isEmptyString((String)currMDapacheVarField)) continue;
                    if (!apacheVarsFilesLines.containsKey(currMDApacheIdxFile)) {
                        apacheVarsFilesLines.put(currMDApacheIdxFile, new StringBuffer(270));
                    }
                    StringBuffer mdApacheVarsLines = (StringBuffer)apacheVarsFilesLines.get(currMDApacheIdxFile);
                    if (currMDataType != null && currMDataType.equalsIgnoreCase("List") && currMDDataSubType != null || currMDapacheVarField.indexOf("urlsByLanguage") > 0 || currMDapacheVarField.indexOf("friendlyUrlsByLanguage") > 0) {
                        mdApacheVarsLines.append(this._composeMetaVarListLines(idxCont, idxDoc, currMDStorageCfg2, currMDapacheVarField, VAR_LINE_PATTERN));
                        continue;
                    }
                    mdApacheVarsLines.append(this._composeMetaVarElementLine(currMDStorageCfg2, idxCont, null, currMDapacheVarField, currMDataType, currMDDataSubType, currMDStorageCfg2.getProperty("apache.varName"), VAR_LINE_PATTERN));
                }
            }
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            cfgLoadEx.printStackTrace(System.err);
            R01FLog.to((String)LOG_TYPE_ID).warning("Error al obtener la configuraci\u00f3n de almacenamiento de metaDatos para el server:dataStore = " + idxCont.getStorage().getServer().getOid() + ":" + idxCont.getStorage().getDataStore().getOid() + " >> " + cfgLoadEx.getMessage());
        }
        if (DEBUG) {
            for (Map.Entry entry : apacheVarsFilesLines.entrySet()) {
                String file = (String)entry.getKey();
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\nFICHERO _composeMetaDataApacheContentVarsLines: " + file + "\r\n" + entry.getValue().toString());
            }
        }
        return apacheVarsFilesLines;
    }

    private StringBuffer _composeMetaVarListLines(R01MIndexableContent idxCont, R01MIndexableDocument idxDoc, R01MMetaDataStorageConfig mdStorageCfg, String memberSrc, String linePattern) {
        String varName = mdStorageCfg.getProperty("apache.varName");
        String varValue = mdStorageCfg.getProperty("apache.varValue");
        String currMDapacheVarFieldValue = this._getMemberValue(mdStorageCfg, idxCont, idxDoc, memberSrc);
        HashMap<String, String> resultValues = new HashMap<String, String>();
        if (!StringUtils.isEmptyString((String)currMDapacheVarFieldValue)) {
            String[] elements = currMDapacheVarFieldValue.split(",");
            for (int i = 0; i < elements.length; ++i) {
                String element = elements[i];
                if (element.length() > 0 && element.charAt(0) == '(' && element.indexOf(41) > 0) {
                    element = element.substring(1, element.indexOf(41));
                }
                String[] objects = element.split(";");
                HashMap<String, String> translationMap = new HashMap<String, String>();
                for (int j = 0; j < objects.length; ++j) {
                    translationMap.put(String.valueOf(j + 1), objects[j]);
                }
                String name = varName.indexOf(37) >= 0 ? StringUtils.replaceVariableValues((String)varName, (char)'%', translationMap) : varName;
                String value = varValue.indexOf(37) >= 0 ? StringUtils.replaceVariableValues((String)varValue, (char)'%', translationMap) : varValue;
                if (resultValues.keySet().contains(name)) {
                    resultValues.put(name, (String)resultValues.get(name) + "," + value);
                    continue;
                }
                resultValues.put(name, value);
            }
        }
        StringBuffer apacheVarsLines = new StringBuffer(34);
        for (Map.Entry entry : resultValues.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            String line = StringUtils.replaceString((String)linePattern, (String)"$varName$", (String)name);
            line = StringUtils.replaceString((String)line, (String)"$varValue$", (String)this._fixStringValue(value));
            apacheVarsLines.append(line).append('\n');
        }
        return apacheVarsLines;
    }

    private StringBuffer _composeMetaVarElementLine(R01MMetaDataStorageConfig mdStorageCfg, R01MIndexableContent idxCont, R01MIndexableDocument idxDoc, String memberSrc, String currMDataType, String currMDDataSubType, String varName, String linePattern) {
        if (linePattern == null) {
            if (idxDoc != null && idxDoc.getOid() != null) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error al componer la linea de metadatos / variables del contenido " + idxDoc.getOid() + "\n No se ha pasado ningun patron de la linea a formar");
            } else {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error al componer la linea de metadatos / variables del contenido. El documento es NULL ");
            }
            return new StringBuffer();
        }
        String apacheVarLine = StringUtils.replaceString((String)linePattern, (String)"$varName$", (String)varName);
        String currMDapacheVarFieldValue = this._getMemberValue(mdStorageCfg, idxCont, idxDoc, memberSrc);
        if (currMDapacheVarFieldValue != null) {
            if (currMDataType != null && currMDataType.equalsIgnoreCase("String") && currMDDataSubType != null && NumberUtils.isInteger((String)currMDDataSubType) && currMDapacheVarFieldValue.length() > Integer.parseInt(currMDDataSubType)) {
                currMDapacheVarFieldValue = currMDapacheVarFieldValue.substring(0, Integer.parseInt(currMDDataSubType));
            }
            apacheVarLine = StringUtils.replaceString((String)apacheVarLine, (String)"$varValue$", (String)this._fixStringValue(currMDapacheVarFieldValue));
        } else {
            apacheVarLine = StringUtils.replaceString((String)apacheVarLine, (String)"$varValue$", (String)"");
        }
        return new StringBuffer(apacheVarLine).append('\n');
    }

    private Map _composeMiscApacheMetaVarsLines(String varName, String propValue, R01MIndexableContent idxCont, R01MIndexableDocument idxDoc, List<String> metadataFileNames, String linePattern) {
        String idxFileName;
        String memberValue;
        StringBuffer miscIDXLines = new StringBuffer();
        HashMap<String, StringBuffer> idxFilesLines = new HashMap<String, StringBuffer>();
        int firstPointPosition = propValue.indexOf(46);
        if (firstPointPosition > 0) {
            memberValue = this._getMemberValue(null, idxCont, idxDoc, propValue.substring(firstPointPosition + 1));
            idxFileName = "r01ContVars." + propValue.substring(0, firstPointPosition) + ".shtml";
        } else {
            R01FLog.to((String)LOG_TYPE_ID).warning("Error en el formato del elemento " + varName + ". " + propValue + " debe tener un formato file.tipo.valor/ruta");
            memberValue = this._getMemberValue(null, idxCont, idxDoc, propValue);
            idxFileName = DEFAULT_APACHE_VAR_FILENAME;
        }
        if (metadataFileNames == null || metadataFileNames.isEmpty() || metadataFileNames.contains(idxFileName)) {
            if (memberValue != null) {
                String idxLine = StringUtils.replaceString((String)linePattern, (String)"$varName$", (String)varName);
                idxLine = StringUtils.replaceString((String)idxLine, (String)"$varValue$", (String)this._fixStringValue(memberValue));
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\t\t" + idxLine);
                }
                miscIDXLines.append(idxLine + "\r\n");
            } else {
                String idxLine;
                R01FLog.to((String)LOG_TYPE_ID).warning("\tel valor asociado para el campo " + varName + " est\u00e1 vac\u00edo o es una cadena arbitraria... Se toma este valor a pelo!");
                if (propValue.indexOf(46) > 0) {
                    idxLine = StringUtils.replaceString((String)linePattern, (String)"$varName$", (String)varName);
                    idxLine = StringUtils.replaceString((String)idxLine, (String)"$varValue$", (String)this._fixStringValue(propValue.substring(propValue.indexOf(46) + 1)));
                } else {
                    idxLine = StringUtils.replaceString((String)linePattern, (String)"$varName$", (String)varName);
                    idxLine = StringUtils.replaceString((String)idxLine, (String)"$varValue$", (String)this._fixStringValue(propValue));
                }
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\t\t" + idxLine);
                }
                miscIDXLines.append(idxLine);
                miscIDXLines.append("\r\n");
            }
            idxFilesLines.put(idxFileName, miscIDXLines);
        }
        return idxFilesLines;
    }

    private String _fixStringValue(String theString) {
        return theString.replaceAll("\"", "'");
    }

    private StringBuffer _composePublicationTargetsVarsLines(R01MIndexableDocument idxDoc) {
        StringBuffer pubsIDXLines = new StringBuffer(50);
        if (idxDoc.getPublicationInfo() != null) {
            List pubTargets = idxDoc.getPublicationInfo();
            R01MIndexablePublicationInfo currPubTarget2 = null;
            R01MIndexablePublicationInfo lastPublication = null;
            for (R01MIndexablePublicationInfo currPubTarget2 : pubTargets) {
                if (lastPublication != null && (currPubTarget2.getState() != 1 || !currPubTarget2.getPublishDate().after(lastPublication.getPublishDate()))) continue;
                lastPublication = currPubTarget2;
            }
            pubsIDXLines.append("<!--#set var=\"r01_repository\" value=\"" + lastPublication.getRepositoryOid() + "\" -->\r\n");
        }
        return pubsIDXLines;
    }

    private String _getMemberValue(R01MMetaDataStorageConfig mdStorageCfg, R01MIndexableContent idxCont, R01MIndexableDocument idxDoc, String memberSrc) {
        String metaDataTypeDef = null;
        String metaDataType = null;
        if (mdStorageCfg != null) {
            metaDataTypeDef = mdStorageCfg.getDataType();
            Pattern mdTypePattern = Pattern.compile("(unknown|String|Integer|Long|Short|Float|Double|Date|List|Map|R01MStructureCatalog|R01MGeoCatalog|R01MSearchResultItemPublicationInfo)(?:\\((.+)\\))*");
            Matcher mdTypeMatcher = mdTypePattern.matcher(metaDataTypeDef);
            if (mdTypeMatcher.matches() && mdTypeMatcher.groupCount() >= 2) {
                metaDataType = mdTypeMatcher.group(1);
            }
        }
        String objectType = null;
        String memberPath = null;
        Object memberValue = null;
        Pattern mdValuePattern = Pattern.compile(REG_EX);
        Matcher mdValueMatcher = mdValuePattern.matcher(memberSrc);
        if (mdValueMatcher.matches()) {
            objectType = mdValueMatcher.group(1);
            memberPath = mdValueMatcher.group(2);
            try {
                StringBuffer resultList;
                R01MIndexableDataFile currIdxDf2;
                int mapClauseIndex = memberPath.indexOf("($LANG$)");
                if (mapClauseIndex > 0) {
                    memberPath = memberPath.substring(0, mapClauseIndex);
                }
                if (objectType.equalsIgnoreCase("CONTENT") && idxCont != null) {
                    memberValue = ReflectionUtils.getMemberValueUsingPath((Object)idxCont, (String)memberPath, (boolean)true);
                } else if (objectType.equalsIgnoreCase("DOCUMENT") && idxDoc != null) {
                    memberValue = ReflectionUtils.getMemberValueUsingPath((Object)idxDoc, (String)memberPath, (boolean)true);
                } else if (objectType.equalsIgnoreCase("DOCUMENT_DATAFILES")) {
                    if (idxDoc.getDataFiles() != null && idxDoc.getDataFiles().size() > 0) {
                        memberValue = new StringBuffer(idxDoc.getDataFiles().size() * 60);
                        currIdxDf2 = null;
                        Object currDfMemberValue = null;
                        Iterator dfIt = idxDoc.getDataFiles().values().iterator();
                        while (dfIt.hasNext()) {
                            currIdxDf2 = (R01MIndexableDataFile)dfIt.next();
                            currDfMemberValue = ReflectionUtils.getMemberValueUsingPath((Object)currIdxDf2, (String)memberPath, (boolean)true);
                            if (currDfMemberValue == null) continue;
                            ((StringBuffer)memberValue).append(currIdxDf2.getOid());
                            ((StringBuffer)memberValue).append(">>");
                            ((StringBuffer)memberValue).append(this._serializeToString(currDfMemberValue, idxDoc.getLanguage()));
                            if (((StringBuffer)memberValue).length() <= 0 || !dfIt.hasNext()) continue;
                            ((StringBuffer)memberValue).append("$$");
                        }
                    }
                } else if (objectType.equalsIgnoreCase("DOCUMENT_MAINDATAFILE") && idxDoc != null) {
                    R01MIndexableDataFile mainDF = idxDoc.getMainDataFile();
                    if (mainDF != null) {
                        memberValue = ReflectionUtils.getMemberValueUsingPath((Object)mainDF, (String)memberPath, (boolean)true);
                    }
                } else if (objectType.equalsIgnoreCase("METADATA") && idxDoc.getDataFiles() != null) {
                    currIdxDf2 = null;
                    for (R01MIndexableDataFile currIdxDf2 : idxDoc.getDataFiles().values()) {
                        if (!currIdxDf2.isMetaDataContainer() || currIdxDf2.getMetaData() == null || currIdxDf2.getMetaData().isEmpty()) continue;
                        R01MIndexableMetaData metaData = currIdxDf2.getMetaData(memberPath);
                        if (metaData != null && mdStorageCfg != null) {
                            memberValue = metaData.getMetaDataValue();
                            if (memberValue != null && metaDataType != null && metaDataType.equalsIgnoreCase("Date")) {
                                if ((memberValue = DateUtils.reformatDateString((String)((String)memberValue), (String)DateUtils.getLanguageDateFormat((String)idxDoc.getLanguage(), (Properties)R01MSearchEngineConstants.IDX_DATE_FORMATS), (String)DateUtils.getLanguageDateFormat((String)idxDoc.getLanguage(), (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS))) != null) continue;
                                R01FLog.to((String)LOG_TYPE_ID).warning("NO se ha podido obtener una fecha con el formato dd/MM/yyyy del metaDato " + mdStorageCfg.getOid() + " = null");
                                continue;
                            }
                            if (memberValue != null) continue;
                            R01FLog.to((String)LOG_TYPE_ID).info("NO se encuentra el valor del metaDato " + memberPath + ": NO se ha obtenido el metaDato <autonomy.idxFieldSrc>" + memberSrc + "</autonomy.idxFieldSrc>\r\nPosibles Causas:\r\n\t-El valor de esta propiedad autonomy.idxFieldSrc debe coincidir con el oid de un metaDato del objeto R01MIndexableDataFile\r\n\t-El objeto R01MIndexableDataFile NO tenga un valor para el metaDato (es nulo)\r\n\t-La sentencia xpath especificada en la configuracion del metaDato en el fichero searchMetaDataStorage.xml y que permite obtener su valor desde el DCR NO es correcta");
                            continue;
                        }
                        R01FLog.to((String)LOG_TYPE_ID).info("NO se encuentra el valor del metaDato " + memberPath + ": NO se han obtenido el metaDatos especificos en el DCR\r\nPosibles causas:\r\n\t-El DCR no contiene valores para los metaDatos especificos\r\n\t-La sentencia xpath especificada en la configuracion del metaDato del fichero searchMetaDataStorageConfig.xml no es valida");
                    }
                }
                if (metaDataType == null) {
                    R01FLog.to((String)LOG_TYPE_ID).warning("NO se ha definido un tipo de dato para el metaDato " + memberPath + "\r\nEs posible que la sentencia dataType especificada en la configuracion de tipologia no sea valida");
                } else if (metaDataType.equalsIgnoreCase("List") && memberValue != null) {
                    R01MIndexableStructureCatalog valueElement;
                    resultList = new StringBuffer();
                    List valueList = (List)memberValue;
                    if (memberPath != null && memberPath.equalsIgnoreCase("structureCatalogs")) {
                        for (int i = 0; i < valueList.size(); ++i) {
                            valueElement = (R01MIndexableStructureCatalog)valueList.get(i);
                            resultList.append('(');
                            resultList.append(valueElement.getStructureOid());
                            resultList.append(';');
                            resultList.append(valueElement.getLabelOid());
                            resultList.append(';');
                            resultList.append(valueElement.getLabelRoleInStructure());
                            resultList.append("),");
                        }
                    } else if (memberPath != null && memberPath.equalsIgnoreCase("geoCatalogs")) {
                        for (int i = 0; i < valueList.size(); ++i) {
                            valueElement = (R01MIndexableGeoCatalog)valueList.get(i);
                            resultList.append('(');
                            resultList.append(valueElement.getGeoStructureOid());
                            resultList.append(';');
                            resultList.append(valueElement.getGeoLabelOid());
                            resultList.append("),");
                        }
                    } else if (memberPath != null && memberPath.equalsIgnoreCase("publicationInfo")) {
                        for (int i = 0; i < valueList.size(); ++i) {
                            valueElement = (R01MIndexablePublicationInfo)valueList.get(i);
                            resultList.append('(');
                            resultList.append(valueElement.getRepositoryOid());
                            resultList.append(';');
                            resultList.append(valueElement.getRepositoryAlias());
                            resultList.append(';');
                            resultList.append(valueElement.getState());
                            resultList.append(';');
                            resultList.append(DateUtils.getDateFormated((java.util.Date)valueElement.getPublishDate(), (String)DateUtils.getLanguageDateFormat((String)idxDoc.getLanguage(), (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS)));
                            resultList.append("),");
                        }
                    } else {
                        resultList.append(memberValue.toString());
                    }
                    memberValue = resultList.toString();
                    if (((String)memberValue).endsWith(",")) {
                        memberValue = ((String)memberValue).substring(0, ((String)memberValue).length() - 1);
                    }
                } else if (memberPath != null && (memberPath.equalsIgnoreCase("friendlyUrlsByLanguage") || memberPath.equalsIgnoreCase("urlsByLanguage"))) {
                    if (idxCont.getDocuments() != null && !idxCont.getDocuments().isEmpty()) {
                        resultList = new StringBuffer();
                        ArrayList<String> executedDocs = new ArrayList<String>();
                        Map docsToIndex = new HashMap<String, R01MIndexableDocument>();
                        if (idxDoc == null) {
                            docsToIndex = idxCont.getDocuments();
                        } else {
                            docsToIndex.put(idxDoc.getOid(), idxDoc);
                        }
                        Iterator itDocuments = docsToIndex.entrySet().iterator();
                        while (itDocuments.hasNext()) {
                            R01MIndexableDocument documentIdx = (R01MIndexableDocument)itDocuments.next().getValue();
                            if (executedDocs.contains(documentIdx.getLanguage() + "_" + documentIdx.getInternalName())) continue;
                            executedDocs.add(documentIdx.getLanguage() + "_" + documentIdx.getInternalName());
                            memberValue = ReflectionUtils.getMemberValueUsingPath((Object)documentIdx, (String)memberPath, (boolean)true);
                            Map valueList = (Map)memberValue;
                            if (valueList == null) continue;
                            for (Map.Entry entry : valueList.entrySet()) {
                                String repository = (String)entry.getKey();
                                Map value = (Map)entry.getValue();
                                String lang = "";
                                String url = "";
                                for (Map.Entry entry2 : value.entrySet()) {
                                    lang = (String)entry2.getKey();
                                    url = (String)entry2.getValue();
                                    if (!documentIdx.getLanguage().equalsIgnoreCase(lang)) continue;
                                    resultList.append('(').append(documentIdx.getInternalName()).append(';').append(repository).append(';').append(lang).append(';').append(url).append("),");
                                }
                            }
                        }
                        memberValue = resultList.toString();
                        if (((String)memberValue).endsWith(",")) {
                            memberValue = ((String)memberValue).substring(0, ((String)memberValue).length() - 1);
                        }
                    }
                } else if (memberValue == null) {
                    memberValue = "";
                }
                if (mapClauseIndex > 0 && memberValue != null && ReflectionUtils.isMap(memberValue.getClass())) {
                    memberValue = ((Map)memberValue).get(idxDoc.getLanguage());
                }
            }
            catch (ReflectionException refEx) {
                refEx.printStackTrace(System.err);
                R01FLog.to((String)LOG_TYPE_ID).severe("Error al acceder al miembro " + memberPath + " :" + refEx.getMessage() + ".Se ignora la linea correspondiente al metaDato en el fichero IDX generado!!!");
            }
        } else {
            R01FLog.to((String)LOG_TYPE_ID).warning("La propiedad <autonomy.idxFieldSrc>" + memberSrc + "</autonomy.idxFieldSrc> para un metaDato especificada en el fichero searchMetaDataStorage.xml que NO tiene el formato correcto!!!");
        }
        return this._serializeToString(memberValue, idxDoc == null ? null : idxDoc.getLanguage());
    }

    private String _serializeToString(Object memberValue, String language) {
        String outMemberValueStr = null;
        if (memberValue != null) {
            if (memberValue instanceof String) {
                outMemberValueStr = this._fixStringValue((String)memberValue);
            } else if (memberValue instanceof StringBuffer) {
                outMemberValueStr = this._fixStringValue(((StringBuffer)memberValue).toString());
            } else if (memberValue instanceof java.util.Date) {
                java.util.Date date = (java.util.Date)memberValue;
                outMemberValueStr = DateUtils.getDateFormated((java.util.Date)date, (String)DateUtils.getLanguageDateFormat((String)language, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS));
            } else if (memberValue instanceof Date) {
                Date date = (Date)memberValue;
                outMemberValueStr = DateUtils.getDateFormated((java.util.Date)date, (String)DateUtils.getLanguageDateFormat((String)language, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS));
            } else if (ReflectionUtils.isMap(memberValue.getClass())) {
                outMemberValueStr = "";
                Map theMap = (Map)memberValue;
                Map.Entry me = null;
                Iterator mIt = theMap.entrySet().iterator();
                while (mIt.hasNext()) {
                    me = mIt.next();
                    outMemberValueStr = outMemberValueStr + "(" + (String)me.getKey() + ";" + me.getValue().toString() + ")" + (mIt.hasNext() ? "," : "");
                }
                outMemberValueStr = this._fixStringValue(outMemberValueStr);
            } else {
                outMemberValueStr = this._fixStringValue(memberValue.toString());
            }
            return outMemberValueStr;
        }
        return null;
    }

    private static Properties _obtainAutonomyMemberMappingInfo(String serverOid, String dataStoreOid) throws R01MSearchIndexerException {
        String patternsKey = serverOid + ":" + dataStoreOid;
        if (memberMappingsCache != null && memberMappingsCache.get(patternsKey) != null) {
            return (Properties)memberMappingsCache.get(patternsKey);
        }
        Map theMappings = null;
        try {
            R01MSearchMetaDataStorageConfig searchMetaDataStorageCfg = typoStorageConfigAPI.getSearchMetaDataStorageConfig(serverOid, dataStoreOid);
            theMappings = searchMetaDataStorageCfg.getProperties();
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            throw new R01MSearchIndexerException("Error al cargar la configuraci\u00f3n de almacenamiento de tipos: " + cfgLoadEx.getDetailedMessage(), (Exception)((Object)cfgLoadEx));
        }
        if (theMappings.get("autonomy.DRETITLE") == null) {
            throw new R01MSearchIndexerException("No se ha encontrado el patr\u00f3n 'autonomy.DRETITLE' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (theMappings.get("autonomy.DREFIELD_metaData") == null) {
            throw new R01MSearchIndexerException("No se ha encontrado el patr\u00f3n 'autonomy.DREFIELD_metaData' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        if (theMappings.get("autonomy.DREFIELD_guides") == null) {
            throw new R01MSearchIndexerException("No se ha encontrado el patr\u00f3n 'autonomy.DREFIELD_guides' en las propiedades de la configuraci\u00f3n el fichero searchMetaDataStorage.xml");
        }
        Properties outProps = new Properties();
        outProps.put("autonomy.DRETITLE", theMappings.get("autonomy.DRETITLE"));
        outProps.put("autonomy.DREFIELD_metaData", theMappings.get("autonomy.DREFIELD_metaData"));
        outProps.put("autonomy.DREFIELD_guides", theMappings.get("autonomy.DREFIELD_guides"));
        if (memberMappingsCache == null) {
            memberMappingsCache = new HashMap();
        }
        memberMappingsCache.put(patternsKey, outProps);
        return outProps;
    }

    private void _mergeBufferStringMaps(Map originalMap, Map mapToAppend) {
        for (Map.Entry entry : mapToAppend.entrySet()) {
            String key = (String)entry.getKey();
            if (originalMap.containsKey(key)) {
                if (((StringBuffer)originalMap.get(key)).toString().endsWith("\r\n")) {
                    originalMap.put(key, ((StringBuffer)originalMap.get(key)).append(entry.getValue()));
                    continue;
                }
                originalMap.put(key, ((StringBuffer)originalMap.get(key)).append("\r\n").append(entry.getValue()));
                continue;
            }
            originalMap.put(key, mapToAppend.get(key));
        }
    }

    private void _traceIndex(String objOid, int objType, int action, String errorMsg) {
        if (objType == 1 || objType == 4) {
            switch (action) {
                case 1: {
                    R01KTraceIndexHelper.execMetavarsTraceIndexInit((String)objOid);
                    break;
                }
                case 2: {
                    R01KTraceIndexHelper.execMetavarsTraceIndexEndErr((String)objOid, (String)errorMsg);
                    break;
                }
                case 3: {
                    R01KTraceIndexHelper.execMetavarsTraceIndexEnd((String)objOid);
                    break;
                }
                case 4: {
                    R01KTraceIndexHelper.execMetavarsCheckIndexOK((String)objOid);
                    break;
                }
            }
        } else if (objType == 0) {
            try {
                R01MContent theContent = R01MClientFactory.getContentModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext()).loadContent(objOid);
                if (theContent.getDocuments() != null && !theContent.getDocuments().isEmpty()) {
                    for (String documentOid : theContent.getDocuments().keySet()) {
                        switch (action) {
                            case 1: {
                                R01KTraceIndexHelper.execMetavarsTraceIndexInit((String)documentOid);
                                break;
                            }
                            case 2: {
                                R01KTraceIndexHelper.execMetavarsTraceIndexEndErr((String)documentOid, (String)errorMsg);
                                break;
                            }
                            case 3: {
                                R01KTraceIndexHelper.execMetavarsTraceIndexEnd((String)documentOid);
                                break;
                            }
                            case 4: {
                                R01KTraceIndexHelper.execMetavarsCheckIndexOK((String)documentOid);
                                break;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }
}

