/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01k.searchorchestrator.indexer;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.sql.QueryExecutor;
import com.ejie.r01f.util.ArrayUtils;
import com.ejie.r01f.util.CollectionConverterException;
import com.ejie.r01f.util.CollectionUtils;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01k.ejb.entity.baseindexableobject.R01KBaseIndexableObjectCMPLocal;
import com.ejie.r01k.ejb.entity.baseindexableobject.R01KBaseIndexableObjectCMPPK;
import com.ejie.r01k.ejb.entity.baseindexableobject.R01KBaseIndexableObjectCMPUtil;
import com.ejie.r01k.ejb.entity.indexabledatafile.R01KIndexableDataFileCMPLocal;
import com.ejie.r01k.ejb.entity.indexabledatafile.R01KIndexableDataFileCMPPK;
import com.ejie.r01k.ejb.entity.indexabledatafile.R01KIndexableDataFileCMPUtil;
import com.ejie.r01k.ejb.entity.indexabledocument.R01KIndexableDocumentCMPLocal;
import com.ejie.r01k.ejb.entity.indexabledocument.R01KIndexableDocumentCMPPK;
import com.ejie.r01k.ejb.entity.indexabledocument.R01KIndexableDocumentCMPUtil;
import com.ejie.r01k.ejb.entity.indexinfo.R01KIndexInfoCMPLocal;
import com.ejie.r01k.ejb.entity.indexinfo.R01KIndexInfoCMPUtil;
import com.ejie.r01k.ejb.entity.indexinfo.R01KIndexInfoCMPValue;
import com.ejie.r01k.searchengine.indexer.R01KContentIndexerManager;
import com.ejie.r01k.searchengine.indexer.R01KIndexerManager;
import com.ejie.r01k.searchorchestrator.indexer.indexers.R01KSearchEngineIndexer;
import com.ejie.r01k.searchorchestrator.indexer.queueprocessors.R01KObjectsToIndexProcessor;
import com.ejie.r01k.traceindex.R01KTraceIndexHelper;
import com.ejie.r01k.util.R01KQueries;
import com.ejie.r01k.utils.R01KTraceUtils;
import com.ejie.r01m.config.objects.searchengine.R01MSearchSource;
import com.ejie.r01m.config.objects.searchengine.R01MSearchSourceIndexer;
import com.ejie.r01m.config.objects.typology.R01MContentType;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MJMSException;
import com.ejie.r01m.exceptions.R01MSearchIndexerException;
import com.ejie.r01m.exceptions.R01MSearchIndexerQueueProcessorException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MContentTypologyInfo;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.misc.R01MOperationInModelObjectResult;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexDefinition;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableContent;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MContentModelAPI;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.jms.R01MJMSUtils;
import com.ejie.r01m.utils.jms.R01MJmsQueueParam;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;
import com.ejie.r01p.objects.publisher.R01PPublishDefinition;
import com.ejie.r01p.objects.searchengine.indexer.R01PIndexStatesByIndexer;
import com.ejie.r01p.objects.searchengine.indexer.R01PIndexStatesByIndexerElement;
import com.ejie.r01p.services.R01PClientFactory;
import com.ejie.r01p.services.bzd.R01PSearchEngineIndexerBzd;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

public class R01KSearchOrchestratorIndexer
implements R01PSearchEngineIndexerBzd {
    private static final String LOG_TYPE_ID = "r01k.indexerProcessor";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01k.indexerProcessor").intValue() != Level.OFF.intValue();
    private String _context;
    private static final String SORT_TO_INDEX_ID = "orderToIndex";
    private static final String SORT_TO_UNINDEX_ID = "orderToUnindex";
    private static final boolean SEND_INDEX_FINISHED_MESSAGES = XMLProperties.getBoolean((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"indexMessagesManagement/sendIndexFinishedMessages", (boolean)false);
    private static final boolean TRACE_INDEX = XMLProperties.getBoolean((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"traceIndex", (boolean)false);
    private static final long DEFAULT_TIME_TO_DELIVER = XMLProperties.getLong((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"indexConcurrenceManagement/timeToDeliverIndex", (long)-1L);

    public R01KSearchOrchestratorIndexer() {
        this._context = null;
    }

    public R01KSearchOrchestratorIndexer(String context) {
        this._context = context;
    }

    public Map<String, R01MOperationInModelObjectResult> execInmediateIndexObject(R01MUserContext userCtx, R01MIndexDefinition indexElement) throws R01MSearchIndexerException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("R01KSearchOrchestratorIndexer._executeIndexerOperation > Lanzando la indexaci\u00f3n inmediata del objeto " + (indexElement.getObjectOid() == null ? " (null) " : indexElement.getObjectOid()) + "(" + R01MConstants.OBJECT_DESCS[indexElement.getObjectType()] + ")");
        }
        R01MOperationInModelObjectResult operationResult = this._executeIndexOperation(userCtx, indexElement.getObjectOid(), indexElement.getObjectType(), indexElement.getMetadataFileNames(), indexElement.getIndexers());
        HashMap<String, R01MOperationInModelObjectResult> resultMap = new HashMap<String, R01MOperationInModelObjectResult>();
        resultMap.put("inmediateIndex", operationResult);
        return resultMap;
    }

    public void execInmediatePublishIndex(R01MUserContext userCtx, String objectOid, int objectType, String filterPattern) throws EJBException {
        if (!StringUtils.isEmptyString((String)objectOid)) {
            this._execPublishIndexResources(objectOid, objectType, filterPattern);
        }
    }

    public void execInmediateIndexObjectWithIndexer(R01MUserContext userCtx, String objectOid, int objectType, String indexerClass) throws R01MSearchIndexerException {
        R01KSearchEngineIndexer indexer = null;
        try {
            indexer = (R01KSearchEngineIndexer)ReflectionUtils.getObjectInstance((String)indexerClass);
        }
        catch (ReflectionException rEx) {
            throw new R01MSearchIndexerException("NO se ha podido instanciar la clase " + (indexerClass == null ? " (null) " : indexerClass));
        }
        String objsToIndexQueueManagerImplClassName = XMLProperties.get((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"indexerContents/queueManagerImplClassNames/r01kQueue");
        if (objsToIndexQueueManagerImplClassName == null) {
            R01FLog.to((String)LOG_TYPE_ID).warning("R01KSearchOrchestratorIndexer > NO se ha definido la clase que implementa el manager de cola de indexaci\u00f3n para en la seccion indexerContents/queueManagerImplClassNames del fichero r01k.properties.xml\r\nSe toma el valor com.ejie.r01k.searchorchestrator.indexer.queueprocessors.R01KDAOObjectsToProcessQueueManager por defecto!!!!");
            objsToIndexQueueManagerImplClassName = "com.ejie.r01k.searchorchestrator.indexer.queueprocessors.R01KDAOObjectsToProcessQueueManager";
        }
        R01KObjectsToIndexProcessor processor = new R01KObjectsToIndexProcessor(userCtx);
        try {
            processor.inmediateIndexObject(objectOid, objectType, new R01KSearchEngineIndexer[]{indexer});
        }
        catch (R01MSearchIndexerQueueProcessorException siEx) {
            throw new R01MSearchIndexerException("Error al ejecutar la indexaci\u00f3n del objeto " + objectOid + " del tipo " + objectType + " con el indexador " + indexerClass + ". Error: " + siEx.getMessage());
        }
    }

    public Map<String, R01MOperationInModelObjectResult> execInmediateUnIndexObject(R01MUserContext userCtx, String objectOid, int objectType) {
        if (objectOid == null) {
            R01FLog.to((String)LOG_TYPE_ID).severe("R01KSearchOrchestratorIndexer.execInmediateUnIndexObject > Lanzando la desindexaci\u00f3n  inmediata del objeto null(" + R01MConstants.OBJECT_DESCS[objectType] + ") ==> OBJETO PASADO ES NULL");
            return null;
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("R01KSearchOrchestratorIndexer.execInmediateUnIndexObject > Lanzando la desindexaci\u00f3n  inmediata del objeto " + objectOid + "(" + R01MConstants.OBJECT_DESCS[objectType] + ")");
        }
        if (!StringUtils.isEmptyString((String)objectOid)) {
            R01MOperationInModelObjectResult operationResult = new R01MOperationInModelObjectResult(objectOid, objectType, true, "OK");
            Map<String, R01KSearchEngineIndexer[]> orderedIndexers = this._loadIndexers(objectOid, objectType);
            if (orderedIndexers != null && !orderedIndexers.isEmpty()) {
                R01KSearchEngineIndexer[] indexersOrderedToUnindex = orderedIndexers.get(SORT_TO_UNINDEX_ID);
                R01KObjectsToIndexProcessor processor = new R01KObjectsToIndexProcessor(userCtx);
                try {
                    operationResult = processor.inmediateUnIndexObject(objectOid, objectType, indexersOrderedToUnindex);
                }
                catch (R01MSearchIndexerQueueProcessorException siEx) {
                    R01FLog.to((String)LOG_TYPE_ID).warning("Error en la indexaci\u00f3n del objeto " + objectOid + " de tipo " + R01MConstants.OBJECT_DESCS[objectType] + ". No se ha podido realizar la desindexaci\u00f3n inmediata. Error: " + siEx.getMessage());
                    operationResult = new R01MOperationInModelObjectResult(null, -1, false, "Immediate unindex has failed. Error: " + siEx.getMessage());
                }
            }
            HashMap<String, R01MOperationInModelObjectResult> resultMap = new HashMap<String, R01MOperationInModelObjectResult>();
            resultMap.put("inmediateUnIndex", operationResult);
            return resultMap;
        }
        return null;
    }

    public boolean execCheckContentExistence(String objectOid) throws R01MSearchIndexerException {
        try {
            R01KBaseIndexableObjectCMPUtil.getLocalHome().findByPrimaryKey(new R01KBaseIndexableObjectCMPPK(objectOid));
            return true;
        }
        catch (FinderException findEx) {
            return false;
        }
        catch (NamingException nameEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("R01KSearchOrchestratorIndexer > Error al comprobar la existencia de un objeto indexable. No se encuentra el Home del EJB de indexaci\u00f3n b\u00e1sica correspondiente al objeto indexable base con oid " + objectOid + ": " + nameEx.getMessage());
            throw new R01MSearchIndexerException("No se encuentra el Home del EJB de indexaci\u00f3n b\u00e1sica correspondiente al objeto indexable base con oid " + objectOid, (Exception)nameEx);
        }
    }

    public R01MIndexableContent execLoadIndexableContent(R01MUserContext userCtx, String contentOid) throws R01MSearchIndexerException {
        R01MIndexableContent idxCont = null;
        try {
            idxCont = R01MClientFactory.getContentModelAPI((R01MUserContext)userCtx).getIndexableContent(contentOid);
        }
        catch (R01MSecurityException secEx) {
            throw new R01MSearchIndexerException((Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new R01MSearchIndexerException((Exception)((Object)cmEx));
        }
        return idxCont;
    }

    private R01MContentTypologyInfo _execLoadObjectTypology(String objectOid, int objectType) throws R01MSearchIndexerException {
        R01MContentTypologyInfo typo = null;
        String contentOid = null;
        if (objectType == 3 || objectType == 4 || objectType == 5) {
            typo = new R01MContentTypologyInfo();
            typo.setTypeOid(R01MConstants.PORTAL_TYPE_ID);
            typo.setFamilyOid(R01MConstants.PORTAL_FAMILY_ID);
            typo.setClusterOid(R01MConstants.PORTAL_CLUSTER_ID);
        } else {
            try {
                if (objectType == 0) {
                    contentOid = objectOid;
                } else if (objectType == 1) {
                    R01KIndexableDocumentCMPLocal docCMP = R01KIndexableDocumentCMPUtil.getLocalHome().findByPrimaryKey(new R01KIndexableDocumentCMPPK(objectOid));
                    contentOid = docCMP.getOidContent();
                } else if (objectType == 2) {
                    R01KIndexableDataFileCMPLocal dfCMP = R01KIndexableDataFileCMPUtil.getLocalHome().findByPrimaryKey(new R01KIndexableDataFileCMPPK(objectOid));
                    R01KIndexableDocumentCMPLocal docCMP = R01KIndexableDocumentCMPUtil.getLocalHome().findByPrimaryKey(new R01KIndexableDocumentCMPPK(dfCMP.getOidDocument()));
                    contentOid = docCMP.getOidContent();
                }
                R01KBaseIndexableObjectCMPLocal baseIndexableObject = R01KBaseIndexableObjectCMPUtil.getLocalHome().findByPrimaryKey(new R01KBaseIndexableObjectCMPPK(contentOid));
                typo = new R01MContentTypologyInfo(baseIndexableObject.getOidClusterTipologia(), baseIndexableObject.getOidFamiliaTipologia(), baseIndexableObject.getOidTipoTipologia());
            }
            catch (FinderException findEx) {
                throw new R01MSearchIndexerException("No se encuentra el Home del EJB de indexaci\u00f3n b\u00e1sica correspondiente al objeto indexable para obtener su tipolog\u00eda. No se encuentra el objeto de oid " + objectOid, (Exception)((Object)findEx));
            }
            catch (NamingException nameEx) {
                throw new R01MSearchIndexerException("No se encuentra el Home del EJB de indexaci\u00f3n b\u00e1sica correspondiente al objeto indexable base con oid " + objectOid, (Exception)nameEx);
            }
            catch (Exception ex) {
                throw new R01MSearchIndexerException("Error general al obtener la tipologia para el contenido '" + contentOid + "' de objeto indexable base con oid " + objectOid, ex);
            }
        }
        return typo;
    }

    private void _execPublishIndexResources(String objectOid, int objectType, String filterPattern) {
        if (XMLProperties.getBoolean((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"publisherEnabled")) {
            List repositories = new ArrayList();
            if (objectType == 0 || objectType == 1) {
                repositories = XMLProperties.getPropertyList((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"contentIndexConfiguration/indexpublicationRepositories/repository");
            } else if (objectType == 4) {
                repositories = XMLProperties.getPropertyList((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"contentIndexConfiguration/indexpublicationRepositories/repository");
            }
            Date now = new Date();
            for (String repositoryOid : repositories) {
                try {
                    R01PPublishDefinition pubDefinition = new R01PPublishDefinition(R01MAuthManager.createMasterSystemUserContext().getUserName(), objectOid, objectType == 0 ? 8 : 10, null, filterPattern, null, repositoryOid, 0, now, null, false, null, null);
                    R01PClientFactory.getPublisherAPI().publish(pubDefinition);
                    if (!DEBUG) continue;
                    R01FLog.to((String)LOG_TYPE_ID).info("Los recursos del documento de Oid " + objectOid + " han sido publicados en el repositorio de Oid " + repositoryOid);
                }
                catch (Exception genericPublishEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("Error desconocido en la Publicaci\u00f3n: " + genericPublishEx.getMessage());
                }
            }
        }
    }

    private R01MOperationInModelObjectResult _executeIndexOperation(R01MUserContext userCtx, String objectOid, int objectType, List<String> metadataFileNames, List<String> indexers) {
        if (objectOid == null) {
            R01FLog.to((String)LOG_TYPE_ID).severe("R01KSearchOrchestratorIndexer._executeIndexOperation > Lanzando la indexaci\u00f3n  inmediata del objeto  (null) (" + R01MConstants.OBJECT_DESCS[objectType] + ") ==> OBJETO PASADO ES NULL");
            return null;
        }
        if (objectType == 0 || objectType == 1) {
            return this._executeIndexContentModelObject(userCtx, objectOid, objectType, metadataFileNames, indexers);
        }
        if (objectType == 4) {
            return this._executeIndexPortalModelObject(userCtx, objectOid, objectType, metadataFileNames, indexers);
        }
        return new R01MOperationInModelObjectResult(objectOid, objectType, false, "NOOK: Not indexable object type: OID = " + objectOid + ", " + "TYPE: " + objectType);
    }

    private R01MOperationInModelObjectResult _executeIndexPortalModelObject(R01MUserContext userCtx, String objectOid, int objectType, List<String> metadataFileNames, List<String> indexers) {
        Map<String, R01KSearchEngineIndexer[]> orderedIndexers = this._loadIndexers(objectOid, objectType);
        R01KSearchEngineIndexer[] indexersOrderedToIndex = orderedIndexers.get(SORT_TO_INDEX_ID);
        if (indexers != null && !indexers.isEmpty()) {
            int i;
            ArrayList<R01KSearchEngineIndexer> indexersToApply = new ArrayList<R01KSearchEngineIndexer>();
            for (i = 0; i < indexersOrderedToIndex.length; ++i) {
                if (!indexers.contains(indexersOrderedToIndex[i].getClass().getName())) continue;
                indexersToApply.add(indexersOrderedToIndex[i]);
            }
            indexersOrderedToIndex = new R01KSearchEngineIndexer[indexersToApply.size()];
            for (i = 0; i < indexersToApply.size(); ++i) {
                indexersOrderedToIndex[i] = (R01KSearchEngineIndexer)indexersToApply.get(i);
            }
        }
        R01KObjectsToIndexProcessor processor = new R01KObjectsToIndexProcessor(userCtx);
        try {
            return processor.inmediateIndexObject(objectOid, objectType, indexersOrderedToIndex, metadataFileNames);
        }
        catch (R01MSearchIndexerQueueProcessorException siEx) {
            R01FLog.to((String)LOG_TYPE_ID).warning("Error en la indexaci\u00f3n del objeto " + objectOid + " de tipo " + R01MConstants.OBJECT_DESCS[objectType] + ". No se ha podido realizar la indexaci\u00f3n inmediata. Error: " + siEx.getMessage());
            return new R01MOperationInModelObjectResult(null, -1, false, "Immediate index has failed. Error: " + siEx.getMessage());
        }
    }

    private R01MOperationInModelObjectResult _executeIndexContentModelObject(R01MUserContext userCtx, String objectOid, int objectType, List<String> metadataFileNames, List<String> indexers) {
        R01MOperationInModelObjectResult result = new R01MOperationInModelObjectResult(objectOid, objectType, true, "OK");
        StringBuffer baseErrorMessage = new StringBuffer(48);
        baseErrorMessage.append("Error en la indexaci\u00f3n del objeto ").append(objectOid).append(" de tipo ").append(R01MConstants.OBJECT_DESCS[objectType]).append(" (").append(objectType).append("). ");
        List<R01KSearchEngineIndexer>[] orderedIndexers = this._loadOrderedIndexers(objectOid, objectType);
        List<R01KSearchEngineIndexer> documentIndexersOrderedToIndex = orderedIndexers[0];
        List<R01KSearchEngineIndexer> contentIndexersOrderedToIndex = orderedIndexers[1];
        if (indexers != null && !indexers.isEmpty()) {
            R01FLog.to((String)LOG_TYPE_ID).info("Indexadores solicitados para " + objectOid + ":");
            ArrayList<R01KSearchEngineIndexer> newDocumentIndexersOrderedToIndex = new ArrayList<R01KSearchEngineIndexer>();
            for (R01KSearchEngineIndexer currentIndexer : documentIndexersOrderedToIndex) {
                if (indexers.contains(currentIndexer.getClass().getName())) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\tEjecutar el indexador:" + currentIndexer.getClass().getName() + " para " + objectOid);
                    newDocumentIndexersOrderedToIndex.add(currentIndexer);
                    continue;
                }
                R01FLog.to((String)LOG_TYPE_ID).info("\tNO ejecutar el indexador:" + currentIndexer.getClass().getName() + " para " + objectOid);
            }
            documentIndexersOrderedToIndex = newDocumentIndexersOrderedToIndex;
            ArrayList<R01KSearchEngineIndexer> newContentIndexersOrderedToIndex = new ArrayList<R01KSearchEngineIndexer>();
            for (R01KSearchEngineIndexer currentIndexer : contentIndexersOrderedToIndex) {
                R01FLog.to((String)LOG_TYPE_ID).info("\tEjecutar el indexador:" + currentIndexer.getClass().getName() + " para " + objectOid);
                if (indexers.contains(currentIndexer.getClass().getName())) {
                    newContentIndexersOrderedToIndex.add(currentIndexer);
                    continue;
                }
                R01FLog.to((String)LOG_TYPE_ID).info("\tNO ejecutar el indexador:" + currentIndexer.getClass().getName() + " para " + objectOid);
            }
            contentIndexersOrderedToIndex = newContentIndexersOrderedToIndex;
        } else {
            R01FLog.to((String)LOG_TYPE_ID).info("No hay indexadores solicitados para " + objectOid);
        }
        String currentState = "creating master user";
        try {
            R01MUserContext adminContext = R01MAuthManager.createMasterSystemUserContext();
            R01MContentModelAPI contentAPI = R01MClientFactory.getContentModelAPI((R01MUserContext)adminContext);
            currentState = "loading content oid";
            String contentOid = this._loadContentOid(contentAPI, objectOid, objectType);
            currentState = "checking content existence";
            if (!contentAPI.checkContentExistence(contentOid)) {
                R01FLog.to((String)LOG_TYPE_ID).info("Al lanzar la indexaci\u00f3n, se comprueba que no existe el contenido " + contentOid + ", por lo que se lanza " + "directamente la desindexaci\u00f3n.");
                this.execInmediateUnIndexObject(userCtx, objectOid, objectType);
                return new R01MOperationInModelObjectResult(objectOid, objectType, true, "OK: Se lanza la desindexaci\u00f3n del contenido " + contentOid + " ya que no " + "existe en la BD de R01D");
            }
            currentState = "loading document oids";
            List<String> documentsOids = this._loadDocumentsOids(contentAPI, contentOid);
            currentState = "loading indexing state XML for the content";
            R01PIndexStatesByIndexer contentIndexerStates = this.loadContentIndexerState(contentAPI, contentOid);
            currentState = "loading indexing state XML for the documents";
            Map<String, R01PIndexStatesByIndexer> documentIndexersStateMap = this.loadDocumentIndexersStateMap(contentAPI, documentsOids);
            HashMap<String, String> indexRequestedCounter = new HashMap<String, String>();
            R01KObjectsToIndexProcessor processor = new R01KObjectsToIndexProcessor(userCtx);
            try {
                Collection indexableDocuments = R01KIndexableDocumentCMPUtil.getLocalHome().findByContentOid(contentOid);
                for (R01KIndexableDocumentCMPLocal indexedDocumentCMP : indexableDocuments) {
                    String indexedDocument = indexedDocumentCMP.getOidDocument();
                    if (documentsOids.contains(indexedDocument)) continue;
                    this.execInmediateUnIndexObject(userCtx, indexedDocument, 1);
                }
            }
            catch (FinderException fEx) {
                R01FLog.to((String)LOG_TYPE_ID).warning(baseErrorMessage + "No hay documentos indexables en la BD para el contenido " + contentOid + ".");
            }
            catch (NamingException nameEx) {
                R01FLog.to((String)LOG_TYPE_ID).warning(baseErrorMessage + "Error al recoger los documentos indexables en la BD para el contenido " + contentOid + ": " + nameEx.getMessage());
            }
            if (objectType == 1 && !documentsOids.contains(objectOid)) {
                ArrayList<R01KSearchEngineIndexer> filteredDocumentsIndexersOrderedToIndex = new ArrayList<R01KSearchEngineIndexer>();
                for (int i = 0; i < documentIndexersOrderedToIndex.size(); ++i) {
                    if (!indexers.contains(documentIndexersOrderedToIndex.get(i).getClass().getName())) continue;
                    filteredDocumentsIndexersOrderedToIndex.add(documentIndexersOrderedToIndex.get(i));
                }
                currentState = "indexing document (immediate): " + objectOid;
                try {
                    processor.inmediateIndexObject(objectOid, 1, filteredDocumentsIndexersOrderedToIndex.toArray(new R01KSearchEngineIndexer[filteredDocumentsIndexersOrderedToIndex.size()]), metadataFileNames);
                }
                catch (R01MSearchIndexerQueueProcessorException siEx) {
                    throw siEx;
                }
                catch (Exception ex) {
                    currentState = "indexing document " + objectOid + ".\nWhile checking if document or content exists.";
                    if (!contentAPI.checkContentExistence(contentOid)) {
                        this._sendIndexMessage(contentOid, 0, null, 1);
                    }
                    if (!contentAPI.checkDocumentExistence(objectOid)) {
                        this._sendIndexMessage(contentOid, 0, null, 0);
                    }
                    throw new R01MSearchIndexerException(ex);
                }
            }
            boolean hasToRelaunchIndexers = true;
            while (hasToRelaunchIndexers) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("Lanzando los indexadores para el objeto " + objectOid + " de " + "tipo " + R01MConstants.OBJECT_DESCS[objectType]);
                }
                try {
                    for (String documentOid : documentsOids) {
                        ArrayList<String> indexersToExecute = new ArrayList<String>();
                        R01PIndexStatesByIndexer documentIndexers = documentIndexersStateMap.get(documentOid);
                        if (documentIndexers != null && documentIndexers.getIndexers() != null && !documentIndexers.getIndexers().isEmpty()) {
                            for (R01PIndexStatesByIndexerElement indexer : documentIndexers.getIndexers()) {
                                if (indexer.getState() != R01KSearchEngineIndexer.INDEX_RUNNING) continue;
                                indexersToExecute.add(indexer.getIndexerClassName());
                            }
                        }
                        ArrayList<R01KSearchEngineIndexer> filteredDocumentsIndexersOrderedToIndex = new ArrayList<R01KSearchEngineIndexer>();
                        if (indexersToExecute == null || indexersToExecute.isEmpty()) continue;
                        for (int i = 0; i < documentIndexersOrderedToIndex.size(); ++i) {
                            if (!indexersToExecute.contains(documentIndexersOrderedToIndex.get(i).getClass().getName())) continue;
                            filteredDocumentsIndexersOrderedToIndex.add(documentIndexersOrderedToIndex.get(i));
                        }
                        try {
                            currentState = "indexing document " + documentOid;
                            R01KIndexerManager indexerManager = (R01KIndexerManager)ReflectionUtils.getObjectInstance((String)R01MConstants.CONTENT_INDEXER_MANAGER, null, null, (boolean)true);
                            R01MIndexDefinition indexElement = new R01MIndexDefinition(0, documentOid, 1, null, null, false, -1, null, null, null);
                            indexerManager.prepareToIndex(indexElement);
                            processor.inmediateIndexObject(documentOid, 1, filteredDocumentsIndexersOrderedToIndex.toArray(new R01KSearchEngineIndexer[filteredDocumentsIndexersOrderedToIndex.size()]), metadataFileNames);
                        }
                        catch (R01MSearchIndexerQueueProcessorException siEx) {
                            throw siEx;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            currentState = "indexing document " + objectOid + ".\nWhile checking if document or content exists.";
                            if (!contentAPI.checkContentExistence(contentOid)) {
                                this._sendIndexMessage(contentOid, 0, null, 1);
                                continue;
                            }
                            if (!contentAPI.checkDocumentExistence(objectOid)) {
                                this._sendIndexMessage(contentOid, 0, null, 0);
                                continue;
                            }
                            throw new R01MSearchIndexerException(ex);
                        }
                    }
                    hasToRelaunchIndexers = false;
                    documentIndexersStateMap = this.loadDocumentIndexersStateMap(contentAPI, documentsOids);
                    Map<String, List<String>> objectsWithRequestedState = this._getElementsWithRequestedIndexState(contentOid, documentsOids, null, documentIndexersStateMap, R01KSearchEngineIndexer.INDEX_REQUESTED);
                    for (Map.Entry<String, List<String>> entry : objectsWithRequestedState.entrySet()) {
                        String documentOid = entry.getKey();
                        List<String> indexerswithSelectedState = entry.getValue();
                        if (indexerswithSelectedState == null || indexerswithSelectedState.isEmpty()) continue;
                        hasToRelaunchIndexers = true;
                        if (!indexRequestedCounter.containsKey(documentOid)) {
                            indexRequestedCounter.put(documentOid, Integer.toString(1));
                            continue;
                        }
                        int counter = Integer.parseInt((String)indexRequestedCounter.get(documentOid)) + 1;
                        if (counter > XMLProperties.getInt((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"indexConcurrenceManagement/indexMaxIterations", (int)5)) {
                            hasToRelaunchIndexers = false;
                            this._updateIndexStatesInContentAndDocuments(contentAPI, contentOid, contentIndexerStates, documentIndexersStateMap, R01KSearchEngineIndexer.INDEX_RUNNING, R01KSearchEngineIndexer.INDEX_FINISHED_ERRORS, "RUNNING: Max number of index iterations reached");
                            break;
                        }
                        indexRequestedCounter.put(documentOid, Integer.toString(counter));
                    }
                    if (!hasToRelaunchIndexers) continue;
                    currentState = "checking content existence";
                    if (!contentAPI.checkContentExistence(contentOid)) {
                        R01FLog.to((String)LOG_TYPE_ID).info("Al lanzar la indexaci\u00f3n, se comprueba que no existe el contenido " + contentOid + ", por lo que se lanza " + "directamente la desindexaci\u00f3n.");
                        this.execInmediateUnIndexObject(userCtx, objectOid, objectType);
                        return new R01MOperationInModelObjectResult(objectOid, objectType, true, "OK: Se lanza la desindexaci\u00f3n del contenido " + contentOid + " ya que no " + "existe en la BD de R01D");
                    }
                    currentState = "loading document oids of content " + contentOid;
                    documentsOids = this._loadDocumentsOids(contentAPI, contentOid);
                    currentState = "loadind content from content model";
                    R01MContent content = contentAPI.loadContent(contentOid);
                    currentState = "getting indexable object";
                    R01MIndexableContent idxCont = contentAPI.getIndexableContent(contentOid);
                    boolean copyIndexableXMLToContentFolder = XMLProperties.getBoolean((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"contentIndexPrepareOps/copyIndexableXMLToContentFolder", (boolean)true);
                    if (copyIndexableXMLToContentFolder) {
                        currentState = "uploading indexable object";
                        contentAPI.uploadIndexableObject(content, idxCont);
                    }
                    currentState = "updating indexing state XML of the content " + contentOid;
                    this._updateIndexStatesInContentAndDocuments(contentAPI, contentOid, null, documentIndexersStateMap, R01KSearchEngineIndexer.INDEX_REQUESTED, R01KSearchEngineIndexer.INDEX_RUNNING, "RUNNING: The indexer is currently running.");
                }
                catch (R01MSearchIndexerException siEx) {
                    R01FLog.to((String)LOG_TYPE_ID).warning(baseErrorMessage + "Error al cargar el XML de estados de indexaci\u00f3n para " + "los documentos del contenido " + contentOid + ": " + siEx.getMessage());
                    return new R01MOperationInModelObjectResult(objectOid, objectType, false, "NOOK: Error loading indexing state XML for the documents of the content " + contentOid + ": " + "OID = " + objectOid + ", " + "TYPE: " + objectType + ". " + "ERROR: " + siEx.getMessage());
                }
            }
            hasToRelaunchIndexers = true;
            while (hasToRelaunchIndexers) {
                currentState = "content immediate index";
                processor.inmediateIndexObject(objectOid, objectType, contentIndexersOrderedToIndex.toArray(new R01KSearchEngineIndexer[contentIndexersOrderedToIndex.size()]), metadataFileNames);
                hasToRelaunchIndexers = false;
                boolean isAnyContentWithRequestedState = this._isAnyElementInRequestedState(contentOid, documentsOids, contentIndexerStates, null, R01KSearchEngineIndexer.INDEX_REQUESTED);
                boolean isAnyDocumentWithRequestedState = this._isAnyElementInRequestedState(contentOid, documentsOids, null, documentIndexersStateMap, R01KSearchEngineIndexer.INDEX_REQUESTED);
                if (isAnyContentWithRequestedState && !isAnyDocumentWithRequestedState) {
                    hasToRelaunchIndexers = true;
                    if (!indexRequestedCounter.containsKey(contentOid)) {
                        indexRequestedCounter.put(contentOid, Integer.toString(1));
                    } else {
                        int counter = Integer.parseInt((String)indexRequestedCounter.get(contentOid)) + 1;
                        if (counter > XMLProperties.getInt((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"indexConcurrenceManagement/indexMaxIterations", (int)5)) {
                            hasToRelaunchIndexers = false;
                            break;
                        }
                        indexRequestedCounter.put(contentOid, Integer.toString(counter));
                    }
                    currentState = "updating indexing state XML of the content " + contentOid;
                    this._updateIndexStatesInContentAndDocuments(contentAPI, contentOid, contentIndexerStates, null, R01KSearchEngineIndexer.INDEX_REQUESTED, R01KSearchEngineIndexer.INDEX_RUNNING, "RUNNING: The indexer is currently running.");
                    currentState = "checking content existence";
                    if (!contentAPI.checkContentExistence(contentOid)) {
                        R01FLog.to((String)LOG_TYPE_ID).info("Al lanzar la indexaci\u00f3n, se comprueba que no existe el contenido " + contentOid + ", por lo que se lanza " + "directamente la desindexaci\u00f3n.");
                        this.execInmediateUnIndexObject(userCtx, objectOid, objectType);
                        return new R01MOperationInModelObjectResult(objectOid, objectType, true, "OK: Se lanza la desindexaci\u00f3n del contenido " + contentOid + " ya que no " + "existe en la BD de R01D");
                    }
                    currentState = "loading document oids of content " + contentOid;
                    documentsOids = this._loadDocumentsOids(contentAPI, contentOid);
                    continue;
                }
                if (!isAnyDocumentWithRequestedState) continue;
                Map<String, List<String>> objectsToIndex = this._getElementsWithRequestedIndexState(contentOid, documentsOids, null, documentIndexersStateMap, R01KSearchEngineIndexer.INDEX_REQUESTED);
                for (Map.Entry<String, List<String>> entry : objectsToIndex.entrySet()) {
                    String documentOid = entry.getKey();
                    List<String> indexersWithRequestedState = entry.getValue();
                    if (indexersWithRequestedState == null || indexersWithRequestedState.isEmpty()) continue;
                    ArrayList<String> requestedIndexers = new ArrayList<String>();
                    requestedIndexers.add(indexersWithRequestedState.get(0));
                    currentState = "sending message for content " + contentOid;
                    this._sendIndexMessage(documentOid, 1, requestedIndexers, 0);
                }
            }
        }
        catch (Exception Ex) {
            R01FLog.to((String)LOG_TYPE_ID).warning(baseErrorMessage + "Error " + currentState + " para el objeto " + objectOid + " de tipo " + objectType + ": " + Ex.getMessage());
            return new R01MOperationInModelObjectResult(objectOid, objectType, false, "NOOK: Error " + currentState + ": " + "OID = " + objectOid + ", " + "TYPE: " + objectType + ". (" + R01MConstants.OBJECT_DESCS[objectType] + ")" + "ERROR: " + Ex.getMessage());
        }
        return result;
    }

    private List<R01KSearchEngineIndexer>[] _loadOrderedIndexers(String objectOid, int objectType) {
        Map<String, R01KSearchEngineIndexer[]> orderedIndexers = this._loadIndexers(objectOid, objectType);
        LinkedList<R01KSearchEngineIndexer> documentIndexersOrderedToIndex = new LinkedList<R01KSearchEngineIndexer>();
        LinkedList<R01KSearchEngineIndexer> contentIndexersOrderedToIndex = new LinkedList<R01KSearchEngineIndexer>();
        if (orderedIndexers != null && !orderedIndexers.isEmpty()) {
            R01KSearchEngineIndexer[] indexersOrderedToIndex = orderedIndexers.get(SORT_TO_INDEX_ID);
            for (int i = 0; i < indexersOrderedToIndex.length; ++i) {
                R01KSearchEngineIndexer currentElement = indexersOrderedToIndex[i];
                if (currentElement.getIndexerType() == R01KSearchEngineIndexer.CONTENT_TYPE_INDEXER) {
                    contentIndexersOrderedToIndex.add(currentElement);
                    continue;
                }
                if (currentElement.getIndexerType() == R01KSearchEngineIndexer.DOCUMENT_TYPE_INDEXER) {
                    documentIndexersOrderedToIndex.add(currentElement);
                    continue;
                }
                R01FLog.to((String)LOG_TYPE_ID).warning("El indexador cargado (" + indexersOrderedToIndex[i].getClass().getName() + ") " + "no tiene configuraci\u00f3n de tipo reconocida: " + currentElement.getIndexerType() + ". " + "Por defecto se carga entre los indexadores de tipo content");
                contentIndexersOrderedToIndex.add(currentElement);
            }
        }
        return new List[]{documentIndexersOrderedToIndex, contentIndexersOrderedToIndex};
    }

    private boolean _isAnyElementInRequestedState(String contentOid, List<String> documentsOids, R01PIndexStatesByIndexer contentIndexerStateDoc, Map<String, R01PIndexStatesByIndexer> documentIndexersStateMap, int stateToCheck) {
        Map<String, List<String>> objectsWithRequestedState = this._getElementsWithRequestedIndexState(contentOid, documentsOids, contentIndexerStateDoc, documentIndexersStateMap, stateToCheck);
        for (List<String> indexerRunning : objectsWithRequestedState.values()) {
            if (indexerRunning == null || indexerRunning.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private Map<String, List<String>> _getElementsWithRequestedIndexState(String contentOid, List<String> documentsOids, R01PIndexStatesByIndexer contentIndexerState, Map<String, R01PIndexStatesByIndexer> documentIndexersStateMap, int stateToCheck) {
        HashMap<String, List<String>> objectsWithStateRequested = new HashMap<String, List<String>>();
        if (contentIndexerState != null) {
            ArrayList<String> contentIndexersWithRequestedState = new ArrayList<String>();
            if (contentIndexerState.getIndexers() != null) {
                for (R01PIndexStatesByIndexerElement indexer : contentIndexerState.getIndexers()) {
                    if (indexer.getState() != stateToCheck) continue;
                    contentIndexersWithRequestedState.add(indexer.getIndexerClassName());
                }
            }
            objectsWithStateRequested.put(contentOid, contentIndexersWithRequestedState);
        }
        if (documentsOids != null && documentIndexersStateMap != null) {
            for (String currentDocumentOid : documentsOids) {
                R01PIndexStatesByIndexer documentIndexerState = documentIndexersStateMap.get(currentDocumentOid);
                ArrayList<String> documentIndexersWithRequestedState = new ArrayList<String>();
                if (documentIndexerState.getIndexers() != null) {
                    for (R01PIndexStatesByIndexerElement indexer : documentIndexerState.getIndexers()) {
                        if (indexer.getState() != stateToCheck) continue;
                        documentIndexersWithRequestedState.add(indexer.getIndexerClassName());
                    }
                }
                objectsWithStateRequested.put(currentDocumentOid, documentIndexersWithRequestedState);
            }
        }
        return objectsWithStateRequested;
    }

    private String _loadContentOid(R01MContentModelAPI contentAPI, String objectOid, int objectType) throws R01MSearchIndexerException {
        String contentOid = null;
        if (objectType == 1) {
            try {
                contentOid = contentAPI.getDocumentParentContent(objectOid);
            }
            catch (R01MSecurityException secEx) {
                throw new R01MSearchIndexerException("Error al obtener el Contenido del documento " + objectOid, (Exception)((Object)secEx));
            }
            catch (R01MContentModelException cmEx) {
                throw new R01MSearchIndexerException("Error al obtener el Contenido del documento " + objectOid, (Exception)((Object)cmEx));
            }
        } else if (objectType == 0) {
            contentOid = objectOid;
        }
        return contentOid;
    }

    private List<String> _loadDocumentsOids(R01MContentModelAPI contentAPI, String contentOid) throws R01MSearchIndexerException {
        R01MContent content = null;
        ArrayList<String> documentsOids = new ArrayList<String>();
        if (!StringUtils.isEmptyString((String)contentOid)) {
            try {
                content = contentAPI.loadContent(contentOid);
            }
            catch (R01MSecurityException secEx) {
                throw new R01MSearchIndexerException("Error al cargar el contenido " + contentOid, (Exception)((Object)secEx));
            }
            catch (R01MContentModelException cmEx) {
                throw new R01MSearchIndexerException("Error al cargar el contenido " + contentOid, (Exception)((Object)cmEx));
            }
            if (content.getDocuments() != null && !content.getDocuments().isEmpty()) {
                documentsOids = new ArrayList();
                for (R01MDocument currDoc : content.getDocuments().values()) {
                    if (currDoc.isIndexOff()) continue;
                    documentsOids.add(currDoc.getOid());
                }
            }
        }
        return documentsOids;
    }

    public R01PIndexStatesByIndexer loadContentIndexerState(R01MContentModelAPI contentAPI, String contentOid) throws R01MSearchIndexerException {
        R01PIndexStatesByIndexer contentIndexerState;
        String contentIndexerStateXML = null;
        try {
            contentIndexerStateXML = contentAPI.loadContentIndexersState(contentOid);
        }
        catch (R01MSecurityException secEx) {
            throw new R01MSearchIndexerException("Error al cargar el XML de estado de las indexaciones para el contenido " + contentOid, (Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new R01MSearchIndexerException("Error al cargar el XML de estado de las indexaciones para el contenido " + contentOid, (Exception)((Object)cmEx));
        }
        try {
            contentIndexerState = (R01PIndexStatesByIndexer)XOManager.getObject((String)R01MConstants.INDEXABLEOBJECTS_MAPFILE, (String)contentIndexerStateXML);
        }
        catch (XOMarshallerException xoEx) {
            throw new R01MSearchIndexerException("Error al parsear el XML a objetos de estado de las indexaciones para el contenido " + contentOid, (Exception)((Object)xoEx));
        }
        if (contentIndexerState == null) {
            contentIndexerState = new R01PIndexStatesByIndexer();
        }
        return contentIndexerState;
    }

    public Map<String, R01PIndexStatesByIndexer> loadDocumentIndexersStateMap(R01MContentModelAPI contentAPI, List<String> documentsOids) throws R01MSearchIndexerException {
        HashMap<String, R01PIndexStatesByIndexer> documentIndexersStateMap = new HashMap<String, R01PIndexStatesByIndexer>();
        if (documentsOids != null) {
            for (String currentDocumentOid : documentsOids) {
                R01PIndexStatesByIndexer documentIndexerStateDoc;
                String documentIndexerState = null;
                try {
                    documentIndexerState = contentAPI.loadDocumentIndexersState(currentDocumentOid);
                }
                catch (R01MSecurityException secEx) {
                    throw new R01MSearchIndexerException("Error al cargar el XML de estado de las indexaciones para el documento " + currentDocumentOid, (Exception)((Object)secEx));
                }
                catch (R01MContentModelException cmEx) {
                    throw new R01MSearchIndexerException("Error al cargar el XML de estado de las indexaciones para el documento " + currentDocumentOid, (Exception)((Object)cmEx));
                }
                try {
                    documentIndexerStateDoc = (R01PIndexStatesByIndexer)XOManager.getObject((String)R01MConstants.INDEXABLEOBJECTS_MAPFILE, (String)documentIndexerState);
                }
                catch (XOMarshallerException xoEx) {
                    throw new R01MSearchIndexerException("Error al parsear el XML a objetos de estado de las indexaciones para el documento " + currentDocumentOid, (Exception)((Object)xoEx));
                }
                if (documentIndexerStateDoc == null) {
                    documentIndexerStateDoc = new R01PIndexStatesByIndexer();
                }
                documentIndexersStateMap.put(currentDocumentOid, documentIndexerStateDoc);
            }
        }
        return documentIndexersStateMap;
    }

    public void _updateIndexStatesInContentAndDocuments(R01MContentModelAPI contentAPI, String contentOid, R01PIndexStatesByIndexer contentIndexerStates, Map<String, R01PIndexStatesByIndexer> documentIndexersStateMap, int initialState, int finalState, String message) throws R01MSearchIndexerException {
        List<R01KSearchEngineIndexer>[] orderedIndexers = this._loadOrderedIndexers(contentOid, 0);
        if (contentIndexerStates != null) {
            if (orderedIndexers != null && (contentIndexerStates.getIndexers() == null || contentIndexerStates.getIndexers().isEmpty())) {
                List<R01KSearchEngineIndexer> contentOrderedIndexers = orderedIndexers[1];
                ArrayList<R01PIndexStatesByIndexerElement> arrayList = new ArrayList<R01PIndexStatesByIndexerElement>();
                for (R01KSearchEngineIndexer defaultIndexer : contentOrderedIndexers) {
                    R01PIndexStatesByIndexerElement indexer = new R01PIndexStatesByIndexerElement();
                    indexer.setIndexerClassName(defaultIndexer.getClass().getName());
                    indexer.setMessage("OK: The indexer has never been executed.");
                    indexer.setState(R01KSearchEngineIndexer.INDEX_FINISHED_OK);
                    arrayList.add(indexer);
                }
                contentIndexerStates.setIndexers(arrayList);
            }
            for (R01PIndexStatesByIndexerElement r01PIndexStatesByIndexerElement : contentIndexerStates.getIndexers()) {
                if (r01PIndexStatesByIndexerElement.getState() != initialState) continue;
                r01PIndexStatesByIndexerElement.setState(finalState);
                r01PIndexStatesByIndexerElement.setMessage(message);
            }
            try {
                contentAPI.setContentIndexersState(contentOid, XOManager.getXML((String)R01MConstants.INDEXABLEOBJECTS_MAPFILE, (Object)contentIndexerStates));
            }
            catch (R01MSecurityException secEx) {
                throw new R01MSearchIndexerException("Error al actualizar el XML de estado de las indexaciones para el contenido " + contentOid, (Exception)((Object)secEx));
            }
            catch (R01MContentModelException cmEx) {
                throw new R01MSearchIndexerException("Error al actualizar el XML de estado de las indexaciones para el contenido " + contentOid, (Exception)((Object)cmEx));
            }
            catch (XOMarshallerException xoEx) {
                throw new R01MSearchIndexerException("Error al pasar el objeto a XML de estado de las indexaciones para el contenido " + contentOid, (Exception)((Object)xoEx));
            }
        }
        if (documentIndexersStateMap != null) {
            for (Map.Entry entry : documentIndexersStateMap.entrySet()) {
                String documentOid = (String)entry.getKey();
                R01PIndexStatesByIndexer documentIndexerStates = (R01PIndexStatesByIndexer)entry.getValue();
                if (orderedIndexers != null && (documentIndexerStates.getIndexers() == null || documentIndexerStates.getIndexers().isEmpty())) {
                    List<R01KSearchEngineIndexer> documentOrderedIndexers = orderedIndexers[0];
                    ArrayList<R01PIndexStatesByIndexerElement> indexersStates = new ArrayList<R01PIndexStatesByIndexerElement>();
                    for (R01KSearchEngineIndexer defaultIndexer : documentOrderedIndexers) {
                        R01PIndexStatesByIndexerElement indexer = new R01PIndexStatesByIndexerElement();
                        indexer.setIndexerClassName(defaultIndexer.getClass().getName());
                        indexer.setMessage("OK: The indexer has never been executed.");
                        indexer.setState(R01KSearchEngineIndexer.INDEX_FINISHED_OK);
                        indexersStates.add(indexer);
                    }
                    documentIndexerStates.setIndexers(indexersStates);
                }
                for (R01PIndexStatesByIndexerElement indexer : documentIndexerStates.getIndexers()) {
                    if (indexer.getState() != initialState) continue;
                    indexer.setState(finalState);
                    indexer.setMessage(message);
                }
                try {
                    contentAPI.setDocumentIndexersState(documentOid, XOManager.getXML((String)R01MConstants.INDEXABLEOBJECTS_MAPFILE, (Object)documentIndexerStates));
                }
                catch (R01MSecurityException secEx) {
                    throw new R01MSearchIndexerException("Error al actualizar el XML de estado de las indexaciones para el documento " + documentOid, (Exception)((Object)secEx));
                }
                catch (R01MContentModelException cmEx) {
                    throw new R01MSearchIndexerException("Error al actualizar el XML de estado de las indexaciones para el documento " + documentOid, (Exception)((Object)cmEx));
                }
                catch (XOMarshallerException xoEx) {
                    throw new R01MSearchIndexerException("Error al pasar el objeto a XML de estado de las indexaciones para el documento " + documentOid, (Exception)((Object)xoEx));
                }
            }
        }
    }

    public void _setIndexStatesInContentAndDocuments(R01MContentModelAPI contentAPI, String contentOid, R01PIndexStatesByIndexer contentIndexerStates, Map<String, R01PIndexStatesByIndexer> documentIndexersStateMap, int state, String message, List<String> indexers) throws R01MSearchIndexerException {
        List<R01KSearchEngineIndexer>[] orderedIndexers = this._loadOrderedIndexers(contentOid, 0);
        if (contentIndexerStates != null) {
            if (orderedIndexers != null && (contentIndexerStates.getIndexers() == null || contentIndexerStates.getIndexers().isEmpty())) {
                List<R01KSearchEngineIndexer> contentOrderedIndexers = orderedIndexers[1];
                ArrayList<R01PIndexStatesByIndexerElement> arrayList = new ArrayList<R01PIndexStatesByIndexerElement>();
                for (R01KSearchEngineIndexer defaultIndexer : contentOrderedIndexers) {
                    R01PIndexStatesByIndexerElement indexer = new R01PIndexStatesByIndexerElement();
                    indexer.setIndexerClassName(defaultIndexer.getClass().getName());
                    indexer.setMessage("OK: The indexer has never been executed.");
                    indexer.setState(R01KSearchEngineIndexer.INDEX_FINISHED_OK);
                    arrayList.add(indexer);
                }
                contentIndexerStates.setIndexers(arrayList);
            }
            for (R01PIndexStatesByIndexerElement r01PIndexStatesByIndexerElement : contentIndexerStates.getIndexers()) {
                if (indexers != null && !indexers.isEmpty() && !indexers.contains(r01PIndexStatesByIndexerElement.getIndexerClassName())) continue;
                r01PIndexStatesByIndexerElement.setMessage(message);
                r01PIndexStatesByIndexerElement.setState(state);
            }
            try {
                contentAPI.setContentIndexersState(contentOid, XOManager.getXML((String)R01MConstants.INDEXABLEOBJECTS_MAPFILE, (Object)contentIndexerStates));
            }
            catch (R01MSecurityException secEx) {
                throw new R01MSearchIndexerException("Error al actualizar el XML de estado de las indexaciones para el contenido " + contentOid, (Exception)((Object)secEx));
            }
            catch (R01MContentModelException cmEx) {
                throw new R01MSearchIndexerException("Error al actualizar el XML de estado de las indexaciones para el contenido " + contentOid, (Exception)((Object)cmEx));
            }
            catch (XOMarshallerException xoEx) {
                throw new R01MSearchIndexerException("Error al pasar el objeto a XML de estado de las indexaciones para el contenido " + contentOid, (Exception)((Object)xoEx));
            }
        }
        if (documentIndexersStateMap != null) {
            for (Map.Entry entry : documentIndexersStateMap.entrySet()) {
                String documentOid = (String)entry.getKey();
                R01PIndexStatesByIndexer documentIndexerStates = (R01PIndexStatesByIndexer)entry.getValue();
                if (orderedIndexers != null && (documentIndexerStates.getIndexers() == null || documentIndexerStates.getIndexers().isEmpty())) {
                    List<R01KSearchEngineIndexer> documentOrderedIndexers = orderedIndexers[0];
                    ArrayList<R01PIndexStatesByIndexerElement> indexersStates = new ArrayList<R01PIndexStatesByIndexerElement>();
                    for (R01KSearchEngineIndexer defaultIndexer : documentOrderedIndexers) {
                        R01PIndexStatesByIndexerElement indexer = new R01PIndexStatesByIndexerElement();
                        indexer.setIndexerClassName(defaultIndexer.getClass().getName());
                        indexer.setMessage("OK: The indexer has never been executed.");
                        indexer.setState(R01KSearchEngineIndexer.INDEX_FINISHED_OK);
                        indexersStates.add(indexer);
                    }
                    documentIndexerStates.setIndexers(indexersStates);
                }
                for (R01PIndexStatesByIndexerElement indexer : documentIndexerStates.getIndexers()) {
                    if (indexers != null && !indexers.isEmpty() && !indexers.contains(indexer.getIndexerClassName())) continue;
                    indexer.setMessage(message);
                    indexer.setState(state);
                }
                try {
                    contentAPI.setDocumentIndexersState(documentOid, XOManager.getXML((String)R01MConstants.INDEXABLEOBJECTS_MAPFILE, (Object)documentIndexerStates));
                }
                catch (R01MSecurityException secEx) {
                    throw new R01MSearchIndexerException("Error al actualizar el XML de estado de las indexaciones para el documento " + documentOid, (Exception)((Object)secEx));
                }
                catch (R01MContentModelException cmEx) {
                    throw new R01MSearchIndexerException("Error al actualizar el XML de estado de las indexaciones para el documento " + documentOid, (Exception)((Object)cmEx));
                }
                catch (XOMarshallerException xoEx) {
                    throw new R01MSearchIndexerException("Error al pasar el objeto a XML de estado de las indexaciones para el documento " + documentOid, (Exception)((Object)xoEx));
                }
            }
        }
    }

    private Map<String, R01KSearchEngineIndexer[]> _loadOrderedIndexers(List<R01MSearchSourceIndexer> indexersList) throws R01MSearchIndexerQueueProcessorException {
        Map sortedToIndexIndexer = null;
        Map sortedToUnindexIndexer = null;
        try {
            sortedToIndexIndexer = CollectionUtils.convertListIntoMap(indexersList, (String)SORT_TO_INDEX_ID, (boolean)false);
            sortedToUnindexIndexer = CollectionUtils.convertListIntoMap(indexersList, (String)SORT_TO_UNINDEX_ID, (boolean)false);
        }
        catch (CollectionConverterException ccEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("R01KSearchOrchestratorIndexer: Error al tratar de ordenar los indexadores para su ejecuci\u00f3n ordenada seg\u00fan sea una indexaci\u00f3n o desindexaci\u00f3n: " + ccEx.getMessage());
        }
        HashMap<String, R01KSearchEngineIndexer[]> sortedIndexers = new HashMap<String, R01KSearchEngineIndexer[]>();
        this._addSortIndexerList(sortedToIndexIndexer, indexersList, sortedIndexers, SORT_TO_INDEX_ID);
        this._addSortIndexerList(sortedToUnindexIndexer, indexersList, sortedIndexers, SORT_TO_UNINDEX_ID);
        return sortedIndexers;
    }

    private void _addSortIndexerList(Map<String, R01MSearchSourceIndexer> sortedToIndexIndexer, List<R01MSearchSourceIndexer> indexersList, Map<String, R01KSearchEngineIndexer[]> sortedIndexers, String TypeOfSortId) throws R01MSearchIndexerQueueProcessorException {
        ArrayList sortedIndexersList;
        if (sortedToIndexIndexer != null) {
            ArrayList<String> valuesOfOrder = new ArrayList<String>(sortedToIndexIndexer.keySet());
            Collections.sort(valuesOfOrder);
            ArrayList<R01MSearchSourceIndexer> sortedList = new ArrayList<R01MSearchSourceIndexer>();
            for (int i = 0; i < valuesOfOrder.size(); ++i) {
                sortedList.add(sortedToIndexIndexer.get(valuesOfOrder.get(i)));
            }
            sortedIndexersList = (ArrayList)this._loadIndexers(sortedList);
        } else {
            sortedIndexersList = (ArrayList)this._loadIndexers(indexersList);
        }
        if (sortedIndexersList != null) {
            sortedIndexers.put(TypeOfSortId, sortedIndexersList.toArray(new R01KSearchEngineIndexer[sortedIndexersList.size()]));
        } else {
            sortedIndexers.put(TypeOfSortId, null);
        }
    }

    private List<R01KSearchEngineIndexer> _loadIndexers(List<R01MSearchSourceIndexer> sortedIndexersList) throws R01MSearchIndexerQueueProcessorException {
        ArrayList<R01KSearchEngineIndexer> indexers = null;
        if (sortedIndexersList != null && !sortedIndexersList.isEmpty()) {
            indexers = new ArrayList<R01KSearchEngineIndexer>();
            R01MSearchSourceIndexer currIndexer = null;
            R01KSearchEngineIndexer indexerImpl = null;
            for (int i = 0; i < sortedIndexersList.size(); ++i) {
                currIndexer = sortedIndexersList.get(i);
                if (!currIndexer.isActive()) continue;
                try {
                    indexerImpl = (R01KSearchEngineIndexer)ReflectionUtils.getObjectInstance((String)currIndexer.getImplClassName());
                }
                catch (ReflectionException refExc) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01KSearchOrchestratorIndexer > Error en la carga de Indexadores. Error:" + refExc.getMessage());
                    throw new R01MSearchIndexerQueueProcessorException("Error en la carga de Indexadores, revisa el fichero r01kSearchEngineConfig.xml . Error:" + refExc.getMessage(), (Exception)((Object)refExc));
                }
                Map props = currIndexer.getProperties();
                if (props != null) {
                    Properties properties = new Properties();
                    properties.clear();
                    properties.putAll((Map<?, ?>)props);
                    indexerImpl.setProperties(properties);
                }
                indexerImpl.setNativeDateFormat(currIndexer.getNativeDateFormat() != null ? currIndexer.getNativeDateFormat() : "dd/MM/yyyy");
                indexers.add(indexerImpl);
            }
        }
        return indexers;
    }

    private Map<String, R01KSearchEngineIndexer[]> _loadIndexers(String objectOid, int objectType) {
        HashMap<String, R01KSearchEngineIndexer[]> orderedIndexers = null;
        Object[] indexersOrderedToIndex = new R01KSearchEngineIndexer[]{};
        Object[] indexersOrderedToUnindex = new R01KSearchEngineIndexer[]{};
        String theContext = !StringUtils.isEmptyString((String)this._context) ? this._context : R01MSearchEngineUtils.obtainContext((String)XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"searchEngine/defaultSearchEngineContext"), null);
        Map searchSources = null;
        try {
            searchSources = R01MClientFactory.getSearchEngineConfigAPI().getSearchEngineConfig().getSearchSources(theContext);
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            R01FLog.to((String)LOG_TYPE_ID).warning("R01KSearchOrchestratorIndexer._loadIndexers > Error al recoger la configuraci\u00f3n del motor de b\u00fasqueda para recoger los indexadores comunes. Error:" + cfgLoadEx.getMessage());
        }
        if (searchSources != null && !searchSources.isEmpty()) {
            for (Map.Entry meSearchSources : searchSources.entrySet()) {
                R01MSearchSource searchSource = (R01MSearchSource)meSearchSources.getValue();
                try {
                    Map<String, R01KSearchEngineIndexer[]> orderedSourceIndexers = this._loadOrderedIndexers(searchSource.getIndexers());
                    indexersOrderedToIndex = (R01KSearchEngineIndexer[])ArrayUtils.addAll((Object[])indexersOrderedToIndex, (Object[])orderedSourceIndexers.get(SORT_TO_INDEX_ID));
                    indexersOrderedToUnindex = (R01KSearchEngineIndexer[])ArrayUtils.addAll((Object[])indexersOrderedToUnindex, (Object[])orderedSourceIndexers.get(SORT_TO_UNINDEX_ID));
                }
                catch (R01MSearchIndexerQueueProcessorException siqEx) {
                    R01FLog.to((String)LOG_TYPE_ID).warning("R01KSearchOrchestratorIndexer._loadIndexers > Error al recoger los indexadores para el origen " + searchSource.getInternalName() + ". " + "Error:" + siqEx.getMessage());
                }
            }
        }
        R01MContentTypologyInfo typo = null;
        if (objectType == 3 || objectType == 4 || objectType == 5) {
            typo = new R01MContentTypologyInfo();
            typo.setTypeOid(R01MConstants.PORTAL_TYPE_ID);
            typo.setFamilyOid(R01MConstants.PORTAL_FAMILY_ID);
            typo.setClusterOid(R01MConstants.PORTAL_CLUSTER_ID);
        } else {
            try {
                typo = this._execLoadObjectTypology(objectOid, objectType);
            }
            catch (R01MSearchIndexerException siEx) {
                R01FLog.to((String)LOG_TYPE_ID).warning("R01KSearchOrchestratorIndexer._loadIndexers > No se puede coger la tipolog\u00eda del modelo de R01K.\nNo existe el objeto " + objectOid + " de tipo " + objectType + " en las tablas de R01K. Se recoger\u00e1n los datos de R01D.");
            }
            if (typo == null) {
                try {
                    R01MContentModelAPI api = R01MClientFactory.getContentModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext());
                    if (api.checkContentExistence(objectOid)) {
                        typo = api.loadContentTypology(objectOid, objectType);
                    }
                }
                catch (Exception ex) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01KSearchOrchestratorIndexer._loadIndexers > Error al obtener la tipolog\u00eda del objeto " + objectOid + " de tipo " + objectType + ". Error al obtener el tipo de los datos de r01d. " + "Error:" + ex.getMessage());
                    return null;
                }
            }
        }
        if (typo != null) {
            R01MContentType typologyConfig = null;
            try {
                typologyConfig = R01MClientFactory.getTypologyConfigAPI().getTypeConfig(typo.getClusterOid(), typo.getFamilyOid(), typo.getTypeOid());
                try {
                    Map<String, R01KSearchEngineIndexer[]> sortedIndexers = this._loadOrderedIndexers(typologyConfig.getTypoIndexer());
                    indexersOrderedToIndex = (R01KSearchEngineIndexer[])ArrayUtils.addAll((Object[])indexersOrderedToIndex, (Object[])sortedIndexers.get(SORT_TO_INDEX_ID));
                    indexersOrderedToUnindex = (R01KSearchEngineIndexer[])ArrayUtils.addAll((Object[])indexersOrderedToUnindex, (Object[])sortedIndexers.get(SORT_TO_UNINDEX_ID));
                }
                catch (R01MSearchIndexerQueueProcessorException siqEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01KSearchOrchestratorIndexer._loadIndexers > Error al recoger los indexadores propios de la tipolog\u00eda:  cluster " + typo.getClusterOid() + ", familia" + typo.getFamilyOid() + " y  tipo " + typo.getTypeOid() + ". " + "Error:" + siqEx.getMessage());
                    return null;
                }
            }
            catch (R01MConfigLoadException clEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("R01KSearchOrchestratorIndexer._loadIndexers > Error al cargar la configuraci\u00f3n de la tipolog\u00eda para el cluster " + typo.getClusterOid() + ", la familia" + typo.getFamilyOid() + " y el tipo " + typo.getTypeOid() + ". Objeto " + objectOid + " y tipo de objeto: " + objectType + "Error:" + clEx.getMessage());
                return null;
            }
        }
        if (indexersOrderedToIndex != null && indexersOrderedToIndex.length > 0 || indexersOrderedToUnindex != null && indexersOrderedToUnindex.length > 0) {
            orderedIndexers = new HashMap<String, R01KSearchEngineIndexer[]>();
        }
        if (indexersOrderedToIndex != null && indexersOrderedToIndex.length > 0) {
            orderedIndexers.put(SORT_TO_INDEX_ID, (R01KSearchEngineIndexer[])indexersOrderedToIndex);
        }
        if (indexersOrderedToUnindex != null && indexersOrderedToUnindex.length > 0) {
            orderedIndexers.put(SORT_TO_UNINDEX_ID, (R01KSearchEngineIndexer[])indexersOrderedToUnindex);
        }
        return orderedIndexers;
    }

    public void execIndexFinished(String objectOid, int objectType, String message, Map<String, String> resultsPerIndexer) throws R01MSearchIndexerException {
        if (SEND_INDEX_FINISHED_MESSAGES) {
            ArrayList<R01MJmsQueueParam> params = new ArrayList<R01MJmsQueueParam>();
            params.add(new R01MJmsQueueParam(1, "proccessType", (Object)"index"));
            params.add(new R01MJmsQueueParam(1, "objectOid", (Object)objectOid));
            params.add(new R01MJmsQueueParam(3, "objectType", (Object)Integer.toString(objectType)));
            params.add(new R01MJmsQueueParam(1, "message", (Object)message));
            params.add(new R01MJmsQueueParam(1, "resultsPerIndexer", (Object)(resultsPerIndexer == null || resultsPerIndexer.isEmpty() ? "" : resultsPerIndexer.toString())));
            String JMSQueueId = "r01ProccessIndexFinished";
            try {
                R01MJMSUtils.sendJMSMessage((String)JMSQueueId, params);
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("Notificaci\u00f3n de la fin del proceso de indexaci\u00f3n del objeto " + objectOid + " de tipo " + R01MConstants.OBJECT_DESCS[objectType] + " correcta.");
                }
            }
            catch (R01MJMSException jmsExc) {
                throw new R01MSearchIndexerException("Error en la notificaci\u00f3n de la fin del proceso de indexaci\u00f3n del objeto " + objectOid + " de tipo " + R01MConstants.OBJECT_DESCS[objectType] + ". Error: " + jmsExc.getMessage(), (Exception)((Object)jmsExc));
            }
        }
    }

    public void execPostIndexFinished(String objectOid, int objectType, String message, Map<String, String> resultsPerIndexer) throws R01MSearchIndexerException {
        if (SEND_INDEX_FINISHED_MESSAGES) {
            ArrayList<R01MJmsQueueParam> params = new ArrayList<R01MJmsQueueParam>();
            params.add(new R01MJmsQueueParam(1, "proccessType", (Object)"postIndex"));
            params.add(new R01MJmsQueueParam(1, "objectOid", (Object)objectOid));
            params.add(new R01MJmsQueueParam(3, "objectType", (Object)Integer.toString(objectType)));
            params.add(new R01MJmsQueueParam(1, "message", (Object)message));
            params.add(new R01MJmsQueueParam(1, "resultsPerIndexer", (Object)resultsPerIndexer.toString()));
            String JMSQueueId = "r01ProccessIndexFinished";
            try {
                R01MJMSUtils.sendJMSMessage((String)JMSQueueId, params);
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("Notificaci\u00f3n de la fin del proceso postIndex del objeto " + objectOid + " de tipo " + R01MConstants.OBJECT_DESCS[objectType] + " correcta.");
                }
            }
            catch (R01MJMSException jmsExc) {
                throw new R01MSearchIndexerException("Error en la notificaci\u00f3n de la fin del proceso postIndex del objeto " + objectOid + " de tipo " + R01MConstants.OBJECT_DESCS[objectType] + ". Error: " + jmsExc.getMessage(), (Exception)((Object)jmsExc));
            }
        }
    }

    public void execPreIndexFinished(String objectOid, int objectType, String message, Map<String, String> resultsPerIndexer) throws R01MSearchIndexerException {
        if (SEND_INDEX_FINISHED_MESSAGES) {
            ArrayList<R01MJmsQueueParam> params = new ArrayList<R01MJmsQueueParam>();
            params.add(new R01MJmsQueueParam(1, "proccessType", (Object)"preIndex"));
            params.add(new R01MJmsQueueParam(1, "objectOid", (Object)objectOid));
            params.add(new R01MJmsQueueParam(3, "objectType", (Object)Integer.toString(objectType)));
            params.add(new R01MJmsQueueParam(1, "message", (Object)message));
            params.add(new R01MJmsQueueParam(1, "resultsPerIndexer", (Object)resultsPerIndexer.toString()));
            String JMSQueueId = "r01ProccessIndexFinished";
            try {
                R01MJMSUtils.sendJMSMessage((String)JMSQueueId, params);
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("Notificaci\u00f3n de la fin del proceso preIndex del objeto " + objectOid + " de tipo " + R01MConstants.OBJECT_DESCS[objectType] + " correcta.");
                }
            }
            catch (R01MJMSException jmsExc) {
                throw new R01MSearchIndexerException("Error en la notificaci\u00f3n de la fin del proceso preIndex del objeto " + objectOid + " de tipo " + R01MConstants.OBJECT_DESCS[objectType] + ". Error: " + jmsExc.getMessage(), (Exception)((Object)jmsExc));
            }
        }
    }

    public void execPrepareToIndexFinished(String objectOid, int objectType, String message, Map<String, String> resultsPerIndexer) throws R01MSearchIndexerException {
        if (SEND_INDEX_FINISHED_MESSAGES) {
            ArrayList<R01MJmsQueueParam> params = new ArrayList<R01MJmsQueueParam>();
            params.add(new R01MJmsQueueParam(1, "proccessType", (Object)"prepareToIndex"));
            params.add(new R01MJmsQueueParam(1, "objectOid", (Object)objectOid));
            params.add(new R01MJmsQueueParam(3, "objectType", (Object)Integer.toString(objectType)));
            params.add(new R01MJmsQueueParam(1, "message", (Object)message));
            params.add(new R01MJmsQueueParam(1, "resultsPerIndexer", (Object)resultsPerIndexer.toString()));
            String JMSQueueId = "r01ProccessIndexFinished";
            try {
                R01MJMSUtils.sendJMSMessage((String)JMSQueueId, params);
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("Notificaci\u00f3n de la fin del proceso prepareToIndex del objeto " + objectOid + " de tipo " + R01MConstants.OBJECT_DESCS[objectType] + " correcta.");
                }
            }
            catch (R01MJMSException jmsExc) {
                throw new R01MSearchIndexerException("Error en la notificaci\u00f3n de la fin del proceso prepareToIndex del objeto " + objectOid + " de tipo " + R01MConstants.OBJECT_DESCS[objectType] + ". Error: " + jmsExc.getMessage(), (Exception)((Object)jmsExc));
            }
        }
    }

    public void executeIndexation(R01MIndexDefinition indexElement, String managerClassName) throws R01MSearchIndexerException {
        String objectOid = indexElement.getObjectOid();
        int objectType = indexElement.getObjectType();
        if (R01KTraceIndexHelper.TRACE_INDEX_ACTIVATED) {
            if (objectType == 1 || objectType == 4) {
                R01KTraceIndexHelper.initTraceIndex((String)objectOid, (int)indexElement.getObjectType(), (int)indexElement.getIndexType());
            } else if (objectType == 0) {
                try {
                    R01MContent theContent = R01MClientFactory.getContentModelAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext()).loadContent(objectOid);
                    if (theContent.getDocuments() != null && !theContent.getDocuments().isEmpty()) {
                        for (String documentOid : theContent.getDocuments().keySet()) {
                            R01KTraceIndexHelper.initTraceIndex((String)documentOid, (int)indexElement.getObjectType(), (int)indexElement.getIndexType());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
        ArrayList<R01MJmsQueueParam> params = new ArrayList<R01MJmsQueueParam>();
        params.add(new R01MJmsQueueParam(3, "indexType", (Object)Integer.toString(indexElement.getIndexType())));
        params.add(new R01MJmsQueueParam(1, "objectOid", (Object)objectOid));
        params.add(new R01MJmsQueueParam(3, "objectType", (Object)Integer.toString(objectType)));
        params.add(new R01MJmsQueueParam(1, "managerClass", (Object)managerClassName));
        String metadataFileNamesStr = indexElement.getMetadataFileNames() == null ? null : org.apache.commons.lang.StringUtils.join((Object[])indexElement.getMetadataFileNames().toArray(), (String)",");
        params.add(new R01MJmsQueueParam(1, "metadataFileNames", (Object)metadataFileNamesStr));
        params.add(new R01MJmsQueueParam(1, "indexers", (Object)(indexElement.getIndexers() == null ? "" : indexElement.getIndexers().toString().replaceFirst("\\[", "").replaceFirst("\\]", ""))));
        params.add(new R01MJmsQueueParam(2, "publishIndexData", (Object)Boolean.toString(indexElement.isPublishIndexData())));
        params.add(new R01MJmsQueueParam(1, "indexFilesToPublish", (Object)(indexElement.getIndexFilesToPublish() != null ? indexElement.getIndexFilesToPublish() : "")));
        params.add(new R01MJmsQueueParam(3, "publicationType", (Object)Integer.toString(indexElement.getPublicationType())));
        params.add(new R01MJmsQueueParam(1, "pubDateInMillis", (Object)(indexElement.getPublicationDate() != null ? Long.toString(indexElement.getPublicationDate().getTime()) : "")));
        params.add(new R01MJmsQueueParam(1, "repositoryOid", (Object)(indexElement.getRepositoryOids() == null ? "" : indexElement.getRepositoryOids().toString().replaceFirst("\\[", "").replaceFirst("\\]", ""))));
        params.add(new R01MJmsQueueParam(3, "indexIteration", (Object)Integer.toString(indexElement.getIteration())));
        String JMSQueueId = "r01IndexObject";
        try {
            R01MJMSUtils.sendJMSMessage((String)JMSQueueId, params, (long)DEFAULT_TIME_TO_DELIVER);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("Enviado mensaje de indexaci\u00f3n del objeto " + objectOid + " de tipo " + R01MConstants.OBJECT_DESCS[objectType] + ". Operaci\u00f3n lanzada correctamente.");
            }
        }
        catch (R01MJMSException jmsExc) {
            throw new R01MSearchIndexerException("Error en el env\u00edo del mensaje de indexaci\u00f3n del objeto " + objectOid + " de tipo " + R01MConstants.OBJECT_DESCS[objectType] + ". Error: " + jmsExc.getMessage(), (Exception)((Object)jmsExc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execPerformIndex(R01MIndexDefinition indexElement, String managerClassName) throws R01MSearchIndexerException {
        block60: {
            String objectOid = indexElement.getObjectOid();
            int objectType = indexElement.getObjectType();
            if (StringUtils.isEmptyString((String)managerClassName)) {
                throw new R01MSearchIndexerException("Error al ejecutar la indexaci\u00f3n. El nombre de la clase manejadora de la indexaci\u00f3n es nulo o vac\u00edo.");
            }
            if (StringUtils.isEmptyString((String)objectOid)) {
                throw new R01MSearchIndexerException("Error al ejecutar la indexaci\u00f3n. El oid del objeto a indexar es nulo o vac\u00edo.");
            }
            R01KIndexerManager indexerManager = null;
            try {
                indexerManager = (R01KIndexerManager)ReflectionUtils.getObjectInstance((String)managerClassName, null, null, (boolean)true);
            }
            catch (ReflectionException rEx) {
                throw new R01MSearchIndexerException("Error al instanciar la clase manejadora de la indexaci\u00f3n " + managerClassName + ". Error: " + rEx.getMessage(), (Exception)((Object)rEx));
            }
            boolean traceIndex = false;
            boolean isContentManagerIndexProcess = false;
            String contentOid = null;
            R01MContentModelAPI contentAPI = null;
            if (objectType == 0 || objectType == 1) {
                isContentManagerIndexProcess = true;
                R01MUserContext adminContext = null;
                try {
                    adminContext = R01MAuthManager.createMasterSystemUserContext();
                }
                catch (R01MSecurityException secEx) {
                    throw new R01MSearchIndexerException("Error al tratar de obtener el contexto del usuario administrador", (Exception)((Object)secEx));
                }
                contentAPI = R01MClientFactory.getContentModelAPI((R01MUserContext)adminContext);
            }
            if (isContentManagerIndexProcess && indexElement.getIndexType() == 0) {
                traceIndex = TRACE_INDEX;
                if (!this._concurrenceManagement(objectType, objectOid, indexElement, contentAPI)) {
                    return;
                }
                ArrayList<String> documentOids = new ArrayList<String>();
                if (objectType == 1) {
                    try {
                        contentOid = contentAPI.getDocumentParentContent(objectOid);
                    }
                    catch (R01MSecurityException secEx) {
                        throw new R01MSearchIndexerException("Error al cargar el oid del contenido para el documento " + objectOid + ": " + secEx.getMessage(), (Exception)((Object)secEx));
                    }
                    catch (R01MContentModelException cmEx) {
                        throw new R01MSearchIndexerException("Error al cargar el oid del contenido para el documento " + objectOid + ": " + cmEx.getMessage(), (Exception)((Object)cmEx));
                    }
                    documentOids.add(objectOid);
                } else {
                    contentOid = objectOid;
                    documentOids = this._loadDocumentsOids(contentAPI, contentOid);
                }
                R01PIndexStatesByIndexer contentIndexerStates = this.loadContentIndexerState(contentAPI, contentOid);
                Map<String, R01PIndexStatesByIndexer> documentIndexersStateMap = this.loadDocumentIndexersStateMap(contentAPI, documentOids);
                try {
                    this._updateIndexStatesInContentAndDocuments(contentAPI, contentOid, contentIndexerStates, documentIndexersStateMap, R01KSearchEngineIndexer.INDEX_REQUESTED, R01KSearchEngineIndexer.INDEX_RUNNING, "RUNNING: Indexer is currently running");
                }
                catch (R01MSearchIndexerException siEx) {
                    throw new R01MSearchIndexerException("Error al actualizar el XML de estado de las indexaciones para el contenido " + contentOid + ": " + siEx.getMessage(), (Exception)((Object)siEx));
                }
            }
            try {
                R01KIndexInfoCMPValue traceVO = null;
                String traceManagerClassName = managerClassName.substring(managerClassName.lastIndexOf(46) + 1, managerClassName.length());
                if (traceIndex && isContentManagerIndexProcess) {
                    try {
                        Collection indexInfoCMPs = R01KIndexInfoCMPUtil.getLocalHome().findByIndexer(contentOid, indexElement.getObjectOid(), traceManagerClassName);
                        if (indexInfoCMPs != null && !indexInfoCMPs.isEmpty()) {
                            for (R01KIndexInfoCMPLocal currIndexInfoCMP : indexInfoCMPs) {
                                currIndexInfoCMP.remove();
                            }
                        }
                        traceVO = new R01KIndexInfoCMPValue();
                        traceVO.setContentOid(contentOid);
                        traceVO.setObjectOid(indexElement.getObjectOid());
                        traceVO.setIndexerType(traceManagerClassName);
                    }
                    catch (Exception ex) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("No se pueden borrar los registros de traceado de la indexaci\u00f3n de la tabla R01K60T00 para el contenido '" + contentOid + "', objeto indexable '" + indexElement.getObjectOid() + "', traceManagerClassName '" + traceManagerClassName + "'. Error:" + ex.getMessage());
                        traceIndex = false;
                    }
                }
                try {
                    if (traceIndex && isContentManagerIndexProcess) {
                        traceVO.setIndexerStep(0);
                        R01KTraceUtils.traceIndex(traceVO, 1, null);
                    }
                    try {
                        indexerManager.prepareToIndex(indexElement);
                    }
                    catch (Exception siEx) {
                        if (traceIndex) {
                            R01KTraceUtils.traceIndex(traceVO, 3, siEx);
                        }
                        throw new R01MSearchIndexerException("Error al preparar los datos para la indexaci\u00f3n del objeto " + objectOid + " de tipo " + Integer.toString(objectType) + " con la clase manejadora de indexaci\u00f3n " + managerClassName + ". Error:" + siEx.getMessage(), siEx);
                    }
                    if (traceIndex && isContentManagerIndexProcess) {
                        R01KTraceUtils.traceIndex(traceVO, 2, null);
                        traceVO.setIndexerStep(1);
                        R01KTraceUtils.traceIndex(traceVO, 1, null);
                    }
                    try {
                        indexerManager.preIndex(indexElement);
                    }
                    catch (Exception siEx) {
                        if (traceIndex && isContentManagerIndexProcess) {
                            R01KTraceUtils.traceIndex(traceVO, 3, siEx);
                        }
                        throw new R01MSearchIndexerException("Error al ejecutar las acciones previas a la indexaci\u00f3n del objeto " + objectOid + " de tipo " + Integer.toString(objectType) + " con la clase manejadora de indexaci\u00f3n " + managerClassName + ". Error:" + siEx.getMessage(), siEx);
                    }
                    if (traceIndex && isContentManagerIndexProcess) {
                        R01KTraceUtils.traceIndex(traceVO, 2, null);
                        traceVO.setIndexerStep(2);
                        R01KTraceUtils.traceIndex(traceVO, 1, null);
                    }
                    try {
                        indexerManager.index(indexElement);
                    }
                    catch (Exception siEx) {
                        if (traceIndex && isContentManagerIndexProcess) {
                            R01KTraceUtils.traceIndex(traceVO, 3, siEx);
                        }
                        throw new R01MSearchIndexerException("MANAGE INDEX >> Error al ejecutar la indexaci\u00f3n del objeto " + objectOid + " de tipo " + Integer.toString(objectType) + " con la clase manejadora de indexaci\u00f3n " + managerClassName + ". Error:" + siEx.getMessage(), siEx);
                    }
                    if (traceIndex && isContentManagerIndexProcess) {
                        R01KTraceUtils.traceIndex(traceVO, 2, null);
                        traceVO.setIndexerStep(3);
                        R01KTraceUtils.traceIndex(traceVO, 1, null);
                    }
                    try {
                        indexerManager.postIndex(indexElement);
                    }
                    catch (Exception siEx) {
                        if (traceIndex && isContentManagerIndexProcess) {
                            R01KTraceUtils.traceIndex(traceVO, 3, siEx);
                        }
                        throw new R01MSearchIndexerException("MANAGE INDEX >> Error al ejecutar las acciones posteriores a la indexaci\u00f3n del objeto " + objectOid + " de tipo " + Integer.toString(objectType) + " con la clase manejadora de indexaci\u00f3n " + managerClassName + ". Error:" + siEx.getMessage(), siEx);
                    }
                    if (traceIndex && isContentManagerIndexProcess) {
                        R01KTraceUtils.traceIndex(traceVO, 2, null);
                    }
                }
                finally {
                    if (isContentManagerIndexProcess && indexElement.getIndexType() == 0) {
                        this._resetContentModelIndexFlags(objectType, objectOid, contentAPI);
                    }
                }
            }
            catch (R01MSearchIndexerException siEx) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).warning("R01KSearchOrchestratorIndexer - execPerformIndex >>>> Se ha producido un error en el proceso de indexaci\u00f3n del objeto " + objectOid + " de tipo " + objectType + ". Error: " + siEx.getMessage());
                }
                if (indexElement.getIndexType() != 0) break block60;
                if (objectType == 0) {
                    try {
                        if (!contentAPI.checkContentExistence(objectOid)) {
                            this._sendIndexMessage(objectOid, 0, null, 1);
                        }
                    }
                    catch (R01MSecurityException secEx) {
                        throw new R01MSearchIndexerException("En el tratamiento de excepciones.Al comprobar la existencia del contenido " + objectOid + " " + "en el modelo de contenidos: " + secEx.getMessage(), (Exception)((Object)secEx));
                    }
                    catch (R01MContentModelException cmEx) {
                        throw new R01MSearchIndexerException("En el tratamiento de excepciones.Al comprobar la existencia del contenido " + objectOid + " " + "en el modelo de contenidos: " + cmEx.getMessage(), (Exception)((Object)cmEx));
                    }
                }
                if (objectType != 1) break block60;
                R01KIndexableDocumentCMPPK pkDocument = new R01KIndexableDocumentCMPPK(objectOid);
                try {
                    contentOid = R01KIndexableDocumentCMPUtil.getLocalHome().findByPrimaryKey(pkDocument).getOidContent();
                }
                catch (NamingException namEx) {
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("R01KSearchOrchestratorIndexer - execPerformIndex >>>> En el tratamiento de excepciones. Al obtener el oid del contenido para el documento " + objectOid + " " + "desde las tablas de r01k. Error: " + namEx.getMessage());
                    }
                    throw new R01MSearchIndexerException("En el tratamiento de excepciones.Error al obtener el oid del contenido para el documento " + objectOid + ": " + namEx.getMessage(), (Exception)namEx);
                }
                catch (FinderException findEx) {
                    throw new R01MSearchIndexerException("En el tratamiento de excepciones.El documento " + objectOid + ", " + "no se encuentra en las tablas de r01k: " + findEx.getMessage(), (Exception)((Object)findEx));
                }
                try {
                    if (!contentAPI.checkContentExistence(contentOid)) {
                        this._sendIndexMessage(contentOid, 0, null, 1);
                    } else if (!contentAPI.checkDocumentExistence(objectOid)) {
                        this._sendIndexMessage(contentOid, 0, null, 0);
                    }
                }
                catch (R01MSecurityException secEx) {
                    throw new R01MSearchIndexerException("En el tratamiento de excepciones.Al comprobar la existencia del contenido " + contentOid + " " + " o el documento " + objectOid + " " + "en el modelo de contenidos: " + secEx.getMessage(), (Exception)((Object)secEx));
                }
                catch (R01MContentModelException cmEx) {
                    throw new R01MSearchIndexerException("En el tratamiento de excepciones.Al comprobar la existencia del contenido " + contentOid + " " + " o el documento " + objectOid + " " + "en el modelo de contenidos: " + cmEx.getMessage(), (Exception)((Object)cmEx));
                }
                throw siEx;
            }
        }
    }

    private boolean _concurrenceManagement(int objectType, String objectOid, R01MIndexDefinition indexElement, R01MContentModelAPI contentAPI) throws R01MSearchIndexerException {
        String contentOid = null;
        try {
            if (!this._indexModelContentModelConcurrence(objectType, objectOid, indexElement, contentAPI)) {
                return false;
            }
            if (indexElement.getIndexType() == 0) {
                contentOid = objectType == 0 || objectType == 4 ? objectOid : contentAPI.getDocumentParentContent(objectOid);
            } else {
                String string = contentOid = objectType == 0 || objectType == 4 ? objectOid : this._getDocumentParentContent(objectOid);
                if (contentOid == null) {
                    return false;
                }
            }
        }
        catch (R01MSecurityException secEx) {
            throw new R01MSearchIndexerException("Error al cargar el oid del contenido para el documento " + objectOid + ": " + secEx.getMessage(), (Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new R01MSearchIndexerException("Error al cargar el oid del contenido para el documento " + objectOid + ": " + cmEx.getMessage(), (Exception)((Object)cmEx));
        }
        ArrayList<String> documentOids = new ArrayList<String>();
        if (objectType == 1) {
            documentOids.add(objectOid);
        } else if (objectType == 0) {
            try {
                if (!contentAPI.checkContentExistence(objectOid)) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            documentOids = this._loadDocumentsOids(contentAPI, contentOid);
        }
        if (indexElement.getIndexType() == 0) {
            R01PIndexStatesByIndexer contentDocument = this.loadContentIndexerState(contentAPI, contentOid);
            Map<String, R01PIndexStatesByIndexer> documentsDocumentMap = this.loadDocumentIndexersStateMap(contentAPI, documentOids);
            this._setIndexStatesInContentAndDocuments(contentAPI, contentOid, contentDocument, documentsDocumentMap, R01KSearchEngineIndexer.INDEX_REQUESTED, "REQUESTED: Index requested", indexElement.getIndexers());
        }
        for (String currentDocumentOid : documentOids) {
            if (!indexElement.isPublishIndexData() || indexElement.getIndexType() != 0) continue;
            try {
                boolean hasToPublish = false;
                hasToPublish = contentAPI.isDocumentPublished(null, currentDocumentOid);
                if (R01KContentIndexerManager.checkDocumentPublishIndexFiles((String)currentDocumentOid)) continue;
                try {
                    contentAPI.setDocumentPublishIndexFiles(currentDocumentOid, hasToPublish);
                }
                catch (R01MSecurityException secEx) {
                    throw new R01MSearchIndexerException("Error al establecer el flag de publicaci\u00f3n de ficheros de indexaci\u00f3n del documento " + objectOid + ": " + secEx.getMessage(), (Exception)((Object)secEx));
                }
                catch (R01MContentModelException cmEx) {
                    throw new R01MSearchIndexerException("Error al establecer el flag de publicaci\u00f3n de ficheros de indexaci\u00f3n del documento " + objectOid + ": " + cmEx.getMessage(), (Exception)((Object)cmEx));
                }
            }
            catch (R01MSecurityException secEx) {
                if (!DEBUG) continue;
                R01FLog.to((String)LOG_TYPE_ID).severe("R01KSearchOrchestratorIndexer - _concurrenceManagement >>>> Se ha producido al verificar si el documento " + currentDocumentOid + " est\u00e1 publicado" + " para publicar los ficheros de indexaci\u00f3n. Error: " + secEx.getMessage());
            }
            catch (R01MContentModelException cmEx) {
                if (!DEBUG) continue;
                R01FLog.to((String)LOG_TYPE_ID).severe("R01KSearchOrchestratorIndexer - _concurrenceManagement >>>> Se ha producido al verificar si el documento " + currentDocumentOid + " est\u00e1 publicado" + " para publicar los ficheros de indexaci\u00f3n. Error: " + cmEx.getMessage());
            }
        }
        if (!this._checkIndexStartDate(contentOid, contentAPI)) {
            return false;
        }
        try {
            contentAPI.setContentIndexStartDate(contentOid, new Date());
        }
        catch (R01MSecurityException secEx) {
            throw new R01MSearchIndexerException("Error al establecer la fecha de inicio del proceso de indexaci\u00f3n del documento " + objectOid + ": " + secEx.getMessage(), (Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new R01MSearchIndexerException("Error al establecer la fecha de inicio del proceso de indexaci\u00f3n del documento " + objectOid + ": " + cmEx.getMessage(), (Exception)((Object)cmEx));
        }
        return true;
    }

    private boolean _indexModelContentModelConcurrence(int objectType, String objectOid, R01MIndexDefinition indexElement, R01MContentModelAPI contentAPI) throws R01MSearchIndexerException {
        block17: {
            if (objectType == 1 && indexElement.getIndexType() == 0) {
                try {
                    if (contentAPI.checkDocumentExistence(objectOid)) break block17;
                    boolean existsContentInR01K = true;
                    R01KIndexableDocumentCMPPK pkDocument = new R01KIndexableDocumentCMPPK(objectOid);
                    String contentOid = null;
                    try {
                        contentOid = R01KIndexableDocumentCMPUtil.getLocalHome().findByPrimaryKey(pkDocument).getOidContent();
                    }
                    catch (NamingException namEx) {
                        if (DEBUG) {
                            R01FLog.to((String)LOG_TYPE_ID).info("R01KSearchOrchestratorIndexer - execPerformIndex >>>> Al obtener el Oid del contenido para el documento " + objectOid + " desde las tablas de r01k. Error: " + namEx.getMessage());
                        }
                        throw new R01MSearchIndexerException("Error al cargar del modelo de contenidos el oid del contenido para el documento " + objectOid + ": " + namEx.getMessage(), (Exception)namEx);
                    }
                    catch (FinderException findEx) {
                        existsContentInR01K = false;
                    }
                    if (existsContentInR01K) {
                        try {
                            if (contentAPI.checkContentExistence(contentOid)) {
                                this._sendIndexMessage(contentOid, 0, null, 0);
                                return false;
                            }
                        }
                        catch (R01MSecurityException secEx) {
                            if (DEBUG) {
                                R01FLog.to((String)LOG_TYPE_ID).info("R01KSearchOrchestratorIndexer - execPerformIndex._initIndexConcurrenceManagement >>>> Error al acceder al modelo de contenidos para comprobar la existencia del contenido " + contentOid + " en las tablas de r01d. Error: " + secEx.getMessage());
                            }
                            throw new R01MSearchIndexerException("Error al cargar del modelo de contenidos el contenido de oid " + contentOid + " durante la indexaci\u00f3n del documento de oid " + objectOid + ": " + secEx.getMessage(), (Exception)((Object)secEx));
                        }
                        catch (R01MContentModelException cmEx) {
                            if (DEBUG) {
                                R01FLog.to((String)LOG_TYPE_ID).info("R01KSearchOrchestratorIndexer - execPerformIndex._initIndexConcurrenceManagement >>>> Error al acceder al modelo de contenidos para comprobar la existencia del contenido " + contentOid + " en las tablas de r01d. Error: " + cmEx.getMessage());
                            }
                            throw new R01MSearchIndexerException("Error al cargar del modelo de contenidos el contenido de oid " + contentOid + " durante la indexaci\u00f3n del documento de oid " + objectOid + ": " + cmEx.getMessage(), (Exception)((Object)cmEx));
                        }
                        this._sendIndexMessage(contentOid, 0, null, 1);
                        return false;
                    }
                    this._reSendIndexMessage(indexElement);
                    return false;
                }
                catch (R01MSecurityException secEx) {
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("R01KSearchOrchestratorIndexer - execPerformIndex._initIndexConcurrenceManagement >>>> Error al acceder al modelo de contenidos para comprobar la existencia del documento " + objectOid + " en las tablas de r01d. Error: " + secEx.getMessage());
                    }
                    throw new R01MSearchIndexerException("Error al cargar del modelo de contenidos el documento de oid " + objectOid + ": " + secEx.getMessage(), (Exception)((Object)secEx));
                }
                catch (R01MContentModelException cmEx) {
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("R01KSearchOrchestratorIndexer - execPerformIndex._initIndexConcurrenceManagement >>>> Error al acceder al modelo de contenidos para comprobar la existencia del documento " + objectOid + " en las tablas de r01d. Error: " + cmEx.getMessage());
                    }
                    throw new R01MSearchIndexerException("Error al cargar del modelo de contenidos el documento de oid " + objectOid + ": " + cmEx.getMessage(), (Exception)((Object)cmEx));
                }
            }
        }
        return true;
    }

    private boolean _checkIndexStartDate(String contentOid, R01MContentModelAPI contentAPI) throws R01MSearchIndexerException {
        Date indexStartDate;
        try {
            indexStartDate = contentAPI.loadContentIndexStartDate(contentOid);
        }
        catch (R01MSecurityException secEx) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("R01KSearchOrchestratorIndexer - execPerformIndex._checkIndexStartDate >>>> Error al acceder al modelo de contenidos para comprobar la concurrencia con otras indexaciones sobre elementos del mismo contenido " + contentOid + " (fecha de inicio de la indexaci\u00f3n). " + "Error: " + secEx.getMessage());
            }
            throw new R01MSearchIndexerException("Error al cargar del modelo de contenidos la fecha de inicio de indexaci\u00f3n para el contenido de oid " + contentOid + ": " + secEx.getMessage(), (Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("R01KSearchOrchestratorIndexer - execPerformIndex._checkIndexStartDate >>>> Error al acceder al modelo de contenidos para comprobar la concurrencia con otras indexaciones sobre elementos del mismo contenido " + contentOid + " (fecha de inicio de la indexaci\u00f3n). " + "Error: " + cmEx.getMessage());
            }
            throw new R01MSearchIndexerException("Error al cargar del modelo de contenidos la fecha de inicio de indexaci\u00f3n para el contenido de oid " + contentOid + ": " + cmEx.getMessage(), (Exception)((Object)cmEx));
        }
        if (indexStartDate != null) {
            long indexProccessTimeout = XMLProperties.getLong((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"indexerContents/indexProccessTimeOut", (long)300000L);
            if (DateUtils.getDateAsMillis((Date)new Date()) < DateUtils.getDateAsMillis((Date)indexStartDate) + indexProccessTimeout) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("Ya existe una indexaci\u00f3n en curso para elementos del contenido " + contentOid + ". No se indexa.");
                }
                return false;
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("Exist\u00eda una indexaci\u00f3n en curso para elementos del contenido " + contentOid + " pero ha pasado el timeout configurado para considerar que la indexaci\u00f3n ha fallado. " + "Se indexa de nuevo.");
            }
        } else if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("El campo de fecha de inicio de indexaci\u00f3n de los elementos del contenido " + contentOid + " es nulo, por lo que no hay ninguna indexaci\u00f3n activa para \u00e9l. Se indexa");
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _resetContentModelIndexFlags(int objectType, String objectOid, R01MContentModelAPI contentAPI) throws R01MSearchIndexerException {
        String contentOid = objectOid;
        if (objectType == 1) {
            R01KIndexableDocumentCMPPK pkDocument = new R01KIndexableDocumentCMPPK(objectOid);
            try {
                contentOid = R01KIndexableDocumentCMPUtil.getLocalHome().findByPrimaryKey(pkDocument).getOidContent();
            }
            catch (NamingException namEx) {
                if (!DEBUG) throw new R01MSearchIndexerException("Error al obtener el Oid del contenido para el documento " + objectOid + ": " + namEx.getMessage(), (Exception)namEx);
                R01FLog.to((String)LOG_TYPE_ID).info("R01KSearchOrchestratorIndexer - execPerformIndex >>>> Al obtener el Oid del contenido para el documento " + objectOid + " " + "desde las tablas de r01k. Error: " + namEx.getMessage());
                throw new R01MSearchIndexerException("Error al obtener el Oid del contenido para el documento " + objectOid + ": " + namEx.getMessage(), (Exception)namEx);
            }
            catch (FinderException findEx) {
                throw new R01MSearchIndexerException("Despu\u00e9s de indexar el documento " + objectOid + ", " + "\u00e9ste no se encuentra en las tablas de r01k: " + findEx.getMessage(), (Exception)((Object)findEx));
            }
        }
        try {
            if (!contentAPI.checkContentExistence(contentOid)) return;
            try {
                contentAPI.setContentIndexStartDate(contentOid, null);
            }
            catch (R01MSecurityException secEx) {
                throw new R01MSearchIndexerException("Error al resetear la fecha de inicio de indexaci\u00f3n del contenido " + contentOid + ": " + secEx.getMessage(), (Exception)((Object)secEx));
            }
            catch (R01MContentModelException cmEx) {
                throw new R01MSearchIndexerException("Error al resetear la fecha de inicio de indexaci\u00f3n del contenido " + contentOid + ": " + cmEx.getMessage(), (Exception)((Object)cmEx));
            }
            if (objectType == 0) {
                try {
                    contentAPI.setContentPublishIndexFiles(objectOid, false);
                }
                catch (R01MSecurityException secEx) {
                    throw new R01MSearchIndexerException("Error al establecer la fecha de inicio o el flag de publicaci\u00f3n del proceso de indexaci\u00f3n del " + (objectType == 0 ? "contenido " : "documento ") + objectOid + ": " + secEx.getMessage(), (Exception)((Object)secEx));
                }
                catch (R01MContentModelException cmEx) {
                    throw new R01MSearchIndexerException("Error al establecer la fecha de inicio o el flag de publicaci\u00f3n del proceso de indexaci\u00f3n del " + (objectType == 0 ? "contenido " : "documento ") + objectOid + ": " + cmEx.getMessage(), (Exception)((Object)cmEx));
                }
            }
            R01MContent content = null;
            try {
                content = contentAPI.loadContent(contentOid);
            }
            catch (R01MSecurityException secEx) {
                throw new R01MSearchIndexerException("Error al cargar los documentos del contenido " + objectOid + ": " + secEx.getMessage(), (Exception)((Object)secEx));
            }
            catch (R01MContentModelException cmEx) {
                throw new R01MSearchIndexerException("Error al cargar los documentos del contenido " + objectOid + ": " + cmEx.getMessage(), (Exception)((Object)cmEx));
            }
            if (content.getDocuments() == null || content.getDocuments().isEmpty()) return;
            Set documentsToUpdate = content.getDocuments().keySet();
            for (String currentDocumentOid : documentsToUpdate) {
                try {
                    contentAPI.setDocumentPublishIndexFiles(currentDocumentOid, false);
                }
                catch (R01MSecurityException secEx) {
                    throw new R01MSearchIndexerException("Error al establecer el flag de publicaci\u00f3n de ficheros de indexaci\u00f3n del " + (objectType == 0 ? "contenido " : "documento ") + objectOid + ": " + secEx.getMessage(), (Exception)((Object)secEx));
                }
                catch (R01MContentModelException cmEx) {
                    throw new R01MSearchIndexerException("Error al establecer el flag de publicaci\u00f3n de ficheros de indexaci\u00f3n del " + (objectType == 0 ? "contenido " : "documento ") + objectOid + ": " + cmEx.getMessage(), (Exception)((Object)cmEx));
                    return;
                }
            }
        }
        catch (R01MSecurityException secEx) {
            throw new R01MSearchIndexerException("Error al comprobar la existencia del contenido " + contentOid + " en las tablas de r01d: " + secEx.getMessage(), (Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new R01MSearchIndexerException("Error al comprobar la existencia del contenido " + contentOid + " en las tablas de r01d: " + cmEx.getMessage(), (Exception)((Object)cmEx));
        }
    }

    private void _sendIndexMessage(String objectOid, int objectType, List<String> indexers, int indexType) throws R01MSearchIndexerException {
        R01MIndexDefinition indexDefinition = new R01MIndexDefinition();
        indexDefinition.setIndexType(indexType);
        indexDefinition.setObjectOid(objectOid);
        indexDefinition.setObjectType(objectType);
        if (indexers != null && !indexers.isEmpty()) {
            indexDefinition.setIndexers(indexers);
        }
        indexDefinition.setMetadataFileNames(null);
        indexDefinition.setPublishIndexData(false);
        indexDefinition.setRepositoryOids(new ArrayList());
        indexDefinition.setPublicationType(-1);
        indexDefinition.setPublicationDate(null);
        indexDefinition.setIndexFilesToPublish("");
        R01KSearchOrchestratorIndexer soIndexer = new R01KSearchOrchestratorIndexer();
        soIndexer.executeIndexation(indexDefinition, R01MConstants.CONTENT_INDEXER_MANAGER);
    }

    private void _reSendIndexMessage(R01MIndexDefinition indexDefinition) throws R01MSearchIndexerException {
        indexDefinition.increaseIterations();
        if (indexDefinition.getIteration() > XMLProperties.getInt((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"indexConcurrenceManagement/indexMaxIterations", (int)5)) {
            R01FLog.to((String)"r01k.index").severe("N\u00famero m\u00e1ximo de iteraciones superado para la misma petici\u00f3n de indexaci\u00f3n: \n\t- OID: " + indexDefinition.getObjectOid() + "\n\t- TYPE: " + indexDefinition.getObjectType() + "\n\t- INDEX_TYPE: " + indexDefinition.getIndexType());
        } else {
            R01KSearchOrchestratorIndexer soIndexer = new R01KSearchOrchestratorIndexer();
            soIndexer.executeIndexation(indexDefinition, R01MConstants.CONTENT_INDEXER_MANAGER);
        }
    }

    private String _getDocumentParentContent(String documentOid) {
        String contentOid;
        block4: {
            contentOid = null;
            R01KIndexableDocumentCMPPK pkDocument = new R01KIndexableDocumentCMPPK(documentOid);
            try {
                contentOid = R01KIndexableDocumentCMPUtil.getLocalHome().findByPrimaryKey(pkDocument).getOidContent();
            }
            catch (NamingException namEx) {
                if (DEBUG) {
                    R01FLog.to((String)"r01k.index").info("R01KObjectsToIndexProcessor - _getContentOidFromDocumentOid >>>> Al obtener el Oid del contenido para el documento " + documentOid + " desde las tablas de r01k. Error: " + namEx.getMessage());
                }
            }
            catch (FinderException findEx) {
                if (!DEBUG) break block4;
                R01FLog.to((String)"r01k.index").info("R01KObjectsToIndexProcessor - _getContentOidFromDocumentOid >>>> Al obtener el Oid del contenido para el documento " + documentOid + " desde las tablas de r01k. No se puede obtener el contenido padre: " + findEx.getMessage());
            }
        }
        return contentOid;
    }

    public void injectDataForIndexInAutonomy(String objectOid, String langVersionOid, int indexType, String metadataFile, String drereference, String pubRepositoryOid) {
        QueryExecutor qryExec = R01KQueries.obtainQueryExecutorInstance();
        String sql = R01KQueries.getQuery((String)"index", (String)"checkindexinautonomy");
        if (sql == null) {
            R01FLog.to((String)LOG_TYPE_ID).severe("R01KSearchOrchestratorIndexer.injectDataForIndexInAutonomy > NO se puede dejar en BD de indexaci\u00f3n directa de autonomy la informaci\u00f3n para la versi\u00f3n idiom\u00e1tica " + langVersionOid + ". \n" + "La SQL con identificador id='checkindexinautonomy' dentro del entity 'index' " + "no existe. Revisa el queryModelMapping");
            return;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(langVersionOid);
        try {
            List responses = qryExec.executeQuery(sql, params);
            if (responses != null && !responses.isEmpty()) {
                sql = R01KQueries.getQuery((String)"index", (String)"updateindexinautonomy");
                if (sql == null) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01KSearchOrchestratorIndexer.injectDataForIndexInAutonomy > NO se puede dejar en BD de indexaci\u00f3n directa de autonomy la informaci\u00f3n para la versi\u00f3n idiom\u00e1tica " + langVersionOid + ". \n" + "La SQL con identificador id='updateindexinautonomy' dentro del entity 'index' " + "no existe. Revisa el queryModelMapping");
                    return;
                }
                params = new ArrayList();
                params.add(objectOid);
                params.add(new Integer(indexType));
                params.add(metadataFile);
                params.add(langVersionOid);
                try {
                    qryExec.executeUpdate(sql, params);
                }
                catch (SQLException sqlEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01KSearchOrchestratorIndexer.injectDataForIndexInAutonomy > NO se puede dejar en BD de indexaci\u00f3n directa de autonomy la informaci\u00f3n para la versi\u00f3n idiom\u00e1tica " + langVersionOid + ". \n" + "Error al ejecutar la SQL de actualizaci\u00f3n del IDX: " + sqlEx.getMessage());
                    sqlEx.printStackTrace();
                }
            } else {
                sql = R01KQueries.getQuery((String)"index", (String)"inserttoindexinautonomy");
                if (sql == null) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01KSearchOrchestratorIndexer.injectDataForIndexInAutonomy > NO se puede dejar en BD de indexaci\u00f3n directa de autonomy la informaci\u00f3n para la versi\u00f3n idiom\u00e1tica " + langVersionOid + ". \n" + "La SQL con identificador id='inserttoindexinautonomy' dentro del entity 'index' " + "no existe. Revisa el queryModelMapping");
                    return;
                }
                String databaseInAutonomy = XMLProperties.getProperty((String)R01MConstants.INTERNALAPI_APPCODE, (String)("autonomy/databaseInAutonomy/" + pubRepositoryOid), (String)"euskadi_db");
                params = new ArrayList();
                params.add(objectOid);
                params.add(langVersionOid);
                params.add(new Integer(indexType));
                params.add(metadataFile);
                params.add(drereference);
                params.add(databaseInAutonomy);
                try {
                    qryExec.executeInsert(sql, params);
                }
                catch (SQLException sqlEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01KSearchOrchestratorIndexer.injectDataForIndexInAutonomy > NO se puede dejar en BD de indexaci\u00f3n directa de autonomy la informaci\u00f3n para la versi\u00f3n idiom\u00e1tica " + langVersionOid + ". \n" + "Error al ejecutar la SQL de inserci\u00f3n del IDX: " + sqlEx.getMessage());
                    sqlEx.printStackTrace();
                }
            }
        }
        catch (SQLException sqlEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("R01KSearchOrchestratorIndexer.injectDataForIndexInAutonomy > NO se puede dejar en BD de indexaci\u00f3n directa de autonomy la informaci\u00f3n para la versi\u00f3n idiom\u00e1tica " + langVersionOid + ". \n" + "Error al ejecutar la consulta para verificar si ya hab\u00eda un registro pendiente: " + sqlEx.getMessage());
            sqlEx.printStackTrace();
        }
    }
}

