/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01k.searchorchestrator;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.sql.QueryExecutor;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01k.searchorchestrator.R01KSearchSourceInitEventListenerImpl;
import com.ejie.r01k.searchorchestrator.initmultiplexors.R01KSearchSessionInitMultiplexor;
import com.ejie.r01k.searchorchestrator.searchperformers.R01KSearchPerformer;
import com.ejie.r01m.config.objects.searchengine.R01MSearchEngineConfig;
import com.ejie.r01m.config.objects.searchengine.R01MSearchSource;
import com.ejie.r01m.config.objects.searchengine.R01MSearchSourcePerformer;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MSearchInitializeException;
import com.ejie.r01m.exceptions.R01MSearchPerformerException;
import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuideElement;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedCluster;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.results.R01MSearchSourceInitResult;
import com.ejie.r01m.objects.searchengine.results.R01MSearchSourceResume;
import com.ejie.r01m.objects.searchengine.results.R01MSessionSearchInitResult;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.bzd.R01MSearchOrchestatorBzd;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class R01KSearchOrchestratorSession
implements R01MSearchOrchestatorBzd {
    private static final String JOBMANAGER_INITMULTIPLEXOR_IMPL = XMLProperties.get((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"initMultiplexor/multiplexorImpl[@id='jobManager']/implClassName");
    private static final Properties JOBMANAGER_INITMULTIPLEXOR_IMPL_PROPS = XMLProperties.getProperties((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"initMultiplexor/multiplexorImpl[@id='jobManager']/properties");
    private static final String SERIAL_INITMULTIPLEXOR_IMPL = XMLProperties.get((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"initMultiplexor/multiplexorImpl[@id='serial']/implClassName");
    private static final Properties SERIAL_INITMULTIPLEXOR_IMPL_PROPS = XMLProperties.getProperties((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"initMultiplexor/multiplexorImpl[@id='serial']/properties");
    private static final String LOG_TYPE_ID = "r01k.session";
    private static boolean DEBUG = R01FLog.getLogLevel((String)"r01k.session").intValue() != Level.OFF.intValue();
    private static transient R01MSearchEngineConfig SEARCH_ORCHESTRATOR_CONFIG = null;
    private static QueryExecutor _qryExecIndex;

    public R01MSessionSearchInitResult execInitSession(String searchEngineId, String context, String searchSessionOid, String searchSessionLang, R01MQueryObject qry, R01MSearchGuideElement[] guideFutureElements, boolean lazy) throws R01MSearchInitializeException {
        R01MSessionSearchInitResult srchInitResult;
        R01KSearchSessionInitMultiplexor initMux;
        if (SEARCH_ORCHESTRATOR_CONFIG == null) {
            throw new R01MSearchInitializeException("No se puede utilizar el buscador ya que NO se ha podido cargar su configuracion!!!");
        }
        if (qry == null) {
            throw new R01MSearchInitializeException("La query de b\u00fasqueda es nula!!!. No se puede inicializar la sesi\u00f3n");
        }
        if (qry.getQueryOid() == null) {
            try {
                qry.setQueryOid(R01MUtils.generateNewOid((String)R01MConstants.SEARCHENGINE_APPCODE));
            }
            catch (GUIDDispenserException guidDispEx) {
                guidDispEx.printStackTrace(System.out);
                qry.setQueryOid("noOid");
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("La query NO ten\u00eda OID, as\u00ed que se ha generado uno por defecto: " + qry.getQueryOid());
            }
        }
        if (SEARCH_ORCHESTRATOR_CONFIG.getSearchSources() == null || SEARCH_ORCHESTRATOR_CONFIG.getSearchSources().isEmpty()) {
            throw new R01MSearchInitializeException("No se han configurado or\u00edgenes de b\u00fasqueda en la configuraci\u00f3n del buscador...NO ES UTILIZABLE!!!");
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n[ORCHESTRATOR]-PASO 1: Obtener los origenes de resultados para la query ---------------------------------------------------");
        }
        ArrayList<R01MSearchSource> sourcesToSearch = new ArrayList<R01MSearchSource>(SEARCH_ORCHESTRATOR_CONFIG.getSearchSources().size());
        R01MSearchSource currSearchSrc2 = null;
        R01MSearchedCluster currSearchedCluster2 = null;
        block2: for (R01MSearchSource currSearchSrc2 : SEARCH_ORCHESTRATOR_CONFIG.getSearchSources().values()) {
            if (qry.getContext().equals(currSearchSrc2.getContext())) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\t\t-Origen de resultados " + currSearchSrc2.getInternalName() + ": pertenece al mismo contexto que la b\u00fasqueda actual (" + qry.getContext() + ")");
                }
                if (qry.contentClusters == null || qry.contentClusters.isEmpty()) {
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("\t\t\t...en la query no se definen clusters, as\u00ed que NO se discrimina si el origen gestiona algun cluster");
                    }
                    sourcesToSearch.add(currSearchSrc2);
                    continue;
                }
                if (currSearchSrc2.getAvailableClusters() != null && !currSearchSrc2.getAvailableClusters().isEmpty()) {
                    for (R01MSearchedCluster currSearchedCluster2 : qry.contentClusters) {
                        if (!currSearchSrc2.getAvailableClusters().containsKey(currSearchedCluster2.getOid())) continue;
                        if (DEBUG) {
                            R01FLog.to((String)LOG_TYPE_ID).info("\t\t\t...en la query se definen clusters, y el origen gestiona uno de ellos, as\u00ed que enviar la query!");
                        }
                        sourcesToSearch.add(currSearchSrc2);
                        continue block2;
                    }
                    continue;
                }
                R01FLog.to((String)LOG_TYPE_ID).warning("En el origen de resultados " + currSearchSrc2.getOid() + " NO se definen clusters disponibles para la b\u00fasqueda, as\u00ed que se envia la b\u00fasqueda al origen.\r\nSe aconseja definir los clusters que gestiona el origen!");
                sourcesToSearch.add(currSearchSrc2);
                continue;
            }
            if (!DEBUG) continue;
            R01FLog.to((String)LOG_TYPE_ID).info("\t\t-Origen de resultados " + currSearchSrc2.getInternalName() + ": NO pertenece al mismo contexto en el que est\u00e1 instalado el buscador (" + qry.getContext() + ") as\u00ed que NO se busca en este origen!!!");
        }
        if (sourcesToSearch.isEmpty()) {
            throw new R01MSearchInitializeException("En la configuracion del buscador NO hay ning\u00fan origen de resultados para el contexto " + qry.getContext() + " en el que ejecutar la b\u00fasqueda con los clusters indicados");
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n[ORCHESTRATOR]-PASO 2: Crear los ejecutores de b\u00fasquedas de cada uno de los origenes ---------------------------------------------------");
        }
        HashMap<String, R01KSearchPerformer> srcsSearchPerformers = new HashMap<String, R01KSearchPerformer>(sourcesToSearch.size());
        for (R01MSearchSource currSearchSrc2 : sourcesToSearch) {
            R01KSearchPerformer srcSearchPerformer;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\t\t-Origen de resultados: " + currSearchSrc2.getOid() + " > " + (String)currSearchSrc2.getName().get(searchSessionLang));
            }
            if (currSearchSrc2.getActiveSearchPerformer() == null || currSearchSrc2.getActiveSearchPerformer().getImplClassName() == null) {
                R01FLog.to((String)LOG_TYPE_ID).severe("El origen de resultados " + currSearchSrc2.getOid() + " NO est\u00e1 correctamente configurado (no se define el searchPerformer). Revisa el XML de configuraci\u00f3n del cluster!. NO SE BUSCARAN RESULTADOS EN ESTE ORIGEN!!!");
            }
            if ((srcSearchPerformer = R01KSearchOrchestratorSession._instanceSearchPerformer(currSearchSrc2.getActiveSearchPerformer())) == null) continue;
            srcsSearchPerformers.put(currSearchSrc2.getOid(), srcSearchPerformer);
        }
        if (srcsSearchPerformers.isEmpty()) {
            throw new R01MSearchInitializeException("No se han podido instanciar los ejecutores de b\u00fasquedas en los or\u00edgenes de resultados!!!");
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n[ORCHESTRATOR]-PASO 3: Multiplexar la llamada a init: instanciar el multiplexor -------------------------------------------");
        }
        if ((initMux = R01KSearchOrchestratorSession._instanceInitMultiplexor(srcsSearchPerformers.size())) == null) {
            throw new R01MSearchInitializeException("No se ha podido instanciar un multiplexor de fase de inicializaci\u00f3n de la b\u00fasqueda!!!");
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n[ORCHESTRATOR]-PASO 4: Inicializar los or\u00edgenes de resultados -------------------------------------------------------------");
        }
        R01KSearchSourceInitEventListenerImpl initEventListener = new R01KSearchSourceInitEventListenerImpl();
        initMux.multiplexInitPhase(searchSessionOid, searchSessionLang, qry, guideFutureElements, lazy, srcsSearchPerformers, initEventListener);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n[ORCHESTRATOR]-PASO 5: Todos los or\u00edgenes de resultados est\u00e1n inicializados!!!! -------------------------------------------");
        }
        if (!(srchInitResult = initEventListener.getSessionSearchInitResult()).getSourcesInitResults().isEmpty()) {
            R01MSearchSourceInitResult currSrcInitResult2 = null;
            for (R01MSearchSourceInitResult currSrcInitResult2 : srchInitResult.getSourcesInitResults().values()) {
                R01MSearchSource srchSrc;
                if (currSrcInitResult2.getSourceDetails() == null) {
                    currSrcInitResult2.setSourceDetails(new R01MSearchSourceResume());
                }
                if (currSrcInitResult2.getSourceDetails().getSourceName() == null) {
                    srchSrc = SEARCH_ORCHESTRATOR_CONFIG.getSearchSourceCfg(qry.getContext(), currSrcInitResult2.getSourceOid());
                    currSrcInitResult2.getSourceDetails().setSourceName((String)srchSrc.getName().get(searchSessionLang));
                }
                if (currSrcInitResult2.getSourceDetails().getAvailablePublicationTargets() == null) {
                    srchSrc = SEARCH_ORCHESTRATOR_CONFIG.getSearchSourceCfg(qry.getContext(), currSrcInitResult2.getSourceOid());
                    currSrcInitResult2.getSourceDetails().setAvailablePublicationTargets(srchSrc.getAvailablePublicationTargets());
                }
                if (!DEBUG) continue;
                R01FLog.to((String)LOG_TYPE_ID).info("\t-origen " + currSrcInitResult2.getSourceDetails().getSourceName() + " oid=" + currSrcInitResult2.getSourceOid() + " " + currSrcInitResult2.getPager().getElementCount() + " elementos");
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info(":::::Sesion de b\u00fasqueda INICIALIZADA: (" + srchInitResult.getInitPerformMillis() + " msg), " + srchInitResult.getSourcesInitResults().size() + " or\u00edgenes inicializados\r\noooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo\r\noooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo\r\n\r\n\r\n");
            }
        } else if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).warning(":::::NO se ha inicializado NING\u00daN origen de resultados!!!!");
        }
        return srchInitResult;
    }

    public R01MSearchResultItem[] execGetResults(String searchEngineId, String context, String searchSessionOid, String searchSessionLang, String sourceOid, R01MQueryObject qry, int pageNum, Object pageFirstElementOid, Object pageLastElementOid) throws R01MSearchPerformerException {
        R01KSearchPerformer srcSearchPerformer;
        if (SEARCH_ORCHESTRATOR_CONFIG == null) {
            throw new R01MSearchPerformerException("No se puede utilizar el buscador ya que NO se ha podido cargar su configuracion!!!");
        }
        if (qry == null) {
            throw new R01MSearchPerformerException("La query de b\u00fasqueda es nula!!!. No se pueden obtener resultados del origen " + sourceOid);
        }
        if (qry.getQueryOid() == null) {
            try {
                qry.setQueryOid(R01MUtils.generateNewOid((String)R01MConstants.SEARCHENGINE_APPCODE));
            }
            catch (GUIDDispenserException guidDispEx) {
                guidDispEx.printStackTrace(System.out);
                qry.setQueryOid("noOid");
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("La query NO ten\u00eda OID, as\u00ed que se ha generado uno por defecto: " + qry.getQueryOid());
            }
        }
        R01MSearchResultItem[] outResults = null;
        R01MSearchSource srchSrcCfg = SEARCH_ORCHESTRATOR_CONFIG.getSearchSourceCfg(qry.getContext(), sourceOid);
        if (srchSrcCfg != null) {
            srcSearchPerformer = null;
            try {
                srcSearchPerformer = R01KSearchOrchestratorSession._instanceSearchPerformer(srchSrcCfg.getActiveSearchPerformer());
            }
            catch (R01MSearchInitializeException srchInitEx) {
                throw new R01MSearchPerformerException("Error al instanciar el searchPerformer para el origen " + sourceOid + " en el contexto " + qry.getContext() + ": " + srchInitEx.getMessage(), (Exception)((Object)srchInitEx));
            }
        } else {
            throw new R01MSearchPerformerException("No se puede encontrar la configuraci\u00f3n del origen " + sourceOid + " con el contexto " + qry.getContext() + ": NO se puede instanciar el searchPerformer y NO se puede ejecutar la b\u00fasqueda!");
        }
        outResults = srcSearchPerformer.search(searchSessionOid, searchSessionLang, sourceOid, qry, pageNum, pageFirstElementOid, pageLastElementOid);
        return outResults;
    }

    public R01MSearchResultItem[] execGetResultsFromAutonomyQuery(String sourceOid, String context, String autonomyQuery) throws R01MSearchPerformerException {
        R01KSearchPerformer srcSearchPerformer;
        if (SEARCH_ORCHESTRATOR_CONFIG == null) {
            throw new R01MSearchPerformerException("No se puede utilizar el buscador ya que NO se ha podido cargar su configuracion!!!");
        }
        if (StringUtils.isEmptyString((String)autonomyQuery)) {
            throw new R01MSearchPerformerException("La query de b\u00fasqueda es nula!!!. No se pueden obtener resultados del origen " + sourceOid);
        }
        R01MSearchResultItem[] outResults = null;
        R01MSearchSource srchSrcCfg = SEARCH_ORCHESTRATOR_CONFIG.getSearchSourceCfg(context, sourceOid);
        if (srchSrcCfg != null) {
            srcSearchPerformer = null;
            try {
                srcSearchPerformer = R01KSearchOrchestratorSession._instanceSearchPerformer(srchSrcCfg.getActiveSearchPerformer());
            }
            catch (R01MSearchInitializeException srchInitEx) {
                throw new R01MSearchPerformerException("Error al instanciar el searchPerformer para el origen " + sourceOid + " en el contexto " + context + ": " + srchInitEx.getMessage(), (Exception)((Object)srchInitEx));
            }
        } else {
            throw new R01MSearchPerformerException("No se puede encontrar la configuraci\u00f3n del origen " + sourceOid + " con el contexto " + context + ": NO se puede instanciar el searchPerformer y NO se puede ejecutar la b\u00fasqueda!");
        }
        srcSearchPerformer.setSearchSourceOid(sourceOid);
        outResults = srcSearchPerformer.searchFromAutonomyQuery(autonomyQuery, context);
        return outResults;
    }

    public String execGetSearchEngineQuerySentence(String searchEngineId, String context, String searchSessionOid, String searchSessionLang, String sourceOid, R01MQueryObject qry, int pageNum, Object pageFirstCod, Object pageLastCod) throws R01MSearchPerformerException {
        R01KSearchPerformer srcSearchPerformer;
        String outQuery = null;
        R01MSearchSource srchSrcCfg = SEARCH_ORCHESTRATOR_CONFIG.getSearchSourceCfg(qry.getContext(), sourceOid);
        if (srchSrcCfg != null) {
            srcSearchPerformer = null;
            try {
                srcSearchPerformer = R01KSearchOrchestratorSession._instanceSearchPerformer(srchSrcCfg.getActiveSearchPerformer());
            }
            catch (R01MSearchInitializeException srchInitEx) {
                throw new R01MSearchPerformerException("Error al instanciar el searchPerformer para el origen " + sourceOid + " en el contexto " + qry.getContext() + ": " + srchInitEx.getMessage(), (Exception)((Object)srchInitEx));
            }
        } else {
            throw new R01MSearchPerformerException("No se puede encontrar la configuraci\u00f3n del origen " + sourceOid + " con el contexto " + qry.getContext() + ": NO se puede instanciar el searchPerformer y NO se puede ejecutar la b\u00fasqueda!");
        }
        outQuery = srcSearchPerformer.composeSearchQuery(false, searchSessionOid, searchSessionLang, sourceOid, qry, pageNum, pageFirstCod, pageLastCod);
        return outQuery;
    }

    public List execSearchFullText(String text) throws R01MSearchPerformerException {
        List data;
        ArrayList<String> result = new ArrayList<String>();
        String sql = "SELECT OID_DOCUMENT_04 FROM R01K04T00 WHERE CONTAINS(SEARCHED_COLS_04,'" + text + "') > 0";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Buscar los documentos con el texto " + text + ":\n" + sql);
        }
        try {
            data = _qryExecIndex.executeQuery(sql);
        }
        catch (SQLException sqlEx) {
            throw new R01MSearchPerformerException("Error al consultar los documentos de BD. con el texto " + text + ": " + sqlEx.getMessage(), (Exception)sqlEx);
        }
        if (data != null && !data.isEmpty()) {
            for (int i = 0; i < data.size(); ++i) {
                Map rowMap = (Map)data.get(i);
                result.add(rowMap.get("OID_DOCUMENT_04").toString());
            }
        }
        return result;
    }

    private static R01KSearchPerformer _instanceSearchPerformer(R01MSearchSourcePerformer searchPerformerCfg) throws R01MSearchInitializeException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("...instanciando el SearchPerformer con la implementacion en la clase: " + searchPerformerCfg.getImplClassName());
        }
        try {
            R01KSearchPerformer performer = (R01KSearchPerformer)ReflectionUtils.getObjectInstance((String)searchPerformerCfg.getImplClassName());
            performer.setSearchPerformerId(searchPerformerCfg.getId());
            performer.setSearchSourceOid(searchPerformerCfg.getId());
            performer.setNativeDateFormat(searchPerformerCfg.getNativeDateFormat());
            if (searchPerformerCfg.getProperties() != null) {
                Properties props = new Properties();
                props.putAll((Map<?, ?>)searchPerformerCfg.getProperties());
                performer.setProperties(props);
            }
            return performer;
        }
        catch (ReflectionException refEx) {
            throw new R01MSearchInitializeException("Error al instanciar el searchPerformer " + searchPerformerCfg.getImplClassName() + ": " + refEx.getMessage(), (Exception)((Object)refEx));
        }
    }

    private static R01KSearchSessionInitMultiplexor _instanceInitMultiplexor(int numSrcs) throws R01MSearchInitializeException {
        R01KSearchSessionInitMultiplexor initMux = null;
        try {
            if (numSrcs == 1) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\t-hay UN UNICO origen de resultados... utilizar el multiplexor en serie: " + SERIAL_INITMULTIPLEXOR_IMPL);
                }
                if (SERIAL_INITMULTIPLEXOR_IMPL == null) {
                    throw new R01MSearchInitializeException("No se ha definido la implementacion del multiplexor de llamadas a la inicializaci\u00f3n de b\u00fasquedas en el fichero r01k.properties.xml: Falta la propiedad initMultiplexor/multiplexorImpl@id='serial'/implClassName");
                }
                initMux = (R01KSearchSessionInitMultiplexor)ReflectionUtils.getObjectInstance((String)SERIAL_INITMULTIPLEXOR_IMPL, (Class[])new Class[]{Properties.class}, (Object[])new Object[]{SERIAL_INITMULTIPLEXOR_IMPL_PROPS}, (boolean)true);
            } else {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\t-hay VARIOS origenes de resultados... utilizar el multiplexor en paralelo: " + JOBMANAGER_INITMULTIPLEXOR_IMPL);
                }
                if (JOBMANAGER_INITMULTIPLEXOR_IMPL == null) {
                    throw new R01MSearchInitializeException("No se ha definido la implementacion del multiplexor de llamadas a la inicializaci\u00f3n de b\u00fasquedas en el fichero r01k.properties.xml: Falta la propiedad initMultiplexor/multiplexorImpl@id='jobManager'/implClassName");
                }
                initMux = (R01KSearchSessionInitMultiplexor)ReflectionUtils.getObjectInstance((String)JOBMANAGER_INITMULTIPLEXOR_IMPL, (Class[])new Class[]{Properties.class}, (Object[])new Object[]{JOBMANAGER_INITMULTIPLEXOR_IMPL_PROPS}, (boolean)true);
            }
        }
        catch (ReflectionException refEx) {
            throw new R01MSearchInitializeException("No se ha podido instanciar el multiplexor de la fase de inicializaci\u00f3n de b\u00fasquedas: " + refEx.getMessage(), (Exception)((Object)refEx));
        }
        return initMux;
    }

    static {
        try {
            SEARCH_ORCHESTRATOR_CONFIG = R01MClientFactory.getSearchEngineConfigAPI().getSearchEngineConfig();
            if (SEARCH_ORCHESTRATOR_CONFIG.getSearchSources() == null) {
                R01FLog.to((String)LOG_TYPE_ID).severe("NO se han definido or\u00edgenes de b\u00fasqueda en el fichero de configuraci\u00f3n del buscador.\r\nEL BUSCADOR NO SE PUEDE UTILIZAR!!!!!");
            }
            if (SEARCH_ORCHESTRATOR_CONFIG.getDefaultContext() == null) {
                R01FLog.to((String)LOG_TYPE_ID).warning("NO se ha definido la propiedad defaultContext en el fichero de configuracion del buscador. Esta propiedad es MUY ACONSEJABLE!!");
            }
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            cfgLoadEx.printStackTrace(System.out);
            R01FLog.to((String)LOG_TYPE_ID).severe("NO se ha podido cargar la configuracion del buscador.\r\nEL BUSCADOR NO SE PUEDE UTILIZAR!!!!!");
        }
        _qryExecIndex = new QueryExecutor(R01MConstants.SEARCHENGINE_APPCODE, "indexerConnection");
    }
}

