/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01k.ejb.services.searchengine;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01k.searchorchestrator.R01KSearchOrchestratorSession;
import com.ejie.r01k.searchorchestrator.persistence.R01KSearchOrchestatorPersistenceManager;
import com.ejie.r01m.exceptions.R01MJMSException;
import com.ejie.r01m.exceptions.R01MSearchInitializeException;
import com.ejie.r01m.exceptions.R01MSearchPerformerException;
import com.ejie.r01m.exceptions.R01MSearchStorageException;
import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuideElement;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.results.R01MSessionSearchInitResult;
import com.ejie.r01m.services.bzd.R01MSearchOrchestatorBzd;
import com.ejie.r01m.services.bzd.R01MSearchOrchestatorPersistenceManagerBzd;
import com.ejie.r01n.ejb.notifier.R01NCachesNotifierSLUtil;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;

public class R01KSearchEngineServicesSLBaseBean
implements SessionBean,
R01MSearchOrchestatorBzd,
R01MSearchOrchestatorPersistenceManagerBzd {
    private static final long serialVersionUID = 7749999826405454260L;
    private static String LOG_TYPE_LOG = "r01k.services";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)LOG_TYPE_LOG).intValue() != Level.OFF.intValue();
    private SessionContext context;
    private static Map _guideDefsCache;

    public void setSessionContext(SessionContext newContext) throws EJBException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_LOG).info("\tR01KSearchEngineServicesSL.setSessionContext()...");
        }
        this.context = newContext;
    }

    public void ejbRemove() throws EJBException, RemoteException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_LOG).info("\tR01KSearchEngineServicesSL.ejbRemove()...");
        }
    }

    public void ejbActivate() throws EJBException, RemoteException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_LOG).info("\tR01KSearchEngineServicesSL.ejbActivate()...");
        }
    }

    public void ejbPassivate() throws EJBException, RemoteException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_LOG).info("\tR01KSearchEngineServicesSL.ejbPassivate()...");
        }
    }

    public void ejbCreate() throws CreateException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_LOG).info("\tR01KSearchEngineServicesSL.ejbCreate()...");
        }
    }

    public boolean existsQuery(String queryOid) throws EJBException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_LOG).info("\tR01KSearchEngineServicesSL.execLoadQuery()...");
        }
        if (queryOid == null) {
            return false;
        }
        try {
            R01KSearchOrchestatorPersistenceManager persistenceMgr = new R01KSearchOrchestatorPersistenceManager();
            return persistenceMgr.existsQuery(queryOid);
        }
        catch (R01MSearchStorageException sEx) {
            throw new EJBException((Exception)((Object)sEx));
        }
    }

    public String execLoadQuery(String queryOid) throws EJBException, R01MSearchStorageException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_LOG).info("\tR01KSearchEngineServicesSL.execLoadQuery()...");
        }
        if (queryOid == null) {
            throw new R01MSearchStorageException("No se puede cargar una query con oid null");
        }
        try {
            R01KSearchOrchestatorPersistenceManager persistenceMgr = new R01KSearchOrchestatorPersistenceManager();
            return persistenceMgr.execLoadQuery(queryOid);
        }
        catch (R01MSearchStorageException sEx) {
            throw new EJBException((Exception)((Object)sEx));
        }
    }

    public void execSaveQuery(String qryOid, String qryXML) throws EJBException, R01MSearchStorageException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_LOG).info("\tR01KSearchEngineServicesSL.execSaveQuery()...");
        }
        try {
            if (qryOid == null || qryXML == null) {
                throw new R01MSearchStorageException("No se puede guardar la query ya que esta o su oid son nulos");
            }
            R01KSearchOrchestatorPersistenceManager persistenceMgr = new R01KSearchOrchestatorPersistenceManager();
            persistenceMgr.execSaveQuery(qryOid, qryXML);
        }
        catch (R01MSearchStorageException sEx) {
            throw new EJBException((Exception)((Object)sEx));
        }
    }

    public String execLoadGuide(String guideOid) throws EJBException, R01MSearchStorageException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_LOG).info("\tR01KSearchEngineServicesSL.execLoadGuide()...");
        }
        if (guideOid == null) {
            throw new R01MSearchStorageException("No se puede cargar una guia con oid null");
        }
        String guideXML = null;
        try {
            String string = guideXML = _guideDefsCache == null ? null : (String)_guideDefsCache.get(guideOid);
            if (guideXML == null) {
                R01KSearchOrchestatorPersistenceManager persistenceMgr = new R01KSearchOrchestatorPersistenceManager();
                guideXML = persistenceMgr.execLoadGuide(guideOid);
                if (_guideDefsCache == null) {
                    _guideDefsCache = new HashMap();
                }
                _guideDefsCache.put(guideOid, guideXML);
            }
            return guideXML;
        }
        catch (R01MSearchStorageException sEx) {
            throw new EJBException((Exception)((Object)sEx));
        }
    }

    public void execSaveGuide(String guideOid, String guideDesc, String guideXML) throws EJBException, R01MSearchStorageException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_LOG).info("\tR01KSearchEngineServicesSL.execSaveGuide()...");
        }
        try {
            if (StringUtils.isEmptyString((String)guideOid) || StringUtils.isEmptyString((String)guideXML)) {
                throw new R01MSearchStorageException("No se puede guardar la guia ya que esta o su oid son nulos");
            }
            R01KSearchOrchestatorPersistenceManager persistenceMgr = new R01KSearchOrchestatorPersistenceManager();
            persistenceMgr.execSaveGuide(guideOid, guideDesc, guideXML);
            try {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_LOG).info("Notificando la recarga de caches del buscador");
                }
                R01NCachesNotifierSLUtil.getHome().create().reloadSearchEngineCache();
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_LOG).info("Fin notificaci\u00f3n de la recarga de caches del buscador");
                }
            }
            catch (R01MJMSException jmsExc) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_LOG).severe("REGENERADOR: Error en la recarga de caches del buscador:" + jmsExc.getMessage());
                }
                jmsExc.printStackTrace(System.out);
            }
            catch (RemoteException rmtExc) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_LOG).severe("REGENERADOR: No se encuentra el EJB de recarga de caches del buscador:" + rmtExc.getMessage());
                }
                rmtExc.printStackTrace(System.out);
            }
            catch (CreateException crtExc) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_LOG).severe("REGENERADOR: No se puede crear el servicio de recarga de caches del buscador:" + crtExc.getMessage());
                }
                crtExc.printStackTrace(System.out);
            }
            catch (NamingException namExc) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_LOG).severe("REGENERADOR: No se encuentra el EJB de recarga del buscador:" + namExc.getMessage());
                }
                namExc.printStackTrace(System.out);
            }
        }
        catch (R01MSearchStorageException sEx) {
            throw new EJBException((Exception)((Object)sEx));
        }
    }

    public void execDeleteGuide(String guideOid) throws EJBException, R01MSearchStorageException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_LOG).info("\tR01KSearchEngineServicesSL.execDeleteGuide()...");
        }
        try {
            if (guideOid == null) {
                throw new R01MSearchStorageException("No se puede borrar la guia ya que su oid es nulo");
            }
            R01KSearchOrchestatorPersistenceManager persistenceMgr = new R01KSearchOrchestatorPersistenceManager();
            persistenceMgr.execDeleteGuide(guideOid);
        }
        catch (R01MSearchStorageException sEx) {
            throw new EJBException((Exception)((Object)sEx));
        }
    }

    public List execLoadGuideList() throws EJBException, R01MSearchStorageException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_LOG).info("\tR01KSearchEngineServicesSL.execLoadGuideList()...");
        }
        try {
            R01KSearchOrchestatorPersistenceManager persistenceMgr = new R01KSearchOrchestatorPersistenceManager();
            return persistenceMgr.execLoadGuideList();
        }
        catch (R01MSearchStorageException sEx) {
            throw new EJBException((Exception)((Object)sEx));
        }
    }

    public String execLoadXMLGuide(String guideOid) throws EJBException, R01MSearchStorageException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_LOG).info("\tR01KSearchEngineServicesSL.execLoadXMLGuide(" + guideOid + ")...");
        }
        try {
            String guideXML;
            String string = guideXML = _guideDefsCache == null ? null : (String)_guideDefsCache.get(guideOid);
            if (guideXML == null) {
                R01KSearchOrchestatorPersistenceManager persistenceMgr = new R01KSearchOrchestatorPersistenceManager();
                guideXML = persistenceMgr.execLoadXMLGuide(guideOid);
                if (_guideDefsCache == null) {
                    _guideDefsCache = new HashMap();
                }
                _guideDefsCache.put(guideOid, guideXML);
            }
            return guideXML;
        }
        catch (R01MSearchStorageException sEx) {
            throw new EJBException((Exception)((Object)sEx));
        }
    }

    public void execReloadGuidesInCache() throws EJBException, R01MSearchStorageException {
        List guides;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_LOG).info("\tR01KSearchEngineServiceSL.execReloadGuides() ");
        }
        try {
            guides = this.execLoadGuideList();
        }
        catch (R01MSearchStorageException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
        if (_guideDefsCache != null) {
            _guideDefsCache.clear();
        }
        if (guides != null && !guides.isEmpty()) {
            for (String[] guide : guides) {
                this.execLoadGuide(guide[0]);
            }
        }
    }

    public R01MSessionSearchInitResult execInitSession(String searchEngineId, String srchContext, String searchSessionOid, String searchSessionLang, R01MQueryObject qry, R01MSearchGuideElement[] guideFutureElements, boolean lazy) throws EJBException, R01MSearchInitializeException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_LOG).info("\tR01KSearchEngineServicesSL.execInitSession()...");
        }
        try {
            R01KSearchOrchestratorSession session = new R01KSearchOrchestratorSession();
            return session.execInitSession(searchEngineId, srchContext, searchSessionOid, searchSessionLang, qry, guideFutureElements, lazy);
        }
        catch (R01MSearchInitializeException sEx) {
            throw new EJBException((Exception)((Object)sEx));
        }
    }

    public R01MSearchResultItem[] execGetResults(String searchEngineId, String srchContext, String searchSessionOid, String searchSessionLang, String sourceOid, R01MQueryObject qry, int pageNum, Object pageFirstElementOid, Object pageLastElementOid) throws EJBException, R01MSearchPerformerException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_LOG).info("\tR01KSearchEngineServicesSL.execGetResults()...");
        }
        R01KSearchOrchestratorSession session = new R01KSearchOrchestratorSession();
        try {
            return session.execGetResults(searchEngineId, srchContext, searchSessionOid, searchSessionLang, sourceOid, qry, pageNum, pageFirstElementOid, pageLastElementOid);
        }
        catch (R01MSearchPerformerException sEx) {
            throw new EJBException((Exception)((Object)sEx));
        }
    }

    public R01MSearchResultItem[] execGetResultsFromAutonomyQuery(String sourceOid, String theContext, String autonomyQuery) throws R01MSearchPerformerException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_LOG).info("\tR01KSearchEngineServicesSL.execGetResults()...");
        }
        R01KSearchOrchestratorSession session = new R01KSearchOrchestratorSession();
        try {
            return session.execGetResultsFromAutonomyQuery(sourceOid, theContext, autonomyQuery);
        }
        catch (R01MSearchPerformerException sEx) {
            throw new EJBException((Exception)((Object)sEx));
        }
    }

    public String execGetSearchEngineQuerySentence(String searchEngineId, String theContext, String searchSessionOid, String searchSessionLang, String sourceOid, R01MQueryObject qry, int pageNum, Object pageFirstCod, Object pageLastCod) throws R01MSearchPerformerException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_LOG).info("\tR01KSearchEngineServicesSL.execGetSearchEngineQuerySentence()...");
        }
        R01KSearchOrchestratorSession session = new R01KSearchOrchestratorSession();
        try {
            return session.execGetSearchEngineQuerySentence(searchEngineId, theContext, searchSessionOid, searchSessionLang, sourceOid, qry, pageNum, pageFirstCod, pageLastCod);
        }
        catch (R01MSearchPerformerException sEx) {
            throw new EJBException((Exception)((Object)sEx));
        }
    }

    public List execSearchFullText(String text) throws R01MSearchPerformerException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_LOG).info("\tR01KSearchEngineServicesSL.execSearchFullText()...");
        }
        R01KSearchOrchestratorSession search = new R01KSearchOrchestratorSession();
        try {
            return search.execSearchFullText(text);
        }
        catch (R01MSearchPerformerException sEx) {
            throw new EJBException((Exception)((Object)sEx));
        }
    }
}

