/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services.resources;

import com.ejie.r01d.datastore.R01DContentInDataStore;
import com.ejie.r01d.exceptions.R01DContentModelPersistenceException;
import com.ejie.r01d.gestorcontenidos.dbhelppers.R01DContentModelLoaderHelper;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.document.R01DDocumentCMPPK;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.document.R01DDocumentCMPUtil;
import com.ejie.r01d.services.R01DContentModelManager;
import com.ejie.r01d.services.resources.R01DBaseResourcesManager;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.config.objects.container.R01MResourcesContainerConfig;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.exceptions.R01MJMSException;
import com.ejie.r01m.exceptions.R01MLinkResourcesException;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.resources.R01MLinkedResource;
import com.ejie.r01m.objects.resources.R01MLinkedResourcesGroup;
import com.ejie.r01m.objects.resources.R01MResourceInterface;
import com.ejie.r01m.objects.resources.R01MResourcesManagerInterface;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MPathHelpper;
import com.ejie.r01m.utils.jms.R01MJMSUtils;
import com.ejie.r01m.utils.jms.R01MJmsQueueParam;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.ejb.FinderException;
import javax.naming.NamingException;

public class R01DLinkedResourcesManager
extends R01DBaseResourcesManager
implements R01MResourcesManagerInterface {
    private static final String LOG_TYPE_ID = "r01d.render";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01d.render").intValue() != Level.OFF.intValue();
    private static long timeToDeliverLinkedResources = Long.parseLong(XMLProperties.get((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"timeToDeliverLinkedResources", (String)"15000"));
    private transient R01DContentModelManager _cmManager = new R01DContentModelManager();

    public final void saveResourcesObjectInfo(R01MUserContext userCtx, Map documentResources, Map linkData) throws R01MLinkResourcesException {
        R01MContent content = (R01MContent)linkData.get("content");
        String documentOid = (String)linkData.get("documentOid");
        String titleGroup = (String)linkData.get("titleGroup");
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("El fichero descriptor de recursos vinculados del documento '" + documentOid + "' va a ser actualizado.");
        }
        R01MLinkedResourcesGroup resourcesGroup = null;
        if (documentResources != null && !documentResources.isEmpty()) {
            resourcesGroup = new R01MLinkedResourcesGroup();
            resourcesGroup.setResources(documentResources);
        }
        if (resourcesGroup != null && !StringUtils.isEmptyString((String)titleGroup)) {
            resourcesGroup.setTitleGroupLabel(titleGroup);
        }
        StringBuffer resourcesXML = null;
        InputStream resourcesXMLIS = null;
        if (resourcesGroup != null) {
            resourcesXML = new StringBuffer();
            resourcesXML.append("<?xml version='1.0' encoding='ISO-8859-1'?>");
            try {
                resourcesXML.append(XOManager.getXML((String)R01MConstants.LINK_MAPFILE, (Object)resourcesGroup));
            }
            catch (XOMarshallerException mapExc) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error al mapear el XML de recursos del documento '" + documentOid + "'.Error:" + mapExc.getMessage());
                throw new R01MLinkResourcesException("Error al mapear el XML de recursos del documento '" + documentOid + "'", (Exception)((Object)mapExc));
            }
            try {
                resourcesXMLIS = StringUtils.getInputStream((StringBuffer)resourcesXML);
            }
            catch (UnsupportedEncodingException encExc) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error al obtener un stream del XML de recursos del documento '" + documentOid + "'.Error:" + encExc.getMessage());
                throw new R01MLinkResourcesException("Error al obtener un stream del XML de recursos del documento '" + documentOid + "'", (Exception)encExc);
            }
        }
        try {
            if (resourcesXML != null) {
                R01FLog.to((String)LOG_TYPE_ID).info(">>>>>>>>>>>>> El XML de vinculaciones tiene informaci\u00f3n.");
            } else {
                R01FLog.to((String)LOG_TYPE_ID).info(">>>>>>>>>>>>> El XML de vinculaciones est\u00e1 VACIO.");
            }
            R01DDocumentCMPUtil.getLocalHome().findByPrimaryKey(new R01DDocumentCMPPK(documentOid)).setXMLLinkedResources(resourcesXML != null ? resourcesXML.toString() : null);
        }
        catch (FinderException fndExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No existe el documento '" + documentOid + "'.Error:" + fndExc.getMessage());
            throw new R01MLinkResourcesException("No existe el documento '" + documentOid + "'", (Exception)((Object)fndExc));
        }
        catch (NamingException namExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se encuentra el EJB de documentos.Error:" + namExc.getMessage());
            throw new R01MLinkResourcesException("No se encuentra el EJB de documentos.", (Exception)namExc);
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("El fichero descriptor de recursos del documento '" + documentOid + "' ha sido actualizado en Base de Datos.");
        }
        R01DContentInDataStore dataStore = new R01DContentInDataStore(userCtx, content);
        R01MDocument document = content.getDocument(documentOid);
        String documentLinkedDescriptorDocumentRelativePath = R01MPathHelpper.getDocumentLinkedDescriptorDocumentRelativePath((String)document.getLanguage(), (String)document.getInternalName());
        if (resourcesXML != null) {
            try {
                dataStore.uploadAttachmentFile(documentOid, documentLinkedDescriptorDocumentRelativePath, resourcesXMLIS);
            }
            catch (R01MDataStoreException dsExc) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error al actualizar el fichero descriptor de recursos del documento '" + documentOid + "'.Error:" + dsExc.getMessage());
                throw new R01MLinkResourcesException("Error al actualizar el fichero descriptor de recursos del documento '" + documentOid + "'", (Exception)((Object)dsExc));
            }
        }
        try {
            dataStore.deleteAttachmentFile(documentOid, documentLinkedDescriptorDocumentRelativePath);
            dataStore.consolidateAttachmentFile(documentOid, documentLinkedDescriptorDocumentRelativePath);
        }
        catch (R01MDataStoreException dsExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al borrar el fichero descriptor de recursos del documento '" + documentOid + "'.Error:" + dsExc.getMessage());
            throw new R01MLinkResourcesException("Error al borrar el fichero descriptor de recursos del documento '" + documentOid + "'", (Exception)((Object)dsExc));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Fin actualizaci\u00f3n del fichero descriptor de recursos del documento '" + documentOid + "'.");
        }
    }

    public final String onLinkToObject(R01MUserContext userCtx, R01MResourceInterface resource, Map linkData) throws R01MLinkResourcesException {
        R01MContent content = (R01MContent)linkData.get("content");
        String documentOid = (String)linkData.get("documentOid");
        R01MLinkedResource linkResource = (R01MLinkedResource)resource;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Actualizar la relaci\u00f3n bidireccional del contenido '" + content.getOid() + "'.");
        }
        if (!StringUtils.isEmptyString((String)linkResource.getRelatedDocumentContentOid()) && !StringUtils.isEmptyString((String)linkResource.getRelatedDocumentDocumentOid()) && linkResource.isRelationOwner()) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("Relaci\u00f3n bidireccional entre los contenidos Base:'" + content.getOid() + "' <--> Destino:'" + linkResource.getRelatedDocumentContentOid() + "'.");
            }
            R01MLinkedResource newLinkResource = new R01MLinkedResource();
            newLinkResource.linkToContent(content.getOid(), documentOid);
            newLinkResource.getLink().getFirstLinkItem().setTitle(linkResource.getLink().getFirstLinkItem().getTitle());
            newLinkResource.setLinkType(2);
            newLinkResource.setContainerId(linkResource.getContainerId());
            newLinkResource.setRelatedDocumentLinkedResourceOid(linkResource.getOid());
            newLinkResource.setRelationOwner(false);
            newLinkResource.setRelationId(linkResource.getRelationId());
            newLinkResource.setPresentationTags(linkResource.getPresentationTags());
            if (linkResource.getUserInterfaceRelationTextSelector().equals("src")) {
                newLinkResource.setUserInterfaceRelationTextSelector("dst");
            } else {
                newLinkResource.setUserInterfaceRelationTextSelector("src");
            }
            Map inversePresentationTagIds = (Map)linkData.get("inversePresentationTagIds");
            if (inversePresentationTagIds != null && inversePresentationTagIds.containsKey(linkResource.getOid())) {
                newLinkResource.setPresentationTags((List)inversePresentationTagIds.get(linkResource.getOid()));
            }
            this.notifyNewLinkedRelationsInContent(linkResource.getRelatedDocumentContentOid(), linkResource.getRelatedDocumentDocumentOid(), linkResource.getRelatedDocumentContentRepositoryOid(), 1, newLinkResource.getOid(), newLinkResource);
            return newLinkResource.getOid();
        }
        return null;
    }

    public final void onUnlinkFromObject(R01MUserContext userCtx, R01MResourceInterface resource, Map linkData) throws R01MLinkResourcesException {
        String opDesc = "Borrar la relaci\u00f3n en el recurso asociado.";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        String contentOid = ((R01MContent)linkData.get("content")).getOid();
        R01MLinkedResource linkResource = (R01MLinkedResource)resource;
        if (!StringUtils.isEmptyString((String)linkResource.getRelatedDocumentContentOid()) && !StringUtils.isEmptyString((String)linkResource.getRelatedDocumentDocumentOid()) && linkResource.isRelationOwner()) {
            R01MContent relContent;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("Relaci\u00f3n bidireccional entre los contenidos Base:'" + contentOid + "' <--> Destino:'" + linkResource.getRelatedDocumentContentOid() + "'.");
            }
            try {
                relContent = this._cmManager.doLoadContent(userCtx, ((R01MLinkedResource)resource).getRelatedDocumentContentOid());
            }
            catch (R01MContentModelException cmExc) {
                R01FLog.to((String)LOG_TYPE_ID).warning("Error al cargar el contenido '" + ((R01MLinkedResource)resource).getRelatedDocumentContentOid() + "'.Error:" + cmExc.getMessage());
                return;
            }
            this.notifyNewLinkedRelationsInContent(relContent.getOid(), linkResource.getRelatedDocumentDocumentOid(), linkResource.getRelatedDocumentContentRepositoryOid(), 0, ((R01MLinkedResource)resource).getRelatedDocumentLinkedResourceOid(), null);
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end): " + opDesc);
        }
    }

    public final void onUpdatedLinkInObject(R01MUserContext userCtx, R01MResourceInterface resourceOld, R01MResourceInterface resourceNew, Map linkData) throws R01MLinkResourcesException {
        String opDesc = "Cambiar la relaci\u00f3n con el recurso asociado.";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01MLinkedResource currResourceOld = (R01MLinkedResource)resourceOld;
        R01MLinkedResource currResourceNew = (R01MLinkedResource)resourceNew;
        if (StringUtils.isEmptyString((String)currResourceOld.getRelatedDocumentContentOid()) && !StringUtils.isEmptyString((String)currResourceNew.getRelatedDocumentContentOid())) {
            this.onLinkToObject(userCtx, resourceNew, linkData);
        }
        if (!StringUtils.isEmptyString((String)currResourceOld.getRelatedDocumentContentOid()) && !StringUtils.isEmptyString((String)currResourceNew.getRelatedDocumentContentOid())) {
            if (!currResourceOld.getRelatedDocumentContentOid().equals(currResourceNew.getRelatedDocumentContentOid())) {
                this.onUnlinkFromObject(userCtx, resourceOld, linkData);
                this.onLinkToObject(userCtx, resourceNew, linkData);
            } else if (!currResourceOld.getRelationId().equals(currResourceNew.getRelationId())) {
                Map newResources;
                R01DContentModelLoaderHelper loaderHelper = new R01DContentModelLoaderHelper(userCtx);
                try {
                    newResources = loaderHelper.loadDocumentLinkedResourcesFromDBXML(currResourceNew.getRelatedDocumentDocumentOid()).getResources();
                }
                catch (R01DContentModelPersistenceException cmExc) {
                    R01FLog.to((String)LOG_TYPE_ID).warning("Error al cargar los recursos del documento '" + currResourceNew.getRelatedDocumentDocumentOid() + "'.Error:" + cmExc.getMessage());
                    return;
                }
                R01MLinkedResource resourceToModify = (R01MLinkedResource)newResources.get(currResourceNew.getRelatedDocumentLinkedResourceOid());
                if (resourceToModify != null) {
                    Map inversePresentationTagIds = (Map)linkData.get("inversePresentationTagIds");
                    if (inversePresentationTagIds != null && inversePresentationTagIds.containsKey(resourceOld.getOid())) {
                        resourceToModify.setPresentationTags((List)inversePresentationTagIds.get(resourceOld.getOid()));
                    }
                    resourceToModify.setRelationId(currResourceNew.getRelationId());
                    if (currResourceNew.getUserInterfaceRelationTextSelector().equals("src")) {
                        resourceToModify.setUserInterfaceRelationTextSelector("dst");
                    } else {
                        resourceToModify.setUserInterfaceRelationTextSelector("src");
                    }
                    this.notifyNewLinkedRelationsInContent(currResourceNew.getRelatedDocumentContentOid(), currResourceNew.getRelatedDocumentDocumentOid(), currResourceNew.getRelatedDocumentContentRepositoryOid(), 2, resourceToModify.getOid(), resourceToModify);
                } else {
                    throw new R01MLinkResourcesException("No se encuentra el vinculo con oid: " + currResourceNew.getRelatedDocumentLinkedResourceOid() + " del documento:" + currResourceNew.getRelatedDocumentDocumentOid());
                }
            }
        }
        if (!StringUtils.isEmptyString((String)currResourceOld.getRelatedDocumentContentOid()) && StringUtils.isEmptyString((String)currResourceNew.getRelatedDocumentContentOid())) {
            this.onUnlinkFromObject(userCtx, resourceOld, linkData);
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end): " + opDesc);
        }
    }

    public final void onFinishRenderPresentationFile(R01MUserContext userCtx, Map resources, Map linkData, boolean publishGeneratedFile, List repositories) throws R01MLinkResourcesException {
        String opDesc = "Generar el renderizado del HTML de las vinculaciones del documento.";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        super.onFinishRenderPresentationFile(userCtx, resources, linkData, publishGeneratedFile, repositories, "linked");
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end): " + opDesc);
        }
    }

    public void notifyNewLinkedRelationsInContent(String contentToUpdateOid, String documentToUpdateOid, String documentPubRepositoryOid, int action, String resourceOid, R01MLinkedResource resourceObj) {
        try {
            ArrayList<R01MJmsQueueParam> params = new ArrayList<R01MJmsQueueParam>();
            params.add(new R01MJmsQueueParam(1, "contentOid", (Object)contentToUpdateOid));
            params.add(new R01MJmsQueueParam(1, "documentOid", (Object)documentToUpdateOid));
            params.add(new R01MJmsQueueParam(1, "repositoryOid", (Object)documentPubRepositoryOid));
            params.add(new R01MJmsQueueParam(3, "action", (Object)Integer.toString(action)));
            params.add(new R01MJmsQueueParam(1, "resourceOid", (Object)(resourceOid != null ? resourceOid : "")));
            if (action == 0 || action == 3) {
                params.add(new R01MJmsQueueParam(1, "resourceObj", (Object)""));
            } else {
                params.add(new R01MJmsQueueParam(1, "resourceObj", (Object)XOManager.getXML((String)R01MConstants.LINK_MAPFILE, (Object)resourceObj)));
            }
            R01MJMSUtils.sendJMSMessage((String)"r01LinkedRelations", params, (long)timeToDeliverLinkedResources);
        }
        catch (R01MJMSException jmsExc) {
            R01FLog.to((String)LOG_TYPE_ID).warning("Error al notificar la creaci\u00f3n del v\u00ednculo en el contenido relacionado.Error:" + jmsExc.getMessage());
        }
        catch (XOMarshallerException xoExc) {
            R01FLog.to((String)LOG_TYPE_ID).warning("Error al crear el par\u00e1metro de v\u00ednculos para el contenido relacionado.Error:" + xoExc.getMessage());
        }
    }

    public void validateResourcesContainer(String workAreaOid, String typeOid, Map resources) throws R01MContentModelObjectsValidatorException, R01MContentModelException {
        R01MResourcesContainerConfig containerCfg;
        try {
            containerCfg = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(workAreaOid).getAllowedResourcesContainers();
            R01MResourcesContainerConfig containerTypoCfg = R01MClientFactory.getTypologyConfigAPI().getTypeConfig(typeOid).getAllowedResourcesContainers();
            if (containerTypoCfg != null && containerTypoCfg.getAllowedContainers() != null && !containerTypoCfg.getAllowedContainers().isEmpty()) {
                if (containerCfg == null) {
                    containerCfg = new R01MResourcesContainerConfig();
                    containerCfg.setAllowedContainers(new ArrayList());
                }
                for (String containerId : containerTypoCfg.getAllowedContainers()) {
                    if (containerCfg.getAllowedContainers().contains(containerId)) continue;
                    containerCfg.getAllowedContainers().add(containerId);
                }
            }
        }
        catch (R01MConfigLoadException cfgExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en la carga de contenedores validos para la workarea '" + workAreaOid + "'.Error:" + cfgExc.getMessage());
            throw new R01MContentModelException("Error en la carga de contenedores validos para la workarea '" + workAreaOid + "'.", (Exception)((Object)cfgExc));
        }
        if (resources != null && !resources.values().isEmpty()) {
            for (R01MLinkedResource resource : resources.values()) {
                if (containerCfg != null && (containerCfg.getAllowedContainers() == null || containerCfg.getAllowedContainers().contains(resource.getContainerId()))) continue;
                throw new R01MContentModelObjectsValidatorException("El contenedor " + resource.getContainerId() + " no esta configurado para la workarea " + workAreaOid);
            }
        }
    }
}

