/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services.resources;

import com.ejie.r01d.datastore.R01DContentInDataStore;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.document.R01DDocumentCMPPK;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.document.R01DDocumentCMPUtil;
import com.ejie.r01d.services.resources.R01DBaseResourcesManager;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01m.config.objects.container.R01MResourcesContainerConfig;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.exceptions.R01MLinkResourcesException;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.resources.R01MGalleryResourcesGroup;
import com.ejie.r01m.objects.resources.R01MResourceInterface;
import com.ejie.r01m.objects.resources.R01MResourcesManagerInterface;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MPathHelpper;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.ejb.FinderException;
import javax.naming.NamingException;

public class R01DGalleryResourcesManager
extends R01DBaseResourcesManager
implements R01MResourcesManagerInterface {
    private static final String LOG_TYPE_ID = "r01d.render";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01d.render").intValue() != Level.OFF.intValue();

    public void saveResourcesObjectInfo(R01MUserContext userCtx, Map linkData) throws R01MLinkResourcesException {
        R01MContent content = (R01MContent)linkData.get("content");
        String documentOid = (String)linkData.get("documentOid");
        Map documentGalleries = (Map)linkData.get("galleries");
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("El fichero descriptor de galer\u00edas del documento '" + documentOid + "' va a ser actualizado.");
        }
        R01MGalleryResourcesGroup galleriesGroup = null;
        if (documentGalleries != null && !documentGalleries.isEmpty()) {
            galleriesGroup = new R01MGalleryResourcesGroup();
            galleriesGroup.setGalleries(documentGalleries);
        }
        StringBuffer resourcesXML = null;
        InputStream resourcesXMLIS = null;
        if (galleriesGroup != null) {
            resourcesXML = new StringBuffer();
            resourcesXML.append("<?xml version='1.0' encoding='ISO-8859-1'?>");
            try {
                resourcesXML.append(XOManager.getXML((String)R01MConstants.LINK_MAPFILE, (Object)galleriesGroup));
            }
            catch (XOMarshallerException mapExc) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error al mapear el XML de recursos de galerias del documento '" + documentOid + "'.Error:" + mapExc.getMessage());
                throw new R01MLinkResourcesException("Error al mapear el XML de recursos de galerias del documento '" + documentOid + "'", (Exception)((Object)mapExc));
            }
            try {
                resourcesXMLIS = StringUtils.getInputStream((StringBuffer)resourcesXML);
            }
            catch (UnsupportedEncodingException encExc) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error al obtener un stream del XML de recursos de galerias del documento '" + documentOid + "'.Error:" + encExc.getMessage());
                throw new R01MLinkResourcesException("Error al obtener un stream del XML de recursos de galerias del documento '" + documentOid + "'", (Exception)encExc);
            }
        }
        try {
            R01DDocumentCMPUtil.getLocalHome().findByPrimaryKey(new R01DDocumentCMPPK(documentOid)).setXMLGalleryResources(resourcesXML != null ? resourcesXML.toString() : null);
        }
        catch (FinderException fndExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No existe el documento '" + documentOid + "'.Error:" + fndExc.getMessage());
            throw new R01MLinkResourcesException("No existe el documento '" + documentOid + "'", (Exception)((Object)fndExc));
        }
        catch (NamingException namExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se encuentra el EJB de documentos.Error:" + namExc.getMessage());
            throw new R01MLinkResourcesException("No se encuentra el EJB de documentos.", (Exception)namExc);
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("El fichero descriptor de galerias de recursos del documento '" + documentOid + "' ha sido actualizado en Base de Datos.");
        }
        R01DContentInDataStore dataStore = new R01DContentInDataStore(userCtx, content);
        R01MDocument document = content.getDocument(documentOid);
        String galleryDescriptorDocumentRelativePath = R01MPathHelpper.getDocumentGalleryDescriptorDocumentRelativePath((String)document.getLanguage(), (String)document.getInternalName());
        if (resourcesXML != null) {
            try {
                dataStore.uploadAttachmentFile(documentOid, galleryDescriptorDocumentRelativePath, resourcesXMLIS);
            }
            catch (R01MDataStoreException dsExc) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error al actualizar el fichero descriptor de galerias de recursos del documento '" + documentOid + "'.Error:" + dsExc.getMessage());
                throw new R01MLinkResourcesException("Error al actualizar el fichero descriptor de galerias de recursos del documento '" + documentOid + "'", (Exception)((Object)dsExc));
            }
        }
        try {
            dataStore.deleteAttachmentFile(documentOid, galleryDescriptorDocumentRelativePath);
            dataStore.consolidateAttachmentFile(documentOid, galleryDescriptorDocumentRelativePath);
        }
        catch (R01MDataStoreException dsExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al borrar el fichero descriptor de galerias de recursos del documento '" + documentOid + "'.Error:" + dsExc.getMessage());
            throw new R01MLinkResourcesException("Error al borrar el fichero descriptor de galerias de recursos del documento '" + documentOid + "'", (Exception)((Object)dsExc));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("El fichero descriptor de galerias de recursos del documento '" + documentOid + "' ha sido actualizado en el store.");
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Fin actualizaci\u00f3n del fichero descriptor de galerias de recursos del documento '" + documentOid + "'.");
        }
    }

    public String onLinkToObject(R01MUserContext userCtx, R01MResourceInterface resource, Map linkData) throws R01MLinkResourcesException {
        return null;
    }

    public void onUnlinkFromObject(R01MUserContext userCtx, R01MResourceInterface resource, Map linkData) throws R01MLinkResourcesException {
    }

    public void onUpdatedLinkInObject(R01MUserContext userCtx, R01MResourceInterface resourceOld, R01MResourceInterface resourceNew, Map linkData) throws R01MLinkResourcesException {
    }

    public void onFinishRenderPresentationFile(R01MUserContext userCtx, Map resources, Map linkData, boolean publishGeneratedFile, List repositories) throws R01MLinkResourcesException {
        String opDesc = "Generar el renderizado del HTML de la galer\u00eda del documento.";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        super.onFinishRenderPresentationFile(userCtx, resources, linkData, publishGeneratedFile, repositories, "gallery");
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end): " + opDesc);
        }
    }

    public void validateContainer(String workAreaOid, String typeOid, String containerId) throws R01MContentModelObjectsValidatorException, R01MContentModelException {
        R01MResourcesContainerConfig containerCfg;
        try {
            containerCfg = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(workAreaOid).getAllowedResourcesContainers();
            R01MResourcesContainerConfig containerTypoCfg = R01MClientFactory.getTypologyConfigAPI().getTypeConfig(typeOid).getAllowedResourcesContainers();
            if (containerTypoCfg != null && containerTypoCfg.getAllowedContainers() != null && !containerTypoCfg.getAllowedContainers().isEmpty()) {
                if (containerCfg == null) {
                    containerCfg = new R01MResourcesContainerConfig();
                    containerCfg.setAllowedContainers(new ArrayList());
                }
                for (String containerAllowedId : containerTypoCfg.getAllowedContainers()) {
                    if (containerCfg.getAllowedContainers().contains(containerAllowedId)) continue;
                    containerCfg.getAllowedContainers().add(containerAllowedId);
                }
            }
        }
        catch (R01MConfigLoadException cfgExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en la carga de contenedores validos para la workarea '" + workAreaOid + "'.Error:" + cfgExc.getMessage());
            throw new R01MContentModelException("Error en la carga de contenedores validos para la workarea '" + workAreaOid + "'.", (Exception)((Object)cfgExc));
        }
        if (containerCfg == null || containerCfg.getAllowedContainers() != null && !containerCfg.getAllowedContainers().contains(containerId)) {
            throw new R01MContentModelObjectsValidatorException("El contenedor " + containerId + " no esta configurado para la workarea " + workAreaOid);
        }
    }
}

