/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services.resources;

import com.ejie.r01d.datastore.R01DContentInDataStore;
import com.ejie.r01d.exceptions.R01DContentModelException;
import com.ejie.r01d.objects.R01DComposeResourceResult;
import com.ejie.r01d.renderer.R01DDocumentResourcesAPI;
import com.ejie.r01d.services.R01DContentModelManager;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.config.objects.container.R01MResourcesContainerManagementConfig;
import com.ejie.r01m.config.objects.typology.R01MResourcesRenderConfig;
import com.ejie.r01m.config.objects.typology.R01MResourcesRenderGroup;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.exceptions.R01MLinkResourcesException;
import com.ejie.r01m.exceptions.R01MPublisherException;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MContentLocation;
import com.ejie.r01m.objects.contentmodel.R01MContentTypologyInfo;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.contentmanager.R01MDocumentResourcesUtils;
import com.ejie.r01p.objects.publisher.R01PPublishDefinition;
import com.ejie.r01p.services.R01PClientFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

abstract class R01DBaseResourcesManager {
    private static final String LOG_TYPE_ID = "r01d.render";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01d.render").intValue() != Level.OFF.intValue();

    R01DBaseResourcesManager() {
    }

    public void onFinishRenderPresentationFile(R01MUserContext userCtx, Map resources, Map linkData, boolean publishGeneratedFile, List repositories, String renderGroupType) throws R01MLinkResourcesException {
        R01MResourcesRenderGroup rendererGroup;
        ArrayList<String> filesToUnPublish;
        ArrayList<String> filesToPublish;
        String htmlResourcesFileDocumentRelativePath;
        R01DContentInDataStore dataStore;
        R01MDocument document;
        List contentResourcesToDelete;
        String documentOid;
        R01MContent content;
        block64: {
            content = (R01MContent)linkData.get("content");
            documentOid = (String)linkData.get("documentOid");
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("[Renderizado de recursos](" + content.getOid() + ";" + documentOid + ") Inicio ...");
            }
            R01DContentModelManager cmManager = new R01DContentModelManager();
            try {
                if (!cmManager.doCheckContentDocumentRelation(content.getOid(), documentOid)) {
                    return;
                }
            }
            catch (R01MContentModelException ex2) {
                // empty catch block
            }
            Properties presentationParams = new Properties();
            presentationParams.put("contentOid", content.getOid());
            if (linkData.containsKey("titleGroup") && linkData.get("titleGroup") != null) {
                presentationParams.put("titleGroupLabel", linkData.get("titleGroup"));
            }
            if (linkData.containsKey("galleryId")) {
                presentationParams.put("galleryId", linkData.get("galleryId"));
            }
            if (linkData.containsKey("galleries")) {
                presentationParams.put("galleries", linkData.get("galleries"));
            }
            contentResourcesToDelete = null;
            try {
                contentResourcesToDelete = R01MDocumentResourcesUtils.getAllowedContainersFromLocAndTypo((R01MContentLocation)content.getStoreLocation(), (R01MContentTypologyInfo)content.getTypo());
            }
            catch (R01MContentModelException cmEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error en la carga de los contenedores permitidos para el contenido '" + content.getOid() + "', para el " + "almacenamiento " + content.getStoreLocation().composeMemoCode() + " " + "y la tipolog\u00eda " + content.getTypo().composeMemoCode() + ". " + "Error:" + cmEx.getMessage());
                throw new R01MLinkResourcesException("Error en la carga de los contenedores permitidos para el contenido '" + content.getOid() + "', para el " + "almacenamiento " + content.getStoreLocation().composeMemoCode() + " " + "y la tipolog\u00eda " + content.getTypo().composeMemoCode() + ". " + "Error:" + cmEx.getMessage(), (Exception)((Object)cmEx));
            }
            R01MResourcesContainerManagementConfig containersCfg = null;
            try {
                containersCfg = R01MClientFactory.getResourcesContainerConfigAPI().getResourcesContainerConfig();
            }
            catch (Exception cfgExc) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error en la carga de la configuraci\u00f3n de contenedores.Error:" + cfgExc.getMessage());
                throw new R01MLinkResourcesException("Error en la carga de la configuraci\u00f3n de contenedores.", cfgExc);
            }
            document = content.getDocument(documentOid);
            R01DDocumentResourcesAPI resourcesAPI = new R01DDocumentResourcesAPI(userCtx);
            dataStore = new R01DContentInDataStore(userCtx, content);
            htmlResourcesFileDocumentRelativePath = "";
            filesToPublish = new ArrayList<String>();
            filesToUnPublish = new ArrayList<String>();
            try {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("[Renderizado de recursos](" + content.getOid() + ";" + documentOid + ") CREAR EL ARCHIVO HTML PARA CADA CONTENEDOR.");
                }
                Map htmlResourcesByContainer = resourcesAPI.renderDocumentResourcesAsIS(documentOid, document.getLanguage(), content.getStoreLocation(), content.getTypo(), new ArrayList(resources.values()), renderGroupType, presentationParams);
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("[Renderizado de recursos](" + content.getOid() + ";" + documentOid + ") Fin renderizado, comienza el tratamiento de los buffers.");
                }
                StringBuffer subDirectory = new StringBuffer();
                for (Map.Entry meContainer : htmlResourcesByContainer.entrySet()) {
                    String currentContainer = (String)meContainer.getKey();
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("[Renderizado de recursos](" + content.getOid() + ";" + documentOid + ") Obtener el HTML para el contenedor:" + currentContainer);
                    }
                    Map allGeneratedHTML = (Map)meContainer.getValue();
                    if (contentResourcesToDelete != null && contentResourcesToDelete.contains(currentContainer)) {
                        if (DEBUG) {
                            R01FLog.to((String)LOG_TYPE_ID).info("[Renderizado de recursos](" + content.getOid() + ";" + documentOid + ") NO borrar el HTML para el contenedor:" + currentContainer);
                        }
                        contentResourcesToDelete.remove(currentContainer);
                    } else if (contentResourcesToDelete != null && !contentResourcesToDelete.contains(currentContainer)) {
                        if (!DEBUG) continue;
                        R01FLog.to((String)LOG_TYPE_ID).info("[Renderizado de recursos](" + content.getOid() + ";" + documentOid + ") Marcar para borrar el HTML para el contenedor:" + currentContainer);
                        continue;
                    }
                    if (!containersCfg.getContainerIds().contains(currentContainer)) {
                        R01FLog.to((String)LOG_TYPE_ID).warning("Para el contenido " + content.getOid() + "(" + content.getName() + ") y " + "documento " + document.getOid() + "(" + document.getLanguage() + "_" + document.getInternalName() + ") " + "se ha solicitado crear los recursos para el container " + currentContainer + " y " + "dicho container no existe en el fichero de definicion de los mismos: " + "WA sistema: /system_XX/others/r01ContainersConfig.xml");
                        continue;
                    }
                    if (allGeneratedHTML == null || allGeneratedHTML.isEmpty()) continue;
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("[Renderizado de recursos](" + content.getOid() + ";" + documentOid + ") TRATAR EL ARCHIVO HTML PARA CADA RENDERIZADO DEL CONTENEDOR");
                    }
                    for (Map.Entry meRenderResult : allGeneratedHTML.entrySet()) {
                        String renderId = (String)meRenderResult.getKey();
                        R01DComposeResourceResult generatedHtml = (R01DComposeResourceResult)meRenderResult.getValue();
                        try {
                            subDirectory.setLength(0);
                            String resourceInternalName = "";
                            if (renderGroupType.equals("gallery") && linkData.containsKey("galleryId") && linkData.get("galleries") != null && !((Map)linkData.get("galleries")).isEmpty()) {
                                resourceInternalName = linkData.get("galleryId").toString();
                                subDirectory.append("galleries");
                                subDirectory.append(File.separator);
                                subDirectory.append(resourceInternalName);
                                subDirectory.append(File.separator);
                            }
                            htmlResourcesFileDocumentRelativePath = R01MDocumentResourcesUtils.getDocumentResourceGeneratedFileDocumentRelativePath((R01MContentTypologyInfo)content.getTypo(), (String)renderGroupType, (String)renderId, (String)document.getLanguage(), (String)document.getInternalName(), (String)currentContainer, (String)resourceInternalName);
                        }
                        catch (R01MContentModelException cmExc) {
                            R01FLog.to((String)LOG_TYPE_ID).severe("Error al obtener el nombre del archivo del tipo \"" + renderGroupType + "\" para el contenido '" + content.getOid() + "'.Error:" + cmExc.getMessage());
                            throw new R01MLinkResourcesException("Error al obtener el nombre del archivo del tipo \"" + renderGroupType + "\" para el contenido '" + content.getOid() + "'.", (Exception)((Object)cmExc));
                        }
                        if (DEBUG) {
                            R01FLog.to((String)LOG_TYPE_ID).info("[Renderizado de recursos](" + content.getOid() + ";" + documentOid + ") Crear el HTML del tipo \"" + renderGroupType + "\" del documento '" + documentOid + "' con el nombre '" + htmlResourcesFileDocumentRelativePath + "'");
                        }
                        if (!StringUtils.isEmptyString((String)htmlResourcesFileDocumentRelativePath)) {
                            Object htmlRenderResult = null;
                            if (generatedHtml != null && generatedHtml.getStateResult() != 3) {
                                htmlRenderResult = generatedHtml.getResourceResultAsInputStream("html");
                                if (DEBUG) {
                                    R01FLog.to((String)LOG_TYPE_ID).info("[Renderizado de recursos](" + content.getOid() + ";" + documentOid + ") El HTML generado para " + htmlResourcesFileDocumentRelativePath + " es:\n" + htmlRenderResult);
                                }
                            } else if (DEBUG) {
                                R01FLog.to((String)LOG_TYPE_ID).info("[Renderizado de recursos](" + content.getOid() + ";" + documentOid + ") El HTML generado para " + htmlResourcesFileDocumentRelativePath + " es vacio.");
                            }
                            if (htmlRenderResult != null && !StringUtils.isEmptyString((String)htmlRenderResult.toString())) {
                                dataStore.uploadAttachmentFile(documentOid, htmlResourcesFileDocumentRelativePath, (InputStream)htmlRenderResult);
                                if (!publishGeneratedFile) continue;
                                filesToPublish.add(document.getLanguage() + "_" + document.getInternalName() + "/" + htmlResourcesFileDocumentRelativePath);
                                continue;
                            }
                            if (DEBUG) {
                                R01FLog.to((String)LOG_TYPE_ID).info("[Renderizado de recursos](" + content.getOid() + ";" + documentOid + ") Borrar el archivo " + htmlResourcesFileDocumentRelativePath + "  ya que no tiene tama\u00f1o, y por tanto contenido.");
                            }
                            dataStore.deleteAttachmentFile(documentOid, htmlResourcesFileDocumentRelativePath);
                            if (!publishGeneratedFile) continue;
                            filesToUnPublish.add(document.getLanguage() + "_" + document.getInternalName() + "/" + htmlResourcesFileDocumentRelativePath);
                            continue;
                        }
                        R01FLog.to((String)LOG_TYPE_ID).warning("No se ha podido obtener el nombre del archivo de generacion del tipo \"" + renderGroupType + "\" para el documento '" + documentOid + "'.");
                    }
                }
                if (!renderGroupType.equals("gallery")) break block64;
                try {
                    rendererGroup = R01MDocumentResourcesUtils.getTypologyRenders((R01MContentTypologyInfo)content.getTypo(), (String)"gallery");
                }
                catch (R01MContentModelException cmExc) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("Error en la carga de los renderizadores del tipo '" + renderGroupType + "' para la tipolog\u00eda " + content.getTypo().composeMemoCode() + ".Error:" + cmExc.getMessage());
                    throw new R01DContentModelException("Error en la carga de los renderizadores del tipo '" + renderGroupType + "' para la tipolog\u00eda " + content.getTypo().composeMemoCode(), (Exception)((Object)cmExc));
                }
                String headFiles = resourcesAPI.getHeadFilesHtml(rendererGroup);
                dataStore.uploadAttachmentFile(documentOid, "/" + R01MConstants.DOCUMENT_INDEX_FOLDER + "/r01ContHead.shtml", (InputStream)new ByteArrayInputStream(headFiles.getBytes()));
            }
            catch (R01DContentModelException cmExc) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error al generar el renderizado del HTML del tipo \"" + renderGroupType + "\" del documento '" + documentOid + "'.Error:" + cmExc.getMessage());
                throw new R01MLinkResourcesException("Error al generar el renderizado del HTML del tipo \"" + renderGroupType + "\" del documento '" + documentOid + "'.", (Exception)((Object)cmExc));
            }
            catch (R01MDataStoreException dsExc) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error al crear el archivo '" + htmlResourcesFileDocumentRelativePath + "' del renderizado del HTML del tipo \"" + renderGroupType + "\" del documento '" + documentOid + "'.Error:" + dsExc.getMessage());
                throw new R01MLinkResourcesException("Error al crear el archivo '" + htmlResourcesFileDocumentRelativePath + "' del renderizado del HTML del tipo \"" + renderGroupType + "\" del documento '" + documentOid + "'.", (Exception)((Object)dsExc));
            }
        }
        R01DContentModelManager manager = new R01DContentModelManager();
        if (publishGeneratedFile) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("[Renderizado de recursos](" + content.getOid() + ";" + documentOid + ") [R01DBaseResourcesManager] Publicar el filelist de archivos de recursos generados.....");
            }
            if (repositories != null && !repositories.isEmpty()) {
                Iterator itRep = repositories.iterator();
                while (itRep.hasNext()) {
                    R01PPublishDefinition pubDefinition;
                    String repositoryOid = itRep.next().toString();
                    boolean isDocumentPublished = false;
                    try {
                        isDocumentPublished = manager.isDocumentPublished(userCtx, repositoryOid, documentOid);
                    }
                    catch (R01MContentModelException ex) {
                        R01FLog.to((String)LOG_TYPE_ID).warning("Error al validar si el documento '" + documentOid + "' est\u00e1 publicado en el repositorio '" + repositoryOid + "'");
                    }
                    if (isDocumentPublished && !filesToPublish.isEmpty()) {
                        try {
                            pubDefinition = new R01PPublishDefinition(userCtx.getUserName(), content.getOid(), 11, null, null, filesToPublish, repositoryOid, 0, null, null, true, null, null);
                            R01PClientFactory.getPublisherAPI().publish(pubDefinition);
                        }
                        catch (R01MPublisherException pubExc) {
                            R01FLog.to((String)LOG_TYPE_ID).warning("Error en la publicaci\u00f3n del HTML generado del tipo \"" + renderGroupType + "\" del documento '" + documentOid + "' en el repositorio '" + repositoryOid + "'.Error:" + pubExc.getMessage());
                        }
                    }
                    if (!isDocumentPublished || filesToUnPublish.isEmpty()) continue;
                    try {
                        pubDefinition = new R01PPublishDefinition(userCtx.getUserName(), content.getOid(), 11, null, null, filesToUnPublish, repositoryOid, 2, null, null, true, null, null);
                        R01PClientFactory.getPublisherAPI().publish(pubDefinition);
                    }
                    catch (R01MPublisherException pubExc) {
                        R01FLog.to((String)LOG_TYPE_ID).warning("Error en la publicaci\u00f3n del HTML generado del tipo \"" + renderGroupType + "\" del documento '" + documentOid + "' en el repositorio '" + repositoryOid + "'.Error:" + pubExc.getMessage());
                    }
                }
            }
        }
        if (contentResourcesToDelete != null && !contentResourcesToDelete.isEmpty()) {
            filesToPublish = new ArrayList();
            rendererGroup = null;
            try {
                rendererGroup = R01MDocumentResourcesUtils.getTypologyRenders((R01MContentTypologyInfo)content.getTypo(), (String)renderGroupType);
            }
            catch (R01MContentModelException ex1) {
                R01FLog.to((String)LOG_TYPE_ID).warning("Error en la carga de los renderizadores para la tipolog\u00eda " + content.getTypo().composeMemoCode());
            }
            if (rendererGroup != null && rendererGroup.getRenders() != null && !rendererGroup.getRenders().isEmpty()) {
                for (R01MResourcesRenderConfig resourcesHtmlRenderCfg : rendererGroup.getRenders().values()) {
                    for (String containerId : contentResourcesToDelete) {
                        try {
                            htmlResourcesFileDocumentRelativePath = R01MDocumentResourcesUtils.getDocumentResourceGeneratedFileDocumentRelativePath((R01MContentTypologyInfo)content.getTypo(), (String)renderGroupType, (String)resourcesHtmlRenderCfg.getId(), (String)document.getLanguage(), (String)document.getInternalName(), (String)containerId);
                        }
                        catch (R01MContentModelException cmExc) {
                            R01FLog.to((String)LOG_TYPE_ID).warning("Error al obtener el path del archivo de recursos del tipo \"" + renderGroupType + "\" del documento '" + documentOid + "'.Error:" + cmExc.getMessage());
                            continue;
                        }
                        filesToPublish.add(htmlResourcesFileDocumentRelativePath);
                        try {
                            dataStore.deleteAttachmentFile(documentOid, htmlResourcesFileDocumentRelativePath);
                        }
                        catch (R01MDataStoreException dsExc) {
                            R01FLog.to((String)LOG_TYPE_ID).severe("Error al borrar el archivo '" + htmlResourcesFileDocumentRelativePath + "' del renderizado del HTML del tipo \"" + renderGroupType + "\" del documento '" + documentOid + "'.Error:" + dsExc.getMessage());
                            throw new R01MLinkResourcesException("Error al borrar el archivo '" + htmlResourcesFileDocumentRelativePath + "' del renderizado del HTML del tipo \"" + renderGroupType + "\" del documento '" + documentOid + "'.", (Exception)((Object)dsExc));
                        }
                    }
                    if (!publishGeneratedFile || repositories == null || repositories.isEmpty()) continue;
                    Iterator itRep = repositories.iterator();
                    while (itRep.hasNext()) {
                        String repositoryOid = itRep.next().toString();
                        boolean isDocumentPublished = false;
                        try {
                            isDocumentPublished = manager.isDocumentPublished(userCtx, repositoryOid, documentOid);
                        }
                        catch (R01MContentModelException ex) {
                            R01FLog.to((String)LOG_TYPE_ID).warning("Error al validar si el documento '" + documentOid + "' est\u00e1 publicado en el repositorio '" + repositoryOid + "'");
                        }
                        if (!isDocumentPublished) continue;
                        try {
                            R01PPublishDefinition pubDefinition = new R01PPublishDefinition(userCtx.getUserName(), content.getOid(), 11, null, null, filesToPublish, repositoryOid, 2, null, null, true, null, null);
                            R01PClientFactory.getPublisherAPI().publish(pubDefinition);
                        }
                        catch (R01MPublisherException pubExc) {
                            R01FLog.to((String)LOG_TYPE_ID).warning("Error en la publicaci\u00f3n del HTML generado del tipo \"" + renderGroupType + "\" del documento '" + documentOid + "' en el repositorio '" + repositoryOid + "'.Error:" + pubExc.getMessage());
                        }
                    }
                }
            }
        }
    }
}

