/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services.helpers;

import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.config.objects.typology.R01MContentType;
import com.ejie.r01m.config.objects.typology.R01MMetadataGenerator;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.services.R01MClientFactory;

public class R01DTypoMetadataGeneratorHelper {
    private R01MUserContext _userCtx;

    public R01DTypoMetadataGeneratorHelper(R01MUserContext userCtx) {
        this._userCtx = userCtx;
    }

    public String obtainComposeMetadataValue(String typologyOid, String metadataOid) throws R01MContentModelException {
        R01MContentType typeConfig = null;
        String metadataName = "";
        try {
            typeConfig = R01MClientFactory.getTypologyConfigAPI().getTypeConfig(typologyOid);
        }
        catch (R01MConfigLoadException ex) {
            throw new R01MContentModelException("Error en la carga de configuraciones. " + ex.getMessage());
        }
        String[] configValues = this._obtainComposeMetadataClass(typeConfig, metadataOid);
        String className = configValues[0];
        String methodName = configValues[1];
        if (!StringUtils.isEmptyString((String)className) && !StringUtils.isEmptyString((String)methodName)) {
            try {
                Object objDef = ReflectionUtils.getObjectInstance((String)className);
                metadataName = (String)ReflectionUtils.invokeMethod((Object)objDef, (String)methodName, (Class[])new Class[]{String.class}, (Object[])new Object[]{typologyOid});
            }
            catch (ReflectionException refEx) {
                throw new R01MContentModelException("Error al obtener el metadato generado. " + refEx.getMessage());
            }
            catch (ClassNotFoundException cnfEx) {
                throw new R01MContentModelException("Error al obtener el metadato generado: NO se encuentra la clase de generacion de metadatos " + className + " de la tipolog\u00eda " + typologyOid);
            }
            catch (Throwable thEx) {
                throw new R01MContentModelException("Error al obtener el metadato generado. " + thEx.getMessage());
            }
        }
        return metadataName;
    }

    private String[] _obtainComposeMetadataClass(R01MContentType typeConfig, String metadataOid) {
        String[] configValues = new String[]{"", ""};
        if (typeConfig != null) {
            R01MMetadataGenerator metadataGenerator = null;
            if (typeConfig.getMetadataGeneratorClass() != null && typeConfig.getMetadataGeneratorClass().containsKey(metadataOid) && (metadataGenerator = (R01MMetadataGenerator)typeConfig.getMetadataGeneratorClass().get(metadataOid)) != null) {
                configValues[0] = metadataGenerator.getGeneratorClass();
                configValues[1] = metadataGenerator.getMethod();
            }
        }
        return configValues;
    }
}

