/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services.helpers;

import com.ejie.r01d.gestorcontenidos.ejb.cmp.opendataPackage.R01DOpendataPackageCMPLocal;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.opendataPackage.R01DOpendataPackageCMPPK;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.opendataPackage.R01DOpendataPackageCMPUtil;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.opendataPackage.R01DOpendataPackageCMPValue;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.objects.opendata.R01MOpendataPackage;
import com.ejie.r01m.utils.R01MConstants;
import java.util.logging.Level;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

public class R01DPackageHelper {
    private static final String LOG_TYPE_ID = "r01d.manager";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01d.manager").intValue() != Level.OFF.intValue();
    private transient R01MUserContext _userCtx;

    public R01DPackageHelper(R01MUserContext userCtx) {
        this._userCtx = userCtx;
    }

    public void doSavePackage(R01MOpendataPackage opendataPackage) throws R01MContentModelException {
        R01DOpendataPackageCMPLocal packageCMPUtil = null;
        try {
            packageCMPUtil = R01DOpendataPackageCMPUtil.getLocalHome().findByPrimaryKey(new R01DOpendataPackageCMPPK(opendataPackage.getOid()));
        }
        catch (FinderException fndExc) {
            this._registerNewPackage(opendataPackage);
            return;
        }
        catch (NamingException namExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PACKAGE MANAGER.doSavePackage > Error al encontrar el CMP de empaquetado:" + namExc.getMessage());
            throw new R01MContentModelException("No se encuentra el CMP de empaquetado.", (Exception)namExc);
        }
        this._updatePackage(opendataPackage, packageCMPUtil);
    }

    public void doDeletePackage(String packageOid) throws R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tejbRemove()...");
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PACKAGE MANAGER" + packageOid + ") > DELETE > Borrando el empaquetado.");
        }
        try {
            R01DOpendataPackageCMPUtil.getLocalHome().findByPrimaryKey(new R01DOpendataPackageCMPPK(packageOid)).remove();
        }
        catch (EJBException ejbEx) {
            R01FLog.to((String)"r01g.categoryManager").severe("PACKAGE MANAGER (" + packageOid + ") > DELETE > Error en CMP del empaquetado.");
            throw new R01MContentModelException("Error al borrar el empaquetado " + packageOid + ": " + ejbEx.getMessage());
        }
        catch (RemoveException remEx) {
            R01FLog.to((String)"r01g.categoryManager").severe("PACKAGE MANAGER (" + packageOid + ") > DELETE > No se puede borrar el empaquetado.");
            throw new R01MContentModelException("No se puede borrar el empaquetado " + packageOid + ": " + remEx.getMessage());
        }
        catch (FinderException findEx) {
            R01FLog.to((String)"r01g.categoryManager").severe("PACKAGE MANAGER (" + packageOid + ")> DELETE > No existe la categor\u00eda.");
            throw new R01MContentModelException("No existe el empaquetado " + packageOid + ": " + findEx.getMessage());
        }
        catch (NamingException namEx) {
            R01FLog.to((String)"r01g.categoryManager").severe("PACKAGE MANAGER (" + packageOid + ")> DELETE > Error al localizar el home del CMP del empaquetado.");
            throw new R01MContentModelException("Error al localizar el home del CMP de empaquetado: " + namEx.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01g.categoryManager").info("PACKAGE MANAGER (" + packageOid + ")> DELETE > empaquetado Borrado!");
        }
    }

    private void _registerNewPackage(R01MOpendataPackage opendataPackage) throws R01MContentModelException {
        R01DOpendataPackageCMPValue packageVO = new R01DOpendataPackageCMPValue();
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PACKAGE MANAGER (" + opendataPackage.getOid() + ") >> Mapeo del paquete");
        }
        packageVO.setName(opendataPackage.getNamePackage());
        packageVO.setOid(opendataPackage.getOid());
        int state = new Integer(opendataPackage.getStatePackage());
        packageVO.setState(state);
        packageVO.setContentOid(opendataPackage.getContentOidPackage());
        packageVO.setLang(opendataPackage.getLang());
        StringBuffer dataXML = new StringBuffer();
        try {
            dataXML.append(XOManager.getXML((String)R01MConstants.CONTENTMODEL_MAPFILE, (Object)opendataPackage));
        }
        catch (XOMarshallerException xoExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PACKAGE MANAGER(" + opendataPackage.getOid() + ") > Error al mapear el objeto empaquetado a XML. Error:" + xoExc.getMessage());
            throw new R01MContentModelException("Error al mapear el objeto opendatapaquete a XML: " + xoExc.getMessage(), (Exception)((Object)xoExc));
        }
        packageVO.setXML(dataXML.toString());
        try {
            R01DOpendataPackageCMPUtil.getLocalHome().create(packageVO);
        }
        catch (CreateException crtExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PACKAGE MANAGER > Error al crear el empaquetado (" + opendataPackage.getOid() + "). Error:" + crtExc.getMessage());
            throw new R01MContentModelException((Exception)((Object)crtExc));
        }
        catch (NamingException namEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al encontrar el CMP de empaquetado. Error:" + namEx.getMessage());
            return;
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PACKAGE MANAGER > Registrando el empaquetado (" + opendataPackage.getOid() + ").");
        }
    }

    private void _updatePackage(R01MOpendataPackage opendataPackage, R01DOpendataPackageCMPLocal packageCMP) throws R01MContentModelException {
        StringBuffer dataXML = new StringBuffer();
        try {
            dataXML.append(XOManager.getXML((String)R01MConstants.CONTENTMODEL_MAPFILE, (Object)opendataPackage));
        }
        catch (XOMarshallerException xoExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PACKAGE MANAGER(" + opendataPackage.getOid() + ") > Error al mapear el objeto empaquetado a XML. Error:" + xoExc.getMessage());
            throw new R01MContentModelException("Error al mapear el objeto opendatapaquete a XML: " + xoExc.getMessage(), (Exception)((Object)xoExc));
        }
        int state = new Integer(opendataPackage.getStatePackage());
        R01DOpendataPackageCMPValue packageVO = new R01DOpendataPackageCMPValue();
        packageVO.setName(opendataPackage.getNamePackage());
        packageVO.setState(state);
        packageVO.setXML(dataXML.toString());
        packageVO.setOid(packageCMP.getOid());
        packageVO.setContentOid(opendataPackage.getContentOidPackage());
        packageVO.setLang(opendataPackage.getLang());
        if (opendataPackage.getUpdateDatePackage() != 0L) {
            packageVO.setUpdateDatePackage(opendataPackage.getUpdateDatePackage());
        }
        packageCMP.setR01DOpendataPackageCMPValue(packageVO);
    }
}

