/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services.helpers;

import com.ejie.r01d.services.R01DContentAdminManager;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MSearchIllegalPaginationException;
import com.ejie.r01m.exceptions.R01MSearchInitializeException;
import com.ejie.r01m.exceptions.R01MSearchPerformerException;
import com.ejie.r01m.objects.notice.R01MNotice;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedOrderByMetaData;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.session.R01MSearchSession;
import com.ejie.r01m.searchengine.servlet.R01MSearchEngineWebConstants;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class R01DNoticeHelper {
    private static final String NOTICE_URL_PAGE = XMLProperties.get((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"notice/previewUrlPage", (String)"/r01-iwprev/");
    private R01MUserContext _userCtx;

    public R01DNoticeHelper(R01MUserContext userCtx) {
        this._userCtx = userCtx;
    }

    public String cleanExpiredNotice(String contentsOid, String lang) throws R01MContentModelException {
        StringBuffer noticesOid = new StringBuffer();
        List<R01MNotice> notices = this.getActiveNotices(lang);
        if (notices != null && !notices.isEmpty()) {
            for (int i = 0; i < notices.size(); ++i) {
                String contentOid = notices.get(i).getContentOid();
                if (contentsOid.indexOf(contentOid) == -1) continue;
                noticesOid.append(contentOid);
                if (i == notices.size() - 1) continue;
                noticesOid.append(";");
            }
        }
        return noticesOid.toString();
    }

    public List<R01MNotice> getActiveNotices(String lang) throws R01MContentModelException {
        int accesToContents = this._userCtx.getUserContentWorkAreas() == null || this._userCtx.getUserContentWorkAreas().isEmpty() ? 0 : 1;
        int accesToPortal = this._userCtx.getUserPortals() == null || this._userCtx.getUserPortals().isEmpty() ? 0 : 1;
        R01MQueryObject queryObject = new R01MQueryObject();
        queryObject.setLanguage(lang);
        queryObject.addContentFamily("avisos_tecnicos");
        queryObject.addContentType("aviso_tecnico");
        R01DContentAdminManager adminMngr = new R01DContentAdminManager();
        List<String> repo = adminMngr.doGetAllowedTargetsToPublishDocuments();
        if (repo != null && !repo.isEmpty()) {
            for (String currentRepo : repo) {
                queryObject.addPublishRepository(currentRepo);
            }
        }
        queryObject.setReturnLinkedDocuments(false);
        String pattern = DateUtils.getLanguageDateFormat((String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS);
        String today = DateUtils.getDateFormated((Date)new Date(), (String)pattern);
        queryObject.addMetaData("noticeActivationDate", "LTE", today);
        queryObject.addMetaData("noticeExpirationDate", "GTEN", today);
        if (accesToContents == 1 && accesToPortal == 1) {
            queryObject.addORMetaData("noticeIntenalScopeContents", "EQ", String.valueOf(accesToContents));
            queryObject.addORMetaData("noticeIntenalScopePortals", "EQ", String.valueOf(accesToPortal));
        } else if (accesToContents == 1 && accesToPortal == 0) {
            queryObject.addMetaData("noticeIntenalScopeContents", "EQ", String.valueOf(accesToContents));
        } else if (accesToContents == 0 && accesToPortal == 1) {
            queryObject.addMetaData("noticeIntenalScopePortals", "EQ", String.valueOf(accesToPortal));
        } else if (accesToContents == 0 && accesToPortal == 0) {
            queryObject.addMetaData("noticeIntenalScopeContents", "EQ", String.valueOf(accesToContents));
            queryObject.addMetaData("noticeIntenalScopePortals", "EQ", String.valueOf(accesToPortal));
        }
        ArrayList<R01MSearchedOrderByMetaData> orderBy = new ArrayList<R01MSearchedOrderByMetaData>();
        orderBy.add(new R01MSearchedOrderByMetaData("noticeActivationDate", "desc"));
        queryObject.setOrderBy(orderBy);
        queryObject.setPresentationProperty("r01PageSize", "" + R01MSearchEngineWebConstants.MAX_RESULTITEMS_PER_PAGE);
        ArrayList<R01MNotice> activeNotices = null;
        try {
            R01MSearchSession session = R01MClientFactory.getSearchEngineSessionAPI().createSession(lang, queryObject);
            List totalResults = session.getTotalPagesAndSourcesSearchResultItems();
            if (totalResults != null && !totalResults.isEmpty()) {
                activeNotices = new ArrayList<R01MNotice>();
                for (R01MSearchResultItem item : totalResults) {
                    R01MNotice notice = new R01MNotice();
                    notice.setContentOid(item.getContentOid());
                    notice.setDocumentOid(item.getDocumentOid());
                    if (item.getDocumentMetaData("noticeActivationDate") != null) {
                        notice.setActivationDate(DateUtils.getDateFromFormatedString((String)item.getDocumentMetaData("noticeActivationDate"), (String)"dd/MM/yyyy"));
                    }
                    notice.setDescription(item.getDocumentMetaData("noticeDescription"));
                    notice.setTitle(item.getDocumentMetaData("noticeTitle"));
                    StringBuffer previewUrl = new StringBuffer(50);
                    previewUrl.append(NOTICE_URL_PAGE);
                    previewUrl.append(lang);
                    previewUrl.append("/contenidos/");
                    previewUrl.append(item.getDocumentWorkAreaRelativePath());
                    previewUrl.append("/");
                    previewUrl.append(item.getDocumentMainDataFileDefaultGeneratedFileDocumentRelativePath());
                    notice.setPreviewUrl(previewUrl.toString());
                    notice.setMiniatureUrl("");
                    activeNotices.add(notice);
                }
            }
        }
        catch (R01MSearchInitializeException initExc) {
            throw new R01MContentModelException("Error en la inicializaci\u00f3n de la query :" + initExc.getMessage());
        }
        catch (IllegalStateException ex) {
            throw new R01MContentModelException("Error en la b\u00fasqueda :" + ex.getMessage());
        }
        catch (R01MSearchPerformerException ex) {
            throw new R01MContentModelException("Error en la inicializaci\u00f3n de la query :" + ex.getMessage());
        }
        catch (R01MSearchIllegalPaginationException ex) {
            throw new R01MContentModelException("Error en la paginaci\u00f3n de la b\u00fasqueda :" + ex.getMessage());
        }
        return activeNotices;
    }

    public String convertContentsOidToString(String oidsContentsRead, List<R01MNotice> oidsToConvert) {
        StringBuffer contentsOid = new StringBuffer();
        if (oidsToConvert != null && !oidsToConvert.isEmpty()) {
            for (int i = 0; i < oidsToConvert.size(); ++i) {
                String contentOid = oidsToConvert.get(i).getContentOid();
                if (!StringUtils.isEmptyString((String)oidsContentsRead) && oidsContentsRead.indexOf(contentOid) != -1) continue;
                if (!StringUtils.isEmptyString((String)oidsContentsRead) || !StringUtils.isEmptyString((String)contentsOid.toString())) {
                    contentsOid.append(";");
                }
                contentsOid.append(contentOid);
            }
        }
        return contentsOid.toString();
    }
}

