/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services.helpers;

import com.ejie.r01d.exceptions.R01DContentModelPersistenceException;
import com.ejie.r01d.gestorcontenidos.dbhelppers.ejb.R01DEjbContentModelLoader;
import com.ejie.r01f.jvt.JVTComparator;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MDeleteContentException;
import com.ejie.r01m.exceptions.R01MDeleteDocumentException;
import com.ejie.r01m.exceptions.R01MDuplicateContentException;
import com.ejie.r01m.exceptions.R01MDuplicateDataFileException;
import com.ejie.r01m.exceptions.R01MDuplicateDocumentException;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MDataFile;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.contentmodel.R01MDocumentPublicationTarget;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class R01DModelUpdateValidatorHelper {
    private transient R01MUserContext _userCtx = null;
    private transient R01MContent _content = null;
    private transient R01MDocument _document = null;
    private static final String LOG_TYPE_ID = "r01d.manager";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01d.manager").intValue() != Level.OFF.intValue();

    public R01DModelUpdateValidatorHelper() {
    }

    public R01DModelUpdateValidatorHelper(R01MUserContext userCtx, Object object) throws R01MContentModelException {
        this._userCtx = userCtx;
        if (object instanceof R01MContent) {
            this._content = (R01MContent)object;
        } else if (object instanceof R01MDocument) {
            this._document = (R01MDocument)object;
        } else {
            throw new R01MContentModelException("Error en el validador de objetos del modelo de contenidos. El tipo de objeto no es v\u00e1lido: " + object.getClass());
        }
    }

    public void processOperations(List<JVTComparator.PlanTableOperation> planTable) throws R01MContentModelException, R01MDuplicateContentException, R01MDuplicateDocumentException, R01MDuplicateDataFileException, R01MDeleteContentException, R01MDeleteDocumentException {
        if (this._userCtx == null || this._content == null && this._document == null || planTable == null || planTable.isEmpty()) {
            return;
        }
        for (JVTComparator.PlanTableOperation operation : planTable) {
            Object obj = null;
            Object objParent = null;
            if (operation.args.length == 1) {
                obj = operation.args[0];
            } else {
                obj = operation.args[1];
                objParent = operation.args[0];
            }
            if (obj instanceof R01MContent && operation.operation == 1) {
                boolean canBeInserted;
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\t...ver si existe un contenido con el mismo nombre y tipo que " + this._content.getName() + " (" + this._content.getTypo().composeMemoCode() + ")....");
                }
                if (canBeInserted = this._validateContentForInsert()) continue;
                throw new R01MDuplicateContentException("El contenido " + this._content.getName() + " ya existe en el tipo " + this._content.getTypo().composeMemoCode());
            }
            if (obj instanceof R01MDocument && operation.operation == 5) {
                boolean canBeInserted;
                R01MDocument doc = (R01MDocument)obj;
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\t...ver si existe un documento con nombreInterno-lenguage: " + doc.getInternalName() + "-" + doc.getLanguage() + " en el contenido " + this._content.getName() + " (" + this._content.getTypo().composeMemoCode() + ")....");
                }
                if (canBeInserted = this._validateDocumentForInsert(doc)) continue;
                throw new R01MDuplicateDocumentException("El documento " + doc.getInternalName() + "-" + doc.getLanguage() + " ya existe en el contenido " + this._content.getOid() + "(" + this._content.getName() + "> " + this._content.getTypo().composeMemoCode() + ")");
            }
            if (obj instanceof R01MDataFile && operation.operation == 5) {
                boolean canBeInserted;
                R01MDocument doc = (R01MDocument)objParent;
                R01MDataFile df = (R01MDataFile)obj;
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\t...ver si existe el dataFile " + df.getName() + " en el documento " + doc.getInternalName() + "-" + doc.getLanguage());
                }
                if (canBeInserted = this._validateDataFileForInsert(doc, df)) continue;
                throw new R01MDuplicateDataFileException("El dataFile " + df.getName() + " ya existe en el documento " + doc.getInternalName() + "-" + doc.getLanguage());
            }
            if (obj instanceof R01MContent && operation.operation == 2) {
                boolean canBeDeleted;
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\t...ver si se puede borrar el contenido " + this._content.getName() + " (" + this._content.getTypo().composeMemoCode() + ")");
                }
                if (canBeDeleted = this._validateContentForDeletion()) continue;
                throw new R01MDeleteContentException("No se puede borrar el contenido " + this._content.getName() + " (" + this._content.getTypo().composeMemoCode() + ") ya que alguno de los documentos esta publicado");
            }
            if (obj instanceof R01MDocument && operation.operation == 6) {
                boolean canBeDeleted;
                R01MDocument doc = (R01MDocument)obj;
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\t...ver si se puede borrar el documento " + doc.getInternalName() + "-" + doc.getLanguage() + " del contenido " + this._content.getName() + " (" + this._content.getTypo().composeMemoCode() + ")");
                }
                if (canBeDeleted = this._validateDocumentForDeletion(doc)) continue;
                throw new R01MDeleteDocumentException("No se puede borrar el documento " + doc.getInternalName() + "-" + doc.getLanguage() + " del contenido " + this._content.getName() + " (" + this._content.getTypo().composeMemoCode() + ") ya que est\u00e1 publicado");
            }
            if (!(obj instanceof R01MDataFile) || operation.operation != 6) continue;
            R01MDocument doc = (R01MDocument)objParent;
            R01MDataFile df = (R01MDataFile)obj;
            if (!DEBUG) continue;
            R01FLog.to((String)LOG_TYPE_ID).info("\t...ver si se puede borrar el dataFile " + df.getName() + " en el documento " + doc.getInternalName() + "-" + doc.getLanguage());
        }
    }

    private boolean _validateContentForInsert() throws R01MContentModelException {
        try {
            R01DEjbContentModelLoader loader = new R01DEjbContentModelLoader(this._userCtx);
            boolean existsContent = loader.executeCheckContentExistenceByNameAndTypo(this._content.getName(), this._content.getTypo());
            return !existsContent;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            throw new R01MContentModelException((Exception)((Object)cmEx));
        }
    }

    private boolean _validateContentForDeletion() {
        if (this._content.getDocuments() != null && !this._content.getDocuments().isEmpty()) {
            boolean currDocIsDeleteable = false;
            for (R01MDocument doc : this._content.getDocuments().values()) {
                currDocIsDeleteable = this._validateDocumentForDeletion(doc);
                if (currDocIsDeleteable) continue;
                return false;
            }
        }
        return true;
    }

    private boolean _validateDocumentForInsert(R01MDocument doc) {
        boolean existsSameDoc = false;
        if (this._content.getDocuments() != null) {
            for (R01MDocument currDoc : this._content.getDocuments().values()) {
                if (currDoc.getOid().equals(doc.getOid()) || !currDoc.getInternalName().equals(doc.getInternalName()) || !currDoc.getLanguage().equals(doc.getLanguage())) continue;
                existsSameDoc = true;
                break;
            }
        }
        return !existsSameDoc;
    }

    private boolean _validateDocumentForDeletion(R01MDocument doc) {
        boolean isDeleteable = true;
        List publications = doc.getPublicationInfo();
        HashMap<String, Object[]> publicationsStates = new HashMap<String, Object[]>();
        if (publications != null && !publications.isEmpty()) {
            for (R01MDocumentPublicationTarget publicacion1 : publications) {
                if (publicationsStates.containsKey(publicacion1.getOid())) {
                    Date loadedDate = (Date)((Object[])publicationsStates.get(publicacion1.getOid()))[1];
                    if (!publicacion1.getPublishDate().after(loadedDate)) continue;
                    publicationsStates.put(publicacion1.getOid(), new Object[]{Integer.toString(publicacion1.getState()), publicacion1.getPublishDate()});
                    continue;
                }
                publicationsStates.put(publicacion1.getOid(), new Object[]{Integer.toString(publicacion1.getState()), publicacion1.getPublishDate()});
            }
        }
        Iterator statesIt = publicationsStates.values().iterator();
        while (statesIt.hasNext()) {
            int currentState = Integer.parseInt((String)((Object[])statesIt.next())[0]);
            if (currentState == 0 || currentState == 5) continue;
            isDeleteable = false;
            break;
        }
        return isDeleteable;
    }

    private boolean _validateDataFileForInsert(R01MDocument doc, R01MDataFile df) {
        boolean existsSameDf = false;
        if (doc.getDataFiles() != null) {
            for (R01MDataFile currDf : doc.getDataFiles().values()) {
                if (currDf.getOid().equals(df.getOid()) || !currDf.getName().equals(df.getName())) continue;
                existsSameDf = true;
                break;
            }
        }
        return !existsSameDf;
    }
}

