/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services.helpers;

import com.ejie.r01d.exceptions.R01DContentModelPersistenceException;
import com.ejie.r01d.gestorcontenidos.dbhelppers.R01DContentModelLoaderHelper;
import com.ejie.r01d.gestorcontenidos.dbhelppers.dao.R01DDAOStorageContentsLoader;
import com.ejie.r01d.services.R01DContentModelManager;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MContentLocation;
import com.ejie.r01m.objects.misc.R01MOperationInModelObjectResult;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MDateUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class R01DLocationPublishHelper {
    private transient R01MUserContext _userCtx;
    protected transient R01DContentModelManager _modelMgr;

    public R01DLocationPublishHelper() {
    }

    public R01DLocationPublishHelper(R01MUserContext userCtx, R01DContentModelManager mgr) {
        this._userCtx = userCtx;
        this._modelMgr = mgr;
    }

    public List<R01MOperationInModelObjectResult>[] doPublicateContentDocuments(R01MContent currCont, List<String> documentOids, String publishRepositoryOid, int publicationType) throws R01MSecurityException, R01MContentModelException {
        StringBuffer dbg = new StringBuffer("");
        List[] results = new List[]{new ArrayList(), new ArrayList()};
        dbg.append("-Contenido: " + currCont.getOid() + " ");
        Map documents = currCont.getDocuments();
        if (documentOids != null && !documentOids.isEmpty()) {
            dbg.append(documents.size());
            dbg.append(" documentos\r\n");
            try {
                R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx).publishDocuments(currCont.getOid(), documentOids, publicationType, R01MDateUtils.today(), false);
                dbg.append("[OK]\r\n");
                R01MOperationInModelObjectResult res = new R01MOperationInModelObjectResult(currCont.getOid(), 0, true, null);
                results[0].add(res);
            }
            catch (Exception ex) {
                R01MOperationInModelObjectResult res = new R01MOperationInModelObjectResult(currCont.getOid(), 0, false, "Error al publicar los documentos del contenido: " + ex.getMessage());
                results[1].add(res);
                dbg.append("[ERROR]: ").append(res.composeDebugInfo()).append("\r\n");
            }
        }
        if (results != null && results[0] != null) {
            dbg.append("###################### Contenido " + currCont.getInternalName() + " publicado correctamente.");
        }
        return results;
    }

    public List[] doPublicateLocationContentsDocuments(R01MContentLocation loc, String publishRepositoryOid, int publicationType) throws R01MSecurityException, R01MContentModelException {
        int i;
        if (this._userCtx == null) {
            throw new R01MSecurityException("No se tiene contexto de usuario.");
        }
        if (loc == null || loc.getServerOid() == null || loc.getDataRepositoryOid() == null || loc.getAreaOid() == null || loc.getWorkAreaOid() == null) {
            throw new IllegalArgumentException("La workArea suministrada para la publicaci\u00f3n NO es correcta!!!");
        }
        if (StringUtils.isEmptyString((String)publishRepositoryOid)) {
            throw new IllegalArgumentException("El repositorio de publicaci\u00f3n NO es correcto!!!");
        }
        List[] results = new List[]{new ArrayList(), new ArrayList()};
        StringBuffer dbg = new StringBuffer(92);
        R01DDAOStorageContentsLoader loader = new R01DDAOStorageContentsLoader(this._userCtx);
        String[] contentOids = null;
        try {
            contentOids = loader.executeLoadWorkareaContentsOids(loc);
        }
        catch (R01DContentModelPersistenceException cmEx) {
            throw new R01MContentModelException("NO se pueden cargar los oids de los contenidos de la workArea " + loc.composeMemoCode() + ": " + cmEx.getMessage(), (Exception)((Object)cmEx));
        }
        if (contentOids == null || contentOids.length == 0) {
            dbg.append("NO HAY CONTENIDOS A MIGRAR en la workArea ").append(loc.composeMemoCode());
            return null;
        }
        dbg.append(">>>WorkArea " + loc.composeMemoCode() + contentOids.length + " contenidos a publicar\r\n");
        R01DContentModelLoaderHelper cmLoader = new R01DContentModelLoaderHelper(this._userCtx);
        for (i = 0; i < contentOids.length; ++i) {
            List<R01MOperationInModelObjectResult>[] currContResults;
            block15: {
                String contentOid = contentOids[i];
                currContResults = null;
                try {
                    R01MContent currContent = cmLoader.loadContentFromDBXML(contentOid);
                    if (currContent.getDocuments() == null || currContent.getDocuments().isEmpty()) break block15;
                    currContResults = this.doPublicateContentDocuments(currContent, new ArrayList<String>(currContent.getDocuments().keySet()), publishRepositoryOid, publicationType);
                }
                catch (R01DContentModelPersistenceException ex) {
                    continue;
                }
            }
            if (currContResults != null && currContResults[0] != null) {
                results[0].addAll(currContResults[0]);
            }
            if (currContResults == null || currContResults[1] == null) continue;
            results[1].addAll(currContResults[1]);
        }
        dbg.append("\r\n\r\n[[[[[[[Fin del proceso de publicaci\u00f3n]]]]]]");
        if (results != null) {
            dbg.append("###################### Contenidos publicados correctamente (" + results[0].size() + "):");
            if (results[0] != null) {
                for (i = 0; i < results[0].size(); ++i) {
                    dbg.append(((R01MOperationInModelObjectResult)results[0].get(i)).composeDebugInfo() + "\r\n");
                }
            }
            dbg.append("###################### Contenidos publicados con error (" + results[1].size() + "):");
            if (results[1] != null) {
                for (i = 0; i < results[1].size(); ++i) {
                    dbg.append(((R01MOperationInModelObjectResult)results[1].get(i)).composeDebugInfo() + "\r\n");
                }
            }
        }
        return results;
    }
}

