/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services.helpers;

import com.ejie.r01d.exceptions.R01DContentModelPersistenceException;
import com.ejie.r01d.gestorcontenidos.dbhelppers.dao.R01DDAOHistoryManager;
import com.ejie.r01d.services.R01DRawDataManager;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.contentmodel.R01MBaseDocumentInterface;
import com.ejie.r01m.objects.contentmodel.R01MContentHistory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MDateUtils;
import com.ejie.r01p.utils.R01PVariables;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class R01DHistoryHelper {
    private static final String HISTORY_BASE_PATH = XMLProperties.getProperty((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"history/basePath", (String)"r01history");
    private static final String HISTORY_BASE_CONFIG = XMLProperties.getProperty((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"history/baseConfig", (String)"interwoven");
    private static final String HISTORY_DOCUMENT_CHANGE_FILE_NAME = XMLProperties.getProperty((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"history/document/changesFileName", (String)"r01Doc_Changes_$internal_name$_$lang$.txt");
    private static final String HISTORY_DOCUMENT_PUBLISH_FILE_NAME = XMLProperties.getProperty((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"history/document/publishFileName", (String)"r01Doc_Pubs_$internal_name$_$lang$.txt");
    private static final String HISTORY_CONTENT_CHANGE_FILE_NAME = XMLProperties.getProperty((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"history/content/changesFileName", (String)"r01Cont_Changes.txt");
    private static final int NUM_MAX_REG = Integer.parseInt(XMLProperties.getProperty((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"history/configuration/numMaxReg", (String)"1000").toString());
    private static final String PATH_SEP = "/";
    private R01MUserContext _userCtx;

    public R01DHistoryHelper() {
    }

    public R01DHistoryHelper(R01MUserContext userCtx) {
        this();
        this._userCtx = userCtx;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doInsertHistoryInBD(R01MContentHistory historyReg) throws R01MContentModelException {
        List historyList;
        if (historyReg == null) {
            return;
        }
        R01DDAOHistoryManager historyDAO = new R01DDAOHistoryManager(this._userCtx);
        List oldHistoryList = null;
        try {
            oldHistoryList = historyDAO.executeLoadHistory(historyReg.getContentOid(), null);
        }
        catch (R01DContentModelPersistenceException ex) {
            ex.printStackTrace(System.out);
        }
        if (oldHistoryList != null && !oldHistoryList.isEmpty()) {
            String fileWorkareaPath = historyReg.getFileWorkAreaPath().substring(0, historyReg.getFileWorkAreaPath().lastIndexOf(PATH_SEP) + 1) + HISTORY_CONTENT_CHANGE_FILE_NAME;
            for (R01MContentHistory historyValue : oldHistoryList) {
                try {
                    historyDAO.executeUpdate(historyValue.getOid(), historyReg.getWorkAreaPath(), fileWorkareaPath, String.valueOf(1), R01MConstants.CLUSTER);
                }
                catch (R01DContentModelPersistenceException ex) {
                    ex.printStackTrace(System.out);
                }
            }
        }
        if (historyReg.getAction() == 14) {
            historyReg.setState(new Integer(3));
            try {
                historyList = historyDAO.executeLoadHistory(historyReg.getContentOid());
                if (historyList != null && !historyList.isEmpty()) {
                    for (R01MContentHistory historyValue : historyList) {
                        try {
                            historyDAO.executeDelete(historyValue.getOid());
                        }
                        catch (R01DContentModelPersistenceException ex) {
                            throw new R01MContentModelException((Exception)((Object)ex));
                        }
                    }
                }
            }
            catch (R01DContentModelPersistenceException ex1) {
                ex1.printStackTrace(System.out);
            }
        } else {
            historyReg.setState(new Integer(2));
            try {
                historyList = historyDAO.executeLoadHistory(historyReg.getContentOid(), historyReg.getObjectOid(), historyReg.getAction().intValue());
                if (historyList != null && !historyList.isEmpty()) {
                    for (R01MContentHistory historyValue : historyList) {
                        if (historyValue.getState() == 2) {
                            try {
                                historyDAO.executeUpdateState(historyValue.getOid(), String.valueOf(1));
                            }
                            catch (R01DContentModelPersistenceException ex) {
                                ex.printStackTrace(System.out);
                            }
                            continue;
                        }
                        if (historyValue.getState() != 0 && historyValue.getState() != 3) continue;
                        try {
                            historyDAO.executeDelete(historyValue.getOid());
                        }
                        catch (R01DContentModelPersistenceException ex) {
                            ex.printStackTrace(System.out);
                        }
                    }
                }
            }
            catch (R01DContentModelPersistenceException ex1) {
                throw new R01MContentModelException((Exception)((Object)ex1));
            }
        }
        try {
            historyDAO.executeInsert(historyReg, R01MConstants.CLUSTER);
            return;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            throw new R01MContentModelException((Exception)((Object)cmEx));
        }
    }

    public void doInsertHistoryInFile() throws R01MContentModelException {
        int count;
        List saveInFile = null;
        R01DDAOHistoryManager historyDAO = new R01DDAOHistoryManager(this._userCtx);
        try {
            count = historyDAO.executeLoadSaveInFileCount(R01MConstants.CLUSTER);
        }
        catch (R01DContentModelPersistenceException ex) {
            throw new R01MContentModelException((Exception)((Object)ex));
        }
        ArrayList<String> listToDelete = new ArrayList<String>();
        ArrayList<String> listToUpdate = new ArrayList<String>();
        int numMaxReg = NUM_MAX_REG;
        int min = 1;
        int max = numMaxReg;
        int numSql = count / numMaxReg;
        if (count > numMaxReg * numSql) {
            ++numSql;
        }
        for (int i = 0; i < numSql; ++i) {
            try {
                saveInFile = historyDAO.executeLoadSaveInFile(R01MConstants.CLUSTER, min, max);
            }
            catch (R01DContentModelPersistenceException ex) {
                throw new R01MContentModelException((Exception)((Object)ex));
            }
            if (saveInFile != null && !saveInFile.isEmpty()) {
                String workareaPath = "";
                String fileWorkareaRelativePath = "";
                boolean writeInFile = false;
                ArrayList<R01MContentHistory> historyList = null;
                ArrayList listToFile = new ArrayList();
                for (R01MContentHistory r01MContentHistory : saveInFile) {
                    if (HISTORY_BASE_CONFIG.equals("fileSystem") && r01MContentHistory.getWorkAreaPath().startsWith("//iwmnt") || HISTORY_BASE_CONFIG.equals("interwoven") && r01MContentHistory.getWorkAreaPath().startsWith("d:")) continue;
                    if (historyList == null) {
                        historyList = new ArrayList<R01MContentHistory>();
                    }
                    if (StringUtils.isEmptyString((String)workareaPath)) {
                        workareaPath = r01MContentHistory.getWorkAreaPath();
                    }
                    if (StringUtils.isEmptyString((String)fileWorkareaRelativePath)) {
                        fileWorkareaRelativePath = r01MContentHistory.getFileWorkAreaPath();
                    }
                    if (r01MContentHistory.getWorkAreaPath().equals(workareaPath) && r01MContentHistory.getFileWorkAreaPath().equals(fileWorkareaRelativePath)) {
                        historyList.add(r01MContentHistory);
                        writeInFile = false;
                    } else {
                        writeInFile = true;
                    }
                    if (r01MContentHistory.getState() == 1) {
                        listToDelete.add(r01MContentHistory.getOid());
                    } else {
                        listToUpdate.add(r01MContentHistory.getOid());
                    }
                    if (writeInFile) {
                        listToFile.add(historyList);
                        historyList = new ArrayList();
                        historyList.add(r01MContentHistory);
                    }
                    workareaPath = r01MContentHistory.getWorkAreaPath();
                    fileWorkareaRelativePath = r01MContentHistory.getFileWorkAreaPath();
                }
                listToFile.add(historyList);
                if (listToFile != null && !listToFile.isEmpty()) {
                    for (List list : listToFile) {
                        if (list == null || list.isEmpty()) continue;
                        StringBuffer data = this.doGenerateHistoryFileData(list);
                        try {
                            if (StringUtils.isEmptyStringBuffer((StringBuffer)data)) continue;
                            R01MContentHistory history = (R01MContentHistory)list.get(0);
                            this.updateFileHistory(this._userCtx, history.getWorkAreaPath(), history.getFileWorkAreaPath(), data);
                        }
                        catch (Exception ex1) {
                            ex1.printStackTrace();
                        }
                        catch (Throwable th) {
                            th.printStackTrace();
                        }
                    }
                }
            }
            min = max + 1;
            max += numMaxReg;
        }
        if (listToDelete != null && !listToDelete.isEmpty()) {
            for (String regOid : listToDelete) {
                try {
                    historyDAO.executeDelete(regOid);
                }
                catch (R01DContentModelPersistenceException ex) {
                    throw new R01MContentModelException((Exception)((Object)ex));
                }
            }
        }
        if (listToUpdate != null && !listToUpdate.isEmpty()) {
            for (String regOid : listToUpdate) {
                try {
                    historyDAO.executeUpdateState(regOid, String.valueOf(3));
                }
                catch (R01DContentModelPersistenceException ex) {
                    throw new R01MContentModelException((Exception)((Object)ex));
                }
            }
        }
    }

    public StringBuffer doGenerateHistoryFileData(List historyList) {
        StringBuffer data = new StringBuffer();
        char separadorBD = '|';
        char separador = ' ';
        if (historyList != null && !historyList.isEmpty()) {
            for (R01MContentHistory history : historyList) {
                if (history.getAction() == 14) {
                    return null;
                }
                String name = history.getName();
                data.append(R01MDateUtils.dateTimeToStr((Date)history.getActionDate(), (String)"es"));
                data.append(separador);
                data.append(StringUtils.fillRight((String)history.getAuthor(), (int)20, (String)" "));
                data.append(separador);
                data.append(StringUtils.fillRight((String)R01MConstants.OBJECT_DESCS[history.getType()], (int)10, (String)" "));
                data.append(separador);
                data.append(StringUtils.fillRight((String)name, (int)30, (String)" "));
                data.append(separador);
                data.append(history.getActionName());
                data.append(separadorBD);
                data.append(history.getOid());
                data.append(separadorBD);
                data.append(history.getContentOid());
                data.append(separadorBD);
                data.append(history.getAuthor());
                data.append(separadorBD);
                data.append(history.getComment());
                data.append(separadorBD);
                data.append(R01MDateUtils.dateTimeToStr((Date)history.getActionDate(), (String)"es"));
                data.append(separadorBD);
                data.append(history.getType());
                data.append(separadorBD);
                data.append(history.getName());
                data.append(separadorBD);
                data.append(history.getAction());
                data.append(separadorBD);
                data.append(history.getObjectOid());
                data.append("\n");
            }
        }
        return data;
    }

    public void updateFileHistory(R01MUserContext userCtx, String workAreaPath, String fileWorkareaPath, StringBuffer contentData) throws R01MDataStoreException {
        R01DRawDataManager dataStore = new R01DRawDataManager();
        try {
            dataStore.doUpdateFile(userCtx, workAreaPath, fileWorkareaPath, StringUtils.getInputStream((StringBuffer)contentData), null, true, true);
        }
        catch (R01MSecurityException ex) {
            throw new R01MDataStoreException((Exception)((Object)ex));
        }
        catch (UnsupportedEncodingException ex) {
            throw new R01MDataStoreException((Exception)ex);
        }
    }

    public String getFileName(Object object, int historyActionType) {
        StringBuffer contentHistoryFilePath = new StringBuffer();
        contentHistoryFilePath.append(PATH_SEP + HISTORY_BASE_PATH);
        R01MBaseDocumentInterface document = null;
        if (object instanceof R01MBaseDocumentInterface) {
            document = (R01MBaseDocumentInterface)object;
            Properties vars = new Properties();
            vars.put("internal_name", document.getInternalName());
            vars.put("lang", document.getLanguage());
            String changeFileName = R01PVariables.customize((String)HISTORY_DOCUMENT_CHANGE_FILE_NAME, (Properties)vars);
            String publishFileName = R01PVariables.customize((String)HISTORY_DOCUMENT_PUBLISH_FILE_NAME, (Properties)vars);
            switch (historyActionType) {
                case 10: 
                case 20: {
                    contentHistoryFilePath.append(PATH_SEP);
                    contentHistoryFilePath.append(publishFileName);
                    break;
                }
                default: {
                    contentHistoryFilePath.append(PATH_SEP);
                    contentHistoryFilePath.append(changeFileName);
                    break;
                }
            }
        } else {
            contentHistoryFilePath.append(PATH_SEP + HISTORY_CONTENT_CHANGE_FILE_NAME);
        }
        return contentHistoryFilePath.toString();
    }
}

