/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services.helpers;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.objects.listelements.ListElement;
import com.ejie.r01f.objects.listelements.ListElementCollection;
import com.ejie.r01f.objects.tree.TreeImpl;
import com.ejie.r01f.objects.tree.TreeNode;
import com.ejie.r01f.sql.BDConnectionHelpper;
import com.ejie.r01m.objects.gip.R01MGipOrgChartElement;
import com.ejie.r01m.utils.R01MConstants;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.ejb.EJBException;

public class R01DGipServicesHelper {
    private static final String ES_COD = "_cast";
    private String _lang = "_cast";

    public TreeImpl getArbolDepartamento(String codDpto) throws IllegalArgumentException {
        Connection conx = null;
        Statement qry = null;
        ResultSet rs = null;
        Hashtable<String, TreeNode> raices = new Hashtable<String, TreeNode>();
        TreeNode nodo = null;
        ListElement datos = null;
        TreeImpl arbol = null;
        String raizEstructura = null;
        String descDpto = null;
        String sql = null;
        if (codDpto == null) {
            throw new IllegalArgumentException("getArbolEstructura: El c\u00f3digo del departamento no puede ser null");
        }
        try {
            sql = "SELECT descr" + this._lang + " " + "FROM R01L.R01LLAV00 " + "WHERE codorgno='" + codDpto + "'";
            conx = BDConnectionHelpper.getConnection((String)R01MConstants.USERINTERFACE_APPCODE, (String)"gipConnection");
            qry = conx.prepareStatement(sql);
            rs = qry.executeQuery();
            if (!rs.next()) {
                TreeImpl treeImpl = null;
                return treeImpl;
            }
            descDpto = rs.getString("descr" + this._lang);
            sql = "SELECT cenorg, codestr_us, descr" + this._lang + " " + "FROM R01L.R01LLBV00 " + "WHERE codorgno='" + codDpto + "' " + "ORDER BY codestr_us";
            qry = conx.prepareStatement(sql);
            rs = qry.executeQuery();
            if (!rs.next()) {
                TreeImpl treeImpl = null;
                return treeImpl;
            }
            raizEstructura = rs.getString("codestr_us");
            datos = new ListElement(raizEstructura, (Object)descDpto);
            arbol = new TreeImpl((Object)datos);
            raices.put(raizEstructura, arbol.getRootNode());
            TreeNode nodoPadre = null;
            String codEstructura = null;
            String raiz = null;
            while (rs.next()) {
                codEstructura = rs.getString("codestr_us");
                codEstructura = codEstructura + "00000000";
                codEstructura = codEstructura.substring(0, 8);
                try {
                    datos = new ListElement(rs.getString("cenorg"), (Object)rs.getString("descr" + this._lang));
                    nodo = arbol.createNode((Object)datos);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace(System.out);
                }
                if (!raices.containsKey(raiz = this._getRaizEstructura(codEstructura))) continue;
                nodoPadre = (TreeNode)raices.get(raiz);
                nodoPadre.appendChild(nodo);
                raices.put(codEstructura, nodo);
            }
            TreeImpl treeImpl = arbol;
            return treeImpl;
        }
        catch (Exception e) {
            throw new EJBException("getArbolEstructura(String): " + e.getMessage());
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                qry.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                conx.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public TreeImpl getArbolDepartamento(String codDpto, int nivel) throws IllegalArgumentException {
        Connection conx = null;
        Statement qry = null;
        ResultSet rs = null;
        Hashtable<String, TreeNode> raices = new Hashtable<String, TreeNode>();
        TreeNode nodo = null;
        ListElement datos = null;
        TreeImpl arbol = null;
        String raizEstructura = null;
        String descDpto = null;
        String sql = null;
        if (codDpto == null) {
            throw new IllegalArgumentException("getArbolEstructura: El c\u00f3digo del departamento no puede ser null");
        }
        try {
            sql = "SELECT descr" + this._lang + " " + "FROM R01L.R01LLAV00 " + "WHERE codorgno='" + codDpto + "'";
            conx = BDConnectionHelpper.getConnection((String)R01MConstants.USERINTERFACE_APPCODE, (String)"gipConnection");
            qry = conx.prepareStatement(sql);
            rs = qry.executeQuery();
            if (!rs.next()) {
                TreeImpl treeImpl = null;
                return treeImpl;
            }
            descDpto = rs.getString("descr" + this._lang);
            rs.close();
            sql = "SELECT cenorg, codestr_us, descr" + this._lang + " " + "FROM R01L.R01LLBV00 " + "WHERE codorgno='" + codDpto + "' " + "ORDER BY codestr_us";
            qry = conx.prepareStatement(sql);
            rs = qry.executeQuery();
            if (!rs.next()) {
                TreeImpl e = null;
                return e;
            }
            raizEstructura = rs.getString("codestr_us");
            int nivelRaiz = this._getLevelFromCode(raizEstructura);
            datos = new ListElement(raizEstructura, (Object)descDpto);
            arbol = new TreeImpl((Object)datos, nivelRaiz);
            raices.put(raizEstructura, arbol.getRootNode());
            TreeNode nodoPadre = null;
            String codEstructura = null;
            String raiz = null;
            int newNivel = 0;
            while (rs.next()) {
                codEstructura = rs.getString("codestr_us");
                codEstructura = codEstructura + "00000000";
                newNivel = this._getLevelFromCode(codEstructura = codEstructura.substring(0, 8));
                if (newNivel > nivel) continue;
                try {
                    datos = new ListElement(rs.getString("cenorg"), (Object)rs.getString("descr" + this._lang));
                    nodo = arbol.createNode((Object)datos);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace(System.out);
                }
                if (!raices.containsKey(raiz = this._getRaizEstructura(codEstructura))) continue;
                nodoPadre = (TreeNode)raices.get(raiz);
                nodoPadre.appendChild(nodo, newNivel);
                raices.put(codEstructura, nodo);
            }
            TreeImpl treeImpl = arbol;
            return treeImpl;
        }
        catch (Exception e) {
            throw new EJBException("getArbolDepartamento: " + e.getMessage());
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                qry.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                conx.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public TreeImpl getArbolEstructura() {
        Connection conx = null;
        Statement qry = null;
        ResultSet rs = null;
        Hashtable<String, TreeNode> raices = new Hashtable<String, TreeNode>();
        TreeNode nodo = null;
        ListElement datos = null;
        TreeImpl arbol = null;
        try {
            datos = new ListElement("0", (Object)"Arbol Gobierno Vasco");
            arbol = new TreeImpl((Object)datos);
            String sql = "SELECT cenorg, codestr_us, descr" + this._lang + " " + "FROM R01L.R01LLBV00 " + "ORDER BY codestr_us";
            conx = BDConnectionHelpper.getConnection((String)R01MConstants.USERINTERFACE_APPCODE, (String)"gipConnection");
            qry = conx.prepareStatement(sql);
            rs = qry.executeQuery();
            TreeNode nodoPadre = null;
            String codEstructura = null;
            String raiz = null;
            if (rs.next()) {
                do {
                    codEstructura = rs.getString("codestr_us");
                    codEstructura = codEstructura + "00000000";
                    codEstructura = codEstructura.substring(0, 8);
                    try {
                        datos = new ListElement(rs.getString("cenorg"), (Object)rs.getString("descr" + this._lang));
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                    nodo = arbol.createNode((Object)datos);
                    raiz = this._getRaizEstructura(codEstructura);
                    if (raices.containsKey(raiz)) {
                        nodoPadre = (TreeNode)raices.get(raiz);
                        nodoPadre.appendChild(nodo);
                        raices.put(codEstructura, nodo);
                        continue;
                    }
                    nodoPadre = arbol.getRootNode();
                    nodoPadre.appendChild(nodo);
                    raices.put(raiz, nodo);
                } while (rs.next());
                TreeImpl treeImpl = arbol;
                return treeImpl;
            }
            TreeImpl treeImpl = null;
            return treeImpl;
        }
        catch (Exception e) {
            throw new EJBException("getArbolEstructura(): " + e.getMessage());
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                qry.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                conx.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public TreeImpl getArbolEstructura(String codNodo) throws IllegalArgumentException {
        Connection conx = null;
        Statement qry = null;
        ResultSet rs = null;
        Hashtable<String, TreeNode> raices = new Hashtable<String, TreeNode>();
        TreeNode nodo = null;
        ListElement datos = null;
        TreeImpl arbol = null;
        String raizEstructura = null;
        if (codNodo == null) {
            throw new IllegalArgumentException("getArbolEstructura: El c\u00f3digo del nodo no puede ser null");
        }
        try {
            raizEstructura = this.getCodigoEstructura(codNodo);
            if (raizEstructura == null) {
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        if (raizEstructura != null) {
            while (raizEstructura.charAt(raizEstructura.length() - 1) == '0' && raizEstructura.length() > 1) {
                raizEstructura = raizEstructura.substring(0, raizEstructura.length() - 1);
            }
        }
        try {
            String sql = "SELECT cenorg, codestr_us, descr" + this._lang + " " + "FROM R01L.R01LLBV00 " + "WHERE codestr_us LIKE '" + raizEstructura + "%' " + "ORDER BY codestr_us";
            conx = BDConnectionHelpper.getConnection((String)R01MConstants.USERINTERFACE_APPCODE, (String)"gipConnection");
            qry = conx.prepareStatement(sql);
            rs = qry.executeQuery();
            if (!rs.next()) {
                TreeImpl treeImpl = null;
                return treeImpl;
            }
            R01FLog.to((String)"r01l.gipEJB").info("--Recuperacion el codigo CODESTR_US en GETARBOLESTRUCTURA(,)" + rs.getString("codestr_us"));
            raizEstructura = rs.getString("codestr_us");
            datos = new ListElement(raizEstructura, (Object)rs.getString("descr" + this._lang));
            arbol = new TreeImpl((Object)datos);
            raices.put(raizEstructura, arbol.getRootNode());
            TreeNode nodoPadre = null;
            String codEstructura = null;
            String raiz = null;
            while (rs.next()) {
                codEstructura = rs.getString("codestr_us");
                codEstructura = codEstructura + "00000000";
                codEstructura = codEstructura.substring(0, 8);
                try {
                    datos = new ListElement(rs.getString("cenorg"), (Object)rs.getString("descr" + this._lang));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace(System.out);
                }
                nodo = arbol.createNode((Object)datos);
                raiz = this._getRaizEstructura(codEstructura);
                if (!raices.containsKey(raiz)) continue;
                nodoPadre = (TreeNode)raices.get(raiz);
                nodoPadre.appendChild(nodo);
                raices.put(codEstructura, nodo);
            }
            TreeImpl treeImpl = arbol;
            return treeImpl;
        }
        catch (Exception e) {
            throw new EJBException("getArbolEstructura(String): " + e.getMessage());
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                qry.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                conx.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public TreeImpl getArbolEstructura(String codNodo, int nivel) throws IllegalArgumentException {
        Connection conx = null;
        Statement qry = null;
        ResultSet rs = null;
        Hashtable<String, TreeNode> raices = new Hashtable<String, TreeNode>();
        TreeNode nodo = null;
        ListElement datos = null;
        TreeImpl arbol = null;
        String raizEstructura = null;
        if (codNodo == null) {
            throw new IllegalArgumentException("getArbolEstructura: El c\u00f3digo del nodo no puede ser null");
        }
        try {
            raizEstructura = this.getCodigoEstructura(codNodo);
            if (raizEstructura == null) {
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        if (raizEstructura != null) {
            while (raizEstructura.charAt(raizEstructura.length() - 1) == '0' && raizEstructura.length() > 1) {
                raizEstructura = raizEstructura.substring(0, raizEstructura.length() - 1);
            }
        }
        try {
            String sql = "SELECT cenorg, codestr_us, descr" + this._lang + " " + "FROM R01L.R01LLBV00 " + "WHERE codestr_us LIKE '" + raizEstructura + "%' " + "ORDER BY codestr_us";
            conx = BDConnectionHelpper.getConnection((String)R01MConstants.USERINTERFACE_APPCODE, (String)"gipConnection");
            qry = conx.prepareStatement(sql);
            rs = qry.executeQuery();
            if (!rs.next()) {
                TreeImpl treeImpl = null;
                return treeImpl;
            }
            R01FLog.to((String)"r01l.gipEJB").info("En la recuperaci\u00f3n el c\u00f3digo CODESTR_US en GETARBOLESTRUCTURA(,)" + rs.getString("codestr_us"));
            raizEstructura = rs.getString("codestr_us");
            datos = new ListElement(raizEstructura, (Object)rs.getString("descr" + this._lang));
            arbol = new TreeImpl((Object)datos);
            raices.put(raizEstructura, arbol.getRootNode());
            TreeNode nodoPadre = null;
            String codEstructura = null;
            String raiz = null;
            while (rs.next()) {
                codEstructura = rs.getString("codestr_us");
                codEstructura = codEstructura + "00000000";
                codEstructura = codEstructura.substring(0, 8);
                try {
                    datos = new ListElement(rs.getString("cenorg"), (Object)rs.getString("descr" + this._lang));
                    nodo = arbol.createNode((Object)datos);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                if (!raices.containsKey(raiz = this._getRaizEstructura(codEstructura)) || (nodoPadre = (TreeNode)raices.get(raiz)).getNodeLevel() == nivel) continue;
                nodoPadre.appendChild(nodo);
                raices.put(codEstructura, nodo);
            }
            TreeImpl treeImpl = arbol;
            return treeImpl;
        }
        catch (Exception e) {
            throw new EJBException("getArbolEstructura(String,int): " + e.getMessage());
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                qry.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                conx.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public String getCodigoEstructura(String codNodo) throws IllegalArgumentException {
        Connection conx = null;
        Statement qry = null;
        ResultSet rs = null;
        String resultado = null;
        try {
            String sql = "SELECT codestr_us FROM R01L.R01LLBV00 WHERE cenorg='" + codNodo + "'";
            conx = BDConnectionHelpper.getConnection((String)R01MConstants.USERINTERFACE_APPCODE, (String)"gipConnection");
            qry = conx.prepareStatement(sql);
            rs = qry.executeQuery();
            if (rs.next()) {
                resultado = rs.getString("codestr_us");
            }
            String string = resultado;
            return string;
        }
        catch (Exception e) {
            throw new EJBException("getCodigoEstructura(String codNodo): " + e.getMessage());
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                qry.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                conx.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public String getDepartamentoFromNodoEstructura(String codNodo) throws IllegalArgumentException {
        Connection conx = null;
        Statement qry = null;
        ResultSet rs = null;
        if (codNodo == null) {
            throw new IllegalArgumentException("getDepartamentoFromNodoEstructura: El c\u00f3digo del nodo no puede ser null");
        }
        try {
            String sql = "SELECT CODORGNO FROM R01L.R01LLBV00 WHERE CENORG = '" + codNodo + "'";
            conx = BDConnectionHelpper.getConnection((String)R01MConstants.USERINTERFACE_APPCODE, (String)"gipConnection");
            qry = conx.prepareStatement(sql);
            rs = qry.executeQuery();
            if (rs.next()) {
                R01FLog.to((String)"r01l.gipEJB").info("En el GIP el nombre del departamento es " + rs.getString("CODORGNO"));
                String string = rs.getString("CODORGNO");
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            throw new EJBException(" getDepartamentoFromNodoEstructura(String codNodo): " + e.getMessage());
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                qry.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                conx.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public String getNodoEstructuraFromDepartamento(String codDpto) throws IllegalArgumentException {
        Connection conx = null;
        Statement qry = null;
        ResultSet rs = null;
        if (codDpto == null) {
            throw new IllegalArgumentException("getNodoEstructuraFromDepartamento: El c\u00f3digo del departamento no puede ser null");
        }
        try {
            String sql = "SELECT CENORG,CODESTR_US FROM R01L.R01LLBV00 WHERE CODORGNO = '" + codDpto + "' " + "ORDER BY CODESTR_US";
            conx = BDConnectionHelpper.getConnection((String)R01MConstants.USERINTERFACE_APPCODE, (String)"gipConnection");
            qry = conx.prepareStatement(sql);
            qry.setMaxRows(1);
            rs = qry.executeQuery();
            if (rs.next()) {
                String string = rs.getString("CENORG");
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            throw new EJBException("getNodoEstructuraFromDepartamento: " + e.getMessage());
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                qry.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                conx.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public ListElementCollection getNombreDepartamentos() {
        Connection conx = null;
        Statement qry = null;
        ResultSet rs = null;
        ListElementCollection departamentos = null;
        ListElement elemento = null;
        try {
            String sql = "SELECT codorgno, descr" + this._lang + " " + "FROM R01L.R01LLAV00 " + "ORDER BY DPTORGUS";
            conx = BDConnectionHelpper.getConnection((String)R01MConstants.USERINTERFACE_APPCODE, (String)"gipConnection");
            qry = conx.prepareStatement(sql);
            rs = qry.executeQuery();
            if (rs.next()) {
                departamentos = new ListElementCollection();
                do {
                    elemento = new ListElement(rs.getString("codorgno"), (Object)rs.getString("descr" + this._lang));
                    departamentos.add((Object)elemento);
                } while (rs.next());
            }
            ListElementCollection listElementCollection = departamentos;
            return listElementCollection;
        }
        catch (Exception e) {
            throw new EJBException("getNombreDepartamentos: " + e.getMessage());
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                qry.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                conx.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public TreeImpl getOrganigrama(String codDpto, int nivel) throws SQLException, IllegalArgumentException {
        Connection conx = null;
        Statement qry = null;
        ResultSet rs = null;
        String sql = null;
        Hashtable<String, TreeNode> raices = new Hashtable<String, TreeNode>();
        TreeNode nodo = null;
        R01MGipOrgChartElement datos = null;
        TreeImpl arbol = null;
        String raizEstructura = null;
        String descDpto = null;
        String tipoOrg = null;
        if (codDpto == null) {
            throw new IllegalArgumentException("getOrganigrama: El c\u00f3digo del departamento no puede ser null");
        }
        try {
            sql = "SELECT descr" + this._lang + ", TIPO_NIV " + "FROM R01L.R01LLAV00 " + "WHERE codorgno='" + codDpto + "'";
            conx = BDConnectionHelpper.getConnection((String)R01MConstants.USERINTERFACE_APPCODE, (String)"gipConnection");
            qry = conx.prepareStatement(sql);
            rs = qry.executeQuery();
            if (!rs.next()) {
                TreeImpl treeImpl = null;
                return treeImpl;
            }
            descDpto = rs.getString("descr" + this._lang);
            tipoOrg = rs.getString("TIPO_NIV");
            sql = "SELECT cenorg, codestr_us, InitCap(responsable) AS responsable, descr" + this._lang + " " + "FROM R01L.R01LLBV00 " + "WHERE codorgno='" + codDpto + "' " + "ORDER BY codestr_us";
            qry = conx.prepareStatement(sql);
            rs = qry.executeQuery();
            if (!rs.next()) {
                TreeImpl sqlEx = null;
                return sqlEx;
            }
            raizEstructura = rs.getString("codestr_us");
            int nivelRaiz = this._getLevelFromCode(raizEstructura);
            datos = new R01MGipOrgChartElement(rs.getString("cenorg"), descDpto, this._toLowerCaseParticulas(rs.getString("responsable")), tipoOrg);
            arbol = new TreeImpl((Object)datos, nivelRaiz);
            raices.put(raizEstructura, arbol.getRootNode());
            TreeNode nodoPadre = null;
            String codEstructura = null;
            String raiz = null;
            int newNivel = 0;
            while (rs.next()) {
                codEstructura = rs.getString("codestr_us");
                newNivel = this._getLevelFromCode(codEstructura);
                codEstructura = codEstructura + "00000000";
                codEstructura = codEstructura.substring(0, 8);
                try {
                    datos = new R01MGipOrgChartElement(rs.getString("cenorg"), rs.getString("descr" + this._lang), this._toLowerCaseParticulas(rs.getString("responsable")));
                    nodo = arbol.createNode((Object)datos);
                }
                catch (IllegalArgumentException illArgEx) {
                    illArgEx.printStackTrace(System.out);
                }
                if (!raices.containsKey(raiz = this._getRaizEstructura(codEstructura))) continue;
                nodoPadre = (TreeNode)raices.get(raiz);
                if (newNivel > nivel) continue;
                nodoPadre.appendChild(nodo, newNivel);
                raices.put(codEstructura, nodo);
            }
            TreeImpl treeImpl = arbol;
            return treeImpl;
        }
        catch (SQLException sqlEx) {
            throw new SQLException("getOrganigrama(String,int): " + sqlEx.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlEx) {
                sqlEx.printStackTrace(System.out);
            }
            try {
                if (qry != null) {
                    qry.close();
                }
            }
            catch (SQLException sqlEx) {
                sqlEx.printStackTrace(System.out);
            }
            try {
                if (conx != null) {
                    conx.close();
                }
            }
            catch (SQLException sqlEx) {
                sqlEx.printStackTrace(System.out);
            }
        }
    }

    private int _getLevelFromCode(String codigo) {
        int nivel = 0;
        try {
            while (codigo.charAt(codigo.length() - 1) == '0' && codigo.length() > 1) {
                codigo = codigo.substring(0, codigo.length() - 1);
                ++nivel;
            }
            if (codigo.charAt(codigo.length() - 1) != '0') {
                if (nivel == 7) {
                    nivel = 1;
                } else if ((nivel -= 7) < 0) {
                    nivel *= -1;
                }
            } else {
                nivel = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return nivel;
    }

    private String _getRaizEstructura(String codEstructura) {
        String raiz = codEstructura;
        while (raiz.charAt(raiz.length() - 1) == '0' && raiz.length() > 1) {
            raiz = raiz.substring(0, raiz.length() - 1);
        }
        if (raiz.length() > 1) {
            raiz = raiz.substring(0, raiz.length() - 1);
            while (raiz.charAt(raiz.length() - 1) == '0' && raiz.length() > 1) {
                raiz = raiz.substring(0, raiz.length() - 1);
            }
        }
        raiz = raiz + "00000000";
        raiz = raiz.substring(0, 8);
        return raiz;
    }

    private String _toLowerCaseParticula(String cadena, String particula) {
        StringBuffer strBufCadena = new StringBuffer(cadena);
        int posicion = cadena.indexOf(particula);
        while (posicion > -1) {
            strBufCadena.replace(posicion, posicion + particula.length(), particula.toLowerCase());
            posicion = cadena.indexOf(particula, posicion + 1);
        }
        return strBufCadena.toString();
    }

    private String _toLowerCaseParticulas(String cadena) {
        if (cadena.indexOf(" De ") > -1) {
            cadena = this._toLowerCaseParticula(cadena, " De ");
        }
        if (cadena.indexOf(" Del ") > -1) {
            cadena = this._toLowerCaseParticula(cadena, " Del ");
        }
        if (cadena.indexOf(" La ") > -1) {
            cadena = this._toLowerCaseParticula(cadena, " La ");
        }
        return cadena;
    }
}

