/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services.helpers;

import com.ejie.r01m.config.objects.storage.R01MWorkArea;
import com.ejie.r01m.config.objects.typology.R01MAllowedTypo;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MContentLocation;
import com.ejie.r01m.objects.contentmodel.R01MContentTypologyInfo;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.contentmodel.R01MDocumentRevisionState;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MContentModelAPI;
import java.util.List;

public class R01DDocumentStateHelper {
    private transient R01MUserContext _userCtx;

    public R01DDocumentStateHelper() {
    }

    public R01DDocumentStateHelper(R01MUserContext userCtx) {
        this();
        this._userCtx = userCtx;
    }

    public R01MDocumentRevisionState doRequestDocumentRevision(R01MContent cont, R01MDocument doc) throws R01MContentModelException {
        try {
            R01MContentLocation contentStorage = cont.getStoreLocation();
            R01MContentTypologyInfo contentTypo = cont.getTypo();
            R01MWorkArea workareaCfg = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(contentStorage.getServerOid(), contentStorage.getDataRepositoryOid(), contentStorage.getAreaOid(), contentStorage.getWorkAreaOid());
            List allowedTypos = workareaCfg.getTypologyConfig().getAllowedTypos();
            int pendingRevisions = 0;
            for (int i = 0; i < allowedTypos.size(); ++i) {
                R01MAllowedTypo allowedTypo = (R01MAllowedTypo)allowedTypos.get(i);
                if (!allowedTypo.getClusterOid().equals(contentTypo.getClusterOid()) || !allowedTypo.getFamilyOid().equals(contentTypo.getFamilyOid()) || !allowedTypo.getTypeOid().equals(contentTypo.getTypeOid())) continue;
                pendingRevisions = allowedTypo.getNumberOfApprovalsNeeded();
                break;
            }
            int newState = -pendingRevisions;
            return new R01MDocumentRevisionState(newState);
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            throw new R01MContentModelException("No se puede cargar la informaci\u00f3n de configuraci\u00f3n del storage del contenido " + cont.getOid(), (Exception)((Object)cfgLoadEx));
        }
    }

    public R01MDocumentRevisionState doAproveDocument(R01MContent cont, R01MDocument doc) throws R01MContentModelException {
        int docState = doc.getRevisionState().getState();
        if (docState >= 0) {
            docState = 0;
        }
        int newState = docState + 1;
        return new R01MDocumentRevisionState(newState);
    }

    public R01MDocumentRevisionState doRejectDocument(R01MContent cont, R01MDocument doc) throws R01MContentModelException, R01MSecurityException {
        doc.setRevisionState(new R01MDocumentRevisionState());
        return doc.getRevisionState();
    }

    public R01MDocumentRevisionState doEditDocument(R01MContent cont, R01MDocument doc) throws R01MContentModelException, R01MSecurityException {
        return this.doRejectDocument(cont, doc);
    }

    public int obtainUiState(String target, String oidDocument) throws R01MSecurityException, R01MContentModelException {
        boolean ispublished;
        Integer revisionState;
        int traslateState = -1;
        Integer redaccionState = new Integer(1);
        Integer aprobadoState = new Integer(0);
        R01MContentModelAPI contentModelAPI = R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx);
        R01MDocument doc = new R01MDocument();
        try {
            doc = contentModelAPI.loadDocument(oidDocument);
            revisionState = doc.getRevisionState().getState();
            ispublished = contentModelAPI.isDocumentPublished(target, oidDocument);
        }
        catch (R01MSecurityException ex) {
            throw new R01MSecurityException("El usuario no tiene permisos para acceder al documento");
        }
        catch (R01MContentModelException ex) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion.", (Exception)((Object)ex));
        }
        if (!ispublished) {
            traslateState = 0;
        } else if (revisionState.compareTo(aprobadoState) == 0 && ispublished) {
            traslateState = 1;
        } else if ((revisionState.compareTo(redaccionState) == 0 || doc.getRevisionState().getRemainingRevisions() < 0) && ispublished) {
            traslateState = 2;
        }
        return traslateState;
    }
}

