/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services.helpers;

import com.ejie.r01d.datastore.R01DContentInDataStore;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MContentLocation;
import com.ejie.r01m.objects.contentmodel.R01MContentResume;
import com.ejie.r01m.objects.contentmodel.R01MDataFile;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.misc.R01MOperationInModelObjectResult;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MContentModelAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class R01DDataFileGenerationHelper {
    private transient R01MUserContext _userCtx;

    public R01DDataFileGenerationHelper() {
    }

    public R01DDataFileGenerationHelper(R01MUserContext userCtx) {
        this();
        this._userCtx = userCtx;
    }

    public void doGenerateDataFileUsingPresentationTemplate(R01MContent content, String documentOid, String dataFileOid, String presentationTemplateOid, boolean syncWorkflow, boolean uploadToDocumentFolder) throws R01MDataStoreException {
        R01DContentInDataStore contInDS = new R01DContentInDataStore(this._userCtx, content);
        contInDS.generateDataFileUsingPresentationTemplate(documentOid, dataFileOid, presentationTemplateOid, syncWorkflow, uploadToDocumentFolder);
    }

    public void doGenerateDataFileUsingAllPresentationTemplates(R01MContent content, String documentOid, String dataFileOid, boolean syncWorkflow, boolean uploadToDocumentFolder) throws R01MDataStoreException {
        R01DContentInDataStore contInDS = new R01DContentInDataStore(this._userCtx, content);
        contInDS.generateDataFileUsingAllPresentationTemplates(documentOid, dataFileOid, syncWorkflow, uploadToDocumentFolder);
    }

    public List[] doGenerateAllContentDataFiles(R01MContent cont) {
        List[] results = new List[]{new ArrayList(), new ArrayList()};
        Map docs = cont.getDocuments();
        if (docs != null && !docs.isEmpty()) {
            for (Map.Entry docIt : docs.entrySet()) {
                R01MDocument doc = (R01MDocument)docIt.getValue();
                Map dfs = doc.getDataFiles();
                if (dfs == null || dfs.size() <= 0) continue;
                for (Map.Entry dfIt : dfs.entrySet()) {
                    R01MDataFile df = (R01MDataFile)dfIt.getValue();
                    try {
                        this.doGenerateDataFileUsingAllPresentationTemplates(cont, doc.getOid(), df.getOid(), false, false);
                        R01MOperationInModelObjectResult res = new R01MOperationInModelObjectResult(cont.getOid() + ":" + doc.getOid() + ":" + df.getOid(), 2, true, null);
                        results[0].add(res);
                    }
                    catch (R01MDataStoreException dsEx) {
                        R01MOperationInModelObjectResult res = new R01MOperationInModelObjectResult(cont.getOid() + ":" + doc.getOid() + ":" + df.getOid(), 2, false, "Error al generar: " + dsEx.getMessage());
                        results[1].add(res);
                        dsEx.printStackTrace(System.out);
                    }
                }
            }
        }
        return results;
    }

    public List[] doGenerateAllContentDataFiles(R01MContent cont, String documentOid) {
        List[] results = new List[]{new ArrayList(), new ArrayList()};
        R01MDocument doc = cont.getDocument(documentOid);
        Map dfs = doc.getDataFiles();
        if (dfs != null && dfs.size() > 0) {
            for (Map.Entry dfIt : dfs.entrySet()) {
                R01MDataFile df = (R01MDataFile)dfIt.getValue();
                try {
                    this.doGenerateDataFileUsingAllPresentationTemplates(cont, doc.getOid(), df.getOid(), false, false);
                    R01MOperationInModelObjectResult res = new R01MOperationInModelObjectResult(cont.getOid() + ":" + doc.getOid() + ":" + df.getOid(), 2, true, null);
                    results[0].add(res);
                }
                catch (R01MDataStoreException dsEx) {
                    R01MOperationInModelObjectResult res = new R01MOperationInModelObjectResult(cont.getOid() + ":" + doc.getOid() + ":" + df.getOid(), 2, false, "Error al generar: " + dsEx.getMessage());
                    results[1].add(res);
                    dsEx.printStackTrace(System.out);
                }
            }
        }
        return results;
    }

    public List[] doGenerateAllLocationContentsDataFiles(R01MContentLocation loc) throws R01MSecurityException, R01MContentModelException {
        List[] results = new List[]{new ArrayList(), new ArrayList()};
        R01MContentModelAPI cmAPI = R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx);
        Map types = cmAPI.loadWorkAreaContents(loc);
        if (types != null && !types.isEmpty()) {
            for (Map.Entry typoME : types.entrySet()) {
                Object[] typologyArray = (Object[])typoME.getValue();
                Map contents = (Map)typologyArray[2];
                if (contents == null || contents.isEmpty()) continue;
                for (Map.Entry contME : contents.entrySet()) {
                    R01MContentResume contResume = (R01MContentResume)contME.getValue();
                    try {
                        R01MContent cont = cmAPI.loadContent(contResume.getOid());
                        List[] currContResults = this.doGenerateAllContentDataFiles(cont);
                        if (currContResults == null) continue;
                        results[0].addAll(currContResults[0]);
                        results[1].addAll(currContResults[1]);
                    }
                    catch (R01MContentModelException cmEx) {
                        R01MOperationInModelObjectResult res = new R01MOperationInModelObjectResult(contResume.getOid(), 0, false, "Error al cargar el contenido: " + cmEx.getMessage());
                        results[1].add(res);
                    }
                }
            }
        }
        return results;
    }

    public List[] doGenerateDatafileHTMLsBydocumentOid(String documentOid) throws R01MSecurityException, R01MContentModelException {
        List[] results = new List[]{new ArrayList(), new ArrayList()};
        R01MContentModelAPI contAPI = R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx);
        String contentOid = contAPI.getDocumentParentContent(documentOid);
        try {
            List[] currContResults = this.doGenerateAllContentDataFiles(contAPI.loadContent(contentOid), documentOid);
            if (currContResults != null) {
                results[0].addAll(currContResults[0]);
                results[1].addAll(currContResults[1]);
            }
        }
        catch (R01MContentModelException cmEx) {
            R01MOperationInModelObjectResult res = new R01MOperationInModelObjectResult(contentOid, 0, false, "Error al cargar el contenido: " + cmEx.getMessage());
            results[1].add(res);
        }
        return results;
    }
}

