/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services.helpers;

import com.ejie.r01d.datastore.R01DContentInDataStore;
import com.ejie.r01d.gestorcontenidos.dbhelppers.R01DContentModelLoaderHelper;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.catalogation.R01DCatalogCMPPK;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.catalogation.R01DCatalogCMPUtil;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.catalogation.R01DCatalogCMPValue;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.content.R01DContentCMPPK;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.content.R01DContentCMPUtil;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.publipdtes.R01DPubliPdtesCMPPK;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.publipdtes.R01DPubliPdtesCMPUtil;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.publipdtes.R01DPubliPdtesCMPValue;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.repopubli.R01DRepoPubDocumentCMPPK;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.repopubli.R01DRepoPubDocumentCMPUtil;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.repopubli.R01DRepoPubDocumentCMPValue;
import com.ejie.r01d.services.R01DContentModelManager;
import com.ejie.r01d.services.helpers.R01DContentModelInDataStoreHelper;
import com.ejie.r01d.services.helpers.R01DIndexerHelper;
import com.ejie.r01d.util.R01DQueries;
import com.ejie.r01f.exceptions.ExceptionUtils;
import com.ejie.r01f.jvt.JVTComparator;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.sql.QueryExecutor;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.config.objects.publisher.R01MLogicalPublicationInfo;
import com.ejie.r01m.config.objects.typologymanagement.R01MContentTypeTemplateConfig;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MCatalogElementNotFoundException;
import com.ejie.r01m.exceptions.R01MCatalogException;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.objects.cataloguing.R01MStructureCatalog;
import com.ejie.r01m.objects.cataloguing.structures.R01MStructureItem;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MDataFile;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.contentmodel.R01MDocumentPublicationRequested;
import com.ejie.r01m.objects.contentmodel.R01MDocumentPublicationTarget;
import com.ejie.r01m.objects.misc.R01MContentTestRecord;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexDefinition;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.contentmanager.R01MContentObjectsComparator;
import com.ejie.r01m.utils.contentmanager.R01MDataFileXMLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public class R01DContentTestHelper {
    private transient R01MUserContext _userCtx;
    private transient R01DContentModelManager _modelMgr;

    public R01DContentTestHelper() {
    }

    public R01DContentTestHelper(R01MUserContext userCtx, R01DContentModelManager mgr) {
        this._userCtx = userCtx;
        this._modelMgr = mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List testContent(String contentOid, boolean repair) throws R01MContentModelException {
        R01MDocumentPublicationTarget results;
        block38: {
            results = new ArrayList();
            int msgNumber = 0;
            StringBuffer dbg = new StringBuffer(73);
            try {
                ArrayList<R01MStructureCatalog> okLabels;
                List labels;
                JVTComparator comparator;
                dbg.append("R01MDataFileXMLUtils del contenido " + contentOid + " correccion de errores: " + (repair ? "ON" : "OFF") + "\r\n");
                R01DContentModelLoaderHelper loader = new R01DContentModelLoaderHelper(this._userCtx);
                R01MContent contentFromDB = loader.loadContentFromDBRecords(contentOid);
                R01MContent contentFromXML = loader.loadContentFromDBXML(contentOid);
                R01DContentInDataStore contentDataStore = new R01DContentInDataStore(this._userCtx, contentFromXML);
                if (contentFromDB == null || contentFromXML == null) break block38;
                if (contentFromXML.getDocuments() != null && !contentFromXML.getDocuments().isEmpty()) {
                    dbg.append("\t\t-TEST publicaciones incorrectas ");
                    boolean isContentDescriptorModified = false;
                    ArrayList<R01MDocumentPublicationTarget> publicationsToDelete = new ArrayList<R01MDocumentPublicationTarget>();
                    for (Map.Entry meDocument : contentFromXML.getDocuments().entrySet()) {
                        R01MDocument document = (R01MDocument)meDocument.getValue();
                        if (document.getPublicationInfo() == null || document.getPublicationInfo().isEmpty()) continue;
                        publicationsToDelete.clear();
                        for (R01MDocumentPublicationTarget pub : document.getPublicationInfo()) {
                            if (pub.getPublicationOid() != null && !pub.getPublicationOid().trim().equals("")) continue;
                            results.add(new R01MContentTestRecord(contentFromDB.getStoreLocation().composeMemoCode(), msgNumber++, R01MContentTestRecord.MSG_ERR_OBJ, contentFromXML.getClass().toString(), contentFromXML.getOid(), "Existen PUBLICACIONES sin identificador de publicaci\u00f3n."));
                            publicationsToDelete.add(pub);
                        }
                        if (!repair || publicationsToDelete.isEmpty()) continue;
                        Iterator itPublicationsToDelete = publicationsToDelete.iterator();
                        while (itPublicationsToDelete.hasNext()) {
                            contentFromXML.getDocument(document.getOid()).getPublicationInfo().remove(itPublicationsToDelete.next());
                        }
                        isContentDescriptorModified = true;
                    }
                    if (isContentDescriptorModified) {
                        R01DContentCMPUtil.getLocalHome().findByPrimaryKey(new R01DContentCMPPK(contentFromXML.getOid())).setDescriptor("<?xml version='1.0' encoding='ISO-8859-1'?>" + XOManager.getXML((String)R01MConstants.CONTENTMODEL_MAPFILE, (Object)contentFromXML));
                    }
                    dbg.append("[OK]\r\n");
                }
                if ((comparator = R01MContentObjectsComparator.compare((Object)contentFromDB, (Object)contentFromXML)) == null) {
                    throw new R01MContentModelException("NO se ha podido instanciar el comparador de objetos!");
                }
                if (comparator.getPlanTable() != null && comparator.getPlanTable().size() > 0) {
                    results.add(new R01MContentTestRecord(contentFromDB.getStoreLocation().composeMemoCode(), msgNumber++, R01MContentTestRecord.MSG_ERR_OBJ, contentFromXML.getClass().toString(), contentFromXML.getOid(), "[Comparator]" + comparator.composeDebugInfo()));
                    if (repair) {
                        Iterator it = comparator.getPlanTableIterator();
                        while (it.hasNext()) {
                            JVTComparator.PlanTableOperation operation = (JVTComparator.PlanTableOperation)it.next();
                            dbg.append("\t\t-TEST de objetos dependientes");
                            results.addAll(this._repairObjects(operation, contentFromXML.getOid(), msgNumber++, contentFromDB.getStoreLocation().composeMemoCode()));
                            dbg.append("[OK]\r\n");
                        }
                    }
                }
                comparator.reset();
                try {
                    dbg.append("\t\t-TEST validacion ");
                    contentFromXML.validateObject();
                    dbg.append("[OK]\r\n");
                }
                catch (R01MContentModelObjectsValidatorException cmvEx) {
                    results.add(new R01MContentTestRecord(contentFromDB.getStoreLocation().composeMemoCode(), msgNumber++, R01MContentTestRecord.MSG_ERR_SINTAX, contentFromXML.getClass().toString(), contentFromXML.getOid(), "Error en validaci\u00f3n del objeto: " + cmvEx.getMessage()));
                    dbg.append("[ERROR] " + cmvEx.getMessage() + "\r\n");
                }
                if (repair && (labels = contentFromXML.getLabels()) != null && !labels.isEmpty()) {
                    dbg.append("\t\t-TEST validez de etiquetas ");
                    okLabels = new ArrayList<R01MStructureCatalog>();
                    boolean labelOK = true;
                    boolean isModified = false;
                    for (int i = 0; i < labels.size(); ++i) {
                        R01MStructureCatalog label = (R01MStructureCatalog)labels.get(i);
                        labelOK = this._checkStructureLabel(label);
                        if (labelOK) {
                            okLabels.add(label);
                            continue;
                        }
                        isModified = true;
                    }
                    if (isModified) {
                        contentFromXML.setLabels(okLabels);
                        this._modelMgr.doSaveContent(this._userCtx, contentFromXML);
                    }
                    dbg.append("[OK]\r\n");
                }
                dbg.append("\t\t-TEST directorios por defecto del contenido");
                try {
                    if (repair) {
                        contentDataStore.createContentDefaultDirs();
                    }
                }
                catch (R01MDataStoreException dsEx) {
                    dbg.append("[ERROR] " + dsEx.getMessage() + "\r\n");
                    results.add(new R01MContentTestRecord(contentFromDB.getStoreLocation().composeMemoCode(), msgNumber++, R01MContentTestRecord.MSG_ERR_PUBLISHDIR, contentFromXML.getClass().toString(), contentFromXML.getOid(), "Error en directorio de contenido/publicaci\u00f3n: " + dsEx.getMessage()));
                }
                dbg.append("[OK]\r\n");
                Map documents = contentFromXML.getDocuments();
                if (documents == null || documents.isEmpty()) {
                    okLabels = results;
                    return okLabels;
                }
                for (Map.Entry me : documents.entrySet()) {
                    R01MDocument document = (R01MDocument)me.getValue();
                    dbg.append("\t\t-TEST estructura de directorios documento " + document.getOid() + " ");
                    results.addAll(this._testDocumentFolderStructure(repair, contentDataStore, document.getOid(), msgNumber++, contentFromDB.getStoreLocation().composeMemoCode()));
                    dbg.append("[OK]\r\n");
                    dbg.append("\t\t-TEST url publicacion documento " + document.getOid() + " ");
                    List publicationInfo = document.getPublicationInfo();
                    if (publicationInfo != null && !publicationInfo.isEmpty()) {
                        for (R01MDocumentPublicationTarget publication : publicationInfo) {
                            if (publication.getState() != 1 && publication.getState() != 4 && publication.getState() != 3) continue;
                            results.addAll(this._testPublishURL(repair, document.getOid(), publication, msgNumber++, contentFromDB.getStoreLocation().composeMemoCode()));
                        }
                    }
                    dbg.append("[OK]\r\n");
                    Map datafiles = document.getDataFiles();
                    if (datafiles == null || datafiles.isEmpty()) {
                        R01MDocumentPublicationTarget publication;
                        publication = results;
                        return publication;
                    }
                    boolean existsInitialDatafile = false;
                    String oidInitialDatafileTemp = "";
                    for (Map.Entry meDatafile : datafiles.entrySet()) {
                        R01MDataFile datafile;
                        block39: {
                            datafile = (R01MDataFile)meDatafile.getValue();
                            oidInitialDatafileTemp = datafile.getOid();
                            dbg.append("\t\t\t-TEST DCR del dataFile " + datafile.getOid() + " (existencia y encoding) ");
                            InputStream dfIs = null;
                            try {
                                dfIs = contentDataStore.downloadDataFile(document.getOid(), datafile.getOid());
                                R01MDataFileXMLUtils.parseDCR((InputStream)dfIs);
                            }
                            catch (R01MDataStoreException dstExc) {
                                results.add(new R01MContentTestRecord(contentFromDB.getStoreLocation().composeMemoCode(), msgNumber++, R01MContentTestRecord.MSG_ERR_DCR, datafile.getClass().toString(), datafile.getOid(), "El DCR del archivo no existe o no se puede descargar"));
                                if (!repair) break block39;
                                try {
                                    R01MContentTypeTemplateConfig templateCfg = R01MClientFactory.getTypologyManagementConfigAPI().getTemplateConfig(contentFromXML.getStoreLocation(), contentFromXML.getTypo(), datafile.getTemplateOid());
                                    try {
                                        contentDataStore.uploadDataFile(document.getOid(), datafile.getOid(), R01DContentModelInDataStoreHelper.obtainDataFileTemplate(document.getLanguage() + "_" + datafile.getOid(), templateCfg));
                                    }
                                    catch (R01MDataStoreException dsEx) {
                                        results.add(new R01MContentTestRecord(contentFromDB.getStoreLocation().composeMemoCode(), msgNumber++, R01MContentTestRecord.MSG_ERR_DCR, datafile.getClass().toString(), datafile.getOid(), "Error al crear un DCR b\u00e1sico para el archivo"));
                                    }
                                }
                                catch (R01MConfigLoadException cfgLoadEx) {
                                    R01FLog.to((String)"r01d.manager").severe("NO se ha podido obtener la configuracion de la plantilla " + datafile.getTemplateOid() + ".Error:" + cfgLoadEx.getMessage());
                                }
                            }
                            catch (SAXException saxEx) {
                                dbg.append("\t\t\t\t-Correccion del Encoding del DCR: " + contentDataStore.getContent().getOid() + " : " + document.getOid() + " : " + datafile.getOid());
                                if (!repair) break block39;
                                this._changeDCREncoding(contentDataStore, document.getOid(), datafile.getOid(), msgNumber, contentDataStore.getContent().getStoreLocation().composeMemoCode());
                            }
                        }
                        dbg.append("[OK]\r\n");
                        if (datafile.getInitialPage() != 1) continue;
                        existsInitialDatafile = true;
                    }
                    if (existsInitialDatafile) continue;
                    results.add(new R01MContentTestRecord(contentFromDB.getStoreLocation().composeMemoCode(), msgNumber++, R01MContentTestRecord.MSG_ERR_INITIAL, document.getClass().toString(), document.getOid(), "El documento no tiene archivo de inicio"));
                    if (!repair) continue;
                    results.add(new R01MContentTestRecord(contentFromDB.getStoreLocation().composeMemoCode(), msgNumber++, R01MContentTestRecord.MSG_ERR_INITIAL, document.getClass().toString(), document.getOid(), "Se establece como archivo de inicio el archivo de oid " + oidInitialDatafileTemp));
                    this._modelMgr.doSetDocumentInitialPage(this._userCtx, contentFromXML.getOid(), document.getOid(), oidInitialDatafileTemp);
                    List indexers = new ArrayList();
                    indexers = XMLProperties.getPropertyList((String)R01MConstants.API_APPCODE, (String)"indexersConfigurations/default/indexer", Arrays.asList("com.ejie.r01k.searchorchestrator.indexer.indexers.R01KDataBaseIndexer"));
                    R01MIndexDefinition indexDefinition = new R01MIndexDefinition(0, document.getOid(), 1, null, indexers, false, -1, null, null, null);
                    R01DIndexerHelper.doIndexObject(indexDefinition);
                }
            }
            catch (Throwable th) {
                R01FLog.to((String)"r01d.tester").severe("Error GENERAL:" + th.getMessage());
                results.add(new R01MContentTestRecord(null, msgNumber++, R01MContentTestRecord.MSG_ERR_FATAL, null, null, "Error general al cargar el objeto: " + th.getMessage()));
            }
            finally {
                R01FLog.to((String)"r01d.tester").info(dbg.toString());
            }
        }
        return results;
    }

    private List _testDocumentFolderStructure(boolean repair, R01DContentInDataStore contentDataStore, String documentOid, int msgNumber, String contentLocationMemoCode) {
        ArrayList<R01MContentTestRecord> results;
        block7: {
            results = new ArrayList<R01MContentTestRecord>();
            try {
                contentDataStore.listDocumentFolderContents(documentOid, "/", false);
            }
            catch (R01MDataStoreException ex) {
                ex.printStackTrace(System.out);
                results.add(new R01MContentTestRecord(contentLocationMemoCode, msgNumber, R01MContentTestRecord.MSG_ERR_DOC_FOLDER, R01MDocument.class.toString(), documentOid, "El documento en IW no se puede leer"));
                if (!repair) break block7;
                try {
                    contentDataStore.createDocument(documentOid);
                }
                catch (R01MDataStoreException dsEx) {
                    dsEx.printStackTrace(System.out);
                    results.add(new R01MContentTestRecord(contentLocationMemoCode, msgNumber, R01MContentTestRecord.MSG_ERR_DOC_FOLDER, R01MDocument.class.toString(), documentOid, "No se ha podido crear la carpeta del documento en IW"));
                }
            }
        }
        if (repair) {
            try {
                contentDataStore.createDocumentDefaultDirs(documentOid);
            }
            catch (R01MDataStoreException dsEx) {
                dsEx.printStackTrace(System.out);
                results.add(new R01MContentTestRecord(contentLocationMemoCode, msgNumber + 1, R01MContentTestRecord.MSG_ERR_DOC_FOLDER, R01MDocument.class.toString(), documentOid, "Error en la estructura del directorio de documento: " + dsEx.getMessage()));
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List _changeDCREncoding(R01DContentInDataStore contentDataStore, String documentOid, String dataFileOid, int msgNumber, String contentLocationMemoCode) {
        ArrayList<R01MContentTestRecord> results = new ArrayList<R01MContentTestRecord>();
        InputStream dfIs = null;
        InputStreamReader dcrReader = null;
        ByteArrayOutputStream recodedDCROS = null;
        OutputStreamWriter recodedDCROSWriter = null;
        ByteArrayInputStream recodedDCRIS = null;
        try {
            dfIs = contentDataStore.downloadDataFile(documentOid, dataFileOid);
            String newEncoding = "UTF-8";
            dcrReader = new InputStreamReader(dfIs);
            String enconding = dcrReader.getEncoding();
            if (enconding == null || StringUtils.isEmptyString((String)enconding) || enconding.compareTo(newEncoding) == 0) {
                dcrReader.close();
            } else {
                recodedDCROS = new ByteArrayOutputStream();
                recodedDCROSWriter = new OutputStreamWriter((OutputStream)recodedDCROS, newEncoding);
                while (dcrReader.ready()) {
                    int c = dcrReader.read();
                    if (c <= 0) continue;
                    recodedDCROSWriter.write(c);
                }
                recodedDCROSWriter.flush();
                recodedDCRIS = new ByteArrayInputStream(recodedDCROS.toByteArray());
                contentDataStore.uploadDataFile(documentOid, dataFileOid, (InputStream)recodedDCRIS);
            }
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace(System.out);
            results.add(new R01MContentTestRecord(contentLocationMemoCode, msgNumber++, R01MContentTestRecord.MSG_ERR_DCR, R01MDataFile.class.toString(), dataFileOid, "Error al corregir el encoding de un DCR"));
        }
        catch (R01MDataStoreException dstExc) {
            dstExc.printStackTrace(System.out);
            results.add(new R01MContentTestRecord(contentLocationMemoCode, msgNumber++, R01MContentTestRecord.MSG_ERR_DCR, R01MDataFile.class.toString(), dataFileOid, "Error al subir al dataStore el DCR con el encoding corregido"));
        }
        finally {
            try {
                if (dfIs != null) {
                    dfIs.close();
                }
                if (dcrReader != null) {
                    dcrReader.close();
                }
                if (recodedDCROS != null) {
                    recodedDCROS.close();
                }
                if (recodedDCROSWriter != null) {
                    recodedDCROSWriter.close();
                }
                if (recodedDCRIS != null) {
                    recodedDCRIS.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(System.out);
            }
        }
        return results;
    }

    private List _testPublishURL(boolean restore, String documentOid, R01MDocumentPublicationTarget publication, int msgNumber, String contentLocationMemoCode) {
        ArrayList<R01MContentTestRecord> results = new ArrayList<R01MContentTestRecord>();
        String alias = null;
        try {
            alias = "/" + ((R01MLogicalPublicationInfo)R01MClientFactory.getPublisherConfigAPI().getLogicalPublicationsConfigs().get(publication.getOid())).getContentAlias();
        }
        catch (R01MConfigLoadException ex) {
            results.add(new R01MContentTestRecord(contentLocationMemoCode, msgNumber, R01MContentTestRecord.MSG_ERR_URLPUBLISH, R01MDocument.class.toString(), documentOid, "Error en la validaci\u00f3n de la URL de publicaci\u00f3n.Error:" + ExceptionUtils.serializeExceptionStackTrace((Throwable)ex)));
        }
        if (alias != null && !publication.getUrl().startsWith(alias)) {
            results.add(new R01MContentTestRecord(contentLocationMemoCode, msgNumber, R01MContentTestRecord.MSG_ERR_URLPUBLISH, R01MDocument.class.toString(), documentOid, "La URL de publicaci\u00f3n est\u00e1 mal constru\u00edda. Debe comenzar por '/" + alias + "'"));
            if (restore) {
                QueryExecutor qryExec = R01DQueries.obtainQueryExecutorInstance();
                try {
                    StringBuffer sql = new StringBuffer(50);
                    sql.append("UPDATE r01d19t01 SET url_19 ='/");
                    sql.append(alias);
                    sql.append(publication.getUrl());
                    sql.append("' WHERE oid_18 ='");
                    sql.append(publication.getOid());
                    sql.append("' AND oid_12='");
                    sql.append(documentOid);
                    sql.append("'");
                    qryExec.executeInsert(sql.toString());
                }
                catch (Exception sqlEx) {
                    sqlEx.printStackTrace(System.out);
                    results.add(new R01MContentTestRecord(contentLocationMemoCode, msgNumber, R01MContentTestRecord.MSG_ERR_URLPUBLISH, R01MDocument.class.toString(), documentOid, "Error al actualizar la URL de publicaci\u00f3n."));
                }
            }
        }
        return results;
    }

    private List _repairObjects(JVTComparator.PlanTableOperation operation, String contentOid, int msgNumber, String contentLocationMemoCode) {
        R01MDocument doc;
        R01MStructureCatalog label;
        ArrayList<R01MContentTestRecord> results = new ArrayList<R01MContentTestRecord>();
        Object[] args = operation.args;
        if (operation.operation == 6 && args[1] instanceof R01MStructureCatalog) {
            label = (R01MStructureCatalog)args[1];
            results.add(new R01MContentTestRecord(contentLocationMemoCode, msgNumber, R01MContentTestRecord.MSG_ERR_LABEL, R01MContent.class.toString(), contentOid, "La etiqueta " + label.getOid() + " no est\u00e1 en el descriptor del contenido"));
            try {
                R01DCatalogCMPUtil.getLocalHome().findByPrimaryKey(new R01DCatalogCMPPK(contentOid, label.getOid(), label.getStructureOid())).remove();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                results.add(new R01MContentTestRecord(contentLocationMemoCode, msgNumber, R01MContentTestRecord.MSG_ERR_LABEL, R01MContent.class.toString(), contentOid, "Error al borrar la etiqueta " + label.getOid() + " en BD"));
            }
        }
        if (operation.operation == 6 && args[1] instanceof R01MDocumentPublicationRequested) {
            R01MDocumentPublicationRequested reqPublication = (R01MDocumentPublicationRequested)args[1];
            results.add(new R01MContentTestRecord(contentLocationMemoCode, msgNumber, R01MContentTestRecord.MSG_ERR_PUB, R01MContent.class.toString(), contentOid, "La petici\u00f3n de publicacion " + reqPublication.getOid() + " no est\u00e1 en la BD"));
            try {
                R01DPubliPdtesCMPUtil.getLocalHome().findByPrimaryKey(new R01DPubliPdtesCMPPK(reqPublication.getOid())).remove();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                results.add(new R01MContentTestRecord(contentLocationMemoCode, msgNumber, R01MContentTestRecord.MSG_ERR_PUB, R01MContent.class.toString(), contentOid, "Error al borrar la petici\u00f3n de publicacion " + reqPublication.getOid() + " en BD"));
            }
        }
        if (operation.operation == 6 && args[1] instanceof R01MDocumentPublicationTarget) {
            doc = (R01MDocument)args[0];
            R01MDocumentPublicationTarget publicacion = (R01MDocumentPublicationTarget)args[1];
            results.add(new R01MContentTestRecord(contentLocationMemoCode, msgNumber, R01MContentTestRecord.MSG_ERR_PUB, R01MContent.class.toString(), contentOid, "La publicacion " + publicacion.getOid() + " no est\u00e1 en la BD"));
            try {
                R01DRepoPubDocumentCMPUtil.getLocalHome().findByPrimaryKey(new R01DRepoPubDocumentCMPPK(doc.getOid(), publicacion.getOid(), publicacion.getState())).remove();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                results.add(new R01MContentTestRecord(contentLocationMemoCode, msgNumber, R01MContentTestRecord.MSG_ERR_PUB, R01MContent.class.toString(), contentOid, "Error al borrar la publicacion " + publicacion.getOid() + " en BD"));
            }
        }
        if (operation.operation == 5 && args[1] instanceof R01MStructureCatalog) {
            label = (R01MStructureCatalog)args[1];
            results.add(new R01MContentTestRecord(contentLocationMemoCode, msgNumber, R01MContentTestRecord.MSG_ERR_LABEL, R01MContent.class.toString(), contentOid, "La etiqueta " + label.getOid() + " no est\u00e1 en BD"));
            R01DCatalogCMPValue catalogVO = new R01DCatalogCMPValue();
            catalogVO.setOid(label.getOid());
            catalogVO.setContentOid(contentOid);
            catalogVO.setStructureOid(label.getStructureOid());
            catalogVO.setRole(label.getRole());
            try {
                R01DCatalogCMPUtil.getLocalHome().create(catalogVO);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                results.add(new R01MContentTestRecord(contentLocationMemoCode, msgNumber, R01MContentTestRecord.MSG_ERR_LABEL, R01MContent.class.toString(), contentOid, "Error al corregir la etiqueta " + label.getOid() + " en BD."));
            }
        }
        if (operation.operation == 5 && args[1] instanceof R01MDocumentPublicationRequested) {
            doc = (R01MDocument)args[0];
            R01MDocumentPublicationRequested reqPub = (R01MDocumentPublicationRequested)args[1];
            results.add(new R01MContentTestRecord(contentLocationMemoCode, msgNumber, R01MContentTestRecord.MSG_ERR_PUB, R01MContent.class.toString(), contentOid, "La peticion de publicacion " + reqPub.getOid() + " no est\u00e1 en BD"));
            R01DPubliPdtesCMPValue pubPdtesVO = new R01DPubliPdtesCMPValue();
            pubPdtesVO.setOid(reqPub.getOid());
            pubPdtesVO.setDocumentOid(doc.getOid());
            pubPdtesVO.setRepositoryOid(reqPub.getRepositoryOid());
            pubPdtesVO.setOperationDate(reqPub.getOperationDate());
            pubPdtesVO.setOperationType(new Integer(reqPub.getOperationType()));
            try {
                R01DPubliPdtesCMPUtil.getLocalHome().create(pubPdtesVO);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                results.add(new R01MContentTestRecord(contentLocationMemoCode, msgNumber, R01MContentTestRecord.MSG_ERR_PUB, R01MContent.class.toString(), contentOid, "Error al corregir la peticion de publicacion " + reqPub.getOid() + " en BD."));
            }
        }
        if (operation.operation == 5 && args[1] instanceof R01MDocumentPublicationTarget) {
            doc = (R01MDocument)args[0];
            R01MDocumentPublicationTarget pub = (R01MDocumentPublicationTarget)args[1];
            results.add(new R01MContentTestRecord(contentLocationMemoCode, msgNumber, R01MContentTestRecord.MSG_ERR_PUB, R01MContent.class.toString(), contentOid, "La publicacion " + pub.getOid() + " no est\u00e1 en BD"));
            R01DRepoPubDocumentCMPValue repoPubVO = new R01DRepoPubDocumentCMPValue();
            repoPubVO.setDocumentOid(doc.getOid());
            repoPubVO.setPublicationOid(pub.getOid());
            repoPubVO.setState(pub.getState());
            repoPubVO.setPublishDate(pub.getPublishDate());
            repoPubVO.setUrl(pub.getUrl());
            repoPubVO.setMainAlias(pub.getMainAlias());
            repoPubVO.setPublicationOid(pub.getPublicationOid());
            repoPubVO.setPublisherConfirmation(pub.getPublisherConfirmation());
            try {
                R01DRepoPubDocumentCMPUtil.getLocalHome().create(repoPubVO);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                results.add(new R01MContentTestRecord(contentLocationMemoCode, msgNumber, R01MContentTestRecord.MSG_ERR_PUB, R01MContent.class.toString(), contentOid, "Error al corregir la publicacion " + pub.getOid() + " en BD."));
            }
        }
        return results;
    }

    private boolean _checkStructureLabel(R01MStructureCatalog label) {
        R01MStructureItem item = null;
        boolean labelOK = true;
        try {
            item = R01MClientFactory.getCatalogAPI((R01MUserContext)this._userCtx).getStructureItem(label.structureOid, label.oid, Integer.parseInt(label.getRole()));
            if (item != null) {
                if (label.role != null) {
                    if (item.getRole() != Integer.parseInt(label.role)) {
                        labelOK = false;
                    }
                } else {
                    labelOK = false;
                }
            }
        }
        catch (R01MCatalogElementNotFoundException catNFExc) {
            catNFExc.printStackTrace(System.out);
            labelOK = false;
        }
        catch (R01MCatalogException catEx) {
            catEx.printStackTrace(System.out);
            labelOK = false;
        }
        return labelOK;
    }
}

