/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services.helpers;

import com.ejie.r01d.datastore.R01DContentInDataStore;
import com.ejie.r01d.services.R01DContentModelManager;
import com.ejie.r01f.clone.CloneUtils;
import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.exceptions.R01MDeleteContentException;
import com.ejie.r01m.exceptions.R01MDeleteDataFileException;
import com.ejie.r01m.exceptions.R01MDeleteDocumentException;
import com.ejie.r01m.exceptions.R01MDirtyContentModelException;
import com.ejie.r01m.exceptions.R01MDuplicateContentException;
import com.ejie.r01m.exceptions.R01MDuplicateDataFileException;
import com.ejie.r01m.exceptions.R01MDuplicateDocumentException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.R01MBaseLocationObject;
import com.ejie.r01m.objects.businesserrors.R01MBusinessErrors;
import com.ejie.r01m.objects.cataloguing.R01MStructureCatalog;
import com.ejie.r01m.objects.cataloguing.picks.R01MGeoPick;
import com.ejie.r01m.objects.cataloguing.picks.R01MGeoPicks;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MContentLocation;
import com.ejie.r01m.objects.contentmodel.R01MContentTypologyInfo;
import com.ejie.r01m.objects.contentmodel.R01MDataFile;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.contentmodel.R01MDocumentRevisionState;
import com.ejie.r01m.objects.contentmodel.R01MSaveContentResult;
import com.ejie.r01m.objects.datastore.R01MDataStoreItem;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MRawDataAPI;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MDateUtils;
import com.ejie.r01m.utils.R01MPathHelpper;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.contentmanager.R01MContentModelObjectsValidator;
import com.ejie.r01m.utils.contentmanager.R01MDataFileXMLUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class R01DContentModelObjectsCopyHelper {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01d.contentManager").intValue() != Level.OFF.intValue();
    private static final int CONTENT_MOVE = 0;
    private static final boolean COPY_DATAFILES_TO_DOCUMENTFOLDER = XMLProperties.getBoolean((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"contentIndexPrepareOps/copyDataFilesToDocumentFolder", (boolean)true);
    private R01DContentModelManager _cmManager;

    public R01DContentModelObjectsCopyHelper() {
        this._cmManager = new R01DContentModelManager();
    }

    public R01DContentModelObjectsCopyHelper(R01DContentModelManager cmManager) {
        this._cmManager = cmManager;
    }

    public R01MContent copyContent(R01MUserContext userCtx, R01MContent srcCont, R01MContentLocation targetLoc, String newContentName, boolean copyAttachments) throws R01MDuplicateContentException, R01MDuplicateDocumentException, R01MDuplicateDataFileException, R01MDeleteContentException, R01MDeleteDocumentException, R01MDeleteDataFileException, R01MDataStoreException, R01MContentModelException, R01MDirtyContentModelException, R01MSecurityException {
        if (srcCont == null) {
            throw new R01MContentModelException("NO se ha pasado el contenido a copiar");
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.contentManager").info("\r\n\r\n\r\nCONTENTMANAGER - COPYCONTENT(" + srcCont.getOid() + ")> Copia del modelo de objetos...");
        }
        R01MContent copyCont = this._cloneContentObjMembers(userCtx, srcCont, targetLoc, newContentName);
        HashMap<String, String> documentsAssociation = null;
        HashMap<String, String> dataFilesAssociation = null;
        HashMap documentDataFilesAssociation = null;
        if (srcCont.getDocuments() != null && !srcCont.getDocuments().isEmpty()) {
            R01MDocument srcDoc;
            documentsAssociation = new HashMap<String, String>(srcCont.getDocuments().size());
            documentDataFilesAssociation = new HashMap(srcCont.getDocuments().size());
            HashMap<String, R01MDocument> copyOfDocuments = new HashMap<String, R01MDocument>(srcCont.getDocuments().size());
            for (Map.Entry meDocument : srcCont.getDocuments().entrySet()) {
                srcDoc = (R01MDocument)meDocument.getValue();
                R01MDocument copyDoc = this._cloneDocumentObjMembers(userCtx, srcDoc, srcDoc.getLanguage(), null);
                copyOfDocuments.put(copyDoc.getOid(), copyDoc);
                documentsAssociation.put(srcDoc.getOid(), copyDoc.getOid());
            }
            copyCont.setDocuments(copyOfDocuments);
            for (Map.Entry meDocument : srcCont.getDocuments().entrySet()) {
                srcDoc = (R01MDocument)meDocument.getValue();
                if (srcDoc.getDataFiles() == null || srcDoc.getDataFiles().isEmpty()) continue;
                dataFilesAssociation = new HashMap<String, String>(srcDoc.getDataFiles().size());
                HashMap<String, R01MDataFile> copyOfDataFiles = new HashMap<String, R01MDataFile>(srcDoc.getDataFiles().size());
                for (Map.Entry meDataFile : srcDoc.getDataFiles().entrySet()) {
                    R01MDataFile srcDataFile = (R01MDataFile)meDataFile.getValue();
                    R01MDataFile copyDataFile = this._cloneDataFileObjMembers(userCtx, srcDataFile);
                    copyOfDataFiles.put(copyDataFile.getOid(), copyDataFile);
                    dataFilesAssociation.put(srcDataFile.getOid(), copyDataFile.getOid());
                }
                documentDataFilesAssociation.put(srcDoc.getOid(), dataFilesAssociation);
                String docCopyOid = documentsAssociation.get(srcDoc.getOid()).toString();
                R01MDocument docCopy = copyCont.getDocument(docCopyOid);
                docCopy.setDataFiles(copyOfDataFiles);
                this._validateDocumentDataFiles(copyCont, docCopy);
            }
            if (DEBUG) {
                R01FLog.to((String)"r01d.contentManager").info("CONTENTMANAGER - COPYCONTENT(" + srcCont.getOid() + ")> FIN Copia del modelo de objetos...\r\n\r\n\r\n");
            }
        }
        try {
            R01MClientFactory.getContentModelAPI((R01MUserContext)userCtx).saveContent(copyCont);
        }
        catch (R01MContentModelObjectsValidatorException ex) {
            R01FLog.to((String)"r01d.contentManager").severe("CONTENTMANAGER - COPYCONTENT(" + srcCont.getOid() + ")> Error al salvar el contenido copia ...\r\n\r\n\r\n");
            throw new R01MContentModelException("Error al salvar el contenido copia de oid", (Exception)((Object)ex));
        }
        catch (R01MSecurityException ex) {
            R01FLog.to((String)"r01d.contentManager").severe("CONTENTMANAGER - COPYCONTENT(" + srcCont.getOid() + ")> Error al salvar el contenido copia ...\r\n\r\n\r\n");
            throw new R01MContentModelException("Error al salvar el contenido copia de oid", (Exception)((Object)ex));
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.contentManager").info("CONTENTMANAGER - COPYCONTENT(" + srcCont.getOid() + ")> Creada la copia del contenido con el oid '" + copyCont.getOid() + "'...\r\n\r\n\r\n");
        }
        try {
            R01MGeoPicks geoPicks = this._cmManager.doLoadContentGeoLabels(userCtx, srcCont.getOid());
            if (geoPicks != null && geoPicks.getGeopicks() != null && !geoPicks.getGeopicks().isEmpty()) {
                if (DEBUG) {
                    R01FLog.to((String)"r01d.contentManager").info("\r\n\r\n\r\nCONTENTMANAGER - COPYCONTENT(" + srcCont.getOid() + ")> Copia de la catalogacion geografica...");
                }
                R01MGeoPicks newGeoPicks = new R01MGeoPicks();
                newGeoPicks.setGeopicks(geoPicks.getGeopicks());
                this._cmManager.doSaveContentGeoLabels(userCtx, copyCont.getOid(), newGeoPicks);
            }
        }
        catch (Exception ex) {
            R01FLog.to((String)"r01d.contentManager").severe("CONTENTMANAGER - COPYCONTENT(" + srcCont.getOid() + ")> Error al salvar la catalogacion geografica del contenido copia ...\r\n\r\n\r\n");
            throw new R01MContentModelException("Error al salvar la catalogacion geografica en la copia del contenido de oid " + srcCont.getOid() + " al contenido " + copyCont.getOid(), ex);
        }
        if (srcCont.getDocuments() != null && !srcCont.getDocuments().isEmpty()) {
            for (Map.Entry meDocument : srcCont.getDocuments().entrySet()) {
                String srcDocOid = ((R01MDocument)meDocument.getValue()).getOid();
                if (DEBUG) {
                    R01FLog.to((String)"r01d.contentManager").info("\r\n\r\n\r\nCONTENTMANAGER - COPYCONTENT(" + srcCont.getOid() + ")> Copia de los errores de negocio del documento " + srcDocOid + "...");
                }
                String copyDocOid = documentsAssociation.get(srcDocOid).toString();
                try {
                    R01MBusinessErrors businessErrorsDoc = this._cmManager.doLoadBusinessErrors(userCtx, srcDocOid);
                    if (businessErrorsDoc == null || businessErrorsDoc.getCategories() == null || businessErrorsDoc.getCategories().isEmpty()) continue;
                    businessErrorsDoc.setDocumentOid(copyDocOid);
                    this._cmManager.doSetBusinessErrors(userCtx, copyDocOid, businessErrorsDoc);
                }
                catch (Exception ex) {
                    R01FLog.to((String)"r01d.contentManager").severe("CONTENTMANAGER - COPYCONTENT(" + srcCont.getOid() + ")> Error al copiar los errores de negocio del documento ...\r\n\r\n\r\n");
                    throw new R01MContentModelException("Error al copiar los errores de negocio del documento de oid " + srcDocOid + " al documento " + copyDocOid, ex);
                }
            }
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.contentManager").info("\r\n\r\n\r\nCONTENTMANAGER - COPYCONTENT(" + srcCont.getOid() + ")> Copia de los ficheros...");
        }
        if (srcCont.getDocuments() != null && !srcCont.getDocuments().isEmpty()) {
            if (DEBUG) {
                R01FLog.to((String)"r01d.contentManager").info("CONTENTMANAGER - COPYCONTENT(" + srcCont.getOid() + ")> Copiando dataFiles (f\u00edsicamente)...");
            }
            for (Map.Entry meDocument : srcCont.getDocuments().entrySet()) {
                R01MDocument srcDoc = (R01MDocument)meDocument.getValue();
                R01MDocument copyDoc = copyCont.getDocument(documentsAssociation.get(srcDoc.getOid()).toString());
                Map currDocDataFilesAssociation = (Map)documentDataFilesAssociation.get(srcDoc.getOid());
                this._copyDocumentFiles(userCtx, srcCont, copyCont, srcDoc, copyDoc, currDocDataFilesAssociation, true);
            }
        }
        if (copyAttachments) {
            R01DContentInDataStore contentDataStoreSource = new R01DContentInDataStore(userCtx, srcCont);
            contentDataStoreSource.copyContent(copyCont);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.contentManager").info("CONTENTMANAGER - COPYCONTENT(" + srcCont.getOid() + ")> FIN Copia de los ficheros...\r\n\r\n\r\n");
        }
        return copyCont;
    }

    public R01MDocument copyDocument(R01MUserContext userCtx, R01MContent srcCont, R01MContent destCont, R01MDocument srcDoc, String newLang, String documentInternalName, boolean copyAttachments) throws R01MDuplicateContentException, R01MDuplicateDocumentException, R01MDuplicateDataFileException, R01MDeleteContentException, R01MDeleteDocumentException, R01MDeleteDataFileException, R01MDataStoreException, R01MContentModelException, R01MDirtyContentModelException {
        if (srcCont == null || destCont == null || srcDoc == null) {
            throw new R01MContentModelException("NO se ha pasado el contenido origen / destino o el documento a copiar");
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.contentManager").info("\r\n\r\n\r\nCONTENTMANAGER - COPYDOCUMENT(" + srcCont.getOid() + ":" + srcDoc.getOid() + " a " + destCont.getOid() + ")> Copia del modelo de objetos...");
        }
        HashMap<String, String> dataFilesAssociation = null;
        R01MDocument copyDoc = this._cloneDocumentObjMembers(userCtx, srcDoc, newLang, documentInternalName);
        destCont.addDocument(copyDoc);
        if (srcDoc.getDataFiles() != null && !srcDoc.getDataFiles().isEmpty()) {
            dataFilesAssociation = new HashMap<String, String>(srcDoc.getDataFiles().size());
            HashMap<String, R01MDataFile> copyOfDataFiles = new HashMap<String, R01MDataFile>(srcDoc.getDataFiles().size());
            for (Map.Entry meDataFile : srcDoc.getDataFiles().entrySet()) {
                R01MDataFile srcDataFile = (R01MDataFile)meDataFile.getValue();
                R01MDataFile copyDataFile = this._cloneDataFileObjMembers(userCtx, srcDataFile);
                copyOfDataFiles.put(copyDataFile.getOid(), copyDataFile);
                dataFilesAssociation.put(srcDataFile.getOid(), copyDataFile.getOid());
            }
            copyDoc.setDataFiles(copyOfDataFiles);
            this._validateDocumentDataFiles(destCont, copyDoc);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.contentManager").info("CONTENTMANAGER - COPYDOCUMENT(" + srcCont.getOid() + ":" + srcDoc.getOid() + " a " + destCont.getOid() + ")> Copia del modelo de objetos...\r\n\r\n\r\n");
        }
        try {
            this._cmManager.doSaveContent(userCtx, destCont);
        }
        catch (R01MSecurityException secEx) {
            R01FLog.to((String)"r01d.contentManager").severe("CONTENTMANAGER - COPYCONTENT(" + srcCont.getOid() + ")> Error al guardar el contenido de destino ...\r\n\r\n\r\n");
            throw new R01MContentModelException("Error al guardar el contenido de destino (" + destCont.getOid() + ") en la copia del documento de oid " + srcDoc.getOid() + " al documento " + copyDoc.getOid(), (Exception)((Object)secEx));
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.contentManager").info("\r\n\r\n\r\nCONTENTMANAGER - COPYCONTENT(" + srcCont.getOid() + ")> Copia de los errores de negocio del documento " + srcDoc.getOid() + "...");
        }
        try {
            R01MBusinessErrors businessErrorsDoc = this._cmManager.doLoadBusinessErrors(userCtx, srcDoc.getOid());
            if (businessErrorsDoc != null && businessErrorsDoc.getCategories() != null && !businessErrorsDoc.getCategories().isEmpty()) {
                businessErrorsDoc.setDocumentOid(copyDoc.getOid());
                this._cmManager.doSetBusinessErrors(userCtx, copyDoc.getOid(), businessErrorsDoc);
            }
        }
        catch (Exception ex) {
            R01FLog.to((String)"r01d.contentManager").severe("CONTENTMANAGER - COPYCONTENT(" + srcCont.getOid() + ")> Error al copiar los errores de negocio del documento ...\r\n\r\n\r\n");
            throw new R01MContentModelException("Error al copiar los errores de negocio del documento de oid " + srcDoc.getOid() + " al documento " + copyDoc.getOid(), ex);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.contentManager").info("\r\n\r\n\r\nCONTENTMANAGER - COPYCONTENT(" + srcCont.getOid() + ":" + srcDoc.getOid() + " a " + destCont.getOid() + ")> Copia de los ficheros...");
        }
        this._copyDocumentFiles(userCtx, srcCont, destCont, srcDoc, copyDoc, dataFilesAssociation, copyAttachments);
        if (DEBUG) {
            R01FLog.to((String)"r01d.contentManager").info("CONTENTMANAGER - COPYCONTENT(" + srcCont.getOid() + ":" + srcDoc.getOid() + " a " + destCont.getOid() + ")> FIN Copia de los ficheros...\r\n\r\n\r\n");
        }
        return copyDoc;
    }

    public List<R01MDocument> copyDocumentInto(R01MUserContext userCtx, R01MContent cont, R01MDocument srcDoc, R01MDocument dstDoc, boolean copyAttachments) throws R01MDuplicateContentException, R01MDuplicateDocumentException, R01MDuplicateDataFileException, R01MDeleteContentException, R01MDeleteDocumentException, R01MDeleteDataFileException, R01MDataStoreException, R01MContentModelException, R01MDirtyContentModelException {
        Map<String, Long> resultTS;
        if (cont == null || srcDoc == null || dstDoc == null) {
            throw new R01MContentModelException("NO se ha pasado el contenido o el documento origen / destino a copiar");
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.contentManager").info("\r\n\r\n\r\nCONTENTMANAGER - COPYDOCUMENT(" + cont.getOid() + ":" + srcDoc.getOid() + " a " + dstDoc.getOid() + ")> Copia del modelo de objetos...");
        }
        HashMap<String, String> dataFilesAssociation = null;
        R01MDocument copyDoc = this._cloneDocumentObjMembers(userCtx, srcDoc, dstDoc.getLanguage(), dstDoc.getInternalName());
        copyDoc.setOid(dstDoc.getOid());
        cont.getDocuments().put(dstDoc.getOid(), copyDoc);
        if (srcDoc.getDataFiles() != null && !srcDoc.getDataFiles().isEmpty()) {
            dataFilesAssociation = new HashMap<String, String>(srcDoc.getDataFiles().size());
            HashMap<String, R01MDataFile> copyOfDataFiles = new HashMap<String, R01MDataFile>(srcDoc.getDataFiles().size());
            for (Map.Entry meDataFile : srcDoc.getDataFiles().entrySet()) {
                R01MDataFile srcDataFile = (R01MDataFile)meDataFile.getValue();
                R01MDataFile copyDataFile = this._cloneDataFileObjMembers(userCtx, srcDataFile);
                String prewDFOid = null;
                try {
                    prewDFOid = R01MUtils.generateNewOid((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"content");
                }
                catch (GUIDDispenserException ex) {
                    throw new R01MContentModelException((Exception)((Object)ex));
                }
                copyDataFile.setOid(prewDFOid);
                copyOfDataFiles.put(prewDFOid, copyDataFile);
                dataFilesAssociation.put(srcDataFile.getOid(), prewDFOid);
            }
            copyDoc.setDataFiles(copyOfDataFiles);
            this._validateDocumentDataFiles(cont, copyDoc);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.contentManager").info("CONTENTMANAGER - COPYDOCUMENT(" + cont.getOid() + ":" + srcDoc.getOid() + " a " + dstDoc.getOid() + ")> Copia del modelo de objetos...\r\n\r\n\r\n");
        }
        copyDoc.setEmpty(false);
        try {
            resultTS = this._cmManager.doSaveContent(userCtx, cont);
        }
        catch (R01MSecurityException secEx) {
            R01FLog.to((String)"r01d.contentManager").severe("CONTENTMANAGER - COPYCONTENT(" + cont.getOid() + ")> Error al guardar el contenido ...\r\n\r\n\r\n");
            throw new R01MContentModelException("Error al guardar el contenido en la copia del documento de oid " + srcDoc.getOid() + " al documento " + copyDoc.getOid(), (Exception)((Object)secEx));
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.contentManager").info("\r\n\r\n\r\nCONTENTMANAGER - COPYCONTENT(" + cont.getOid() + ")> Copia de los errores de negocio del documento " + srcDoc.getOid() + "...");
        }
        try {
            R01MBusinessErrors businessErrorsDoc = this._cmManager.doLoadBusinessErrors(userCtx, srcDoc.getOid());
            if (businessErrorsDoc != null && businessErrorsDoc.getCategories() != null && !businessErrorsDoc.getCategories().isEmpty()) {
                businessErrorsDoc.setDocumentOid(copyDoc.getOid());
                this._cmManager.doSetBusinessErrors(userCtx, copyDoc.getOid(), businessErrorsDoc);
            }
        }
        catch (Exception ex) {
            R01FLog.to((String)"r01d.contentManager").severe("CONTENTMANAGER - COPYCONTENT(" + cont.getOid() + ")> Error al copiar los errores de negocio del documento ...\r\n\r\n\r\n");
            throw new R01MContentModelException("Error al copiar los errores de negocio del documento de oid " + srcDoc.getOid() + " al documento " + copyDoc.getOid(), ex);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.contentManager").info("\r\n\r\n\r\nCONTENTMANAGER - COPYCONTENT(" + cont.getOid() + ":" + srcDoc.getOid() + " a " + dstDoc.getOid() + ")> Copia de los ficheros...");
        }
        this._copyDocumentFiles(userCtx, cont, cont, srcDoc, copyDoc, dataFilesAssociation, copyAttachments);
        if (DEBUG) {
            R01FLog.to((String)"r01d.contentManager").info("CONTENTMANAGER - COPYCONTENT(" + cont.getOid() + ":" + srcDoc.getOid() + " a " + dstDoc.getOid() + ")> FIN Copia de los ficheros...\r\n\r\n\r\n");
        }
        LinkedList<R01MDocument> result = new LinkedList<R01MDocument>();
        result.add((R01MDocument)resultTS.get(cont.getOid()));
        result.add(copyDoc);
        return result;
    }

    public Object[] moveContentToAnotherArea(R01MUserContext userCtx, String contentOid, String newAreaOid, String newWorkAreaOid, boolean publishDocuments, int actionType, String contentNameTarget, String newDataRepositoryOid, String newServerOid) throws R01MSecurityException, R01MContentModelException, R01MDataStoreException {
        String msgRestore;
        R01MSaveContentResult contentResult;
        List defLabels;
        if (actionType == 0) {
            if (DEBUG) {
                R01FLog.to((String)"r01d.contentManager").info("CONTENTMANAGER - moveContentToAnotherArea: INICIO MOVER contenido " + contentOid + " al area " + newAreaOid + " y workArea " + newWorkAreaOid);
            }
        } else if (DEBUG) {
            R01FLog.to((String)"r01d.contentManager").info("CONTENTMANAGER - moveContentToAnotherArea: INICIO COPIAR contenido " + contentOid + " al area " + newAreaOid + " y workArea " + newWorkAreaOid);
        }
        HashMap<String, String> documentsAssociation = null;
        HashMap<String, String> dataFilesAssociation = null;
        HashMap documentDataFilesAssociation = null;
        R01MContent contentOld = this._cmManager.doLoadContent(userCtx, contentOid);
        R01MContent backupContent = (R01MContent)CloneUtils.cloneByReflection((Object)contentOld);
        R01MContentLocation oldLocation = (R01MContentLocation)CloneUtils.cloneByReflection((Object)contentOld.getStoreLocation());
        if (DEBUG) {
            R01FLog.to((String)"r01d.contentManager").info("CONTENTMANAGER - moveContentToAnotherArea: Crear nuevo contenido");
        }
        R01MContent content = null;
        if (actionType == 0) {
            content = contentOld;
            content.setStoreLocation(new R01MContentLocation(newServerOid, newDataRepositoryOid, newAreaOid, newWorkAreaOid));
        } else {
            if (StringUtils.isEmptyString((String)contentNameTarget) || contentNameTarget.length() > 30 || !R01MContentModelObjectsValidator.isValidName((String)contentNameTarget)) {
                throw new R01MContentModelException("El nombre de contenido " + contentNameTarget + " no es v\u00e1lido.");
            }
            content = this._cloneContentObjMembers(userCtx, contentOld, new R01MContentLocation(newServerOid, newDataRepositoryOid, newAreaOid, newWorkAreaOid), contentNameTarget);
            if (contentOld.getDocuments() != null && !contentOld.getDocuments().isEmpty()) {
                documentsAssociation = new HashMap<String, String>(contentOld.getDocuments().size());
                documentDataFilesAssociation = new HashMap(contentOld.getDocuments().size());
                HashMap<String, R01MDocument> copyOfDocuments = new HashMap<String, R01MDocument>(contentOld.getDocuments().size());
                for (Map.Entry meDocument : contentOld.getDocuments().entrySet()) {
                    R01MDocument srcDoc = (R01MDocument)meDocument.getValue();
                    R01MDocument copyDoc = this._cloneDocumentObjMembers(userCtx, srcDoc, srcDoc.getLanguage(), null);
                    copyOfDocuments.put(copyDoc.getOid(), copyDoc);
                    documentsAssociation.put(srcDoc.getOid(), copyDoc.getOid());
                    if (srcDoc.getDataFiles() == null || srcDoc.getDataFiles().isEmpty()) continue;
                    dataFilesAssociation = new HashMap<String, String>(srcDoc.getDataFiles().size());
                    HashMap<String, R01MDataFile> copyOfDataFiles = new HashMap<String, R01MDataFile>(srcDoc.getDataFiles().size());
                    for (Map.Entry meDataFile : srcDoc.getDataFiles().entrySet()) {
                        R01MDataFile srcDataFile = (R01MDataFile)meDataFile.getValue();
                        R01MDataFile copyDataFile = this._cloneDataFileObjMembers(userCtx, srcDataFile);
                        copyOfDataFiles.put(copyDataFile.getOid(), copyDataFile);
                        dataFilesAssociation.put(srcDataFile.getOid(), copyDataFile.getOid());
                    }
                    documentDataFilesAssociation.put(srcDoc.getOid(), dataFilesAssociation);
                    copyDoc.setDataFiles(copyOfDataFiles);
                }
                content.setDocuments(copyOfDocuments);
            }
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.contentManager").info("CONTENTMANAGER - moveContentToAnotherArea: Reset de URLs de archivos");
        }
        if (content.getDocuments() != null && !content.getDocuments().isEmpty()) {
            for (R01MDocument document : content.getDocuments().values()) {
                if (document.getDataFiles() == null || document.getDataFiles().isEmpty()) continue;
                for (R01MDataFile datafile : document.getDataFiles().values()) {
                    datafile.setEditUrl(null);
                    datafile.setGenerateUrl(null);
                    datafile.setPreviewUrl(null);
                    try {
                        R01MContentModelObjectsValidator.validateDataFile((R01MContent)content, (String)document.getOid(), (String)datafile.getOid());
                    }
                    catch (R01MContentModelObjectsValidatorException ex) {}
                }
            }
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.contentManager").info("CONTENTMANAGER - moveContentToAnotherArea: Recatalogar");
        }
        if ((defLabels = this._cmManager.doGetDefaultLabels(content.getStoreLocation(), content.getTypo())) != null && !defLabels.isEmpty()) {
            if (content.getLabels() != null && !content.getLabels().isEmpty()) {
                ArrayList<R01MStructureCatalog> auxLabels = new ArrayList<R01MStructureCatalog>();
                for (R01MStructureCatalog srcCat : defLabels) {
                    boolean bExists = false;
                    for (R01MStructureCatalog currLabel : content.getLabels()) {
                        if (!srcCat.getStructureOid().equals(currLabel.getStructureOid()) || !srcCat.getOid().equals(currLabel.getOid())) continue;
                        bExists = true;
                    }
                    if (bExists) continue;
                    auxLabels.add(srcCat);
                }
                if (!auxLabels.isEmpty()) {
                    defLabels.addAll(auxLabels);
                }
            }
            if (content.getLabels() != null && !content.getLabels().isEmpty()) {
                content.getLabels().addAll(defLabels);
            } else {
                content.setLabels(defLabels);
            }
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.contentManager").info("CONTENTMANAGER - moveContentToAnotherArea: Guardar el contenido");
        }
        try {
            contentResult = this._cmManager.doSaveContentReturningPlanTable(userCtx, content);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            if (actionType == 0) {
                msgRestore = "Rollback OK";
                try {
                    contentResult = this._cmManager.doSaveContentReturningPlanTable(userCtx, backupContent);
                }
                catch (Exception ex1) {
                    ex1.printStackTrace(System.err);
                    msgRestore = "Error al intentar restaurar el contenido " + ex1.getMessage();
                }
                throw new R01MContentModelException("Error al mover el contenido de oid " + content.getOid() + ".Error:" + ex.getMessage() + ".Se intenta hacer el rollback y el resultado es " + msgRestore, ex);
            }
            throw new R01MContentModelException("Error al copiar el contenido de oid " + contentOld.getOid() + ".Error:" + ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.contentManager").info("CONTENTMANAGER - moveContentToAnotherArea: Mover fisicamente lso archivos en el datastore (IW)");
        }
        if (actionType != 0) {
            try {
                if (contentOld.getDocuments() != null && !contentOld.getDocuments().isEmpty()) {
                    for (Map.Entry meDocument : contentOld.getDocuments().entrySet()) {
                        R01MDocument srcDoc = (R01MDocument)meDocument.getValue();
                        R01MDocument copyDoc = content.getDocument(documentsAssociation.get(srcDoc.getOid()).toString());
                        Map currDocDataFilesAssociation = (Map)documentDataFilesAssociation.get(srcDoc.getOid());
                        this._copyDocumentFiles(userCtx, contentOld, content, srcDoc, copyDoc, currDocDataFilesAssociation, true);
                    }
                }
                R01DContentInDataStore contentDataStoreSource = new R01DContentInDataStore(userCtx, contentOld);
                contentDataStoreSource.copyContent(content);
            }
            catch (Exception ex1) {
                ex1.printStackTrace(System.err);
                throw new R01MContentModelException("Error al copiar el contenido de oid " + contentOld.getOid() + ".Error:" + ex1.getMessage());
            }
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.contentManager").info("CONTENTMANAGER - moveContentToAnotherArea: MOVER FISICAMENTE LOS ARCHIVOS EN EL DATASTORE (IW)");
        }
        try {
            this.launchDataStoreAction(userCtx, 1, content, oldLocation, content.getStoreLocation(), contentOld.getName(), contentOld.getInternalName());
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            msgRestore = "Rollback OK";
            try {
                this._cmManager.doSaveContent(userCtx, backupContent);
            }
            catch (Exception ex1) {
                ex1.printStackTrace(System.err);
                msgRestore = "Error al intentar restaurar el contenido " + ex1.getMessage();
            }
            throw new R01MContentModelException("Error al guardar el contenido de oid " + content.getOid() + ".Error:" + ex.getMessage() + ".Se intenta hacer el rollback y el resultado es " + msgRestore, ex);
        }
        try {
            this.launchDataStoreAction(userCtx, 3, content, oldLocation, content.getStoreLocation(), contentOld.getName(), contentOld.getInternalName());
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            this.launchDataStoreAction(userCtx, 1, backupContent, content.getStoreLocation(), oldLocation, contentOld.getName(), contentOld.getInternalName());
            msgRestore = "Rollback OK";
            try {
                this._cmManager.doSaveContent(userCtx, backupContent);
            }
            catch (Exception ex1) {
                ex1.printStackTrace(System.err);
                msgRestore = "Error al intentar restaurar el contenido " + ex1.getMessage();
            }
            throw new R01MContentModelException("Error al guardar el contenido de oid " + content.getOid() + ".Error:" + ex.getMessage() + ".Se intenta hacer el rollback y el resultado es " + msgRestore, ex);
        }
        this.launchDataStoreAction(userCtx, 2, content, oldLocation, null, contentOld.getName(), contentOld.getInternalName());
        this.launchDataStoreAction(userCtx, 4, content, oldLocation, null, contentOld.getName(), contentOld.getInternalName());
        this.launchDataStoreAction(userCtx, 5, content, null, content.getStoreLocation(), contentOld.getName(), contentOld.getInternalName());
        this.launchDataStoreAction(userCtx, 6, content, null, content.getStoreLocation(), contentOld.getName(), contentOld.getInternalName());
        if (publishDocuments) {
            if (DEBUG) {
                R01FLog.to((String)"r01d.contentManager").info("CONTENTMANAGER - moveContentToAnotherArea: Republicar documentos publicados");
            }
            if (content.getDocuments() != null && !content.getDocuments().isEmpty()) {
                content = this._cmManager.doPublishAllDocuments(userCtx, content.getOid(), 0, null, true);
            }
        }
        if (actionType == 0) {
            if (DEBUG) {
                R01FLog.to((String)"r01d.contentManager").info("CONTENTMANAGER - moveContentToAnotherArea: FIN MOVER contenido " + contentOid + " al area " + newAreaOid + " y workArea " + newWorkAreaOid);
            }
        } else if (DEBUG) {
            R01FLog.to((String)"r01d.contentManager").info("CONTENTMANAGER - moveContentToAnotherArea: FIN COPIAR contenido " + contentOid + " al area " + newAreaOid + " y workArea " + newWorkAreaOid);
        }
        return new Object[]{content, contentResult};
    }

    private R01MContent _cloneContentObjMembers(R01MUserContext userCtx, R01MContent cont, R01MContentLocation newLoc, String newContentName) throws R01MContentModelException, R01MSecurityException {
        R01MContent contentClon = (R01MContent)CloneUtils.cloneByReflection((Object)cont);
        try {
            contentClon.setOid(R01MUtils.generateNewOid((String)R01MConstants.CONTENTMANAGER_APPCODE));
            contentClon.setName(newContentName);
            contentClon.setStoreLocation(newLoc);
            contentClon.setAuthor(userCtx.getUserName());
            contentClon.setCreateDate(R01MDateUtils.today());
            contentClon.setDocuments(null);
            R01MGeoPicks geolabels = contentClon.getGeoPicks();
            if (geolabels != null && !geolabels.getGeopicks().isEmpty()) {
                for (R01MGeoPick geoCatalog : geolabels.getGeopicks()) {
                    geoCatalog.setOid(R01MUtils.generateNewOid((String)R01MConstants.CONTENTMANAGER_APPCODE));
                }
            }
        }
        catch (GUIDDispenserException guidEx) {
            throw new R01MContentModelException("Error al obtener el oid del contenido copia: " + guidEx.getMessage(), (Exception)((Object)guidEx));
        }
        return contentClon;
    }

    private R01MDocument _cloneDocumentObjMembers(R01MUserContext userCtx, R01MDocument srcDoc, String newLang, String newInternalName) throws R01MContentModelException {
        R01MDocument copyOfDocument = (R01MDocument)CloneUtils.cloneByReflection((Object)srcDoc);
        try {
            String newDocumentOid = R01MUtils.generateNewOid((String)R01MConstants.CONTENTMANAGER_APPCODE);
            copyOfDocument.setOid(newDocumentOid);
            if (newLang != null) {
                copyOfDocument.setLanguage(newLang);
            }
            copyOfDocument.setUrlAliases(null);
            copyOfDocument.setAuthor(userCtx.getUserName());
            copyOfDocument.setCreateDate(R01MDateUtils.today());
            copyOfDocument.setRevisionState(new R01MDocumentRevisionState());
            copyOfDocument.setPublicationInfo(null);
            copyOfDocument.setRequestedPublications(null);
            copyOfDocument.setDataFiles(null);
            copyOfDocument.setBase(false);
            if (newInternalName != null) {
                copyOfDocument.setInternalName(newInternalName);
            }
        }
        catch (GUIDDispenserException guidEx) {
            throw new R01MContentModelException("Error al obtener el oid del documento copia: " + guidEx.getMessage(), (Exception)((Object)guidEx));
        }
        return copyOfDocument;
    }

    private R01MDataFile _cloneDataFileObjMembers(R01MUserContext userCtx, R01MDataFile srcDataFile) throws R01MContentModelException {
        R01MDataFile copyOfDataFile = (R01MDataFile)CloneUtils.cloneByReflection((Object)srcDataFile);
        try {
            String newDataFileOid = R01MUtils.generateNewOid((String)R01MConstants.CONTENTMANAGER_APPCODE);
            copyOfDataFile.setOid(newDataFileOid);
            copyOfDataFile.setCreateDate(R01MDateUtils.today());
            copyOfDataFile.setAuthor(userCtx.getUserName());
            copyOfDataFile.setEditUrl(null);
            copyOfDataFile.setPreviewUrl(null);
            copyOfDataFile.setGenerateUrl(null);
        }
        catch (GUIDDispenserException guidEx) {
            throw new R01MContentModelException("Error al obtener el oid del documento copia: " + guidEx.getMessage(), (Exception)((Object)guidEx));
        }
        return copyOfDataFile;
    }

    private void _validateDocumentDataFiles(R01MContent cont, R01MDocument doc) throws R01MContentModelException {
        if (doc.getDataFiles() != null) {
            for (Map.Entry meDataFile : doc.getDataFiles().entrySet()) {
                R01MDataFile currDataFile = (R01MDataFile)meDataFile.getValue();
                try {
                    R01MContentModelObjectsValidator.validateDataFile((R01MContent)cont, (String)doc.getOid(), (String)currDataFile.getOid());
                }
                catch (R01MContentModelObjectsValidatorException validEx) {
                    throw new R01MContentModelException("El archivo " + currDataFile.getOid() + " NO es valido (algun dato no es correcto).\n\t Detalle: " + validEx.getMessage());
                }
            }
        }
    }

    private void _copyDocumentFiles(R01MUserContext userCtx, R01MContent srcContent, R01MContent copyContent, R01MDocument srcDoc, R01MDocument copyDoc, Map dataFilesAssociation, boolean copyAttachments) throws R01MDataStoreException {
        Map srcDataFiles = srcDoc.getDataFiles();
        if (srcDataFiles != null && !srcDataFiles.isEmpty()) {
            R01DContentInDataStore srcContInDataStore = new R01DContentInDataStore(userCtx, srcContent);
            R01DContentInDataStore targetContInDataStore = new R01DContentInDataStore(userCtx, copyContent);
            if (copyAttachments) {
                srcContInDataStore.copyDocument(copyContent, srcDoc.getOid(), copyDoc.getOid());
            }
            for (Map.Entry meDataFile : srcDataFiles.entrySet()) {
                R01MDataFile srcDataFile = (R01MDataFile)meDataFile.getValue();
                try {
                    InputStream srcDataFileIS = srcContInDataStore.downloadDataFile(srcDoc.getOid(), srcDataFile.getOid());
                    String copyDataFileOid = dataFilesAssociation.get(srcDataFile.getOid()).toString();
                    String dataFileCopy = R01MDataFileXMLUtils.changeDCRNameInXML((InputStream)srcDataFileIS, (String)(srcDoc.getLanguage() + "_" + copyDataFileOid));
                    targetContInDataStore.uploadDataFile(copyDoc.getOid(), copyDataFileOid, (InputStream)new ByteArrayInputStream(dataFileCopy.getBytes()));
                    if (!COPY_DATAFILES_TO_DOCUMENTFOLDER) continue;
                    targetContInDataStore.copyDataFileFromSystemAreaToDocumentFolder(copyDoc.getOid(), copyDataFileOid);
                }
                catch (R01MDataStoreException dstExc) {
                    throw new R01MDataStoreException("Error al crear una copia de los dataFiles f\u00edsicos del Gestor de Contenidos del documento de oid " + srcDoc.getOid() + ": " + dstExc.getMessage(), (Exception)((Object)dstExc));
                }
            }
        }
    }

    private void launchDataStoreAction(R01MUserContext userCtx, int type, R01MContent content, R01MContentLocation oldLocation, R01MContentLocation newLocation, String contentSourceName, String contentSourceInternalName) throws R01MSecurityException, R01MDataStoreException {
        R01MRawDataAPI rawDataAPI = R01MClientFactory.getRawDataAPI((R01MUserContext)userCtx);
        String waSourcePath = "unknown";
        String contentWARelPath = "unknown";
        if (oldLocation != null) {
            waSourcePath = R01MPathHelpper.getLocationPath((R01MBaseLocationObject)oldLocation);
            contentWARelPath = R01MPathHelpper.getContentWorkAreaRelativePath((R01MContentTypologyInfo)content.getTypo(), (R01MBaseLocationObject)oldLocation, (String)content.getOid(), (String)contentSourceInternalName, (String)contentSourceName);
        }
        String waTargetPath = "unknown";
        if (newLocation != null) {
            waTargetPath = R01MPathHelpper.getLocationPath((R01MBaseLocationObject)newLocation);
        }
        switch (type) {
            case 1: {
                R01MDataStoreItem[] items = rawDataAPI.getFolderContents(waSourcePath, contentWARelPath, true);
                if (items == null || items.length <= 0) break;
                String[] filePaths = new String[items.length];
                for (int i = 0; i < items.length; ++i) {
                    filePaths[i] = items[i].getWorkAreaRelativePath();
                }
                rawDataAPI.moveFolderToAnotherWorkArea(waSourcePath, R01MPathHelpper.getLocationPath((R01MBaseLocationObject)newLocation), filePaths);
                break;
            }
            case 2: {
                rawDataAPI.deleteFolder(waSourcePath, contentWARelPath, true);
                break;
            }
            case 3: {
                ArrayList<String> filesWARelPath = new ArrayList<String>();
                if (content.getDocuments() != null && !content.getDocuments().isEmpty()) {
                    for (R01MDocument document : content.getDocuments().values()) {
                        if (document.getDataFiles() == null || document.getDataFiles().isEmpty()) continue;
                        for (R01MDataFile datafile : document.getDataFiles().values()) {
                            filesWARelPath.add(R01MPathHelpper.getDataFileWorkAreaRelativePath((R01MContentTypologyInfo)content.getTypo(), (R01MBaseLocationObject)oldLocation, (String)content.getOid(), (String)contentSourceInternalName, (String)contentSourceName, (String)document.getOid(), (String)document.getLanguage(), (String)document.getInternalName(), (String)datafile.getOid(), (String)datafile.getInternalName(), (String)datafile.getName(), (String)datafile.getTemplateOid()));
                        }
                    }
                }
                if (filesWARelPath.isEmpty()) break;
                String dataFolderWARelPath = ((String)filesWARelPath.get(0)).substring(0, ((String)filesWARelPath.get(0)).lastIndexOf("/"));
                String[] filesWARelativePath = new String[filesWARelPath.size()];
                int i = 0;
                Iterator itFilesPath = filesWARelPath.iterator();
                while (itFilesPath.hasNext()) {
                    filesWARelativePath[i] = (String)itFilesPath.next();
                    ++i;
                }
                rawDataAPI.copyFiles(waSourcePath, dataFolderWARelPath, R01MPathHelpper.getLocationPath((R01MBaseLocationObject)newLocation), dataFolderWARelPath, filesWARelativePath);
                break;
            }
            case 4: {
                if (content.getDocuments() == null || content.getDocuments().isEmpty()) break;
                for (R01MDocument document : content.getDocuments().values()) {
                    if (document.getDataFiles() == null || document.getDataFiles().isEmpty()) continue;
                    for (R01MDataFile datafile : document.getDataFiles().values()) {
                        String datafileWARelPath = R01MPathHelpper.getDataFileWorkAreaRelativePath((R01MContentTypologyInfo)content.getTypo(), (R01MBaseLocationObject)oldLocation, (String)content.getOid(), (String)contentSourceInternalName, (String)contentSourceName, (String)document.getOid(), (String)document.getLanguage(), (String)document.getInternalName(), (String)datafile.getOid(), (String)datafile.getInternalName(), (String)datafile.getName(), (String)datafile.getTemplateOid());
                        rawDataAPI.deleteFile(waSourcePath, datafileWARelPath, true);
                    }
                }
                break;
            }
            case 5: {
                if (content.getDocuments() == null || content.getDocuments().isEmpty()) break;
                for (R01MDocument document : content.getDocuments().values()) {
                    String documentWARelPath = R01MPathHelpper.getDocumentWorkAreaRelativePath((R01MContentTypologyInfo)content.getTypo(), (R01MBaseLocationObject)content.getStoreLocation(), (String)content.getOid(), (String)content.getInternalName(), (String)content.getName(), (String)document.getOid(), (String)document.getLanguage(), (String)document.getInternalName());
                    rawDataAPI.submmitFolder(waTargetPath, documentWARelPath);
                }
                break;
            }
            case 6: {
                if (content.getDocuments() == null || content.getDocuments().isEmpty()) break;
                for (R01MDocument document : content.getDocuments().values()) {
                    if (document.getDataFiles() == null || document.getDataFiles().isEmpty()) continue;
                    for (R01MDataFile datafile : document.getDataFiles().values()) {
                        String datafileWARelPath = R01MPathHelpper.getDataFileWorkAreaRelativePath((R01MContentTypologyInfo)content.getTypo(), (R01MBaseLocationObject)content.getStoreLocation(), (String)content.getOid(), (String)content.getInternalName(), (String)content.getName(), (String)document.getOid(), (String)document.getLanguage(), (String)document.getInternalName(), (String)datafile.getOid(), (String)datafile.getInternalName(), (String)datafile.getName(), (String)datafile.getTemplateOid());
                        rawDataAPI.submmitFile(waTargetPath, datafileWARelPath);
                    }
                }
                break;
            }
            default: {
                throw new R01MDataStoreException("Tipo de operaci\u00f3n = " + type + " no v\u00e1lida..........");
            }
        }
    }
}

