/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services.helpers;

import com.ejie.r01d.datastore.R01DContentInDataStore;
import com.ejie.r01f.file.ResourcesLoader;
import com.ejie.r01f.jvt.JVTComparator;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.config.objects.typologymanagement.R01MContentTypeTemplateConfig;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MDataFile;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class R01DContentModelInDataStoreHelper {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01d.manager").intValue() != Level.OFF.intValue();
    private static transient Map _dcrDataContent = null;
    private R01MUserContext _userCtx;
    private R01DContentInDataStore _contentInDataStore;

    private R01DContentModelInDataStoreHelper() {
    }

    public R01DContentModelInDataStoreHelper(R01MUserContext userCtx, R01MContent content) {
        this._userCtx = userCtx;
        this._contentInDataStore = new R01DContentInDataStore(userCtx, content);
    }

    public void processOperations(List planTable) throws R01MDataStoreException {
        if (planTable == null || planTable.size() == 0) {
            return;
        }
        R01MContent cont = this._contentInDataStore.getContent();
        for (JVTComparator.PlanTableOperation operation : planTable) {
            R01MDataFile df;
            R01MDocument doc;
            Object obj = null;
            Object objParent = null;
            if (operation.args.length == 1) {
                obj = operation.args[0];
            } else {
                obj = operation.args[1];
                objParent = operation.args[0];
            }
            if (obj instanceof R01MContent && operation.operation == 1) {
                if (DEBUG) {
                    R01FLog.to((String)"r01d.manager").info("\t...crear estructura de carpetas para el contenido " + cont.getName() + " (" + cont.getTypo().composeMemoCode() + ") en el storage del Gestor de Contenidos (IW) ....");
                }
                this._contentInDataStore.create();
                continue;
            }
            if (obj instanceof R01MDocument && operation.operation == 5) {
                doc = (R01MDocument)obj;
                if (DEBUG) {
                    R01FLog.to((String)"r01d.manager").info("\t...crear estructura de carpetas para el documento " + doc.getInternalName() + "-" + doc.getLanguage() + " del contenido " + cont.getName() + " (" + cont.getTypo().composeMemoCode() + ") en el storage del Gestor de Contenidos (IW) ....");
                }
                this._contentInDataStore.createDocument(doc.getOid());
                continue;
            }
            if (obj instanceof R01MDataFile && operation.operation == 5) {
                doc = (R01MDocument)objParent;
                df = (R01MDataFile)obj;
                boolean dfExists = this._contentInDataStore.existsDataFile(doc.getOid(), df.getOid());
                if (dfExists) {
                    if (!DEBUG) continue;
                    R01FLog.to((String)"r01d.manager").info("\t...ya existe el dcr para el dataFile " + df.getName() + " en el documento " + doc.getInternalName() + "-" + doc.getLanguage() + " del contenido " + cont.getName() + " (" + cont.getTypo().composeMemoCode() + ") en el storage del Gestor de Contenidos (IW) .... NO se crea uno vacio");
                    continue;
                }
                if (DEBUG) {
                    R01FLog.to((String)"r01d.manager").info("\t...crear dcr vacio para el dataFile " + df.getName() + " en el documento " + doc.getInternalName() + "-" + doc.getLanguage() + " del contenido " + cont.getName() + " (" + cont.getTypo().composeMemoCode() + ") en el storage del Gestor de Contenidos (IW) ....");
                }
                R01MContentTypeTemplateConfig templateCfg = null;
                try {
                    templateCfg = R01MClientFactory.getTypologyManagementConfigAPI().getTemplateConfig(cont.getStoreLocation(), cont.getTypo(), df.getTemplateOid());
                }
                catch (R01MConfigLoadException cfgLoadEx) {
                    R01FLog.to((String)"r01d.manager").severe("NO se ha podido obtener la configuracion de la plantilla " + df.getTemplateOid());
                    cfgLoadEx.printStackTrace(System.out);
                }
                this._contentInDataStore.uploadDataFile(doc.getOid(), df.getOid(), R01DContentModelInDataStoreHelper.obtainDataFileTemplate(doc.getLanguage() + "_" + df.getOid(), templateCfg));
                continue;
            }
            if (obj instanceof R01MContent && operation.operation == 2) {
                if (DEBUG) {
                    R01FLog.to((String)"r01d.manager").info("\t...borrar estructura de carpetas para el contenido " + cont.getName() + " (" + cont.getTypo().composeMemoCode() + ") en el storage del Gestor de Contenidos (IW) ....");
                }
                this._contentInDataStore.delete();
                continue;
            }
            if (obj instanceof R01MDocument && operation.operation == 6) {
                doc = (R01MDocument)obj;
                if (DEBUG) {
                    R01FLog.to((String)"r01d.manager").info("\t...borrar estructura de carpetas para el documento " + doc.getInternalName() + "-" + doc.getLanguage() + " del contenido " + cont.getName() + " (" + cont.getTypo().composeMemoCode() + ") en el storage del Gestor de Contenidos (IW) ....");
                }
                this._contentInDataStore.deleteDocument(doc.getOid(), true);
                continue;
            }
            if (!(obj instanceof R01MDataFile) || operation.operation != 6) continue;
            doc = (R01MDocument)objParent;
            df = (R01MDataFile)obj;
            if (DEBUG) {
                R01FLog.to((String)"r01d.manager").info("\t...borrar DCR (y su copia a nivel de documento), as\u00ed como archivos generados para el dataFile " + df.getName() + " en el documento " + doc.getInternalName() + "-" + doc.getLanguage() + " del contenido " + cont.getName() + " (" + cont.getTypo().composeMemoCode() + ") en el storage del Gestor de Contenidos (IW) ....");
            }
            this._contentInDataStore.deleteDataFile(doc.getOid(), df.getOid(), true);
        }
    }

    public void updateContentDescriptor(String descriptorXML) throws R01MDataStoreException {
        this._contentInDataStore.updateContentDescriptor(descriptorXML);
    }

    public void updateDocumentDescriptor(R01MDocument document) throws R01MDataStoreException {
        this._contentInDataStore.updateDocumentDescriptor(document);
    }

    public static InputStream obtainDataFileTemplate(String datafileName, R01MContentTypeTemplateConfig templateCfg) throws R01MDataStoreException {
        String theDCRDataContent;
        String templateType;
        String string = templateCfg == null ? "default" : (templateType = templateCfg.getType() != null ? templateCfg.getType() : "default");
        if (_dcrDataContent == null || _dcrDataContent.get(templateType) == null) {
            String archiveName = XMLProperties.getString((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"contentServices/newDCRArchive", (String)"r01dNewDCR_default.xml");
            archiveName = StringUtils.replaceString((String)archiveName, (String)"$templateType$", (String)templateType);
            try {
                String newDcrDataContent = StringUtils.loadFromStream((InputStream)ResourcesLoader.getResourceFileAsStream((String)archiveName));
                if (DEBUG) {
                    R01FLog.to((String)"r01d.manager").info(newDcrDataContent);
                }
                if (_dcrDataContent == null) {
                    _dcrDataContent = new HashMap();
                }
                _dcrDataContent.put(templateType, newDcrDataContent);
            }
            catch (IOException ioEx) {
                R01FLog.to((String)"r01d.contentmanagerBMP").severe("DATAFILE BMP > No se encuentra el fichero con la plantilla de un DCR: " + archiveName);
                throw new R01MDataStoreException("No se encuentra el archivo XML para la creaci\u00f3n de archivo de datos en la ruta " + archiveName + ": " + ioEx.getMessage(), (Exception)ioEx);
            }
        }
        if ((theDCRDataContent = (String)_dcrDataContent.get(templateType)) != null) {
            HashMap<String, String> values = new HashMap<String, String>(2);
            values.put("templateName", templateCfg != null ? templateCfg.getOid() : "");
            values.put("datafileName", datafileName);
            return new ByteArrayInputStream(StringUtils.replaceVariableValues((String)theDCRDataContent, (String)"$", values).getBytes());
        }
        throw new R01MDataStoreException("NO se ha podido obtener una plantilla para un DCR de tipo " + templateType);
    }
}

